/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.controls.StatusBar;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.codecoach.CCArb;
import oracle.jdevimpl.runner.codecoach.CCConfiguration;
import oracle.jdevimpl.runner.codecoach.CCResultPage;
import oracle.jdevimpl.runner.codecoach.CCResults;

final class CCProcess
extends JRunProcess {
    private int localport;
    private Thread getCCMessagesThread;
    private LogPage advicesLogPage;
    private Workspace workspace;
    private Project project;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;

    CCProcess() {
    }

    public boolean canRun(String string, Object object, Node node, List list) {
        if ("Java".equals(string)) {
            return this.canRunJava(node, list);
        }
        if ("Database".equals(string)) {
            list.add(CCArb.format(95, node.getShortLabel()));
            return false;
        }
        if ("XSLT".equals(string)) {
            list.add(CCArb.format(96, node.getShortLabel()));
            return false;
        }
        if ("XQuery".equals(string)) {
            list.add(CCArb.format(97, node.getShortLabel()));
            return false;
        }
        return false;
    }

    private boolean canRunJava(Node node, List list) {
        JDK jDK = this.getJdkDefinition();
        if (this.runConfiguration.usingOJVM(jDK)) {
            return true;
        }
        list.add(CCArb.format(98, node.getShortLabel()));
        return false;
    }

    public Object getValue(String string, Object object, String string2) {
        if ("Java".equals(string) && "FirstJavaCommandOptions".equals(string2)) {
            return this.getFirstJavaCommandOptions();
        }
        return null;
    }

    private String[] getFirstJavaCommandOptions() {
        Project project = this.getProject();
        CCConfiguration cCConfiguration = CCConfiguration.getInstance((PropertyStorage)project);
        String string = "-X5codecoach -Xcc:new -Xcc:port:" + this.localport + " -Xcc:level:" + cCConfiguration.getLevel() + " -Xcc:disable:ALL";
        String string2 = cCConfiguration.getAdvices().trim();
        String string3 = cCConfiguration.getInclude().trim();
        String string4 = cCConfiguration.getExclude().trim();
        String string5 = string;
        if (!string2.equals("")) {
            string5 = string5 + " -Xcc:enable:" + string2;
        }
        if (!string3.equals("")) {
            string5 = string5 + " -Xcc:incl:" + string3;
        }
        if (!string4.equals("")) {
            string5 = string5 + " -Xcc:excl:" + string4;
        }
        return IdeUtil.convertStringToStringArray((String)string5);
    }

    public String getProcessLabelPrefix() {
        return CCArb.getString(22);
    }

    public Icon getIcon() {
        return CCArb.getIcon(23);
    }

    protected Class getStarterFactorySubClass() {
        return JStarterFactory.class;
    }

    protected boolean startTarget() {
        this.localport = Helpers.getLocalPort();
        if (super.startTarget()) {
            this.getCCMessagesThread = new 1();
            this.getCCMessagesThread.start();
            return true;
        }
        return false;
    }

    public void terminate() {
        if (this.starter != null && this.starter.canTerminateGracefully()) {
            this.starter.terminateGracefully();
            return;
        }
        try {
            this.outputStream.writeByte(40);
            this.outputStream.flush();
        }
        catch (Exception exception) {
            super.terminate();
        }
    }

    public void finished() {
        super.finished();
        try {
            this.getCCMessagesThread.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void connect() throws Exception {
        boolean bl = false;
        int n = 5;
        int n2 = 100;
        while (true) {
            try {
                Thread.sleep(n2);
                InetAddress inetAddress = InetAddress.getByName(null);
                Socket socket = new Socket(inetAddress, this.localport);
                socket.setTcpNoDelay(true);
                this.inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 32768));
                this.outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                return;
            }
            catch (Exception exception) {
                System.out.println(exception);
                if (n-- == 0) {
                    throw new Exception();
                }
                n2 *= 2;
                continue;
            }
            break;
        }
    }

    private void getCCMessages() {
        int n = 0;
        this.advicesLogPage = CCResultPage.makePage(this.context, this.getShortLabel() + CCArb.getString(38), CCArb.getString(28));
        this.advicesLogPage.clearAll();
        this.workspace = this.context.getWorkspace();
        this.project = this.context.getProject();
        StatusBar statusBar = Ide.getStatusBar();
        try {
            int n2;
            this.connect();
            CCResults cCResults = new CCResults(this.workspace, this.project);
            statusBar.setText(CCArb.getString(14));
            do {
                if ((n2 = this.inputStream.readUnsignedByte()) != 1) continue;
                try {
                    int n3 = this.inputStream.readInt();
                    if (n3 == 0) continue;
                    byte[] byArray = new byte[n3];
                    this.inputStream.readFully(byArray);
                    String string = new String(byArray, "UTF-8");
                    cCResults.addAdviceInResult(string);
                    if (++n % 50 != 0) continue;
                    statusBar.setText(n + " " + CCArb.getString(15));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (n2 != 0);
            this.outputStream.writeByte(6);
            this.outputStream.flush();
            statusBar.setText(n + " " + CCArb.getString(16));
            cCResults.finalizeResults();
            statusBar.setText(CCArb.getString(17));
            SwingUtilities.invokeLater(new EventRunner(cCResults));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void mav$getCCMessages(CCProcess cCProcess) {
        cCProcess.getCCMessages();
    }

    static LogPage ra$advicesLogPage(CCProcess cCProcess) {
        return cCProcess.advicesLogPage;
    }

    final class 1
    extends Thread {
        public void run() {
            CCProcess.mav$getCCMessages(CCProcess.this);
        }
    }

    class EventRunner
    implements Runnable {
        CCResults results;

        EventRunner(CCResults cCResults) {
            this.results = cCResults;
        }

        public void run() {
            if (this.results.isEmpty()) {
                CCProcess.ra$advicesLogPage(CCProcess.this).log((Object)CCArb.getString(86));
            } else {
                CCProcess.ra$advicesLogPage(CCProcess.this).log((Object)this.results);
            }
        }
    }
}

