/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.codecoach.CCAdvice;
import oracle.jdevimpl.runner.codecoach.CCAdviceGroup;
import oracle.jdevimpl.runner.codecoach.CCArb;
import oracle.jdevimpl.runner.codecoach.CCResults;
import oracle.jdevimpl.runner.profile.HTMLSaver;

public class CCResultPage
extends AbstractLogPage
implements ContextMenuListener,
Controller {
    protected static final String CCRESULT_PAGE_ID = "CCResultPage";
    private JScrollPane scrollPane;
    private JTree msgTree;
    private JTextArea textArea;
    private DefaultMutableTreeNode root;
    private Component currentView;
    private String tooltip;
    private static Hashtable pagesByName = new Hashtable(2);
    private boolean _haveResults;
    private static final int HTML_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"CodeCoachResultSaveToHTML");
    private static final int GOTO_SRC_CMD_ID = Ide.findOrCreateCmdID((String)"CodeCoachResultGotoSrc");
    private static final int FIX_IT_CMD_ID = Ide.findOrCreateCmdID((String)"CodeCoachResultFixIt");
    private static final int IGNORE_IT_CMD_ID = Ide.findOrCreateCmdID((String)"CodeCoachResultIgnoreIt");
    private static final int HIDE_IT_CMD_ID = Ide.findOrCreateCmdID((String)"CodeCoachResultHideIt");
    private static final int RESTORE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"CodeCoachResultRestoreAll");
    private ContextMenu resultContextMenu;
    private IdeAction actionHTMLSave;
    private IdeAction actionFindSrc;
    private IdeAction actionFixIt;
    private IdeAction actionIgnoreIt;
    private IdeAction actionHideIt;
    private IdeAction actionRestoreAll;
    private JMenuItem menuHTMLSave;
    private JMenuItem menuFindSrc;
    private JMenuItem menuFixIt;
    private JMenuItem menuIgnoreIt;
    private JMenuItem menuHideIt;
    private JMenuItem menuRestoreAll;
    private Context context;
    private CCResults res;
    private static final HelpInfo DEFAULT_HELP_TOPIC = new HelpInfo(CCArb.getString(1));

    public static CCResultPage makePage(Context context, String string, String string2) {
        CCResultPage cCResultPage = (CCResultPage)((Object)pagesByName.get(string));
        if (cCResultPage == null) {
            cCResultPage = new CCResultPage(string, string2);
        }
        cCResultPage.context = context;
        return cCResultPage;
    }

    public HelpInfo getHelpInfo() {
        TreePath[] treePathArray = this.getSelectedAdvices();
        if (treePathArray.length != 0) {
            return CCResultPage.advFromPath(treePathArray[0]).getHelpInfo();
        }
        return DEFAULT_HELP_TOPIC;
    }

    private IdeAction myGetAction(int n, String string) {
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string);
        int n2 = string.indexOf("&");
        if (n2 != -1) {
            ideAction.putValue("MnemonicKey", (Object)new Integer(string.charAt(n2 + 1)));
        }
        ideAction.addController((Controller)this);
        return ideAction;
    }

    private CCResultPage(String string, String string2) {
        super(new ViewId(CCRESULT_PAGE_ID, string));
        this.tooltip = string2;
        this.getGUI();
        pagesByName.put(string, this);
        this.actionHTMLSave = this.myGetAction(HTML_SAVE_CMD_ID, CCArb.getString(89));
        this.actionFindSrc = this.myGetAction(GOTO_SRC_CMD_ID, CCArb.getString(90));
        this.actionFixIt = this.myGetAction(FIX_IT_CMD_ID, CCArb.getString(91));
        this.actionIgnoreIt = this.myGetAction(IGNORE_IT_CMD_ID, CCArb.getString(92));
        this.actionHideIt = this.myGetAction(HIDE_IT_CMD_ID, CCArb.getString(93));
        this.actionRestoreAll = this.myGetAction(RESTORE_ALL_CMD_ID, CCArb.getString(94));
        this.resultContextMenu = LogManager.getLogManager().getContextMenu();
        this.resultContextMenu.addContextMenuListener((ContextMenuListener)this);
        this.menuHTMLSave = this.resultContextMenu.createMenuItem((ToggleAction)this.actionHTMLSave, JDeveloperMenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
        this.menuFindSrc = this.resultContextMenu.createMenuItem((ToggleAction)this.actionFindSrc, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
        this.menuFixIt = this.resultContextMenu.createMenuItem((ToggleAction)this.actionFixIt);
        this.menuIgnoreIt = this.resultContextMenu.createMenuItem((ToggleAction)this.actionIgnoreIt);
        this.menuHideIt = this.resultContextMenu.createMenuItem((ToggleAction)this.actionHideIt);
        this.menuRestoreAll = this.resultContextMenu.createMenuItem((ToggleAction)this.actionRestoreAll);
    }

    private static boolean advListFixable(TreePath[] treePathArray) {
        boolean bl = false;
        int n = 0;
        while (n < treePathArray.length) {
            CCAdvice cCAdvice = CCResultPage.advFromPath(treePathArray[n]);
            if (cCAdvice != null) {
                if (!cCAdvice.isFixable()) {
                    return false;
                }
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private static boolean advListIgnorable(TreePath[] treePathArray) {
        boolean bl = false;
        int n = 0;
        while (n < treePathArray.length) {
            CCAdvice cCAdvice = CCResultPage.advFromPath(treePathArray[n]);
            if (cCAdvice != null) {
                if (!cCAdvice.isIgnorable()) {
                    return false;
                }
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private static boolean advListHidable(TreePath[] treePathArray) {
        boolean bl = false;
        int n = 0;
        while (n < treePathArray.length) {
            CCAdvice cCAdvice = CCResultPage.advFromPath(treePathArray[n]);
            if (cCAdvice != null) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private static boolean advListFindable(TreePath[] treePathArray) {
        CCAdvice cCAdvice;
        if (treePathArray.length == 1 && (cCAdvice = CCResultPage.advFromPath(treePathArray[0])) != null) {
            return cCAdvice.isFindable();
        }
        return false;
    }

    public ContextMenu getContextMenu() {
        return this.resultContextMenu;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (contextMenu == null) {
            return;
        }
        Context context = contextMenu.getContext();
        if (context == null || context.getView() != this) {
            return;
        }
        TreePath[] treePathArray = this.getSelectedAdvices();
        contextMenu.add((Component)this.menuHTMLSave, JDeveloperMenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
        contextMenu.add((Component)this.menuRestoreAll, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        contextMenu.add((Component)this.menuHideIt, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        contextMenu.add((Component)this.menuIgnoreIt, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        contextMenu.add((Component)this.menuFixIt, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        contextMenu.add((Component)this.menuFindSrc, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        this.menuHTMLSave.setEnabled(this._haveResults);
        this.menuFindSrc.setEnabled(CCResultPage.advListFindable(treePathArray));
        this.menuFixIt.setEnabled(CCResultPage.advListFixable(treePathArray));
        this.menuIgnoreIt.setEnabled(CCResultPage.advListIgnorable(treePathArray));
        this.menuHideIt.setEnabled(CCResultPage.advListHidable(treePathArray));
        if (this.res != null) {
            this.menuRestoreAll.setEnabled(this.res.isAdvicesHidden());
        } else {
            this.menuRestoreAll.setEnabled(false);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void saveToHTML() {
        HTMLSaver hTMLSaver = new HTMLSaver(this.root);
        hTMLSaver.SaveToFile(this.getContext());
    }

    private Object getNextLeaf(int n) {
        int n2 = -1;
        if (this.msgTree.getSelectionPath() != null) {
            n2 = this.msgTree.getRowForPath(this.msgTree.getSelectionPath());
        }
        while ((n2 += n) >= 0 && n2 < this.msgTree.getRowCount()) {
            TreePath treePath = this.msgTree.getPathForRow(n2);
            Object object = treePath.getLastPathComponent();
            if (!this.msgTree.getModel().isLeaf(object)) continue;
            this.msgTree.setSelectionPath(treePath);
            return object;
        }
        return null;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 30 || n == 31) {
            Object object = this.getNextLeaf(n == 31 ? -1 : 1);
            if (object != null) {
                this.msgTree.scrollPathToVisible(this.msgTree.getSelectionPath());
                this.findSource();
            }
            return true;
        }
        if (n == HTML_SAVE_CMD_ID) {
            this.saveToHTML();
            return true;
        }
        if (n == GOTO_SRC_CMD_ID) {
            this.findSource();
            return true;
        }
        if (n == FIX_IT_CMD_ID) {
            this.fixIt();
            return true;
        }
        if (n == IGNORE_IT_CMD_ID) {
            this.ignoreIt();
            return true;
        }
        if (n == HIDE_IT_CMD_ID) {
            this.hideIt();
            return true;
        }
        if (n == RESTORE_ALL_CMD_ID) {
            this.showAll();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == HTML_SAVE_CMD_ID) {
            return true;
        }
        if (n == GOTO_SRC_CMD_ID) {
            return true;
        }
        if (n == FIX_IT_CMD_ID) {
            return true;
        }
        if (n == IGNORE_IT_CMD_ID) {
            return true;
        }
        if (n == HIDE_IT_CMD_ID) {
            return true;
        }
        if (n == RESTORE_ALL_CMD_ID) {
            return true;
        }
        if (n == 30 || n == 31) {
            ideAction.setEnabled(this.msgTree != null && this.msgTree.getRowCount() > 0);
            return true;
        }
        return false;
    }

    public Controller getController() {
        return this;
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            this.root = new DefaultMutableTreeNode("root");
            this.msgTree = new JTree(this.root);
            this.scrollPane = new JScrollPane(this.msgTree);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.currentView = this.msgTree;
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
        }
        return this.scrollPane;
    }

    private CCAdvice[] sortAdviceList(ArrayList arrayList) {
        CCAdvice[] cCAdviceArray = new CCAdvice[arrayList.size()];
        cCAdviceArray = arrayList.toArray(cCAdviceArray);
        Arrays.sort(cCAdviceArray, new 2());
        return cCAdviceArray;
    }

    public Context getContext(EventObject eventObject) {
        if (this.context == null) {
            this.context = Context.newIdeContext();
        }
        this.context.setEvent(eventObject);
        this.context.setView((View)this);
        return this.context;
    }

    private void findSource() {
        TreePath[] treePathArray = this.getSelectedAdvices();
        if (CCResultPage.advListFindable(treePathArray)) {
            CCResultPage.advFromPath(treePathArray[0]).showSource();
        }
    }

    private static CCAdvice advFromPath(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof CCAdvice) {
            return (CCAdvice)object;
        }
        return null;
    }

    private void removePath(TreePath treePath) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.msgTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        if (defaultMutableTreeNode2.getChildCount() == 0) {
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    private TreePath[] getSelectedAdvices() {
        int n;
        TreePath[] treePathArray = this.msgTree.getSelectionPaths();
        int n2 = 0;
        if (treePathArray != null) {
            n = 0;
            while (n < treePathArray.length) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                if (defaultMutableTreeNode != null && defaultMutableTreeNode.isLeaf()) {
                    ++n2;
                }
                ++n;
            }
        }
        TreePath[] treePathArray2 = new TreePath[n2];
        n2 = 0;
        if (treePathArray != null) {
            n = 0;
            while (n < treePathArray.length) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                if (defaultMutableTreeNode != null && defaultMutableTreeNode.isLeaf()) {
                    treePathArray2[n2++] = treePathArray[n];
                }
                ++n;
            }
        }
        return treePathArray2;
    }

    private void hideIt() {
        TreePath[] treePathArray = this.getSelectedAdvices();
        if (treePathArray.length != 0) {
            int n = 0;
            while (n < treePathArray.length) {
                CCResultPage.advFromPath(treePathArray[n]).hideIt();
                ++n;
            }
            this.clearAll();
            this.logMsg(this.res);
        }
    }

    private void fixIt() {
        TreePath[] treePathArray = this.getSelectedAdvices();
        if (!CCResultPage.advListFixable(treePathArray)) {
            return;
        }
        int n = 0;
        while (n < treePathArray.length) {
            CCAdvice cCAdvice = CCResultPage.advFromPath(treePathArray[n]);
            if (cCAdvice.fixIt()) {
                cCAdvice.removeIt();
                this.removePath(treePathArray[n]);
            }
            ++n;
        }
    }

    private void ignoreIt() {
        TreePath[] treePathArray = this.getSelectedAdvices();
        if (!CCResultPage.advListIgnorable(treePathArray)) {
            return;
        }
        int n = 0;
        while (n < treePathArray.length) {
            CCAdvice cCAdvice = CCResultPage.advFromPath(treePathArray[n]);
            if (cCAdvice.ignoreIt()) {
                cCAdvice.removeIt();
                this.removePath(treePathArray[n]);
            }
            ++n;
        }
    }

    private void showAll() {
        this.res.showAll();
        this.clearAll();
        this.logMsg(this.res);
    }

    private void logMsg(CCResults cCResults) {
        this._haveResults = true;
        this.res = cCResults;
        if (this.currentView != this.msgTree) {
            this.currentView = this.msgTree;
            this.scrollPane.setViewportView(this.currentView);
        }
        Iterator iterator = cCResults.iterator();
        while (iterator.hasNext()) {
            CCAdviceGroup cCAdviceGroup = (CCAdviceGroup)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(cCAdviceGroup);
            boolean bl = false;
            Iterator iterator2 = cCAdviceGroup.iterator();
            while (iterator2.hasNext()) {
                CCAdvice cCAdvice = (CCAdvice)iterator2.next();
                if (!cCAdvice.shouldShow()) continue;
                bl = true;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(cCAdvice));
            }
            if (!bl) continue;
            this.root.add(defaultMutableTreeNode);
        }
        this.msgTree.setRootVisible(false);
        this.msgTree.getSelectionModel().setSelectionMode(4);
        this.msgTree.updateUI();
        int n = 0;
        while (n < this.msgTree.getRowCount()) {
            this.msgTree.expandRow(n);
            ++n;
        }
        this.msgTree.addMouseListener(new 1());
    }

    private void logMsg(String string) {
        this._haveResults = false;
        if (this.currentView != this.textArea) {
            this.currentView = this.textArea;
            this.scrollPane.setViewportView(this.currentView);
        }
        this.textArea.append(string);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    protected void logMsg(Object object) {
        if (object instanceof CCResults) {
            this.logMsg((CCResults)object);
        } else if (object instanceof String) {
            this.logMsg((String)object);
        } else {
            this.logMsg(object.toString());
        }
    }

    public void clearAll() {
        this._haveResults = false;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.msgTree.getModel();
        while (defaultTreeModel.getChildCount(this.root) > 0) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultTreeModel.getChild(this.root, 0);
            defaultTreeModel.removeNodeFromParent(mutableTreeNode);
        }
        this.textArea.setText("");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.getGUI();
        this.textArea.addMouseListener(mouseListener);
        this.msgTree.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (this.scrollPane == null) {
            return;
        }
        this.msgTree.removeMouseListener(mouseListener);
        this.textArea.removeMouseListener(mouseListener);
    }

    static void mav$findSource(CCResultPage cCResultPage) {
        cCResultPage.findSource();
    }

    static JTree ra$msgTree(CCResultPage cCResultPage) {
        return cCResultPage.msgTree;
    }

    public final class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((CCAdvice)object).getLineNo() - ((CCAdvice)object2).getLineNo();
        }

        public boolean equals(Object object, Object object2) {
            return object == object2;
        }
    }

    public final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                CCResultPage.ra$msgTree(CCResultPage.this).requestFocus();
                Context context = CCResultPage.this.getContext(mouseEvent);
                CCResultPage.this.getContextMenu().show(context);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            CCResultPage.mav$findSource(CCResultPage.this);
        }
    }
}

