/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.runner.codecoach.CCAdvice;
import oracle.jdevimpl.runner.codecoach.CCAdviceGroup;
import oracle.jdevimpl.runner.codecoach.CCArb;
import oracle.jdevimpl.runner.codecoach.GroupComparator;

class CCResults {
    static final GroupComparator gcc = new GroupComparator();
    Workspace workspace;
    Project project;
    HashMap URLCache;
    HashMap advGroupsMap;
    ArrayList advGroupsList;
    BitSet advMask;

    CCResults(Workspace workspace, Project project) {
        this.workspace = workspace;
        this.project = project;
        this.URLCache = new HashMap(10);
        this.advGroupsMap = new HashMap(10);
        this.advMask = (BitSet)CCAdvice.allAdvices.clone();
    }

    void showAll() {
        this.advMask.or(CCAdvice.allAdvices);
    }

    boolean isAdvicesHidden() {
        return this.advMask.equals(CCAdvice.allAdvices) ^ true;
    }

    private URL expandSourceFile(String string, String string2) {
        String string3 = string + "@" + string2;
        URL uRL = (URL)this.URLCache.get(string3);
        if (uRL == null) {
            uRL = this.findSourceFile(string, string2);
            this.URLCache.put(string3, uRL);
        }
        return uRL;
    }

    JavaManager getJavaManager() {
        return JavaManager.getJavaManager(this.project);
    }

    private URL findSourceFile(String string, String string2) {
        String string3 = "";
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string3 = string.substring(0, n);
        }
        string3 = string3.replace('/', '.');
        return Source.findSourceFile(this.workspace, this.project, string3, string2);
    }

    boolean isEmpty() {
        return this.advGroupsList.isEmpty();
    }

    void addAdviceInResult(String string) {
        CCAdvice cCAdvice = new CCAdvice(string);
        URL uRL = null;
        int n = cCAdvice.getLineNo();
        if (n == 0) {
            return;
        }
        String string2 = n >= 0 ? ((uRL = this.expandSourceFile(cCAdvice.getClassName(), cCAdvice.getFileName())) == null ? CCArb.format(88, cCAdvice.getFileName()) : URLFileSystem.getPlatformPathName((URL)uRL)) : CCArb.getString(87);
        CCAdviceGroup cCAdviceGroup = (CCAdviceGroup)this.advGroupsMap.get(string2);
        if (cCAdviceGroup == null) {
            cCAdviceGroup = new CCAdviceGroup(this, string2, uRL);
            this.advGroupsMap.put(string2, cCAdviceGroup);
        }
        cCAdviceGroup.addAdviceToGroup(cCAdvice);
    }

    void finalizeResults() {
        Object[] objectArray = this.advGroupsMap.values().toArray();
        Arrays.sort(objectArray, gcc);
        this.advGroupsList = new ArrayList(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            CCAdviceGroup cCAdviceGroup = (CCAdviceGroup)objectArray[n];
            cCAdviceGroup.finalizeAdvices();
            this.advGroupsList.add(cCAdviceGroup);
            ++n;
        }
        this.advGroupsMap = null;
    }

    Iterator iterator() {
        return this.advGroupsList.iterator();
    }
}

