/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Runner;
import oracle.ide.util.ArrayResourceBundle;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.codecoach.CCArb;
import oracle.jdevimpl.runner.codecoach.CCConfigurationPanel;
import oracle.jdevimpl.runner.codecoach.CCProcess;

public class JCodeCoach
implements Addin,
Observer,
ContextMenuListener,
Controller {
    static IdeAction actionStart;
    static JMenuItem startMenu;
    private Project activeProject;
    private static final int CC_START_CMD_ID;

    static {
        CC_START_CMD_ID = Ide.findOrCreateCmdID((String)"CCStartCommand");
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == CC_START_CMD_ID) {
            this.startProcess();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == CC_START_CMD_ID) {
            String string;
            ideAction.setEnabled(this.canStartProcess());
            if (this.activeProject != null) {
                String string2 = this.activeProject.getShortLabel();
                string = CCArb.format(19, string2);
            } else {
                string = CCArb.getString(18);
            }
            ideAction.putValue("Name", (Object)string);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element element = context.getElement();
        if (element == null) {
            return;
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void activeProjectChanged() {
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        this.activeProject = Ide.getActiveProject();
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        1 var3_3 = new 1(this, updateMessage, object);
        if (SwingUtilities.isEventDispatchThread()) {
            var3_3.run();
        } else {
            SwingUtilities.invokeLater(var3_3);
        }
    }

    public void initialize() {
        Ide.getSystem().attach((Observer)this);
        this.createMenus();
        JCodeCoach.registerSettingsPanel();
    }

    private static void registerSettingsPanel() {
        Navigable navigable = new Navigable(CCArb.getString(29), CCConfigurationPanel.class);
        Runner.getRunner().addRunConfigurationToolNavigable(navigable);
    }

    private void createMenus() {
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"Run");
        String string = jMenu.getText();
        actionStart = IdeAction.get((int)CC_START_CMD_ID, null, (String)CCArb.getString(18), (String)string, (Integer)CCArb.getInteger(20), (ArrayResourceBundle)CCArb.getInstance(), (int)21, null, (boolean)false);
        actionStart.addController((Controller)this);
        actionStart.putValue("NoCtxName", (Object)CCArb.getString(18));
        startMenu = menubar.createMenuItem((ToggleAction)actionStart, JDeveloperMenuConstants.WEIGHT_RUN_CODECOACH);
        menubar.add((Component)startMenu, jMenu, JDeveloperMenuConstants.SECTION_RUN_CODECOACH);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/codecoach/accelerators.xml");
    }

    private void updateStartMenu() {
        Context context = Ide.getMainWindow().getLastActiveView().getContext();
        this.update(actionStart, context);
    }

    private boolean canStartProcess() {
        Project project = Ide.getActiveProject();
        if (Ide.getActiveWorkspace() != null && project != null && project.isOpen()) {
            RunConfiguration runConfiguration = RunConfiguration.getInstance((PropertyStorage)project);
            JDK jDK = Helpers.getActiveJdkDefinition(project);
            return runConfiguration.usingOJVM(jDK);
        }
        return false;
    }

    private void startProcess() {
        if (Ide.getActiveWorkspace() != null && Ide.getActiveProject() != null) {
            CCProcess cCProcess = new CCProcess();
            cCProcess.start();
        }
    }

    static void mav$activeProjectChanged(JCodeCoach jCodeCoach) {
        jCodeCoach.activeProjectChanged();
    }

    static void mav$updateStartMenu(JCodeCoach jCodeCoach) {
        jCodeCoach.updateStartMenu();
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ UpdateMessage v$change;
        private final /* synthetic */ Object v$observed;
        final /* synthetic */ JCodeCoach this$0;

        public void run() {
            int n = this.v$change.getMessageID();
            if (this.v$observed == Ide.getSystem()) {
                if (n == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    JCodeCoach.mav$activeProjectChanged(this.this$0);
                    JCodeCoach.mav$updateStartMenu(this.this$0);
                }
            } else if (this.v$observed instanceof Project && n == UpdateMessage.PROPERTY_SET) {
                JCodeCoach.mav$updateStartMenu(this.this$0);
            }
        }

        public 1(JCodeCoach jCodeCoach, UpdateMessage updateMessage, Object object) {
            this.v$observed = object;
            this.v$change = updateMessage;
            this.this$0 = jCodeCoach;
        }
    }
}

