/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeProfile;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasDataInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ProfilingEvents;

abstract class BaseEvaluator {
    protected DebugContext debugContext;
    private Map cachedSimple;
    private static final Object cachedSimpleNull = Boolean.FALSE;

    BaseEvaluator(DebugContext debugContext) {
        this.debugContext = debugContext;
        this.cachedSimple = new HashMap();
    }

    void clearCache() {
        this.cachedSimple.clear();
    }

    abstract int evaluateConditionResult(Object var1);

    abstract Object evaluate(String var1);

    protected Object evaluateSimple(String string) {
        Object object = null;
        int n = -1;
        do {
            String string2;
            if ((object = (Object)this.cachedSimple.get(string2 = (n = string.indexOf(46, n + 1)) != -1 ? string.substring(0, n) : string)) == null) {
                object = this.evaluateSimpleInternal(string2);
                if (object != null) {
                    this.cachedSimple.put(string2, object);
                    continue;
                }
                this.cachedSimple.put(string2, cachedSimpleNull);
                continue;
            }
            if (object != cachedSimpleNull) continue;
            object = null;
        } while (object == null && n != -1);
        if (object != null && n != -1) {
            if (object instanceof DebugVariableInfo) {
                object = ((DebugVariableInfo)object).getDataInfo();
            } else if (object instanceof DebugFieldInfo) {
                object = ((DebugFieldInfo)object).getDataInfo();
            }
            object = this.partialMatch(string, n, string.length(), object);
        }
        return object;
    }

    protected Object evaluateSimpleInternal(String string) {
        Object object = null;
        if (!this.debugContext.variables.isEmpty() && (object = (Object)this.debugContext.variables.get(string)) != null) {
            return object;
        }
        if (this.debugContext.dataObject != null) {
            if (string.equals("this")) {
                return this.debugContext.dataObject;
            }
            object = this.checkThisFields(this.debugContext.dataObject, string);
            if (object != null) {
                return object;
            }
        }
        DebugVariableInfo[] debugVariableInfoArray = null;
        if (this.debugContext.frame != null) {
            DebugVariableInfo[] debugVariableInfoArray2 = this.debugContext.frame.listLocals();
            object = this.checkVars(string, debugVariableInfoArray2, true);
            if (object != null) {
                return object;
            }
            debugVariableInfoArray = this.debugContext.frame.listArguments();
            object = this.checkVars(string, debugVariableInfoArray, false);
            if (object != null) {
                return object;
            }
            DebugVariableInfo debugVariableInfo = BaseEvaluator.findThis(debugVariableInfoArray);
            if (debugVariableInfo != null) {
                object = this.checkThisFields(debugVariableInfo.getDataInfo(), string);
                if (object != null) {
                    return object;
                }
            } else {
                DebugClassInfo debugClassInfo = this.debugContext.frame.getLocation().getClassInfo();
                if (debugClassInfo != null) {
                    DebugFieldInfo[] debugFieldInfoArray = debugClassInfo.getStaticFields(-1);
                    object = this.checkFields(string, debugFieldInfoArray);
                    if (object != null) {
                        return object;
                    }
                    debugFieldInfoArray = new DebugFieldInfo[]{debugClassInfo.getStaticField(string)};
                    if (debugFieldInfoArray[0] != null && (object = this.checkFields(string, debugFieldInfoArray)) != null) {
                        return object;
                    }
                    String string2 = debugClassInfo.getName();
                    if (string2.startsWith("$Oracle.PackageBody.")) {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(string2);
                        int n = 0;
                        while (n < 4) {
                            fastStringBuffer.removeCharAt(15);
                            ++n;
                        }
                        String string3 = fastStringBuffer.toString();
                        DebugClassInfo debugClassInfo2 = this.debugContext.vm.findFirstClassByName(string3);
                        if (debugClassInfo2 != null) {
                            debugFieldInfoArray = debugClassInfo2.getStaticFields(-1);
                            object = this.checkFields(string, debugFieldInfoArray);
                            if (object != null) {
                                return object;
                            }
                            debugFieldInfoArray = new DebugFieldInfo[]{debugClassInfo2.getStaticField(string)};
                            if (debugFieldInfoArray[0] != null && (object = this.checkFields(string, debugFieldInfoArray)) != null) {
                                return object;
                            }
                        }
                    }
                }
            }
            if ((object = this.checkVars(string, debugVariableInfoArray2, false)) != null) {
                return object;
            }
            object = this.debugContext.frame.getVariable(string);
            if (object != null) {
                return object;
            }
        }
        if (this.debugContext.vm != null) {
            object = this.checkClasses(string);
            if (object != null) {
                return object;
            }
            if (this.debugContext.thread != null && this.debugContext.frame != null && this.debugContext.frame.getFrameNumber() == 0) {
                DebugVariableInfo debugVariableInfo;
                DebugVariableInfo debugVariableInfo2;
                if (this.debugContext.thread.equals(this.debugContext.vm.getCurrentThread())) {
                    DebugDataInfo debugDataInfo;
                    DebugDataObjectInfo debugDataObjectInfo;
                    if (string.equals(BaseEvaluator.getThrowExpressionPart()) && (debugDataObjectInfo = this.debugContext.vm.getCurrentThrow()) != null) {
                        return debugDataObjectInfo;
                    }
                    if (string.equals(BaseEvaluator.getWatchpointObjectExpressionPart())) {
                        DebugDataObjectInfo debugDataObjectInfo2 = this.debugContext.vm.getWatchpointObject();
                        if (debugDataObjectInfo2 != null) {
                            return debugDataObjectInfo2;
                        }
                    } else if (string.equals(BaseEvaluator.getWatchpointFieldExpressionPart())) {
                        DebugFieldInfo debugFieldInfo = this.debugContext.vm.getWatchpointField();
                        if (debugFieldInfo != null) {
                            return debugFieldInfo;
                        }
                    } else if (string.equals(BaseEvaluator.getWatchpointFieldFutureValueExpressionPart()) && (debugDataInfo = this.debugContext.vm.getWatchpointFieldFutureValue()) != null) {
                        return debugDataInfo;
                    }
                }
                if (string.equals(BaseEvaluator.getReturnedExpressionPart()) && (debugVariableInfo2 = this.debugContext.thread.getReturnedValue()) != null) {
                    return debugVariableInfo2;
                }
                if (string.equals(BaseEvaluator.getReturnExpressionPart()) && (debugVariableInfo = this.debugContext.thread.getReturnValue()) != null) {
                    return debugVariableInfo;
                }
            }
            if (this.debugContext.frame != null) {
                String string4 = BaseEvaluator.getSlotExpressionPartPrefix();
                if (string.startsWith(string4)) {
                    try {
                        String string5 = string.substring(string4.length());
                        int n = Integer.parseInt(string5.toString());
                        if (n < debugVariableInfoArray.length) {
                            DebugVariableInfo debugVariableInfo;
                            DebugVariableInfo debugVariableInfo3 = debugVariableInfo = debugVariableInfoArray[n];
                            return debugVariableInfo3;
                        }
                        DebugStackSlotInfo[] debugStackSlotInfoArray = this.debugContext.frame.listSlots();
                        if (n < debugStackSlotInfoArray.length) {
                            DebugStackSlotInfo debugStackSlotInfo = debugStackSlotInfoArray[n];
                            DebugDataCompositeInfo debugDataCompositeInfo = debugStackSlotInfo.getDataInfo();
                            if (debugDataCompositeInfo != null) {
                                DebugDataCompositeInfo debugDataCompositeInfo2 = debugDataCompositeInfo;
                                return debugDataCompositeInfo2;
                            }
                            DebugClassInfo debugClassInfo = this.findPrimitiveIntClass();
                            if (debugClassInfo != null) {
                                String string6 = debugStackSlotInfo.getValue();
                                EvaluationInfo evaluationInfo = new EvaluationInfo(DebugSharedPrimitives.intDecode(string6), debugClassInfo);
                                return evaluationInfo;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string.equals(BaseEvaluator.getClassNameExpressionPart())) {
                    try {
                        DebugClassInfo debugClassInfo = this.debugContext.frame.getLocation().getClassInfo();
                        if (debugClassInfo != null) {
                            DebugClassInfo debugClassInfo3 = this.findClass("java.lang.String");
                            EvaluationInfo evaluationInfo = new EvaluationInfo(debugClassInfo.getName(), debugClassInfo3);
                            return evaluationInfo;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.debugContext.vm.getCapabilities().canGetHeap() && string.startsWith("_0x")) {
                try {
                    String string7 = string.substring(3);
                    long l = Long.parseLong(string7, 16);
                    DebugHeapObjectInfo debugHeapObjectInfo = this.debugContext.vm.getHeapObjectAtAddress(l);
                    if (debugHeapObjectInfo != null) {
                        DebugDataCompositeInfo debugDataCompositeInfo;
                        DebugDataCompositeInfo debugDataCompositeInfo3 = debugDataCompositeInfo = debugHeapObjectInfo.getDataInfo();
                        return debugDataCompositeInfo3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object checkThisFields(DebugDataInfo debugDataInfo, String string) {
        Object object = null;
        if (debugDataInfo instanceof DebugDataObjectInfo) {
            DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo;
            String string2 = "val$" + string;
            String string3 = "v$" + string;
            if (debugDataObjectInfo.canGetFieldByName()) {
                DebugFieldInfo[] debugFieldInfoArray;
                DebugFieldInfo[] debugFieldInfoArray2;
                DebugFieldInfo[] debugFieldInfoArray3;
                int n = string.indexOf(46);
                if (n == -1) {
                    n = string.length();
                }
                String string4 = string.substring(0, n);
                int n2 = -1;
                if (ProfilingEvents.eventOn[13]) {
                    n2 = IdeProfile.startEvent((int)ProfilingEvents.eventId[13], (String)string4);
                }
                DebugFieldInfo debugFieldInfo = debugDataObjectInfo.getField(string4);
                if (ProfilingEvents.eventOn[13]) {
                    IdeProfile.endEvent((int)n2);
                }
                if (debugFieldInfo != null && (object = this.checkFields(string, debugFieldInfoArray3 = new DebugFieldInfo[]{debugFieldInfo})) != null) {
                    return object;
                }
                String string5 = "val$" + string4;
                debugFieldInfo = debugDataObjectInfo.getField(string5);
                if (debugFieldInfo != null && (object = this.checkFields(string2, debugFieldInfoArray2 = new DebugFieldInfo[]{debugFieldInfo})) != null) {
                    return object;
                }
                String string6 = "v$" + string4;
                debugFieldInfo = debugDataObjectInfo.getField(string6);
                if (debugFieldInfo != null && (object = this.checkFields(string3, debugFieldInfoArray = new DebugFieldInfo[]{debugFieldInfo})) != null) {
                    return object;
                }
            } else {
                int n = -1;
                if (ProfilingEvents.eventOn[12]) {
                    n = IdeProfile.startEvent((int)ProfilingEvents.eventId[12], (String)("evaluateSimpleInternal " + string));
                }
                DebugFieldInfo[] debugFieldInfoArray = debugDataObjectInfo.getFields(-1);
                if (ProfilingEvents.eventOn[12]) {
                    IdeProfile.endEvent((int)n, (String)(" - " + (debugFieldInfoArray != null ? debugFieldInfoArray.length : 0) + " fields"));
                }
                if ((object = this.checkFields(string, debugFieldInfoArray)) != null) {
                    return object;
                }
                object = this.checkFields(string2, debugFieldInfoArray);
                if (object != null) {
                    return object;
                }
                object = this.checkFields(string3, debugFieldInfoArray);
                if (object != null) {
                    return object;
                }
            }
        }
        return null;
    }

    protected Object checkVars(String string, DebugVariableInfo[] debugVariableInfoArray, boolean bl) {
        int n = debugVariableInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugVariableInfo debugVariableInfo = debugVariableInfoArray[n2];
            if ((!bl || debugVariableInfo.isInScope()) && string.equals(debugVariableInfo.getName())) {
                return debugVariableInfo;
            }
            ++n2;
        }
        return null;
    }

    protected static DebugVariableInfo findThis(DebugVariableInfo[] debugVariableInfoArray) {
        int n = debugVariableInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugVariableInfo debugVariableInfo = debugVariableInfoArray[n2];
            if (debugVariableInfo.getName().equals("this")) {
                return debugVariableInfo;
            }
            ++n2;
        }
        return null;
    }

    protected Object checkFields(String string, DebugFieldInfo[] debugFieldInfoArray) {
        int n = debugFieldInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n2];
            if (string.equals(debugFieldInfo.getName())) {
                return debugFieldInfo;
            }
            ++n2;
        }
        return null;
    }

    private Object checkFields(String string, int n, int n2, DebugFieldInfo[] debugFieldInfoArray) {
        int n3 = debugFieldInfoArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n4];
            String string2 = debugFieldInfo.getName();
            if (string.regionMatches(n, string2, 0, n5 = string2.length())) {
                if (n2 - n == n5) {
                    return debugFieldInfo;
                }
                DebugDataInfo debugDataInfo = debugFieldInfo.getDataInfo();
                Object object = this.partialMatch(string, n + n5, n2, debugDataInfo);
                if (object != null) {
                    return object;
                }
            }
            ++n4;
        }
        return null;
    }

    protected DebugClassInfo checkClasses(String string) {
        if (this.debugContext.vm != null) {
            DebugClassInfo debugClassInfo = this.debugContext.vm.findFirstClassByName(string);
            if (debugClassInfo != null) {
                return debugClassInfo;
            }
            debugClassInfo = this.debugContext.vm.findFirstClassByName(string, true);
            if (debugClassInfo != null) {
                return debugClassInfo;
            }
        }
        return null;
    }

    protected Object partialMatch(String string, int n, int n2, Object object) {
        char c = string.charAt(n);
        if (c == '.') {
            ++n;
            if (object instanceof DebugDataObjectInfo) {
                DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)object;
                if (debugDataObjectInfo.canGetFieldByName()) {
                    int n3 = string.indexOf(46, n);
                    if (n3 == -1 || n3 > n2) {
                        n3 = n2;
                    }
                    String string2 = string.substring(n, n3);
                    int n4 = -1;
                    if (ProfilingEvents.eventOn[13]) {
                        n4 = IdeProfile.startEvent((int)ProfilingEvents.eventId[13], (String)string2);
                    }
                    DebugFieldInfo debugFieldInfo = debugDataObjectInfo.getField(string2);
                    if (ProfilingEvents.eventOn[13]) {
                        IdeProfile.endEvent((int)n4);
                    }
                    if (debugFieldInfo != null) {
                        DebugFieldInfo[] debugFieldInfoArray = new DebugFieldInfo[]{debugFieldInfo};
                        return this.checkFields(string, n, n2, debugFieldInfoArray);
                    }
                    return null;
                }
                int n5 = -1;
                if (ProfilingEvents.eventOn[12]) {
                    n5 = IdeProfile.startEvent((int)ProfilingEvents.eventId[12], (String)("partialMatch " + string.substring(n)));
                }
                DebugFieldInfo[] debugFieldInfoArray = debugDataObjectInfo.getFields(-1);
                if (ProfilingEvents.eventOn[12]) {
                    IdeProfile.endEvent((int)n5, (String)(" - " + (debugFieldInfoArray != null ? debugFieldInfoArray.length : 0) + " fields"));
                }
                return this.checkFields(string, n, n2, debugFieldInfoArray);
            }
            if (object instanceof DebugDataArrayInfo) {
                int n6;
                DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)object;
                if (!debugDataArrayInfo.isNull() && n2 - n == 6 && string.regionMatches(n, "length", 0, 6) && (n6 = debugDataArrayInfo.getArrayCount()) != -1) {
                    try {
                        DebugClassInfo debugClassInfo = this.findPrimitiveIntClass();
                        if (debugClassInfo != null) {
                            EvaluationInfo evaluationInfo = new EvaluationInfo(n6, debugClassInfo);
                            return evaluationInfo;
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (object instanceof DebugClassInfo) {
                DebugClassInfo debugClassInfo = (DebugClassInfo)object;
                DebugFieldInfo[] debugFieldInfoArray = debugClassInfo.getStaticFields(-1);
                Object object2 = this.checkFields(string, n, n2, debugFieldInfoArray);
                if (object2 != null) {
                    return object2;
                }
                debugFieldInfoArray = new DebugFieldInfo[]{debugClassInfo.getStaticField(string.substring(n, n2))};
                if (debugFieldInfoArray[0] != null && (object2 = this.checkFields(string, n, n2, debugFieldInfoArray)) != null) {
                    return object2;
                }
            }
        }
        return null;
    }

    static DebugDataInfo getDataInfo(Object object) {
        if (object instanceof DebugDataInfo) {
            return (DebugDataInfo)object;
        }
        if (object instanceof DebugHasDataInfo) {
            return ((DebugHasDataInfo)object).getDataInfo();
        }
        return null;
    }

    protected long getComparableId(EvaluationInfo evaluationInfo) throws Exception {
        long l;
        DebugDataInfo debugDataInfo = evaluationInfo.getDataInfo();
        if (debugDataInfo instanceof DebugDataCompositeInfo && (l = JDebugger.getObjectNumber((DebugDataCompositeInfo)debugDataInfo)) != 0L) {
            return l;
        }
        if (evaluationInfo.isNull()) {
            return 0L;
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    protected DebugMethodInfo getCurrentMethod() {
        if (this.debugContext.frame != null) {
            return this.debugContext.frame.getLocation().getMethod();
        }
        return null;
    }

    protected DebugClassInfo findClass(String string) {
        return this.checkClasses(string);
    }

    protected DebugClassInfo findPrimitiveIntClass() {
        return null;
    }

    static String getThrowExpressionPart() {
        return "_" + DbgArb.getString(631);
    }

    static String getReturnedExpressionPart() {
        return "_" + DbgArb.getString(633);
    }

    static String getReturnExpressionPart() {
        return "_" + DbgArb.getString(634);
    }

    static String getSlotExpressionPartPrefix() {
        return "_" + DbgArb.getString(635);
    }

    static String getClassNameExpressionPart() {
        return "_" + DbgArb.getString(636);
    }

    static String getWatchpointObjectExpressionPart() {
        return "_" + DbgArb.getString(637);
    }

    static String getWatchpointFieldExpressionPart() {
        return "_" + DbgArb.getString(638);
    }

    static String getWatchpointFieldFutureValueExpressionPart() {
        return "_" + DbgArb.getString(639);
    }
}

