/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.FastStringBuffer;
import oracle.ideri.util.Product;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.BreakpointSettings;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SavedBreakpoints;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

final class Breakpoint
extends BaseElement
implements GutterColumnListener,
DebugBreakpointCondition {
    private BreakpointSettings breakpointSettings;
    private SourceIcon sourceIcon;
    private boolean shallow;
    private Map debugBreakpointForDebuggingProcess;
    private Map debuggingProcessForDebugBreakpoint;
    private static final int STATUS_DISABLED = 0;
    private static final int STATUS_ENABLED = 1;
    private static final int STATUS_UNVERIFIED = 2;
    private static final int STATUS_VERIFIED = 3;
    private static final Object GlobalBreakpointsKey = "217";
    private static SavedBreakpoints savedBreakpoints;
    private static Map allBreakpoints;
    private static final String REFACTORING_OPERATION = "DebuggerRefactoringOperation";

    private Breakpoint(BreakpointSettings breakpointSettings) {
        this.breakpointSettings = breakpointSettings;
        this.init();
    }

    Breakpoint(URL uRL, int n, String string, String string2, int n2) {
        if (n != 0) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(uRL);
        this.breakpointSettings.setType(n);
        this.breakpointSettings.setPkg(string);
        this.breakpointSettings.setFile(string2);
        this.breakpointSettings.setLine(n2);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL uRL, int n, String string) {
        if (n != 1 && n != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(uRL);
        this.breakpointSettings.setType(n);
        if (n == 1) {
            this.breakpointSettings.setMethod(string);
        } else {
            this.breakpointSettings.setClassName(string);
        }
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL uRL, int n, String string, int n2) {
        if (n != 7) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(uRL);
        this.breakpointSettings.setType(n);
        this.breakpointSettings.setMethod(string);
        this.breakpointSettings.setOffset(n2);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL uRL, int n, String string, boolean bl, boolean bl2) {
        if (n != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(uRL);
        this.breakpointSettings.setType(n);
        this.breakpointSettings.setException(string);
        this.breakpointSettings.setCaught(bl);
        this.breakpointSettings.setUncaught(bl2);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL uRL, int n) {
        if (n != 3) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(uRL);
        this.breakpointSettings.setType(n);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL uRL, int n, URL uRL2, int n2) {
        if (n != 5) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(uRL);
        this.breakpointSettings.setType(n);
        this.breakpointSettings.setURL(uRL2);
        this.breakpointSettings.setLine(n2);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL uRL, int n, String string, String string2, boolean bl, boolean bl2) {
        if (n != 6) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(uRL);
        this.breakpointSettings.setType(n);
        this.breakpointSettings.setClassName(string);
        this.breakpointSettings.setFieldName(string2);
        this.breakpointSettings.setAccess(bl);
        this.breakpointSettings.setModify(bl2);
        this.breakpointSettings.setActions();
        this.init();
    }

    private void init() {
        this.debugBreakpointForDebuggingProcess = new HashMap();
        this.debuggingProcessForDebugBreakpoint = new HashMap();
    }

    DebugBreakpoint getDebugBreakpoint(DebuggingProcess debuggingProcess) {
        return (DebugBreakpoint)this.debugBreakpointForDebuggingProcess.get(debuggingProcess);
    }

    URL getOwnerURL() {
        return this.breakpointSettings.getOwnerURL();
    }

    void setOwnerURL(URL uRL) {
        boolean bl = this.hideBreakpointIcon();
        this.breakpointSettings.setOwnerURL(uRL);
        if (bl) {
            this.showBreakpointIcon();
        }
    }

    boolean isPersistent() {
        return this.breakpointSettings.isPersistent();
    }

    int getType() {
        return this.breakpointSettings.getType();
    }

    String getPackage() {
        return this.breakpointSettings.getPkg();
    }

    String getFile() {
        return this.breakpointSettings.getFile();
    }

    int getLine() {
        return this.breakpointSettings.getLine();
    }

    void setPackageFileLine(String string, String string2, int n) {
        this.setPackageFileLine(string, string2, n, true);
    }

    private void setPackageFileLine(String string, String string2, int n, boolean bl) {
        if (this.breakpointSettings.getType() != 0) {
            throw new Error("bad type");
        }
        boolean bl2 = bl ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setPkg(string);
        this.breakpointSettings.setFile(string2);
        this.breakpointSettings.setLine(n);
        if (bl && bl2) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            28 var6_6 = new 28(this, string, string2, n);
            27 var7_7 = new 27();
            this.pauseAndInvoke(var6_6, var7_7);
        }
    }

    public void markMoved(GutterMark gutterMark, int n, int n2) {
        int n3 = this.breakpointSettings.getType();
        if (n3 == 0) {
            String string = this.breakpointSettings.getPkg();
            String string2 = this.breakpointSettings.getFile();
            this.setPackageFileLine(string, string2, n2, false);
            JDebugger.getInstance().updateBreakpointsWindow();
        } else if (n3 == 5) {
            URL uRL = this.breakpointSettings.getURL();
            this.setURLLine(uRL, n2, false);
            JDebugger.getInstance().updateBreakpointsWindow();
        } else if (n3 == 6 && this.hideBreakpointIcon()) {
            this.showBreakpointIcon();
        }
    }

    public void markRemoved(GutterMark gutterMark, int n) {
        this.removeBreakpoint();
        JDebugger.getInstance().updateBreakpointsWindow();
    }

    public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
        this.removeBreakpoint();
        JDebugger.getInstance().updateBreakpointsWindow();
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
        return this.getShortLabel();
    }

    String getMethod() {
        return this.breakpointSettings.getMethod();
    }

    void setMethod(String string) {
        if (this.breakpointSettings.getType() != 1) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setMethod(string);
        if (!this.shallow) {
            26 var2_2 = new 26(this, string);
            this.pauseAndInvoke(var2_2, null);
        }
    }

    int getOffset() {
        return this.breakpointSettings.getOffset();
    }

    void setMethodOffset(String string, int n) {
        this.setMethodOffset(string, n, true);
    }

    void setMethodOffset(String string, int n, boolean bl) {
        if (this.breakpointSettings.getType() != 7) {
            throw new Error("bad type");
        }
        boolean bl2 = bl ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setMethod(string);
        this.breakpointSettings.setOffset(n);
        if (bl && bl2) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            25 var5_5 = new 25(this, string, n);
            24 var6_6 = new 24();
            this.pauseAndInvoke(var5_5, var6_6);
        }
    }

    String getException() {
        return this.breakpointSettings.getException();
    }

    boolean isCaught() {
        return this.breakpointSettings.isCaught();
    }

    boolean isUncaught() {
        return this.breakpointSettings.isUncaught();
    }

    void setException(String string, boolean bl, boolean bl2) {
        if (this.breakpointSettings.getType() != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setException(string);
        this.breakpointSettings.setCaught(bl);
        this.breakpointSettings.setUncaught(bl2);
        if (!this.shallow) {
            23 var4_4 = new 23(this, string, bl, bl2);
            this.pauseAndInvoke(var4_4, null);
        }
    }

    String getClassName() {
        return this.breakpointSettings.getClassName();
    }

    void setClassName(String string) {
        if (this.breakpointSettings.getType() != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setClassName(string);
        if (!this.shallow) {
            22 var2_2 = new 22(this, string);
            this.pauseAndInvoke(var2_2, null);
        }
    }

    URL getURL() {
        return this.breakpointSettings.getURL();
    }

    void setURLLine(URL uRL, int n) {
        this.setURLLine(uRL, n, true);
    }

    private void setURLLine(URL uRL, int n, boolean bl) {
        if (this.breakpointSettings.getType() != 5) {
            throw new Error("bad type");
        }
        boolean bl2 = bl ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setURL(uRL);
        this.breakpointSettings.setLine(n);
        if (bl && bl2) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            21 var5_5 = new 21(this, uRL, n);
            20 var6_6 = new 20();
            this.pauseAndInvoke(var5_5, var6_6);
        }
    }

    String getFieldName() {
        return this.breakpointSettings.getFieldName();
    }

    boolean isAccess() {
        return this.breakpointSettings.isAccess();
    }

    boolean isModify() {
        return this.breakpointSettings.isModify();
    }

    void setWatchpoint(String string, String string2, boolean bl, boolean bl2) {
        if (this.breakpointSettings.getType() != 6) {
            throw new Error("bad type");
        }
        boolean bl3 = this.hideBreakpointIcon();
        this.breakpointSettings.setClassName(string);
        this.breakpointSettings.setFieldName(string2);
        this.breakpointSettings.setAccess(bl);
        this.breakpointSettings.setModify(bl2);
        if (bl3) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            19 var6_6 = new 19(this, string, string2, bl, bl2);
            18 var7_7 = new 18();
            this.pauseAndInvoke(var6_6, var7_7);
        }
    }

    boolean isEnabled() {
        return this.breakpointSettings.isEnabled();
    }

    boolean isEnabledNow() {
        DebugBreakpoint debugBreakpoint;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (debugBreakpoint = this.getDebugBreakpoint(debuggingProcess)) != null) {
            return debugBreakpoint.getEnabled();
        }
        return this.breakpointSettings.isEnabled();
    }

    void setEnabled(boolean bl) {
        this.breakpointSettings.setEnabled(bl);
        if (!this.shallow) {
            17 var2_2 = new 17(this, bl);
            16 var3_3 = new 16();
            this.pauseAndInvoke(var2_2, var3_3);
        }
    }

    String getGroupName() {
        return this.breakpointSettings.getGroupName();
    }

    void setGroupName(String string) {
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setGroupName(string);
        String string2 = string;
        if (!this.shallow) {
            15 var3_3 = new 15(this, string2);
            this.pauseAndInvoke(var3_3, null);
        }
    }

    String getCondition() {
        return this.breakpointSettings.getCondition();
    }

    void setCondition(String string) {
        Breakpoint breakpoint;
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setCondition(string);
        Breakpoint breakpoint2 = breakpoint = string.length() > 0 ? this : null;
        if (!this.shallow) {
            14 var3_3 = new 14(this, breakpoint);
            this.pauseAndInvoke(var3_3, null);
        }
    }

    public boolean checkBreakpointCondition(DebugBreakpoint debugBreakpoint, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
        block8: {
            try {
                if (debugStackFrameInfoArray.length > 0) {
                    String string = this.breakpointSettings.getCondition();
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(debugVirtualMachine, debugThreadInfo, debugStackFrameInfoArray[0]);
                    int n = evaluator.evaluateCondition(string);
                    switch (n) {
                        default: {
                            String string2 = DbgArb.format(565, string);
                            DebuggingProcess debuggingProcess = (DebuggingProcess)this.debuggingProcessForDebugBreakpoint.get(debugBreakpoint);
                            debuggingProcess.addMessage(string2);
                            boolean bl = true;
                            return bl;
                        }
                        case -1: {
                            String string3 = DbgArb.format(566, string);
                            DebuggingProcess debuggingProcess = (DebuggingProcess)this.debuggingProcessForDebugBreakpoint.get(debugBreakpoint);
                            debuggingProcess.addMessage(string3);
                            boolean bl = true;
                            return bl;
                        }
                        case 0: {
                            boolean bl = false;
                            return bl;
                        }
                        case 1: 
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block8;
                throw (ThreadDeath)throwable;
            }
        }
        return false;
    }

    String getThreadName() {
        return this.breakpointSettings.getThreadName();
    }

    void setThreadName(String string) {
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setThreadName(string);
        String string2 = string;
        if (!this.shallow) {
            13 var3_3 = new 13(this, string2);
            this.pauseAndInvoke(var3_3, null);
        }
    }

    String getThreadNameNot() {
        return this.breakpointSettings.getThreadNameNot();
    }

    void setThreadNameNot(String string) {
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setThreadNameNot(string);
        String string2 = string;
        if (!this.shallow) {
            12 var3_3 = new 12(this, string2);
            this.pauseAndInvoke(var3_3, null);
        }
    }

    int getPassCount() {
        return this.breakpointSettings.getPassCount();
    }

    void setPassCount(int n) {
        this.breakpointSettings.setPassCount(n);
        if (!this.shallow) {
            11 var2_2 = new 11(this, n);
            this.pauseAndInvoke(var2_2, null);
        }
    }

    String getPassCountInfo() {
        int n;
        DebugBreakpoint debugBreakpoint;
        int n2 = this.breakpointSettings.getPassCount();
        String string = Integer.toString(n2);
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (debugBreakpoint = this.getDebugBreakpoint(debuggingProcess)) != null && (n = debugBreakpoint.getPassCount()) != n2) {
            string = string + " " + DbgArb.format(393, Integer.toString(n));
        }
        return string;
    }

    private long[] getInstanceFiltersArray(DebuggingProcess debuggingProcess) {
        DebugBreakpoint debugBreakpoint = this.getDebugBreakpoint(debuggingProcess);
        if (debugBreakpoint != null) {
            return debugBreakpoint.getInstanceFilters();
        }
        return null;
    }

    String getInstanceFilters() {
        int n;
        long[] lArray;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (lArray = this.getInstanceFiltersArray(debuggingProcess)) != null && (n = lArray.length) > 0) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n2 = 0;
            while (n2 < n) {
                fastStringBuffer.append(Long.toString(lArray[n2]));
                if (n2 < n - 1) {
                    fastStringBuffer.append(", ");
                }
                ++n2;
            }
            return DbgArb.format(419, fastStringBuffer.toString());
        }
        return "";
    }

    boolean isActionHalt() {
        return this.breakpointSettings.isActionHalt();
    }

    void setActionHalt(boolean bl) {
        this.breakpointSettings.setActionHalt(bl);
        if (!this.shallow) {
            10 var2_2 = new 10(this, bl);
            this.pauseAndInvoke(var2_2, null);
        }
    }

    boolean isActionBeep() {
        return this.breakpointSettings.isActionBeep();
    }

    void setActionBeep(boolean bl) {
        this.breakpointSettings.setActionBeep(bl);
        if (!this.shallow) {
            9 var2_2 = new 9();
            this.pauseAndInvoke(var2_2, null);
        }
    }

    boolean isActionLog() {
        return this.breakpointSettings.isActionLog();
    }

    void setActionLog(boolean bl) {
        this.breakpointSettings.setActionLog(bl);
        if (!this.shallow) {
            8 var2_2 = new 8();
            this.pauseAndInvoke(var2_2, null);
        }
    }

    String getActionLogTag() {
        return this.breakpointSettings.getActionLogTag();
    }

    void setActionLogTag(String string) {
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setActionLogTag(string);
    }

    String getActionLogExpression() {
        return this.breakpointSettings.getActionLogExpr();
    }

    void setActionLogExpression(String string) {
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setActionLogExpr(string);
    }

    boolean isActionLogStack() {
        return this.breakpointSettings.isActionLogStack();
    }

    void setActionLogStack(boolean bl) {
        this.breakpointSettings.setActionLogStack(bl);
    }

    String getAction() {
        String string;
        String string2;
        String string3 = "";
        String string4 = "";
        if (this.breakpointSettings.isActionHalt()) {
            string3 = string3 + string4 + DbgArb.getString(394);
            string4 = ", ";
        }
        if (this.breakpointSettings.isActionBeep()) {
            string3 = string3 + string4 + DbgArb.getString(395);
            string4 = ", ";
        }
        if (this.breakpointSettings.isActionLog()) {
            string3 = string3 + string4 + DbgArb.getString(397);
            string4 = ", ";
        }
        if ((string2 = this.breakpointSettings.getActionEnableOther()).length() > 0) {
            string3 = string3 + string4 + DbgArb.getString(398) + string2;
            string4 = ", ";
        }
        if ((string = this.breakpointSettings.getActionDisableOther()).length() > 0) {
            string3 = string3 + string4 + DbgArb.getString(399) + string;
        }
        return string3;
    }

    String logBreakpoint(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
        return this.prepareLog(debugVirtualMachine, debugThreadInfo, debugStackFrameInfoArray, null, null);
    }

    String logException(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray, String string, String string2) {
        return this.prepareLog(debugVirtualMachine, debugThreadInfo, debugStackFrameInfoArray, string, string2);
    }

    String logDeadlock(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
        return this.prepareLog(debugVirtualMachine, debugThreadInfo, debugStackFrameInfoArray, null, null);
    }

    String logWatchpoint(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray, DebugFieldInfo debugFieldInfo, DebugDataInfo debugDataInfo) {
        String string;
        String string2 = debugDataInfo == null ? DbgArb.format(554, this.getFieldName()) : DbgArb.format(555, this.getFieldName());
        DebugDataInfo debugDataInfo2 = debugFieldInfo.getDataInfo();
        String string3 = DataPanel.makeDataValue(debugFieldInfo, debugDataInfo2);
        if ((string3 == null || string3.length() == 0) && debugDataInfo2 instanceof DebugDataCompositeInfo) {
            string3 = Breakpoint.makeStupidValue(debugVirtualMachine, (DebugDataCompositeInfo)debugDataInfo2);
        }
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + " " + DbgArb.format(556, string3);
        }
        if (((string = DataPanel.makeDataValue(debugFieldInfo, debugDataInfo)) == null || string.length() == 0) && debugDataInfo instanceof DebugDataCompositeInfo) {
            string = Breakpoint.makeStupidValue(debugVirtualMachine, (DebugDataCompositeInfo)debugDataInfo);
        }
        if (string != null && string.length() > 0) {
            string2 = string2 + " " + DbgArb.format(557, string);
        }
        return this.prepareLog(debugVirtualMachine, debugThreadInfo, debugStackFrameInfoArray, string2, null);
    }

    private static String makeStupidValue(DebugVirtualMachine debugVirtualMachine, DebugDataCompositeInfo debugDataCompositeInfo) {
        long l = JDebugger.getObjectNumber(debugDataCompositeInfo);
        return "@" + Long.toHexString(l).toUpperCase();
    }

    private String prepareLog(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray, String string, String string2) {
        if (this.breakpointSettings.isActionBeep()) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.breakpointSettings.isActionLog()) {
            String string3;
            String string4;
            String string5;
            String string6 = this.getMessage(debugStackFrameInfoArray, string, string2);
            String string7 = this.breakpointSettings.getActionLogTag();
            if (string7 != null && string7.length() > 0) {
                string6 = string6 + string7 + "\n";
            }
            if ((string5 = this.breakpointSettings.getActionLogExpr()) != null && string5.length() > 0 && (string4 = this.evaluateLogExpression(debugVirtualMachine, debugThreadInfo, debugStackFrameInfoArray, string5)) != null && string4.length() > 0) {
                string6 = string6 + string4;
            }
            if (this.breakpointSettings.isActionLogStack() && (string3 = this.getLogStack(debugStackFrameInfoArray)) != null && string3.length() > 0) {
                string6 = string6 + string3;
            }
            return string6;
        }
        return null;
    }

    private String evaluateLogExpression(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray, String string) {
        String string2;
        block5: {
            string2 = "?";
            try {
                if (debugStackFrameInfoArray.length > 0) {
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(debugVirtualMachine, debugThreadInfo, debugStackFrameInfoArray[0]);
                    Object object = evaluator.evaluate(string);
                    if (object != null) {
                        DebugDataInfo debugDataInfo = Evaluator.getDataInfo(object);
                        string2 = DataPanel.makeDataValue(object, debugDataInfo);
                        String string3 = DataPanel.makeType(debugDataInfo, debugDataInfo.getClassInfo(), true, null);
                        if (string3 != null && string3.length() > 0) {
                            string2 = string2 + " (" + string3 + ")";
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)throwable;
            }
        }
        String string4 = DbgArb.format(564, string, string2);
        return string4;
    }

    private String getLogStack(DebugStackFrameInfo[] debugStackFrameInfoArray) {
        int n = debugStackFrameInfoArray.length;
        if (n > 0) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n2 = 0;
            while (n2 < n) {
                DebugMethodInfo debugMethodInfo;
                DebugStackFrameInfo debugStackFrameInfo = debugStackFrameInfoArray[n2];
                DebugLocation debugLocation = debugStackFrameInfo.getLocation();
                if (debugLocation != null && (debugMethodInfo = debugLocation.getMethod()) != null) {
                    String string = DebugShared.makeCourtesyMethodName(debugMethodInfo, true, false, debugStackFrameInfo);
                    String string2 = debugLocation.getFilename();
                    int n3 = debugLocation.getLine();
                    fastStringBuffer.append('\t');
                    fastStringBuffer.append("at ");
                    fastStringBuffer.append(string);
                    if ((debugMethodInfo.getAccess() & 0x100) != 0) {
                        fastStringBuffer.append("(Native Method)");
                    } else if (string2 != null) {
                        fastStringBuffer.append('(');
                        fastStringBuffer.append(string2);
                        if (n3 > 0) {
                            fastStringBuffer.append(':');
                            fastStringBuffer.append(Integer.toString(n3));
                        }
                        fastStringBuffer.append(')');
                    }
                    fastStringBuffer.append("\n");
                }
                ++n2;
            }
            return fastStringBuffer.toString();
        }
        return null;
    }

    private String getMessage(DebugStackFrameInfo[] debugStackFrameInfoArray, String string, String string2) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        switch (this.breakpointSettings.getType()) {
            default: {
                n = 548;
                bl = true;
                break;
            }
            case 1: {
                n = 549;
                bl2 = true;
                bl = true;
                break;
            }
            case 7: {
                n = 550;
                bl2 = true;
                bl = false;
                break;
            }
            case 2: {
                n = 551;
                bl = true;
                break;
            }
            case 3: {
                n = 552;
                bl = true;
                break;
            }
            case 4: {
                n = 558;
                bl2 = true;
                bl = true;
                break;
            }
            case 5: {
                n = 559;
                bl2 = true;
                bl = true;
                break;
            }
            case 6: {
                n = 553;
                bl2 = true;
                bl = true;
            }
        }
        String string3 = "";
        DebugLocation debugLocation = DebuggingProcess.getNonNativeLocation(debugStackFrameInfoArray);
        if (debugLocation != null) {
            DebugMethodInfo debugMethodInfo = debugLocation.getMethod();
            if (bl) {
                String string4 = debugLocation.getFilename();
                int n2 = debugLocation.getLine();
                if (bl2 && debugMethodInfo != null) {
                    DebugClassInfo debugClassInfo = debugMethodInfo.getClassInfo();
                    int n3 = debugClassInfo != null && debugClassInfo.getLanguage() == 8 ? 897 : (XSLTRunnerAddin.isXSLTStylesheet(debugClassInfo) ? 562 : 561);
                    String string5 = DebugShared.makeCourtesyMethodName(debugMethodInfo, true, true, null);
                    string3 = DbgArb.format(n3, Integer.toString(n2), string4, string5);
                } else {
                    string3 = DbgArb.format(560, Integer.toString(n2), string4);
                }
            } else if (bl2 && debugMethodInfo != null) {
                String string6 = DebugShared.makeCourtesyMethodName(debugMethodInfo, true, true, null);
                int n4 = debugLocation.getBytecodeOffset();
                string3 = DbgArb.format(563, Integer.toString(n4), string6);
            }
        }
        Object[] objectArray = new String[]{string3, string != null ? string : "", string2 != null ? string2 : ""};
        return DbgArb.format(n, objectArray);
    }

    String getActionEnableOther() {
        return this.breakpointSettings.getActionEnableOther();
    }

    void setActionEnableOther(String string) {
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setActionEnableOther(string);
        String string2 = string;
        if (!this.shallow) {
            7 var3_3 = new 7(this, string2);
            this.pauseAndInvoke(var3_3, null);
        }
    }

    String getActionDisableOther() {
        return this.breakpointSettings.getActionDisableOther();
    }

    void setActionDisableOther(String string) {
        if (string == null) {
            string = "";
        }
        this.breakpointSettings.setActionDisableOther(string);
        String string2 = string;
        if (!this.shallow) {
            6 var3_3 = new 6(this, string2);
            this.pauseAndInvoke(var3_3, null);
        }
    }

    void pauseAndApplyChanges(Runnable runnable) {
        5 var2_2 = new 5();
        4 var3_3 = null;
        if (runnable != null) {
            var3_3 = new 4(this, runnable);
        }
        this.pauseAndInvoke(var2_2, var3_3);
    }

    void putBreakpoint(DebuggingProcess debuggingProcess) {
        try {
            DebugBreakpoint debugBreakpoint = null;
            String string = null;
            int n = this.breakpointSettings.getType();
            switch (n) {
                case 0: {
                    String string2 = this.breakpointSettings.getPkg();
                    String string3 = this.breakpointSettings.getFile();
                    int n2 = this.breakpointSettings.getLine();
                    debugBreakpoint = debuggingProcess.getVM().putBreakpointPackageFileLine(string2, string3, n2);
                    break;
                }
                case 1: {
                    String string4 = this.breakpointSettings.getMethod();
                    debugBreakpoint = debuggingProcess.getVM().putBreakpointMethod(string4);
                    break;
                }
                case 7: {
                    String string5 = this.breakpointSettings.getMethod();
                    int n3 = this.breakpointSettings.getOffset();
                    debugBreakpoint = debuggingProcess.getVM().putBreakpointMethodBytecode(string5, n3);
                    break;
                }
                case 2: {
                    String string6 = this.breakpointSettings.getException();
                    boolean bl = this.breakpointSettings.isCaught();
                    boolean bl2 = this.breakpointSettings.isUncaught();
                    debugBreakpoint = debuggingProcess.getVM().putBreakpointException(string6, bl, bl2);
                    break;
                }
                case 3: {
                    debugBreakpoint = debuggingProcess.getVM().putBreakpointDeadlock();
                    break;
                }
                case 4: {
                    String string7 = this.breakpointSettings.getClassName();
                    debugBreakpoint = debuggingProcess.getVM().putBreakpointClass(string7);
                    break;
                }
                case 5: {
                    String[] stringArray = debuggingProcess.url_to_packageAndFile(this.breakpointSettings.getURL());
                    if (stringArray != null && stringArray.length == 2) {
                        int n4 = this.breakpointSettings.getLine();
                        debugBreakpoint = debuggingProcess.getVM().putBreakpointPackageFileLine(stringArray[0], stringArray[1], n4);
                        break;
                    }
                    string = DbgArb.format(591, this.getDescription());
                    break;
                }
                case 6: {
                    String string8 = this.breakpointSettings.getClassName();
                    String string9 = this.breakpointSettings.getFieldName();
                    boolean bl = this.breakpointSettings.isAccess();
                    boolean bl3 = this.breakpointSettings.isModify();
                    debugBreakpoint = debuggingProcess.getVM().putBreakpointWatchpoint(string8, string9, bl, bl3);
                }
            }
            if (debugBreakpoint != null) {
                String string10;
                String string11;
                String string12;
                this.debugBreakpointForDebuggingProcess.put(debuggingProcess, debugBreakpoint);
                this.debuggingProcessForDebugBreakpoint.put(debugBreakpoint, debuggingProcess);
                JDebugger.getInstance().breakpointHasBeenPut(this, debugBreakpoint);
                if (!this.breakpointSettings.isEnabled()) {
                    debugBreakpoint.setEnabled(false);
                }
                if ((string12 = this.breakpointSettings.getGroupName()).length() > 0) {
                    debugBreakpoint.setName(string12);
                }
                if ((string11 = this.breakpointSettings.getCondition()).length() > 0) {
                    debugBreakpoint.setCondition(this);
                }
                String string13 = this.breakpointSettings.getThreadName();
                String string14 = this.breakpointSettings.getThreadNameNot();
                if (string13.length() > 0) {
                    debugBreakpoint.setThreadname(string13);
                } else if (string14.length() > 0) {
                    debugBreakpoint.setThreadnameNot(string14);
                }
                debugBreakpoint.setPassCount(this.breakpointSettings.getPassCount());
                debugBreakpoint.setStop(this.breakpointSettings.isActionHalt());
                debugBreakpoint.setLog(this.breakpointSettings.isActionBeep() || this.breakpointSettings.isActionLog());
                String string15 = this.breakpointSettings.getActionEnableOther();
                if (string15.length() > 0) {
                    debugBreakpoint.setEnableOtherBPs(string15);
                }
                if ((string10 = this.breakpointSettings.getActionDisableOther()).length() > 0) {
                    debugBreakpoint.setDisableOtherBPs(string10);
                }
                this.changed(debugBreakpoint, debuggingProcess);
            } else if (this.breakpointSettings.isEnabled()) {
                String string16 = null;
                if (string != null) {
                    string16 = string;
                } else if (n == 3) {
                    if ((debuggingProcess.getVM().getLanguages() & 1) != 0) {
                        string16 = DbgArb.getString(592);
                    }
                } else {
                    string16 = n == 6 ? DbgArb.format(593, this.getDescription()) : DbgArb.format(590, this.getDescription());
                }
                if (string16 != null) {
                    debuggingProcess.log(string16);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void putBreakpoint(Runnable runnable) {
        3 var2_2 = new 3();
        this.pauseAndInvoke(var2_2, runnable);
    }

    void removeBreakpoint() {
        if (!this.breakpointSettings.isPersistent()) {
            this.hideBreakpointIcon();
            2 var1_1 = new 2();
            1 var2_2 = new 1();
            this.pauseAndInvoke(var1_1, var2_2);
            Breakpoint.removeBreakpointFromOwner(this);
        }
    }

    void setShallow(boolean bl) {
        this.shallow = bl;
    }

    private void pauseAndInvoke(RunWhilePaused runWhilePaused, Runnable runnable) {
        DebuggingProcess[] debuggingProcessArray = JDebugger.getInstance().getDebuggingProcessesForBreakpoint(this);
        JDebugger.pauseAndInvoke(debuggingProcessArray, runWhilePaused, runnable);
    }

    void changed(DebugBreakpoint debugBreakpoint, DebuggingProcess debuggingProcess) {
        if (JDebugger.getInstance().isActiveDebuggingProcess(debuggingProcess)) {
            this.updateBreakpointIcon();
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        DebugBreakpoint debugBreakpoint = this.getDebugBreakpoint(debuggingProcess);
        if (debugBreakpoint != null) {
            JDebugger.getInstance().breakpointHasBeenRemoved(this, debugBreakpoint);
            this.debuggingProcessForDebugBreakpoint.remove(debugBreakpoint);
        }
        this.debugBreakpointForDebuggingProcess.remove(debuggingProcess);
    }

    String getTypeString() {
        switch (this.breakpointSettings.getType()) {
            case 0: {
                return DbgArb.getString(380);
            }
            case 1: {
                return DbgArb.getString(379);
            }
            case 7: {
                return DbgArb.getString(386);
            }
            case 2: {
                return DbgArb.getString(381);
            }
            case 3: {
                return DbgArb.getString(382);
            }
            case 4: {
                return DbgArb.getString(383);
            }
            case 5: {
                return DbgArb.getString(384);
            }
            case 6: {
                return DbgArb.getString(385);
            }
        }
        return "";
    }

    private int getActiveStatus() {
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null) {
            DebugBreakpoint debugBreakpoint = this.getDebugBreakpoint(debuggingProcess);
            if (debugBreakpoint != null) {
                if (!debugBreakpoint.getEnabled()) {
                    return 0;
                }
                if (debugBreakpoint instanceof DebugBreakpointClass || debugBreakpoint instanceof DebugBreakpointMethod || debugBreakpoint instanceof DebugBreakpointMethodBytecode || debugBreakpoint instanceof DebugBreakpointPackageFileLine) {
                    DebugLocation[] debugLocationArray = debugBreakpoint.getLocations();
                    return debugLocationArray.length > 0 ? 3 : 2;
                }
            } else {
                return this.breakpointSettings.isEnabled() ? 2 : 0;
            }
        }
        return this.breakpointSettings.isEnabled() ? 1 : 0;
    }

    private int getIconKey() {
        if (this.breakpointSettings.getType() == 6) {
            if (this.isEnabledNow()) {
                return 405;
            }
            return 404;
        }
        switch (this.getActiveStatus()) {
            case 0: {
                return 400;
            }
            case 1: 
            case 2: {
                return 401;
            }
            case 3: {
                return 403;
            }
        }
        return -1;
    }

    public String getShortLabel() {
        return DbgArb.format(387, this.getTypeString(), this.getDescription());
    }

    public Icon getIcon() {
        int n = this.getIconKey();
        if (n != -1) {
            return DbgArb.getIcon(n);
        }
        return null;
    }

    HighlightStyle getHighlightStyle() {
        switch (this.getActiveStatus()) {
            case 0: {
                return SourceIcon.disabledBPStyle;
            }
            case 1: 
            case 2: 
            case 3: {
                return SourceIcon.enabledBPStyle;
            }
        }
        return null;
    }

    private void makeSourceIcon(String string, String string2, int n) {
        URL uRL = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arrayResourceBundle = DbgArb.getInstance();
        int n2 = this.getIconKey();
        if (uRL == null) {
            this.sourceIcon = new SourceIcon(null, null, string, string2, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
        } else {
            String string3 = URLFileSystem.getSuffix((URL)uRL).toLowerCase();
            if (string3.equals(".jpr")) {
                this.sourceIcon = new SourceIcon(null, uRL, string, string2, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
            } else if (string3.equals(".jws")) {
                this.sourceIcon = new SourceIcon(uRL, null, string, string2, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(URL uRL, int n) {
        URL uRL2 = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arrayResourceBundle = DbgArb.getInstance();
        int n2 = this.getIconKey();
        if (uRL2 == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, uRL, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
        } else {
            String string = URLFileSystem.getSuffix((URL)uRL2).toLowerCase();
            if (string.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, uRL2, uRL, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
            } else if (string.equals(".jws")) {
                this.sourceIcon = new SourceIcon(uRL2, (URL)null, uRL, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(String string, String string2) {
        URL uRL = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arrayResourceBundle = DbgArb.getInstance();
        int n = this.getIconKey();
        if (uRL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, string, string2, null, arrayResourceBundle, n, this.getHighlightStyle(), 1, this);
        } else {
            String string3 = URLFileSystem.getSuffix((URL)uRL).toLowerCase();
            if (string3.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, uRL, string, string2, null, arrayResourceBundle, n, this.getHighlightStyle(), 1, this);
            } else if (string3.equals(".jws")) {
                this.sourceIcon = new SourceIcon(uRL, (URL)null, string, string2, null, arrayResourceBundle, n, this.getHighlightStyle(), 1, this);
            }
        }
    }

    private void makeSourceIcon(String string, int n) {
        URL uRL = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arrayResourceBundle = DbgArb.getInstance();
        int n2 = this.getIconKey();
        if (uRL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, string, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
        } else {
            String string2 = URLFileSystem.getSuffix((URL)uRL).toLowerCase();
            if (string2.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, uRL, string, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
            } else if (string2.equals(".jws")) {
                this.sourceIcon = new SourceIcon(uRL, (URL)null, string, n, null, arrayResourceBundle, n2, this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void showBreakpointIcon() {
        int n = this.breakpointSettings.getType();
        switch (n) {
            case 0: {
                String string = this.breakpointSettings.getPkg();
                String string2 = this.breakpointSettings.getFile();
                int n2 = this.breakpointSettings.getLine();
                this.makeSourceIcon(string, string2, n2);
                break;
            }
            case 5: {
                URL uRL = this.breakpointSettings.getURL();
                int n3 = this.breakpointSettings.getLine();
                this.makeSourceIcon(uRL, n3);
                break;
            }
            case 6: {
                String string = this.breakpointSettings.getClassName();
                String string3 = this.breakpointSettings.getFieldName();
                this.makeSourceIcon(string, string3);
                break;
            }
            case 7: {
                String string = this.breakpointSettings.getMethod();
                int n4 = this.breakpointSettings.getOffset();
                this.makeSourceIcon(string, n4);
            }
        }
    }

    boolean matchesIconLocation(CodeEditor codeEditor, int n) {
        if (this.sourceIcon != null) {
            return this.sourceIcon.matchesIconLocation(codeEditor, n);
        }
        return false;
    }

    private boolean hideBreakpointIcon() {
        if (this.sourceIcon != null) {
            this.sourceIcon.hide();
            this.sourceIcon = null;
            return true;
        }
        return false;
    }

    private void updateBreakpointIcon() {
        if (this.sourceIcon != null) {
            this.sourceIcon.changeIcon(DbgArb.getInstance(), this.getIconKey(), this.getHighlightStyle());
        }
    }

    String getDescription() {
        String string = "";
        switch (this.breakpointSettings.getType()) {
            case 0: {
                String string2 = this.breakpointSettings.getPkg();
                String string3 = this.breakpointSettings.getFile();
                if (Product.isRaptor() && string3.endsWith(".pls")) {
                    string3 = string3.substring(0, string3.length() - 4);
                }
                int n = this.breakpointSettings.getLine();
                string = string2 + " " + string3 + " " + n;
                break;
            }
            case 1: {
                String string4;
                string = string4 = this.breakpointSettings.getMethod();
                break;
            }
            case 7: {
                String string5 = this.breakpointSettings.getMethod();
                int n = this.breakpointSettings.getOffset();
                string = string5 + " " + n;
                break;
            }
            case 2: {
                String string6 = this.breakpointSettings.getException();
                if (Product.isRaptor() && this.breakpointSettings.isPersistent() && string6.equals("java.lang.Exception")) {
                    string = DbgArb.getString(539);
                    break;
                }
                boolean bl = this.breakpointSettings.isCaught();
                boolean bl2 = this.breakpointSettings.isUncaught();
                if (bl) {
                    if (bl2) {
                        string = DbgArb.format(544, string6);
                        break;
                    }
                    string = DbgArb.format(542, string6);
                    break;
                }
                if (bl2) {
                    string = DbgArb.format(543, string6);
                    break;
                }
                string = string6;
                break;
            }
            case 3: {
                string = DbgArb.getString(540);
                break;
            }
            case 4: {
                String string7;
                string = string7 = this.breakpointSettings.getClassName();
                break;
            }
            case 5: {
                URL uRL = this.breakpointSettings.getURL();
                int n = this.breakpointSettings.getLine();
                string = URLFileSystem.getPlatformPathName((URL)uRL) + " " + n;
                break;
            }
            case 6: {
                String string8 = this.breakpointSettings.getClassName() + " " + this.breakpointSettings.getFieldName();
                boolean bl = this.breakpointSettings.isAccess();
                boolean bl3 = this.breakpointSettings.isModify();
                if (bl) {
                    if (bl3) {
                        string = DbgArb.format(547, string8);
                        break;
                    }
                    string = DbgArb.format(545, string8);
                    break;
                }
                string = bl3 ? DbgArb.format(546, string8) : string8;
            }
        }
        if (this.breakpointSettings.isPersistent()) {
            string = DbgArb.format(541, string);
        }
        return string;
    }

    String getStatusInfo() {
        String string = this.breakpointSettings.isEnabled() ? DbgArb.getString(389) : DbgArb.getString(388);
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null) {
            String string2 = null;
            switch (this.getActiveStatus()) {
                case 0: {
                    string2 = DbgArb.getString(388);
                    break;
                }
                case 1: {
                    string2 = DbgArb.getString(389);
                    break;
                }
                case 2: {
                    string2 = DbgArb.getString(390);
                    break;
                }
                case 3: {
                    string2 = DbgArb.getString(391);
                }
            }
            if (string2 != null && !string2.equals(string)) {
                string = string + " " + DbgArb.format(392, string2);
            }
        }
        return string;
    }

    static void loadBreakpoints() {
        savedBreakpoints = new SavedBreakpoints();
        savedBreakpoints.load();
        allBreakpoints = new HashMap();
        ArrayList arrayList = savedBreakpoints.getBreakpoints();
        int n = arrayList.size();
        if (n == 0) {
            Breakpoint.createPersistentBreakpoints();
        } else {
            int n2 = 0;
            while (n2 < n) {
                BreakpointSettings breakpointSettings = (BreakpointSettings)arrayList.get(n2);
                Breakpoint breakpoint = new Breakpoint(breakpointSettings);
                List list = Breakpoint.getBreakpoints(breakpoint.getOwnerURL());
                list.add(breakpoint);
                ++n2;
            }
        }
    }

    private static void createPersistentBreakpoints() {
        Breakpoint breakpoint = new Breakpoint((URL)null, 2, "java.lang.Exception", false, true);
        Breakpoint.initializePersistentOptions(breakpoint);
        Breakpoint.addBreakpointToOwner(breakpoint);
        if (!Product.isRaptor()) {
            String string = System.getProperty("os.name").toLowerCase();
            if (string.indexOf("linux") != -1) {
                breakpoint.setEnabled(false);
            }
            Breakpoint breakpoint2 = new Breakpoint((URL)null, 2, "java.lang.AssertionError", false, true);
            Breakpoint.initializePersistentOptions(breakpoint2);
            Breakpoint.addBreakpointToOwner(breakpoint2);
            Breakpoint breakpoint3 = new Breakpoint(null, 3);
            Breakpoint.initializePersistentOptions(breakpoint3);
            Breakpoint.addBreakpointToOwner(breakpoint3);
            if (string.indexOf("sunos") != -1) {
                breakpoint3.setEnabled(false);
            }
        }
    }

    private static void initializePersistentOptions(Breakpoint breakpoint) {
        breakpoint.breakpointSettings.setPersistent(true);
        breakpoint.breakpointSettings.setActionHalt(true);
        breakpoint.breakpointSettings.setActionLog(true);
        breakpoint.breakpointSettings.setActionLogTag("");
        breakpoint.breakpointSettings.setActionLogExpr("");
        breakpoint.breakpointSettings.setActionLogStack(false);
        breakpoint.breakpointSettings.setActionEnableOther("");
        breakpoint.breakpointSettings.setActionDisableOther("");
    }

    static void saveBreakpoints() {
        ArrayList arrayList = savedBreakpoints.getBreakpoints();
        arrayList.clear();
        for (Object k : allBreakpoints.keySet()) {
            URL uRL;
            boolean bl = true;
            if (k instanceof URL && !URLFileSystem.exists((URL)(uRL = (URL)k))) {
                bl = false;
            }
            if (!bl) continue;
            List list = (List)allBreakpoints.get(k);
            for (Breakpoint breakpoint : list) {
                BreakpointSettings breakpointSettings = breakpoint.breakpointSettings;
                arrayList.add(breakpointSettings);
            }
        }
        savedBreakpoints.save();
    }

    private static List getBreakpoints(URL uRL) {
        Object object = uRL == null ? GlobalBreakpointsKey : uRL;
        ArrayList arrayList = (ArrayList)allBreakpoints.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList();
            allBreakpoints.put(object, arrayList);
        }
        return arrayList;
    }

    static void breakpointOwnerRenamed(UpdateMessage updateMessage) {
        URL uRL = RenameMessage.getOldURL((UpdateMessage)updateMessage);
        Node node = RenameMessage.getRenamedNode((UpdateMessage)updateMessage);
        if (node != null) {
            URL uRL2 = node.getURL();
            List list = (List)allBreakpoints.remove(uRL);
            if (list != null) {
                for (Breakpoint breakpoint : list) {
                    breakpoint.setOwnerURL(uRL2);
                }
                allBreakpoints.put(uRL2, list);
            }
        }
    }

    static List[] getBreakpoints(Workspace workspace, Project project) {
        ArrayList<List> arrayList = new ArrayList<List>();
        arrayList.add(Breakpoint.getBreakpoints(null));
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            arrayList.add(Breakpoint.getBreakpoints(workspace.getURL()));
        }
        if (project != null && project != Ide.getDefaultProject()) {
            arrayList.add(Breakpoint.getBreakpoints(project.getURL()));
        }
        return arrayList.toArray(new List[arrayList.size()]);
    }

    static void removeBreakpointFromOwner(Breakpoint breakpoint) {
        URL uRL = breakpoint.getOwnerURL();
        List list = Breakpoint.getBreakpoints(uRL);
        list.remove(breakpoint);
    }

    static void addBreakpointToOwner(Breakpoint breakpoint) {
        Breakpoint.addBreakpointToOwner(breakpoint, false);
    }

    static void addBreakpointToOwner(Breakpoint breakpoint, boolean bl) {
        URL uRL = breakpoint.getOwnerURL();
        List list = Breakpoint.getBreakpoints(uRL);
        list.add(breakpoint);
        if (bl) {
            breakpoint.showBreakpointIcon();
        }
    }

    static void showBreakpointIcons(List[] listArray) {
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : listArray[n2]) {
                breakpoint.showBreakpointIcon();
            }
            ++n2;
        }
    }

    static void hideBreakpointIcons(List[] listArray) {
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : listArray[n2]) {
                breakpoint.hideBreakpointIcon();
            }
            ++n2;
        }
    }

    static void updateBreakpointIcons(List[] listArray) {
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : listArray[n2]) {
                breakpoint.updateBreakpointIcon();
            }
            ++n2;
        }
    }

    static RefactoringHandler getRefactoringHandler() {
        return new RefactoringHandler();
    }

    static void mav$updateBreakpointIcon(Breakpoint breakpoint) {
        breakpoint.updateBreakpointIcon();
    }

    static BreakpointSettings ra$breakpointSettings(Breakpoint breakpoint) {
        return breakpoint.breakpointSettings;
    }

    static Map ra$debuggingProcessForDebugBreakpoint(Breakpoint breakpoint) {
        return breakpoint.debuggingProcessForDebugBreakpoint;
    }

    static Map ra$debugBreakpointForDebuggingProcess(Breakpoint breakpoint) {
        return breakpoint.debugBreakpointForDebuggingProcess;
    }

    static Map ra$allBreakpoints() {
        return allBreakpoints;
    }

    static Object ra$GlobalBreakpointsKey() {
        return GlobalBreakpointsKey;
    }

    final class 28
    implements RunWhilePaused {
        private final /* synthetic */ String v$pkgArg;
        private final /* synthetic */ String v$fileArg;
        private final /* synthetic */ int v$lineArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpointPackageFileLine debugBreakpointPackageFileLine;
                if (debuggingProcess == null || !bl || (debugBreakpointPackageFileLine = (DebugBreakpointPackageFileLine)this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpointPackageFileLine.setPackageFileLine(this.v$pkgArg, this.v$fileArg, this.v$lineArg);
            }
        }

        public 28(Breakpoint breakpoint, String string, String string2, int n) {
            this.v$lineArg = n;
            this.v$fileArg = string2;
            this.v$pkgArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 27
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 26
    implements RunWhilePaused {
        private final /* synthetic */ String v$methodArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpointMethod debugBreakpointMethod;
                if (debuggingProcess == null || !bl || (debugBreakpointMethod = (DebugBreakpointMethod)this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpointMethod.setMethod(this.v$methodArg);
            }
        }

        public 26(Breakpoint breakpoint, String string) {
            this.v$methodArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 25
    implements RunWhilePaused {
        private final /* synthetic */ String v$methodArg;
        private final /* synthetic */ int v$offsetArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpointMethodBytecode debugBreakpointMethodBytecode;
                if (debuggingProcess == null || !bl || (debugBreakpointMethodBytecode = (DebugBreakpointMethodBytecode)this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpointMethodBytecode.setMethodBytecodeOffset(this.v$methodArg, this.v$offsetArg);
            }
        }

        public 25(Breakpoint breakpoint, String string, int n) {
            this.v$offsetArg = n;
            this.v$methodArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 24
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 23
    implements RunWhilePaused {
        private final /* synthetic */ String v$exceptionArg;
        private final /* synthetic */ boolean v$caughtArg;
        private final /* synthetic */ boolean v$uncaughtArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpointException debugBreakpointException;
                if (debuggingProcess == null || !bl || (debugBreakpointException = (DebugBreakpointException)this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpointException.setExceptionClassname(this.v$exceptionArg, this.v$caughtArg, this.v$uncaughtArg);
            }
        }

        public 23(Breakpoint breakpoint, String string, boolean bl, boolean bl2) {
            this.v$uncaughtArg = bl2;
            this.v$caughtArg = bl;
            this.v$exceptionArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 22
    implements RunWhilePaused {
        private final /* synthetic */ String v$classNameArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpointClass debugBreakpointClass;
                if (debuggingProcess == null || !bl || (debugBreakpointClass = (DebugBreakpointClass)this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpointClass.setClassname(this.v$classNameArg);
            }
        }

        public 22(Breakpoint breakpoint, String string) {
            this.v$classNameArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 21
    implements RunWhilePaused {
        private final /* synthetic */ URL v$urlArg;
        private final /* synthetic */ int v$lineArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                String[] stringArray;
                DebugBreakpointPackageFileLine debugBreakpointPackageFileLine;
                if (debuggingProcess == null || !bl || (debugBreakpointPackageFileLine = (DebugBreakpointPackageFileLine)this.this$0.getDebugBreakpoint(debuggingProcess)) == null || (stringArray = debuggingProcess.url_to_packageAndFile(this.v$urlArg)) == null || stringArray.length != 2) break block0;
                debugBreakpointPackageFileLine.setPackageFileLine(stringArray[0], stringArray[1], this.v$lineArg);
            }
        }

        public 21(Breakpoint breakpoint, URL uRL, int n) {
            this.v$lineArg = n;
            this.v$urlArg = uRL;
            this.this$0 = breakpoint;
        }
    }

    final class 20
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 19
    implements RunWhilePaused {
        private final /* synthetic */ String v$classNameArg;
        private final /* synthetic */ String v$fieldNameArg;
        private final /* synthetic */ boolean v$accessArg;
        private final /* synthetic */ boolean v$modifyArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpointWatchpoint debugBreakpointWatchpoint;
                if (debuggingProcess == null || !bl || (debugBreakpointWatchpoint = (DebugBreakpointWatchpoint)this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpointWatchpoint.setWatchpoint(this.v$classNameArg, this.v$fieldNameArg, this.v$accessArg, this.v$modifyArg);
            }
        }

        public 19(Breakpoint breakpoint, String string, String string2, boolean bl, boolean bl2) {
            this.v$modifyArg = bl2;
            this.v$accessArg = bl;
            this.v$fieldNameArg = string2;
            this.v$classNameArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 18
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 17
    implements RunWhilePaused {
        private final /* synthetic */ boolean v$enabledArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setEnabled(this.v$enabledArg);
            }
        }

        public 17(Breakpoint breakpoint, boolean bl) {
            this.v$enabledArg = bl;
            this.this$0 = breakpoint;
        }
    }

    final class 16
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
            JDebugger.getInstance().updateBreakpointsWindowStatus();
        }
    }

    final class 15
    implements RunWhilePaused {
        private final /* synthetic */ String v$groupName;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setName(this.v$groupName);
            }
        }

        public 15(Breakpoint breakpoint, String string) {
            this.v$groupName = string;
            this.this$0 = breakpoint;
        }
    }

    final class 14
    implements RunWhilePaused {
        private final /* synthetic */ DebugBreakpointCondition v$bpCondition;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setCondition(this.v$bpCondition);
            }
        }

        public 14(Breakpoint breakpoint, DebugBreakpointCondition debugBreakpointCondition) {
            this.v$bpCondition = debugBreakpointCondition;
            this.this$0 = breakpoint;
        }
    }

    final class 13
    implements RunWhilePaused {
        private final /* synthetic */ String v$threadName;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setThreadname(this.v$threadName);
            }
        }

        public 13(Breakpoint breakpoint, String string) {
            this.v$threadName = string;
            this.this$0 = breakpoint;
        }
    }

    final class 12
    implements RunWhilePaused {
        private final /* synthetic */ String v$threadNameNot;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setThreadnameNot(this.v$threadNameNot);
            }
        }

        public 12(Breakpoint breakpoint, String string) {
            this.v$threadNameNot = string;
            this.this$0 = breakpoint;
        }
    }

    final class 11
    implements RunWhilePaused {
        private final /* synthetic */ int v$passCountArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setPassCount(this.v$passCountArg);
            }
        }

        public 11(Breakpoint breakpoint, int n) {
            this.v$passCountArg = n;
            this.this$0 = breakpoint;
        }
    }

    final class 10
    implements RunWhilePaused {
        private final /* synthetic */ boolean v$actionHaltArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setStop(this.v$actionHaltArg);
            }
        }

        public 10(Breakpoint breakpoint, boolean bl) {
            this.v$actionHaltArg = bl;
            this.this$0 = breakpoint;
        }
    }

    final class 9
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setLog(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionBeep() || Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionLog());
            }
        }
    }

    final class 8
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setLog(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionBeep() || Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionLog());
            }
        }
    }

    final class 7
    implements RunWhilePaused {
        private final /* synthetic */ String v$actionEnableOther;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setEnableOtherBPs(this.v$actionEnableOther);
            }
        }

        public 7(Breakpoint breakpoint, String string) {
            this.v$actionEnableOther = string;
            this.this$0 = breakpoint;
        }
    }

    final class 6
    implements RunWhilePaused {
        private final /* synthetic */ String v$actionDisableOther;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = this.this$0.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                debugBreakpoint.setDisableOtherBPs(this.v$actionDisableOther);
            }
        }

        public 6(Breakpoint breakpoint, String string) {
            this.v$actionDisableOther = string;
            this.this$0 = breakpoint;
        }
    }

    final class 5
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            if (debuggingProcess != null && bl) {
                try {
                    DebugBreakpoint debugBreakpoint = Breakpoint.this.getDebugBreakpoint(debuggingProcess);
                    if (debugBreakpoint != null) {
                        switch (Breakpoint.ra$breakpointSettings(Breakpoint.this).getType()) {
                            case 0: {
                                String string = Breakpoint.ra$breakpointSettings(Breakpoint.this).getPkg();
                                String string2 = Breakpoint.ra$breakpointSettings(Breakpoint.this).getFile();
                                int n = Breakpoint.ra$breakpointSettings(Breakpoint.this).getLine();
                                ((DebugBreakpointPackageFileLine)debugBreakpoint).setPackageFileLine(string, string2, n);
                                break;
                            }
                            case 1: {
                                String string = Breakpoint.ra$breakpointSettings(Breakpoint.this).getMethod();
                                ((DebugBreakpointMethod)debugBreakpoint).setMethod(string);
                                break;
                            }
                            case 7: {
                                String string = Breakpoint.ra$breakpointSettings(Breakpoint.this).getMethod();
                                int n = Breakpoint.ra$breakpointSettings(Breakpoint.this).getOffset();
                                ((DebugBreakpointMethodBytecode)debugBreakpoint).setMethodBytecodeOffset(string, n);
                                break;
                            }
                            case 2: {
                                String string = Breakpoint.ra$breakpointSettings(Breakpoint.this).getException();
                                boolean bl2 = Breakpoint.ra$breakpointSettings(Breakpoint.this).isCaught();
                                boolean bl3 = Breakpoint.ra$breakpointSettings(Breakpoint.this).isUncaught();
                                ((DebugBreakpointException)debugBreakpoint).setExceptionClassname(string, bl2, bl3);
                                break;
                            }
                            case 4: {
                                String string = Breakpoint.ra$breakpointSettings(Breakpoint.this).getClassName();
                                ((DebugBreakpointClass)debugBreakpoint).setClassname(string);
                                break;
                            }
                            case 5: {
                                String[] stringArray = debuggingProcess.url_to_packageAndFile(Breakpoint.ra$breakpointSettings(Breakpoint.this).getURL());
                                if (stringArray == null || stringArray.length != 2) break;
                                int n = Breakpoint.ra$breakpointSettings(Breakpoint.this).getLine();
                                ((DebugBreakpointPackageFileLine)debugBreakpoint).setPackageFileLine(stringArray[0], stringArray[1], n);
                                break;
                            }
                            case 6: {
                                String string = Breakpoint.ra$breakpointSettings(Breakpoint.this).getClassName();
                                String string3 = Breakpoint.ra$breakpointSettings(Breakpoint.this).getFieldName();
                                boolean bl4 = Breakpoint.ra$breakpointSettings(Breakpoint.this).isAccess();
                                boolean bl5 = Breakpoint.ra$breakpointSettings(Breakpoint.this).isModify();
                                ((DebugBreakpointWatchpoint)debugBreakpoint).setWatchpoint(string, string3, bl4, bl5);
                            }
                        }
                        debugBreakpoint.setEnabled(Breakpoint.ra$breakpointSettings(Breakpoint.this).isEnabled());
                        debugBreakpoint.setName(Breakpoint.ra$breakpointSettings(Breakpoint.this).getGroupName());
                        Breakpoint breakpoint = Breakpoint.ra$breakpointSettings(Breakpoint.this).getCondition().length() > 0 ? Breakpoint.this : null;
                        debugBreakpoint.setCondition(breakpoint);
                        debugBreakpoint.setThreadname(Breakpoint.ra$breakpointSettings(Breakpoint.this).getThreadName());
                        debugBreakpoint.setThreadnameNot(Breakpoint.ra$breakpointSettings(Breakpoint.this).getThreadNameNot());
                        debugBreakpoint.setPassCount(Breakpoint.ra$breakpointSettings(Breakpoint.this).getPassCount());
                        debugBreakpoint.setStop(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionHalt());
                        debugBreakpoint.setLog(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionBeep() || Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionLog());
                        debugBreakpoint.setEnableOtherBPs(Breakpoint.ra$breakpointSettings(Breakpoint.this).getActionEnableOther());
                        debugBreakpoint.setDisableOtherBPs(Breakpoint.ra$breakpointSettings(Breakpoint.this).getActionDisableOther());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ Runnable v$runOnceLater;
        final /* synthetic */ Breakpoint this$0;

        public void run() {
            Breakpoint.mav$updateBreakpointIcon(this.this$0);
            this.v$runOnceLater.run();
        }

        public 4(Breakpoint breakpoint, Runnable runnable) {
            this.v$runOnceLater = runnable;
            this.this$0 = breakpoint;
        }
    }

    final class 3
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            if (debuggingProcess != null && bl) {
                Breakpoint.this.putBreakpoint(debuggingProcess);
            }
        }
    }

    final class 2
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            block0: {
                DebugBreakpoint debugBreakpoint;
                if (debuggingProcess == null || !bl || (debugBreakpoint = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) == null) break block0;
                JDebugger.getInstance().breakpointHasBeenRemoved(Breakpoint.this, debugBreakpoint);
                debugBreakpoint.remove();
            }
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            Breakpoint.ra$debuggingProcessForDebugBreakpoint(Breakpoint.this).clear();
            Breakpoint.ra$debugBreakpointForDebuggingProcess(Breakpoint.this).clear();
        }
    }

    static class RefactoringHandler
    extends URLRefactoringHandler {
        RefactoringHandler() {
        }

        public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
            RefactoringOperation refactoringOperation = (RefactoringOperation)searchOperation.getProperty(Breakpoint.REFACTORING_OPERATION);
            if (refactoringOperation == null) {
                refactoringOperation = new RefactoringOperation();
                searchOperation.setProperty(Breakpoint.REFACTORING_OPERATION, refactoringOperation);
            }
            SearchCriteria searchCriteria = searchOperation.getCriteria();
            boolean bl = false;
            switch (searchCriteria.getSearchType()) {
                case -2147483546: {
                    bl = refactoringOperation.refactorRenameMethod_chooseUrls(project, (RenameMethodCriteria)searchCriteria);
                    break;
                }
                case -2147483545: {
                    bl = refactoringOperation.refactorRenameField_chooseUrls(project, (RenameFieldCriteria)searchCriteria);
                    break;
                }
                case -2147483535: {
                    bl = refactoringOperation.refactorMoveClasses_chooseUrls(project, (MoveClassesCriteria)searchCriteria);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                HashSet<URL> hashSet = new HashSet<URL>();
                hashSet.add(SavedBreakpoints.getXMLURL());
                return hashSet;
            }
            return null;
        }

        public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
            return null;
        }

        public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
            RefactoringOperation refactoringOperation = (RefactoringOperation)searchOperation.getProperty(Breakpoint.REFACTORING_OPERATION);
            SearchCriteria searchCriteria = searchOperation.getCriteria();
            switch (searchCriteria.getSearchType()) {
                case -2147483546: {
                    return refactoringOperation.refactorRenameMethod_doChanges(project, (RenameMethodCriteria)searchCriteria);
                }
                case -2147483545: {
                    return refactoringOperation.refactorRenameField_doChanges(project, (RenameFieldCriteria)searchCriteria);
                }
                case -2147483535: {
                    return refactoringOperation.refactorMoveClasses_doChanges(project, (MoveClassesCriteria)searchCriteria);
                }
            }
            return false;
        }
    }

    static class RefactoringOperation {
        private Map projectToAffectedBreakpoints;
        private String className;
        private String oldMethodName;
        private String oldFullMethodName;
        private String oldGetterName;
        private String oldFullGetterName;
        private String oldSetterName;
        private String oldFullSetterName;
        private String oldFieldName;
        private Map bpToUrl;
        private final String REFACTOR_BREAKPOINT_CMD_PREFIX;
        private int countRefactorBreakpointCommands;

        RefactoringOperation() {
            this.$init$();
            this.projectToAffectedBreakpoints = new HashMap();
            this.bpToUrl = new HashMap();
        }

        private Set getRefactorableBreakpoints(Project project) {
            Workspace workspace;
            HashSet hashSet = new HashSet();
            if (project != null) {
                URL uRL = project.getURL();
                List list = (List)Breakpoint.ra$allBreakpoints().get(uRL);
                if (list != null) {
                    hashSet.addAll(list);
                }
            }
            if (project == Ide.getActiveProject() && (workspace = Ide.getActiveWorkspace()) != null) {
                List list;
                URL uRL = workspace.getURL();
                List list2 = (List)Breakpoint.ra$allBreakpoints().get(uRL);
                if (list2 != null) {
                    hashSet.addAll(list2);
                }
                if ((list = (List)Breakpoint.ra$allBreakpoints().get(Breakpoint.ra$GlobalBreakpointsKey())) != null) {
                    hashSet.addAll(list);
                }
            }
            return hashSet;
        }

        private String getFullMethodName(JavaMethod javaMethod, String string) {
            String string2 = javaMethod.getReturnType().getRawName() + " " + string + "(";
            JavaType[] javaTypeArray = javaMethod.getParameterTypes();
            int n = 0;
            while (n < javaTypeArray.length) {
                string2 = string2 + javaTypeArray[n].getRawName();
                if (n + 1 < javaTypeArray.length) {
                    string2 = string2 + ", ";
                }
                ++n;
            }
            string2 = string2 + ")";
            return string2;
        }

        boolean refactorRenameMethod_chooseUrls(Project project, RenameMethodCriteria renameMethodCriteria) {
            HashSet<Breakpoint> hashSet = new HashSet<Breakpoint>();
            this.projectToAffectedBreakpoints.put(project, hashSet);
            Set set = this.getRefactorableBreakpoints(project);
            JavaMethod javaMethod = renameMethodCriteria.getMethodDescription().getJavaMethod(JavaManager.getJavaManager(project));
            this.className = javaMethod.getOwningClass().getQualifiedName();
            this.oldMethodName = javaMethod.getName();
            String string = this.className + '.' + this.oldMethodName;
            this.oldFullMethodName = this.getFullMethodName(javaMethod, string);
            block4: for (Breakpoint breakpoint : set) {
                switch (breakpoint.getType()) {
                    case 1: {
                        String string2 = breakpoint.getMethod();
                        if (!string2.equals(string)) continue block4;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 7: {
                        String string3 = breakpoint.getMethod();
                        if (!string3.equals(this.oldFullMethodName)) break;
                        hashSet.add(breakpoint);
                    }
                }
            }
            return hashSet.isEmpty() ^ true;
        }

        boolean refactorRenameField_chooseUrls(Project project, RenameFieldCriteria renameFieldCriteria) {
            HashSet<Breakpoint> hashSet = new HashSet<Breakpoint>();
            this.projectToAffectedBreakpoints.put(project, hashSet);
            Set set = this.getRefactorableBreakpoints(project);
            JavaField javaField = renameFieldCriteria.getFieldDescription().getJavaField(JavaManager.getJavaManager(project));
            this.className = javaField.getOwningClass().getQualifiedName();
            this.oldFieldName = javaField.getName();
            String string = null;
            MethodDescription methodDescription = renameFieldCriteria.getGetterDescription();
            if (methodDescription != null) {
                JavaMethod javaMethod = methodDescription.getJavaMethod(JavaManager.getJavaManager(project));
                this.oldGetterName = javaMethod.getName();
                string = this.className + '.' + this.oldGetterName;
                this.oldFullGetterName = this.getFullMethodName(javaMethod, string);
            }
            String string2 = null;
            MethodDescription methodDescription2 = renameFieldCriteria.getSetterDescription();
            if (methodDescription2 != null) {
                JavaMethod javaMethod = methodDescription2.getJavaMethod(JavaManager.getJavaManager(project));
                this.oldSetterName = javaMethod.getName();
                string2 = this.className + '.' + this.oldSetterName;
                this.oldFullSetterName = this.getFullMethodName(javaMethod, string2);
            }
            block5: for (Breakpoint breakpoint : set) {
                switch (breakpoint.getType()) {
                    case 6: {
                        String string3 = breakpoint.getClassName();
                        String string4 = breakpoint.getFieldName();
                        if (!string3.equals(this.className) || !string4.equals(this.oldFieldName)) continue block5;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 1: {
                        String string5 = breakpoint.getMethod();
                        if (this.oldGetterName != null && string5.equals(string)) {
                            hashSet.add(breakpoint);
                            break;
                        }
                        if (this.oldSetterName == null || !string5.equals(string2)) continue block5;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 7: {
                        String string6 = breakpoint.getMethod();
                        if (this.oldGetterName != null && string6.equals(this.oldFullGetterName)) {
                            hashSet.add(breakpoint);
                            break;
                        }
                        if (this.oldSetterName == null || !string6.equals(this.oldFullSetterName)) continue block5;
                        hashSet.add(breakpoint);
                    }
                }
            }
            return hashSet.isEmpty() ^ true;
        }

        boolean refactorMoveClasses_chooseUrls(Project project, MoveClassesCriteria moveClassesCriteria) {
            HashSet<Breakpoint> hashSet = new HashSet<Breakpoint>();
            this.projectToAffectedBreakpoints.put(project, hashSet);
            Set set = this.getRefactorableBreakpoints(project);
            List<URL> list = Arrays.asList(moveClassesCriteria.getOldUrls());
            Workspace workspace = Ide.getActiveWorkspace();
            block9: for (Breakpoint breakpoint : set) {
                switch (breakpoint.getType()) {
                    case 0: {
                        String string = breakpoint.getPackage();
                        String string2 = breakpoint.getFile();
                        URL uRL = Source.findSourceFile(workspace, project, string, string2);
                        if (uRL == null || !list.contains(uRL)) continue block9;
                        hashSet.add(breakpoint);
                        this.bpToUrl.put(breakpoint, uRL);
                        break;
                    }
                    case 1: {
                        String string;
                        String string3 = breakpoint.getMethod();
                        int n = string3.lastIndexOf(46);
                        if (n == -1 || !moveClassesCriteria.isMovedClass(string = string3.substring(0, n))) continue block9;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 7: {
                        String string;
                        int n;
                        int n2;
                        String string4 = breakpoint.getMethod();
                        int n3 = string4.indexOf("(");
                        if (n3 == -1 || (n2 = string4.lastIndexOf(" ", n3) + 1) == -1 || (n = string4.lastIndexOf(".", n3)) == -1 || !moveClassesCriteria.isMovedClass(string = string4.substring(n2, n))) continue block9;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 2: {
                        String string = breakpoint.getException();
                        if (!moveClassesCriteria.isMovedClass(string)) continue block9;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 4: {
                        String string = breakpoint.getClassName();
                        if (!moveClassesCriteria.isMovedClass(string)) continue block9;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 5: {
                        URL uRL = breakpoint.getURL();
                        if (!list.contains(uRL)) continue block9;
                        hashSet.add(breakpoint);
                        break;
                    }
                    case 6: {
                        String string = breakpoint.getClassName();
                        if (!moveClassesCriteria.isMovedClass(string)) break;
                        hashSet.add(breakpoint);
                    }
                }
            }
            return hashSet.isEmpty() ^ true;
        }

        void $init$() {
            this.REFACTOR_BREAKPOINT_CMD_PREFIX = "DebugRefactorBreakpoint";
        }

        boolean refactorRenameMethod_doChanges(Project project, RenameMethodCriteria renameMethodCriteria) {
            Set set = (Set)this.projectToAffectedBreakpoints.get(project);
            String string = this.className + '.' + this.oldMethodName;
            String string2 = renameMethodCriteria.getMemberNameAfter();
            String string3 = this.className + '.' + string2;
            int n = this.oldFullMethodName.indexOf("(");
            int n2 = this.oldFullMethodName.lastIndexOf(".", n) + 1;
            String string4 = this.oldFullMethodName.substring(0, n2) + string2 + this.oldFullMethodName.substring(n);
            for (Breakpoint breakpoint : set) {
                3 var12_12 = new 3(this, this, breakpoint, string, string3, string4);
                try {
                    CommandProcessor.getInstance().invoke((Command)var12_12);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        boolean refactorRenameField_doChanges(Project project, RenameFieldCriteria renameFieldCriteria) {
            Set set = (Set)this.projectToAffectedBreakpoints.get(project);
            String string = renameFieldCriteria.getMemberNameAfter();
            String string2 = this.className + '.' + this.oldGetterName;
            String string3 = renameFieldCriteria.getGetterNameAfter();
            String string4 = this.className + '.' + string3;
            int n = this.oldFullGetterName.indexOf("(");
            int n2 = this.oldFullGetterName.lastIndexOf(".", n) + 1;
            String string5 = this.oldFullGetterName.substring(0, n2) + string3 + this.oldFullGetterName.substring(n);
            String string6 = this.className + '.' + this.oldSetterName;
            String string7 = renameFieldCriteria.getSetterNameAfter();
            String string8 = this.className + '.' + string7;
            int n3 = this.oldFullSetterName.indexOf("(");
            int n4 = this.oldFullSetterName.lastIndexOf(".", n3) + 1;
            String string9 = this.oldFullSetterName.substring(0, n4) + string7 + this.oldFullSetterName.substring(n3);
            for (Breakpoint breakpoint : set) {
                2 var19_19 = new 2(this, this, breakpoint, string, string2, string4, string6, string8, string5, string9);
                try {
                    CommandProcessor.getInstance().invoke((Command)var19_19);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        boolean refactorMoveClasses_doChanges(Project project, MoveClassesCriteria moveClassesCriteria) {
            Set set = (Set)this.projectToAffectedBreakpoints.get(project);
            List<URL> list = Arrays.asList(moveClassesCriteria.getOldUrls());
            List<URL> list2 = Arrays.asList(moveClassesCriteria.getNewUrls());
            List<String> list3 = Arrays.asList(moveClassesCriteria.getOldPackageNames());
            List<String> list4 = Arrays.asList(moveClassesCriteria.getNewPackageNames());
            List<String> list5 = Arrays.asList(moveClassesCriteria.getFqOldClassesNames());
            List<String> list6 = Arrays.asList(moveClassesCriteria.getFqNewClassesNames());
            Workspace workspace = Ide.getActiveWorkspace();
            for (Breakpoint breakpoint : set) {
                1 var13_13 = new 1(this, this, breakpoint, list, list2, project, list5, list6);
                try {
                    CommandProcessor.getInstance().invoke((Command)var13_13);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        static int ra$countRefactorBreakpointCommands(RefactoringOperation refactoringOperation) {
            return refactoringOperation.countRefactorBreakpointCommands;
        }

        static void wa$countRefactorBreakpointCommands(RefactoringOperation refactoringOperation, int n) {
            refactoringOperation.countRefactorBreakpointCommands = n;
        }

        static String ra$oldFullMethodName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFullMethodName;
        }

        static String ra$className(RefactoringOperation refactoringOperation) {
            return refactoringOperation.className;
        }

        static String ra$oldFieldName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFieldName;
        }

        static String ra$oldGetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldGetterName;
        }

        static String ra$oldSetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldSetterName;
        }

        static String ra$oldFullGetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFullGetterName;
        }

        static String ra$oldFullSetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFullSetterName;
        }

        static Map ra$bpToUrl(RefactoringOperation refactoringOperation) {
            return refactoringOperation.bpToUrl;
        }

        abstract class RefactorBreakpointCommand
        extends Command {
            protected Breakpoint _bp;

            private RefactorBreakpointCommand(Breakpoint breakpoint) {
                StringBuilder stringBuilder = new StringBuilder().append("DebugRefactorBreakpoint");
                RefactoringOperation refactoringOperation2 = RefactoringOperation.this;
                int n = RefactoringOperation.ra$countRefactorBreakpointCommands(refactoringOperation2);
                RefactoringOperation.wa$countRefactorBreakpointCommands(refactoringOperation2, n + 1);
                super(Ide.findOrCreateCmdID((String)stringBuilder.append(n).toString()), 3, DbgArb.getString(894));
                this._bp = breakpoint;
                this.setContext(Context.newIdeContext());
            }

            RefactorBreakpointCommand(Breakpoint breakpoint, 3 var3_3) {
                this(breakpoint);
            }

            RefactorBreakpointCommand(Breakpoint breakpoint, 2 var3_3) {
                this(breakpoint);
            }

            RefactorBreakpointCommand(Breakpoint breakpoint, 1 var3_3) {
                this(breakpoint);
            }
        }

        final class 3
        extends RefactorBreakpointCommand {
            private final /* synthetic */ String v$oldClassDotMethod;
            private final /* synthetic */ String v$newClassDotMethod;
            private final /* synthetic */ String v$newFullMethodName;
            final /* synthetic */ RefactoringOperation this$0;

            public int doit() throws Exception {
                switch (this._bp.getType()) {
                    case 1: {
                        String string = this._bp.getMethod();
                        if (!string.equals(this.v$oldClassDotMethod)) break;
                        this._bp.setMethod(this.v$newClassDotMethod);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String string = this._bp.getMethod();
                        if (!string.equals(RefactoringOperation.ra$oldFullMethodName(this.this$0))) break;
                        this._bp.setMethodOffset(this.v$newFullMethodName, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                    }
                }
                return 0;
            }

            public int undo() throws Exception {
                switch (this._bp.getType()) {
                    case 1: {
                        String string = this._bp.getMethod();
                        if (!string.equals(this.v$newClassDotMethod)) break;
                        this._bp.setMethod(this.v$oldClassDotMethod);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String string = this._bp.getMethod();
                        if (!string.equals(this.v$newFullMethodName)) break;
                        this._bp.setMethodOffset(RefactoringOperation.ra$oldFullMethodName(this.this$0), this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                    }
                }
                return 0;
            }

            public 3(RefactoringOperation refactoringOperation, RefactoringOperation refactoringOperation2, Breakpoint breakpoint, String string, String string2, String string3) {
                this.v$newFullMethodName = string3;
                this.v$newClassDotMethod = string2;
                this.v$oldClassDotMethod = string;
                this.this$0 = refactoringOperation;
                super(breakpoint, (3)null);
            }
        }

        final class 2
        extends RefactorBreakpointCommand {
            private final /* synthetic */ String v$newFieldName;
            private final /* synthetic */ String v$oldClassDotGetter;
            private final /* synthetic */ String v$newClassDotGetter;
            private final /* synthetic */ String v$oldClassDotSetter;
            private final /* synthetic */ String v$newClassDotSetter;
            private final /* synthetic */ String v$newFullGetterName;
            private final /* synthetic */ String v$newFullSetterName;
            final /* synthetic */ RefactoringOperation this$0;

            public int doit() throws Exception {
                switch (this._bp.getType()) {
                    case 6: {
                        String string = this._bp.getClassName();
                        String string2 = this._bp.getFieldName();
                        if (!string.equals(RefactoringOperation.ra$className(this.this$0)) || !string2.equals(RefactoringOperation.ra$oldFieldName(this.this$0))) break;
                        this._bp.setWatchpoint(string, this.v$newFieldName, this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 1: {
                        String string = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && string.equals(this.v$oldClassDotGetter)) {
                            this._bp.setMethod(this.v$newClassDotGetter);
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !string.equals(this.v$oldClassDotSetter)) break;
                        this._bp.setMethod(this.v$newClassDotSetter);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String string = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && string.equals(RefactoringOperation.ra$oldFullGetterName(this.this$0))) {
                            this._bp.setMethodOffset(this.v$newFullGetterName, this._bp.getOffset());
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !string.equals(RefactoringOperation.ra$oldFullSetterName(this.this$0))) break;
                        this._bp.setMethodOffset(this.v$newFullSetterName, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                    }
                }
                return 0;
            }

            public int undo() throws Exception {
                switch (this._bp.getType()) {
                    case 6: {
                        String string = this._bp.getClassName();
                        String string2 = this._bp.getFieldName();
                        if (!string.equals(RefactoringOperation.ra$className(this.this$0)) || !string2.equals(this.v$newFieldName)) break;
                        this._bp.setWatchpoint(string, RefactoringOperation.ra$oldFieldName(this.this$0), this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 1: {
                        String string = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && string.equals(this.v$newClassDotGetter)) {
                            this._bp.setMethod(this.v$oldClassDotGetter);
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !string.equals(this.v$newClassDotSetter)) break;
                        this._bp.setMethod(this.v$oldClassDotSetter);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String string = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && string.equals(this.v$newFullGetterName)) {
                            this._bp.setMethodOffset(RefactoringOperation.ra$oldFullGetterName(this.this$0), this._bp.getOffset());
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !string.equals(this.v$newFullSetterName)) break;
                        this._bp.setMethodOffset(RefactoringOperation.ra$oldFullSetterName(this.this$0), this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                    }
                }
                return 0;
            }

            public 2(RefactoringOperation refactoringOperation, RefactoringOperation refactoringOperation2, Breakpoint breakpoint, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
                this.v$newFullSetterName = string7;
                this.v$newFullGetterName = string6;
                this.v$newClassDotSetter = string5;
                this.v$oldClassDotSetter = string4;
                this.v$newClassDotGetter = string3;
                this.v$oldClassDotGetter = string2;
                this.v$newFieldName = string;
                this.this$0 = refactoringOperation;
                super(breakpoint, (2)null);
            }
        }

        final class 1
        extends RefactorBreakpointCommand {
            String savedOldPackage;
            String savedOldFile;
            String savedNewPackage;
            String savedNewFile;
            private final /* synthetic */ List v$oldUrls;
            private final /* synthetic */ List v$newUrls;
            private final /* synthetic */ Project v$project;
            private final /* synthetic */ List v$oldClassNames;
            private final /* synthetic */ List v$newClassNames;
            final /* synthetic */ RefactoringOperation this$0;

            public int doit() throws Exception {
                switch (this._bp.getType()) {
                    case 0: {
                        int n;
                        String string = this._bp.getPackage();
                        String string2 = this._bp.getFile();
                        URL uRL = (URL)RefactoringOperation.ra$bpToUrl(this.this$0).get(this._bp);
                        if (uRL == null || (n = this.v$oldUrls.indexOf(uRL)) == -1) break;
                        URL uRL2 = (URL)this.v$newUrls.get(n);
                        URL uRL3 = URLFileSystem.getParent((URL)uRL2);
                        URLPath uRLPath = PathsConfiguration.getInstance(this.v$project).getProjectSourcePath();
                        String string3 = uRLPath.toRelativePath(uRL3);
                        if (string3 == null) break;
                        String string4 = string3.replace('/', '.');
                        if (string4.endsWith(".")) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        String string5 = URLFileSystem.getFileName((URL)uRL2);
                        this._bp.setPackageFileLine(string4, string5, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        this.savedOldPackage = string;
                        this.savedOldFile = string2;
                        this.savedNewPackage = string4;
                        this.savedNewFile = string5;
                        break;
                    }
                    case 1: {
                        String string;
                        int n;
                        String string6 = this._bp.getMethod();
                        int n2 = string6.lastIndexOf(46);
                        if (n2 == -1 || (n = this.v$oldClassNames.indexOf(string = string6.substring(0, n2))) == -1) break;
                        String string7 = (String)this.v$newClassNames.get(n);
                        String string8 = string7 + '.' + string6.substring(n2 + 1);
                        this._bp.setMethod(string8);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String string = this._bp.getMethod();
                        int n = string.indexOf("(");
                        int n3 = string.lastIndexOf(" ", n) + 1;
                        int n4 = string.lastIndexOf(".", n);
                        String string9 = string.substring(n3, n4);
                        int n5 = this.v$oldClassNames.indexOf(string9);
                        if (n5 == -1) break;
                        String string10 = (String)this.v$newClassNames.get(n5);
                        String string11 = string.substring(0, n3) + string10 + string.substring(n4);
                        this._bp.setMethodOffset(string11, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 2: {
                        String string = this._bp.getException();
                        int n = this.v$oldClassNames.indexOf(string);
                        if (n == -1) break;
                        String string12 = (String)this.v$newClassNames.get(n);
                        this._bp.setException(string12, this._bp.isCaught(), this._bp.isUncaught());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 4: {
                        String string = this._bp.getClassName();
                        int n = this.v$oldClassNames.indexOf(string);
                        if (n == -1) break;
                        String string13 = (String)this.v$newClassNames.get(n);
                        this._bp.setClassName(string13);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 5: {
                        URL uRL = this._bp.getURL();
                        int n = this.v$oldUrls.indexOf(uRL);
                        if (n == -1) break;
                        URL uRL4 = (URL)this.v$newUrls.get(n);
                        this._bp.setURLLine(uRL4, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 6: {
                        String string = this._bp.getClassName();
                        int n = this.v$oldClassNames.indexOf(string);
                        if (n == -1) break;
                        String string14 = (String)this.v$newClassNames.get(n);
                        this._bp.setWatchpoint(string14, this._bp.getFieldName(), this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                    }
                }
                return 0;
            }

            public int undo() throws Exception {
                switch (this._bp.getType()) {
                    case 0: {
                        String string = this._bp.getPackage();
                        String string2 = this._bp.getFile();
                        if (string != this.savedNewPackage || string2 != this.savedNewFile) break;
                        this._bp.setPackageFileLine(this.savedOldPackage, this.savedOldFile, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 1: {
                        String string;
                        int n;
                        String string3 = this._bp.getMethod();
                        int n2 = string3.lastIndexOf(46);
                        if (n2 == -1 || (n = this.v$newClassNames.indexOf(string = string3.substring(0, n2))) == -1) break;
                        String string4 = (String)this.v$oldClassNames.get(n);
                        String string5 = string4 + '.' + string3.substring(n2 + 1);
                        this._bp.setMethod(string5);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String string = this._bp.getMethod();
                        int n = string.indexOf("(");
                        int n3 = string.lastIndexOf(" ", n) + 1;
                        int n4 = string.lastIndexOf(".", n);
                        String string6 = string.substring(n3, n4);
                        int n5 = this.v$newClassNames.indexOf(string6);
                        if (n5 == -1) break;
                        String string7 = (String)this.v$oldClassNames.get(n5);
                        String string8 = string.substring(0, n3) + string7 + string.substring(n4);
                        this._bp.setMethodOffset(string8, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 2: {
                        String string = this._bp.getException();
                        int n = this.v$newClassNames.indexOf(string);
                        if (n == -1) break;
                        String string9 = (String)this.v$oldClassNames.get(n);
                        this._bp.setException(string9, this._bp.isCaught(), this._bp.isUncaught());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 4: {
                        String string = this._bp.getClassName();
                        int n = this.v$newClassNames.indexOf(string);
                        if (n == -1) break;
                        String string10 = (String)this.v$oldClassNames.get(n);
                        this._bp.setClassName(string10);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 5: {
                        URL uRL = this._bp.getURL();
                        int n = this.v$newUrls.indexOf(uRL);
                        if (n == -1) break;
                        URL uRL2 = (URL)this.v$oldUrls.get(n);
                        this._bp.setURLLine(uRL2, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 6: {
                        String string = this._bp.getClassName();
                        int n = this.v$newClassNames.indexOf(string);
                        if (n == -1) break;
                        String string11 = (String)this.v$oldClassNames.get(n);
                        this._bp.setWatchpoint(string11, this._bp.getFieldName(), this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                    }
                }
                return 0;
            }

            public 1(RefactoringOperation refactoringOperation, RefactoringOperation refactoringOperation2, Breakpoint breakpoint, List list, List list2, Project project, List list3, List list4) {
                this.v$newClassNames = list4;
                this.v$oldClassNames = list3;
                this.v$project = project;
                this.v$newUrls = list2;
                this.v$oldUrls = list;
                this.this$0 = refactoringOperation;
                super(breakpoint, (1)null);
            }
        }
    }
}

