/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointOptionsDialog;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.Evaluator;

final class BreakpointActionsPanel
extends JPanel
implements DocumentListener,
ItemListener,
ActionListener {
    private BreakpointOptionsDialog bpDialog;
    private JCheckBox haltCheckBox;
    private JCheckBox beepCheckBox;
    private JCheckBox logCheckBox;
    private JLabel logTagLabel;
    private HistoryList logTagHistoryList;
    private JComboBox logTagComboBox;
    private JTextField logTagEditor;
    private JLabel logExprLabel;
    private HistoryList logExprHistoryList;
    private JComboBox logExprComboBox;
    private JTextField logExprEditor;
    private JCheckBox logStackCheckBox;
    private JCheckBox enableOtherCheckBox;
    private JComboBox enableOtherComboBox;
    private JTextField enableOtherEditor;
    private JCheckBox disableOtherCheckBox;
    private JComboBox disableOtherComboBox;
    private JTextField disableOtherEditor;
    private JCheckBox saveActionsCheckBox;
    private static final String logTagHistoryName = "DebugBreakpointLogTag";
    private static final String logExprHistoryName = "DebugBreakpointLogExpr";

    BreakpointActionsPanel(String[] stringArray, boolean bl, BreakpointOptionsDialog breakpointOptionsDialog) {
        super(new GridBagLayout());
        this.bpDialog = breakpointOptionsDialog;
        this.haltCheckBox = new JCheckBox();
        this.beepCheckBox = new JCheckBox();
        this.logCheckBox = new JCheckBox();
        this.logTagLabel = new JLabel();
        this.logTagHistoryList = Ide.loadHistoryList((String)logTagHistoryName);
        this.logTagComboBox = new JComboBox<String>(this.logTagHistoryList.getHistory());
        this.logTagComboBox.setEditable(true);
        this.logTagEditor = (JTextField)this.logTagComboBox.getEditor().getEditorComponent();
        this.logExprLabel = new JLabel();
        this.logExprHistoryList = Ide.loadHistoryList((String)logExprHistoryName);
        this.logExprComboBox = new JComboBox<String>(this.logExprHistoryList.getHistory());
        this.logExprComboBox.setEditable(true);
        this.logExprEditor = (JTextField)this.logExprComboBox.getEditor().getEditorComponent();
        this.logStackCheckBox = new JCheckBox();
        this.enableOtherCheckBox = new JCheckBox();
        if (stringArray != null) {
            this.enableOtherComboBox = new JComboBox<String>(stringArray);
            this.enableOtherComboBox.setEditable(true);
            this.enableOtherEditor = (JTextField)this.enableOtherComboBox.getEditor().getEditorComponent();
        } else {
            this.enableOtherEditor = new JTextField();
        }
        this.disableOtherCheckBox = new JCheckBox();
        if (stringArray != null) {
            this.disableOtherComboBox = new JComboBox<String>(stringArray);
            this.disableOtherComboBox.setEditable(true);
            this.disableOtherEditor = (JTextField)this.disableOtherComboBox.getEditor().getEditorComponent();
        } else {
            this.disableOtherEditor = new JTextField();
        }
        this.saveActionsCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.haltCheckBox, (String)DbgArb.getString(516));
        ResourceUtils.resButton((AbstractButton)this.beepCheckBox, (String)DbgArb.getString(517));
        ResourceUtils.resButton((AbstractButton)this.logCheckBox, (String)DbgArb.getString(518));
        ResourceUtils.resLabel((JLabel)this.logTagLabel, (Component)this.logTagEditor, (String)DbgArb.getString(519));
        ResourceUtils.resLabel((JLabel)this.logExprLabel, (Component)this.logExprEditor, (String)DbgArb.getString(520));
        ResourceUtils.resButton((AbstractButton)this.logStackCheckBox, (String)DbgArb.getString(521));
        ResourceUtils.resButton((AbstractButton)this.enableOtherCheckBox, (String)DbgArb.getString(522));
        this.enableOtherEditor.getAccessibleContext().setAccessibleName(this.enableOtherCheckBox.getText());
        ResourceUtils.resButton((AbstractButton)this.disableOtherCheckBox, (String)DbgArb.getString(523));
        this.disableOtherEditor.getAccessibleContext().setAccessibleName(this.disableOtherCheckBox.getText());
        ResourceUtils.resButton((AbstractButton)this.saveActionsCheckBox, (String)DbgArb.getString(524));
        int n = 0;
        this.add((Component)this.haltCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.beepCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.logCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.logTagLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        this.add((Component)this.logTagComboBox, new GridBagConstraints(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.logExprLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        this.add((Component)this.logExprComboBox, new GridBagConstraints(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.logStackCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 5), 0, 0));
        this.add((Component)this.enableOtherCheckBox, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        if (this.enableOtherComboBox != null) {
            this.add((Component)this.enableOtherComboBox, new GridBagConstraints(2, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        } else {
            this.add((Component)this.enableOtherEditor, new GridBagConstraints(2, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.add((Component)this.disableOtherCheckBox, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        if (this.disableOtherComboBox != null) {
            this.add((Component)this.disableOtherComboBox, new GridBagConstraints(2, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        } else {
            this.add((Component)this.disableOtherEditor, new GridBagConstraints(2, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        if (bl) {
            this.add((Component)this.saveActionsCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.logCheckBox.addItemListener(this);
        this.logTagComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.logTagComboBox, (DocumentListener)this);
        this.logExprComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.logExprComboBox, (DocumentListener)this);
        this.enableOtherCheckBox.addItemListener(this);
        if (this.enableOtherComboBox != null) {
            this.enableOtherComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.enableOtherComboBox, (DocumentListener)this);
        }
        this.disableOtherCheckBox.addItemListener(this);
        if (this.disableOtherComboBox != null) {
            this.disableOtherComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.disableOtherComboBox, (DocumentListener)this);
        }
    }

    void loadFrom(Breakpoint breakpoint, BreakpointsWindowSettings breakpointsWindowSettings) {
        String string;
        String string2;
        boolean bl;
        String string3;
        String string4;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (breakpoint != null) {
            bl4 = breakpoint.isActionHalt();
            bl3 = breakpoint.isActionBeep();
            bl2 = breakpoint.isActionLog();
            string4 = breakpoint.getActionLogTag();
            string3 = breakpoint.getActionLogExpression();
            bl = breakpoint.isActionLogStack();
            string2 = breakpoint.getActionEnableOther();
            string = breakpoint.getActionDisableOther();
        } else {
            bl4 = breakpointsWindowSettings.getDefaultActionHalt();
            bl3 = breakpointsWindowSettings.getDefaultActionBeep();
            bl2 = breakpointsWindowSettings.getDefaultActionLog();
            string4 = breakpointsWindowSettings.getDefaultActionLogTag();
            string3 = breakpointsWindowSettings.getDefaultActionLogExpr();
            bl = breakpointsWindowSettings.getDefaultActionLogStack();
            string2 = breakpointsWindowSettings.getDefaultActionEnableOther();
            string = breakpointsWindowSettings.getDefaultActionDisableOther();
        }
        this.haltCheckBox.setSelected(bl4);
        this.beepCheckBox.setSelected(bl3);
        this.logCheckBox.setSelected(bl2);
        this.logTagLabel.setEnabled(bl2);
        IdeUtil.comboBoxSelectItem((JComboBox)this.logTagComboBox, (Object)string4);
        this.logTagComboBox.setEnabled(bl2);
        this.logExprLabel.setEnabled(bl2);
        IdeUtil.comboBoxSelectItem((JComboBox)this.logExprComboBox, (Object)string3);
        this.logExprComboBox.setEnabled(bl2);
        this.logStackCheckBox.setEnabled(bl2);
        this.logStackCheckBox.setSelected(bl);
        this.enableOtherCheckBox.setSelected(string2.length() > 0);
        if (this.enableOtherComboBox != null) {
            IdeUtil.comboBoxSelectItem((JComboBox)this.enableOtherComboBox, (Object)string2);
            this.enableOtherComboBox.setEnabled(this.enableOtherCheckBox.isSelected());
        } else {
            this.enableOtherEditor.setText(string2);
            this.enableOtherEditor.setEnabled(this.enableOtherCheckBox.isSelected());
        }
        this.disableOtherCheckBox.setSelected(string.length() > 0);
        if (this.disableOtherComboBox != null) {
            IdeUtil.comboBoxSelectItem((JComboBox)this.disableOtherComboBox, (Object)string);
            this.disableOtherComboBox.setEnabled(this.disableOtherCheckBox.isSelected());
        } else {
            this.disableOtherEditor.setText(string);
            this.disableOtherEditor.setEnabled(this.disableOtherCheckBox.isSelected());
        }
    }

    void setLog(boolean bl) {
        this.logCheckBox.setSelected(bl);
    }

    String anythingInvalid() {
        String string = this.logExprEditor.getText();
        if (string.length() > 0 && !Evaluator.validate(string)) {
            return DbgArb.getString(536);
        }
        if (this.enableOtherCheckBox.isSelected() && this.enableOtherEditor.getText().length() == 0) {
            return DbgArb.getString(537);
        }
        if (this.disableOtherCheckBox.isSelected() && this.disableOtherEditor.getText().length() == 0) {
            return DbgArb.getString(538);
        }
        return null;
    }

    void commitTo(Breakpoint breakpoint, BreakpointsWindowSettings breakpointsWindowSettings) {
        boolean bl = this.haltCheckBox.isSelected();
        boolean bl2 = this.beepCheckBox.isSelected();
        boolean bl3 = this.logCheckBox.isSelected();
        String string = "";
        String string2 = "";
        boolean bl4 = false;
        if (bl3) {
            string = this.logTagHistoryList.comboBoxGetSelectedItem(this.logTagEditor);
            string2 = this.logExprHistoryList.comboBoxGetSelectedItem(this.logExprEditor);
            bl4 = this.logStackCheckBox.isSelected();
        }
        String string3 = "";
        if (this.enableOtherCheckBox.isSelected()) {
            string3 = this.enableOtherEditor.getText();
        }
        String string4 = "";
        if (this.disableOtherCheckBox.isSelected()) {
            string4 = this.disableOtherEditor.getText();
        }
        if (breakpoint != null) {
            breakpoint.setActionHalt(bl);
            breakpoint.setActionBeep(bl2);
            breakpoint.setActionLog(bl3);
            breakpoint.setActionLogTag(string);
            breakpoint.setActionLogExpression(string2);
            breakpoint.setActionLogStack(bl4);
            breakpoint.setActionEnableOther(string3);
            breakpoint.setActionDisableOther(string4);
        }
        if (breakpoint == null || this.saveActionsCheckBox.isSelected()) {
            breakpointsWindowSettings.setDefaultActionHalt(bl);
            breakpointsWindowSettings.setDefaultActionBeep(bl2);
            breakpointsWindowSettings.setDefaultActionLog(bl3);
            breakpointsWindowSettings.setDefaultActionLogTag(string);
            breakpointsWindowSettings.setDefaultActionLogExpr(string2);
            breakpointsWindowSettings.setDefaultActionLogStack(bl4);
            breakpointsWindowSettings.setDefaultActionEnableOther(string3);
            breakpointsWindowSettings.setDefaultActionDisableOther(string4);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.logTagComboBox) {
            this.logTagEditor.setText((String)this.logTagComboBox.getSelectedItem());
        } else if (object == this.logExprComboBox) {
            this.logExprEditor.setText((String)this.logExprComboBox.getSelectedItem());
        } else if (object == this.enableOtherComboBox && this.enableOtherComboBox != null) {
            this.enableOtherEditor.setText((String)this.enableOtherComboBox.getSelectedItem());
        } else if (object == this.disableOtherComboBox && this.disableOtherComboBox != null) {
            this.disableOtherEditor.setText((String)this.disableOtherComboBox.getSelectedItem());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.logCheckBox) {
            boolean bl = this.logCheckBox.isSelected();
            this.logTagLabel.setEnabled(bl);
            this.logTagComboBox.setEnabled(bl);
            this.logExprLabel.setEnabled(bl);
            this.logExprComboBox.setEnabled(bl);
            this.logStackCheckBox.setEnabled(bl);
        } else if (object == this.enableOtherCheckBox) {
            if (this.enableOtherComboBox != null) {
                this.enableOtherComboBox.setEnabled(this.enableOtherCheckBox.isSelected());
            } else {
                this.enableOtherEditor.setEnabled(this.enableOtherCheckBox.isSelected());
            }
        } else if (object == this.disableOtherCheckBox) {
            if (this.disableOtherComboBox != null) {
                this.disableOtherComboBox.setEnabled(this.disableOtherCheckBox.isSelected());
            } else {
                this.disableOtherEditor.setEnabled(this.disableOtherCheckBox.isSelected());
            }
        }
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }
}

