/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLTextField;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointActionsPanel;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

final class BreakpointOptionsDialog
extends JPanel
implements ChangeListener,
DocumentListener,
ItemListener,
ActionListener {
    private static int lastType = 2;
    private Project jproject;
    private JEWTDialog dlg;
    private URL ownerURL;
    private Breakpoint bp;
    private Breakpoint[] group;
    private Breakpoint[] breakpoints;
    private String[] groupNames;
    private JTabbedPane tabbedPane;
    private JPanel definitionPane;
    private JPanel conditionsPane;
    private JPanel actionsPane;
    private int currentType;
    private BreakpointTypeItem[] types;
    private JComboBox typeComboBox;
    private CardPanel definitionCardPanel;
    private HistoryList packageHistoryList;
    private JComboBox packageComboBox;
    private JTextField packageEditor;
    private HistoryList fileHistoryList;
    private JComboBox fileComboBox;
    private JTextField fileEditor;
    private JTextField lineTextField;
    private HistoryList methodHistoryList;
    private JComboBox methodComboBox;
    private JTextField methodEditor;
    private HistoryList exceptionHistoryList;
    private JComboBox exceptionComboBox;
    private JTextField exceptionEditor;
    private JButton exceptionBrowseButton;
    private JCheckBox caughtCheckBox;
    private JCheckBox uncaughtCheckBox;
    private HistoryList classHistoryList;
    private JComboBox classComboBox;
    private JTextField classEditor;
    private JButton classBrowseButton;
    private URLTextField urlTextField;
    private JButton urlBrowseButton;
    private JTextField lineTextField2;
    private HistoryList watchpointClassHistoryList;
    private JComboBox watchpointClassComboBox;
    private JTextField watchpointClassEditor;
    private JButton watchpointClassBrowseButton;
    private HistoryList watchpointFieldHistoryList;
    private JComboBox watchpointFieldComboBox;
    private JTextField watchpointFieldEditor;
    private JCheckBox accessCheckBox;
    private JCheckBox modifyCheckBox;
    private JLabel groupNameLabel;
    private HistoryList groupNameHistoryList;
    private JComboBox groupNameComboBox;
    private JTextField groupNameEditor;
    private JCheckBox groupNameCheckBox;
    private JTextField groupNameTextField;
    private HistoryList conditionHistoryList;
    private JComboBox conditionComboBox;
    private JTextField conditionEditor;
    private JRadioButton radioAllThreads;
    private JRadioButton radioOneThread;
    private HistoryList threadHistoryList;
    private JComboBox threadComboBox;
    private JTextField threadEditor;
    private JRadioButton radioNotThread;
    private HistoryList notThreadHistoryList;
    private JComboBox notThreadComboBox;
    private JTextField notThreadEditor;
    private NumericSpinBox passCountBox;
    private BreakpointActionsPanel bpActionsPanel;
    private static final String packageHistoryName = "DebugBreakpointPackage";
    private static final String fileHistoryName = "DebugBreakpointFile";
    private static final String methodHistoryName = "DebugBreakpointMethod";
    private static final String exceptionHistoryName = "DebugBreakpointException";
    private static final String classHistoryName = "DebugBreakpointClass";
    private static final String watchpointClassHistoryName = "DebugBreakpointWatchpointClass";
    private static final String watchpointFieldHistoryName = "DebugBreakpointWatchpointField";
    private static final String groupNameHistoryName = "DebugBreakpointGroupName";
    private static final String conditionHistoryName = "DebugBreakpointCondition";
    private static final String threadHistoryName = "DebugBreakpointThread";
    private static final String notThreadHistoryName = "DebugBreakpointThreadNot";

    static BreakpointOptionsDialog showBreakpointOptionsDialog(URL uRL, Breakpoint breakpoint, String[] stringArray) {
        BreakpointOptionsDialog breakpointOptionsDialog = new BreakpointOptionsDialog(uRL, breakpoint, stringArray);
        String string = breakpoint == null ? DbgArb.getString(455) : DbgArb.getString(456);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)breakpointOptionsDialog, (Component)breakpointOptionsDialog.getInitialFocus(), (String)string);
        breakpointOptionsDialog.setJEWTDialog(jEWTDialog);
        jEWTDialog.setOKButtonEnabled(breakpointOptionsDialog.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)breakpointOptionsDialog, "f1_deb_new_edit_breakptdialog_html");
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            return breakpointOptionsDialog;
        }
        return null;
    }

    static BreakpointOptionsDialog showBreakpointOptionsDialog(Breakpoint[] breakpointArray, boolean bl, String[] stringArray) {
        BreakpointOptionsDialog breakpointOptionsDialog = new BreakpointOptionsDialog(breakpointArray, bl, stringArray);
        String string = bl ? DbgArb.getString(457) : DbgArb.getString(458);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)breakpointOptionsDialog, (Component)breakpointOptionsDialog.getInitialFocus(), (String)string);
        breakpointOptionsDialog.setJEWTDialog(jEWTDialog);
        jEWTDialog.setOKButtonEnabled(breakpointOptionsDialog.canOk());
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            return breakpointOptionsDialog;
        }
        return null;
    }

    private BreakpointOptionsDialog(URL uRL, Breakpoint breakpoint, String[] stringArray) {
        super(new BorderLayout());
        this.ownerURL = uRL;
        this.bp = breakpoint;
        this.groupNames = stringArray;
        this.currentType = breakpoint != null ? breakpoint.getType() : lastType;
        ArrayList<BreakpointTypeItem> arrayList = new ArrayList<BreakpointTypeItem>();
        arrayList.add(new BreakpointTypeItem(0));
        arrayList.add(new BreakpointTypeItem(2));
        arrayList.add(new BreakpointTypeItem(1));
        arrayList.add(new BreakpointTypeItem(4));
        arrayList.add(new BreakpointTypeItem(5));
        arrayList.add(new BreakpointTypeItem(6));
        if (breakpoint != null && this.currentType == 3) {
            arrayList.add(new BreakpointTypeItem(3));
        }
        if (breakpoint != null && this.currentType == 7) {
            arrayList.add(new BreakpointTypeItem(7));
        }
        this.types = arrayList.toArray(new BreakpointTypeItem[arrayList.size()]);
        this.init();
    }

    private BreakpointOptionsDialog(Breakpoint[] breakpointArray, boolean bl, String[] stringArray) {
        super(new BorderLayout());
        this.bp = breakpointArray[0];
        if (bl) {
            this.group = breakpointArray;
        } else {
            this.breakpoints = breakpointArray;
        }
        this.groupNames = stringArray;
        this.init();
    }

    private void init() {
        this.jproject = Ide.getActiveProject();
        this.tabbedPane = new JTabbedPane();
        this.definitionPane = this.makeDefinitionPane();
        this.conditionsPane = this.makeConditionsPane();
        this.actionsPane = this.makeActionsPane(this.groupNames);
        this.tabbedPane.addTab(DbgArb.getString(459), this.definitionPane);
        this.tabbedPane.addTab(DbgArb.getString(460), this.conditionsPane);
        this.tabbedPane.addTab(DbgArb.getString(461), this.actionsPane);
        this.add((Component)this.tabbedPane, "Center");
        this.addListeners();
    }

    private void addListeners() {
        this.tabbedPane.addChangeListener(this);
        if (this.group != null) {
            this.groupNameTextField.getDocument().addDocumentListener(this);
        } else if (this.breakpoints != null) {
            this.groupNameCheckBox.addItemListener(this);
            this.groupNameComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.groupNameComboBox, (DocumentListener)this);
        } else {
            this.typeComboBox.addItemListener(this);
            this.packageComboBox.addActionListener(this);
            this.fileComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.fileComboBox, (DocumentListener)this);
            this.lineTextField.getDocument().addDocumentListener(this);
            this.methodComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.methodComboBox, (DocumentListener)this);
            this.exceptionComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.exceptionComboBox, (DocumentListener)this);
            this.exceptionBrowseButton.addActionListener(this);
            this.classComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.classComboBox, (DocumentListener)this);
            this.classBrowseButton.addActionListener(this);
            this.urlTextField.getDocument().addDocumentListener(this);
            this.urlBrowseButton.addActionListener((ActionListener)this.urlTextField);
            this.lineTextField2.getDocument().addDocumentListener(this);
            this.watchpointClassComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.watchpointClassComboBox, (DocumentListener)this);
            this.watchpointClassBrowseButton.addActionListener(this);
            this.watchpointFieldComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.watchpointFieldComboBox, (DocumentListener)this);
            this.groupNameComboBox.addActionListener(this);
        }
        this.conditionComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.conditionComboBox, (DocumentListener)this);
        this.radioAllThreads.addActionListener(this);
        this.radioAllThreads.addItemListener(this);
        this.radioOneThread.addActionListener(this);
        this.radioOneThread.addItemListener(this);
        this.radioNotThread.addActionListener(this);
        this.radioNotThread.addItemListener(this);
        this.threadComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.threadComboBox, (DocumentListener)this);
        this.notThreadComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.notThreadComboBox, (DocumentListener)this);
    }

    private void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 2());
    }

    private boolean showXSLTMessage(int n) {
        BreakpointTypeItem breakpointTypeItem = this.getBreakpointTypeItem(n);
        String[] stringArray = new String[]{DbgArb.format(836, breakpointTypeItem.toString()), DbgArb.getString(837)};
        int n2 = JOptionPane.showConfirmDialog(this, stringArray, DbgArb.format(835, this.dlg.getTitle()), 0);
        return n2 == 0;
    }

    private boolean findClass(String string) {
        JavaManager javaManager;
        return this.jproject != null && (javaManager = JavaManager.getJavaManager(this.jproject)).getClass(string) != null;
    }

    private boolean showClassNotFoundMessage(String string) {
        String[] stringArray = new String[]{DbgArb.format(839, string), DbgArb.getString(840)};
        int n = JOptionPane.showConfirmDialog(this, stringArray, DbgArb.format(838, this.dlg.getTitle()), 0);
        return n == 0;
    }

    private boolean findMethod(String string) {
        int n;
        boolean bl = false;
        if (this.jproject != null && (n = string.lastIndexOf(46)) != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            JavaManager javaManager = JavaManager.getJavaManager(this.jproject);
            JavaClass javaClass = javaManager.getClass(string2);
            if (javaClass != null) {
                Collection collection;
                Collection collection2;
                if (string3.equals("<clinit>")) {
                    if (javaClass.getClinitMethod() != null) {
                        bl = true;
                    } else {
                        List list;
                        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
                        if (sourceClass != null && (list = sourceClass.getSourceInitializers()) != null && list.size() > 0) {
                            bl = true;
                        }
                    }
                } else if (string3.equals("<init>") && (collection2 = javaClass.getDeclaredConstructors()) != null && collection2.size() > 0) {
                    bl = true;
                }
                if (!bl && (collection = javaClass.getDeclaredMethods()) != null && collection.size() > 0) {
                    for (JavaMethod javaMethod : collection) {
                        if (!javaMethod.getName().equals(string3)) continue;
                        bl = true;
                        break;
                    }
                }
            }
        }
        return bl;
    }

    private boolean showMethodNotFoundMessage(String string) {
        String[] stringArray = new String[]{DbgArb.format(842, string), DbgArb.getString(843)};
        int n = JOptionPane.showConfirmDialog(this, stringArray, DbgArb.format(841, this.dlg.getTitle()), 0);
        return n == 0;
    }

    private boolean findField(String string, String string2) {
        JavaManager javaManager;
        JavaClass javaClass;
        return this.jproject != null && (javaClass = (javaManager = JavaManager.getJavaManager(this.jproject)).getClass(string)) != null && javaClass.getDeclaredField(string2) != null;
    }

    private boolean showFieldNotFoundMessage(String string, String string2) {
        String[] stringArray = new String[]{DbgArb.format(845, string2, string), DbgArb.getString(846)};
        int n = JOptionPane.showConfirmDialog(this, stringArray, DbgArb.format(844, this.dlg.getTitle()), 0);
        return n == 0;
    }

    private Component getInitialFocus() {
        if (this.group != null) {
            return this.groupNameTextField;
        }
        if (this.breakpoints != null) {
            return this.groupNameCheckBox;
        }
        switch (this.currentType) {
            default: {
                return this.packageEditor;
            }
            case 1: {
                return this.methodEditor;
            }
            case 7: {
                return this.groupNameEditor;
            }
            case 2: {
                return this.exceptionEditor;
            }
            case 3: {
                return this.groupNameEditor;
            }
            case 4: {
                return this.classEditor;
            }
            case 5: {
                return this.urlTextField;
            }
            case 6: 
        }
        return this.watchpointClassEditor;
    }

    private JPanel makeDefinitionPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        if (this.group != null) {
            JLabel jLabel = new JLabel(DbgArb.getString(506));
            this.groupNameLabel = new JLabel();
            this.groupNameTextField = new JTextField();
            this.groupNameTextField.setText(this.bp.getGroupName());
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameTextField, (String)DbgArb.getString(509));
            jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n2 = 0;
            while (n2 < this.group.length) {
                fastStringBuffer.append(this.group[n2].getDescription());
                fastStringBuffer.append("\n");
                ++n2;
            }
            MultiLineLabel multiLineLabel = new MultiLineLabel(fastStringBuffer.toString());
            JScrollPane jScrollPane = new JScrollPane((Component)multiLineLabel);
            jPanel.add((Component)jScrollPane, new GridBagConstraints(0, n++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 25, 0, 5), 0, 0));
            jPanel.add((Component)this.groupNameLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)this.groupNameTextField, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        } else if (this.breakpoints != null) {
            JLabel jLabel = new JLabel(DbgArb.getString(507));
            this.groupNameCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.groupNameCheckBox, (String)DbgArb.getString(508));
            this.groupNameLabel = new JLabel();
            this.groupNameHistoryList = Ide.loadHistoryList((String)groupNameHistoryName);
            this.groupNameComboBox = new JComboBox<String>(this.groupNameHistoryList.getHistory());
            this.groupNameEditor = (JTextField)this.groupNameComboBox.getEditor().getEditorComponent();
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameEditor, (String)DbgArb.getString(509));
            this.groupNameComboBox.setEditable(true);
            String string = this.bp.getGroupName();
            IdeUtil.comboBoxSelectItem((JComboBox)this.groupNameComboBox, (Object)string);
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameTextField, (String)DbgArb.getString(509));
            this.groupNameCheckBox.setSelected(false);
            this.groupNameLabel.setEnabled(false);
            this.groupNameComboBox.setEnabled(false);
            jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n3 = 0;
            while (n3 < this.breakpoints.length) {
                fastStringBuffer.append(this.breakpoints[n3].getDescription());
                fastStringBuffer.append("\n");
                ++n3;
            }
            MultiLineLabel multiLineLabel = new MultiLineLabel(fastStringBuffer.toString());
            JScrollPane jScrollPane = new JScrollPane((Component)multiLineLabel);
            jPanel.add((Component)jScrollPane, new GridBagConstraints(0, n++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 25, 0, 5), 0, 0));
            jPanel.add((Component)this.groupNameCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)this.groupNameLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)this.groupNameComboBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        } else {
            this.groupNameLabel = new JLabel();
            this.groupNameHistoryList = Ide.loadHistoryList((String)groupNameHistoryName);
            this.groupNameComboBox = new JComboBox<String>(this.groupNameHistoryList.getHistory());
            this.groupNameEditor = (JTextField)this.groupNameComboBox.getEditor().getEditorComponent();
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameEditor, (String)DbgArb.getString(509));
            this.groupNameComboBox.setEditable(true);
            String string = this.bp == null ? "" : this.bp.getGroupName();
            IdeUtil.comboBoxSelectItem((JComboBox)this.groupNameComboBox, (Object)string);
            jPanel.add((Component)this.makeTypePanel(), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)this.makeCardPanel(), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)new JLabel(), new GridBagConstraints(0, n++, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)this.groupNameLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)this.groupNameComboBox, new GridBagConstraints(0, n, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        return jPanel;
    }

    private BreakpointTypeItem getBreakpointTypeItem(int n) {
        int n2 = this.types.length - 1;
        while (n2 >= 0) {
            if (this.types[n2].breakpointType == n) {
                return this.types[n2];
            }
            --n2;
        }
        return null;
    }

    private JPanel makeTypePanel() {
        JLabel jLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.typeComboBox, (String)DbgArb.getString(462));
        this.typeComboBox.setModel(new NonNullableComboBoxModel((Object[])this.types));
        BreakpointTypeItem breakpointTypeItem = this.getBreakpointTypeItem(this.currentType);
        if (breakpointTypeItem != null) {
            this.typeComboBox.setSelectedItem(breakpointTypeItem);
        }
        if (this.bp != null) {
            this.typeComboBox.setEnabled(false);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.typeComboBox, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private CardPanel makeCardPanel() {
        this.definitionCardPanel = new CardPanel();
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            this.definitionCardPanel.add((Component)this.types[n2].panel, Integer.toString(this.types[n2].breakpointType));
            ++n2;
        }
        this.definitionCardPanel.showCard(Integer.toString(this.currentType));
        return this.definitionCardPanel;
    }

    private JPanel makePackageFileLineCard() {
        String string;
        String string2;
        String string3;
        if (this.bp != null && this.currentType == 0) {
            string3 = this.bp.getPackage();
            string2 = this.bp.getFile();
            string = Integer.toString(this.bp.getLine());
        } else {
            string = "";
            string2 = "";
            string3 = "";
        }
        JLabel jLabel = new JLabel();
        this.packageHistoryList = Ide.loadHistoryList((String)packageHistoryName);
        this.packageComboBox = new JComboBox<String>(this.packageHistoryList.getHistory());
        this.packageComboBox.setEditable(true);
        this.packageEditor = (JTextField)this.packageComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.packageEditor, (String)DbgArb.getString(480));
        IdeUtil.comboBoxSelectItem((JComboBox)this.packageComboBox, (Object)string3);
        JLabel jLabel2 = new JLabel();
        this.fileHistoryList = Ide.loadHistoryList((String)fileHistoryName);
        this.fileComboBox = new JComboBox<String>(this.fileHistoryList.getHistory());
        this.fileComboBox.setEditable(true);
        this.fileEditor = (JTextField)this.fileComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fileEditor, (String)DbgArb.getString(481));
        IdeUtil.comboBoxSelectItem((JComboBox)this.fileComboBox, (Object)string2);
        JLabel jLabel3 = new JLabel();
        this.lineTextField = new JTextField(string, 6);
        this.lineTextField.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.lineTextField, (String)DbgArb.getString(482));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel4 = new JLabel(DbgArb.getString(465));
        int n = 0;
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.packageComboBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.fileComboBox, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        jPanel.add((Component)this.lineTextField, new GridBagConstraints(1, n, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeMethodCard() {
        String string = this.bp != null && this.currentType == 1 ? this.bp.getMethod() : "";
        JLabel jLabel = new JLabel();
        this.methodHistoryList = Ide.loadHistoryList((String)methodHistoryName);
        this.methodComboBox = new JComboBox<String>(this.methodHistoryList.getHistory());
        this.methodComboBox.setEditable(true);
        this.methodEditor = (JTextField)this.methodComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.methodEditor, (String)DbgArb.getString(483));
        JLabel jLabel2 = new JLabel(DbgArb.getString(484));
        JLabel jLabel3 = new JLabel(DbgArb.getString(485));
        JLabel jLabel4 = new JLabel(DbgArb.getString(486));
        IdeUtil.comboBoxSelectItem((JComboBox)this.methodComboBox, (Object)string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel5 = new JLabel(DbgArb.getString(467));
        int n = 0;
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.methodComboBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(1, n, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeMethodOffsetCard() {
        JLabel jLabel = new JLabel();
        JTextField jTextField = new JTextField(this.bp.getMethod());
        jTextField.setEditable(false);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)DbgArb.getString(487));
        JLabel jLabel2 = new JLabel();
        JTextField jTextField2 = new JTextField(Integer.toString(this.bp.getOffset()), 6);
        jTextField2.setEditable(false);
        jTextField2.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)jTextField2, (String)DbgArb.getString(488));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(DbgArb.getString(469));
        int n = 0;
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)jTextField2, new GridBagConstraints(1, n, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeExceptionCard() {
        boolean bl;
        boolean bl2;
        String string;
        if (this.bp != null && this.currentType == 2) {
            string = this.bp.getException();
            bl2 = this.bp.isCaught();
            bl = this.bp.isUncaught();
        } else {
            string = "";
            bl2 = true;
            bl = true;
        }
        JLabel jLabel = new JLabel();
        this.exceptionHistoryList = Ide.loadHistoryList((String)exceptionHistoryName);
        if (this.exceptionHistoryList.getSize() == 0) {
            String[] stringArray = new String[]{"java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.ArrayStoreException", "java.lang.ClassCastException", "java.lang.Exception", "java.lang.IllegalAccessException", "java.lang.IllegalArgumentException", "java.lang.IllegalStateException", "java.lang.IndexOutOfBoundsException", "java.lang.NumberFormatException", "java.lang.RuntimeException", "java.lang.SecurityException", "java.lang.StringIndexOutOfBoundsException", "java.lang.UnsupportedOperationException", "java.lang.Error", "java.lang.Throwable", "oracle.jbo.JboException", "$Oracle.EXCEPTION_ORA_6502"};
            this.exceptionHistoryList.fill(stringArray);
        }
        this.exceptionComboBox = new JComboBox<String>(this.exceptionHistoryList.getHistory());
        this.exceptionComboBox.setEditable(true);
        this.exceptionEditor = (JTextField)this.exceptionComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.exceptionEditor, (String)DbgArb.getString(489));
        JLabel jLabel2 = new JLabel(DbgArb.getString(490));
        JLabel jLabel3 = new JLabel(DbgArb.getString(491));
        IdeUtil.comboBoxSelectItem((JComboBox)this.exceptionComboBox, (Object)string);
        this.exceptionBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.exceptionBrowseButton, (String)DbgArb.getString(492));
        this.caughtCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.caughtCheckBox, (String)DbgArb.getString(493));
        this.caughtCheckBox.setSelected(bl2);
        this.uncaughtCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.uncaughtCheckBox, (String)DbgArb.getString(494));
        this.uncaughtCheckBox.setSelected(bl);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel4 = new JLabel(DbgArb.getString(471));
        int n = 0;
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.exceptionComboBox, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        if (!Product.isRaptor()) {
            jPanel.add((Component)this.exceptionBrowseButton, new GridBagConstraints(2, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.caughtCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.uncaughtCheckBox, new GridBagConstraints(0, n, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeDeadlockCard() {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    private JPanel makeClassCard() {
        String string = this.bp != null && this.currentType == 4 ? this.bp.getClassName() : "";
        JLabel jLabel = new JLabel();
        this.classHistoryList = Ide.loadHistoryList((String)classHistoryName);
        this.classComboBox = new JComboBox<String>(this.classHistoryList.getHistory());
        this.classComboBox.setEditable(true);
        this.classEditor = (JTextField)this.classComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.classEditor, (String)DbgArb.getString(495));
        JLabel jLabel2 = new JLabel(DbgArb.getString(490));
        JLabel jLabel3 = new JLabel(DbgArb.getString(496));
        IdeUtil.comboBoxSelectItem((JComboBox)this.classComboBox, (Object)string);
        this.classBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.classBrowseButton, (String)DbgArb.getString(497));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel4 = new JLabel(DbgArb.getString(475));
        int n = 0;
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.classComboBox, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.classBrowseButton, new GridBagConstraints(2, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, n, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeURLLineCard() {
        String string;
        URL uRL;
        if (this.bp != null && this.currentType == 5) {
            uRL = this.bp.getURL();
            string = Integer.toString(this.bp.getLine());
        } else {
            uRL = null;
            string = "";
        }
        JLabel jLabel = new JLabel();
        this.urlTextField = new URLTextField(uRL, false, false);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.urlTextField, (String)DbgArb.getString(498));
        this.urlBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.urlBrowseButton, (String)DbgArb.getString(499));
        JLabel jLabel2 = new JLabel();
        this.lineTextField2 = new JTextField(string, 6);
        this.lineTextField2.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.lineTextField2, (String)DbgArb.getString(482));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(DbgArb.getString(477));
        int n = 0;
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.urlTextField, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.urlBrowseButton, new GridBagConstraints(2, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.lineTextField2, new GridBagConstraints(1, n, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeWatchpointCard() {
        boolean bl;
        boolean bl2;
        String string;
        String string2;
        if (this.bp != null && this.currentType == 6) {
            string2 = this.bp.getClassName();
            string = this.bp.getFieldName();
            bl2 = this.bp.isAccess();
            bl = this.bp.isModify();
        } else {
            string2 = "";
            string = "";
            bl2 = false;
            bl = true;
        }
        JLabel jLabel = new JLabel();
        this.watchpointClassHistoryList = Ide.loadHistoryList((String)watchpointClassHistoryName);
        this.watchpointClassComboBox = new JComboBox<String>(this.watchpointClassHistoryList.getHistory());
        this.watchpointClassComboBox.setEditable(true);
        this.watchpointClassEditor = (JTextField)this.watchpointClassComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.watchpointClassEditor, (String)DbgArb.getString(500));
        JLabel jLabel2 = new JLabel(DbgArb.getString(490));
        JLabel jLabel3 = new JLabel(DbgArb.getString(501));
        IdeUtil.comboBoxSelectItem((JComboBox)this.watchpointClassComboBox, (Object)string2);
        this.watchpointClassBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.watchpointClassBrowseButton, (String)DbgArb.getString(502));
        JLabel jLabel4 = new JLabel();
        this.watchpointFieldHistoryList = Ide.loadHistoryList((String)watchpointFieldHistoryName);
        this.watchpointFieldComboBox = new JComboBox<String>(this.watchpointFieldHistoryList.getHistory());
        this.watchpointFieldComboBox.setEditable(true);
        this.watchpointFieldEditor = (JTextField)this.watchpointFieldComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.watchpointFieldEditor, (String)DbgArb.getString(503));
        IdeUtil.comboBoxSelectItem((JComboBox)this.watchpointFieldComboBox, (Object)string);
        this.accessCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.accessCheckBox, (String)DbgArb.getString(504));
        this.accessCheckBox.setSelected(bl2);
        this.modifyCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.modifyCheckBox, (String)DbgArb.getString(505));
        this.modifyCheckBox.setSelected(bl);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel5 = new JLabel(DbgArb.getString(479));
        int n = 0;
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.watchpointClassComboBox, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.watchpointClassBrowseButton, new GridBagConstraints(2, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.watchpointFieldComboBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.accessCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.modifyCheckBox, new GridBagConstraints(0, n, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeConditionsPane() {
        int n;
        String string;
        if (this.bp != null) {
            string = this.bp.getCondition();
            n = this.bp.getPassCount();
        } else {
            string = "";
            n = 1;
        }
        JLabel jLabel = new JLabel();
        this.conditionHistoryList = Ide.loadHistoryList((String)conditionHistoryName);
        this.conditionComboBox = new JComboBox<String>(this.conditionHistoryList.getHistory());
        this.conditionComboBox.setEditable(true);
        this.conditionEditor = (JTextField)this.conditionComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.conditionEditor, (String)DbgArb.getString(510));
        IdeUtil.comboBoxSelectItem((JComboBox)this.conditionComboBox, (Object)string);
        JPanel jPanel = this.makeThreadPanel();
        JLabel jLabel2 = new JLabel();
        this.passCountBox = new NumericSpinBox(1, Integer.MAX_VALUE);
        this.passCountBox.setIntValue(n);
        SpinBuddy spinBuddy = this.passCountBox.getSpinBuddy();
        if (spinBuddy instanceof JTextField) {
            ((JTextField)spinBuddy).setHorizontalAlignment(4);
        }
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.passCountBox, (String)DbgArb.getString(515));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n2 = 0;
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel2.add((Component)this.conditionComboBox, new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        jPanel2.add((Component)this.passCountBox, new GridBagConstraints(1, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        jPanel2.add((Component)new JLabel(), new GridBagConstraints(0, n2, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel2;
    }

    private JPanel makeThreadPanel() {
        String string;
        String string2;
        if (this.bp != null) {
            string2 = this.bp.getThreadName();
            string = this.bp.getThreadNameNot();
        } else {
            string2 = "";
            string = "";
        }
        this.radioAllThreads = new JRadioButton();
        this.radioOneThread = new JRadioButton();
        this.radioNotThread = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radioAllThreads, (String)DbgArb.getString(512));
        ResourceUtils.resButton((AbstractButton)this.radioOneThread, (String)DbgArb.getString(513));
        ResourceUtils.resButton((AbstractButton)this.radioNotThread, (String)DbgArb.getString(514));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioAllThreads);
        buttonGroup.add(this.radioOneThread);
        buttonGroup.add(this.radioNotThread);
        this.threadHistoryList = Ide.loadHistoryList((String)threadHistoryName);
        this.threadComboBox = new JComboBox<String>(this.threadHistoryList.getHistory());
        this.threadComboBox.setEditable(true);
        this.threadEditor = (JTextField)this.threadComboBox.getEditor().getEditorComponent();
        this.threadEditor.getAccessibleContext().setAccessibleName(this.radioOneThread.getText());
        IdeUtil.comboBoxSelectItem((JComboBox)this.threadComboBox, (Object)string2);
        this.notThreadHistoryList = Ide.loadHistoryList((String)notThreadHistoryName);
        this.notThreadComboBox = new JComboBox<String>(this.notThreadHistoryList.getHistory());
        this.notThreadComboBox.setEditable(true);
        this.notThreadEditor = (JTextField)this.notThreadComboBox.getEditor().getEditorComponent();
        this.notThreadEditor.getAccessibleContext().setAccessibleName(this.radioNotThread.getText());
        IdeUtil.comboBoxSelectItem((JComboBox)this.notThreadComboBox, (Object)string);
        if (string2.length() > 0) {
            this.radioOneThread.setSelected(true);
        } else if (string.length() > 0) {
            this.radioNotThread.setSelected(true);
        } else {
            this.radioAllThreads.setSelected(true);
        }
        this.threadComboBox.setEnabled(this.radioOneThread.isSelected());
        this.notThreadComboBox.setEnabled(this.radioNotThread.isSelected());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(DbgArb.getString(511));
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.radioAllThreads, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.radioOneThread, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.threadComboBox, new GridBagConstraints(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.radioNotThread, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.notThreadComboBox, new GridBagConstraints(1, n, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeActionsPane(String[] stringArray) {
        this.bpActionsPanel = new BreakpointActionsPanel(stringArray, true, this);
        this.bpActionsPanel.loadFrom(this.bp, BreakpointsWindowSettings.getInstance());
        return this.bpActionsPanel;
    }

    void typeChanged() {
        switch (this.currentType) {
            case 0: 
            case 5: {
                this.bpActionsPanel.setLog(false);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.bpActionsPanel.setLog(true);
            }
        }
    }

    void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    private boolean canOk() {
        String string = this.anythingInvalidInDefinition();
        if (string != null) {
            return false;
        }
        string = this.anythingInvalidInConditions();
        if (string != null) {
            return false;
        }
        string = this.anythingInvalidInActions();
        return string == null;
    }

    private String anythingInvalidInDefinition() {
        if (this.group != null) {
            String string = this.groupNameTextField.getText();
            if (string.length() == 0) {
                return DbgArb.getString(525);
            }
            if (!string.equals(this.bp.getGroupName())) {
                int n = this.groupNames.length;
                int n2 = 0;
                while (n2 < n) {
                    if (string.equals(this.groupNames[n2])) {
                        return DbgArb.getString(526);
                    }
                    ++n2;
                }
            }
        } else if (this.breakpoints != null) {
            if (this.groupNameCheckBox.isSelected() && this.groupNameEditor.getText().length() == 0) {
                return DbgArb.getString(525);
            }
        } else {
            switch (this.currentType) {
                case 0: {
                    if (this.fileEditor.getText().length() == 0) {
                        return DbgArb.getString(527);
                    }
                    try {
                        int n = Integer.parseInt(this.lineTextField.getText());
                        if (n < 1) {
                            String string = DbgArb.getString(528);
                            return string;
                        }
                        break;
                    }
                    catch (Exception exception) {
                        String string = DbgArb.getString(528);
                        return string;
                    }
                }
                case 1: {
                    if (this.methodEditor.getText().length() == 0) {
                        return DbgArb.getString(529);
                    }
                    break;
                }
                case 4: {
                    if (this.classEditor.getText().length() == 0) {
                        return DbgArb.getString(530);
                    }
                    break;
                }
                case 5: {
                    if (this.urlTextField.getURL() == null) {
                        return DbgArb.getString(531);
                    }
                    try {
                        int n = Integer.parseInt(this.lineTextField2.getText());
                        if (n < 1) {
                            String string = DbgArb.getString(528);
                            return string;
                        }
                        break;
                    }
                    catch (Exception exception) {
                        String string = DbgArb.getString(528);
                        return string;
                    }
                }
                case 6: {
                    if (this.watchpointClassEditor.getText().length() == 0) {
                        return DbgArb.getString(530);
                    }
                    if (this.watchpointFieldEditor.getText().length() != 0) break;
                    return DbgArb.getString(532);
                }
            }
        }
        return null;
    }

    private String anythingInvalidInConditions() {
        String string = this.conditionEditor.getText();
        if (string.length() > 0 && !Evaluator.validate(string)) {
            return DbgArb.getString(533);
        }
        if (this.radioOneThread.isSelected() && this.threadEditor.getText().length() == 0) {
            return DbgArb.getString(534);
        }
        if (this.radioNotThread.isSelected() && this.notThreadEditor.getText().length() == 0) {
            return DbgArb.getString(535);
        }
        return null;
    }

    private String anythingInvalidInActions() {
        return this.bpActionsPanel.anythingInvalid();
    }

    Breakpoint getBreakpoint() {
        return this.bp;
    }

    private void doOk() {
        if (this.group != null) {
            int n = this.group.length;
            int n2 = 0;
            while (n2 < n) {
                Breakpoint breakpoint = this.group[n2];
                breakpoint.setShallow(true);
                this.doOkForDefinition(breakpoint);
                this.doOkForConditions(breakpoint);
                this.doOkForActions(breakpoint);
                breakpoint.setShallow(false);
                ++n2;
            }
        } else if (this.breakpoints != null) {
            int n = this.breakpoints.length;
            int n3 = 0;
            while (n3 < n) {
                Breakpoint breakpoint = this.breakpoints[n3];
                breakpoint.setShallow(true);
                this.doOkForDefinition(breakpoint);
                this.doOkForConditions(breakpoint);
                this.doOkForActions(breakpoint);
                breakpoint.setShallow(false);
                ++n3;
            }
        } else {
            this.bp = this.doOkForDefinition(this.bp);
            this.doOkForConditions(this.bp);
            this.doOkForActions(this.bp);
            this.bp.setShallow(false);
        }
    }

    private boolean veto() {
        RunConfiguration runConfiguration;
        if (XSLTRunnerAddin.isXSLTDebuggingSupported() && this.bp == null && this.currentType != 5 && this.jproject != null && (runConfiguration = RunConfiguration.getInstance((PropertyStorage)this.jproject)) != null) {
            URL uRL = runConfiguration.getTargetURL();
            try {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                if (node instanceof XMLSourceNode && XSLTRunnerAddin.isXSLT((XMLSourceNode)node)) {
                    boolean bl = this.showXSLTMessage(this.currentType) ^ true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        switch (this.currentType) {
            case 2: {
                String string;
                String string2 = this.exceptionEditor.getText();
                if (string2.length() <= 0 || string2.startsWith("$Oracle.") || this.findClass(string2)) break;
                if (string2.indexOf(46) == -1 && this.findClass(string = "java.lang." + string2)) {
                    this.exceptionEditor.setText(string);
                    return false;
                }
                return this.showClassNotFoundMessage(string2) ^ true;
            }
            case 4: {
                String string = this.classEditor.getText();
                if (string.length() <= 0 || this.findClass(string)) break;
                return this.showClassNotFoundMessage(string) ^ true;
            }
            case 1: {
                String string = this.methodEditor.getText();
                if (string.length() <= 0 || this.findMethod(string)) break;
                return this.showMethodNotFoundMessage(string) ^ true;
            }
            case 6: {
                String string = this.watchpointClassEditor.getText();
                if (string.length() > 0 && !this.findClass(string)) {
                    return this.showClassNotFoundMessage(string) ^ true;
                }
                String string3 = this.watchpointFieldEditor.getText();
                if (string3.length() <= 0 || this.findField(string, string3)) break;
                return this.showFieldNotFoundMessage(string, string3) ^ true;
            }
        }
        return false;
    }

    private Breakpoint doOkForDefinition(Breakpoint breakpoint) {
        if (this.group != null) {
            breakpoint.setGroupName(this.groupNameTextField.getText());
        } else if (this.breakpoints != null) {
            if (this.groupNameCheckBox.isSelected()) {
                breakpoint.setGroupName(this.groupNameHistoryList.comboBoxGetSelectedItem(this.groupNameEditor));
            }
        } else {
            if (breakpoint != null) {
                breakpoint.setShallow(true);
                switch (this.currentType) {
                    case 0: {
                        breakpoint.setPackageFileLine(this.packageHistoryList.comboBoxGetSelectedItem(this.packageEditor), this.fileHistoryList.comboBoxGetSelectedItem(this.fileEditor), Integer.parseInt(this.lineTextField.getText()));
                        break;
                    }
                    case 1: {
                        breakpoint.setMethod(this.methodHistoryList.comboBoxGetSelectedItem(this.methodEditor));
                        break;
                    }
                    case 2: {
                        if (this.exceptionEditor.getText().length() == 0) {
                            this.exceptionEditor.setText("java.lang.Throwable");
                        }
                        breakpoint.setException(this.exceptionHistoryList.comboBoxGetSelectedItem(this.exceptionEditor), this.caughtCheckBox.isSelected(), this.uncaughtCheckBox.isSelected());
                        break;
                    }
                    case 4: {
                        breakpoint.setClassName(this.classHistoryList.comboBoxGetSelectedItem(this.classEditor));
                        break;
                    }
                    case 5: {
                        breakpoint.setURLLine(this.urlTextField.getURL(), Integer.parseInt(this.lineTextField2.getText()));
                        break;
                    }
                    case 6: {
                        breakpoint.setWatchpoint(this.watchpointClassHistoryList.comboBoxGetSelectedItem(this.watchpointClassEditor), this.watchpointFieldHistoryList.comboBoxGetSelectedItem(this.watchpointFieldEditor), this.accessCheckBox.isSelected(), this.modifyCheckBox.isSelected());
                    }
                }
            } else {
                lastType = this.currentType;
                switch (this.currentType) {
                    case 0: {
                        breakpoint = new Breakpoint(this.ownerURL, this.currentType, this.packageHistoryList.comboBoxGetSelectedItem(this.packageEditor), this.fileHistoryList.comboBoxGetSelectedItem(this.fileEditor), Integer.parseInt(this.lineTextField.getText()));
                        break;
                    }
                    case 1: {
                        breakpoint = new Breakpoint(this.ownerURL, this.currentType, this.methodHistoryList.comboBoxGetSelectedItem(this.methodEditor));
                        break;
                    }
                    case 2: {
                        if (this.exceptionEditor.getText().length() == 0) {
                            this.exceptionEditor.setText("java.lang.Throwable");
                        }
                        breakpoint = new Breakpoint(this.ownerURL, this.currentType, this.exceptionHistoryList.comboBoxGetSelectedItem(this.exceptionEditor), this.caughtCheckBox.isSelected(), this.uncaughtCheckBox.isSelected());
                        break;
                    }
                    case 4: {
                        breakpoint = new Breakpoint(this.ownerURL, this.currentType, this.classHistoryList.comboBoxGetSelectedItem(this.classEditor));
                        break;
                    }
                    case 5: {
                        breakpoint = new Breakpoint(this.ownerURL, this.currentType, this.urlTextField.getURL(), Integer.parseInt(this.lineTextField2.getText()));
                        break;
                    }
                    case 6: {
                        breakpoint = new Breakpoint(this.ownerURL, this.currentType, this.watchpointClassHistoryList.comboBoxGetSelectedItem(this.watchpointClassEditor), this.watchpointFieldHistoryList.comboBoxGetSelectedItem(this.watchpointFieldEditor), this.accessCheckBox.isSelected(), this.modifyCheckBox.isSelected());
                    }
                }
                breakpoint.setShallow(true);
            }
            breakpoint.setGroupName(this.groupNameHistoryList.comboBoxGetSelectedItem(this.groupNameEditor));
        }
        return breakpoint;
    }

    private void doOkForConditions(Breakpoint breakpoint) {
        breakpoint.setCondition(this.conditionHistoryList.comboBoxGetSelectedItem(this.conditionEditor));
        if (this.radioOneThread.isSelected()) {
            breakpoint.setThreadName(this.threadHistoryList.comboBoxGetSelectedItem(this.threadEditor));
        } else {
            breakpoint.setThreadName(null);
        }
        if (this.radioNotThread.isSelected()) {
            breakpoint.setThreadNameNot(this.notThreadHistoryList.comboBoxGetSelectedItem(this.notThreadEditor));
        } else {
            breakpoint.setThreadNameNot(null);
        }
        breakpoint.setPassCount(this.passCountBox.getIntValue());
    }

    private void doOkForActions(Breakpoint breakpoint) {
        this.bpActionsPanel.commitTo(breakpoint, BreakpointsWindowSettings.getInstance());
    }

    public void cancel() {
        this.setVisible(false);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.tabbedPane.getSelectedComponent();
        String string = component == this.definitionPane ? "f1_deb_new_edit_breakptdialog_html" : (component == this.conditionsPane ? "f1_deb_new_edit_breakpt_conditions_html" : (component == this.actionsPane ? "f1_deb_new_edit_breakpt_actions_html" : "f1_deb_new_edit_breakptdialog_html"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.radioAllThreads) {
            this.threadComboBox.setEnabled(false);
            this.notThreadComboBox.setEnabled(false);
        } else if (object == this.radioOneThread) {
            this.threadComboBox.setEnabled(true);
            this.notThreadComboBox.setEnabled(false);
        } else if (object == this.radioNotThread) {
            this.threadComboBox.setEnabled(false);
            this.notThreadComboBox.setEnabled(true);
        } else if (object == this.exceptionBrowseButton) {
            JavaManager javaManager = JavaManager.getJavaManager(this.jproject);
            JavaClass javaClass = javaManager.getClass("java.lang.Throwable");
            1 var5_5 = new 1(this, javaClass);
            String string = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.jproject, 2, var5_5);
            if (string != null) {
                this.exceptionEditor.setText(string);
            }
        } else if (object == this.classBrowseButton) {
            String string = ClassPackageBrowserV2.browseClassOrPackage(this, this.jproject, 2);
            if (string != null) {
                this.classEditor.setText(string);
            }
        } else if (object == this.watchpointClassBrowseButton) {
            String string = ClassPackageBrowserV2.browseClassOrPackage(this, this.jproject, 2);
            if (string != null) {
                this.watchpointClassEditor.setText(string);
            }
        } else if (object == this.groupNameComboBox) {
            this.groupNameEditor.setText((String)this.groupNameComboBox.getSelectedItem());
        } else if (object == this.packageComboBox) {
            this.packageEditor.setText((String)this.packageComboBox.getSelectedItem());
        } else if (object == this.fileComboBox) {
            this.fileEditor.setText((String)this.fileComboBox.getSelectedItem());
        } else if (object == this.methodComboBox) {
            this.methodEditor.setText((String)this.methodComboBox.getSelectedItem());
        } else if (object == this.exceptionComboBox) {
            this.exceptionEditor.setText((String)this.exceptionComboBox.getSelectedItem());
        } else if (object == this.classComboBox) {
            this.classEditor.setText((String)this.classComboBox.getSelectedItem());
        } else if (object == this.groupNameComboBox) {
            this.groupNameEditor.setText((String)this.groupNameComboBox.getSelectedItem());
        } else if (object == this.conditionComboBox) {
            this.conditionEditor.setText((String)this.conditionComboBox.getSelectedItem());
        } else if (object == this.threadComboBox) {
            this.threadEditor.setText((String)this.threadComboBox.getSelectedItem());
        } else if (object == this.notThreadComboBox) {
            this.notThreadEditor.setText((String)this.notThreadComboBox.getSelectedItem());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOk();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOk();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOk();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.typeComboBox) {
            BreakpointTypeItem breakpointTypeItem = (BreakpointTypeItem)this.typeComboBox.getSelectedItem();
            this.currentType = breakpointTypeItem.breakpointType;
            this.definitionCardPanel.showCard(Integer.toString(this.currentType));
            this.typeChanged();
            this.enableOk();
        } else if (object == this.groupNameCheckBox) {
            boolean bl = this.groupNameCheckBox.isSelected();
            this.groupNameLabel.setEnabled(bl);
            this.groupNameComboBox.setEnabled(bl);
            this.enableOk();
        } else if (object == this.radioAllThreads || object == this.radioOneThread || object == this.radioNotThread) {
            this.enableOk();
        }
    }

    static boolean mav$veto(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.veto();
    }

    static void mav$doOk(BreakpointOptionsDialog breakpointOptionsDialog) {
        breakpointOptionsDialog.doOk();
    }

    static JPanel mav$makePackageFileLineCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makePackageFileLineCard();
    }

    static JPanel mav$makeExceptionCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeExceptionCard();
    }

    static JPanel mav$makeMethodCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeMethodCard();
    }

    static JPanel mav$makeMethodOffsetCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeMethodOffsetCard();
    }

    static JPanel mav$makeClassCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeClassCard();
    }

    static JPanel mav$makeURLLineCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeURLLineCard();
    }

    static JPanel mav$makeDeadlockCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeDeadlockCard();
    }

    static JPanel mav$makeWatchpointCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeWatchpointCard();
    }

    final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                if (BreakpointOptionsDialog.mav$veto(BreakpointOptionsDialog.this)) {
                    throw new PropertyVetoException("no", propertyChangeEvent);
                }
                BreakpointOptionsDialog.mav$doOk(BreakpointOptionsDialog.this);
            }
        }
    }

    private class BreakpointTypeItem {
        final int breakpointType;
        final String name;
        final JPanel panel;

        BreakpointTypeItem(int n) {
            this.breakpointType = n;
            switch (n) {
                default: {
                    this.name = DbgArb.getString(463);
                    this.panel = BreakpointOptionsDialog.mav$makePackageFileLineCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 2: {
                    this.name = DbgArb.getString(470);
                    this.panel = BreakpointOptionsDialog.mav$makeExceptionCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 1: {
                    this.name = DbgArb.getString(466);
                    this.panel = BreakpointOptionsDialog.mav$makeMethodCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 7: {
                    this.name = DbgArb.getString(468);
                    this.panel = BreakpointOptionsDialog.mav$makeMethodOffsetCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 4: {
                    this.name = DbgArb.getString(474);
                    this.panel = BreakpointOptionsDialog.mav$makeClassCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 5: {
                    this.name = DbgArb.getString(476);
                    this.panel = BreakpointOptionsDialog.mav$makeURLLineCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 3: {
                    this.name = DbgArb.getString(472);
                    this.panel = BreakpointOptionsDialog.mav$makeDeadlockCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 6: {
                    this.name = DbgArb.getString(478);
                    this.panel = BreakpointOptionsDialog.mav$makeWatchpointCard(BreakpointOptionsDialog.this);
                }
            }
        }

        public String toString() {
            return this.name;
        }
    }

    final class 1
    implements ClassPackageBrowserFilterV2 {
        private final /* synthetic */ JavaClass v$throwableClass;
        final /* synthetic */ BreakpointOptionsDialog this$0;

        public boolean acceptPackage(String string) {
            return true;
        }

        public boolean acceptClass(JavaClass javaClass) {
            if (this.v$throwableClass != null) {
                return this.v$throwableClass.isAssignableFrom((JavaType)javaClass);
            }
            return true;
        }

        public 1(BreakpointOptionsDialog breakpointOptionsDialog, JavaClass javaClass) {
            this.v$throwableClass = javaClass;
            this.this$0 = breakpointOptionsDialog;
        }
    }

    private final class CardPanel
    extends JPanel
    implements LayoutManager {
        public CardPanel() {
            this.setLayout(this);
        }

        public void addLayoutComponent(String string, Component component) {
            if (string != null) {
                component.setName(string);
            }
            component.setVisible(component.getParent().getComponentCount() == 1);
        }

        public void removeLayoutComponent(Component component) {
            Container container;
            if (component.isVisible() && (container = component.getParent()).getComponentCount() > 0) {
                container.getComponent(0).setVisible(true);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            int n4 = 0;
            while (n4 < n) {
                Dimension dimension = container.getComponent(n4).getPreferredSize();
                if (dimension.width + insets.left + insets.right > n2) {
                    n2 = dimension.width + insets.left + insets.right;
                }
                if (dimension.height + insets.top + insets.bottom > n3) {
                    n3 = dimension.height + insets.top + insets.bottom;
                }
                ++n4;
            }
            return new Dimension(n2, n3);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            int n4 = 0;
            while (n4 < n) {
                Dimension dimension = container.getComponent(n4).getMinimumSize();
                if (dimension.width + insets.left + insets.right > n2) {
                    n2 = dimension.width + insets.left + insets.right;
                }
                if (dimension.height + insets.top + insets.bottom > n3) {
                    n3 = dimension.height + insets.top + insets.bottom;
                }
                ++n4;
            }
            return new Dimension(n2, n3);
        }

        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.isVisible()) {
                    Rectangle rectangle = container.getBounds();
                    int n3 = rectangle.width - insets.left + insets.right;
                    int n4 = rectangle.height - insets.top + insets.bottom;
                    Dimension dimension = component.getPreferredSize();
                    if (dimension.height < n4) {
                        n4 = dimension.height;
                    }
                    component.setBounds(insets.left, insets.top, n3, n4);
                    break;
                }
                ++n2;
            }
        }

        public void showCard(String string) {
            int n = this.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = this.getComponent(n2);
                if (component.getName().equals(string)) {
                    component.setVisible(true);
                } else if (component.isVisible()) {
                    component.setVisible(false);
                }
                ++n2;
            }
            this.revalidate();
            this.repaint();
        }
    }
}

