/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;

public final class BreakpointSettings
implements Copyable {
    static final int BP_PACKAGE_FILE_LINE = 0;
    static final int BP_METHOD = 1;
    static final int BP_EXCEPTION = 2;
    static final int BP_DEADLOCK = 3;
    static final int BP_CLASS = 4;
    static final int BP_URL_LINE = 5;
    static final int BP_WATCHPOINT = 6;
    static final int BP_METHOD_OFFSET = 7;
    private URL _ownerURL;
    private boolean _persistent;
    private int _type;
    private String _pkg;
    private String _file;
    private int _line;
    private String _method;
    private int _offset;
    private String _exception;
    private boolean _caught;
    private boolean _uncaught;
    private String _className;
    private URL _url;
    private String _fieldName;
    private boolean _access;
    private boolean _modify;
    private boolean _enabled;
    private String _groupName;
    private String _condition;
    private String _threadName;
    private String _threadNameNot;
    private int _passCount;
    private boolean _actionHalt;
    private boolean _actionBeep;
    private boolean _actionLog;
    private String _actionLogTag;
    private String _actionLogExpr;
    private boolean _actionLogStack;
    private String _actionEnableOther;
    private String _actionDisableOther;

    public BreakpointSettings() {
        this.defaultInit();
    }

    public BreakpointSettings(BreakpointSettings breakpointSettings) {
        if (breakpointSettings == null) {
            this.defaultInit();
        } else {
            breakpointSettings.copyToImpl(this);
        }
    }

    private void defaultInit() {
        this._ownerURL = null;
        this._persistent = false;
        this._type = -1;
        this._method = null;
        this._offset = -1;
        this._pkg = null;
        this._file = null;
        this._line = 0;
        this._exception = null;
        this._caught = false;
        this._uncaught = false;
        this._className = null;
        this._url = null;
        this._fieldName = null;
        this._access = false;
        this._modify = false;
        this._enabled = true;
        this._groupName = "";
        this._condition = "";
        this._threadName = "";
        this._threadNameNot = "";
        this._passCount = 1;
        this._actionHalt = false;
        this._actionBeep = false;
        this._actionLog = false;
        this._actionLogTag = "";
        this._actionLogExpr = "";
        this._actionLogStack = false;
        this._actionEnableOther = "";
        this._actionDisableOther = "";
    }

    void setActions() {
        BreakpointsWindowSettings breakpointsWindowSettings = BreakpointsWindowSettings.getInstance();
        this._actionHalt = breakpointsWindowSettings.getDefaultActionHalt();
        this._actionBeep = breakpointsWindowSettings.getDefaultActionBeep();
        this._actionLog = breakpointsWindowSettings.getDefaultActionLog();
        this._actionLogTag = breakpointsWindowSettings.getDefaultActionLogTag();
        this._actionLogExpr = breakpointsWindowSettings.getDefaultActionLogExpr();
        this._actionLogStack = breakpointsWindowSettings.getDefaultActionLogStack();
        this._actionEnableOther = breakpointsWindowSettings.getDefaultActionEnableOther();
        this._actionDisableOther = breakpointsWindowSettings.getDefaultActionDisableOther();
    }

    public Object copyTo(Object object) {
        BreakpointSettings breakpointSettings = object != null ? (BreakpointSettings)object : new BreakpointSettings();
        this.copyToImpl(breakpointSettings);
        return breakpointSettings;
    }

    protected final void copyToImpl(BreakpointSettings breakpointSettings) {
        breakpointSettings._ownerURL = this._ownerURL;
        breakpointSettings._persistent = this._persistent;
        breakpointSettings._type = this._type;
        breakpointSettings._pkg = this._pkg;
        breakpointSettings._file = this._file;
        breakpointSettings._line = this._line;
        breakpointSettings._method = this._method;
        breakpointSettings._offset = this._offset;
        breakpointSettings._exception = this._exception;
        breakpointSettings._caught = this._caught;
        breakpointSettings._uncaught = this._uncaught;
        breakpointSettings._className = this._className;
        breakpointSettings._url = this._url;
        breakpointSettings._fieldName = this._fieldName;
        breakpointSettings._access = this._access;
        breakpointSettings._modify = this._modify;
        breakpointSettings._enabled = this._enabled;
        breakpointSettings._groupName = this._groupName;
        breakpointSettings._condition = this._condition;
        breakpointSettings._threadName = this._threadName;
        breakpointSettings._threadNameNot = this._threadNameNot;
        breakpointSettings._passCount = this._passCount;
        breakpointSettings._actionHalt = this._actionHalt;
        breakpointSettings._actionBeep = this._actionBeep;
        breakpointSettings._actionLog = this._actionLog;
        breakpointSettings._actionLogTag = this._actionLogTag;
        breakpointSettings._actionLogExpr = this._actionLogExpr;
        breakpointSettings._actionLogStack = this._actionLogStack;
        breakpointSettings._actionEnableOther = this._actionEnableOther;
        breakpointSettings._actionDisableOther = this._actionDisableOther;
    }

    public URL getOwnerURL() {
        return this._ownerURL;
    }

    public void setOwnerURL(URL uRL) {
        this._ownerURL = uRL;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void setPersistent(boolean bl) {
        this._persistent = bl;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    public String getPkg() {
        return this._pkg;
    }

    public void setPkg(String string) {
        this._pkg = string;
    }

    public String getFile() {
        return this._file;
    }

    public void setFile(String string) {
        this._file = string;
    }

    public int getLine() {
        return this._line;
    }

    public void setLine(int n) {
        this._line = n;
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String string) {
        this._method = string;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int n) {
        this._offset = n;
    }

    public String getException() {
        return this._exception;
    }

    public void setException(String string) {
        this._exception = string;
    }

    public boolean isCaught() {
        return this._caught;
    }

    public void setCaught(boolean bl) {
        this._caught = bl;
    }

    public boolean isUncaught() {
        return this._uncaught;
    }

    public void setUncaught(boolean bl) {
        this._uncaught = bl;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL uRL) {
        this._url = uRL;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public void setFieldName(String string) {
        this._fieldName = string;
    }

    public boolean isAccess() {
        return this._access;
    }

    public void setAccess(boolean bl) {
        this._access = bl;
    }

    public boolean isModify() {
        return this._modify;
    }

    public void setModify(boolean bl) {
        this._modify = bl;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public void setGroupName(String string) {
        this._groupName = string;
    }

    public String getCondition() {
        return this._condition;
    }

    public void setCondition(String string) {
        this._condition = string;
    }

    public String getThreadName() {
        return this._threadName;
    }

    public void setThreadName(String string) {
        this._threadName = string;
    }

    public String getThreadNameNot() {
        return this._threadNameNot;
    }

    public void setThreadNameNot(String string) {
        this._threadNameNot = string;
    }

    public int getPassCount() {
        return this._passCount;
    }

    public void setPassCount(int n) {
        this._passCount = n;
    }

    public boolean isActionHalt() {
        return this._actionHalt;
    }

    public void setActionHalt(boolean bl) {
        this._actionHalt = bl;
    }

    public boolean isActionBeep() {
        return this._actionBeep;
    }

    public void setActionBeep(boolean bl) {
        this._actionBeep = bl;
    }

    public boolean isActionLog() {
        return this._actionLog;
    }

    public void setActionLog(boolean bl) {
        this._actionLog = bl;
    }

    public String getActionLogTag() {
        return this._actionLogTag;
    }

    public void setActionLogTag(String string) {
        this._actionLogTag = string;
    }

    public String getActionLogExpr() {
        return this._actionLogExpr;
    }

    public void setActionLogExpr(String string) {
        this._actionLogExpr = string;
    }

    public boolean isActionLogStack() {
        return this._actionLogStack;
    }

    public void setActionLogStack(boolean bl) {
        this._actionLogStack = bl;
    }

    public String getActionEnableOther() {
        return this._actionEnableOther;
    }

    public void setActionEnableOther(String string) {
        this._actionEnableOther = string;
    }

    public String getActionDisableOther() {
        return this._actionDisableOther;
    }

    public void setActionDisableOther(String string) {
        this._actionDisableOther = string;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((BreakpointSettings)object);
    }

    protected final boolean equalsImpl(BreakpointSettings breakpointSettings) {
        return URLFileSystem.equals((URL)this._ownerURL, (URL)breakpointSettings._ownerURL) && this._persistent == breakpointSettings._persistent && this._type == breakpointSettings._type && ModelUtil.areEqual((Object)this._pkg, (Object)breakpointSettings._pkg) && ModelUtil.areEqual((Object)this._file, (Object)breakpointSettings._file) && this._line == breakpointSettings._line && ModelUtil.areEqual((Object)this._method, (Object)breakpointSettings._method) && this._offset == breakpointSettings._offset && ModelUtil.areEqual((Object)this._exception, (Object)breakpointSettings._exception) && this._caught == breakpointSettings._caught && this._uncaught == breakpointSettings._uncaught && ModelUtil.areEqual((Object)this._className, (Object)breakpointSettings._className) && URLFileSystem.equals((URL)this._url, (URL)breakpointSettings._url) && ModelUtil.areEqual((Object)this._fieldName, (Object)breakpointSettings._fieldName) && this._access == breakpointSettings._access && this._modify == breakpointSettings._modify && this._enabled == breakpointSettings._enabled && ModelUtil.areEqual((Object)this._groupName, (Object)breakpointSettings._groupName) && ModelUtil.areEqual((Object)this._condition, (Object)breakpointSettings._condition) && ModelUtil.areEqual((Object)this._threadName, (Object)breakpointSettings._threadName) && ModelUtil.areEqual((Object)this._threadNameNot, (Object)breakpointSettings._threadNameNot) && this._passCount == breakpointSettings._passCount && this._actionHalt == breakpointSettings._actionHalt && this._actionBeep == breakpointSettings._actionBeep && this._actionLog == breakpointSettings._actionLog && ModelUtil.areEqual((Object)this._actionLogTag, (Object)breakpointSettings._actionLogTag) && ModelUtil.areEqual((Object)this._actionLogExpr, (Object)breakpointSettings._actionLogExpr) && this._actionLogStack == breakpointSettings._actionLogStack && ModelUtil.areEqual((Object)this._actionEnableOther, (Object)breakpointSettings._actionEnableOther) && ModelUtil.areEqual((Object)this._actionDisableOther, (Object)breakpointSettings._actionDisableOther);
    }
}

