/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointOptionsDialog;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BreakpointsWindow
extends DockableWindow
implements ColumnMenuListener,
ContextMenuListener,
Controller,
DropTargetListener,
DragSourceListener,
DragGestureListener,
TreeSelectionListener,
TreeExpansionListener {
    private BreakpointTreeTableModel model;
    private JFastTreeTable treeTable;
    private TreeSelectionModel treeSelectionModel;
    private JScrollPane scrollPane;
    private String title;
    private Workspace workspace;
    private Project project;
    private List[] breakpoints;
    private Object lastHighlight;
    private BreakpointsWindowSettings bpSettings;
    private int preferredVisibleRowCount;
    private static final String REMOVE_INSTANCE_FILTER_CMD_PREFIX = "DebugBreakpointsRemoveInstanceFilter";
    private List removeInstanceFilterActions;
    private static IdeAction actionAdd;
    private static IdeAction actionOptions;
    private static IdeAction actionEnable;
    private static IdeAction actionDisable;
    private static IdeAction actionRemove;
    private static IdeAction actionChangeScopeGlobal;
    private static IdeAction actionChangeScopeWorkspace;
    private static IdeAction actionChangeScopeProject;
    private static IdeAction actionGoTo;
    private static IdeAction actionEnableAll;
    private static IdeAction actionDisableAll;
    private static IdeAction actionRemoveAll;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAdd;
    private static JMenuItem menuitemOptions;
    private static JMenuItem menuitemEnable;
    private static JMenuItem menuitemDisable;
    private static JMenuItem menuitemRemove;
    private static JMenu subMenuChangeScope;
    private static JMenuItem menuitemChangeScopeGlobal;
    private static JMenuItem menuitemChangeScopeWorkspace;
    private static JMenuItem menuitemChangeScopeProject;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemEnableAll;
    private static JMenuItem menuitemDisableAll;
    private static JMenuItem menuitemRemoveAll;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int ADD_CMD_ID;
    private static final int OPTIONS_CMD_ID;
    private static final int ENABLE_CMD_ID;
    private static final int DISABLE_CMD_ID;
    private static final int REMOVE_CMD_ID;
    private static final int CHANGE_SCOPE_GLOBAL_CMD_ID;
    private static final int CHANGE_SCOPE_WORKSPACE_CMD_ID;
    private static final int CHANGE_SCOPE_PROJECT_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int ENABLE_ALL_CMD_ID;
    private static final int DISABLE_ALL_CMD_ID;
    private static final int REMOVE_ALL_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final int COLUMN_DESCRIPTION = 0;
    static final int COLUMN_TYPE = 1;
    static final int COLUMN_STATUS = 2;
    static final int COLUMN_SCOPE = 3;
    static final int COLUMN_GROUP = 4;
    static final int COLUMN_CONDITION = 5;
    static final int COLUMN_THREAD = 6;
    static final int COLUMN_PASSCOUNT = 7;
    static final int COLUMN_ACTION = 8;
    static final int COLUMN_INSTANCE_FILTERS = 9;
    static final int NUMBER_OF_COLUMNS = 10;
    private TableColumn[] column;
    private int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static DataFlavor breakpointFlavor;
    private static DataFlavor[] transferFlavors;
    static final String BREAKPOINTS_WINDOW_ID = "Debugger.BreakpointsWindow";
    private static Icon breakpointsTabIcon;
    private boolean adjustColumnsAlreadyDone;

    void $init$() {
        this.preferredVisibleRowCount = 6;
        this.column = new TableColumn[10];
        this.columnDefaultWidth = new int[10];
        this.columnShowing = new boolean[10];
        this.adjustColumnsAlreadyDone = false;
    }

    static {
        ADD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsAdd");
        OPTIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsOptions");
        ENABLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsEnable");
        DISABLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsDisable");
        REMOVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsRemove");
        CHANGE_SCOPE_GLOBAL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeGlobal");
        CHANGE_SCOPE_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeWorkspace");
        CHANGE_SCOPE_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeProject");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsGoTo");
        ENABLE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsEnableAll");
        DISABLE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsDisableAll");
        REMOVE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsRemoveAll");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsSettings");
        breakpointFlavor = null;
        transferFlavors = null;
        breakpointsTabIcon = null;
    }

    BreakpointsWindow(Workspace workspace, Project project, List[] listArray) {
        super(BREAKPOINTS_WINDOW_ID);
        this.$init$();
        this.workspace = workspace;
        this.project = project;
        this.breakpoints = listArray;
        this.title = DbgArb.getString(406);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        this.removeInstanceFilterActions = new ArrayList();
        BreakpointsWindow.makeActions();
        this.setControllerForActions();
    }

    void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        int[] nArray = this.bpSettings.getColumnWidth();
        int n = 0;
        while (n < 10) {
            if (nArray[n] != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[n].setPreferredWidth(nArray[n]);
            }
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = this.bpSettings.getColumnOrder();
        if (string != null) {
            int n2 = 0;
            while (n2 < 10) {
                String string2;
                int n3 = string.indexOf(44);
                if (n3 != -1) {
                    string2 = string.substring(0, n3);
                    string = string.substring(n3 + 1);
                } else {
                    string2 = string;
                }
                if (string2.length() == 0) break;
                try {
                    int n4 = tableColumnModel.getColumnIndex(string2);
                    if (n4 != n2) {
                        this.treeTable.moveColumn(n4, n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    private void breakpointsWindowSettingsChanged(boolean bl) {
        if (this.treeTable == null) {
            return;
        }
        boolean[] blArray = this.bpSettings.getColumnVisible();
        int n = 1;
        while (n < 10) {
            if (this.columnShowing[n] != blArray[n]) {
                this.columnShowing[n] = blArray[n];
                if (blArray[n]) {
                    this.treeTable.addColumn(this.column[n]);
                } else {
                    this.treeTable.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl) {
            SwingUtilities.invokeLater(new 13());
        }
        Dimension dimension = this.treeTable.getPreferredSize();
        dimension.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(dimension);
    }

    private void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int[] nArray = this.bpSettings.getColumnWidth();
        int n = 0;
        while (n < 10) {
            nArray[n] = this.column[n].getWidth();
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = "";
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            string = string + tableColumn.getIdentifier() + ",";
        }
        this.bpSettings.setColumnOrder(string);
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        BreakpointsWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdd), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOptions), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEnable), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDisable), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemove), jMenu, f);
        JMenu jMenu2 = menubar.createSubMenu(DbgArb.getString(436), DbgArb.getInteger(437));
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)actionChangeScopeGlobal);
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)actionChangeScopeWorkspace);
        JMenuItem jMenuItem3 = menubar.createMenuItem((ToggleAction)actionChangeScopeProject);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jMenuItem);
        buttonGroup.add(jMenuItem2);
        buttonGroup.add(jMenuItem3);
        jMenu2.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        menubar.add((Component)jMenu2, jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEnableAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDisableAll), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAll), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            this.bpSettings = BreakpointsWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.breakpointsWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.bpSettings.addChangeListener(new 12());
        }
        return this.scrollPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_breakpointwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject eventObject) {
        BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model != null ? this.model.getSelectedBreakpointItem() : null;
        return ContextBuilder.buildContext((Element)breakpointItem, (View)this, eventObject, this.workspace, this.project);
    }

    public int getDefaultVisibility(Layout layout) {
        if (JDebugger.isDebuggingLayout(layout)) {
            return 1;
        }
        return 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (breakpointsTabIcon == null) {
            breakpointsTabIcon = DbgArb.getIcon(60);
        }
        return breakpointsTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    public DropTargetListener getTabDropListener() {
        return this;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.model.branchExpanded(treeExpansionEvent.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.model.branchCollapsed(treeExpansionEvent.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.treeSelectionModel.getLeadSelectionPath();
        this.lastHighlight = treePath != null ? this.model.getInfoFromTreePath(treePath) : null;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point;
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        if (dragGestureEvent.getDragAction() == 2 && (breakpointItem = this.model.getBreakpointItemForDrag(point = dragGestureEvent.getDragOrigin())) != null) {
            try {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 6);
                bufferedImage.setRGB(0, 0, -16777216);
                Point point2 = new Point(0, 0);
                dragGestureEvent.startDrag(null, bufferedImage, point2, breakpointItem, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.checkDrop(dropTargetDropEvent);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(BreakpointsWindow.getBreakpointFlavor())) {
            dropTargetDragEvent.acceptDrag(2);
            return;
        }
        if (dropTargetDragEvent.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
            dropTargetDragEvent.acceptDrag(1);
            return;
        }
        if (dropTargetDragEvent.isDataFlavorSupported(DataPanel.getHeapObjectFlavor())) {
            try {
                DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                if (debuggingProcess != null) {
                    DebugBreakpoint debugBreakpoint;
                    BreakpointTreeTableModel.BreakpointItem breakpointItem;
                    Point point = null;
                    if (dropTargetDragEvent.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        point = dropTargetDragEvent.getLocation();
                    }
                    if (this.model.getColumnAtPoint(point) == 9 && (breakpointItem = this.model.getBreakpointItemAtPoint(point)) != null && breakpointItem.isBreakpoint() && (debugBreakpoint = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null) {
                        dropTargetDragEvent.acceptDrag(1);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    private void checkDrop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.isLocalTransfer()) {
            if (dropTargetDropEvent.isDataFlavorSupported(BreakpointsWindow.getBreakpointFlavor())) {
                try {
                    Point point = null;
                    if (dropTargetDropEvent.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        point = dropTargetDropEvent.getLocation();
                    }
                    String string = this.model.getGroupNameAtPoint(point);
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    BreakpointTreeTableModel.BreakpointItem breakpointItem = (BreakpointTreeTableModel.BreakpointItem)transferable.getTransferData(BreakpointsWindow.getBreakpointFlavor());
                    if (breakpointItem.isMulti()) {
                        List list = breakpointItem.getBreakpoints(null);
                        int n = list.size() - 1;
                        while (n >= 0) {
                            Breakpoint breakpoint = (Breakpoint)list.get(n);
                            breakpoint.setGroupName(string);
                            --n;
                        }
                    } else {
                        Breakpoint breakpoint = breakpointItem.getBreakpoint();
                        breakpoint.setGroupName(string);
                    }
                    this.everythingChanged();
                    dropTargetDropEvent.acceptDrop(2);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception exception) {}
            } else if (dropTargetDropEvent.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                try {
                    String string;
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    ClassesWindow.ClassFlavorData classFlavorData = (ClassesWindow.ClassFlavorData)transferable.getTransferData(ClassesWindow.getClassFlavor());
                    String string2 = classFlavorData.getName();
                    URL uRL = JDebugger.getNewBreakpointOwnerURL(this.workspace, this.project);
                    Breakpoint breakpoint = new Breakpoint(uRL, 4, string2);
                    Point point = null;
                    if (dropTargetDropEvent.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        point = dropTargetDropEvent.getLocation();
                    }
                    if ((string = this.model.getGroupNameAtPoint(point)) != null) {
                        breakpoint.setGroupName(string);
                    }
                    this.addNewBreakpoint(breakpoint);
                    JDebugger.getInstance().viewBreakpoints();
                    dropTargetDropEvent.acceptDrop(1);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception exception) {}
            } else if (dropTargetDropEvent.isDataFlavorSupported(DataPanel.getHeapObjectFlavor())) {
                try {
                    DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                    if (debuggingProcess != null) {
                        HashSet hashSet;
                        DebugDataObjectInfo debugDataObjectInfo;
                        Transferable transferable;
                        Object object;
                        DebugBreakpoint debugBreakpoint;
                        BreakpointTreeTableModel.BreakpointItem breakpointItem;
                        Point point = null;
                        if (dropTargetDropEvent.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                            point = dropTargetDropEvent.getLocation();
                        }
                        if (this.model.getColumnAtPoint(point) == 9 && (breakpointItem = this.model.getBreakpointItemAtPoint(point)) != null && breakpointItem.isBreakpoint() && (debugBreakpoint = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null && (object = (transferable = dropTargetDropEvent.getTransferable()).getTransferData(DataPanel.getHeapObjectFlavor())) instanceof DebugDataObjectInfo && debugBreakpoint.isInstanceFilterAppropriate(debugDataObjectInfo = (DebugDataObjectInfo)object, hashSet = new HashSet()) && !debugBreakpoint.isInstanceFilterSet(debugDataObjectInfo)) {
                            debugBreakpoint.addInstanceFilter(debugDataObjectInfo);
                            this.updateColumn(9);
                            dropTargetDropEvent.acceptDrop(1);
                            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        dropTargetDropEvent.rejectDrop();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Long l;
        int n = ideAction.getCommandId();
        if (n == GOTO_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.showInSource();
            }
            return true;
        }
        if (n == DISABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.disable();
                this.updateColumn(2);
            }
            return true;
        }
        if (n == ENABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.enable();
                this.updateColumn(2);
            }
            return true;
        }
        if (n == REMOVE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                JTree jTree = this.treeTable.getTree();
                int n2 = jTree.getRowForPath(this.treeSelectionModel.getLeadSelectionPath());
                breakpointItem.remove();
                this.everythingChanged(null);
                int n3 = jTree.getRowCount();
                if (n2 < n3) {
                    this.model.highlightRow(n2);
                } else if (0 <= --n2 && n2 < n3) {
                    this.model.highlightRow(n2);
                }
            }
            return true;
        }
        if (n == OPTIONS_CMD_ID) {
            this.editBreakpointDialog();
            return true;
        }
        if (n == CHANGE_SCOPE_GLOBAL_CMD_ID || n == CHANGE_SCOPE_WORKSPACE_CMD_ID || n == CHANGE_SCOPE_PROJECT_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.changeScope(n);
                this.updateColumn(3);
            }
            return true;
        }
        if (n == ADD_CMD_ID) {
            this.addBreakpointDialog();
            return true;
        }
        if (n == DISABLE_ALL_CMD_ID) {
            this.disableAll();
            this.updateColumn(2);
            return true;
        }
        if (n == ENABLE_ALL_CMD_ID) {
            this.enableAll();
            this.updateColumn(2);
            return true;
        }
        if (n == REMOVE_ALL_CMD_ID) {
            this.removeAll();
            this.everythingChanged();
            return true;
        }
        if (n == SETTINGS_CMD_ID) {
            String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(733)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
            return true;
        }
        if (n == EXPAND_ALL_CMD_ID) {
            if (this.anyBreakpoints()) {
                BreakpointTreeTableModel.mav$expandAll(this.model);
            }
            return true;
        }
        if (n == COLLAPSE_ALL_CMD_ID) {
            if (this.anyBreakpoints()) {
                BreakpointTreeTableModel.mav$collapseAll(this.model);
            }
            return true;
        }
        if (n == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (n == 18) {
            Object object;
            int n4;
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null && (n4 = this.treeTable.getSelectedColumn()) != -1 && (object = this.model.getValueAt(breakpointItem, n4)) != null) {
                IdeUtil.copyToClipboard((String)object.toString());
            }
            return true;
        }
        if (this.removeInstanceFilterActions.contains(ideAction) && (l = (Long)ideAction.getValue("UserData")) != null) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem;
            DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
            if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint()) {
                Breakpoint breakpoint = breakpointItem.getBreakpoint();
                long l2 = l;
                debuggingProcess.runWhilePaused(new 11(this, breakpoint, l2));
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        Long l;
        if (!(ideAction.getValue("Debugger.actionOwner") != this || this.treeTable != null && this.isVisible())) {
            ideAction.setEnabled(false);
            return true;
        }
        int n = ideAction.getCommandId();
        if (n == GOTO_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                ideAction.setEnabled(breakpointItem.canShowInSource());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == DISABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    ideAction.putValue("Name", (Object)DbgArb.getString(423));
                } else {
                    ideAction.putValue("Name", (Object)DbgArb.getString(422));
                }
                ideAction.setEnabled(breakpointItem.canDisable());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == ENABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    ideAction.putValue("Name", (Object)DbgArb.getString(426));
                } else {
                    ideAction.putValue("Name", (Object)DbgArb.getString(425));
                }
                ideAction.setEnabled(breakpointItem.canEnable());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == REMOVE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    ideAction.putValue("Name", (Object)DbgArb.getString(429));
                } else {
                    ideAction.putValue("Name", (Object)DbgArb.getString(428));
                }
                ideAction.setEnabled(breakpointItem.canRemove());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == OPTIONS_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    ideAction.putValue("Name", (Object)DbgArb.getString(434));
                } else {
                    ideAction.putValue("Name", (Object)DbgArb.getString(433));
                }
                ideAction.setEnabled(breakpointItem.canEditOptions());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == CHANGE_SCOPE_GLOBAL_CMD_ID || n == CHANGE_SCOPE_WORKSPACE_CMD_ID || n == CHANGE_SCOPE_PROJECT_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                ideAction.setState(breakpointItem.isScope(n));
                ideAction.setEnabled(breakpointItem.canChangeScope(n));
            } else {
                ideAction.setState(false);
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == ADD_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == DISABLE_ALL_CMD_ID || n == ENABLE_ALL_CMD_ID || n == REMOVE_ALL_CMD_ID) {
            ideAction.setEnabled(this.anyBreakpoints());
            return true;
        }
        if (n == SETTINGS_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == EXPAND_ALL_CMD_ID || n == COLLAPSE_ALL_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == SAVE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 18) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            int n2 = this.treeTable.getSelectedColumn();
            ideAction.setEnabled(breakpointItem != null && n2 != -1);
            return true;
        }
        if (this.removeInstanceFilterActions.contains(ideAction) && (l = (Long)ideAction.getValue("UserData")) != null) {
            DebugBreakpoint debugBreakpoint;
            BreakpointTreeTableModel.BreakpointItem breakpointItem;
            DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
            if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint() && (debugBreakpoint = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null) {
                ideAction.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (this.treeTable != null && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            this.addPopupMenuItemsForNew(contextMenu, context);
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                this.addPopupMenuItemsForBreakpointItem(contextMenu, context);
            }
            this.addPopupMenuItemsForBreakpoints(contextMenu, context);
            this.addPopupMenuItemsForTreeTable(contextMenu, context);
            this.addPopupMenuItemsForCommon(contextMenu, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void showColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = true;
            if (this.bpSettings != null) {
                boolean[] blArray = this.bpSettings.getColumnVisible();
                blArray[n] = true;
            }
            this.treeTable.addColumn(this.column[n]);
        }
    }

    @Override
    public void hideColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = false;
            if (this.bpSettings != null) {
                boolean[] blArray = this.bpSettings.getColumnVisible();
                blArray[n] = false;
            }
            this.treeTable.removeColumn(this.column[n]);
        }
    }

    private void createGUI() {
        this.model = new BreakpointTreeTableModel(new ArrayList());
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set set = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, set);
        this.treeTable.setFocusTraversalKeys(1, set);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int n = 0;
        while (n < 10) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnDefaultWidth[n] = this.column[n].getPreferredWidth();
            this.columnShowing[n] = true;
            ++n;
        }
        boolean[] blArray = new boolean[10];
        Arrays.fill(blArray, true);
        blArray[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, blArray);
        this.treeTable.getSelectionModel().setSelectionMode(2);
        JTree jTree = this.treeTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        this.treeSelectionModel = jTree.getSelectionModel();
        this.treeSelectionModel.setSelectionMode(4);
        jTree.addTreeExpansionListener(this);
        jTree.addTreeSelectionListener(this);
        jTree.setCellRenderer(new 10());
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new 9());
        JTableHeader jTableHeader = this.treeTable.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new 8(this, tableCellRenderer));
        this.treeTable.addMouseListener((MouseListener)new 7());
        this.treeTable.addKeyListener((KeyListener)new 6());
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(27, 0)};
        KeyUtil.removeKeyStrokesFromInputMaps((JComponent)this.treeTable, (KeyStroke[])keyStrokeArray);
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color color = this.treeTable.getBackground();
        this.scrollPane.setBackground(color);
        this.scrollPane.getViewport().setBackground(color);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 5());
        this.scrollPane.addComponentListener(new 4());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 2, this);
        new DropTarget((Component)this.treeTable, 3, this);
        new DropTarget(this.scrollPane.getViewport(), 3, this);
        new DropTarget(this.scrollPane, 3, this);
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(431), null, (Integer)DbgArb.getInteger(432), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionDisable = IdeAction.get((int)DISABLE_CMD_ID, null, (String)DbgArb.getString(422), null, (Integer)DbgArb.getInteger(424), null, (int)-1, null, (boolean)false);
            actionDisable.setEnabled(false);
            actionEnable = IdeAction.get((int)ENABLE_CMD_ID, null, (String)DbgArb.getString(425), null, (Integer)DbgArb.getInteger(427), null, (int)-1, null, (boolean)false);
            actionEnable.setEnabled(false);
            actionRemove = IdeAction.get((int)REMOVE_CMD_ID, null, (String)DbgArb.getString(428), null, (Integer)DbgArb.getInteger(430), null, (int)-1, null, (boolean)false);
            actionRemove.setEnabled(false);
            actionOptions = IdeAction.get((int)OPTIONS_CMD_ID, null, (String)DbgArb.getString(433), null, (Integer)DbgArb.getInteger(435), null, (int)-1, null, (boolean)false);
            actionOptions.setEnabled(false);
            actionChangeScopeGlobal = IdeAction.get((int)CHANGE_SCOPE_GLOBAL_CMD_ID, null, (String)DbgArb.getString(438), null, (Integer)DbgArb.getInteger(439), null, (int)-1, null, (boolean)false);
            actionChangeScopeGlobal.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeGlobal.setEnabled(false);
            actionChangeScopeWorkspace = IdeAction.get((int)CHANGE_SCOPE_WORKSPACE_CMD_ID, null, (String)DbgArb.getString(440), null, (Integer)DbgArb.getInteger(441), null, (int)-1, null, (boolean)false);
            actionChangeScopeWorkspace.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeWorkspace.setEnabled(false);
            actionChangeScopeProject = IdeAction.get((int)CHANGE_SCOPE_PROJECT_CMD_ID, null, (String)DbgArb.getString(442), null, (Integer)DbgArb.getInteger(443), null, (int)-1, null, (boolean)false);
            actionChangeScopeProject.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeProject.setEnabled(false);
            actionAdd = IdeAction.get((int)ADD_CMD_ID, null, (String)DbgArb.getString(447), null, (Integer)DbgArb.getInteger(448), null, (int)-1, null, (boolean)false);
            actionAdd.setEnabled(false);
            actionDisableAll = IdeAction.get((int)DISABLE_ALL_CMD_ID, null, (String)DbgArb.getString(449), null, (Integer)DbgArb.getInteger(450), null, (int)-1, null, (boolean)false);
            actionDisableAll.setEnabled(false);
            actionEnableAll = IdeAction.get((int)ENABLE_ALL_CMD_ID, null, (String)DbgArb.getString(451), null, (Integer)DbgArb.getInteger(452), null, (int)-1, null, (boolean)false);
            actionEnableAll.setEnabled(false);
            actionRemoveAll = IdeAction.get((int)REMOVE_ALL_CMD_ID, null, (String)DbgArb.getString(453), null, (Integer)DbgArb.getInteger(454), null, (int)-1, null, (boolean)false);
            actionRemoveAll.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(95), null, (Integer)RunMgrArb.getInteger(96), null, (int)-1, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionGoTo, actionDisable, actionEnable, actionRemove, actionOptions, actionChangeScopeGlobal, actionChangeScopeWorkspace, actionChangeScopeProject, actionAdd, actionDisableAll, actionEnableAll, actionRemoveAll, actionSettings, actionExpandAll, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this);
    }

    private void showPopup(MouseEvent mouseEvent) {
        JDebugger.getInstance().showContextMenu(mouseEvent, this, (JComponent)this.treeTable);
    }

    private void addPopupMenuItemsForNew(ContextMenu contextMenu, Context context) {
        this.update(actionAdd, context);
        if (actionAdd.isEnabled()) {
            if (menuitemAdd == null) {
                menuitemAdd = contextMenu.createMenuItem((ToggleAction)actionAdd);
            }
            contextMenu.add((Component)menuitemAdd, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForBreakpointItem(ContextMenu contextMenu, Context context) {
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        this.update(actionOptions, context);
        if (actionOptions.isEnabled()) {
            if (menuitemOptions == null) {
                menuitemOptions = contextMenu.createMenuItem((ToggleAction)actionOptions);
            }
            contextMenu.add((Component)menuitemOptions, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionEnable, context);
        if (actionEnable.isEnabled()) {
            if (menuitemEnable == null) {
                menuitemEnable = contextMenu.createMenuItem((ToggleAction)actionEnable);
            }
            contextMenu.add((Component)menuitemEnable, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionDisable, context);
        if (actionDisable.isEnabled()) {
            if (menuitemDisable == null) {
                menuitemDisable = contextMenu.createMenuItem((ToggleAction)actionDisable);
            }
            contextMenu.add((Component)menuitemDisable, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionRemove, context);
        if (actionRemove.isEnabled()) {
            if (menuitemRemove == null) {
                menuitemRemove = contextMenu.createMenuItem((ToggleAction)actionRemove);
            }
            contextMenu.add((Component)menuitemRemove, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        if ((breakpointItem = this.model.getSelectedBreakpointItem()) != null && !breakpointItem.isGroup()) {
            if (subMenuChangeScope == null) {
                subMenuChangeScope = contextMenu.createSubMenu(DbgArb.getString(436), DbgArb.getInteger(437));
                if (menuitemChangeScopeGlobal == null) {
                    menuitemChangeScopeGlobal = contextMenu.createMenuItem((ToggleAction)actionChangeScopeGlobal);
                }
                if (menuitemChangeScopeWorkspace == null) {
                    menuitemChangeScopeWorkspace = contextMenu.createMenuItem((ToggleAction)actionChangeScopeWorkspace);
                }
                if (menuitemChangeScopeProject == null) {
                    menuitemChangeScopeProject = contextMenu.createMenuItem((ToggleAction)actionChangeScopeProject);
                }
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(menuitemChangeScopeGlobal);
                buttonGroup.add(menuitemChangeScopeWorkspace);
                buttonGroup.add(menuitemChangeScopeProject);
                subMenuChangeScope.add(menuitemChangeScopeGlobal);
                subMenuChangeScope.add(menuitemChangeScopeWorkspace);
                subMenuChangeScope.add(menuitemChangeScopeProject);
            }
            this.update(actionChangeScopeGlobal, context);
            this.update(actionChangeScopeWorkspace, context);
            this.update(actionChangeScopeProject, context);
            contextMenu.add((Component)subMenuChangeScope, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = contextMenu.createMenuItem((ToggleAction)actionGoTo);
            }
            contextMenu.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.addRemoveInstanceFilterActions(contextMenu, context);
    }

    private void addRemoveInstanceFilterActions(ContextMenu contextMenu, Context context) {
        int n;
        long[] lArray;
        DebugBreakpoint debugBreakpoint;
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        this.removeInstanceFilterActions.clear();
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint() && (debugBreakpoint = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null && (lArray = debugBreakpoint.getInstanceFilters()) != null && (n = lArray.length) > 0) {
            JMenu jMenu = contextMenu.createSubMenu(DbgArb.getString(444), DbgArb.getInteger(445));
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Long l = new Long(lArray[n3]);
                String string = DbgArb.format(446, Long.toString(lArray[n3]));
                int n4 = Ide.findOrCreateCmdID((String)(REMOVE_INSTANCE_FILTER_CMD_PREFIX + n2++));
                IdeAction ideAction = IdeAction.get((int)n4, null, (String)string, null, null, null, (int)-1, (Object)l, (boolean)true);
                ideAction.putValue("Name", (Object)string);
                ideAction.putValue("UserData", (Object)l);
                ideAction.addController((Controller)this);
                this.removeInstanceFilterActions.add(ideAction);
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
                jMenu.add(jMenuItem);
                ++n3;
            }
            contextMenu.add((Component)jMenu, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForBreakpoints(ContextMenu contextMenu, Context context) {
        this.update(actionEnableAll, context);
        if (actionEnableAll.isEnabled()) {
            if (menuitemEnableAll == null) {
                menuitemEnableAll = contextMenu.createMenuItem((ToggleAction)actionEnableAll);
            }
            contextMenu.add((Component)menuitemEnableAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionDisableAll, context);
        if (actionDisableAll.isEnabled()) {
            if (menuitemDisableAll == null) {
                menuitemDisableAll = contextMenu.createMenuItem((ToggleAction)actionDisableAll);
            }
            contextMenu.add((Component)menuitemDisableAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionRemoveAll, context);
        if (actionRemoveAll.isEnabled()) {
            if (menuitemRemoveAll == null) {
                menuitemRemoveAll = contextMenu.createMenuItem((ToggleAction)actionRemoveAll);
            }
            contextMenu.add((Component)menuitemRemoveAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForTreeTable(ContextMenu contextMenu, Context context) {
        this.update(actionExpandAll, context);
        if (actionExpandAll.isEnabled()) {
            if (menuitemExpandAll == null) {
                menuitemExpandAll = contextMenu.createMenuItem((ToggleAction)actionExpandAll);
            }
            contextMenu.add((Component)menuitemExpandAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
        this.update(actionCollapseAll, context);
        if (actionCollapseAll.isEnabled()) {
            if (menuitemCollapseAll == null) {
                menuitemCollapseAll = contextMenu.createMenuItem((ToggleAction)actionCollapseAll);
            }
            contextMenu.add((Component)menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = contextMenu.createMenuItem((ToggleAction)actionSave);
            }
            contextMenu.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = contextMenu.createMenuItem((ToggleAction)actionSettings);
            }
            contextMenu.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    private void saveToFile() {
        URL uRL;
        String string = RunMgrArb.format(103, this.getTitleName());
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            uRLChooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            Exception exception = null;
            try {
                PrintWriter printWriter;
                String string2 = URLFileSystem.getSuffix((URL)uRL).toUpperCase();
                boolean bl = string2.equals(".HTML") || string2.equals(".HTM");
                PrintWriter printWriter2 = printWriter = bl ? JDebugger.printHtmlHeader(uRL, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)));
                if (this.anyBreakpoints()) {
                    BreakpointTreeTableModel.mav$save(this.model, printWriter, bl);
                }
                if (bl) {
                    JDebugger.printHtmlFooter(printWriter);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            waitCursor.hide();
            if (exception != null) {
                String string3 = DbgArb.format(858, this.getTitleName(), URLFileSystem.getPlatformPathName((URL)uRL));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)string, (String)string3, null);
            }
        }
    }

    void everythingChanged() {
        this.everythingChanged(this.lastHighlight);
    }

    private void everythingChanged(Object object) {
        if (this.model != null) {
            this.model.updateBreakpoints(object);
        }
    }

    void setBreakpoints(Workspace workspace, Project project, List[] listArray) {
        this.workspace = workspace;
        this.project = project;
        this.breakpoints = listArray;
        this.everythingChanged();
    }

    private void updateColumn(int n) {
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent tableModelEvent = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, n);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(tableModelEvent);
        }
        if (n == 2) {
            this.updateIcons();
        } else if (n == 0) {
            this.model.fireChanged(this.lastHighlight);
        }
    }

    private void updateIcons() {
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent tableModelEvent = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, 0);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(tableModelEvent);
        }
        this.model.fireChanged(this.lastHighlight);
    }

    void processSelectionChanged() {
        if (this.treeTable == null) {
            return;
        }
        this.updateColumn(2);
        this.updateColumn(7);
        this.updateColumn(9);
    }

    void breakpointDescriptionChanged() {
        if (this.treeTable != null) {
            this.updateColumn(0);
        }
    }

    void breakpointStatusChanged() {
        if (this.treeTable != null) {
            this.updateColumn(2);
        }
    }

    void breakpointInstanceFiltersChanged() {
        if (this.treeTable != null) {
            this.updateColumn(9);
        }
    }

    private void editBreakpointDialog() {
        BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
        if (breakpointItem != null) {
            if (breakpointItem.isMulti()) {
                this.editBreakpointDialog(breakpointItem.getBreakpoints(null), false);
            } else if (breakpointItem.isGroup()) {
                this.editBreakpointDialog(breakpointItem.getBreakpoints(null), true);
            } else {
                this.editBreakpointDialog(breakpointItem.getBreakpoint(), true);
            }
        }
    }

    private void editBreakpointDialog(List list, boolean bl) {
        String[] stringArray;
        Breakpoint[] breakpointArray;
        BreakpointOptionsDialog breakpointOptionsDialog;
        if (list.size() > 0 && (breakpointOptionsDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(breakpointArray = list.toArray(new Breakpoint[list.size()]), bl, stringArray = this.getGroupNames(true))) != null) {
            3 var6_6 = new 3();
            int n = breakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                breakpointArray[n2].pauseAndApplyChanges(var6_6);
                ++n2;
            }
        }
    }

    private void editBreakpointDialog(Breakpoint breakpoint, boolean bl) {
        String[] stringArray;
        URL uRL = breakpoint.getOwnerURL();
        BreakpointOptionsDialog breakpointOptionsDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(uRL, breakpoint, stringArray = this.getGroupNames(true));
        if (breakpointOptionsDialog != null) {
            2 var6_6 = new 2(this, bl, breakpoint);
            breakpoint.pauseAndApplyChanges(var6_6);
        }
    }

    private void addBreakpointDialog() {
        String[] stringArray;
        URL uRL = JDebugger.getNewBreakpointOwnerURL(this.workspace, this.project);
        BreakpointOptionsDialog breakpointOptionsDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(uRL, null, stringArray = this.getGroupNames(true));
        if (breakpointOptionsDialog != null) {
            Breakpoint breakpoint = breakpointOptionsDialog.getBreakpoint();
            this.addNewBreakpoint(breakpoint);
        }
    }

    private String[] getGroupNames(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("");
        }
        this.getGroupNames(arrayList);
        Collections.sort(arrayList);
        int n = arrayList.size();
        return arrayList.toArray(new String[n]);
    }

    private void getGroupNames(List<String> list) {
        int n = this.breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : this.breakpoints[n2]) {
                String string = breakpoint.getGroupName();
                if (string.length() <= 0 || list.contains(string)) continue;
                list.add(string);
            }
            ++n2;
        }
    }

    private List getBreakpointsForGroup(String string) {
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        int n = this.breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : this.breakpoints[n2]) {
                if (!breakpoint.getGroupName().equals(string)) continue;
                arrayList.add(breakpoint);
            }
            ++n2;
        }
        return arrayList;
    }

    void highlightBreakpoint(Breakpoint breakpoint) {
        this.model.highlightBreakpoint(breakpoint);
    }

    void editBreakpoint(Breakpoint breakpoint) {
        this.editBreakpointDialog(breakpoint, false);
    }

    void addNewBreakpoint(Breakpoint breakpoint) {
        1 var2_2 = new 1(this, breakpoint);
        JDebugger.getInstance().addBreakpoint(breakpoint, var2_2);
    }

    private void disableAll() {
        int n = this.breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : this.breakpoints[n2]) {
                breakpoint.setEnabled(false);
            }
            ++n2;
        }
    }

    private void enableAll() {
        int n = this.breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : this.breakpoints[n2]) {
                breakpoint.setEnabled(true);
            }
            ++n2;
        }
    }

    private void removeAll() {
        ArrayList arrayList = new ArrayList();
        int n = this.breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            arrayList.addAll(this.breakpoints[n2]);
            ++n2;
        }
        for (Breakpoint breakpoint : arrayList) {
            breakpoint.removeBreakpoint();
        }
    }

    private boolean anyBreakpoints() {
        int n = this.breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.breakpoints[n2].size() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static DataFlavor getBreakpointFlavor() {
        if (breakpointFlavor == null) {
            breakpointFlavor = new DataFlavor(BreakpointTreeTableModel.BreakpointItem.class, "Breakpoint");
        }
        return breakpointFlavor;
    }

    static void mav$breakpointsWindowSettingsChanged(BreakpointsWindow breakpointsWindow, boolean bl) {
        breakpointsWindow.breakpointsWindowSettingsChanged(bl);
    }

    static void mav$updateColumn(BreakpointsWindow breakpointsWindow, int n) {
        breakpointsWindow.updateColumn(n);
    }

    static BreakpointTreeTableModel ra$model(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.model;
    }

    static JFastTreeTable ra$treeTable(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.treeTable;
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static void mav$showPopup(BreakpointsWindow breakpointsWindow, MouseEvent mouseEvent) {
        breakpointsWindow.showPopup(mouseEvent);
    }

    static IdeAction ra$actionRemove() {
        return actionRemove;
    }

    static void mav$adjustColumnsAfterResize(BreakpointsWindow breakpointsWindow) {
        breakpointsWindow.adjustColumnsAfterResize();
    }

    static void mav$everythingChanged(BreakpointsWindow breakpointsWindow, Object object) {
        breakpointsWindow.everythingChanged(object);
    }

    static void wa$lastHighlight(BreakpointsWindow breakpointsWindow, Object object) {
        breakpointsWindow.lastHighlight = object;
    }

    static List[] ra$breakpoints(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.breakpoints;
    }

    static String[] mav$getGroupNames(BreakpointsWindow breakpointsWindow, boolean bl) {
        return breakpointsWindow.getGroupNames(bl);
    }

    static List mav$getBreakpointsForGroup(BreakpointsWindow breakpointsWindow, String string) {
        return breakpointsWindow.getBreakpointsForGroup(string);
    }

    static DataFlavor maS$getBreakpointFlavor() {
        return BreakpointsWindow.getBreakpointFlavor();
    }

    static DataFlavor[] ra$transferFlavors() {
        return transferFlavors;
    }

    static void wa$transferFlavors(DataFlavor[] dataFlavorArray) {
        transferFlavors = dataFlavorArray;
    }

    static int ra$CHANGE_SCOPE_GLOBAL_CMD_ID() {
        return CHANGE_SCOPE_GLOBAL_CMD_ID;
    }

    static int ra$CHANGE_SCOPE_WORKSPACE_CMD_ID() {
        return CHANGE_SCOPE_WORKSPACE_CMD_ID;
    }

    static Workspace ra$workspace(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.workspace;
    }

    static int ra$CHANGE_SCOPE_PROJECT_CMD_ID() {
        return CHANGE_SCOPE_PROJECT_CMD_ID;
    }

    static Project ra$project(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.project;
    }

    final class 13
    implements Runnable {
        public void run() {
            BreakpointsWindow.this.everythingChanged();
        }
    }

    final class 12
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BreakpointsWindow.mav$breakpointsWindowSettingsChanged(BreakpointsWindow.this, true);
        }
    }

    final class 11
    implements RunWhilePaused {
        private final /* synthetic */ Breakpoint v$bp;
        private final /* synthetic */ long v$id;
        final /* synthetic */ BreakpointsWindow this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            DebugBreakpoint debugBreakpoint;
            if (bl && (debugBreakpoint = this.v$bp.getDebugBreakpoint(debuggingProcess)) != null) {
                debugBreakpoint.removeInstanceFilter(this.v$id);
                BreakpointsWindow.mav$updateColumn(this.this$0, 9);
            }
        }

        public 11(BreakpointsWindow breakpointsWindow, Breakpoint breakpoint, long l) {
            this.v$id = l;
            this.v$bp = breakpoint;
            this.this$0 = breakpointsWindow;
        }
    }

    final class 10
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof BreakpointTreeTableModel.BreakpointItem) {
                String string;
                BreakpointTreeTableModel.BreakpointItem breakpointItem = (BreakpointTreeTableModel.BreakpointItem)object;
                this.setIcon(breakpointItem.getIcon());
                String string2 = breakpointItem.getDescriptionColumnValue();
                this.setToolTipText(string2);
                AccessibleContext accessibleContext = this.getAccessibleContext();
                String string3 = BreakpointTreeTableModel.mav$getAccessibleNameAt(BreakpointsWindow.ra$model(BreakpointsWindow.this), breakpointItem, 0);
                if (breakpointItem.mayHaveChildren()) {
                    string3 = JDebugger.fixTreeCellAccessibleName(string3, bl2);
                }
                if (string3 != null) {
                    accessibleContext.setAccessibleName(string3);
                }
                if ((string = string2) != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            } else {
                this.setIcon(null);
                this.setToolTipText(null);
            }
            return this;
        }
    }

    final class 9
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string2 = object instanceof String ? (String)object : null;
            this.setToolTipText(string2);
            BreakpointTreeTableModel.BreakpointItem breakpointItem = BreakpointsWindow.ra$model(BreakpointsWindow.this).getBreakpointItemForTreePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(n));
            int n3 = jTable.convertColumnIndexToModel(n2);
            AccessibleContext accessibleContext = this.getAccessibleContext();
            String string3 = BreakpointTreeTableModel.mav$getAccessibleNameAt(BreakpointsWindow.ra$model(BreakpointsWindow.this), breakpointItem, n3);
            if (string3 != null) {
                accessibleContext.setAccessibleName(string3);
            }
            if ((string = string2) != null) {
                accessibleContext.setAccessibleDescription(string);
            }
            return this;
        }
    }

    final class 8
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ BreakpointsWindow this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                defaultTableCellRenderer.setHorizontalAlignment(2);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public 8(BreakpointsWindow breakpointsWindow, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = breakpointsWindow;
        }
    }

    final class 7
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (JDebugger.isDoubleClickInTreeTable(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this), mouseEvent)) {
                Context context = BreakpointsWindow.this.getContext(mouseEvent);
                BreakpointsWindow.this.update(BreakpointsWindow.ra$actionGoTo(), context);
                if (BreakpointsWindow.ra$actionGoTo().isEnabled()) {
                    BreakpointsWindow.this.handleEvent(BreakpointsWindow.ra$actionGoTo(), context);
                }
            }
        }
    }

    final class 6
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 127: {
                    Context context = BreakpointsWindow.this.getContext(keyEvent);
                    BreakpointsWindow.this.update(BreakpointsWindow.ra$actionRemove(), context);
                    if (!BreakpointsWindow.ra$actionRemove().isEnabled()) break;
                    BreakpointsWindow.this.handleEvent(BreakpointsWindow.ra$actionRemove(), context);
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    Context context = BreakpointsWindow.this.getContext(keyEvent);
                    BreakpointsWindow.this.update(BreakpointsWindow.ra$actionGoTo(), context);
                    if (!BreakpointsWindow.ra$actionGoTo().isEnabled()) break;
                    BreakpointsWindow.this.handleEvent(BreakpointsWindow.ra$actionGoTo(), context);
                    keyEvent.consume();
                }
            }
        }
    }

    final class 5
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, mouseEvent);
            }
        }
    }

    final class 4
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            BreakpointsWindow.mav$adjustColumnsAfterResize(BreakpointsWindow.this);
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            BreakpointsWindow.mav$everythingChanged(BreakpointsWindow.this, null);
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ boolean v$highlightBP;
        private final /* synthetic */ Breakpoint v$bp;
        final /* synthetic */ BreakpointsWindow this$0;

        public void run() {
            if (this.v$highlightBP) {
                BreakpointsWindow.mav$everythingChanged(this.this$0, this.v$bp);
            } else {
                this.this$0.everythingChanged();
            }
        }

        public 2(BreakpointsWindow breakpointsWindow, boolean bl, Breakpoint breakpoint) {
            this.v$bp = breakpoint;
            this.v$highlightBP = bl;
            this.this$0 = breakpointsWindow;
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Breakpoint v$bp;
        final /* synthetic */ BreakpointsWindow this$0;

        public void run() {
            this.this$0.everythingChanged();
            if (BreakpointsWindow.ra$treeTable(this.this$0) != null) {
                this.this$0.highlightBreakpoint(this.v$bp);
            }
        }

        public 1(BreakpointsWindow breakpointsWindow, Breakpoint breakpoint) {
            this.v$bp = breakpoint;
            this.this$0 = breakpointsWindow;
        }
    }

    private final class BreakpointTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List collapsed;

        BreakpointTreeTableModel(List list) {
            super((Object)list);
            this.root = list;
            this.collapsed = new ArrayList();
        }

        void updateBreakpoints(Object object) {
            this.root.clear();
            int n = BreakpointsWindow.ra$breakpoints(BreakpointsWindow.this).length;
            int n2 = 0;
            while (n2 < n) {
                for (Breakpoint breakpoint : BreakpointsWindow.ra$breakpoints(BreakpointsWindow.this)[n2]) {
                    String string = breakpoint.getGroupName();
                    if (string.length() != 0) continue;
                    this.root.add(new BreakpointItem(breakpoint));
                }
                ++n2;
            }
            String[] stringArray = BreakpointsWindow.mav$getGroupNames(BreakpointsWindow.this, false);
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                this.root.add(new BreakpointItem(string));
                ++n4;
            }
            this.fireChanged(object);
        }

        void fireChanged(Object object) {
            TreePath treePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, treePath.getPath(), null, null);
            this.expandBranches();
            this.restoreHighlight(object);
        }

        void highlightRow(int n) {
            TreePath treePath = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(n);
            Object object = this.getInfoFromTreePath(treePath);
            this.restoreHighlight(object);
        }

        void highlightBreakpoint(Breakpoint breakpoint) {
            this.restoreHighlight(breakpoint, true);
        }

        private void restoreHighlight(Object object) {
            this.restoreHighlight(object, false);
        }

        private void restoreHighlight(Object object, boolean bl) {
            if (object != null) {
                BreakpointsWindow.wa$lastHighlight(BreakpointsWindow.this, object);
                TreePath treePath = this.makeVisible(object);
                JDebugger.getInstance().selectTreeTablePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this), treePath, bl);
            }
        }

        void expandBranches() {
            this.expandBranch(new TreePath(this.root));
        }

        private void expandBranch(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (!this.collapsed.contains(object)) {
                BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().expandPath(treePath);
            }
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.expandBranch(treePath.pathByAddingChild(object2));
                ++n2;
            }
        }

        TreePath makeVisible(Object object) {
            return this.makeVisible(new TreePath(this.root), object);
        }

        private TreePath makeVisible(TreePath treePath, Object object) {
            BreakpointItem breakpointItem;
            Object object2 = treePath.getLastPathComponent();
            if (object2 instanceof BreakpointItem && object.equals((breakpointItem = (BreakpointItem)object2).getInfo())) {
                BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().makeVisible(treePath);
                return treePath;
            }
            int n = this.getChildCount(object2);
            int n2 = 0;
            while (n2 < n) {
                Object object3 = this.getChild(object2, n2);
                TreePath treePath2 = this.makeVisible(treePath.pathByAddingChild(object3), object);
                if (treePath2 != null) {
                    return treePath2;
                }
                ++n2;
            }
            return null;
        }

        void branchExpanded(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            this.collapsed.remove(object);
        }

        void branchCollapsed(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            int n = this.collapsed.indexOf(object);
            if (n != -1) {
                this.collapsed.remove(n);
            }
            this.collapsed.add(0, object);
        }

        BreakpointItem getBreakpointItemForTreePath(TreePath treePath) {
            Object object;
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof BreakpointItem) {
                return (BreakpointItem)object;
            }
            return null;
        }

        BreakpointItem getSelectedBreakpointItem() {
            TreePath[] treePathArray = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getSelectionPaths();
            if (treePathArray == null) {
                return null;
            }
            int n = treePathArray.length;
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return this.getBreakpointItemForTreePath(treePathArray[0]);
            }
            ArrayList<BreakpointItem> arrayList = new ArrayList<BreakpointItem>();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.getBreakpointItemForTreePath(treePathArray[n2]));
                ++n2;
            }
            return new BreakpointItem(arrayList);
        }

        BreakpointItem getBreakpointItemForDrag(Point point) {
            int n = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).rowAtPoint(point);
            if (BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).isRowSelected(n)) {
                BreakpointItem breakpointItem = this.getSelectedBreakpointItem();
                if (breakpointItem != null) {
                    if (breakpointItem.isMulti()) {
                        Iterator iterator = breakpointItem.getMultiBreakpointItems();
                        while (iterator.hasNext()) {
                            BreakpointItem breakpointItem2 = (BreakpointItem)iterator.next();
                            if (!breakpointItem2.isGroup()) continue;
                            return null;
                        }
                    } else if (breakpointItem.getBreakpoint() == null) {
                        return null;
                    }
                }
                return breakpointItem;
            }
            return this.getBreakpointItemForTreePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(n));
        }

        int getColumnAtPoint(Point point) {
            int n;
            if (point != null && (n = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).columnAtPoint(point)) != -1) {
                return BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).convertColumnIndexToModel(n);
            }
            return -1;
        }

        BreakpointItem getBreakpointItemAtPoint(Point point) {
            int n = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).rowAtPoint(point);
            return this.getBreakpointItemForTreePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(n));
        }

        String getGroupNameAtPoint(Point point) {
            BreakpointItem breakpointItem;
            if (point != null && (breakpointItem = this.getBreakpointItemAtPoint(point)) != null) {
                return breakpointItem.getGroupName();
            }
            return null;
        }

        Object getInfoFromTreePath(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof BreakpointItem) {
                BreakpointItem breakpointItem = (BreakpointItem)object;
                return breakpointItem.getInfo();
            }
            return null;
        }

        private void expandAll() {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.expandAll(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree(), new TreePath(this.root));
            waitCursor.hide();
        }

        private void expandAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            jTree.expandPath(treePath);
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.expandAll(jTree, treePath.pathByAddingChild(object2));
                ++n2;
            }
        }

        private void collapseAll() {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.collapseAll(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree(), new TreePath(this.root));
            waitCursor.hide();
        }

        private void collapseAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.collapseAll(jTree, treePath.pathByAddingChild(object2));
                ++n2;
            }
            if (!object.equals(this.root)) {
                jTree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter printWriter, boolean bl) {
            if (bl) {
                printWriter.println("<table border=\"1\">");
            }
            this.saveHeader(printWriter, bl);
            this.save(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree(), new TreePath(this.root), printWriter, bl, "");
            if (bl) {
                printWriter.println("</table>");
            }
        }

        private void saveHeader(PrintWriter printWriter, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (bl) {
                stringBuffer.append("<tr>");
            }
            TableColumnModel tableColumnModel = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                int n = tableColumn.getModelIndex();
                String string = this.getColumnName(n);
                if (bl) {
                    stringBuffer.append("<th>");
                    string = IdeUtil.replaceHTMLReservedCharacters((String)string.toString());
                    stringBuffer.append(string);
                    stringBuffer.append("</th>");
                    continue;
                }
                stringBuffer.append(string);
                int n2 = string.length();
                while (n2 >= 0) {
                    stringBuffer2.append('-');
                    --n2;
                }
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append('\t');
                stringBuffer2.append('\t');
            }
            if (bl) {
                stringBuffer.append("</tr>");
            }
            printWriter.println(stringBuffer.toString());
            if (!bl) {
                printWriter.println(stringBuffer2.toString());
            }
        }

        private void save(JTree jTree, TreePath treePath, PrintWriter printWriter, boolean bl, String string) {
            if (jTree.isVisible(treePath)) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof BreakpointItem) {
                    BreakpointItem breakpointItem = (BreakpointItem)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (bl) {
                        stringBuffer.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getColumnModel();
                    Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                    while (enumeration.hasMoreElements()) {
                        TableColumn tableColumn = enumeration.nextElement();
                        int n = tableColumn.getModelIndex();
                        Object object2 = this.getValueAt(object, n);
                        if (bl) {
                            String string2;
                            stringBuffer.append("<td>");
                            if (n == 0) {
                                stringBuffer.append("<tt>");
                                if (string != null) {
                                    stringBuffer.append(string);
                                }
                                if (jTree.isExpanded(treePath)) {
                                    stringBuffer.append("-&nbsp;");
                                } else if (breakpointItem.mayHaveChildren()) {
                                    stringBuffer.append("+&nbsp;");
                                } else {
                                    stringBuffer.append("&nbsp;&nbsp;");
                                }
                                stringBuffer.append("</tt>");
                            }
                            if ((string2 = IdeUtil.replaceHTMLReservedCharacters((String)object2.toString())).length() > 0) {
                                stringBuffer.append(string2);
                            } else {
                                stringBuffer.append("&nbsp;");
                            }
                            stringBuffer.append("</td>");
                            continue;
                        }
                        if (n == 0) {
                            if (string != null) {
                                stringBuffer.append(string);
                            }
                            if (jTree.isExpanded(treePath)) {
                                stringBuffer.append("- ");
                            } else if (breakpointItem.mayHaveChildren()) {
                                stringBuffer.append("+ ");
                            } else {
                                stringBuffer.append("  ");
                            }
                        }
                        stringBuffer.append(object2);
                        if (!enumeration.hasMoreElements()) continue;
                        stringBuffer.append('\t');
                    }
                    if (bl) {
                        stringBuffer.append("</tr>");
                    }
                    printWriter.println(stringBuffer.toString());
                }
                if (object != this.root) {
                    string = bl ? string + "&nbsp;&nbsp;&nbsp;&nbsp;" : string + "    ";
                }
                int n = this.getChildCount(object);
                int n2 = 0;
                while (n2 < n) {
                    Object object3 = this.getChild(object, n2);
                    this.save(jTree, treePath.pathByAddingChild(object3), printWriter, bl, string);
                    ++n2;
                }
            }
        }

        public boolean isLeaf(Object object) {
            try {
                if (object instanceof List) {
                    boolean bl = false;
                    return bl;
                }
                BreakpointItem breakpointItem = (BreakpointItem)object;
                boolean bl = breakpointItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public Object getChild(Object object, int n) {
            try {
                if (object instanceof List) {
                    Object e = ((List)object).get(n);
                    return e;
                }
                BreakpointItem breakpointItem = (BreakpointItem)object;
                BreakpointItem breakpointItem2 = breakpointItem.getChildNodes()[n];
                return breakpointItem2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object object) {
            try {
                if (object instanceof List) {
                    int n = ((List)object).size();
                    return n;
                }
                BreakpointItem breakpointItem = (BreakpointItem)object;
                int n = breakpointItem.countChildNodes();
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 10;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return DbgArb.getString(409);
                }
                case 3: {
                    return DbgArb.getString(410);
                }
                case 1: {
                    return DbgArb.getString(411);
                }
                case 2: {
                    return DbgArb.getString(412);
                }
                case 4: {
                    return DbgArb.getString(413);
                }
                case 5: {
                    return DbgArb.getString(414);
                }
                case 6: {
                    return DbgArb.getString(415);
                }
                case 7: {
                    return DbgArb.getString(416);
                }
                case 8: {
                    return DbgArb.getString(417);
                }
                case 9: {
                    return DbgArb.getString(418);
                }
            }
            return "";
        }

        public Object getValueAt(Object object, int n) {
            try {
                if (object instanceof List) {
                    switch (n) {
                        case 0: {
                            String string = "root";
                            return string;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            String string = "";
                            return string;
                        }
                    }
                    Object var7_5 = null;
                    return var7_5;
                }
                BreakpointItem breakpointItem = (BreakpointItem)object;
                switch (n) {
                    case 0: {
                        String string = breakpointItem.getDescriptionColumnValue();
                        return string;
                    }
                    case 3: {
                        String string = breakpointItem.getScopeColumnValue();
                        return string;
                    }
                    case 1: {
                        String string = breakpointItem.getTypeColumnValue();
                        return string;
                    }
                    case 2: {
                        String string = breakpointItem.getStatusColumnValue();
                        return string;
                    }
                    case 4: {
                        String string = breakpointItem.getGroupColumnValue();
                        return string;
                    }
                    case 5: {
                        String string = breakpointItem.getConditionColumnValue();
                        return string;
                    }
                    case 6: {
                        String string = breakpointItem.getThreadColumnValue();
                        return string;
                    }
                    case 7: {
                        String string = breakpointItem.getPassCountColumnValue();
                        return string;
                    }
                    case 8: {
                        String string = breakpointItem.getActionColumnValue();
                        return string;
                    }
                    case 9: {
                        String string = breakpointItem.getInstanceFiltersColumnValue();
                        return string;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(BreakpointItem breakpointItem, int n) {
            int n2;
            if (breakpointItem.isBreakpoint()) {
                n2 = 407;
            } else if (breakpointItem.isGroup()) {
                n2 = 408;
            } else {
                return null;
            }
            String string = this.getColumnName(n);
            String string2 = (String)this.getValueAt(breakpointItem, n);
            if (string2 == null || string2.length() == 0) {
                string2 = DbgArb.getString(884);
            }
            return DbgArb.format(n2, string, string2);
        }

        static void mav$save(BreakpointTreeTableModel breakpointTreeTableModel, PrintWriter printWriter, boolean bl) {
            breakpointTreeTableModel.save(printWriter, bl);
        }

        static void mav$expandAll(BreakpointTreeTableModel breakpointTreeTableModel) {
            breakpointTreeTableModel.expandAll();
        }

        static void mav$collapseAll(BreakpointTreeTableModel breakpointTreeTableModel) {
            breakpointTreeTableModel.collapseAll();
        }

        static String mav$getAccessibleNameAt(BreakpointTreeTableModel breakpointTreeTableModel, BreakpointItem breakpointItem, int n) {
            return breakpointTreeTableModel.getAccessibleNameAt(breakpointItem, n);
        }

        private final class BreakpointItem
        extends BaseElement
        implements Transferable {
            private Object info;
            private BreakpointItem[] children;
            private boolean removed;

            BreakpointItem(Object object) {
                this.info = object;
            }

            URL getOwnerURL() {
                if (this.info instanceof Breakpoint) {
                    return ((Breakpoint)this.info).getOwnerURL();
                }
                return null;
            }

            Object getInfo() {
                return this.info;
            }

            boolean isBreakpoint() {
                return this.info instanceof Breakpoint;
            }

            boolean isGroup() {
                return this.info instanceof String;
            }

            boolean isMulti() {
                return this.info instanceof List;
            }

            Iterator getMultiBreakpointItems() {
                if (this.info instanceof List) {
                    return ((List)this.info).iterator();
                }
                return null;
            }

            List getBreakpoints(List arrayList) {
                block7: {
                    block6: {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>();
                        }
                        if (!(this.info instanceof Breakpoint)) break block6;
                        if (arrayList.contains(this.info)) break block7;
                        arrayList.add(this.info);
                        break block7;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItemArray = this.getChildNodes();
                        int n = breakpointItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            breakpointItemArray[n2].getBreakpoints(arrayList);
                            ++n2;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int n = list.size();
                        int n3 = 0;
                        while (n3 < n) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(n3);
                            breakpointItem.getBreakpoints(arrayList);
                            ++n3;
                        }
                    }
                }
                return arrayList;
            }

            Breakpoint getBreakpoint() {
                if (this.info instanceof Breakpoint) {
                    return (Breakpoint)this.info;
                }
                return null;
            }

            String getGroupName() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getGroupName();
                }
                if (this.info instanceof String) {
                    return (String)this.info;
                }
                return null;
            }

            boolean canShowInSource() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    int n = breakpoint.getType();
                    if (n == 0) {
                        return true;
                    }
                    if (n == 5) {
                        return true;
                    }
                }
                return false;
            }

            void showInSource() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    int n = breakpoint.getType();
                    if (n == 0) {
                        String string = breakpoint.getPackage();
                        String string2 = breakpoint.getFile();
                        int n2 = breakpoint.getLine();
                        Source.showSourceFile(BreakpointsWindow.ra$workspace(BreakpointsWindow.this), BreakpointsWindow.ra$project(BreakpointsWindow.this), string, null, string2, n2, false);
                    } else if (n == 5) {
                        URL uRL = breakpoint.getURL();
                        int n3 = breakpoint.getLine();
                        Source.showSourceFile(BreakpointsWindow.ra$workspace(BreakpointsWindow.this), BreakpointsWindow.ra$project(BreakpointsWindow.this), uRL, n3, false);
                    }
                }
            }

            boolean isScope(int n) {
                if (this.info instanceof Breakpoint) {
                    URL uRL = this.getOwnerURL();
                    if (n == BreakpointsWindow.ra$CHANGE_SCOPE_GLOBAL_CMD_ID()) {
                        return uRL == null;
                    }
                    if (n == BreakpointsWindow.ra$CHANGE_SCOPE_WORKSPACE_CMD_ID()) {
                        return BreakpointsWindow.ra$workspace(BreakpointsWindow.this) != null && BreakpointsWindow.ra$workspace(BreakpointsWindow.this).getURL().equals(uRL);
                    }
                    if (n == BreakpointsWindow.ra$CHANGE_SCOPE_PROJECT_CMD_ID()) {
                        return BreakpointsWindow.ra$project(BreakpointsWindow.this) != null && BreakpointsWindow.ra$project(BreakpointsWindow.this).getURL().equals(uRL);
                    }
                }
                return false;
            }

            boolean canChangeScope(int n) {
                if (this.info instanceof Breakpoint && !((Breakpoint)this.info).isPersistent()) {
                    if (n == BreakpointsWindow.ra$CHANGE_SCOPE_GLOBAL_CMD_ID()) {
                        return true;
                    }
                    if (n == BreakpointsWindow.ra$CHANGE_SCOPE_WORKSPACE_CMD_ID()) {
                        return BreakpointsWindow.ra$workspace(BreakpointsWindow.this) != null;
                    }
                    if (n == BreakpointsWindow.ra$CHANGE_SCOPE_PROJECT_CMD_ID()) {
                        return BreakpointsWindow.ra$project(BreakpointsWindow.this) != null;
                    }
                }
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            void changeScope(int n) {
                URL uRL;
                if (!(this.info instanceof Breakpoint)) return;
                URL uRL2 = this.getOwnerURL();
                if (n == BreakpointsWindow.ra$CHANGE_SCOPE_GLOBAL_CMD_ID()) {
                    uRL = null;
                } else if (n == BreakpointsWindow.ra$CHANGE_SCOPE_WORKSPACE_CMD_ID()) {
                    if (BreakpointsWindow.ra$workspace(BreakpointsWindow.this) == null || BreakpointsWindow.ra$workspace(BreakpointsWindow.this) == Ide.getDefaultWorkspace()) return;
                    uRL = BreakpointsWindow.ra$workspace(BreakpointsWindow.this).getURL();
                } else {
                    if (n != BreakpointsWindow.ra$CHANGE_SCOPE_PROJECT_CMD_ID()) return;
                    if (BreakpointsWindow.ra$project(BreakpointsWindow.this) == null || BreakpointsWindow.ra$project(BreakpointsWindow.this) == Ide.getDefaultProject()) return;
                    uRL = BreakpointsWindow.ra$project(BreakpointsWindow.this).getURL();
                }
                if (uRL2 == uRL) return;
                Breakpoint breakpoint = (Breakpoint)this.info;
                Breakpoint.removeBreakpointFromOwner(breakpoint);
                breakpoint.setOwnerURL(uRL);
                Breakpoint.addBreakpointToOwner(breakpoint);
            }

            boolean canDisable() {
                block6: {
                    block5: {
                        if (this.info instanceof Breakpoint) {
                            Breakpoint breakpoint = (Breakpoint)this.info;
                            return breakpoint.isEnabledNow();
                        }
                        if (!(this.info instanceof String)) break block5;
                        BreakpointItem[] breakpointItemArray = this.getChildNodes();
                        int n = breakpointItemArray.length - 1;
                        while (n >= 0) {
                            if (breakpointItemArray[n].canDisable()) {
                                return true;
                            }
                            --n;
                        }
                        break block6;
                    }
                    if (!(this.info instanceof List)) break block6;
                    List list = (List)this.info;
                    int n = list.size() - 1;
                    while (n >= 0) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(n);
                        if (breakpointItem.canDisable()) {
                            return true;
                        }
                        --n;
                    }
                }
                return false;
            }

            void disable() {
                block6: {
                    block5: {
                        if (!(this.info instanceof Breakpoint)) break block5;
                        Breakpoint breakpoint = (Breakpoint)this.info;
                        if (!breakpoint.isEnabledNow()) break block6;
                        breakpoint.setEnabled(false);
                        break block6;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItemArray = this.getChildNodes();
                        int n = breakpointItemArray.length - 1;
                        while (n >= 0) {
                            breakpointItemArray[n].disable();
                            --n;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int n = list.size() - 1;
                        while (n >= 0) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(n);
                            breakpointItem.disable();
                            --n;
                        }
                    }
                }
            }

            boolean canEnable() {
                block6: {
                    block5: {
                        if (this.info instanceof Breakpoint) {
                            Breakpoint breakpoint = (Breakpoint)this.info;
                            return breakpoint.isEnabledNow() ^ true;
                        }
                        if (!(this.info instanceof String)) break block5;
                        BreakpointItem[] breakpointItemArray = this.getChildNodes();
                        int n = breakpointItemArray.length - 1;
                        while (n >= 0) {
                            if (breakpointItemArray[n].canEnable()) {
                                return true;
                            }
                            --n;
                        }
                        break block6;
                    }
                    if (!(this.info instanceof List)) break block6;
                    List list = (List)this.info;
                    int n = list.size() - 1;
                    while (n >= 0) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(n);
                        if (breakpointItem.canEnable()) {
                            return true;
                        }
                        --n;
                    }
                }
                return false;
            }

            void enable() {
                block6: {
                    block5: {
                        if (!(this.info instanceof Breakpoint)) break block5;
                        Breakpoint breakpoint = (Breakpoint)this.info;
                        if (breakpoint.isEnabledNow()) break block6;
                        breakpoint.setEnabled(true);
                        break block6;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItemArray = this.getChildNodes();
                        int n = breakpointItemArray.length - 1;
                        while (n >= 0) {
                            breakpointItemArray[n].enable();
                            --n;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int n = list.size() - 1;
                        while (n >= 0) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(n);
                            breakpointItem.enable();
                            --n;
                        }
                    }
                }
            }

            boolean canRemove() {
                block6: {
                    block7: {
                        block5: {
                            if (!(this.info instanceof Breakpoint)) break block5;
                            Breakpoint breakpoint = (Breakpoint)this.info;
                            if (!breakpoint.isPersistent()) {
                                return true;
                            }
                            break block6;
                        }
                        if (!(this.info instanceof String)) break block7;
                        BreakpointItem[] breakpointItemArray = this.getChildNodes();
                        int n = breakpointItemArray.length - 1;
                        while (n >= 0) {
                            if (breakpointItemArray[n].canRemove()) {
                                return true;
                            }
                            --n;
                        }
                        break block6;
                    }
                    if (!(this.info instanceof List)) break block6;
                    List list = (List)this.info;
                    int n = list.size() - 1;
                    while (n >= 0) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(n);
                        if (breakpointItem.canRemove()) {
                            return true;
                        }
                        --n;
                    }
                }
                return false;
            }

            void remove() {
                if (!this.removed) {
                    if (this.info instanceof Breakpoint) {
                        Breakpoint breakpoint = (Breakpoint)this.info;
                        if (!breakpoint.isPersistent()) {
                            breakpoint.removeBreakpoint();
                        }
                    } else if (this.info instanceof String) {
                        BreakpointItem[] breakpointItemArray = this.getChildNodes();
                        int n = breakpointItemArray.length - 1;
                        while (n >= 0) {
                            breakpointItemArray[n].remove();
                            --n;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int n = list.size() - 1;
                        while (n >= 0) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(n);
                            breakpointItem.remove();
                            --n;
                        }
                    }
                }
                this.removed = true;
            }

            boolean canEditOptions() {
                return true;
            }

            public String getShortLabel() {
                return this.getDescriptionColumnValue();
            }

            public Icon getIcon() {
                if (this.info instanceof Breakpoint) {
                    return ((Breakpoint)this.info).getIcon();
                }
                return null;
            }

            public Object getData() {
                return this;
            }

            public boolean mayHaveChildren() {
                return this.info instanceof String;
            }

            public Iterator getChildren() {
                return Arrays.asList(this.getChildNodes()).iterator();
            }

            public DataFlavor[] getTransferDataFlavors() {
                if (BreakpointsWindow.ra$transferFlavors() == null) {
                    BreakpointsWindow.wa$transferFlavors(new DataFlavor[2]);
                    BreakpointsWindow.ra$transferFlavors()[0] = BreakpointsWindow.maS$getBreakpointFlavor();
                    BreakpointsWindow.ra$transferFlavors()[1] = DataFlavor.stringFlavor;
                }
                return BreakpointsWindow.ra$transferFlavors();
            }

            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                if (dataFlavor.equals(BreakpointsWindow.maS$getBreakpointFlavor())) {
                    return true;
                }
                return dataFlavor.equals(DataFlavor.stringFlavor);
            }

            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (dataFlavor.equals(BreakpointsWindow.maS$getBreakpointFlavor())) {
                    return this;
                }
                if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                    return this.getShortLabel();
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }

            String getDescriptionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getDescription();
                }
                if (this.info instanceof String) {
                    String string = (String)this.info;
                    return string;
                }
                return "";
            }

            String getScopeColumnValue() {
                if (this.info instanceof Breakpoint) {
                    URL uRL = this.getOwnerURL();
                    if (uRL == null) {
                        return DbgArb.getString(420);
                    }
                    return URLFileSystem.getFileName((URL)uRL);
                }
                return "";
            }

            String getTypeColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getTypeString();
                }
                return "";
            }

            String getStatusColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getStatusInfo();
                }
                return "";
            }

            String getGroupColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getGroupName();
                }
                return "";
            }

            String getConditionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getCondition();
                }
                return "";
            }

            String getThreadColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    String string = breakpoint.getThreadName();
                    if (string.length() > 0) {
                        return string;
                    }
                    String string2 = breakpoint.getThreadNameNot();
                    if (string2.length() > 0) {
                        return DbgArb.format(421, string2);
                    }
                }
                return "";
            }

            String getPassCountColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getPassCountInfo();
                }
                return "";
            }

            String getActionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getAction();
                }
                return "";
            }

            String getInstanceFiltersColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)this.info;
                    return breakpoint.getInstanceFilters();
                }
                return "";
            }

            int countChildNodes() {
                if (this.info instanceof String) {
                    return this.getChildNodes().length;
                }
                return 0;
            }

            BreakpointItem[] getChildNodes() {
                if (this.info instanceof String) {
                    if (this.children == null) {
                        String string = (String)this.info;
                        List list = BreakpointsWindow.mav$getBreakpointsForGroup(BreakpointsWindow.this, string);
                        int n = list.size();
                        this.children = new BreakpointItem[n];
                        int n2 = 0;
                        while (n2 < n) {
                            Breakpoint breakpoint = (Breakpoint)list.get(n2);
                            this.children[n2] = new BreakpointItem(breakpoint);
                            ++n2;
                        }
                    }
                    return this.children;
                }
                return new BreakpointItem[0];
            }

            public int hashCode() {
                return this.info.hashCode();
            }

            public boolean equals(Object object) {
                if (object instanceof BreakpointItem) {
                    BreakpointItem breakpointItem = (BreakpointItem)object;
                    return this.info.equals(breakpointItem.info);
                }
                return false;
            }
        }
    }
}

