/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Arrays;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.ClientSetting;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class BreakpointsWindowSettings
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "BreakpointsWindowOptions";
    public static final String BREAKPOINT_SCOPE_GLOBAL = "global";
    public static final String BREAKPOINT_SCOPE_WORKSPACE = "workspace";
    public static final String BREAKPOINT_SCOPE_PROJECT = "project";
    private final boolean[] _columnVisible;
    private final int[] _columnWidth;
    private String _columnOrder;
    private String _breakpointScope;
    private boolean _defaultActionHalt;
    private boolean _defaultActionBeep;
    private boolean _defaultActionLog;
    private String _defaultActionLogTag;
    private String _defaultActionLogExpr;
    private boolean _defaultActionLogStack;
    private String _defaultActionEnableOther;
    private String _defaultActionDisableOther;

    static BreakpointsWindowSettings getInstance() {
        return (BreakpointsWindowSettings)ClientSetting.findOrCreate((String)JDebugger.getExtensionID()).getData(KEY_SETTINGS);
    }

    void $init$() {
        this._columnVisible = new boolean[10];
        this._columnWidth = new int[10];
    }

    public BreakpointsWindowSettings() {
        this.$init$();
        this.defaultInit();
    }

    public BreakpointsWindowSettings(BreakpointsWindowSettings breakpointsWindowSettings) {
        this.$init$();
        if (breakpointsWindowSettings == null) {
            this.defaultInit();
        } else {
            breakpointsWindowSettings.copyToImpl(this);
        }
    }

    private void defaultInit() {
        Arrays.fill(this._columnVisible, false);
        this._columnVisible[0] = true;
        this._columnVisible[1] = true;
        Arrays.fill(this._columnWidth, 0);
        this._columnOrder = null;
        this._breakpointScope = BREAKPOINT_SCOPE_WORKSPACE;
        this._defaultActionHalt = true;
        this._defaultActionBeep = false;
        this._defaultActionLog = true;
        this._defaultActionLogTag = "";
        this._defaultActionLogExpr = "";
        this._defaultActionLogStack = false;
        this._defaultActionEnableOther = "";
        this._defaultActionDisableOther = "";
    }

    public Object copyTo(Object object) {
        BreakpointsWindowSettings breakpointsWindowSettings = object != null ? (BreakpointsWindowSettings)((Object)object) : new BreakpointsWindowSettings();
        this.copyToImpl(breakpointsWindowSettings);
        return breakpointsWindowSettings;
    }

    protected final void copyToImpl(BreakpointsWindowSettings breakpointsWindowSettings) {
        System.arraycopy(this._columnVisible, 0, breakpointsWindowSettings._columnVisible, 0, this._columnVisible.length);
        System.arraycopy(this._columnWidth, 0, breakpointsWindowSettings._columnWidth, 0, this._columnWidth.length);
        breakpointsWindowSettings._columnOrder = this._columnOrder;
        breakpointsWindowSettings._breakpointScope = this._breakpointScope;
        breakpointsWindowSettings._defaultActionHalt = this._defaultActionHalt;
        breakpointsWindowSettings._defaultActionBeep = this._defaultActionBeep;
        breakpointsWindowSettings._defaultActionLog = this._defaultActionLog;
        breakpointsWindowSettings._defaultActionLogTag = this._defaultActionLogTag;
        breakpointsWindowSettings._defaultActionLogExpr = this._defaultActionLogExpr;
        breakpointsWindowSettings._defaultActionLogStack = this._defaultActionLogStack;
        breakpointsWindowSettings._defaultActionEnableOther = this._defaultActionEnableOther;
        breakpointsWindowSettings._defaultActionDisableOther = this._defaultActionDisableOther;
        breakpointsWindowSettings.fireChangeEvent();
    }

    public boolean[] getColumnVisible() {
        return this._columnVisible;
    }

    public void setColumnVisible(boolean[] blArray) {
        System.arraycopy(blArray, 0, this._columnVisible, 0, blArray.length);
    }

    public int[] getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int[] nArray) {
        System.arraycopy(nArray, 0, this._columnWidth, 0, nArray.length);
    }

    public String getColumnOrder() {
        return this._columnOrder;
    }

    public void setColumnOrder(String string) {
        this._columnOrder = string;
    }

    public String getBreakpointScope() {
        return this._breakpointScope;
    }

    public void setBreakpointScope(String string) {
        this._breakpointScope = string;
    }

    public boolean getDefaultActionHalt() {
        return this._defaultActionHalt;
    }

    public void setDefaultActionHalt(boolean bl) {
        this._defaultActionHalt = bl;
    }

    public boolean getDefaultActionBeep() {
        return this._defaultActionBeep;
    }

    public void setDefaultActionBeep(boolean bl) {
        this._defaultActionBeep = bl;
    }

    public boolean getDefaultActionLog() {
        return this._defaultActionLog;
    }

    public void setDefaultActionLog(boolean bl) {
        this._defaultActionLog = bl;
    }

    public String getDefaultActionLogTag() {
        return this._defaultActionLogTag;
    }

    public void setDefaultActionLogTag(String string) {
        this._defaultActionLogTag = string;
    }

    public String getDefaultActionLogExpr() {
        return this._defaultActionLogExpr;
    }

    public void setDefaultActionLogExpr(String string) {
        this._defaultActionLogExpr = string;
    }

    public boolean getDefaultActionLogStack() {
        return this._defaultActionLogStack;
    }

    public void setDefaultActionLogStack(boolean bl) {
        this._defaultActionLogStack = bl;
    }

    public String getDefaultActionEnableOther() {
        return this._defaultActionEnableOther;
    }

    public void setDefaultActionEnableOther(String string) {
        this._defaultActionEnableOther = string;
    }

    public String getDefaultActionDisableOther() {
        return this._defaultActionDisableOther;
    }

    public void setDefaultActionDisableOther(String string) {
        this._defaultActionDisableOther = string;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((BreakpointsWindowSettings)((Object)object));
    }

    protected final boolean equalsImpl(BreakpointsWindowSettings breakpointsWindowSettings) {
        return Arrays.equals(this._columnVisible, breakpointsWindowSettings._columnVisible) && Arrays.equals(this._columnWidth, breakpointsWindowSettings._columnWidth) && ModelUtil.areEqual((Object)this._columnOrder, (Object)breakpointsWindowSettings._columnOrder) && ModelUtil.areEqual((Object)this._breakpointScope, (Object)breakpointsWindowSettings._breakpointScope) && this._defaultActionHalt == breakpointsWindowSettings._defaultActionHalt && this._defaultActionBeep == breakpointsWindowSettings._defaultActionBeep && this._defaultActionLog == breakpointsWindowSettings._defaultActionLog && ModelUtil.areEqual((Object)this._defaultActionLogTag, (Object)breakpointsWindowSettings._defaultActionLogTag) && ModelUtil.areEqual((Object)this._defaultActionLogExpr, (Object)breakpointsWindowSettings._defaultActionLogExpr) && this._defaultActionLogStack == breakpointsWindowSettings._defaultActionLogStack && ModelUtil.areEqual((Object)this._defaultActionEnableOther, (Object)breakpointsWindowSettings._defaultActionEnableOther) && ModelUtil.areEqual((Object)this._defaultActionDisableOther, (Object)breakpointsWindowSettings._defaultActionDisableOther);
    }
}

