/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

public final class BreakpointsWindowSettingsPanel
extends DefaultTraversablePanel {
    private JCheckBox showColumnDescriptionCheckBox;
    private JCheckBox showColumnTypeCheckBox;
    private JCheckBox showColumnStatusCheckBox;
    private JCheckBox showColumnScopeCheckBox;
    private JCheckBox showColumnGroupCheckBox;
    private JCheckBox showColumnConditionCheckBox;
    private JCheckBox showColumnThreadCheckBox;
    private JCheckBox showColumnPasscountCheckBox;
    private JCheckBox showColumnInstanceFiltersCheckBox;
    private JCheckBox showColumnActionCheckBox;
    private JRadioButton bpScopeGlobalRadio;
    private JRadioButton bpScopeWorkspaceRadio;
    private JRadioButton bpScopeProjectRadio;

    public BreakpointsWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_breakpointswinsetpanel_html");
        this.showColumnDescriptionCheckBox = new JCheckBox();
        this.showColumnTypeCheckBox = new JCheckBox();
        this.showColumnStatusCheckBox = new JCheckBox();
        this.showColumnScopeCheckBox = new JCheckBox();
        this.showColumnGroupCheckBox = new JCheckBox();
        this.showColumnConditionCheckBox = new JCheckBox();
        this.showColumnThreadCheckBox = new JCheckBox();
        this.showColumnPasscountCheckBox = new JCheckBox();
        this.showColumnInstanceFiltersCheckBox = new JCheckBox();
        this.showColumnActionCheckBox = new JCheckBox();
        this.bpScopeGlobalRadio = new JRadioButton();
        this.bpScopeWorkspaceRadio = new JRadioButton();
        this.bpScopeProjectRadio = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bpScopeGlobalRadio);
        buttonGroup.add(this.bpScopeWorkspaceRadio);
        buttonGroup.add(this.bpScopeProjectRadio);
        ResourceUtils.resButton((AbstractButton)this.showColumnDescriptionCheckBox, (String)DbgArb.getString(735));
        ResourceUtils.resButton((AbstractButton)this.showColumnTypeCheckBox, (String)DbgArb.getString(736));
        ResourceUtils.resButton((AbstractButton)this.showColumnStatusCheckBox, (String)DbgArb.getString(737));
        ResourceUtils.resButton((AbstractButton)this.showColumnScopeCheckBox, (String)DbgArb.getString(738));
        ResourceUtils.resButton((AbstractButton)this.showColumnGroupCheckBox, (String)DbgArb.getString(739));
        ResourceUtils.resButton((AbstractButton)this.showColumnConditionCheckBox, (String)DbgArb.getString(740));
        ResourceUtils.resButton((AbstractButton)this.showColumnThreadCheckBox, (String)DbgArb.getString(741));
        ResourceUtils.resButton((AbstractButton)this.showColumnPasscountCheckBox, (String)DbgArb.getString(742));
        ResourceUtils.resButton((AbstractButton)this.showColumnInstanceFiltersCheckBox, (String)DbgArb.getString(743));
        ResourceUtils.resButton((AbstractButton)this.showColumnActionCheckBox, (String)DbgArb.getString(744));
        ResourceUtils.resButton((AbstractButton)this.bpScopeGlobalRadio, (String)DbgArb.getString(746));
        ResourceUtils.resButton((AbstractButton)this.bpScopeWorkspaceRadio, (String)DbgArb.getString(747));
        ResourceUtils.resButton((AbstractButton)this.bpScopeProjectRadio, (String)DbgArb.getString(748));
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(this.makeChooseColumnsPanel(), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.makeBPScopePanel(), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n++, 0, 1, 1.0, 1.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
    }

    private JPanel makeChooseColumnsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(RunMgrArb.getString(94)));
        jPanel.add(this.showColumnDescriptionCheckBox);
        jPanel.add(this.showColumnTypeCheckBox);
        jPanel.add(this.showColumnStatusCheckBox);
        jPanel.add(this.showColumnScopeCheckBox);
        jPanel.add(this.showColumnGroupCheckBox);
        jPanel.add(this.showColumnConditionCheckBox);
        jPanel.add(this.showColumnThreadCheckBox);
        jPanel.add(this.showColumnPasscountCheckBox);
        jPanel.add(this.showColumnInstanceFiltersCheckBox);
        jPanel.add(this.showColumnActionCheckBox);
        return jPanel;
    }

    private JPanel makeBPScopePanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 0, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(745)));
        jPanel.add(this.bpScopeGlobalRadio);
        jPanel.add(this.bpScopeWorkspaceRadio);
        jPanel.add(this.bpScopeProjectRadio);
        return jPanel;
    }

    public void onEntry(TraversableContext traversableContext) {
        BreakpointsWindowSettings breakpointsWindowSettings = (BreakpointsWindowSettings)((Object)traversableContext.find("BreakpointsWindowOptions"));
        boolean[] blArray = breakpointsWindowSettings.getColumnVisible();
        this.showColumnDescriptionCheckBox.setSelected(true);
        this.showColumnDescriptionCheckBox.setEnabled(false);
        this.showColumnTypeCheckBox.setSelected(blArray[1]);
        this.showColumnStatusCheckBox.setSelected(blArray[2]);
        this.showColumnScopeCheckBox.setSelected(blArray[3]);
        this.showColumnGroupCheckBox.setSelected(blArray[4]);
        this.showColumnConditionCheckBox.setSelected(blArray[5]);
        this.showColumnThreadCheckBox.setSelected(blArray[6]);
        this.showColumnPasscountCheckBox.setSelected(blArray[7]);
        this.showColumnInstanceFiltersCheckBox.setSelected(blArray[9]);
        this.showColumnActionCheckBox.setSelected(blArray[8]);
        this.bpScopeGlobalRadio.setSelected(false);
        this.bpScopeWorkspaceRadio.setSelected(false);
        this.bpScopeProjectRadio.setSelected(false);
        String string = breakpointsWindowSettings.getBreakpointScope();
        if (string.equals("global")) {
            this.bpScopeGlobalRadio.setSelected(true);
        } else if (string.equals("project")) {
            this.bpScopeProjectRadio.setSelected(true);
        } else {
            this.bpScopeWorkspaceRadio.setSelected(true);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        BreakpointsWindowSettings breakpointsWindowSettings = (BreakpointsWindowSettings)((Object)traversableContext.find("BreakpointsWindowOptions"));
        boolean[] blArray = breakpointsWindowSettings.getColumnVisible();
        blArray[0] = true;
        blArray[1] = this.showColumnTypeCheckBox.isSelected();
        blArray[2] = this.showColumnStatusCheckBox.isSelected();
        blArray[3] = this.showColumnScopeCheckBox.isSelected();
        blArray[4] = this.showColumnGroupCheckBox.isSelected();
        blArray[5] = this.showColumnConditionCheckBox.isSelected();
        blArray[6] = this.showColumnThreadCheckBox.isSelected();
        blArray[7] = this.showColumnPasscountCheckBox.isSelected();
        blArray[9] = this.showColumnInstanceFiltersCheckBox.isSelected();
        blArray[8] = this.showColumnActionCheckBox.isSelected();
        String string = this.bpScopeGlobalRadio.isSelected() ? "global" : (this.bpScopeProjectRadio.isSelected() ? "project" : "workspace");
        breakpointsWindowSettings.setBreakpointScope(string);
    }
}

