/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.net.EncoderUtils;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleBytecode;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleJava;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BytecodeFileSystemHelper
extends URLFileSystemHelper {
    public static final String DBG_PROTOCOL = "ide.dbg";
    public static final String DBG_BYTECODE_PATH = "bytecode/";
    public static final String DBG_BYTECODE_QUERY = "method=";
    private Map<URL, BytecodeInfo> urlToInfo = new HashMap<URL, BytecodeInfo>();
    private static BytecodeFileSystemHelper instance;

    static synchronized BytecodeFileSystemHelper getInstance(boolean bl) {
        if (instance == null && bl) {
            instance = new BytecodeFileSystemHelper();
            URLFileSystem.registerHelper((String)DBG_PROTOCOL, (URLFileSystemHelper)instance);
            JDebugger.getInstance().addStepBytecodeActions();
        }
        return instance;
    }

    private BytecodeFileSystemHelper() {
    }

    private static String getBytecode(DebugMethodInfo debugMethodInfo, Workspace workspace, Project project, Map<Integer, Integer> map, Map<Integer, Integer> map2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        TextNode textNode = null;
        TextBuffer textBuffer = null;
        LineMap lineMap = null;
        try {
            DebugClassInfo debugClassInfo = debugMethodInfo.getClassInfo();
            URL uRL = Source.findSourceFile(workspace, project, debugClassInfo.getPackage(), debugClassInfo.getPrimarySourceFilename());
            if (uRL != null) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)uRL);
                    if (node instanceof TextNode) {
                        TextNode textNode2 = (TextNode)node;
                        TextBuffer textBuffer2 = textNode2.acquireTextBuffer();
                        textNode = textNode2;
                        textBuffer2.readLock();
                        textBuffer = textBuffer2;
                        lineMap = textBuffer.getLineMap();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl = textBuffer != null && lineMap != null;
            DebugDisassembleInfo[] debugDisassembleInfoArray = debugMethodInfo.disassembleMethod(bl, true, false, project);
            int n = 1;
            int n2 = 0;
            while (n2 < debugDisassembleInfoArray.length) {
                if (debugDisassembleInfoArray[n2] instanceof DebugDisassembleJava) {
                    DebugDisassembleJava debugDisassembleJava = (DebugDisassembleJava)debugDisassembleInfoArray[n2];
                    int n3 = debugDisassembleJava.getLineNumber();
                    String string = IdeUtil.prepad((String)Integer.toString(n3), (char)' ', (int)8);
                    fastStringBuffer.append(string);
                    String string2 = "\n";
                    try {
                        int n4 = lineMap.getLineStartOffset(n3 - 1);
                        int n5 = lineMap.getLineEndOffset(n3 - 1);
                        string2 = textBuffer.getString(n4, n5 - n4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fastStringBuffer.append(string2);
                    ++n;
                } else if (debugDisassembleInfoArray[n2] instanceof DebugDisassembleBytecode) {
                    DebugDisassembleBytecode debugDisassembleBytecode = (DebugDisassembleBytecode)debugDisassembleInfoArray[n2];
                    int n6 = debugDisassembleBytecode.getOffset();
                    String string = IdeUtil.prepad((String)Integer.toString(n6), (char)' ', (int)16);
                    fastStringBuffer.append(string);
                    fastStringBuffer.append("        ");
                    fastStringBuffer.append(debugDisassembleBytecode.getBytecode());
                    fastStringBuffer.append("\n");
                    map.put(n6, n);
                    map2.put(n, n6);
                    ++n;
                }
                ++n2;
            }
        }
        finally {
            if (textBuffer != null) {
                textBuffer.readUnlock();
            }
            if (textNode != null) {
                textNode.releaseTextBuffer();
            }
        }
        return fastStringBuffer.toString();
    }

    private static String getWorkspacePart(DebuggingProcess debuggingProcess) {
        String string = "w";
        Workspace workspace = debuggingProcess.getWorkspace();
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            string = string + Integer.toString(workspace.hashCode());
        }
        return string;
    }

    private static String getProjectPart(DebuggingProcess debuggingProcess) {
        String string = "p";
        Project project = debuggingProcess.getProject();
        if (project != null && project != Ide.getDefaultProject()) {
            string = string + Integer.toString(project.hashCode());
        }
        return string;
    }

    private static String getInitialPath(DebuggingProcess debuggingProcess) {
        String string = DBG_BYTECODE_PATH;
        string = string + BytecodeFileSystemHelper.getWorkspacePart(debuggingProcess);
        string = string + "/";
        string = string + BytecodeFileSystemHelper.getProjectPart(debuggingProcess);
        string = string + "/";
        return string;
    }

    private URL makeURL(DebuggingProcess debuggingProcess, DebugMethodInfo debugMethodInfo) {
        String string = BytecodeFileSystemHelper.getInitialPath(debuggingProcess);
        string = string + debugMethodInfo.getClassInfo().getNameWithoutPackage();
        string = string + ".";
        string = string + debugMethodInfo.getNameWithoutClassOrSignature();
        String string2 = DBG_BYTECODE_QUERY;
        try {
            string2 = string2 + EncoderUtils.encodeString((String)debugMethodInfo.getName(), (String)Encodings.getDefaultEncoding());
        }
        catch (Exception exception) {
            string2 = string2 + debugMethodInfo.getName();
        }
        URL uRL = URLFactory.newURL((String)DBG_PROTOCOL, (String)string);
        uRL = URLFactory.replaceQueryPart((URL)uRL, (String)string2);
        return uRL;
    }

    URL getURL(DebuggingProcess debuggingProcess, DebugMethodInfo debugMethodInfo) {
        URL uRL = this.makeURL(debuggingProcess, debugMethodInfo);
        if (this.urlToInfo.containsKey(uRL)) {
            return uRL;
        }
        return null;
    }

    static String getMethodName(URL uRL) {
        try {
            String string;
            if (uRL.getProtocol().equals(DBG_PROTOCOL) && uRL.getPath().startsWith(DBG_BYTECODE_PATH) && (string = uRL.getQuery()).startsWith(DBG_BYTECODE_QUERY)) {
                String string2 = string.substring(DBG_BYTECODE_QUERY.length());
                String string3 = string2 = EncoderUtils.decodeString((String)string2, (String)Encodings.getDefaultEncoding());
                return string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    int getBytecodeOffsetFromLine(URL uRL, int n) {
        Integer n2;
        BytecodeInfo bytecodeInfo = this.urlToInfo.get(uRL);
        if (bytecodeInfo != null && bytecodeInfo.lineToOffsetMap != null && (n2 = bytecodeInfo.lineToOffsetMap.get(n)) != null) {
            return n2;
        }
        return -1;
    }

    int getLineFromBytecodeOffset(URL uRL, int n) {
        Integer n2;
        BytecodeInfo bytecodeInfo = this.urlToInfo.get(uRL);
        if (bytecodeInfo != null && bytecodeInfo.offsetToLineMap != null && (n2 = bytecodeInfo.offsetToLineMap.get(n)) != null) {
            return n2;
        }
        return 0;
    }

    URL addMethod(DebuggingProcess debuggingProcess, DebugMethodInfo debugMethodInfo) {
        URL uRL = this.makeURL(debuggingProcess, debugMethodInfo);
        BytecodeInfo bytecodeInfo = this.urlToInfo.get(uRL);
        if (bytecodeInfo == null) {
            bytecodeInfo = new BytecodeInfo();
            this.urlToInfo.put(uRL, bytecodeInfo);
        }
        BytecodeInfo.mav$setMethod(bytecodeInfo, debugMethodInfo, debuggingProcess.getWorkspace(), debuggingProcess.getProject());
        this.updateMethod(uRL);
        return uRL;
    }

    void updateMethods(DebuggingProcess debuggingProcess) {
        DebugVirtualMachine debugVirtualMachine = debuggingProcess.getVM();
        String string = BytecodeFileSystemHelper.getInitialPath(debuggingProcess);
        for (Map.Entry<URL, BytecodeInfo> entry : this.urlToInfo.entrySet()) {
            String string2;
            DebugClassInfo debugClassInfo;
            String string3;
            URL uRL = entry.getKey();
            String string4 = uRL.getPath();
            if (!string4.startsWith(string)) continue;
            BytecodeInfo bytecodeInfo = entry.getValue();
            if (BytecodeInfo.mav$wasCleared(bytecodeInfo) && debugVirtualMachine != null && (string3 = BytecodeFileSystemHelper.getMethodName(uRL)) != null && (debugClassInfo = debugVirtualMachine.findFirstClassByName(string2 = DebugShared.getMethodClassName(string3))) != null) {
                DebugMethodInfo[] debugMethodInfoArray = debugClassInfo.getMethods();
                int n = debugMethodInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (string3.equals(debugMethodInfoArray[n2].getName())) {
                        BytecodeInfo.mav$setMethod(bytecodeInfo, debugMethodInfoArray[n2], debuggingProcess.getWorkspace(), debuggingProcess.getProject());
                        break;
                    }
                    ++n2;
                }
            }
            this.updateMethod(uRL);
        }
    }

    void removeStaleMethods() {
        for (BytecodeInfo bytecodeInfo : this.urlToInfo.values()) {
            if (bytecodeInfo.method == null || bytecodeInfo.method.getVM().isConnected()) continue;
            BytecodeInfo.mav$clear(bytecodeInfo);
        }
    }

    private void updateMethod(URL uRL) {
        Node node = NodeFactory.find((URL)uRL);
        if (node != null) {
            SwingUtilities.invokeLater(new 1(this, node));
        }
    }

    private synchronized BytecodeInfo fetchSource(URL uRL) {
        BytecodeInfo bytecodeInfo = this.urlToInfo.get(uRL);
        try {
            if (bytecodeInfo != null && bytecodeInfo.method != null) {
                HashMap<Integer, Integer> hashMap;
                HashMap<Integer, Integer> hashMap2;
                String string;
                boolean bl = false;
                if (bytecodeInfo.source == null) {
                    bl = true;
                } else if (bytecodeInfo.method.hasMethodChanged()) {
                    bl = true;
                }
                if (bl && (string = BytecodeFileSystemHelper.getBytecode(bytecodeInfo.method, bytecodeInfo.workspace, bytecodeInfo.project, hashMap2 = new HashMap<Integer, Integer>(), hashMap = new HashMap<Integer, Integer>())) != null && string.length() > 0) {
                    BytecodeInfo.mav$setSource(bytecodeInfo, string, hashMap2, hashMap);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytecodeInfo;
    }

    private synchronized boolean sourceExists(URL uRL) {
        BytecodeInfo bytecodeInfo = this.fetchSource(uRL);
        return bytecodeInfo != null ? BytecodeInfo.mav$sourceExists(bytecodeInfo) : false;
    }

    public boolean canRead(URL uRL) {
        return this.sourceExists(uRL);
    }

    public boolean canWrite(URL uRL) {
        return false;
    }

    public boolean canCreate(URL uRL) {
        return false;
    }

    public boolean canDelete(URL uRL) {
        return false;
    }

    public boolean isValid(URL uRL) {
        return this.sourceExists(uRL);
    }

    public boolean exists(URL uRL) {
        return this.sourceExists(uRL);
    }

    public Icon getDefaultIcon(URL uRL) {
        return JavaIcons.getIcon(3);
    }

    public synchronized long getLength(URL uRL) {
        BytecodeInfo bytecodeInfo = this.fetchSource(uRL);
        return bytecodeInfo != null ? BytecodeInfo.mav$getSourceLength(bytecodeInfo) : 0;
    }

    public URL getParent(URL uRL) {
        return null;
    }

    public boolean isReadOnly(URL uRL) {
        return true;
    }

    public synchronized long lastModified(URL uRL) {
        BytecodeInfo bytecodeInfo = this.fetchSource(uRL);
        return bytecodeInfo != null ? bytecodeInfo.time : (long)-1;
    }

    public synchronized InputStream openInputStream(URL uRL) throws IOException {
        BytecodeInfo bytecodeInfo = this.fetchSource(uRL);
        byte[] byArray = bytecodeInfo != null ? BytecodeInfo.mav$getSourceBytes(bytecodeInfo) : new byte[]{};
        return new ByteArrayInputStream(byArray);
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        throw new UnknownServiceException();
    }

    public synchronized Reader createReader(URL uRL, String string) throws IOException {
        BytecodeInfo bytecodeInfo = this.fetchSource(uRL);
        return new StringReader(bytecodeInfo != null ? BytecodeInfo.mav$getSourceString(bytecodeInfo) : "");
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ BytecodeFileSystemHelper this$0;

        public void run() {
            RevertNodeCommand.reload((Node)this.v$node);
        }

        public 1(BytecodeFileSystemHelper bytecodeFileSystemHelper, Node node) {
            this.v$node = node;
            this.this$0 = bytecodeFileSystemHelper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BytecodeInfo {
        DebugMethodInfo method;
        Workspace workspace;
        Project project;
        long time = -1;
        String source;
        Map<Integer, Integer> offsetToLineMap;
        Map<Integer, Integer> lineToOffsetMap;

        BytecodeInfo() {
        }

        private void setMethod(DebugMethodInfo debugMethodInfo, Workspace workspace, Project project) {
            this.method = debugMethodInfo;
            this.workspace = workspace;
            this.project = project;
        }

        private void clear() {
            this.method = null;
            this.workspace = null;
            this.project = null;
            this.time = -1;
        }

        private boolean wasCleared() {
            return this.method == null;
        }

        private void setSource(String string, Map<Integer, Integer> map, Map<Integer, Integer> map2) {
            this.time = new Date().getTime();
            this.source = string;
            this.offsetToLineMap = map;
            this.lineToOffsetMap = map2;
        }

        private boolean sourceExists() {
            return this.source != null;
        }

        private int getSourceLength() {
            return this.source != null ? this.source.length() : 0;
        }

        private byte[] getSourceBytes() {
            return this.source != null ? this.source.getBytes() : new byte[]{};
        }

        private String getSourceString() {
            return this.source != null ? this.source : "";
        }

        static String mav$getSourceString(BytecodeInfo bytecodeInfo) {
            return bytecodeInfo.getSourceString();
        }

        static byte[] mav$getSourceBytes(BytecodeInfo bytecodeInfo) {
            return bytecodeInfo.getSourceBytes();
        }

        static int mav$getSourceLength(BytecodeInfo bytecodeInfo) {
            return bytecodeInfo.getSourceLength();
        }

        static boolean mav$sourceExists(BytecodeInfo bytecodeInfo) {
            return bytecodeInfo.sourceExists();
        }

        static void mav$setSource(BytecodeInfo bytecodeInfo, String string, Map map, Map map2) {
            bytecodeInfo.setSource(string, map, map2);
        }

        static void mav$clear(BytecodeInfo bytecodeInfo) {
            bytecodeInfo.clear();
        }

        static boolean mav$wasCleared(BytecodeInfo bytecodeInfo) {
            return bytecodeInfo.wasCleared();
        }

        static void mav$setMethod(BytecodeInfo bytecodeInfo, DebugMethodInfo debugMethodInfo, Workspace workspace, Project project) {
            bytecodeInfo.setMethod(debugMethodInfo, workspace, project);
        }
    }
}

