/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DbgArb;

abstract class ClassesPanel
extends JPanel {
    private final JComboBox classComboBox = new JComboBox();
    private DebugClassInfo currentClass;

    protected ClassesPanel() {
    }

    protected final void createPanel(DebugClassInfo debugClassInfo) {
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.classComboBox, (String)DbgArb.getString(814));
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.addToModel(nonNullableComboBoxModel, defaultMutableTreeNode, debugClassInfo);
        this.setSelectedClass((ComboBoxModel)nonNullableComboBoxModel);
        this.classComboBox.setModel(nonNullableComboBoxModel);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.classComboBox.setRenderer(new ClassComboBoxRenderer(defaultTreeModel, this.classComboBox, null));
        JPanel jPanel = this.createBody();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(this.getAppropriateSize());
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.classComboBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.classComboBox.addItemListener(new 2());
        this.update();
    }

    private void addToModel(NonNullableComboBoxModel nonNullableComboBoxModel, DefaultMutableTreeNode defaultMutableTreeNode, DebugClassInfo debugClassInfo) {
        if (debugClassInfo != null) {
            ClassComboBoxItem classComboBoxItem = this.createClassComboBoxItem(debugClassInfo, nonNullableComboBoxModel.getSize());
            nonNullableComboBoxModel.addElement((Object)classComboBoxItem);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(classComboBoxItem);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.addToModel(nonNullableComboBoxModel, defaultMutableTreeNode2, debugClassInfo.getSuperClass(1));
            DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces();
            if (debugClassInfoArray != null) {
                Arrays.sort(debugClassInfoArray, new 1());
                int n = debugClassInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    classComboBoxItem = this.createClassComboBoxItem(debugClassInfoArray[n2], nonNullableComboBoxModel.getSize());
                    nonNullableComboBoxModel.addElement((Object)classComboBoxItem);
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(classComboBoxItem));
                    ++n2;
                }
            }
        }
    }

    private void update() {
        if (this.currentClass != null) {
            this.saveBody(this.currentClass);
        }
        this.clearBody();
        this.currentClass = ClassComboBoxItem.ra$clazz((ClassComboBoxItem)this.classComboBox.getSelectedItem());
        this.loadBody(this.currentClass);
    }

    protected Component getInitialFocus() {
        return this.classComboBox;
    }

    protected final DebugClassInfo getCurrentClass() {
        return this.currentClass;
    }

    protected ClassComboBoxItem createClassComboBoxItem(DebugClassInfo debugClassInfo, int n) {
        return new ClassComboBoxItem(debugClassInfo, n);
    }

    protected void setSelectedClass(ComboBoxModel comboBoxModel) {
        comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
    }

    abstract JPanel createBody();

    abstract Dimension getAppropriateSize();

    abstract void saveBody(DebugClassInfo var1);

    abstract void clearBody();

    abstract void loadBody(DebugClassInfo var1);

    static void mav$update(ClassesPanel classesPanel) {
        classesPanel.update();
    }

    final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            ClassesPanel.mav$update(ClassesPanel.this);
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = ((DebugClassInfo)object).getName();
            String string2 = ((DebugClassInfo)object2).getName();
            return string.compareToIgnoreCase(string2);
        }
    }

    protected class ClassComboBoxItem {
        private final DebugClassInfo clazz;
        private final int row;
        private final String toString;

        protected ClassComboBoxItem(DebugClassInfo debugClassInfo, int n) {
            this.clazz = debugClassInfo;
            this.row = n;
            this.toString = debugClassInfo.getName();
        }

        Icon getIcon() {
            if (this.clazz.isInterface()) {
                return ClassesWindow.getInterfaceIcon();
            }
            return ClassesWindow.getClassIcon();
        }

        protected boolean isSpecial() {
            return false;
        }

        public String toString() {
            return this.toString;
        }

        static DebugClassInfo ra$clazz(ClassComboBoxItem classComboBoxItem) {
            return classComboBoxItem.clazz;
        }

        static int ra$row(ClassComboBoxItem classComboBoxItem) {
            return classComboBoxItem.row;
        }
    }

    private class ClassComboBoxRenderer
    extends JTree
    implements ListCellRenderer {
        private final JComboBox comboBox;
        private final int preferredHeight;
        private final ClassTreeCellRenderer classTreeCellRenderer;
        private ClassComboBoxItem classComboBoxItem;
        private int row;
        private boolean overrideBackground;

        private ClassComboBoxRenderer(TreeModel treeModel, JComboBox jComboBox) {
            super(treeModel);
            this.comboBox = jComboBox;
            this.preferredHeight = jComboBox.getPreferredSize().height;
            this.setRowHeight(this.preferredHeight);
            this.setOpaque(false);
            this.setFocusable(false);
            this.setRootVisible(false);
            this.setShowsRootHandles(false);
            int n = 0;
            while (n < this.getRowCount()) {
                this.expandRow(n);
                ++n;
            }
            TreeUI treeUI = this.getUI();
            if (treeUI instanceof BasicTreeUI) {
                BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
                basicTreeUI.setCollapsedIcon(null);
                basicTreeUI.setExpandedIcon(null);
            }
            this.classTreeCellRenderer = new ClassTreeCellRenderer(null);
            this.setCellRenderer(this.classTreeCellRenderer);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.classComboBoxItem = (ClassComboBoxItem)object;
            this.row = ClassComboBoxItem.ra$row(this.classComboBoxItem);
            if (n == -1) {
                this.overrideBackground = true;
                ClassTreeCellRenderer.wa$overrideBackground(this.classTreeCellRenderer, true);
            } else {
                this.overrideBackground = false;
                ClassTreeCellRenderer.wa$overrideBackground(this.classTreeCellRenderer, false);
            }
            if (bl) {
                this.setSelectionRow(this.row);
            } else {
                this.clearSelection();
            }
            return this;
        }

        public Color getBackground() {
            if (this.overrideBackground) {
                return null;
            }
            return super.getBackground();
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.row * this.getRowHeight());
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = this.preferredHeight;
            return dimension;
        }

        ClassComboBoxRenderer(TreeModel treeModel, JComboBox jComboBox, 1 var4_4) {
            this(treeModel, jComboBox);
        }

        class ClassTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private boolean overrideBackground;

            private ClassTreeCellRenderer() {
                this.setOpaque(false);
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object2;
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Font font = jTree.getFont();
                Icon icon = null;
                if (object instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) instanceof ClassComboBoxItem) {
                    ClassComboBoxItem classComboBoxItem = (ClassComboBoxItem)object2;
                    if (classComboBoxItem.isSpecial() && font != null) {
                        font = font.deriveFont(1);
                    }
                    icon = classComboBoxItem.getIcon();
                }
                this.setFont(font);
                this.setIcon(icon);
                return this;
            }

            public Color getBackground() {
                if (this.overrideBackground) {
                    return null;
                }
                return super.getBackground();
            }

            public Color getBackgroundNonSelectionColor() {
                if (this.overrideBackground) {
                    return null;
                }
                return super.getBackgroundNonSelectionColor();
            }

            static void wa$overrideBackground(ClassTreeCellRenderer classTreeCellRenderer, boolean bl) {
                classTreeCellRenderer.overrideBackground = bl;
            }

            ClassTreeCellRenderer(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }
}

