/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ProfilingEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassesWindow
extends DockableWindow
implements ColumnMenuListener,
ContextMenuListener,
Controller,
DragSourceListener,
DragGestureListener,
TreeExpansionListener {
    private ClassTreeTableModel model;
    private JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private String title;
    private boolean skippedUpdate;
    private DebuggingProcess debuggingProcess;
    private DebugVirtualMachine vm;
    private DebugClassLoaderInfo[] allClassLoaders;
    private PackageInfo[] allPackages;
    private DebugClassInfo[] allClasses;
    private boolean canCountObjects;
    private boolean canCountMemory;
    private List tracingIncludeList;
    private List tracingExcludeList;
    private ClassesWindowSettings classesSettings;
    private int preferredVisibleRowCount;
    private static IdeAction actionGoTo;
    private static IdeAction actionShowInHeap;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionFind;
    private static IdeAction actionFindNext;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemShowInHeap;
    private static JMenuItem menuitemWatchClassLoader;
    private static JMenuItem menuitemInspectClassLoader;
    private static JMenuItem menuitemFind;
    private static JMenuItem menuitemFindNext;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int GOTO_CMD_ID;
    private static final int SHOW_IN_HEAP_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int FIND_CMD_ID;
    private static final int FIND_NEXT_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_COUNT = 1;
    static final int COLUMN_MEMORY = 2;
    static final int COLUMN_FILENAME = 3;
    static final int NUMBER_OF_COLUMNS = 4;
    private TableColumn[] column;
    private int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static DataFlavor classFlavor;
    private static DataFlavor interfaceFlavor;
    private static DataFlavor arrayFlavor;
    static final String CLASSES_WINDOW_ID = "Debugger.ClassesWindow";
    private static Icon classesTabIcon;
    private static Icon packageIcon;
    private static Icon packageIconGray;
    private static Icon classIcon;
    private static Icon classIconGray;
    private static Icon classObfuscatedIcon;
    private static Icon interfaceIcon;
    private static Icon interfaceIconGray;
    private static Icon arrayIcon;
    private static Icon arrayIconGray;
    private static Icon classLoaderIcon;
    private static Icon arrowUpIcon;
    private static Icon arrowDownIcon;
    private static final String NOT_AVAILABLE = "";
    private boolean adjustColumnsAlreadyDone;

    void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 10;
        this.column = new TableColumn[4];
        this.columnDefaultWidth = new int[4];
        this.columnShowing = new boolean[4];
        this.adjustColumnsAlreadyDone = false;
    }

    static {
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesGoTo");
        SHOW_IN_HEAP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesShowInHeap");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesInspectClassLoader");
        FIND_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesFind");
        FIND_NEXT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesFindNext");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesSettings");
        classFlavor = null;
        interfaceFlavor = null;
        arrayFlavor = null;
        classesTabIcon = null;
        packageIcon = null;
        packageIconGray = null;
        classIcon = null;
        classIconGray = null;
        classObfuscatedIcon = null;
        interfaceIcon = null;
        interfaceIconGray = null;
        arrayIcon = null;
        arrayIconGray = null;
        classLoaderIcon = null;
        arrowUpIcon = null;
        arrowDownIcon = null;
    }

    ClassesWindow() {
        super(CLASSES_WINDOW_ID);
        this.$init$();
        this.title = DbgArb.getString(594);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        ClassesWindow.makeActions();
        this.setControllerForActions();
    }

    void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        int[] nArray = this.classesSettings.getColumnWidth();
        int n = 0;
        while (n < 4) {
            if (nArray[n] != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[n].setPreferredWidth(nArray[n]);
            }
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = this.classesSettings.getColumnOrder();
        if (string != null) {
            int n2 = 0;
            while (n2 < 4) {
                String string2;
                int n3 = string.indexOf(44);
                if (n3 != -1) {
                    string2 = string.substring(0, n3);
                    string = string.substring(n3 + 1);
                } else {
                    string2 = string;
                }
                if (string2.length() == 0) break;
                try {
                    int n4 = tableColumnModel.getColumnIndex(string2);
                    if (n4 != n2) {
                        this.treeTable.moveColumn(n4, n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    private boolean hasTreeStructure() {
        return this.classesSettings.isShowClassLoaders() || this.classesSettings.isShowPackages();
    }

    private void classesWindowSettingsChanged(boolean bl) {
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.getTree().setShowsRootHandles(this.hasTreeStructure());
        boolean[] blArray = this.classesSettings.getColumnVisible();
        int n = 0;
        while (n < 4) {
            if (this.columnShowing[n] != blArray[n]) {
                this.columnShowing[n] = blArray[n];
                if (blArray[n]) {
                    this.treeTable.addColumn(this.column[n]);
                } else {
                    this.treeTable.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new 14());
        }
        Dimension dimension = this.treeTable.getPreferredSize();
        dimension.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(dimension);
    }

    private void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int[] nArray = this.classesSettings.getColumnWidth();
        int n = 0;
        while (n < 4) {
            nArray[n] = this.column[n].getWidth();
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = NOT_AVAILABLE;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            string = string + tableColumn.getIdentifier() + ",";
        }
        this.classesSettings.setColumnOrder(string);
    }

    void tracingChanged() {
        if (this.debuggingProcess != null) {
            DebugConfiguration debugConfiguration = this.debuggingProcess.getDebugConfiguration();
            this.tracingIncludeList = debugConfiguration.getTracingIncludeList();
            this.tracingExcludeList = debugConfiguration.getTracingExcludeList();
            if (this.model != null) {
                ClassTreeTableModel.mav$resetIcons(this.model);
            }
        }
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        ClassesWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionShowInHeap), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionFind), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionFindNext), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            this.classesSettings = ClassesWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.tracingChanged();
            this.classesWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.classesSettings.addChangeListener(new 13());
        }
        return this.scrollPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_classwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject eventObject) {
        Object object;
        ClassTreeTableModel.ClassItem classItem = this.model != null ? this.model.getSelectedClassItem() : null;
        JDIInformationProvider jDIInformationProvider = null;
        if (classItem != null && (object = classItem.getInfo()) instanceof JDIInformationProvider) {
            jDIInformationProvider = (JDIInformationProvider)object;
        }
        return ContextBuilder.buildContext((Element)classItem, (View)this, eventObject, this.debuggingProcess, jDIInformationProvider);
    }

    public int getDefaultVisibility(Layout layout) {
        boolean bl = JDebugger.getInstance().canShowDebuggingWindows(layout);
        int n = bl ? 3 : 0;
        return n;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (classesTabIcon == null) {
            classesTabIcon = JavaIcons.getIcon(0);
        }
        return classesTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        ClassTreeTableModel.mav$branchExpanded(this.model, treeExpansionEvent.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        ClassTreeTableModel.mav$branchCollapsed(this.model, treeExpansionEvent.getPath());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point;
        ClassTreeTableModel.ClassItem classItem;
        if (dragGestureEvent.getDragAction() == 1 && (classItem = this.model.getClassItemAtPoint(point = dragGestureEvent.getDragOrigin())).canDrag()) {
            try {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 6);
                bufferedImage.setRGB(0, 0, -16777216);
                Point point2 = new Point(0, 0);
                dragGestureEvent.startDrag(null, bufferedImage, point2, classItem, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == GOTO_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.showSource();
            }
            return true;
        }
        if (n == SHOW_IN_HEAP_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.showInHeap();
            }
            return true;
        }
        if (n == WATCH_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.watchClassLoader();
            }
            return true;
        }
        if (n == INSPECT_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.inspectClassLoader();
            }
            return true;
        }
        if (n == FIND_CMD_ID) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Not Implemented Yet", "Find", 1);
            return true;
        }
        if (n == FIND_NEXT_CMD_ID) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Not Implemented Yet", "Find Next", 1);
            return true;
        }
        if (n == SETTINGS_CMD_ID) {
            String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(787)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
            return true;
        }
        if (n == EXPAND_ALL_CMD_ID) {
            ClassTreeTableModel.mav$expandAll(this.model);
            return true;
        }
        if (n == COLLAPSE_ALL_CMD_ID) {
            ClassTreeTableModel.mav$collapseAll(this.model);
            return true;
        }
        if (n == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (n == 18) {
            Object object;
            int n2;
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null && (n2 = this.treeTable.getSelectedColumn()) != -1 && (object = this.model.getValueAt(classItem, n2)) != null) {
                IdeUtil.copyToClipboard((String)object.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (ideAction.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.isVisible()) {
                ideAction.setEnabled(false);
                return true;
            }
            if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == SETTINGS_CMD_ID)) {
                ideAction.setEnabled(false);
                return true;
            }
        }
        if (n == GOTO_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                ideAction.setEnabled(classItem.canShowSource());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == SHOW_IN_HEAP_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                ideAction.setEnabled(classItem.canShowInHeap());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == WATCH_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                ideAction.setEnabled(classItem.canWatchInspectClassLoader());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == INSPECT_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                ideAction.setEnabled(classItem.canWatchInspectClassLoader());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == FIND_CMD_ID) {
            ideAction.setEnabled(false);
            return true;
        }
        if (n == FIND_NEXT_CMD_ID) {
            ideAction.setEnabled(false);
            return true;
        }
        if (n == SETTINGS_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == EXPAND_ALL_CMD_ID || n == COLLAPSE_ALL_CMD_ID) {
            ideAction.setEnabled(this.hasTreeStructure());
            return true;
        }
        if (n == SAVE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 18) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            int n2 = this.treeTable.getSelectedColumn();
            ideAction.setEnabled(classItem != null && n2 != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (this.treeTable != null && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                this.addPopupMenuItemsForClassItem(contextMenu, context);
            }
            this.addPopupMenuItemsForClasses(contextMenu, context);
            this.addPopupMenuItemsForTreeTable(contextMenu, context);
            this.addPopupMenuItemsForCommon(contextMenu, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private Comparator<DebugClassLoaderInfo> getComparatorForClassLoaders() {
        return new 12();
    }

    private Comparator<PackageInfo> getComparatorForPackages() {
        return new 11();
    }

    private Comparator<DebugClassInfo> getComparatorForClasses() {
        return new 10();
    }

    @Override
    public void showColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = true;
            if (this.classesSettings != null) {
                boolean[] blArray = this.classesSettings.getColumnVisible();
                blArray[n] = true;
            }
            this.treeTable.addColumn(this.column[n]);
        }
    }

    @Override
    public void hideColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = false;
            if (this.classesSettings != null) {
                boolean[] blArray = this.classesSettings.getColumnVisible();
                blArray[n] = false;
            }
            this.treeTable.removeColumn(this.column[n]);
        }
    }

    private void createGUI() {
        this.model = new ClassTreeTableModel(new ArrayList<ClassTreeTableModel.ClassItem>());
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set set = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, set);
        this.treeTable.setFocusTraversalKeys(1, set);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int n = 0;
        while (n < 4) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnDefaultWidth[n] = this.column[n].getPreferredWidth();
            this.columnShowing[n] = true;
            ++n;
        }
        boolean[] blArray = new boolean[4];
        Arrays.fill(blArray, true);
        blArray[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, blArray);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree jTree = this.treeTable.getTree();
        jTree.setRootVisible(false);
        TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        jTree.addTreeExpansionListener(this);
        jTree.setCellRenderer(new 9());
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new 8());
        JTableHeader jTableHeader = this.treeTable.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new 7(this, tableCellRenderer));
        this.treeTable.addMouseListener((MouseListener)new 6());
        this.treeTable.addKeyListener((KeyListener)new 5());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color color = this.treeTable.getBackground();
        this.scrollPane.setBackground(color);
        this.scrollPane.getViewport().setBackground(color);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 4());
        this.scrollPane.addComponentListener(new 3());
        this.treeTable.addHierarchyListener((HierarchyListener)new 2());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 1, this);
        jTableHeader.addMouseListener(new 1());
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(618), null, (Integer)DbgArb.getInteger(619), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionShowInHeap = IdeAction.get((int)SHOW_IN_HEAP_CMD_ID, null, (String)DbgArb.getString(624), null, (Integer)DbgArb.getInteger(625), null, (int)-1, null, (boolean)false);
            actionShowInHeap.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(626), null, (Integer)DbgArb.getInteger(627), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(628), null, (Integer)DbgArb.getInteger(629), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionFind = IdeAction.get((int)FIND_CMD_ID, null, (String)DbgArb.getString(620), null, (Integer)DbgArb.getInteger(621), null, (int)-1, null, (boolean)false);
            actionFind.setEnabled(false);
            actionFindNext = IdeAction.get((int)FIND_NEXT_CMD_ID, null, (String)DbgArb.getString(622), null, (Integer)DbgArb.getInteger(623), null, (int)-1, null, (boolean)false);
            actionFindNext.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(95), null, (Integer)RunMgrArb.getInteger(96), null, (int)-1, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionGoTo, actionShowInHeap, actionWatchClassLoader, actionInspectClassLoader, actionFind, actionFindNext, actionSettings, actionExpandAll, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this);
    }

    private void addPopupMenuItemsForClassItem(ContextMenu contextMenu, Context context) {
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = contextMenu.createMenuItem((ToggleAction)actionGoTo);
            }
            contextMenu.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(actionShowInHeap, context);
        if (actionShowInHeap.isEnabled()) {
            if (menuitemShowInHeap == null) {
                menuitemShowInHeap = contextMenu.createMenuItem((ToggleAction)actionShowInHeap);
            }
            contextMenu.add((Component)menuitemShowInHeap, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionWatchClassLoader, context);
        if (actionWatchClassLoader.isEnabled()) {
            if (menuitemWatchClassLoader == null) {
                menuitemWatchClassLoader = contextMenu.createMenuItem((ToggleAction)actionWatchClassLoader);
            }
            contextMenu.add((Component)menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionInspectClassLoader, context);
        if (actionInspectClassLoader.isEnabled()) {
            if (menuitemInspectClassLoader == null) {
                menuitemInspectClassLoader = contextMenu.createMenuItem((ToggleAction)actionInspectClassLoader);
            }
            contextMenu.add((Component)menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForClasses(ContextMenu contextMenu, Context context) {
        this.update(actionFind, context);
        if (actionFind.isEnabled()) {
            if (menuitemFind == null) {
                menuitemFind = contextMenu.createMenuItem((ToggleAction)actionFind);
            }
            contextMenu.add((Component)menuitemFind, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionFindNext, context);
        if (actionFindNext.isEnabled()) {
            if (menuitemFindNext == null) {
                menuitemFindNext = contextMenu.createMenuItem((ToggleAction)actionFindNext);
            }
            contextMenu.add((Component)menuitemFindNext, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForTreeTable(ContextMenu contextMenu, Context context) {
        this.update(actionExpandAll, context);
        if (actionExpandAll.isEnabled()) {
            if (menuitemExpandAll == null) {
                menuitemExpandAll = contextMenu.createMenuItem((ToggleAction)actionExpandAll);
            }
            contextMenu.add((Component)menuitemExpandAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
        this.update(actionCollapseAll, context);
        if (actionCollapseAll.isEnabled()) {
            if (menuitemCollapseAll == null) {
                menuitemCollapseAll = contextMenu.createMenuItem((ToggleAction)actionCollapseAll);
            }
            contextMenu.add((Component)menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = contextMenu.createMenuItem((ToggleAction)actionSave);
            }
            contextMenu.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = contextMenu.createMenuItem((ToggleAction)actionSettings);
            }
            contextMenu.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent mouseEvent) {
        JDebugger.getInstance().showContextMenu(mouseEvent, this, (JComponent)this.treeTable);
    }

    private void saveToFile() {
        URL uRL;
        String string = RunMgrArb.format(103, this.getTitleName());
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            uRLChooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            Exception exception = null;
            try {
                String string2 = URLFileSystem.getSuffix((URL)uRL).toUpperCase();
                boolean bl = string2.equals(".HTML") || string2.equals(".HTM");
                PrintWriter printWriter = bl ? JDebugger.printHtmlHeader(uRL, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)));
                ClassTreeTableModel.mav$save(this.model, printWriter, bl);
                if (bl) {
                    JDebugger.printHtmlFooter(printWriter);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            waitCursor.hide();
            if (exception != null) {
                String string3 = DbgArb.format(858, this.getTitleName(), URLFileSystem.getPlatformPathName((URL)uRL));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)string, (String)string3, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        if (this.model != null) {
            this.model.updateClasses();
        }
    }

    void updateClasses(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine) {
        int n = -1;
        if (ProfilingEvents.eventOn[5]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[5]);
        }
        this.debuggingProcess = debuggingProcess;
        DebugConfiguration debugConfiguration = debuggingProcess.getDebugConfiguration();
        this.tracingIncludeList = debugConfiguration.getTracingIncludeList();
        this.tracingExcludeList = debugConfiguration.getTracingExcludeList();
        this.vm = debugVirtualMachine;
        if (debugVirtualMachine != null) {
            DebugCapabilities debugCapabilities = debugVirtualMachine.getCapabilities();
            this.canCountObjects = debugCapabilities.canCountObjectsOfClass();
            this.canCountMemory = debugCapabilities.canCountMemoryOfClass();
        } else {
            this.canCountObjects = false;
            this.canCountMemory = false;
        }
        if (this.treeTable != null) {
            this.treeTable.setEnabled(true);
            this.everythingChanged();
        }
        if (ProfilingEvents.eventOn[5]) {
            IdeProfile.endEvent((int)n);
        }
    }

    static int getCount(DebugClassInfo debugClassInfo) {
        if (debugClassInfo.isInterface()) {
            return -1;
        }
        return debugClassInfo.countObjectsOfClass();
    }

    static int getMemory(DebugClassInfo debugClassInfo) {
        if (debugClassInfo.isInterface()) {
            return -1;
        }
        return debugClassInfo.countMemoryOfClass();
    }

    static String makeClassLoaderName(DebugClassLoaderInfo debugClassLoaderInfo) {
        String string = debugClassLoaderInfo.getClassName();
        string = string != null ? DbgArb.format(603, string, Integer.toString(debugClassLoaderInfo.getId())) : DbgArb.getString(604);
        return string;
    }

    void clearClasses() {
        if (this.treeTable == null) {
            return;
        }
        int n = -1;
        if (ProfilingEvents.eventOn[10]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[10]);
        }
        this.treeTable.setEnabled(false);
        this.model.clearClasses();
        this.vm = null;
        this.allClassLoaders = null;
        this.allPackages = null;
        this.allClasses = null;
        if (ProfilingEvents.eventOn[10]) {
            IdeProfile.endEvent((int)n);
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            this.allClassLoaders = null;
            this.allPackages = null;
            this.allClasses = null;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.everythingChanged();
            }
        }
    }

    private static Icon getClassLoaderIcon() {
        if (classLoaderIcon == null) {
            classLoaderIcon = DbgArb.getIcon(605);
        }
        return classLoaderIcon;
    }

    private static Icon getPackageIcon() {
        if (packageIcon == null) {
            packageIcon = JavaIcons.getIcon(5);
        }
        return packageIcon;
    }

    private static Icon getPackageIconGray() {
        if (packageIconGray == null) {
            packageIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getPackageIcon());
        }
        return packageIconGray;
    }

    static Icon getClassIcon() {
        if (classIcon == null) {
            classIcon = JavaIcons.getIcon(0);
        }
        return classIcon;
    }

    private static Icon getClassIconGray() {
        if (classIconGray == null) {
            classIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getClassIcon());
        }
        return classIconGray;
    }

    private static Icon getClassObfuscatedIcon() {
        if (classObfuscatedIcon == null) {
            classObfuscatedIcon = DbgArb.getIcon(606);
        }
        return classObfuscatedIcon;
    }

    static Icon getInterfaceIcon() {
        if (interfaceIcon == null) {
            interfaceIcon = JavaIcons.getIcon(1);
        }
        return interfaceIcon;
    }

    private static Icon getInterfaceIconGray() {
        if (interfaceIconGray == null) {
            interfaceIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getInterfaceIcon());
        }
        return interfaceIconGray;
    }

    private static Icon getArrayIcon() {
        if (arrayIcon == null) {
            arrayIcon = DbgArb.getIcon(607);
        }
        return arrayIcon;
    }

    private static Icon getArrayIconGray() {
        if (arrayIconGray == null) {
            arrayIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getArrayIcon());
        }
        return arrayIconGray;
    }

    private static Icon getArrowUpIcon() {
        if (arrowUpIcon == null) {
            arrowUpIcon = Helpers.getUpArrowIcon();
        }
        return arrowUpIcon;
    }

    private static Icon getArrowDownIcon() {
        if (arrowDownIcon == null) {
            arrowDownIcon = Helpers.getDownArrowIcon();
        }
        return arrowDownIcon;
    }

    static DataFlavor getClassFlavor() {
        if (classFlavor == null) {
            classFlavor = new DataFlavor(ClassFlavorData.class, "ClassFlavor");
        }
        return classFlavor;
    }

    static DataFlavor getInterfaceFlavor() {
        if (interfaceFlavor == null) {
            interfaceFlavor = new DataFlavor(InterfaceFlavorData.class, "InterfaceFlavor");
        }
        return interfaceFlavor;
    }

    static DataFlavor getArrayFlavor() {
        if (arrayFlavor == null) {
            arrayFlavor = new DataFlavor(ArrayFlavorData.class, "ArrayFlavor");
        }
        return arrayFlavor;
    }

    static void mav$classesWindowSettingsChanged(ClassesWindow classesWindow, boolean bl) {
        classesWindow.classesWindowSettingsChanged(bl);
    }

    static ClassesWindowSettings ra$classesSettings(ClassesWindow classesWindow) {
        return classesWindow.classesSettings;
    }

    static ClassTreeTableModel ra$model(ClassesWindow classesWindow) {
        return classesWindow.model;
    }

    static JFastTreeTable ra$treeTable(ClassesWindow classesWindow) {
        return classesWindow.treeTable;
    }

    static Icon maS$getArrowUpIcon() {
        return ClassesWindow.getArrowUpIcon();
    }

    static Icon maS$getArrowDownIcon() {
        return ClassesWindow.getArrowDownIcon();
    }

    static DebuggingProcess ra$debuggingProcess(ClassesWindow classesWindow) {
        return classesWindow.debuggingProcess;
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static void mav$adjustColumnsAfterResize(ClassesWindow classesWindow) {
        classesWindow.adjustColumnsAfterResize();
    }

    static boolean ra$canCountObjects(ClassesWindow classesWindow) {
        return classesWindow.canCountObjects;
    }

    static boolean ra$canCountMemory(ClassesWindow classesWindow) {
        return classesWindow.canCountMemory;
    }

    static Comparator mav$getComparatorForClassLoaders(ClassesWindow classesWindow) {
        return classesWindow.getComparatorForClassLoaders();
    }

    static Comparator mav$getComparatorForPackages(ClassesWindow classesWindow) {
        return classesWindow.getComparatorForPackages();
    }

    static Comparator mav$getComparatorForClasses(ClassesWindow classesWindow) {
        return classesWindow.getComparatorForClasses();
    }

    static DebugClassInfo[] ra$allClasses(ClassesWindow classesWindow) {
        return classesWindow.allClasses;
    }

    static PackageInfo[] ra$allPackages(ClassesWindow classesWindow) {
        return classesWindow.allPackages;
    }

    static DebugClassLoaderInfo[] ra$allClassLoaders(ClassesWindow classesWindow) {
        return classesWindow.allClassLoaders;
    }

    static DebugVirtualMachine ra$vm(ClassesWindow classesWindow) {
        return classesWindow.vm;
    }

    static void wa$allClassLoaders(ClassesWindow classesWindow, DebugClassLoaderInfo[] debugClassLoaderInfoArray) {
        classesWindow.allClassLoaders = debugClassLoaderInfoArray;
    }

    static void wa$allClasses(ClassesWindow classesWindow, DebugClassInfo[] debugClassInfoArray) {
        classesWindow.allClasses = debugClassInfoArray;
    }

    static void wa$allPackages(ClassesWindow classesWindow, PackageInfo[] packageInfoArray) {
        classesWindow.allPackages = packageInfoArray;
    }

    static void wa$skippedUpdate(ClassesWindow classesWindow, boolean bl) {
        classesWindow.skippedUpdate = bl;
    }

    static Icon maS$getClassLoaderIcon() {
        return ClassesWindow.getClassLoaderIcon();
    }

    static Icon maS$getPackageIcon() {
        return ClassesWindow.getPackageIcon();
    }

    static Icon maS$getPackageIconGray() {
        return ClassesWindow.getPackageIconGray();
    }

    static Icon maS$getClassIconGray() {
        return ClassesWindow.getClassIconGray();
    }

    static Icon maS$getClassObfuscatedIcon() {
        return ClassesWindow.getClassObfuscatedIcon();
    }

    static Icon maS$getInterfaceIconGray() {
        return ClassesWindow.getInterfaceIconGray();
    }

    static Icon maS$getArrayIcon() {
        return ClassesWindow.getArrayIcon();
    }

    static Icon maS$getArrayIconGray() {
        return ClassesWindow.getArrayIconGray();
    }

    static List ra$tracingIncludeList(ClassesWindow classesWindow) {
        return classesWindow.tracingIncludeList;
    }

    static List ra$tracingExcludeList(ClassesWindow classesWindow) {
        return classesWindow.tracingExcludeList;
    }

    final class 14
    implements Runnable {
        public void run() {
            ClassesWindow.this.everythingChanged();
        }
    }

    final class 13
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ClassesWindow.mav$classesWindowSettingsChanged(ClassesWindow.this, true);
        }
    }

    final class 12
    implements Comparator {
        public int compare(DebugClassLoaderInfo debugClassLoaderInfo, DebugClassLoaderInfo debugClassLoaderInfo2) {
            int n = ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn();
            boolean bl = ClassesWindow.ra$classesSettings(ClassesWindow.this).isSortAscending();
            if (ModelUtil.areEqual((Object)debugClassLoaderInfo.getClassName(), (Object)debugClassLoaderInfo2.getClassName())) {
                int n2 = debugClassLoaderInfo.getId();
                int n3 = debugClassLoaderInfo2.getId();
                if (n != 0 || bl) {
                    return n2 - n3;
                }
                return n3 - n2;
            }
            String string = ClassesWindow.makeClassLoaderName(debugClassLoaderInfo);
            String string2 = ClassesWindow.makeClassLoaderName(debugClassLoaderInfo2);
            if (n != 0 || bl) {
                return string.compareToIgnoreCase(string2);
            }
            return string2.compareToIgnoreCase(string);
        }
    }

    final class 11
    implements Comparator {
        public int compare(PackageInfo packageInfo, PackageInfo packageInfo2) {
            int n = ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn();
            boolean bl = ClassesWindow.ra$classesSettings(ClassesWindow.this).isSortAscending();
            String string = packageInfo.pkg;
            String string2 = packageInfo2.pkg;
            if (n != 0 || bl) {
                return string.compareToIgnoreCase(string2);
            }
            return string2.compareToIgnoreCase(string);
        }
    }

    final class 10
    implements Comparator {
        public int compare(DebugClassInfo debugClassInfo, DebugClassInfo debugClassInfo2) {
            int n = ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn();
            boolean bl = ClassesWindow.ra$classesSettings(ClassesWindow.this).isSortAscending();
            switch (n) {
                default: {
                    String string = DebugShared.makeCourtesyClassName(debugClassInfo, true);
                    String string2 = DebugShared.makeCourtesyClassName(debugClassInfo2, true);
                    if (bl) {
                        return string.compareToIgnoreCase(string2);
                    }
                    return string2.compareToIgnoreCase(string);
                }
                case 1: {
                    if (bl) {
                        return ClassesWindow.getCount(debugClassInfo) - ClassesWindow.getCount(debugClassInfo2);
                    }
                    return ClassesWindow.getCount(debugClassInfo2) - ClassesWindow.getCount(debugClassInfo);
                }
                case 2: {
                    if (bl) {
                        return ClassesWindow.getMemory(debugClassInfo) - ClassesWindow.getMemory(debugClassInfo2);
                    }
                    return ClassesWindow.getMemory(debugClassInfo2) - ClassesWindow.getMemory(debugClassInfo);
                }
                case 3: 
            }
            if (bl) {
                return debugClassInfo.getPrimarySourceFilename().compareToIgnoreCase(debugClassInfo2.getPrimarySourceFilename());
            }
            return debugClassInfo2.getPrimarySourceFilename().compareToIgnoreCase(debugClassInfo.getPrimarySourceFilename());
        }
    }

    final class 9
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ClassTreeTableModel.ClassItem) {
                String string;
                ClassTreeTableModel.ClassItem classItem = (ClassTreeTableModel.ClassItem)object;
                this.setIcon(classItem.getIcon());
                String string2 = classItem.getNameToolTip();
                if (string2 != null) {
                    this.setToolTipText(string2);
                }
                AccessibleContext accessibleContext = this.getAccessibleContext();
                String string3 = ClassTreeTableModel.mav$getAccessibleNameAt(ClassesWindow.ra$model(ClassesWindow.this), classItem, 0);
                if (classItem.mayHaveChildren()) {
                    string3 = JDebugger.fixTreeCellAccessibleName(string3, bl2);
                }
                if (string3 != null) {
                    accessibleContext.setAccessibleName(string3);
                }
                if ((string = string2) != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            } else {
                this.setIcon(null);
                this.setToolTipText(null);
            }
            return this;
        }
    }

    final class 8
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            int n4 = 2;
            if (n3 == 1 || n3 == 2) {
                n4 = 4;
            }
            this.setHorizontalAlignment(n4);
            String string2 = object instanceof String ? (String)object : null;
            this.setToolTipText(string2);
            ClassTreeTableModel.ClassItem classItem = ClassesWindow.ra$model(ClassesWindow.this).getClassItemForTreePath(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getPathForRow(n));
            AccessibleContext accessibleContext = this.getAccessibleContext();
            String string3 = ClassTreeTableModel.mav$getAccessibleNameAt(ClassesWindow.ra$model(ClassesWindow.this), classItem, n3);
            if (string3 != null) {
                accessibleContext.setAccessibleName(string3);
            }
            if ((string = string2) != null) {
                accessibleContext.setAccessibleDescription(string);
            }
            return this;
        }
    }

    final class 7
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ ClassesWindow this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                int n3 = jTable.convertColumnIndexToModel(n2);
                int n4 = 2;
                if (n3 == 1 || n3 == 2) {
                    n4 = 4;
                }
                defaultTableCellRenderer.setHorizontalAlignment(n4);
                Icon icon = null;
                if (n3 == ClassesWindow.ra$classesSettings(this.this$0).getSortColumn()) {
                    icon = ClassesWindow.ra$classesSettings(this.this$0).isSortAscending() ? ClassesWindow.maS$getArrowUpIcon() : ClassesWindow.maS$getArrowDownIcon();
                }
                defaultTableCellRenderer.setIcon(icon);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public 7(ClassesWindow classesWindow, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = classesWindow;
        }
    }

    final class 6
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ClassesWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ClassesWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) == null || !ClassesWindow.ra$debuggingProcess(ClassesWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, ClassesWindow.this.getTitleName()));
            }
            if (JDebugger.isDoubleClickInTreeTable(ClassesWindow.ra$treeTable(ClassesWindow.this), mouseEvent)) {
                Context context = ClassesWindow.this.getContext(mouseEvent);
                ClassesWindow.this.update(ClassesWindow.ra$actionGoTo(), context);
                if (ClassesWindow.ra$actionGoTo().isEnabled()) {
                    ClassesWindow.this.handleEvent(ClassesWindow.ra$actionGoTo(), context);
                }
            }
        }
    }

    final class 5
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    Context context = ClassesWindow.this.getContext(keyEvent);
                    ClassesWindow.this.update(ClassesWindow.ra$actionGoTo(), context);
                    if (!ClassesWindow.ra$actionGoTo().isEnabled()) break;
                    ClassesWindow.this.handleEvent(ClassesWindow.ra$actionGoTo(), context);
                    keyEvent.consume();
                }
            }
        }
    }

    final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ClassesWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ClassesWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) == null || !ClassesWindow.ra$debuggingProcess(ClassesWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, ClassesWindow.this.getTitleName()));
            }
        }
    }

    final class 3
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            ClassesWindow.mav$adjustColumnsAfterResize(ClassesWindow.this);
        }
    }

    final class 2
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & (long)4) != 0L && ClassesWindow.ra$treeTable(ClassesWindow.this).isShowing()) {
                ClassesWindow.this.nowShown();
            }
        }
    }

    final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) == null || !ClassesWindow.ra$debuggingProcess(ClassesWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, ClassesWindow.this.getTitleName()));
            }
            if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 1) {
                int n = ClassesWindow.ra$treeTable(ClassesWindow.this).getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                int n2 = ClassesWindow.ra$treeTable(ClassesWindow.this).convertColumnIndexToModel(n);
                if (n2 != -1) {
                    if (ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn() == n2) {
                        ClassesWindow.ra$classesSettings(ClassesWindow.this).toggleSortAscending();
                    } else {
                        ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortColumn(n2);
                        if (n2 == 0) {
                            ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortAscending(true);
                        } else {
                            ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortAscending(false);
                        }
                    }
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    waitCursor.show();
                    ClassesWindow.this.everythingChanged();
                    waitCursor.hide();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassTreeTableModel
    extends AbstractTreeTableModel {
        private List<ClassItem> root;
        private List<ClassInfoPath> expanded;
        private ClassInfoPath savedHighlight;

        ClassTreeTableModel(List<ClassItem> list) {
            super(list);
            this.root = list;
            this.expanded = new ArrayList<ClassInfoPath>();
        }

        void updateClasses() {
            this.saveHighlight();
            ClassesWindow.wa$allClassLoaders(ClassesWindow.this, null);
            ClassesWindow.wa$allPackages(ClassesWindow.this, null);
            ClassesWindow.wa$allClasses(ClassesWindow.this, null);
            this.root.clear();
            if (ClassesWindow.ra$treeTable(ClassesWindow.this) != null && ClassesWindow.ra$treeTable(ClassesWindow.this).isShowing()) {
                ClassesWindow.wa$skippedUpdate(ClassesWindow.this, false);
                if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) != null && ClassesWindow.ra$vm(ClassesWindow.this) != null) {
                    this.addClassItems();
                }
            } else {
                ClassesWindow.wa$skippedUpdate(ClassesWindow.this, true);
            }
            this.fireChanged();
            this.restoreHighlight(true);
        }

        private DebugClassLoaderInfo[] makeClassLoadersArray(DebugClassLoaderInfo[] debugClassLoaderInfoArray) {
            ArrayList<DebugClassLoaderInfo> arrayList = new ArrayList<DebugClassLoaderInfo>();
            int n = 0;
            while (n < debugClassLoaderInfoArray.length) {
                DebugClassLoaderInfo debugClassLoaderInfo = debugClassLoaderInfoArray[n];
                String string = debugClassLoaderInfo.getClassName();
                if (string == null || !string.equals("sun.reflect.DelegatingClassLoader")) {
                    arrayList.add(debugClassLoaderInfo);
                }
                ++n;
            }
            return arrayList.toArray(new DebugClassLoaderInfo[arrayList.size()]);
        }

        private DebugClassInfo[] makeClassesArray(DebugClassInfo[] debugClassInfoArray) {
            ArrayList<DebugClassInfo> arrayList = new ArrayList<DebugClassInfo>();
            int n = 0;
            while (n < debugClassInfoArray.length) {
                DebugClassLoaderInfo debugClassLoaderInfo;
                String string;
                DebugClassInfo debugClassInfo = debugClassInfoArray[n];
                if (!(debugClassInfo.isPrimitive() || (string = (debugClassLoaderInfo = debugClassInfo.getClassLoader()).getClassName()) != null && string.equals("sun.reflect.DelegatingClassLoader"))) {
                    arrayList.add(debugClassInfo);
                }
                ++n;
            }
            return arrayList.toArray(new DebugClassInfo[arrayList.size()]);
        }

        private PackageInfo[] makePackagesArray(DebugClassInfo[] debugClassInfoArray) {
            ArrayList<PackageInfo> arrayList = new ArrayList<PackageInfo>();
            if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages()) {
                boolean bl = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoaders();
                boolean bl2 = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree();
                int n = 0;
                while (n < debugClassInfoArray.length) {
                    DebugClassInfo debugClassInfo = debugClassInfoArray[n];
                    PackageInfo packageInfo = new PackageInfo(debugClassInfo);
                    if (!bl) {
                        packageInfo = new PackageInfo(packageInfo.pkg, null);
                    }
                    if (packageInfo.pkg.length() != 0 && !arrayList.contains(packageInfo)) {
                        arrayList.add(packageInfo);
                        if (bl2) {
                            int n2;
                            String string = packageInfo.pkg;
                            DebugClassLoaderInfo debugClassLoaderInfo = packageInfo.classLoader;
                            while ((n2 = string.lastIndexOf(46)) != -1 && !arrayList.contains(packageInfo = new PackageInfo(string = string.substring(0, n2), debugClassLoaderInfo))) {
                                arrayList.add(packageInfo);
                            }
                        }
                    }
                    ++n;
                }
            }
            return arrayList.toArray(new PackageInfo[arrayList.size()]);
        }

        void addClassItems() {
            ClassesWindow.wa$allClassLoaders(ClassesWindow.this, this.makeClassLoadersArray(ClassesWindow.ra$vm(ClassesWindow.this).listClassLoaders()));
            ClassesWindow.wa$allClasses(ClassesWindow.this, this.makeClassesArray(ClassesWindow.ra$vm(ClassesWindow.this).listClasses()));
            ClassesWindow.wa$allPackages(ClassesWindow.this, this.makePackagesArray(ClassesWindow.ra$allClasses(ClassesWindow.this)));
            this.fixSort();
            if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoaders()) {
                ArrayList<DebugClassLoaderInfo> arrayList = new ArrayList<DebugClassLoaderInfo>();
                this.addClassLoaders(null, arrayList);
                this.root.addAll(this.makeChildNodes(arrayList, null, null));
            } else if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages()) {
                ArrayList<PackageInfo> arrayList = new ArrayList<PackageInfo>();
                this.addPackages(null, null, arrayList);
                ArrayList<DebugClassInfo> arrayList2 = new ArrayList<DebugClassInfo>();
                this.addClasses(null, ClassesWindow.NOT_AVAILABLE, arrayList2);
                this.root.addAll(this.makeChildNodes(null, arrayList, arrayList2));
            } else {
                ArrayList<DebugClassInfo> arrayList = new ArrayList<DebugClassInfo>();
                this.addClasses(null, null, arrayList);
                this.root.addAll(this.makeChildNodes(null, null, arrayList));
            }
        }

        private void addClassLoaders(DebugClassLoaderInfo debugClassLoaderInfo, List<DebugClassLoaderInfo> list) {
            boolean bl = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoadersAsTree();
            if (!bl && debugClassLoaderInfo != null) {
                return;
            }
            int n = 0;
            while (n < ClassesWindow.ra$allClassLoaders(ClassesWindow.this).length) {
                DebugClassLoaderInfo debugClassLoaderInfo2 = ClassesWindow.ra$allClassLoaders(ClassesWindow.this)[n];
                boolean bl2 = false;
                if (!bl) {
                    bl2 = true;
                } else if (debugClassLoaderInfo == debugClassLoaderInfo2.getParent()) {
                    bl2 = true;
                }
                if (bl2) {
                    list.add(debugClassLoaderInfo2);
                }
                ++n;
            }
        }

        private void addPackages(DebugClassLoaderInfo debugClassLoaderInfo, String string, List<PackageInfo> list) {
            boolean bl = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree();
            if (!bl && string != null) {
                return;
            }
            String string2 = null;
            int n = 0;
            if (string != null) {
                string2 = string + ".";
                n = string2.length();
            }
            int n2 = 0;
            while (n2 < ClassesWindow.ra$allPackages(ClassesWindow.this).length) {
                PackageInfo packageInfo = ClassesWindow.ra$allPackages(ClassesWindow.this)[n2];
                if (debugClassLoaderInfo == null || debugClassLoaderInfo == packageInfo.classLoader) {
                    boolean bl2 = false;
                    if (!bl) {
                        bl2 = true;
                    } else if ((string2 == null || packageInfo.pkg.startsWith(string2)) && packageInfo.pkg.indexOf(46, n) == -1) {
                        bl2 = true;
                    }
                    if (bl2) {
                        list.add(packageInfo);
                    }
                }
                ++n2;
            }
        }

        private void addClasses(DebugClassLoaderInfo debugClassLoaderInfo, String string, List<DebugClassInfo> list) {
            int n = 0;
            while (n < ClassesWindow.ra$allClasses(ClassesWindow.this).length) {
                DebugClassInfo debugClassInfo = ClassesWindow.ra$allClasses(ClassesWindow.this)[n];
                if (!(debugClassLoaderInfo != null && debugClassLoaderInfo != debugClassInfo.getClassLoader() || string != null && !string.equals(DebugShared.makeCourtesyPackage(debugClassInfo)))) {
                    list.add(debugClassInfo);
                }
                ++n;
            }
        }

        private List<ClassItem> makeChildNodes(List<DebugClassLoaderInfo> list, List<PackageInfo> list2, List<DebugClassInfo> list3) {
            ArrayList<ClassItem> arrayList = new ArrayList<ClassItem>();
            if (list != null) {
                Collections.sort(list, ClassesWindow.mav$getComparatorForClassLoaders(ClassesWindow.this));
                for (DebugClassLoaderInfo debugClassLoaderInfo : list) {
                    arrayList.add(new ClassItem(debugClassLoaderInfo));
                }
            }
            if (list2 != null) {
                Collections.sort(list2, ClassesWindow.mav$getComparatorForPackages(ClassesWindow.this));
                for (PackageInfo packageInfo : list2) {
                    arrayList.add(new ClassItem(packageInfo));
                }
            }
            if (list3 != null) {
                Collections.sort(list3, ClassesWindow.mav$getComparatorForClasses(ClassesWindow.this));
                for (DebugClassInfo debugClassInfo : list3) {
                    arrayList.add(new ClassItem(debugClassInfo));
                }
            }
            return arrayList;
        }

        private void fixSort() {
            if (ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn() == 1 && !ClassesWindow.ra$canCountObjects(ClassesWindow.this) || ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn() == 2 && !ClassesWindow.ra$canCountMemory(ClassesWindow.this)) {
                ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortColumn(0);
                ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortAscending(true);
            }
        }

        void fireChanged() {
            TreePath treePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, treePath.getPath(), null, null);
            this.restoreExpanded(treePath);
        }

        void clearClasses() {
            this.saveHighlight();
            this.clearAll();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            ArrayList<ClassInfoPath> arrayList = new ArrayList<ClassInfoPath>();
            for (ClassInfoPath classInfoPath : this.expanded) {
                if (classInfoPath.getDebuggingProcess() != debuggingProcess) continue;
                arrayList.add(classInfoPath);
            }
            for (ClassInfoPath classInfoPath : arrayList) {
                this.expanded.remove(classInfoPath);
            }
            if (this.savedHighlight != null && this.savedHighlight.getDebuggingProcess() == debuggingProcess) {
                this.savedHighlight = null;
            }
        }

        private void clearAll() {
            this.clearAll(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof ClassItem) {
                ((ClassItem)object).clearClass();
            }
            int n = this.getChildCountLazy(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChildLazy(object, n2);
                if (object2 != null) {
                    this.clearAll(jTree, treePath.pathByAddingChild(object2));
                }
                ++n2;
            }
        }

        private void restoreExpanded(TreePath treePath) {
            JTree jTree = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree();
            if (jTree.isExpanded(treePath)) {
                Object object = treePath.getLastPathComponent();
                Iterator iterator = this.getChildren(object);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    TreePath treePath2 = treePath.pathByAddingChild(e);
                    ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(treePath2);
                    if (!this.expanded.contains(classInfoPath)) continue;
                    jTree.expandPath(treePath2);
                }
            }
        }

        private void branchExpanded(TreePath treePath) {
            ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(treePath);
            if (classInfoPath != null) {
                int n = this.expanded.indexOf(classInfoPath);
                if (n != -1) {
                    this.expanded.remove(n);
                }
                this.expanded.add(classInfoPath);
                this.restoreExpanded(treePath);
            }
        }

        private void branchCollapsed(TreePath treePath) {
            ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(treePath);
            if (classInfoPath != null) {
                this.expanded.remove(classInfoPath);
            }
        }

        private void saveHighlight() {
            ClassInfoPath classInfoPath = this.getCurrentHighlight();
            if (classInfoPath != null) {
                this.savedHighlight = classInfoPath;
            }
        }

        private void restoreHighlight(boolean bl) {
            if (this.savedHighlight != null) {
                this.savedHighlight = this.savedHighlight.updateClassInfoPath();
                TreePath treePath = this.makeVisible(this.savedHighlight);
                JDebugger.getInstance().selectTreeTablePath(ClassesWindow.ra$treeTable(ClassesWindow.this), treePath, bl);
            }
        }

        TreePath makeVisible(ClassInfoPath classInfoPath) {
            TreePath treePath = this.convertClassInfoPathToTreePath(classInfoPath);
            if (treePath != null) {
                ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().makeVisible(treePath);
            }
            return treePath;
        }

        ClassInfoPath getCurrentHighlight() {
            TreePath treePath = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToClassInfoPath(treePath);
            }
            return null;
        }

        ClassItem getClassItemAtPoint(Point point) {
            int n = ClassesWindow.ra$treeTable(ClassesWindow.this).rowAtPoint(point);
            TreePath treePath = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getPathForRow(n);
            return this.getClassItemForTreePath(treePath);
        }

        ClassItem getClassItemForTreePath(TreePath treePath) {
            Object object;
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof ClassItem) {
                return (ClassItem)object;
            }
            return null;
        }

        ClassInfoPath convertTreePathToClassInfoPath(TreePath treePath) {
            boolean bl = false;
            Object[] objectArray = treePath.getPath();
            int n = objectArray.length;
            Object[] objectArray2 = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ClassItem) {
                    objectArray2[n2] = ((ClassItem)object).getInfo();
                    if (objectArray2[n2] != null) {
                        bl = true;
                    }
                }
                ++n2;
            }
            if (bl) {
                return new ClassInfoPath(ClassesWindow.ra$debuggingProcess(ClassesWindow.this), objectArray2);
            }
            return null;
        }

        TreePath convertClassInfoPathToTreePath(ClassInfoPath classInfoPath) {
            int n = classInfoPath.size();
            if (n == 0) {
                return null;
            }
            List<ClassItem> list = this.root;
            TreePath treePath = new TreePath(list);
            int n2 = 1;
            while (n2 < n) {
                Object object = classInfoPath.getClassInfo(n2);
                Object var7_7 = null;
                Iterator iterator = this.getChildren(list);
                while (iterator.hasNext()) {
                    Object object2;
                    Object e = iterator.next();
                    if (!(e instanceof ClassItem) || !((object2 = ((ClassItem)e).getInfo()) == null ? object == null : object2.equals(object))) continue;
                    var7_7 = e;
                    break;
                }
                if (var7_7 == null) {
                    return null;
                }
                list = var7_7;
                treePath = treePath.pathByAddingChild(list);
                ++n2;
            }
            return treePath;
        }

        ClassItem getSelectedClassItem() {
            TreePath treePath = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getSelectionPath();
            return this.getClassItemForTreePath(treePath);
        }

        private void resetIcons() {
            this.resetIconsRecurse(new TreePath(this.root));
            ClassesWindow.ra$treeTable(ClassesWindow.this).repaint(ClassesWindow.ra$treeTable(ClassesWindow.this).getVisibleRect());
        }

        private void resetIcons(TreePath treePath) {
            this.resetIconsRecurse(treePath);
            ClassesWindow.ra$treeTable(ClassesWindow.this).repaint(ClassesWindow.ra$treeTable(ClassesWindow.this).getVisibleRect());
        }

        private void resetIconsRecurse(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof ClassItem) {
                ClassItem.mav$setIconAppropriately((ClassItem)object);
            }
            int n = this.getChildCountLazy(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChildLazy(object, n2);
                if (object2 != null) {
                    this.resetIconsRecurse(treePath.pathByAddingChild(object2));
                }
                ++n2;
            }
        }

        private void expandAll() {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.expandAll(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root));
            waitCursor.hide();
        }

        private void expandAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            jTree.expandPath(treePath);
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.expandAll(jTree, treePath.pathByAddingChild(object2));
                ++n2;
            }
        }

        private void collapseAll() {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.collapseAll(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root));
            waitCursor.hide();
            this.expanded.clear();
        }

        private void collapseAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            int n = this.getChildCountLazy(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChildLazy(object, n2);
                if (object2 != null) {
                    this.collapseAll(jTree, treePath.pathByAddingChild(object2));
                }
                ++n2;
            }
            if (!object.equals(this.root)) {
                jTree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter printWriter, boolean bl) {
            if (bl) {
                printWriter.println("<table border=\"1\">");
            }
            this.saveHeader(printWriter, bl);
            this.save(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root), printWriter, bl, ClassesWindow.NOT_AVAILABLE);
            if (bl) {
                printWriter.println("</table>");
            }
        }

        private void saveHeader(PrintWriter printWriter, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (bl) {
                stringBuffer.append("<tr>");
            }
            TableColumnModel tableColumnModel = ClassesWindow.ra$treeTable(ClassesWindow.this).getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                int n = tableColumn.getModelIndex();
                String string = this.getColumnName(n);
                if (bl) {
                    stringBuffer.append("<th>");
                    string = IdeUtil.replaceHTMLReservedCharacters((String)string.toString());
                    stringBuffer.append(string);
                    stringBuffer.append("</th>");
                    continue;
                }
                stringBuffer.append(string);
                int n2 = string.length();
                while (n2 >= 0) {
                    stringBuffer2.append('-');
                    --n2;
                }
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append('\t');
                stringBuffer2.append('\t');
            }
            if (bl) {
                stringBuffer.append("</tr>");
            }
            printWriter.println(stringBuffer.toString());
            if (!bl) {
                printWriter.println(stringBuffer2.toString());
            }
        }

        private void save(JTree jTree, TreePath treePath, PrintWriter printWriter, boolean bl, String string) {
            if (jTree.isVisible(treePath)) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof ClassItem) {
                    ClassItem classItem = (ClassItem)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (bl) {
                        stringBuffer.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = ClassesWindow.ra$treeTable(ClassesWindow.this).getColumnModel();
                    Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        TableColumn tableColumn = enumeration.nextElement();
                        int n = tableColumn.getModelIndex();
                        Object object2 = this.getValueAt(object, n);
                        if (bl) {
                            String string3;
                            String string4;
                            stringBuffer.append("<td>");
                            if (n == 0) {
                                stringBuffer.append("<tt>");
                                if (string != null) {
                                    stringBuffer.append(string);
                                }
                                if (jTree.isExpanded(treePath)) {
                                    stringBuffer.append("-&nbsp;");
                                } else if (classItem.mayHaveChildren()) {
                                    stringBuffer.append("+&nbsp;");
                                } else {
                                    stringBuffer.append("&nbsp;&nbsp;");
                                }
                                stringBuffer.append("</tt>");
                            }
                            if ((string4 = IdeUtil.replaceHTMLReservedCharacters((String)object2.toString())).length() > 0) {
                                stringBuffer.append(string4);
                            } else {
                                stringBuffer.append("&nbsp;");
                            }
                            if (n == 0 && (string3 = classItem.getIconLabel(" (", ")")) != null && string3.length() > 0) {
                                stringBuffer.append(string3);
                            }
                            stringBuffer.append("</td>");
                            continue;
                        }
                        if (n == 0) {
                            if (string != null) {
                                stringBuffer.append(string);
                            }
                            if (jTree.isExpanded(treePath)) {
                                stringBuffer.append("- ");
                            } else if (classItem.mayHaveChildren()) {
                                stringBuffer.append("+ ");
                            } else {
                                stringBuffer.append("  ");
                            }
                        }
                        stringBuffer.append(object2);
                        if (n == 0 && (string2 = classItem.getIconLabel(" (", ")")) != null && string2.length() > 0) {
                            stringBuffer.append(string2);
                        }
                        if (!enumeration.hasMoreElements()) continue;
                        stringBuffer.append('\t');
                    }
                    if (bl) {
                        stringBuffer.append("</tr>");
                    }
                    printWriter.println(stringBuffer.toString());
                }
                if (object != this.root) {
                    string = bl ? string + "&nbsp;&nbsp;&nbsp;&nbsp;" : string + "    ";
                }
                int n = this.getChildCountLazy(object);
                int n2 = 0;
                while (n2 < n) {
                    Object object3 = this.getChildLazy(object, n2);
                    if (object3 != null) {
                        this.save(jTree, treePath.pathByAddingChild(object3), printWriter, bl, string);
                    }
                    ++n2;
                }
            }
        }

        public boolean isLeaf(Object object) {
            try {
                if (object == this.root) {
                    boolean bl = false;
                    return bl;
                }
                ClassItem classItem = (ClassItem)object;
                boolean bl = classItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
        }

        Iterator getChildren(Object object) {
            if (object == this.root) {
                return this.root.iterator();
            }
            ClassItem classItem = (ClassItem)object;
            return classItem.getChildren();
        }

        private int getChildCountLazy(Object object) {
            if (object instanceof List) {
                return ((List)object).size();
            }
            ClassItem classItem = (ClassItem)object;
            if (ClassItem.ra$children(classItem) != null) {
                return ClassItem.ra$children(classItem).size();
            }
            return 0;
        }

        private Object getChildLazy(Object object, int n) {
            if (object instanceof List) {
                return ((List)object).get(n);
            }
            ClassItem classItem = (ClassItem)object;
            if (ClassItem.ra$children(classItem) != null) {
                return (ClassItem)ClassItem.ra$children(classItem).get(n);
            }
            return null;
        }

        public Object getChild(Object object, int n) {
            try {
                if (object instanceof List) {
                    Object e = ((List)object).get(n);
                    return e;
                }
                ClassItem classItem = (ClassItem)object;
                ClassItem classItem2 = classItem.getChildNodes().get(n);
                return classItem2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object object) {
            try {
                if (object instanceof List) {
                    int n = ((List)object).size();
                    return n;
                }
                ClassItem classItem = (ClassItem)object;
                int n = classItem.countChildNodes();
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return DbgArb.getString(599);
                }
                case 1: {
                    return DbgArb.getString(600);
                }
                case 2: {
                    return DbgArb.getString(601);
                }
                case 3: {
                    return DbgArb.getString(602);
                }
            }
            return ClassesWindow.NOT_AVAILABLE;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public Object getValueAt(Object object, int n) {
            try {
                if (object instanceof List) {
                    switch (n) {
                        case 0: {
                            String string = "root";
                            return string;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            String string = ClassesWindow.NOT_AVAILABLE;
                            return string;
                        }
                    }
                    Object var7_5 = null;
                    return var7_5;
                }
                ClassItem classItem = (ClassItem)object;
                switch (n) {
                    case 0: {
                        String string = classItem.getName();
                        return string;
                    }
                    case 1: {
                        String string = classItem.getCount();
                        return string;
                    }
                    case 2: {
                        String string = classItem.getMemory();
                        return string;
                    }
                    case 3: {
                        String string = classItem.getFilename();
                        return string;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(ClassItem classItem, int n) {
            int n2;
            if (classItem.isPackage()) {
                n2 = 595;
            } else if (classItem.isClass()) {
                n2 = 596;
            } else if (classItem.isInterface()) {
                n2 = 597;
            } else if (classItem.isArrayClass()) {
                n2 = 598;
            } else {
                return null;
            }
            String string = this.getColumnName(n);
            String string2 = (String)this.getValueAt(classItem, n);
            if (string2.length() == 0) {
                string2 = DbgArb.getString(884);
            }
            return DbgArb.format(n2, string, string2);
        }

        static void mav$save(ClassTreeTableModel classTreeTableModel, PrintWriter printWriter, boolean bl) {
            classTreeTableModel.save(printWriter, bl);
        }

        static void mav$expandAll(ClassTreeTableModel classTreeTableModel) {
            classTreeTableModel.expandAll();
        }

        static void mav$collapseAll(ClassTreeTableModel classTreeTableModel) {
            classTreeTableModel.collapseAll();
        }

        static void mav$branchCollapsed(ClassTreeTableModel classTreeTableModel, TreePath treePath) {
            classTreeTableModel.branchCollapsed(treePath);
        }

        static void mav$branchExpanded(ClassTreeTableModel classTreeTableModel, TreePath treePath) {
            classTreeTableModel.branchExpanded(treePath);
        }

        static void mav$resetIcons(ClassTreeTableModel classTreeTableModel) {
            classTreeTableModel.resetIcons();
        }

        static String mav$getAccessibleNameAt(ClassTreeTableModel classTreeTableModel, ClassItem classItem, int n) {
            return classTreeTableModel.getAccessibleNameAt(classItem, n);
        }

        static void mav$addClassLoaders(ClassTreeTableModel classTreeTableModel, DebugClassLoaderInfo debugClassLoaderInfo, List list) {
            classTreeTableModel.addClassLoaders(debugClassLoaderInfo, list);
        }

        static void mav$addPackages(ClassTreeTableModel classTreeTableModel, DebugClassLoaderInfo debugClassLoaderInfo, String string, List list) {
            classTreeTableModel.addPackages(debugClassLoaderInfo, string, list);
        }

        static void mav$addClasses(ClassTreeTableModel classTreeTableModel, DebugClassLoaderInfo debugClassLoaderInfo, String string, List list) {
            classTreeTableModel.addClasses(debugClassLoaderInfo, string, list);
        }

        static List mav$makeChildNodes(ClassTreeTableModel classTreeTableModel, List list, List list2, List list3) {
            return classTreeTableModel.makeChildNodes(list, list2, list3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ClassItem
        extends BaseElement
        implements Transferable {
            private Object info;
            private DebugClassLoaderInfo classLoader;
            private DataFlavor dragFlavor;
            private List<ClassItem> children;
            private Boolean cachedMayHaveChildren;
            private String cachedName;
            private String cachedCount;
            private String cachedMemory;
            private String cachedFilename;

            ClassItem(DebugClassLoaderInfo debugClassLoaderInfo) {
                this.classLoader = debugClassLoaderInfo;
                this.init(debugClassLoaderInfo);
            }

            ClassItem(PackageInfo packageInfo) {
                this.classLoader = packageInfo.classLoader;
                this.init(packageInfo);
            }

            ClassItem(DebugClassInfo debugClassInfo) {
                this.classLoader = debugClassInfo.getClassLoader();
                this.init(debugClassInfo);
            }

            private void init(Object object) {
                this.info = object;
                this.setDragFlavorAppropriately();
                this.setIconAppropriately();
            }

            private void setDragFlavorAppropriately() {
                if (this.info instanceof DebugClassInfo) {
                    DebugClassInfo debugClassInfo = (DebugClassInfo)this.info;
                    if (debugClassInfo.isObject()) {
                        this.dragFlavor = ClassesWindow.getClassFlavor();
                    } else if (debugClassInfo.isInterface()) {
                        this.dragFlavor = ClassesWindow.getInterfaceFlavor();
                    } else if (debugClassInfo.isArray()) {
                        this.dragFlavor = ClassesWindow.getArrayFlavor();
                    }
                }
            }

            private void setIconAppropriately() {
                if (this.info instanceof DebugClassLoaderInfo) {
                    this.setIcon(ClassesWindow.maS$getClassLoaderIcon());
                } else {
                    Icon icon = null;
                    Icon icon2 = null;
                    if (this.info instanceof PackageInfo) {
                        icon = ClassesWindow.maS$getPackageIcon();
                        icon2 = ClassesWindow.maS$getPackageIconGray();
                    } else if (this.info instanceof DebugClassInfo) {
                        DebugClassInfo debugClassInfo = (DebugClassInfo)this.info;
                        if (debugClassInfo.isArray()) {
                            icon = ClassesWindow.maS$getArrayIcon();
                            icon2 = ClassesWindow.maS$getArrayIconGray();
                        } else if (debugClassInfo.isInterface()) {
                            icon = ClassesWindow.getInterfaceIcon();
                            icon2 = ClassesWindow.maS$getInterfaceIconGray();
                        } else {
                            if (debugClassInfo.isDebuggable()) {
                                if (debugClassInfo.isObfuscated()) {
                                    this.setIcon(ClassesWindow.maS$getClassObfuscatedIcon());
                                } else {
                                    this.setIcon(ClassesWindow.getClassIcon());
                                }
                            } else {
                                this.setIcon(ClassesWindow.maS$getClassIconGray());
                            }
                            return;
                        }
                    }
                    if (icon != null && icon2 != null) {
                        String string = this.getRealName();
                        if (DebugShared.isClassOrPackageDebuggable(string, ClassesWindow.ra$tracingIncludeList(ClassesWindow.this), ClassesWindow.ra$tracingExcludeList(ClassesWindow.this))) {
                            this.setIcon(icon);
                        } else {
                            this.setIcon(icon2);
                        }
                    }
                }
            }

            String getIconLabel(String string, String string2) {
                int n = -1;
                Icon icon = this.getIcon();
                if (icon == ClassesWindow.maS$getClassLoaderIcon()) {
                    n = 608;
                } else if (icon == ClassesWindow.maS$getPackageIcon()) {
                    n = 609;
                } else if (icon == ClassesWindow.maS$getPackageIconGray()) {
                    n = 610;
                } else if (icon == ClassesWindow.getClassIcon()) {
                    n = 611;
                } else if (icon == ClassesWindow.maS$getClassIconGray()) {
                    n = 612;
                } else if (icon == ClassesWindow.maS$getClassObfuscatedIcon()) {
                    n = 613;
                } else if (icon == ClassesWindow.getInterfaceIcon()) {
                    n = 614;
                } else if (icon == ClassesWindow.maS$getInterfaceIconGray()) {
                    n = 615;
                } else if (icon == ClassesWindow.maS$getArrayIcon()) {
                    n = 616;
                } else if (icon == ClassesWindow.maS$getArrayIconGray()) {
                    n = 617;
                }
                if (n != -1) {
                    return string + DbgArb.getString(n) + string2;
                }
                return null;
            }

            String getNameToolTip() {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.info instanceof DebugClassLoaderInfo) {
                    stringBuffer.append(ClassesWindow.makeClassLoaderName(this.classLoader));
                } else if (this.info instanceof PackageInfo) {
                    stringBuffer.append(((PackageInfo)this.info).pkg);
                } else if (this.info instanceof DebugClassInfo) {
                    stringBuffer.append(DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, true));
                } else {
                    return null;
                }
                String string = this.getIconLabel(" (", ")");
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }

            boolean isClassLoader() {
                return this.info instanceof DebugClassLoaderInfo;
            }

            boolean isPackage() {
                return this.info instanceof PackageInfo;
            }

            boolean isClass() {
                return this.info instanceof DebugClassInfo && ((DebugClassInfo)this.info).isObject();
            }

            boolean isInterface() {
                return this.info instanceof DebugClassInfo && ((DebugClassInfo)this.info).isInterface();
            }

            boolean isArrayClass() {
                return this.info instanceof DebugClassInfo && ((DebugClassInfo)this.info).isArray();
            }

            void clearClass() {
                this.info = null;
            }

            Object getInfo() {
                return this.info;
            }

            @Override
            public String getShortLabel() {
                return this.getName();
            }

            @Override
            public Object getData() {
                return this;
            }

            @Override
            public boolean mayHaveChildren() {
                if (this.cachedMayHaveChildren == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    this.cachedMayHaveChildren = this.info instanceof DebugClassLoaderInfo ? Boolean.TRUE : (this.info instanceof PackageInfo ? Boolean.TRUE : Boolean.FALSE);
                }
                if (this.cachedMayHaveChildren != null) {
                    return this.cachedMayHaveChildren;
                }
                return false;
            }

            @Override
            public Iterator getChildren() {
                return this.getChildNodes().iterator();
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] dataFlavorArray = this.dragFlavor != null ? new DataFlavor[]{this.dragFlavor, DataFlavor.stringFlavor} : new DataFlavor[]{DataFlavor.stringFlavor};
                return dataFlavorArray;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                if (this.dragFlavor != null && dataFlavor.equals(this.dragFlavor)) {
                    return true;
                }
                return dataFlavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.dragFlavor != null && dataFlavor.equals(this.dragFlavor)) {
                    ClassFlavorData classFlavorData = null;
                    if (this.dragFlavor == ClassesWindow.getClassFlavor()) {
                        classFlavorData = new ClassFlavorData(this.info, null);
                    } else if (this.dragFlavor == ClassesWindow.getInterfaceFlavor()) {
                        classFlavorData = new InterfaceFlavorData(this.info, null);
                    } else if (this.dragFlavor == ClassesWindow.getArrayFlavor()) {
                        classFlavorData = new ArrayFlavorData(this.info, null);
                    }
                    return classFlavorData;
                }
                if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                    return this.getShortLabel();
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }

            public String getName() {
                if (this.cachedName == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    if (this.info instanceof DebugClassLoaderInfo) {
                        this.cachedName = ClassesWindow.makeClassLoaderName(this.classLoader);
                    } else if (this.info instanceof PackageInfo) {
                        if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree()) {
                            String string = ((PackageInfo)this.info).pkg;
                            int n = string.lastIndexOf(46);
                            if (n != -1) {
                                string = string.substring(n + 1);
                            }
                            this.cachedName = string;
                        } else {
                            this.cachedName = ((PackageInfo)this.info).pkg;
                        }
                    } else if (this.info instanceof DebugClassInfo) {
                        this.cachedName = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages() ? DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, false) : DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, true);
                    }
                }
                if (this.cachedName != null) {
                    return this.cachedName;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getCount() {
                if (this.cachedCount == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    int n;
                    this.cachedCount = ClassesWindow.ra$canCountObjects(ClassesWindow.this) && this.info instanceof DebugClassInfo ? ((n = ClassesWindow.getCount((DebugClassInfo)this.info)) >= 0 ? Integer.toString(n) : ClassesWindow.NOT_AVAILABLE) : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedCount != null) {
                    return this.cachedCount;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getMemory() {
                if (this.cachedMemory == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    int n;
                    this.cachedMemory = ClassesWindow.ra$canCountMemory(ClassesWindow.this) && this.info instanceof DebugClassInfo ? ((n = ClassesWindow.getMemory((DebugClassInfo)this.info)) >= 0 ? Integer.toString(n) : ClassesWindow.NOT_AVAILABLE) : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedMemory != null) {
                    return this.cachedMemory;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getFilename() {
                if (this.cachedFilename == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    this.cachedFilename = this.info instanceof DebugClassInfo ? ((DebugClassInfo)this.info).getPrimarySourceFilename() : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedFilename != null) {
                    return this.cachedFilename;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            private List<ClassItem> makeChildren() {
                ArrayList arrayList;
                ArrayList arrayList2;
                ArrayList arrayList3;
                block3: {
                    block2: {
                        arrayList3 = new ArrayList();
                        arrayList2 = new ArrayList();
                        arrayList = new ArrayList();
                        if (!(this.info instanceof DebugClassLoaderInfo)) break block2;
                        ClassTreeTableModel.mav$addClassLoaders(ClassTreeTableModel.this, this.classLoader, arrayList3);
                        if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages()) {
                            ClassTreeTableModel.mav$addPackages(ClassTreeTableModel.this, this.classLoader, null, arrayList2);
                            ClassTreeTableModel.mav$addClasses(ClassTreeTableModel.this, this.classLoader, ClassesWindow.NOT_AVAILABLE, arrayList);
                        } else {
                            ClassTreeTableModel.mav$addClasses(ClassTreeTableModel.this, this.classLoader, null, arrayList);
                        }
                        break block3;
                    }
                    if (!(this.info instanceof PackageInfo)) break block3;
                    String string = ((PackageInfo)this.info).pkg;
                    ClassTreeTableModel.mav$addPackages(ClassTreeTableModel.this, this.classLoader, string, arrayList2);
                    ClassTreeTableModel.mav$addClasses(ClassTreeTableModel.this, this.classLoader, string, arrayList);
                }
                return ClassTreeTableModel.mav$makeChildNodes(ClassTreeTableModel.this, arrayList3, arrayList2, arrayList);
            }

            int countChildNodes() {
                if (this.children == null) {
                    this.children = this.makeChildren();
                }
                if (this.children != null) {
                    return this.children.size();
                }
                return 0;
            }

            List<ClassItem> getChildNodes() {
                if (this.children == null) {
                    this.children = this.makeChildren();
                }
                return this.children;
            }

            String getRealName() {
                if (this.info instanceof DebugClassLoaderInfo) {
                    return null;
                }
                if (this.info instanceof PackageInfo) {
                    return ((PackageInfo)this.info).pkg;
                }
                if (this.info instanceof DebugClassInfo) {
                    DebugClassInfo debugClassInfo = (DebugClassInfo)this.info;
                    return debugClassInfo.getName();
                }
                return null;
            }

            boolean canShowSource() {
                if (this.info instanceof DebugClassInfo) {
                    String string = ((DebugClassInfo)this.info).getPrimarySourceFilename();
                    return string != null && string.length() > 0;
                }
                return false;
            }

            void showSource() {
                if (this.info instanceof DebugClassInfo) {
                    DebugClassInfo debugClassInfo = (DebugClassInfo)this.info;
                    ClassesWindow.ra$debuggingProcess(ClassesWindow.this).showSourceFile(debugClassInfo);
                }
            }

            boolean canDrag() {
                return this.dragFlavor != null;
            }

            boolean canShowInHeap() {
                if (JDebugger.getInstance().canShowHeapWindow() && this.info instanceof DebugClassInfo) {
                    DebugClassInfo debugClassInfo = (DebugClassInfo)this.info;
                    return debugClassInfo.isObject() || debugClassInfo.isArray();
                }
                return false;
            }

            void showInHeap() {
                DebugClassInfo debugClassInfo;
                if (JDebugger.getInstance().canShowHeapWindow() && this.info instanceof DebugClassInfo && ((debugClassInfo = (DebugClassInfo)this.info).isObject() || debugClassInfo.isArray())) {
                    String string = debugClassInfo.getName();
                    JDebugger jDebugger = JDebugger.getInstance();
                    jDebugger.viewHeap();
                    HeapWindow heapWindow = jDebugger.getHeapWindow(true);
                    heapWindow.addHeapClass(string);
                }
            }

            boolean canWatchInspectClassLoader() {
                DebugDataObjectInfo debugDataObjectInfo;
                return !(this.info instanceof PackageInfo) && this.classLoader != null && (debugDataObjectInfo = this.classLoader.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull();
            }

            void watchClassLoader() {
                DebugDataObjectInfo debugDataObjectInfo;
                if (!(this.info instanceof PackageInfo) && this.classLoader != null && (debugDataObjectInfo = this.classLoader.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull()) {
                    String string = ClassesWindow.makeClassLoaderName(this.classLoader);
                    EvaluatorItem evaluatorItem = ClassesWindow.ra$debuggingProcess(ClassesWindow.this).makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                    JDebugger.getInstance().addWatch(evaluatorItem);
                }
            }

            void inspectClassLoader() {
                DebugDataObjectInfo debugDataObjectInfo;
                if (!(this.info instanceof PackageInfo) && this.classLoader != null && (debugDataObjectInfo = this.classLoader.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull()) {
                    String string = ClassesWindow.makeClassLoaderName(this.classLoader);
                    EvaluatorItem evaluatorItem = ClassesWindow.ra$debuggingProcess(ClassesWindow.this).makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                    JDebugger.getInstance().inspect(evaluatorItem);
                }
            }

            static List ra$children(ClassItem classItem) {
                return classItem.children;
            }

            static void mav$setIconAppropriately(ClassItem classItem) {
                classItem.setIconAppropriately();
            }
        }
    }

    private final class ClassInfoPath {
        private final DebuggingProcess debuggingProcess;
        private final Object[] classInfoArray;

        ClassInfoPath(DebuggingProcess debuggingProcess, Object[] objectArray) {
            this.debuggingProcess = debuggingProcess;
            this.classInfoArray = objectArray;
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int size() {
            return this.classInfoArray.length;
        }

        Object getClassInfo(int n) {
            return this.classInfoArray[n];
        }

        ClassInfoPath updateClassInfoPath() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = this.classInfoArray.length;
            if (n > 0) {
                boolean bl = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoaders();
                boolean bl2 = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoadersAsTree();
                boolean bl3 = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages();
                boolean bl4 = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree();
                Object object = this.classInfoArray[n - 1];
                while (object != null) {
                    if (object instanceof DebugClassLoaderInfo && bl || object instanceof PackageInfo && bl3 || object instanceof DebugClassInfo) {
                        arrayList.add(0, object);
                    }
                    Object object2 = null;
                    if (object instanceof DebugClassLoaderInfo) {
                        object2 = bl2 ? ((DebugClassLoaderInfo)object).getParent() : null;
                    } else if (object instanceof PackageInfo) {
                        if (bl4) {
                            PackageInfo packageInfo = ((PackageInfo)object).getParentPackageInfo();
                            if (packageInfo != null) {
                                object2 = packageInfo;
                            } else if (bl) {
                                object2 = ((PackageInfo)object).classLoader;
                            }
                        } else if (bl) {
                            object2 = ((PackageInfo)object).classLoader;
                        }
                    } else if (object instanceof DebugClassInfo) {
                        if (bl3) {
                            PackageInfo packageInfo = new PackageInfo((DebugClassInfo)object);
                            if (packageInfo.pkg.length() != 0) {
                                object2 = packageInfo;
                            } else if (bl) {
                                object2 = ((DebugClassInfo)object).getClassLoader();
                            }
                        } else if (bl) {
                            object2 = ((DebugClassInfo)object).getClassLoader();
                        }
                    }
                    object = object2;
                }
            }
            arrayList.add(0, null);
            Object[] objectArray = arrayList.toArray(new Object[arrayList.size()]);
            return new ClassInfoPath(this.debuggingProcess, objectArray);
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.classInfoArray.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ClassInfoPath) {
                ClassInfoPath classInfoPath = (ClassInfoPath)object;
                return this.debuggingProcess == classInfoPath.debuggingProcess && Arrays.equals(this.classInfoArray, classInfoPath.classInfoArray);
            }
            return false;
        }
    }

    static class ClassFlavorData {
        private String name;

        private ClassFlavorData(Object object) {
            this.name = object instanceof DebugClassInfo ? ((DebugClassInfo)object).getName() : object.toString();
        }

        String getName() {
            return this.name;
        }

        ClassFlavorData(Object object, 1 var2_2) {
            this(object);
        }

        public final class 1 {
        }
    }

    private static class InterfaceFlavorData
    extends ClassFlavorData {
        private InterfaceFlavorData(Object object) {
            super(object, null);
        }

        InterfaceFlavorData(Object object, 1 var2_2) {
            this(object);
        }

        public final class 1 {
        }
    }

    private static class ArrayFlavorData
    extends ClassFlavorData {
        private ArrayFlavorData(Object object) {
            super(object, null);
        }

        ArrayFlavorData(Object object, 1 var2_2) {
            this(object);
        }

        public final class 1 {
        }
    }

    static class PackageInfo {
        final String pkg;
        final DebugClassLoaderInfo classLoader;
        private int hashCode;

        PackageInfo(DebugClassInfo debugClassInfo) {
            this(DebugShared.makeCourtesyPackage(debugClassInfo), debugClassInfo.getClassLoader());
        }

        PackageInfo(String string, DebugClassLoaderInfo debugClassLoaderInfo) {
            this.pkg = string;
            this.classLoader = debugClassLoaderInfo;
        }

        PackageInfo getParentPackageInfo() {
            int n = this.pkg.lastIndexOf(46);
            if (n != -1) {
                String string = this.pkg.substring(0, n);
                return new PackageInfo(string, this.classLoader);
            }
            return null;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode += this.pkg.hashCode();
                if (this.classLoader != null) {
                    this.hashCode += this.classLoader.hashCode();
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof PackageInfo) {
                PackageInfo packageInfo = (PackageInfo)object;
                return this.pkg.equals(packageInfo.pkg) && this.classLoader == packageInfo.classLoader;
            }
            return false;
        }
    }
}

