/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Arrays;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.ClientSetting;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class ClassesWindowSettings
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "ClassesWindowOptions";
    private boolean _showClassLoaders;
    private boolean _showClassLoadersAsTree;
    private boolean _showPackages;
    private boolean _showPackagesAsTree;
    private int _sortColumn;
    private boolean _sortAscending;
    private final boolean[] _columnVisible;
    private final int[] _columnWidth;
    private String _columnOrder;
    private boolean _showPackageStructure;

    static ClassesWindowSettings getInstance() {
        return (ClassesWindowSettings)ClientSetting.findOrCreate((String)JDebugger.getExtensionID()).getData(KEY_SETTINGS);
    }

    void $init$() {
        this._columnVisible = new boolean[4];
        this._columnWidth = new int[4];
    }

    public ClassesWindowSettings() {
        this.$init$();
        this.defaultInit();
    }

    public ClassesWindowSettings(ClassesWindowSettings classesWindowSettings) {
        this.$init$();
        if (classesWindowSettings == null) {
            this.defaultInit();
        } else {
            classesWindowSettings.copyToImpl(this);
        }
    }

    private void defaultInit() {
        this._showClassLoaders = false;
        this._showClassLoadersAsTree = true;
        this._showPackages = true;
        this._showPackagesAsTree = true;
        this._sortColumn = 0;
        this._sortAscending = true;
        Arrays.fill(this._columnVisible, false);
        this._columnVisible[0] = true;
        Arrays.fill(this._columnWidth, 0);
        this._columnOrder = null;
    }

    public Object copyTo(Object object) {
        ClassesWindowSettings classesWindowSettings = object != null ? (ClassesWindowSettings)((Object)object) : new ClassesWindowSettings();
        this.copyToImpl(classesWindowSettings);
        return classesWindowSettings;
    }

    protected final void copyToImpl(ClassesWindowSettings classesWindowSettings) {
        classesWindowSettings._showClassLoaders = this._showClassLoaders;
        classesWindowSettings._showClassLoadersAsTree = this._showClassLoadersAsTree;
        classesWindowSettings._showPackages = this._showPackages;
        classesWindowSettings._showPackagesAsTree = this._showPackagesAsTree;
        classesWindowSettings._sortColumn = this._sortColumn;
        classesWindowSettings._sortAscending = this._sortAscending;
        System.arraycopy(this._columnVisible, 0, classesWindowSettings._columnVisible, 0, this._columnVisible.length);
        System.arraycopy(this._columnWidth, 0, classesWindowSettings._columnWidth, 0, this._columnWidth.length);
        classesWindowSettings._columnOrder = this._columnOrder;
        classesWindowSettings.fireChangeEvent();
    }

    public boolean isShowClassLoaders() {
        return this._showClassLoaders;
    }

    public void setShowClassLoaders(boolean bl) {
        this._showClassLoaders = bl;
    }

    public boolean isShowClassLoadersAsTree() {
        return this._showClassLoadersAsTree;
    }

    public void setShowClassLoadersAsTree(boolean bl) {
        this._showClassLoadersAsTree = bl;
    }

    public boolean isShowPackages() {
        return this._showPackages;
    }

    public void setShowPackages(boolean bl) {
        this._showPackages = bl;
    }

    public boolean isShowPackagesAsTree() {
        return this._showPackagesAsTree;
    }

    public void setShowPackagesAsTree(boolean bl) {
        this._showPackagesAsTree = bl;
    }

    public int getSortColumn() {
        return this._sortColumn;
    }

    public void setSortColumn(int n) {
        this._sortColumn = n;
    }

    public boolean isSortAscending() {
        return this._sortAscending;
    }

    public void setSortAscending(boolean bl) {
        this._sortAscending = bl;
    }

    public void toggleSortAscending() {
        this._sortAscending ^= true;
    }

    public boolean[] getColumnVisible() {
        return this._columnVisible;
    }

    public void setColumnVisible(boolean[] blArray) {
        System.arraycopy(blArray, 0, this._columnVisible, 0, blArray.length);
    }

    public int[] getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int[] nArray) {
        System.arraycopy(nArray, 0, this._columnWidth, 0, nArray.length);
    }

    public String getColumnOrder() {
        return this._columnOrder;
    }

    public void setColumnOrder(String string) {
        this._columnOrder = string;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ClassesWindowSettings)((Object)object));
    }

    protected final boolean equalsImpl(ClassesWindowSettings classesWindowSettings) {
        return this._showClassLoaders == classesWindowSettings._showClassLoaders && this._showClassLoadersAsTree == classesWindowSettings._showClassLoadersAsTree && this._showPackages == classesWindowSettings._showPackages && this._showPackagesAsTree == classesWindowSettings._showPackagesAsTree && this._sortColumn == classesWindowSettings._sortColumn && this._sortAscending == classesWindowSettings._sortAscending && Arrays.equals(this._columnVisible, classesWindowSettings._columnVisible) && Arrays.equals(this._columnWidth, classesWindowSettings._columnWidth) && ModelUtil.areEqual((Object)this._columnOrder, (Object)classesWindowSettings._columnOrder);
    }
}

