/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

public final class ClassesWindowSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private JCheckBox showColumnNameCheckBox;
    private JCheckBox showColumnCountCheckBox;
    private JCheckBox showColumnMemoryCheckBox;
    private JCheckBox showColumnFilenameCheckBox;
    private JCheckBox showClassLoadersCheckBox;
    private JRadioButton showClassLoadersTreeRadio;
    private JRadioButton showClassLoadersListRadio;
    private JCheckBox showPackagesCheckBox;
    private JRadioButton showPackagesTreeRadio;
    private JRadioButton showPackagesListRadio;
    private JLabel sortLabel;
    private JComboBox sortColumnComboBox;
    private JCheckBox sortAscendingCheckBox;

    public ClassesWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_classwinsetpanel_html");
        this.showColumnNameCheckBox = new JCheckBox();
        this.showColumnCountCheckBox = new JCheckBox();
        this.showColumnMemoryCheckBox = new JCheckBox();
        this.showColumnFilenameCheckBox = new JCheckBox();
        this.showClassLoadersCheckBox = new JCheckBox();
        this.showClassLoadersTreeRadio = new JRadioButton();
        this.showClassLoadersListRadio = new JRadioButton();
        this.showPackagesCheckBox = new JCheckBox();
        this.showPackagesTreeRadio = new JRadioButton();
        this.showPackagesListRadio = new JRadioButton();
        this.sortLabel = new JLabel();
        this.sortColumnComboBox = new JComboBox();
        this.sortAscendingCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.showColumnNameCheckBox, (String)DbgArb.getString(796));
        ResourceUtils.resButton((AbstractButton)this.showColumnCountCheckBox, (String)DbgArb.getString(797));
        ResourceUtils.resButton((AbstractButton)this.showColumnMemoryCheckBox, (String)DbgArb.getString(798));
        ResourceUtils.resButton((AbstractButton)this.showColumnFilenameCheckBox, (String)DbgArb.getString(799));
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersCheckBox, (String)DbgArb.getString(791));
        this.showClassLoadersCheckBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersTreeRadio, (String)DbgArb.getString(792));
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersListRadio, (String)DbgArb.getString(793));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.showClassLoadersTreeRadio);
        buttonGroup.add(this.showClassLoadersListRadio);
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(788));
        this.showPackagesCheckBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.showPackagesTreeRadio, (String)DbgArb.getString(789));
        ResourceUtils.resButton((AbstractButton)this.showPackagesListRadio, (String)DbgArb.getString(790));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.showPackagesTreeRadio);
        buttonGroup2.add(this.showPackagesListRadio);
        ResourceUtils.resLabel((JLabel)this.sortLabel, (Component)this.sortColumnComboBox, (String)DbgArb.getString(794));
        Object[] objectArray = new String[]{DbgArb.getString(599), DbgArb.getString(600), DbgArb.getString(601), DbgArb.getString(602)};
        this.sortColumnComboBox.setModel(new NonNullableComboBoxModel(objectArray));
        ResourceUtils.resButton((AbstractButton)this.sortAscendingCheckBox, (String)DbgArb.getString(795));
        this.setLayout(new GridBagLayout());
        int n = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        this.add(this.makeChooseColumnsPanel(insets), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.makeMiscPanel(insets), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0));
        this.add(this.makeSortPanel(insets), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
    }

    private JPanel makeChooseColumnsPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RunMgrArb.getString(94));
        jPanel.setBorder(titledBorder);
        if (insets != null) {
            Insets insets2 = titledBorder.getBorderInsets(jPanel);
            insets.top = insets2.top;
            insets.left = insets2.left;
            insets.bottom = insets2.bottom;
            insets.right = insets2.right;
        }
        jPanel.add(this.showColumnNameCheckBox);
        jPanel.add(this.showColumnCountCheckBox);
        jPanel.add(this.showColumnMemoryCheckBox);
        jPanel.add(this.showColumnFilenameCheckBox);
        return jPanel;
    }

    private JPanel makeMiscPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel2.add((Component)this.showClassLoadersCheckBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel2.add((Component)new JLabel(), new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel2.add((Component)this.showClassLoadersTreeRadio, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        jPanel2.add((Component)this.showClassLoadersListRadio, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        n = 0;
        jPanel3.add((Component)this.showPackagesCheckBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel3.add((Component)new JLabel(), new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel3.add((Component)this.showPackagesTreeRadio, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        jPanel3.add((Component)this.showPackagesListRadio, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel makeSortPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        jPanel.add((Component)this.sortLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.sortColumnComboBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.sortAscendingCheckBox, gridBagConstraints);
        return jPanel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.showClassLoadersCheckBox) {
            this.enableClassLoadersRadios();
        } else if (object == this.showPackagesCheckBox) {
            this.enablePackagesRadios();
        }
    }

    private void enableClassLoadersRadios() {
        boolean bl = this.showClassLoadersCheckBox.isSelected();
        this.showClassLoadersTreeRadio.setEnabled(bl);
        this.showClassLoadersListRadio.setEnabled(bl);
    }

    private void enablePackagesRadios() {
        boolean bl = this.showPackagesCheckBox.isSelected();
        this.showPackagesTreeRadio.setEnabled(bl);
        this.showPackagesListRadio.setEnabled(bl);
    }

    public void onEntry(TraversableContext traversableContext) {
        ClassesWindowSettings classesWindowSettings = (ClassesWindowSettings)((Object)traversableContext.find("ClassesWindowOptions"));
        boolean[] blArray = classesWindowSettings.getColumnVisible();
        this.showColumnNameCheckBox.setSelected(true);
        this.showColumnNameCheckBox.setEnabled(false);
        this.showColumnCountCheckBox.setSelected(blArray[1]);
        this.showColumnMemoryCheckBox.setSelected(blArray[2]);
        this.showColumnFilenameCheckBox.setSelected(blArray[3]);
        this.showClassLoadersCheckBox.setSelected(classesWindowSettings.isShowClassLoaders());
        if (classesWindowSettings.isShowClassLoadersAsTree()) {
            this.showClassLoadersTreeRadio.setSelected(true);
        } else {
            this.showClassLoadersListRadio.setSelected(true);
        }
        this.enableClassLoadersRadios();
        this.showPackagesCheckBox.setSelected(classesWindowSettings.isShowPackages());
        if (classesWindowSettings.isShowPackagesAsTree()) {
            this.showPackagesTreeRadio.setSelected(true);
        } else {
            this.showPackagesListRadio.setSelected(true);
        }
        this.enablePackagesRadios();
        this.sortColumnComboBox.setSelectedIndex(classesWindowSettings.getSortColumn());
        this.sortAscendingCheckBox.setSelected(classesWindowSettings.isSortAscending());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ClassesWindowSettings classesWindowSettings = (ClassesWindowSettings)((Object)traversableContext.find("ClassesWindowOptions"));
        boolean[] blArray = classesWindowSettings.getColumnVisible();
        blArray[0] = true;
        blArray[1] = this.showColumnCountCheckBox.isSelected();
        blArray[2] = this.showColumnMemoryCheckBox.isSelected();
        blArray[3] = this.showColumnFilenameCheckBox.isSelected();
        classesWindowSettings.setShowClassLoaders(this.showClassLoadersCheckBox.isSelected());
        classesWindowSettings.setShowClassLoadersAsTree(this.showClassLoadersTreeRadio.isSelected());
        classesWindowSettings.setShowPackages(this.showPackagesCheckBox.isSelected());
        classesWindowSettings.setShowPackagesAsTree(this.showPackagesTreeRadio.isSelected());
        int n = this.sortColumnComboBox.getSelectedIndex();
        if (n != -1) {
            classesWindowSettings.setSortColumn(n);
        }
        classesWindowSettings.setSortAscending(this.sortAscendingCheckBox.isSelected());
    }
}

