/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.EventObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

class ContextBuilder {
    static Context buildContext(Element element, View view, EventObject eventObject, DebuggingProcess debuggingProcess) {
        return ContextBuilder.buildContext(element, view, eventObject, debuggingProcess, null);
    }

    static Context buildContext(Element element, View view, EventObject eventObject, DebuggingProcess debuggingProcess, JDIInformationProvider jDIInformationProvider) {
        Workspace workspace = null;
        Project project = null;
        if (debuggingProcess != null) {
            workspace = debuggingProcess.getWorkspace();
            project = debuggingProcess.getProject();
        }
        Context context = ContextBuilder.buildContext(element, view, eventObject, workspace, project);
        if (jDIInformationProvider != null) {
            ContextBuilder.addJDIInformation(context, jDIInformationProvider);
        }
        return context;
    }

    static Context buildContext(Element element, View view, EventObject eventObject, Workspace workspace, Project project) {
        Context context = Context.newIdeContext((Element)element);
        if (view != null) {
            context.setView(view);
        }
        if (eventObject != null) {
            context.setEvent(eventObject);
        }
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            context.setWorkspace(workspace);
        }
        if (project != null && project != Ide.getDefaultProject()) {
            context.setProject(project);
        }
        return context;
    }

    static void addJDIInformation(Context context, JDIInformationProvider jDIInformationProvider) {
        Value value;
        Type type;
        StackFrame stackFrame;
        Method method;
        Location location;
        LocalVariable localVariable;
        Field field = jDIInformationProvider.getJDIField();
        if (field != null) {
            context.setProperty("com.sun.jdi.Field", (Object)field);
        }
        if ((localVariable = jDIInformationProvider.getJDILocalVariable()) != null) {
            context.setProperty("com.sun.jdi.LocalVariable", (Object)localVariable);
        }
        if ((location = jDIInformationProvider.getJDILocation()) != null) {
            context.setProperty("com.sun.jdi.Location", (Object)location);
        }
        if ((method = jDIInformationProvider.getJDIMethod()) != null) {
            context.setProperty("com.sun.jdi.Method", (Object)method);
        }
        if ((stackFrame = jDIInformationProvider.getJDIStackFrame()) != null) {
            context.setProperty("com.sun.jdi.StackFrame", (Object)stackFrame);
        }
        if ((type = jDIInformationProvider.getJDIType()) != null) {
            context.setProperty("com.sun.jdi.Type", (Object)type);
        }
        if ((value = jDIInformationProvider.getJDIValue()) != null) {
            context.setProperty("com.sun.jdi.Value", (Object)value);
        }
    }

    ContextBuilder() {
    }
}

