/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.inspector.swing.AbstractTableCellEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInPinTable;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInRegister;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInStack;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInStatic;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.AdjustRangeDialog;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MemoViewDialog;
import oracle.jdevimpl.runner.debug.ModifyValueDialog;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.ObjectPreferencesPanel;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

abstract class DataPanel
implements ColumnMenuListener,
Comparator,
ContextMenuListener,
Controller,
DropTargetListener,
DragSourceListener,
DragGestureListener,
TreeSelectionListener,
TreeExpansionListener {
    protected DockableWindow dockableWindow;
    protected DataTreeTableModel model;
    protected JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private DataTreeCellRenderer dataTreeCellRenderer;
    private DataTableCellRenderer dataTableCellRenderer;
    private boolean skippedUpdate;
    protected DebuggingProcess debuggingProcess;
    protected DebugVirtualMachine vm;
    protected DebugThreadInfo thread;
    protected DebugStackFrameInfo frame;
    private boolean useFilters;
    private ObjectPreferences objectPreferences;
    private static final String BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX = "DebugDataInstanceFilter";
    private Map breakpointInstanceFilterActions;
    private Map arrayRanges;
    protected boolean selectFirstRowIfNoPreviousSelection;
    private DataPanelSettings dataPanelSettings;
    protected int preferredVisibleRowCount;
    protected Font ancestorDepthZeroFont;
    protected Font heapAncestorOutsideHeapFont;
    protected IdeAction _actionViewWhole;
    protected IdeAction _actionAdjustRange;
    protected IdeAction _actionToggleValue;
    protected IdeAction _actionModifyValue;
    protected IdeAction _actionWatch;
    protected IdeAction _actionInspect;
    protected IdeAction _actionWatchClassLoader;
    protected IdeAction _actionInspectClassLoader;
    protected IdeAction _actionGoto;
    protected IdeAction _actionGotoDeclared;
    protected IdeAction _actionGotoField;
    protected IdeAction _actionUseFilters;
    protected IdeAction _actionObjectPreferences;
    protected IdeAction _actionCollapseAll;
    protected IdeAction _actionSave;
    protected JMenuItem _menuitemViewWhole;
    protected JMenuItem _menuitemAdjustRange;
    protected JMenuItem _menuitemToggleValue;
    protected JMenuItem _menuitemModifyValue;
    protected JMenuItem _menuitemWatch;
    protected JMenuItem _menuitemInspect;
    protected JMenuItem _menuitemWatchClassLoader;
    protected JMenuItem _menuitemInspectClassLoader;
    protected JMenuItem _menuitemGoto;
    protected JMenuItem _menuitemGotoDeclared;
    protected JMenuItem _menuitemGotoField;
    protected JMenuItem _menuitemUseFilters;
    protected JMenuItem _menuitemObjectPreferences;
    protected JMenuItem _menuitemCollapseAll;
    protected JMenuItem _menuitemSave;
    protected int _VIEW_WHOLE_CMD_ID;
    protected int _ADJUST_RANGE_CMD_ID;
    protected int _TOGGLE_VALUE_CMD_ID;
    protected int _MODIFY_VALUE_CMD_ID;
    protected int _WATCH_CMD_ID;
    protected int _INSPECT_CMD_ID;
    protected int _WATCH_CLASSLOADER_CMD_ID;
    protected int _INSPECT_CLASSLOADER_CMD_ID;
    protected int _GOTO_CMD_ID;
    protected int _GOTO_DECLARED_CMD_ID;
    protected int _GOTO_FIELD_CMD_ID;
    protected int _USE_FILTERS_CMD_ID;
    protected int _OBJECT_PREFERENCES_CMD_ID;
    protected int _COLLAPSE_ALL_CMD_ID;
    protected int _SAVE_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_VALUE = 1;
    static final int COLUMN_ACTUAL_TYPE = 2;
    static final int COLUMN_DECLARED_TYPE = 3;
    static final int COLUMN_HEX_VALUE = 4;
    static final int COLUMN_ADDRESS = 5;
    static final int COLUMN_ID = 6;
    static final int NUMBER_OF_COLUMNS = 7;
    protected TableColumn[] column;
    protected int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static DataFlavor expressionFlavor = null;
    private static DataFlavor heapObjectFlavor = null;
    private static DataFlavor[] transferFlavors;
    private static Icon primitiveIcon;
    private static Icon primitiveIconGray;
    private static Icon objectIcon;
    private static Icon objectIconGray;
    private static Icon arrayIcon;
    private static Icon arrayIconGray;
    private static Icon staticFolderIcon;
    private static Icon heapFolderIcon;
    private static Icon evaluationIcon;
    private static final String NOT_AVAILABLE = "";
    private static int defaultArrayRangeMax;
    private boolean adjustColumnsAlreadyDone;
    private Font normalFont;
    private Font boldFont;
    private Font boldItalicFont;

    void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 6;
        this.ancestorDepthZeroFont = null;
        this.heapAncestorOutsideHeapFont = null;
        this.column = new TableColumn[7];
        this.columnDefaultWidth = new int[7];
        this.columnShowing = new boolean[7];
        this.adjustColumnsAlreadyDone = false;
    }

    static {
        primitiveIcon = null;
        primitiveIconGray = null;
        objectIcon = null;
        objectIconGray = null;
        arrayIcon = null;
        arrayIconGray = null;
        staticFolderIcon = null;
        heapFolderIcon = null;
        evaluationIcon = null;
        defaultArrayRangeMax = 0;
    }

    DataPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        this.$init$();
        this.dockableWindow = dockableWindow;
        this.dataPanelSettings = dataPanelSettings;
        JDebugger jDebugger = JDebugger.getInstance();
        this.objectPreferences = jDebugger.getObjectPreferences();
        this.breakpointInstanceFilterActions = new HashMap(10);
        this.arrayRanges = new HashMap();
        jDebugger.getContextMenu().addContextMenuListener((ContextMenuListener)this);
        dataPanelSettings.addChangeListener(new 10());
    }

    public void showColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = true;
            if (this.dataPanelSettings != null) {
                boolean[] blArray = this.dataPanelSettings.getColumnVisible();
                blArray[n] = true;
            }
            this.treeTable.addColumn(this.column[n]);
        }
    }

    public void hideColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = false;
            if (this.dataPanelSettings != null) {
                boolean[] blArray = this.dataPanelSettings.getColumnVisible();
                blArray[n] = false;
            }
            this.treeTable.removeColumn(this.column[n]);
        }
    }

    private void createGUI() {
        this.model = new DataTreeTableModel(new ArrayList());
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.dockableWindow.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set set = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, set);
        this.treeTable.setFocusTraversalKeys(1, set);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int n = 0;
        while (n < 7) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnDefaultWidth[n] = this.column[n].getPreferredWidth();
            this.columnShowing[n] = true;
            ++n;
        }
        boolean[] blArray = new boolean[7];
        Arrays.fill(blArray, true);
        blArray[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, blArray);
        this.columnDefaultWidth[0] = this.columnDefaultWidth[0] * 2;
        this.column[0].setPreferredWidth(this.columnDefaultWidth[0]);
        this.columnDefaultWidth[1] = this.columnDefaultWidth[1] * 2;
        this.column[1].setPreferredWidth(this.columnDefaultWidth[1]);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree jTree = this.treeTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        jTree.addTreeExpansionListener(this);
        jTree.addTreeSelectionListener(this);
        this.dataTreeCellRenderer = new DataTreeCellRenderer();
        jTree.setCellRenderer(this.dataTreeCellRenderer);
        this.dataTableCellRenderer = new DataTableCellRenderer();
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)this.dataTableCellRenderer);
        this.column[1].setCellEditor((TableCellEditor)((Object)new ValueCellEditor()));
        JTableHeader jTableHeader = this.treeTable.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new 9(this, tableCellRenderer));
        this.treeTable.addMouseListener((MouseListener)new 8());
        jTableHeader.addMouseListener(new 7());
        this.treeTable.addKeyListener((KeyListener)new 6());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color color = this.treeTable.getBackground();
        this.scrollPane.setBackground(color);
        this.scrollPane.getViewport().setBackground(color);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 5());
        this.scrollPane.addComponentListener(new 4());
        this.treeTable.addHierarchyListener((HierarchyListener)new 3());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 1, this);
        new DropTarget((Component)this.treeTable, 1, this);
        new DropTarget(this.scrollPane.getViewport(), 1, this);
        new DropTarget(this.scrollPane, 1, this);
        this.adjustGUI();
    }

    protected void adjustGUI() {
    }

    private boolean handleDoubleClickOrEnter(EventObject eventObject, int n) {
        IdeAction ideAction = null;
        switch (n) {
            case 0: {
                ideAction = this._actionGotoField;
                break;
            }
            case 2: {
                ideAction = this._actionGoto;
                break;
            }
            case 3: {
                ideAction = this._actionGotoDeclared;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                ideAction = this._actionModifyValue;
            }
        }
        if (ideAction != null) {
            Context context = this.getContext(eventObject);
            this.update(ideAction, context);
            if (ideAction.isEnabled()) {
                this.handleEvent(ideAction, context);
                return true;
            }
        }
        return false;
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    protected Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.treeTable.getTree().getFont();
        }
        return this.normalFont;
    }

    protected Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = this.getNormalFont().deriveFont(1);
        }
        return this.boldFont;
    }

    protected Font getBoldItalicFont() {
        if (this.boldItalicFont == null) {
            this.boldItalicFont = this.getNormalFont().deriveFont(3);
        }
        return this.boldItalicFont;
    }

    Component getGUI() {
        if (this.scrollPane == null) {
            this.createGUI();
        }
        return this.scrollPane;
    }

    void loadSettings() {
        int[] nArray = this.dataPanelSettings.getColumnWidth();
        int n = 0;
        while (n < 7) {
            if (nArray[n] != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[n].setPreferredWidth(nArray[n]);
            }
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = this.dataPanelSettings.getColumnOrder();
        if (string != null) {
            int n2 = 0;
            while (n2 < 7) {
                String string2;
                int n3 = string.indexOf(44);
                if (n3 != -1) {
                    string2 = string.substring(0, n3);
                    string = string.substring(n3 + 1);
                } else {
                    string2 = string;
                }
                if (string2.length() == 0) break;
                try {
                    int n4 = tableColumnModel.getColumnIndex(string2);
                    if (n4 != n2) {
                        this.treeTable.moveColumn(n4, n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    void debugWindowSettingsChanged(DebugWindowSettings debugWindowSettings) {
        if (this.treeTable == null) {
            return;
        }
        this.useFilters = debugWindowSettings.isUseFilters();
    }

    void dataPanelSettingsChanged(boolean bl) {
        if (this.treeTable == null) {
            return;
        }
        boolean[] blArray = this.dataPanelSettings.getColumnVisible();
        int n = 0;
        while (n < 7) {
            if (this.columnShowing[n] != blArray[n]) {
                this.columnShowing[n] = blArray[n];
                if (blArray[n]) {
                    this.treeTable.addColumn(this.column[n]);
                } else {
                    this.treeTable.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new 2());
        }
        Dimension dimension = this.treeTable.getPreferredSize();
        dimension.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(dimension);
    }

    void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int[] nArray = this.dataPanelSettings.getColumnWidth();
        int n = 0;
        while (n < 7) {
            nArray[n] = this.column[n].getWidth();
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = NOT_AVAILABLE;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            string = string + tableColumn.getIdentifier() + ",";
        }
        this.dataPanelSettings.setColumnOrder(string);
    }

    Context getContext() {
        return this.getContext(null);
    }

    Context getContext(EventObject eventObject) {
        Object object;
        DebugDataInfo debugDataInfo;
        DataItem dataItem = this.getSelectedDataItem();
        JDIInformationProvider jDIInformationProvider = null;
        if (dataItem != null && (debugDataInfo = dataItem.getDataInfo()) instanceof JDIInformationProvider) {
            jDIInformationProvider = (JDIInformationProvider)((Object)debugDataInfo);
        }
        Context context = ContextBuilder.buildContext((Element)dataItem, (View)this.dockableWindow, eventObject, this.debuggingProcess, jDIInformationProvider);
        if (this.frame instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)((Object)this.frame));
        }
        if (dataItem != null && (object = dataItem.getInfo()) instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)object);
        }
        return context;
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        DataTreeTableModel.mav$branchExpanded(this.model, treeExpansionEvent.getPath());
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        DataTreeTableModel.mav$branchCollapsed(this.model, treeExpansionEvent.getPath());
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point;
        TreePath treePath;
        DataItem dataItem;
        if (dragGestureEvent.getDragAction() == 1 && (transferFlavors = (dataItem = this.model.getDataItemForTreePath(treePath = this.model.getTreePathAtPoint(point = dragGestureEvent.getDragOrigin()))).canDrag(treePath)) != null) {
            try {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 6);
                bufferedImage.setRGB(0, 0, -16777216);
                Point point2 = new Point(0, 0);
                dragGestureEvent.startDrag(null, bufferedImage, point2, dataItem, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.checkDrop(dropTargetDropEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    protected void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.rejectDrag();
    }

    protected void checkDrop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.rejectDrop();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this._VIEW_WHOLE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewWhole();
            }
            return true;
        }
        if (n == this._ADJUST_RANGE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.adjustRange(treePath);
            }
            return true;
        }
        if (n == this._TOGGLE_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.toggleValue();
            }
            return true;
        }
        if (n == this._MODIFY_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.modifyValue();
            }
            return true;
        }
        if (n == this._WATCH_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.watch(treePath);
            }
            return true;
        }
        if (n == this._INSPECT_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.inspect(treePath);
            }
            return true;
        }
        if (n == this._WATCH_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.watchClassLoader();
            }
            return true;
        }
        if (n == this._INSPECT_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.inspectClassLoader();
            }
            return true;
        }
        if (n == this._GOTO_CMD_ID || n == this._GOTO_DECLARED_CMD_ID || n == this._GOTO_FIELD_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.showSource(n);
            }
            return true;
        }
        if (n == this._USE_FILTERS_CMD_ID) {
            JDebugger.getInstance().setUseFilters(ideAction.getState());
            return true;
        }
        if (n == this._OBJECT_PREFERENCES_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && DataItem.ra$actualClassInfo(dataItem) != null) {
                ObjectPreferencesPanel.showObjectPreferencesDialog(DataItem.ra$actualClassInfo(dataItem), this.dataPanelSettings.isSortFieldsByName());
            }
            return true;
        }
        if (n == this._COLLAPSE_ALL_CMD_ID) {
            DataTreeTableModel.mav$collapseAll(this.model);
            return true;
        }
        if (n == this._SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (n == 18) {
            Object object;
            int n2;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (n2 = this.treeTable.getSelectedColumn()) != -1 && (object = dataItem.getValueOfColumn(n2)) != null) {
                IdeUtil.copyToClipboard((String)object.toString());
            }
            return true;
        }
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(ideAction);
        if (debugBreakpoint != null) {
            DebugDataInfo debugDataInfo;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (debugDataInfo = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
                DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo;
                Boolean bl = (Boolean)ideAction.getValue("UserData");
                if (bl.booleanValue()) {
                    debugBreakpoint.removeInstanceFilter(debugDataObjectInfo);
                } else {
                    debugBreakpoint.addInstanceFilter(debugDataObjectInfo);
                }
                JDebugger.getInstance().updateBreakpointsWindowInstanceFilters();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (ideAction.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                ideAction.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                ideAction.setEnabled(false);
                return true;
            }
        }
        if (n == this._VIEW_WHOLE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                ideAction.setEnabled(dataItem.canViewWhole());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._ADJUST_RANGE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                ideAction.setEnabled(dataItem.canAdjustRange());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._TOGGLE_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                ideAction.setEnabled(dataItem.canToggleValue());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._MODIFY_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                ideAction.setEnabled(dataItem.canModifyValue());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._WATCH_CMD_ID || n == this._INSPECT_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                ideAction.setEnabled(dataItem.canWatchAndInspect(treePath));
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._WATCH_CLASSLOADER_CMD_ID || n == this._INSPECT_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                ideAction.setEnabled(dataItem.canWatchInspectClassLoader());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._GOTO_CMD_ID || n == this._GOTO_DECLARED_CMD_ID || n == this._GOTO_FIELD_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String string = dataItem.canShowSource(n);
                if (string != null) {
                    ideAction.setEnabled(true);
                    ideAction.putValue("Name", (Object)string);
                } else {
                    ideAction.setEnabled(false);
                    ideAction.putValue("Name", (Object)NOT_AVAILABLE);
                }
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._USE_FILTERS_CMD_ID) {
            ideAction.setState(this.useFilters);
            ideAction.setEnabled(this.objectPreferences.isHiddenFieldsEmpty() ^ true);
            return true;
        }
        if (n == this._OBJECT_PREFERENCES_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && DataItem.ra$actualClassInfo(dataItem) != null) {
                ideAction.setEnabled(true);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._COLLAPSE_ALL_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == this._SAVE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 18) {
            DataItem dataItem = this.getSelectedDataItem();
            int n2 = this.treeTable.getSelectedColumn();
            ideAction.setEnabled(dataItem != null && n2 != -1);
            return true;
        }
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(ideAction);
        if (debugBreakpoint != null) {
            DebugDataInfo debugDataInfo;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (debugDataInfo = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
                ideAction.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (this.treeTable != null && context.getView() == this.dockableWindow && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            this.addPopupMenuItemsForNew(contextMenu, context);
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                this.addPopupMenuItemsForDataItem(contextMenu, context);
            }
            this.addPopupMenuItemsForData(contextMenu, context);
            this.addPopupMenuItemsForTreeTable(contextMenu, context);
            this.addPopupMenuItemsForCommon(contextMenu, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public int compare(Object object, Object object2) {
        DebugFieldInfo debugFieldInfo = (DebugFieldInfo)object;
        DebugFieldInfo debugFieldInfo2 = (DebugFieldInfo)object2;
        return debugFieldInfo.getName().compareToIgnoreCase(debugFieldInfo2.getName());
    }

    protected void addPopupMenuItemsForNew(ContextMenu contextMenu, Context context) {
    }

    protected void addPopupMenuItemsForDataItem(ContextMenu contextMenu, Context context) {
        this.update(this._actionViewWhole, context);
        if (this._actionViewWhole.isEnabled()) {
            if (this._menuitemViewWhole == null) {
                this._menuitemViewWhole = contextMenu.createMenuItem((ToggleAction)this._actionViewWhole);
            }
            contextMenu.add((Component)this._menuitemViewWhole, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionAdjustRange, context);
        if (this._actionAdjustRange.isEnabled()) {
            if (this._menuitemAdjustRange == null) {
                this._menuitemAdjustRange = contextMenu.createMenuItem((ToggleAction)this._actionAdjustRange);
            }
            contextMenu.add((Component)this._menuitemAdjustRange, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionToggleValue, context);
        if (this._actionToggleValue.isEnabled()) {
            if (this._menuitemToggleValue == null) {
                this._menuitemToggleValue = contextMenu.createMenuItem((ToggleAction)this._actionToggleValue);
            }
            contextMenu.add((Component)this._menuitemToggleValue, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionModifyValue, context);
        if (this._actionModifyValue.isEnabled()) {
            if (this._menuitemModifyValue == null) {
                this._menuitemModifyValue = contextMenu.createMenuItem((ToggleAction)this._actionModifyValue);
            }
            contextMenu.add((Component)this._menuitemModifyValue, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        if (this._actionWatch != null) {
            this.update(this._actionWatch, context);
            if (this._actionWatch.isEnabled()) {
                if (this._menuitemWatch == null) {
                    this._menuitemWatch = contextMenu.createMenuItem((ToggleAction)this._actionWatch);
                }
                contextMenu.add((Component)this._menuitemWatch, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        if (this._actionInspect != null) {
            this.update(this._actionInspect, context);
            if (this._actionInspect.isEnabled()) {
                if (this._menuitemInspect == null) {
                    this._menuitemInspect = contextMenu.createMenuItem((ToggleAction)this._actionInspect);
                }
                contextMenu.add((Component)this._menuitemInspect, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        this.update(this._actionWatchClassLoader, context);
        if (this._actionWatchClassLoader.isEnabled()) {
            if (this._menuitemWatchClassLoader == null) {
                this._menuitemWatchClassLoader = contextMenu.createMenuItem((ToggleAction)this._actionWatchClassLoader);
            }
            contextMenu.add((Component)this._menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionInspectClassLoader, context);
        if (this._actionInspectClassLoader.isEnabled()) {
            if (this._menuitemInspectClassLoader == null) {
                this._menuitemInspectClassLoader = contextMenu.createMenuItem((ToggleAction)this._actionInspectClassLoader);
            }
            contextMenu.add((Component)this._menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionGoto, context);
        if (this._actionGoto.isEnabled()) {
            if (this._menuitemGoto == null) {
                this._menuitemGoto = contextMenu.createMenuItem((ToggleAction)this._actionGoto);
            }
            contextMenu.add((Component)this._menuitemGoto, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(this._actionGotoDeclared, context);
        if (this._actionGotoDeclared.isEnabled()) {
            if (this._menuitemGotoDeclared == null) {
                this._menuitemGotoDeclared = contextMenu.createMenuItem((ToggleAction)this._actionGotoDeclared);
            }
            contextMenu.add((Component)this._menuitemGotoDeclared, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(this._actionGotoField, context);
        if (this._actionGotoField.isEnabled()) {
            if (this._menuitemGotoField == null) {
                this._menuitemGotoField = contextMenu.createMenuItem((ToggleAction)this._actionGotoField);
            }
            contextMenu.add((Component)this._menuitemGotoField, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.addBreakpointInstanceFilterActions(contextMenu, context);
    }

    private void addBreakpointInstanceFilterActions(ContextMenu contextMenu, Context context) {
        DebugDataInfo debugDataInfo;
        this.breakpointInstanceFilterActions.clear();
        DataItem dataItem = this.getSelectedDataItem();
        if (dataItem != null && (debugDataInfo = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
            DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo;
            HashSet hashSet = new HashSet();
            HashMap<Breakpoint, Boolean> hashMap = new HashMap<Breakpoint, Boolean>();
            List[] listArray = Breakpoint.getBreakpoints(context.getWorkspace(), context.getProject());
            int n = listArray.length;
            int n2 = 0;
            while (n2 < n) {
                for (Breakpoint breakpoint : listArray[n2]) {
                    DebugBreakpoint debugBreakpoint = breakpoint.getDebugBreakpoint(this.debuggingProcess);
                    if (debugBreakpoint == null || !debugBreakpoint.isInstanceFilterAppropriate(debugDataObjectInfo, hashSet)) continue;
                    Boolean bl = debugBreakpoint.isInstanceFilterSet(debugDataObjectInfo) ? Boolean.TRUE : Boolean.FALSE;
                    hashMap.put(breakpoint, bl);
                }
                ++n2;
            }
            if (!hashMap.isEmpty()) {
                JMenu jMenu = contextMenu.createSubMenu(DbgArb.getString(338), DbgArb.getInteger(339));
                int n3 = 0;
                for (Breakpoint breakpoint : hashMap.keySet()) {
                    Boolean bl = (Boolean)hashMap.get(breakpoint);
                    String string = DbgArb.format(340, breakpoint.getTypeString(), breakpoint.getDescription());
                    int n4 = Ide.findOrCreateCmdID((String)(BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX + n3++));
                    IdeAction ideAction = IdeAction.get((int)n4, null, (String)string, null, null, null, (int)-1, (Object)bl, (boolean)true);
                    ideAction.putValue("Name", (Object)string);
                    ideAction.putValue("UserData", (Object)bl);
                    ideAction.putValue("Check", (Object)Boolean.TRUE);
                    ideAction.setState(bl.booleanValue());
                    ideAction.addController((Controller)this);
                    this.breakpointInstanceFilterActions.put(ideAction, breakpoint.getDebugBreakpoint(this.debuggingProcess));
                    JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
                    jMenu.add(jMenuItem);
                }
                contextMenu.add((Component)jMenu, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
    }

    protected void addPopupMenuItemsForData(ContextMenu contextMenu, Context context) {
        this.update(this._actionUseFilters, context);
        if (this._actionUseFilters.isEnabled()) {
            if (this._menuitemUseFilters == null) {
                this._menuitemUseFilters = contextMenu.createMenuItem((ToggleAction)this._actionUseFilters);
            }
            contextMenu.add((Component)this._menuitemUseFilters, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(this._actionObjectPreferences, context);
        if (this._actionObjectPreferences.isEnabled()) {
            if (this._menuitemObjectPreferences == null) {
                this._menuitemObjectPreferences = contextMenu.createMenuItem((ToggleAction)this._actionObjectPreferences);
            }
            contextMenu.add((Component)this._menuitemObjectPreferences, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForTreeTable(ContextMenu contextMenu, Context context) {
        this.update(this._actionCollapseAll, context);
        if (this._actionCollapseAll.isEnabled()) {
            if (this._menuitemCollapseAll == null) {
                this._menuitemCollapseAll = contextMenu.createMenuItem((ToggleAction)this._actionCollapseAll);
            }
            contextMenu.add((Component)this._menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
        this.update(this._actionSave, context);
        if (this._actionSave.isEnabled()) {
            if (this._menuitemSave == null) {
                this._menuitemSave = contextMenu.createMenuItem((ToggleAction)this._actionSave);
            }
            contextMenu.add((Component)this._menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent mouseEvent) {
        JDebugger.getInstance().showContextMenu(mouseEvent, this.dockableWindow, (JComponent)this.treeTable);
    }

    private void saveToFile() {
        URL uRL;
        String string = RunMgrArb.format(103, this.dockableWindow.getTitleName());
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            uRLChooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            Exception exception = null;
            try {
                String string2 = URLFileSystem.getSuffix((URL)uRL).toUpperCase();
                boolean bl = string2.equals(".HTML") || string2.equals(".HTM");
                PrintWriter printWriter = bl ? JDebugger.printHtmlHeader(uRL, this.dockableWindow.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)));
                DataTreeTableModel.mav$save(this.model, printWriter, bl);
                if (bl) {
                    JDebugger.printHtmlFooter(printWriter);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            waitCursor.hide();
            if (exception != null) {
                String string3 = DbgArb.format(858, this.dockableWindow.getTitleName(), URLFileSystem.getPlatformPathName((URL)uRL));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)string, (String)string3, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        if (this.model != null) {
            this.model.updateDataForModel();
        }
    }

    private void updateColumn(int n) {
        DataTreeTableModel.mav$clearCacheForColumn(this.model, n);
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent tableModelEvent = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, n);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(tableModelEvent);
        }
        if (n == 0) {
            DataTreeTableModel.mav$saveHighlight(this.model);
            this.model.fireChanged();
            DataTreeTableModel.mav$restoreHighlight(this.model, false);
        }
    }

    void setUseFilters(boolean bl) {
        this.useFilters = bl;
        this.everythingChanged();
    }

    void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo debugStackFrameInfo) {
        int n = -1;
        if (ProfilingEvents.eventOn[4]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[4], (String)this.dockableWindow.getTitleName());
        }
        this.debuggingProcess = debuggingProcess;
        this.vm = debugVirtualMachine;
        this.thread = debugThreadInfo;
        this.frame = debugStackFrameInfo;
        this.debugContextChanged();
        if (this.treeTable != null) {
            this.treeTable.setEnabled(true);
            this.everythingChanged();
        }
        if (ProfilingEvents.eventOn[4]) {
            IdeProfile.endEvent((int)n);
        }
    }

    protected void debugContextChanged() {
    }

    void clearData() {
        if (this.treeTable == null) {
            return;
        }
        int n = -1;
        if (ProfilingEvents.eventOn[9]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[9], (String)this.dockableWindow.getTitleName());
        }
        this.treeTable.setEnabled(false);
        this.model.clearDataForModel();
        this.vm = null;
        this.thread = null;
        this.frame = null;
        this.debugContextChanged();
        if (ProfilingEvents.eventOn[9]) {
            IdeProfile.endEvent((int)n);
        }
    }

    protected abstract void addDataItems();

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            this.thread = null;
            this.frame = null;
            this.debugContextChanged();
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.everythingChanged();
            }
        }
    }

    private DataArrayRange getArrayRange(DebugDataArrayInfo debugDataArrayInfo) {
        DataArrayRange dataArrayRange = (DataArrayRange)this.arrayRanges.get(debugDataArrayInfo);
        if (dataArrayRange != null) {
            this.arrayRanges.remove(debugDataArrayInfo);
            this.arrayRanges.put(debugDataArrayInfo, dataArrayRange);
        } else {
            dataArrayRange = new DataArrayRange(this.debuggingProcess, debugDataArrayInfo);
        }
        return dataArrayRange;
    }

    private DataItem[] makeDataItemsForObject(DataItem dataItem, DebugDataObjectInfo debugDataObjectInfo) {
        ArrayList<DataItem> arrayList = new ArrayList<DataItem>();
        if (dataItem.ancestorHeapInfo != null) {
            DebugHeapInfo debugHeapInfo = dataItem.ancestorHeapInfo;
            DebugFieldInfo[] debugFieldInfoArray = debugDataObjectInfo.getFields(-1, false, true);
            if (this.dataPanelSettings.isSortFieldsByName()) {
                Arrays.sort(debugFieldInfoArray, this);
            }
            int n = debugFieldInfoArray.length;
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            int n2 = -1;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n3];
                DebugDataInfo debugDataInfo = debugFieldInfo.getDataInfo();
                if (debugDataInfo instanceof DebugDataCompositeInfo && 0 <= (n4 = (nArray[n3] = debugHeapInfo.getDepth((DebugDataCompositeInfo)debugDataInfo))) && (n2 == -1 || n4 < n2)) {
                    n2 = n4;
                }
                ++n3;
            }
            int n5 = 0;
            while (n5 < n) {
                int n6 = nArray[n5];
                if (!this.dataPanelSettings.isHideUnrelated() || n6 >= 0) {
                    arrayList.add(new DataItem(debugFieldInfoArray[n5], null, debugHeapInfo, n6, n6 == n2));
                }
                ++n5;
            }
        } else {
            List list;
            boolean bl;
            List list2;
            String string = this.objectPreferences.getExpandExpression(debugDataObjectInfo);
            if (string != null && (list2 = this.makeDataItemsForObjectExpandExpression(debugDataObjectInfo, string)) != null) {
                arrayList.addAll(list2);
            }
            if (!(bl = this.objectPreferences.getHideAllFields(debugDataObjectInfo)) && (list = this.makeDataItemsForObjectFields(debugDataObjectInfo)) != null) {
                arrayList.addAll(list);
            }
        }
        return arrayList.toArray(new DataItem[arrayList.size()]);
    }

    private List makeDataItemsForObjectExpandExpression(DebugDataObjectInfo debugDataObjectInfo, String string) {
        try {
            ArrayList<DataItem> arrayList = new ArrayList<DataItem>();
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(debugDataObjectInfo);
            String[] stringArray = ObjectPreferences.tokenizeExpandExpression(string);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                DebugDataInfo debugDataInfo = Evaluator.getDataInfo(evaluator.evaluate(string2));
                if (debugDataInfo != null) {
                    String string3 = string2.startsWith(".") ? string2 : (string2.startsWith("this.") ? string2.substring(4) : "." + string2);
                    if (debugDataInfo instanceof DebugDataArrayInfo && n2 == 0 && n == 1) {
                        DebugArrayElementInfo[] debugArrayElementInfoArray = ((DebugDataArrayInfo)debugDataInfo).getArrayElements();
                        int n3 = debugArrayElementInfoArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            DebugArrayElementInfo debugArrayElementInfo = debugArrayElementInfoArray[n4];
                            String string4 = "[" + n4 + "]";
                            DataItem dataItem = new DataItem(debugArrayElementInfo, string4, string3 + "[" + n4 + "]");
                            arrayList.add(dataItem);
                            ++n4;
                        }
                    } else {
                        String string5 = string2;
                        arrayList.add(new DataItem(debugDataInfo, string5, string3));
                    }
                }
                ++n2;
            }
            ArrayList<DataItem> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List makeDataItemsForObjectFields(DebugDataObjectInfo debugDataObjectInfo) {
        ArrayList<DataItem> arrayList = new ArrayList<DataItem>();
        DebugFieldInfo[] debugFieldInfoArray = debugDataObjectInfo.getFields(-1, this.dataPanelSettings.isHideFinalFields(), this.dataPanelSettings.isHideStaticFields());
        if (this.dataPanelSettings.isSortFieldsByName()) {
            Arrays.sort(debugFieldInfoArray, this);
        }
        int n = debugFieldInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2;
            List list;
            DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n2];
            if (!(this.useFilters && (list = this.objectPreferences.getHiddenFields(string2 = debugFieldInfo.getDeclaringClassInfo().getName())) != null && list.contains(string = debugFieldInfo.getName()) || this.shouldSkipField(debugFieldInfo))) {
                arrayList.add(new DataItem(debugFieldInfo));
            }
            ++n2;
        }
        return arrayList;
    }

    private DataItem[] makeDataItemsForArray(DataItem dataItem, DebugDataArrayInfo debugDataArrayInfo, DataArrayRange dataArrayRange) {
        DebugClassInfo debugClassInfo;
        if (dataItem.ancestorHeapInfo != null) {
            DebugClassInfo debugClassInfo2;
            DebugHeapInfo debugHeapInfo = dataItem.ancestorHeapInfo;
            boolean bl = false;
            if (this.dataPanelSettings.isHideUnrelated()) {
                bl = true;
            } else if (this.dataPanelSettings.isHideNullArrayElements() && (debugClassInfo2 = debugDataArrayInfo.getArrayElementClassInfo()) != null && !debugClassInfo2.isPrimitive()) {
                bl = true;
            }
            DebugArrayElementInfo[] debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements(debugDataArrayInfo.getArrayStart(), -1, bl);
            int n = debugArrayElementInfoArray.length;
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            int n2 = -1;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                DebugArrayElementInfo debugArrayElementInfo = debugArrayElementInfoArray[n3];
                DebugDataInfo debugDataInfo = debugArrayElementInfo.getDataInfo();
                if (debugDataInfo instanceof DebugDataCompositeInfo && 0 <= (n4 = (nArray[n3] = debugHeapInfo.getDepth((DebugDataCompositeInfo)debugDataInfo))) && (n2 == -1 || n4 < n2)) {
                    n2 = n4;
                }
                ++n3;
            }
            ArrayList<DataItem> arrayList = new ArrayList<DataItem>();
            int n5 = 0;
            while (n5 < n) {
                int n6 = nArray[n5];
                if (!this.dataPanelSettings.isHideUnrelated() || n6 >= 0) {
                    arrayList.add(new DataItem(debugArrayElementInfoArray[n5], null, debugHeapInfo, n6, n6 == n2));
                }
                ++n5;
            }
            return arrayList.toArray(new DataItem[arrayList.size()]);
        }
        boolean bl = false;
        if (this.dataPanelSettings.isHideNullArrayElements() && (debugClassInfo = debugDataArrayInfo.getArrayElementClassInfo()) != null && !debugClassInfo.isPrimitive()) {
            bl = true;
        }
        DebugArrayElementInfo[] debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements(dataArrayRange.getStart(), dataArrayRange.getCount(), bl);
        int n = debugArrayElementInfoArray.length;
        DataItem[] dataItemArray = new DataItem[n];
        int n7 = 0;
        while (n7 < n) {
            dataItemArray[n7] = new DataItem(debugArrayElementInfoArray[n7]);
            ++n7;
        }
        return dataItemArray;
    }

    private DataItem[] makeDataItemsForClass(DataItem dataItem, DebugClassInfo debugClassInfo) {
        DebugFieldInfo[] debugFieldInfoArray = debugClassInfo.getStaticFields(-1, this.dataPanelSettings.isHideFinalFields());
        if (this.dataPanelSettings.isSortFieldsByName()) {
            Arrays.sort(debugFieldInfoArray, this);
        }
        ArrayList<DataItem> arrayList = new ArrayList<DataItem>();
        int n = debugFieldInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n2];
            if (!this.shouldSkipField(debugFieldInfo)) {
                arrayList.add(new DataItem(debugFieldInfoArray[n2]));
            }
            ++n2;
        }
        return arrayList.toArray(new DataItem[arrayList.size()]);
    }

    private boolean shouldSkipField(DebugFieldInfo debugFieldInfo) {
        String string;
        int n = debugFieldInfo.getAccess();
        return (n & 0x1000) != 0 && !(string = debugFieldInfo.getName()).startsWith("this$") && !string.startsWith("val$") && !string.startsWith("v$");
    }

    private DataItem[] makeDataItemsForHeapInfo(DataItem dataItem, DebugHeapInfo debugHeapInfo) {
        DebugHeapSubset debugHeapSubset = debugHeapInfo.getHeapSubset();
        if (debugHeapSubset instanceof DebugHeapSubsetClasses) {
            DebugHeapObjectInfo[] debugHeapObjectInfoArray = debugHeapInfo.getHeapObjects(0, debugHeapInfo.countHeapObjects());
            int n = debugHeapObjectInfoArray.length;
            DataItem[] dataItemArray = new DataItem[n];
            int n2 = 0;
            while (n2 < n) {
                DebugDataCompositeInfo debugDataCompositeInfo = debugHeapObjectInfoArray[n2].getDataInfo();
                long l = debugDataCompositeInfo.getAddressOfObject();
                if (l != 0L) {
                    String string = "@" + Long.toHexString(l).toUpperCase();
                    dataItemArray[n2] = new DataItem(debugDataCompositeInfo, string, null);
                } else {
                    dataItemArray[n2] = new DataItem(debugDataCompositeInfo);
                }
                ++n2;
            }
            return dataItemArray;
        }
        if (debugHeapSubset instanceof DebugHeapSubsetAncestors) {
            DebugHeapAncestor[] debugHeapAncestorArray = this.dataPanelSettings.isShowOnlyRootAncestors() ? new DebugHeapAncestor[]{} : debugHeapInfo.getAncestorsInsideHeap();
            DebugHeapAncestorOutsideHeap[] debugHeapAncestorOutsideHeapArray = debugHeapInfo.getAncestorsOutsideHeap();
            int n = debugHeapAncestorArray.length + debugHeapAncestorOutsideHeapArray.length;
            DebugHeapAncestor[] debugHeapAncestorArray2 = new DebugHeapAncestor[n];
            System.arraycopy(debugHeapAncestorArray, 0, debugHeapAncestorArray2, 0, debugHeapAncestorArray.length);
            System.arraycopy(debugHeapAncestorOutsideHeapArray, 0, debugHeapAncestorArray2, debugHeapAncestorArray.length, debugHeapAncestorOutsideHeapArray.length);
            if (n > 0) {
                Arrays.sort(debugHeapAncestorArray2, new 1());
                DataItem[] dataItemArray = new DataItem[n];
                int n3 = 0;
                while (n3 < n) {
                    DebugHeapAncestor debugHeapAncestor = debugHeapAncestorArray2[n3];
                    int n4 = debugHeapAncestor.getDepth();
                    dataItemArray[n3] = new DataItem(debugHeapAncestor, null, debugHeapInfo, n4, true);
                    ++n3;
                }
                return dataItemArray;
            }
        }
        return new DataItem[0];
    }

    private DataItem[] makeDataItemsForHeapAncestor(DataItem dataItem, DebugHeapAncestor debugHeapAncestor) {
        DebugHeapInfo debugHeapInfo = dataItem.ancestorHeapInfo;
        DebugDataCompositeInfo debugDataCompositeInfo = debugHeapAncestor.getDataInfo();
        if (debugDataCompositeInfo != null) {
            DebugHeapAncestorInStatic debugHeapAncestorInStatic;
            DebugFieldInfo debugFieldInfo;
            long l = debugDataCompositeInfo.getAddressOfObject();
            String string = "@" + Long.toHexString(l).toUpperCase();
            if (debugHeapAncestor instanceof DebugHeapAncestorInStack) {
                DebugHeapAncestorInStack debugHeapAncestorInStack = (DebugHeapAncestorInStack)debugHeapAncestor;
                DebugVariableInfo debugVariableInfo = debugHeapAncestorInStack.getVariableInfo();
                if (debugVariableInfo != null) {
                    string = debugVariableInfo.getName();
                }
            } else if (debugHeapAncestor instanceof DebugHeapAncestorInStatic && (debugFieldInfo = (debugHeapAncestorInStatic = (DebugHeapAncestorInStatic)debugHeapAncestor).getFieldInfo()) != null) {
                string = debugFieldInfo.getName();
            }
            int n = debugHeapInfo.getDepth(debugDataCompositeInfo);
            DataItem[] dataItemArray = new DataItem[]{new DataItem(debugDataCompositeInfo, string, debugHeapInfo, n, true)};
            return dataItemArray;
        }
        return new DataItem[0];
    }

    protected int getNumberOfColumns() {
        return 7;
    }

    protected String getNameOfColumn(int n) {
        switch (n) {
            case 0: {
                return DbgArb.getString(303);
            }
            case 2: {
                return DbgArb.getString(304);
            }
            case 3: {
                return DbgArb.getString(305);
            }
            case 1: {
                return DbgArb.getString(306);
            }
            case 4: {
                return DbgArb.getString(307);
            }
            case 5: {
                return DbgArb.getString(308);
            }
            case 6: {
                return DbgArb.getString(309);
            }
        }
        return NOT_AVAILABLE;
    }

    protected List getRoot() {
        return (List)this.model.getRoot();
    }

    protected void addTopDataItem(DataItem dataItem) {
        this.model.addTopDataItem(dataItem);
    }

    protected void addTopDataItem(DataItem dataItem, boolean bl) {
        this.model.addTopDataItem(dataItem, bl);
    }

    protected void removeTopDataItem(int n) {
        this.model.removeTopDataItem(n);
    }

    protected void selectTopDataItem(int n) {
        this.model.selectTopDataItem(n);
    }

    TreePath getSelectedTreePath() {
        return this.treeTable.getTree().getSelectionPath();
    }

    DataItem getSelectedDataItem() {
        if (this.treeTable != null) {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            return this.model.getDataItemForTreePath(treePath);
        }
        return null;
    }

    private static synchronized int getDefaultArrayRangeMax() {
        if (defaultArrayRangeMax == 0) {
            defaultArrayRangeMax = 100;
            String string = Ide.getProperty((String)"DebuggerDefaultArrayRangeMax");
            if (string != null) {
                try {
                    defaultArrayRangeMax = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultArrayRangeMax;
    }

    private String prepareDisplayName(Object object, String string, String string2) {
        String string3 = DebugShared.makeCourtesyName(object);
        if (string3 != null) {
            return string3;
        }
        if (string != null) {
            return string;
        }
        return string2;
    }

    static String makeDisplayName(Object object, boolean bl) {
        if (object instanceof DebugClassInfo) {
            DebugClassInfo debugClassInfo = (DebugClassInfo)object;
            String string = debugClassInfo.getName();
            int n = 311;
            if (string.startsWith("$Oracle.")) {
                if (string.startsWith("$Oracle.Package.")) {
                    n = 312;
                } else if (string.startsWith("$Oracle.PackageBody.")) {
                    n = 313;
                } else if (string.startsWith("$Oracle.Type.")) {
                    n = 313;
                } else if (string.startsWith("$Oracle.TypeBody.")) {
                    n = 313;
                }
            } else if (string.startsWith(XSLTRunnerAddin.getXSLTPackage())) {
                n = 316;
            }
            String string2 = DebugShared.makeCourtesyClassName(debugClassInfo, bl);
            return DbgArb.format(n, string2);
        }
        return NOT_AVAILABLE;
    }

    static String makeType(DebugDataInfo debugDataInfo, DebugClassInfo debugClassInfo, boolean bl, Object object) {
        String string;
        if (debugClassInfo != null && (string = DebugShared.makeCourtesyType(debugDataInfo, debugClassInfo, bl, object)) != null) {
            return string;
        }
        return NOT_AVAILABLE;
    }

    private static String evaluateDataValue(DebugDataObjectInfo debugDataObjectInfo, Set set, String[] stringArray) {
        ObjectPreferences objectPreferences;
        String string;
        if (set.add(debugDataObjectInfo) && (string = (objectPreferences = JDebugger.getInstance().getObjectPreferences()).getValueExpression(debugDataObjectInfo)) != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(debugDataObjectInfo);
            Object object = evaluator.evaluate(string);
            if (object != null) {
                String string2;
                DebugDataInfo debugDataInfo = Evaluator.getDataInfo(object);
                String string3 = DataPanel.makeDataValue(object, debugDataInfo, set);
                if (string3 != null && string3.startsWith("\"") && string3.endsWith("\"") && !(string2 = debugDataObjectInfo.getClassInfo().getName()).equals("java.lang.String") && !string2.equals("java.lang.StringBuffer")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                if (stringArray != null && stringArray.length == 1) {
                    stringArray[0] = string;
                }
                return string3;
            }
        }
        return null;
    }

    static String makeDataValue(Object object, DebugDataInfo debugDataInfo) {
        return DataPanel.makeDataValue(object, debugDataInfo, new HashSet(), null);
    }

    static String makeDataValue(Object object, DebugDataInfo debugDataInfo, Set set) {
        return DataPanel.makeDataValue(object, debugDataInfo, set, null);
    }

    static String makeDataValue(Object object, DebugDataInfo debugDataInfo, String[] stringArray) {
        return DataPanel.makeDataValue(object, debugDataInfo, new HashSet(), stringArray);
    }

    static String makeDataValue(Object object, DebugDataInfo debugDataInfo, Set set, String[] stringArray) {
        if (debugDataInfo != null) {
            String string = null;
            if (debugDataInfo instanceof DebugDataCompositeInfo) {
                if (debugDataInfo instanceof DebugDataObjectInfo) {
                    string = DataPanel.evaluateDataValue((DebugDataObjectInfo)debugDataInfo, set, stringArray);
                }
                if (string == null) {
                    string = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)debugDataInfo);
                }
                if (string == null) {
                    string = debugDataInfo.getValue();
                }
            } else {
                string = debugDataInfo.getValue();
                if (debugDataInfo instanceof DebugDataPrimitiveInfo) {
                    try {
                        DebugClassInfo debugClassInfo = debugDataInfo.getClassInfo();
                        if (debugClassInfo != null) {
                            byte[] byArray;
                            String string2;
                            String string3;
                            String string4 = debugClassInfo.getName();
                            if (string4.equals("char")) {
                                String string5 = debugDataInfo.getHexValue();
                                if (string5 != null && string5.length() > 0) {
                                    int n = Integer.parseInt(string5, 16);
                                    string = string + "    " + n;
                                }
                            } else if (string4.equals("byte") && (string3 = debugDataInfo.getHexValue()) != null && string3.length() > 0 && (string2 = new String(byArray = new byte[]{Byte.parseByte(string3, 16)}, Encodings.getDefaultEncoding())).length() == 1) {
                                FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
                                fastStringBuffer.append(' ');
                                int n = string.length() + 1;
                                while (n < 7) {
                                    fastStringBuffer.append(' ');
                                    ++n;
                                }
                                fastStringBuffer.append('\'');
                                fastStringBuffer.append(string2);
                                fastStringBuffer.append('\'');
                                string = fastStringBuffer.toString();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (string != null) {
                return string;
            }
        } else {
            if (object instanceof EvaluationInfo) {
                return ((EvaluationInfo)object).getValue();
            }
            if (object instanceof DebugVariableInfo) {
                return DbgArb.getString(310);
            }
            if (object instanceof DebugStackSlotInfo) {
                return ((DebugStackSlotInfo)object).getValue();
            }
        }
        return NOT_AVAILABLE;
    }

    static String makeHexValue(Object object, DebugDataInfo debugDataInfo) {
        if (debugDataInfo != null) {
            String string = debugDataInfo.getHexValue();
            if (string != null && string.length() > 0) {
                return "0x" + string.toUpperCase();
            }
        } else {
            if (object instanceof EvaluationInfo) {
                return "0x" + ((EvaluationInfo)object).getHexValue().toUpperCase();
            }
            if (object instanceof DebugVariableInfo) {
                return DbgArb.getString(310);
            }
            if (object instanceof DebugStackSlotInfo) {
                return "0x" + ((DebugStackSlotInfo)object).getHexValue().toUpperCase();
            }
        }
        return NOT_AVAILABLE;
    }

    private static Icon getPrimitiveIcon() {
        if (primitiveIcon == null) {
            primitiveIcon = JavaIcons.getIcon(2);
        }
        return primitiveIcon;
    }

    private static Icon getPrimitiveIconGray() {
        if (primitiveIconGray == null) {
            primitiveIconGray = IdeUtil.grayIcon((Icon)DataPanel.getPrimitiveIcon());
        }
        return primitiveIconGray;
    }

    private static Icon getObjectIcon() {
        if (objectIcon == null) {
            objectIcon = JavaIcons.getIcon(0);
        }
        return objectIcon;
    }

    private static Icon getObjectIconGray() {
        if (objectIconGray == null) {
            objectIconGray = IdeUtil.grayIcon((Icon)DataPanel.getObjectIcon());
        }
        return objectIconGray;
    }

    private static Icon getArrayIcon() {
        if (arrayIcon == null) {
            arrayIcon = DbgArb.getIcon(299);
        }
        return arrayIcon;
    }

    private static Icon getArrayIconGray() {
        if (arrayIconGray == null) {
            arrayIconGray = IdeUtil.grayIcon((Icon)DataPanel.getArrayIcon());
        }
        return arrayIconGray;
    }

    private static Icon getStaticFolderIcon() {
        if (staticFolderIcon == null) {
            staticFolderIcon = DbgArb.getIcon(300);
        }
        return staticFolderIcon;
    }

    private static Icon getHeapFolderIcon() {
        if (heapFolderIcon == null) {
            heapFolderIcon = DbgArb.getIcon(301);
        }
        return heapFolderIcon;
    }

    private static Icon getEvaluationIcon() {
        if (evaluationIcon == null) {
            evaluationIcon = IdeIcons.getIcon((int)20);
        }
        return evaluationIcon;
    }

    protected static DataFlavor getExpressionFlavor() {
        if (expressionFlavor == null) {
            expressionFlavor = new DataFlavor(Expression.class, "Expression");
        }
        return expressionFlavor;
    }

    protected static DataFlavor getHeapObjectFlavor() {
        if (heapObjectFlavor == null) {
            heapObjectFlavor = new DataFlavor(DebugDataCompositeInfo.class, "HeapObject");
        }
        return heapObjectFlavor;
    }

    static boolean mav$handleDoubleClickOrEnter(DataPanel dataPanel, EventObject eventObject, int n) {
        return dataPanel.handleDoubleClickOrEnter(eventObject, n);
    }

    static void mav$adjustColumnsAfterResize(DataPanel dataPanel) {
        dataPanel.adjustColumnsAfterResize();
    }

    static Icon maS$getEvaluationIcon() {
        return DataPanel.getEvaluationIcon();
    }

    static Map ra$arrayRanges(DataPanel dataPanel) {
        return dataPanel.arrayRanges;
    }

    static DataTreeCellRenderer ra$dataTreeCellRenderer(DataPanel dataPanel) {
        return dataPanel.dataTreeCellRenderer;
    }

    static DataTableCellRenderer ra$dataTableCellRenderer(DataPanel dataPanel) {
        return dataPanel.dataTableCellRenderer;
    }

    static void wa$skippedUpdate(DataPanel dataPanel, boolean bl) {
        dataPanel.skippedUpdate = bl;
    }

    static boolean[] ra$columnShowing(DataPanel dataPanel) {
        return dataPanel.columnShowing;
    }

    static DataPanelSettings ra$dataPanelSettings(DataPanel dataPanel) {
        return dataPanel.dataPanelSettings;
    }

    static DataItem[] mav$makeDataItemsForObject(DataPanel dataPanel, DataItem dataItem, DebugDataObjectInfo debugDataObjectInfo) {
        return dataPanel.makeDataItemsForObject(dataItem, debugDataObjectInfo);
    }

    static DataItem[] mav$makeDataItemsForArray(DataPanel dataPanel, DataItem dataItem, DebugDataArrayInfo debugDataArrayInfo, DataArrayRange dataArrayRange) {
        return dataPanel.makeDataItemsForArray(dataItem, debugDataArrayInfo, dataArrayRange);
    }

    static DataItem[] mav$makeDataItemsForClass(DataPanel dataPanel, DataItem dataItem, DebugClassInfo debugClassInfo) {
        return dataPanel.makeDataItemsForClass(dataItem, debugClassInfo);
    }

    static DataItem[] mav$makeDataItemsForHeapInfo(DataPanel dataPanel, DataItem dataItem, DebugHeapInfo debugHeapInfo) {
        return dataPanel.makeDataItemsForHeapInfo(dataItem, debugHeapInfo);
    }

    static DataItem[] mav$makeDataItemsForHeapAncestor(DataPanel dataPanel, DataItem dataItem, DebugHeapAncestor debugHeapAncestor) {
        return dataPanel.makeDataItemsForHeapAncestor(dataItem, debugHeapAncestor);
    }

    static DataFlavor[] ra$transferFlavors() {
        return transferFlavors;
    }

    static String mav$prepareDisplayName(DataPanel dataPanel, Object object, String string, String string2) {
        return dataPanel.prepareDisplayName(object, string, string2);
    }

    static Icon maS$getStaticFolderIcon() {
        return DataPanel.getStaticFolderIcon();
    }

    static Icon maS$getHeapFolderIcon() {
        return DataPanel.getHeapFolderIcon();
    }

    static Icon maS$getPrimitiveIconGray() {
        return DataPanel.getPrimitiveIconGray();
    }

    static Icon maS$getArrayIconGray() {
        return DataPanel.getArrayIconGray();
    }

    static Icon maS$getObjectIconGray() {
        return DataPanel.getObjectIconGray();
    }

    static Icon maS$getPrimitiveIcon() {
        return DataPanel.getPrimitiveIcon();
    }

    static Icon maS$getArrayIcon() {
        return DataPanel.getArrayIcon();
    }

    static Icon maS$getObjectIcon() {
        return DataPanel.getObjectIcon();
    }

    static DataArrayRange mav$getArrayRange(DataPanel dataPanel, DebugDataArrayInfo debugDataArrayInfo) {
        return dataPanel.getArrayRange(debugDataArrayInfo);
    }

    static int maS$getDefaultArrayRangeMax() {
        return DataPanel.getDefaultArrayRangeMax();
    }

    final class 10
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            DataPanel.this.dataPanelSettingsChanged(true);
        }
    }

    final class 9
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ DataPanel this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                defaultTableCellRenderer.setHorizontalAlignment(2);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public 9(DataPanel dataPanel, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = dataPanel;
        }
    }

    final class 8
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                DataPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                DataPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, DataPanel.this.dockableWindow.getTitleName()));
            }
            if (JDebugger.isDoubleClickInTreeTable(DataPanel.this.treeTable, mouseEvent)) {
                int n = DataPanel.this.treeTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                int n2 = DataPanel.this.treeTable.convertColumnIndexToModel(n);
                DataPanel.mav$handleDoubleClickOrEnter(DataPanel.this, mouseEvent, n2);
            }
        }
    }

    final class 7
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, DataPanel.this.dockableWindow.getTitleName()));
            }
        }
    }

    final class 6
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    int n2;
                    int n3 = DataPanel.this.treeTable.getSelectedColumn();
                    if (n3 == -1 || !DataPanel.mav$handleDoubleClickOrEnter(DataPanel.this, keyEvent, n2 = DataPanel.this.treeTable.convertColumnIndexToModel(n3))) break;
                    keyEvent.consume();
                }
            }
        }
    }

    final class 5
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                DataPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                DataPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, DataPanel.this.dockableWindow.getTitleName()));
            }
        }
    }

    final class 4
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            DataPanel.mav$adjustColumnsAfterResize(DataPanel.this);
        }
    }

    final class 3
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & (long)4) != 0L && DataPanel.this.treeTable.isShowing()) {
                DataPanel.this.nowShown();
            }
        }
    }

    class DataTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreePath treePath;
        private DataItem dataItem;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DataItem) {
                this.treePath = DataPanel.this.treeTable.getTree().getPathForRow(n);
                this.dataItem = (DataItem)object;
                this.setIcon(this.dataItem.getIcon());
                this.setFont(this.dataItem.getFont(0));
                this.setEnabled(DataItem.mav$isUnrelated(this.dataItem) ^ true);
                AccessibleContext accessibleContext = this.getAccessibleContext();
                String string = DataTreeTableModel.mav$getAccessibleNameAt(DataPanel.this.model, this.dataItem, 0);
                if (this.dataItem.mayHaveChildren()) {
                    string = JDebugger.fixTreeCellAccessibleName(string, bl2);
                }
                if (string != null) {
                    accessibleContext.setAccessibleName(string);
                }
            } else {
                this.dataItem = null;
                this.setIcon(null);
                this.setFont(DataPanel.this.getNormalFont());
                this.setEnabled(true);
                this.setToolTipText(null);
            }
            return this;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (this.dataItem != null && this.treePath != null) {
                return this.dataItem.getToolTip(0, this.treePath);
            }
            return null;
        }

        void clear() {
            this.treePath = null;
            this.dataItem = null;
        }

        DataTreeCellRenderer() {
        }
    }

    class DataTableCellRenderer
    extends DefaultTableCellRenderer {
        private TreePath treePath;
        private DataItem dataItem;
        private int modelColumn;
        private JPanel panel;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.treePath = DataPanel.this.treeTable.getTree().getPathForRow(n);
            this.dataItem = DataPanel.this.model.getDataItemForTreePath(this.treePath);
            this.modelColumn = jTable.convertColumnIndexToModel(n2);
            this.setFont(this.dataItem.getFont(this.modelColumn));
            AccessibleContext accessibleContext = this.getAccessibleContext();
            String string = DataTreeTableModel.mav$getAccessibleNameAt(DataPanel.this.model, this.dataItem, this.modelColumn);
            if (string != null) {
                accessibleContext.setAccessibleName(string);
            }
            if (this.modelColumn == 1 && this.dataItem.getValueExpressionUsed() != null) {
                if (this.panel == null) {
                    this.makePanel();
                }
                this.panel.add((Component)this, "Center");
                return this.panel;
            }
            Container container = this.getParent();
            if (container != null) {
                container.remove(this);
            }
            return this;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (this.dataItem != null && this.treePath != null) {
                return this.dataItem.getToolTip(this.modelColumn, this.treePath);
            }
            return null;
        }

        void clear() {
            this.treePath = null;
            this.dataItem = null;
        }

        private void makePanel() {
            this.panel = new 1(new BorderLayout(0, 0));
            JButton jButton = new JButton(DataPanel.maS$getEvaluationIcon());
            jButton.setMargin(new Insets(2, 2, 2, 2));
            this.panel.add((Component)jButton, "East");
        }

        DataTableCellRenderer() {
        }

        final class 1
        extends JPanel {
            public String getToolTipText(MouseEvent mouseEvent) {
                return DataTableCellRenderer.this.getToolTipText(mouseEvent);
            }

            public 1(LayoutManager layoutManager) {
                super(layoutManager);
            }
        }
    }

    class ValueCellEditor
    extends AbstractTableCellEditor {
        private JPanel panel = new JPanel(new BorderLayout(0, 0));
        private JLabel label = new JLabel();

        ValueCellEditor() {
            this.label.setOpaque(true);
            this.label.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.panel.add((Component)this.label, "Center");
            JButton jButton = new JButton(DataPanel.maS$getEvaluationIcon());
            jButton.setMargin(new Insets(2, 2, 2, 2));
            jButton.addActionListener(new 1());
            this.panel.add((Component)jButton, "East");
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.label.setForeground(jTable.getSelectionForeground());
            this.label.setBackground(jTable.getSelectionBackground());
            this.label.setFont(jTable.getFont());
            this.label.setText(object == null ? DataPanel.NOT_AVAILABLE : object.toString());
            return this.panel;
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return eventObject instanceof MouseEvent;
        }

        final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ValueCellEditor.this.cancelCellEditing();
                Context context = DataPanel.this.getContext(actionEvent);
                DataPanel.this.update(DataPanel.this._actionObjectPreferences, context);
                if (DataPanel.this._actionObjectPreferences.isEnabled()) {
                    DataPanel.this.handleEvent(DataPanel.this._actionObjectPreferences, context);
                }
            }
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            DataPanel.this.everythingChanged();
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((DebugHeapAncestor)object).getDepth() - ((DebugHeapAncestor)object2).getDepth();
        }
    }

    final class DataTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List expanded;
        private DataInfoPath highlight;

        DataTreeTableModel(List list) {
            super((Object)list);
            this.root = list;
            this.expanded = new ArrayList();
        }

        void updateDataForModel() {
            this.saveHighlight();
            DataPanel.ra$dataTreeCellRenderer(DataPanel.this).clear();
            DataPanel.ra$dataTableCellRenderer(DataPanel.this).clear();
            this.root.clear();
            if (DataPanel.this.treeTable.isShowing()) {
                DataPanel.wa$skippedUpdate(DataPanel.this, false);
                if (DataPanel.this.debuggingProcess != null && DataPanel.this.vm != null) {
                    DataPanel.this.addDataItems();
                }
            } else {
                DataPanel.wa$skippedUpdate(DataPanel.this, true);
            }
            this.fireChanged();
            this.restoreHighlight(false);
        }

        void fireChanged() {
            TreePath treePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, treePath.getPath(), null, null);
            this.restoreExpanded(treePath);
        }

        void fireChanged(TreePath treePath) {
            this.fireTreeStructureChanged((Object)this, treePath.getPath(), null, null);
        }

        void clearDataForModel() {
            this.saveHighlight();
            this.clearAll();
        }

        void addTopDataItem(DataItem dataItem) {
            this.addTopDataItem(dataItem, true);
        }

        void addTopDataItem(DataItem dataItem, boolean bl) {
            if (!bl) {
                this.saveHighlight();
            }
            int n = this.root.size();
            this.root.add(dataItem);
            this.fireChanged();
            if (bl) {
                this.selectTopDataItem(n);
            } else {
                this.restoreHighlight(false);
            }
        }

        void removeTopDataItem(int n) {
            this.saveHighlight();
            this.root.remove(n);
            this.fireChanged();
            this.restoreHighlight(false);
        }

        void selectTopDataItem(int n) {
            Object[] objectArray = new Object[]{this.root, this.root.get(n)};
            TreePath treePath = new TreePath(objectArray);
            JDebugger.getInstance().selectTreeTablePath(DataPanel.this.treeTable, treePath, true);
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            ArrayList<DataInfoPath> arrayList = new ArrayList<DataInfoPath>();
            for (DataInfoPath dataInfoPath : this.expanded) {
                if (dataInfoPath.getDebuggingProcess() != debuggingProcess) continue;
                arrayList.add(dataInfoPath);
            }
            for (Object e : arrayList) {
                this.expanded.remove(e);
            }
            this.highlight = null;
            ArrayList arrayList2 = new ArrayList();
            for (Object k : DataPanel.ra$arrayRanges(DataPanel.this).keySet()) {
                DataArrayRange dataArrayRange = (DataArrayRange)DataPanel.ra$arrayRanges(DataPanel.this).get(k);
                if (dataArrayRange.getDebuggingProcess() != debuggingProcess) continue;
                arrayList2.add(k);
            }
            int n = arrayList2.size() - 1;
            while (n >= 0) {
                DataPanel.ra$arrayRanges(DataPanel.this).remove(arrayList2.get(n));
                --n;
            }
        }

        private void clearAll() {
            this.clearAll(DataPanel.this.treeTable.getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof DataItem) {
                ((DataItem)object).clearDataForItem();
            }
            Iterator iterator = this.getLazyChildren(object);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.clearAll(jTree, treePath.pathByAddingChild(e));
            }
        }

        private void clearCacheForColumn(int n) {
            this.clearCacheForColumn(DataPanel.this.treeTable.getTree(), new TreePath(this.root), n);
        }

        private void clearCacheForColumn(JTree jTree, TreePath treePath, int n) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof DataItem) {
                ((DataItem)object).clearCacheForColumn(n);
            }
            Iterator iterator = this.getLazyChildren(object);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.clearCacheForColumn(jTree, treePath.pathByAddingChild(e), n);
            }
        }

        private void restoreExpanded(TreePath treePath) {
            JTree jTree = DataPanel.this.treeTable.getTree();
            if (jTree.isExpanded(treePath)) {
                Object object = treePath.getLastPathComponent();
                Iterator iterator = this.getChildren(object);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    TreePath treePath2 = treePath.pathByAddingChild(e);
                    DataInfoPath dataInfoPath = this.convertTreePathToDataInfoPath(treePath2);
                    if (!this.expanded.contains(dataInfoPath)) continue;
                    jTree.expandPath(treePath2);
                }
            }
        }

        private void branchExpanded(TreePath treePath) {
            DataInfoPath dataInfoPath;
            DataItem dataItem = this.getDataItemForTreePath(treePath);
            if (dataItem != null) {
                DataItem.wa$isExpanded(dataItem, true);
            }
            if ((dataInfoPath = this.convertTreePathToDataInfoPath(treePath)) != null) {
                int n = this.expanded.indexOf(dataInfoPath);
                if (n != -1) {
                    this.expanded.remove(n);
                }
                this.expanded.add(dataInfoPath);
                this.restoreExpanded(treePath);
            }
        }

        private void branchCollapsed(TreePath treePath) {
            DataInfoPath dataInfoPath;
            DataItem dataItem = this.getDataItemForTreePath(treePath);
            if (dataItem != null) {
                DataItem.wa$isExpanded(dataItem, false);
            }
            if ((dataInfoPath = this.convertTreePathToDataInfoPath(treePath)) != null) {
                this.expanded.remove(dataInfoPath);
            }
        }

        private void saveHighlight() {
            DataInfoPath dataInfoPath = this.getCurrentHighlight();
            if (dataInfoPath != null) {
                this.highlight = dataInfoPath;
            }
        }

        private void restoreHighlight(boolean bl) {
            TreePath treePath = null;
            if (this.highlight != null) {
                treePath = this.makeVisible(this.highlight);
            }
            if (treePath == null && DataPanel.this.selectFirstRowIfNoPreviousSelection) {
                treePath = DataPanel.this.treeTable.getTree().getPathForRow(0);
            }
            if (treePath != null) {
                JDebugger.getInstance().selectTreeTablePath(DataPanel.this.treeTable, treePath, bl);
            }
        }

        TreePath makeVisible(DataInfoPath dataInfoPath) {
            TreePath treePath = this.convertDataInfoPathToTreePath(dataInfoPath);
            if (treePath != null) {
                DataPanel.this.treeTable.getTree().makeVisible(treePath);
            }
            return treePath;
        }

        DataInfoPath getCurrentHighlight() {
            TreePath treePath = DataPanel.this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToDataInfoPath(treePath);
            }
            return null;
        }

        TreePath getTreePathAtPoint(Point point) {
            int n = DataPanel.this.treeTable.rowAtPoint(point);
            return DataPanel.this.treeTable.getTree().getPathForRow(n);
        }

        DataItem getDataItemForTreePath(TreePath treePath) {
            Object object;
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DataItem) {
                return (DataItem)object;
            }
            return null;
        }

        DataInfoPath convertTreePathToDataInfoPath(TreePath treePath) {
            boolean bl = false;
            Object[] objectArray = treePath.getPath();
            int n = objectArray.length;
            Object[] objectArray2 = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof DataItem) {
                    objectArray2[n2] = ((DataItem)object).getInfo();
                    if (objectArray2[n2] != null) {
                        bl = true;
                    }
                }
                ++n2;
            }
            if (bl) {
                return new DataInfoPath(DataPanel.this.debuggingProcess, objectArray2);
            }
            return null;
        }

        TreePath convertDataInfoPathToTreePath(DataInfoPath dataInfoPath) {
            int n = dataInfoPath.size();
            if (n == 0) {
                return null;
            }
            List list = this.root;
            TreePath treePath = new TreePath(list);
            int n2 = 1;
            while (n2 < n) {
                Object object = dataInfoPath.getDataInfo(n2);
                Object var7_7 = null;
                Iterator iterator = this.getChildren(list);
                while (iterator.hasNext()) {
                    Object object2;
                    Object e = iterator.next();
                    if (!(e instanceof DataItem) || !((object2 = ((DataItem)e).getInfo()) == null ? object == null : object2.equals(object))) continue;
                    var7_7 = e;
                    break;
                }
                if (var7_7 == null) {
                    return null;
                }
                list = var7_7;
                treePath = treePath.pathByAddingChild(list);
                ++n2;
            }
            return treePath;
        }

        private void collapseAll() {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.collapseAll(DataPanel.this.treeTable.getTree(), new TreePath(this.root));
            waitCursor.hide();
        }

        private void collapseAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            Iterator iterator = this.getLazyChildren(object);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.collapseAll(jTree, treePath.pathByAddingChild(e));
            }
            if (!object.equals(this.root)) {
                jTree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter printWriter, boolean bl) {
            if (bl) {
                printWriter.println("<table border=\"1\">");
            }
            this.saveHeader(printWriter, bl);
            this.save(DataPanel.this.treeTable.getTree(), new TreePath(this.root), printWriter, bl, DataPanel.NOT_AVAILABLE);
            if (bl) {
                printWriter.println("</table>");
            }
        }

        private void saveHeader(PrintWriter printWriter, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (bl) {
                stringBuffer.append("<tr>");
            }
            TableColumnModel tableColumnModel = DataPanel.this.treeTable.getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                int n = tableColumn.getModelIndex();
                String string = this.getColumnName(n);
                if (bl) {
                    stringBuffer.append("<th>");
                    string = IdeUtil.replaceHTMLReservedCharacters((String)string.toString());
                    stringBuffer.append(string);
                    stringBuffer.append("</th>");
                    continue;
                }
                stringBuffer.append(string);
                int n2 = string.length();
                while (n2 >= 0) {
                    stringBuffer2.append('-');
                    --n2;
                }
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append('\t');
                stringBuffer2.append('\t');
            }
            if (bl) {
                stringBuffer.append("</tr>");
            }
            printWriter.println(stringBuffer.toString());
            if (!bl) {
                printWriter.println(stringBuffer2.toString());
            }
        }

        private void save(JTree jTree, TreePath treePath, PrintWriter printWriter, boolean bl, String string) {
            if (jTree.isVisible(treePath)) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof DataItem) {
                    DataItem dataItem = (DataItem)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (bl) {
                        stringBuffer.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = DataPanel.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                    while (enumeration.hasMoreElements()) {
                        TableColumn tableColumn = enumeration.nextElement();
                        int n = tableColumn.getModelIndex();
                        Object object2 = this.getValueAt(object, n);
                        if (bl) {
                            String string2;
                            stringBuffer.append("<td>");
                            if (n == 0) {
                                stringBuffer.append("<tt>");
                                if (string != null) {
                                    stringBuffer.append(string);
                                }
                                if (jTree.isExpanded(treePath)) {
                                    stringBuffer.append("-&nbsp;");
                                } else if (dataItem.mayHaveChildren()) {
                                    stringBuffer.append("+&nbsp;");
                                } else {
                                    stringBuffer.append("&nbsp;&nbsp;");
                                }
                                stringBuffer.append("</tt>");
                            }
                            if ((string2 = IdeUtil.replaceHTMLReservedCharacters((String)object2.toString())).length() > 0) {
                                stringBuffer.append(string2);
                            } else {
                                stringBuffer.append("&nbsp;");
                            }
                            stringBuffer.append("</td>");
                            continue;
                        }
                        if (n == 0) {
                            if (string != null) {
                                stringBuffer.append(string);
                            }
                            if (jTree.isExpanded(treePath)) {
                                stringBuffer.append("- ");
                            } else if (dataItem.mayHaveChildren()) {
                                stringBuffer.append("+ ");
                            } else {
                                stringBuffer.append("  ");
                            }
                        }
                        stringBuffer.append(object2);
                        if (!enumeration.hasMoreElements()) continue;
                        stringBuffer.append('\t');
                    }
                    if (bl) {
                        stringBuffer.append("</tr>");
                    }
                    printWriter.println(stringBuffer.toString());
                }
                if (object != this.root) {
                    string = bl ? string + "&nbsp;&nbsp;&nbsp;&nbsp;" : string + "    ";
                }
                Iterator iterator = this.getLazyChildren(object);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    this.save(jTree, treePath.pathByAddingChild(e), printWriter, bl, string);
                }
            }
        }

        public boolean isLeaf(Object object) {
            try {
                if (object == this.root) {
                    boolean bl = false;
                    return bl;
                }
                DataItem dataItem = (DataItem)object;
                boolean bl = dataItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
        }

        Iterator getChildren(Object object) {
            if (object == this.root) {
                return this.root.iterator();
            }
            DataItem dataItem = (DataItem)object;
            return dataItem.getChildren();
        }

        Iterator getLazyChildren(Object object) {
            if (object == this.root) {
                return this.root.iterator();
            }
            DataItem dataItem = (DataItem)object;
            return dataItem.getLazyChildren();
        }

        public Object getChild(Object object, int n) {
            try {
                if (object == this.root) {
                    Object e = this.root.get(n);
                    return e;
                }
                DataItem dataItem = (DataItem)object;
                DataItem dataItem2 = dataItem.getChildNodes()[n];
                return dataItem2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object object) {
            try {
                if (object == this.root) {
                    int n = this.root.size();
                    return n;
                }
                DataItem dataItem = (DataItem)object;
                int n = dataItem.countChildNodes();
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return DataPanel.this.getNumberOfColumns();
        }

        public String getColumnName(int n) {
            return DataPanel.this.getNameOfColumn(n);
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public boolean isCellEditable(Object object, int n) {
            try {
                DataItem dataItem;
                if (n == 1 && object != this.root && (dataItem = (DataItem)object).getValueExpressionUsed() != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return super.isCellEditable(object, n);
        }

        public Object getValueAt(Object object, int n) {
            try {
                if (object == this.root) {
                    String string = DataPanel.NOT_AVAILABLE;
                    return string;
                }
                DataItem dataItem = (DataItem)object;
                Object object2 = dataItem.getValueOfColumn(n);
                return object2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        private String getAccessibleNameAt(DataItem dataItem, int n) {
            int n2 = 302;
            String string = this.getColumnName(n);
            String string2 = (String)this.getValueAt(dataItem, n);
            if (string2.length() == 0) {
                string2 = DbgArb.getString(884);
            }
            return DbgArb.format(n2, string, string2);
        }

        static void mav$clearCacheForColumn(DataTreeTableModel dataTreeTableModel, int n) {
            dataTreeTableModel.clearCacheForColumn(n);
        }

        static void mav$saveHighlight(DataTreeTableModel dataTreeTableModel) {
            dataTreeTableModel.saveHighlight();
        }

        static void mav$restoreHighlight(DataTreeTableModel dataTreeTableModel, boolean bl) {
            dataTreeTableModel.restoreHighlight(bl);
        }

        static void mav$save(DataTreeTableModel dataTreeTableModel, PrintWriter printWriter, boolean bl) {
            dataTreeTableModel.save(printWriter, bl);
        }

        static void mav$collapseAll(DataTreeTableModel dataTreeTableModel) {
            dataTreeTableModel.collapseAll();
        }

        static void mav$branchCollapsed(DataTreeTableModel dataTreeTableModel, TreePath treePath) {
            dataTreeTableModel.branchCollapsed(treePath);
        }

        static void mav$branchExpanded(DataTreeTableModel dataTreeTableModel, TreePath treePath) {
            dataTreeTableModel.branchExpanded(treePath);
        }

        static String mav$getAccessibleNameAt(DataTreeTableModel dataTreeTableModel, DataItem dataItem, int n) {
            return dataTreeTableModel.getAccessibleNameAt(dataItem, n);
        }
    }

    protected class DataItem
    extends BaseElement
    implements Transferable {
        protected Object info;
        private boolean isDebugHeapAncestor;
        private boolean isDebugHeapAncestorOutsideHeap;
        protected DebugDataInfo data;
        private DebugClassInfo actualClassInfo;
        private DebugClassInfo declaredClassInfo;
        protected DebugHeapInfo ancestorHeapInfo;
        protected int ancestorDepth;
        protected boolean ancestorShortestDepth;
        protected boolean displayNameOverridden;
        protected String displayName;
        protected String expressionPart;
        protected String displayType;
        protected String displayValue;
        private DataItem[] children;
        private DataArrayRange arrayRange;
        private Expression expressionSaved;
        private Boolean cachedMayHaveChildren;
        private String cachedDisplayName;
        private String cachedActualType;
        private String cachedDeclaredType;
        private String cachedValue;
        private String cachedValueExpressionUsed;
        private String cachedHexValue;
        private String cachedAddress;
        private String cachedID;
        private DataItem parentDataItem;
        private boolean isExpanded;

        DataItem(Object object) {
            this(object, null, null);
        }

        DataItem(Object object, String string, String string2) {
            this.ancestorHeapInfo = null;
            this.ancestorDepth = -1;
            this.ancestorShortestDepth = false;
            this.setInfo(object, string, string2);
        }

        DataItem(Object object, String string, DebugHeapInfo debugHeapInfo, int n, boolean bl) {
            this.ancestorHeapInfo = debugHeapInfo;
            this.ancestorDepth = n;
            this.ancestorShortestDepth = bl;
            this.setInfo(object, string, null);
        }

        void modifyInfo(Object object, String string, String string2, TreePath treePath) {
            boolean bl = DataPanel.this.treeTable.getTree().isExpanded(treePath);
            if (bl) {
                DataTreeTableModel.mav$branchCollapsed(DataPanel.this.model, treePath);
            }
            this.setInfo(object, string, string2);
            this.clearChildren(treePath);
            if (bl) {
                DataTreeTableModel.mav$branchExpanded(DataPanel.this.model, treePath);
            }
        }

        private void setInfo(Object object, String string, String string2) {
            this.clearCacheForColumn(-1);
            this.setIcon(null);
            this.info = object;
            this.isDebugHeapAncestor = object instanceof DebugHeapAncestor;
            this.isDebugHeapAncestorOutsideHeap = object instanceof DebugHeapAncestorOutsideHeap;
            this.displayNameOverridden = string != null;
            this.children = null;
            this.arrayRange = null;
            this.expressionSaved = null;
            if (object instanceof DebugVariableInfo) {
                DebugVariableInfo debugVariableInfo = (DebugVariableInfo)object;
                this.data = debugVariableInfo.getDataInfo();
                this.declaredClassInfo = debugVariableInfo.getClassInfo();
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
                String string3 = debugVariableInfo.getName();
                String string4 = this.expressionPart = string2 != null ? string2 : string3;
                this.displayName = debugVariableInfo.isReturned() && string3 != null && string3.length() > 0 ? DbgArb.format(632, string3) : DataPanel.mav$prepareDisplayName(DataPanel.this, object, string, this.expressionPart);
            } else if (object instanceof DebugStackSlotInfo) {
                DebugStackSlotInfo debugStackSlotInfo = (DebugStackSlotInfo)object;
                this.data = debugStackSlotInfo.getDataInfo();
                this.declaredClassInfo = null;
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : null;
                this.expressionPart = string2;
                this.displayName = string;
            } else if (object instanceof DebugFieldInfo) {
                DebugFieldInfo debugFieldInfo = (DebugFieldInfo)object;
                this.data = debugFieldInfo.getDataInfo();
                this.declaredClassInfo = debugFieldInfo.getClassInfo();
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
                this.expressionPart = string2 != null ? string2 : debugFieldInfo.getName();
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, object, string, this.expressionPart);
            } else if (object instanceof DebugArrayElementInfo) {
                DebugArrayElementInfo debugArrayElementInfo = (DebugArrayElementInfo)object;
                this.data = debugArrayElementInfo.getDataInfo();
                this.declaredClassInfo = debugArrayElementInfo.getClassInfo();
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
                this.expressionPart = string2 != null ? string2 : debugArrayElementInfo.getName();
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, object, string, this.expressionPart);
            } else if (object instanceof DebugDataInfo) {
                this.data = (DebugDataInfo)object;
                this.declaredClassInfo = null;
                this.actualClassInfo = this.data.getClassInfo();
                this.expressionPart = string2;
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, object, string, this.expressionPart);
            } else if (object instanceof DebugClassInfo) {
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = ((DebugClassInfo)object).getName();
                this.displayName = null;
                this.setIcon(DataPanel.maS$getStaticFolderIcon());
            } else if (object instanceof DebugHeapSubset) {
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = string2;
                this.displayName = ((DebugHeapSubset)object).getName();
                this.setIcon(DataPanel.maS$getHeapFolderIcon());
            } else if (object instanceof DebugHeapInfo) {
                DebugHeapInfo debugHeapInfo = (DebugHeapInfo)object;
                DebugHeapSubset debugHeapSubset = debugHeapInfo.getHeapSubset();
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = string2;
                if (debugHeapSubset instanceof DebugHeapSubsetClasses) {
                    this.displayName = debugHeapSubset.getName() + " " + debugHeapInfo.countHeapObjects();
                } else if (debugHeapSubset instanceof DebugHeapSubsetAncestors) {
                    DebugHeapObjectInfo debugHeapObjectInfo;
                    long l = ((DebugHeapSubsetAncestors)debugHeapSubset).getAddress();
                    if (l != 0L && (debugHeapObjectInfo = DataPanel.this.vm.getHeapObjectAtAddress(l)) != null) {
                        this.actualClassInfo = debugHeapObjectInfo.getClassInfo();
                    }
                    this.displayName = debugHeapSubset.getName();
                }
                this.setIcon(DataPanel.maS$getHeapFolderIcon());
            } else if (object instanceof EvaluationInfo) {
                EvaluationInfo evaluationInfo = (EvaluationInfo)object;
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = evaluationInfo.getClassInfo();
                this.expressionPart = string2;
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, object, string, this.expressionPart);
            } else if (object instanceof EvaluatorItem) {
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.data = null;
                this.expressionPart = string2;
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, object, string, this.expressionPart);
                this.cachedMayHaveChildren = Boolean.FALSE;
                this.cachedActualType = "?";
                this.cachedDeclaredType = "?";
                this.cachedValue = "?";
                this.cachedHexValue = "?";
                this.cachedAddress = DataPanel.NOT_AVAILABLE;
                this.cachedID = DataPanel.NOT_AVAILABLE;
            } else if (object instanceof DebugMonitorInfo) {
                DebugMonitorInfo debugMonitorInfo = (DebugMonitorInfo)object;
                this.data = debugMonitorInfo.getAssociatedObject();
                this.declaredClassInfo = null;
                this.actualClassInfo = this.data.getClassInfo();
                this.expressionPart = string2;
                String string5 = null;
                long l = JDebugger.getObjectNumber((DebugDataCompositeInfo)this.data);
                string5 = "@" + Long.toHexString(l).toUpperCase();
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, object, string, string5);
            } else if (object instanceof DebugHeapAncestor) {
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = string2;
                int n = ((DebugHeapAncestor)object).getDepth();
                this.displayValue = DbgArb.format(714, Integer.toString(n));
                if (object instanceof DebugHeapAncestorInsideHeap) {
                    DebugHeapAncestorInsideHeap debugHeapAncestorInsideHeap = (DebugHeapAncestorInsideHeap)object;
                    this.data = debugHeapAncestorInsideHeap.getDataInfo();
                    this.declaredClassInfo = null;
                    this.actualClassInfo = this.data.getClassInfo();
                    long l = debugHeapAncestorInsideHeap.getAddress();
                    this.displayName = this.actualClassInfo.isArray() ? DbgArb.format(703, "@" + Long.toHexString(l).toUpperCase()) : DbgArb.format(702, "@" + Long.toHexString(l).toUpperCase());
                } else if (object instanceof DebugHeapAncestorInPinTable) {
                    DebugHeapAncestorInPinTable debugHeapAncestorInPinTable = (DebugHeapAncestorInPinTable)object;
                    DebugDataCompositeInfo debugDataCompositeInfo = debugHeapAncestorInPinTable.getDataInfo();
                    DebugClassInfo debugClassInfo = debugDataCompositeInfo.getClassInfo();
                    long l = debugHeapAncestorInPinTable.getPinnedAddress();
                    this.displayName = debugClassInfo.isArray() ? DbgArb.format(704, "@" + Long.toHexString(l).toUpperCase()) : DbgArb.format(705, "@" + Long.toHexString(l).toUpperCase());
                    this.displayType = DataPanel.makeType(debugDataCompositeInfo, debugClassInfo, DataPanel.ra$dataPanelSettings(DataPanel.this).isShowPackages(), null);
                } else if (object instanceof DebugHeapAncestorInRegister) {
                    DebugHeapAncestorInRegister debugHeapAncestorInRegister = (DebugHeapAncestorInRegister)object;
                    DebugRegisterInfo debugRegisterInfo = debugHeapAncestorInRegister.getRegister();
                    DebugThreadInfo debugThreadInfo = debugHeapAncestorInRegister.getThread();
                    this.displayName = DbgArb.format(706, debugRegisterInfo.getName());
                    this.displayType = DbgArb.format(707, debugThreadInfo.getName());
                } else if (object instanceof DebugHeapAncestorInStack) {
                    DebugHeapAncestorInStack debugHeapAncestorInStack = (DebugHeapAncestorInStack)object;
                    if (debugHeapAncestorInStack.getVariableInfo() != null) {
                        DebugMethodInfo debugMethodInfo = debugHeapAncestorInStack.getStackFrame().getLocation().getMethod();
                        this.displayName = DbgArb.getString(708);
                        this.displayType = DbgArb.format(709, DebugShared.makeCourtesyMethodName(debugMethodInfo, true, false, null));
                    } else {
                        DebugThreadInfo debugThreadInfo = debugHeapAncestorInStack.getThread();
                        this.displayName = DbgArb.getString(710);
                        this.displayType = DbgArb.format(711, debugThreadInfo.getName());
                    }
                } else if (object instanceof DebugHeapAncestorInStatic) {
                    DebugHeapAncestorInStatic debugHeapAncestorInStatic = (DebugHeapAncestorInStatic)object;
                    DebugClassInfo debugClassInfo = debugHeapAncestorInStatic.getClassInfo();
                    this.displayName = DbgArb.getString(712);
                    this.displayType = DbgArb.format(713, DebugShared.makeCourtesyClassName(debugClassInfo, true));
                }
            } else if (object == null) {
                // empty if block
            }
            if (this.getIcon() == null) {
                if (this.data == null && object instanceof DebugVariableInfo) {
                    if (this.declaredClassInfo != null) {
                        if (this.declaredClassInfo.isPrimitive()) {
                            this.setIcon(DataPanel.maS$getPrimitiveIconGray());
                        } else if (this.declaredClassInfo.isArray()) {
                            this.setIcon(DataPanel.maS$getArrayIconGray());
                        } else {
                            this.setIcon(DataPanel.maS$getObjectIconGray());
                        }
                    } else {
                        this.setIcon(DataPanel.maS$getObjectIconGray());
                    }
                } else if (this.actualClassInfo != null && !(object instanceof DebugHeapAncestor)) {
                    if (this.actualClassInfo.isPrimitive()) {
                        this.setIcon(DataPanel.maS$getPrimitiveIcon());
                    } else if (this.actualClassInfo.isArray()) {
                        this.setIcon(DataPanel.maS$getArrayIcon());
                    } else {
                        this.setIcon(DataPanel.maS$getObjectIcon());
                    }
                }
            }
            if (this.data instanceof DebugDataArrayInfo) {
                this.arrayRange = DataPanel.mav$getArrayRange(DataPanel.this, (DebugDataArrayInfo)this.data);
            }
        }

        void clearDataForItem() {
            this.info = null;
            this.data = null;
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.ancestorHeapInfo = null;
            this.arrayRange = null;
        }

        void clearCacheForColumn(int n) {
            switch (n) {
                case -1: {
                    this.cachedMayHaveChildren = null;
                    this.cachedDisplayName = null;
                    this.cachedActualType = null;
                    this.cachedDeclaredType = null;
                    this.cachedValue = null;
                    this.cachedHexValue = null;
                    this.cachedAddress = null;
                    this.cachedID = null;
                    break;
                }
                case 0: {
                    this.cachedMayHaveChildren = null;
                    this.cachedDisplayName = null;
                    break;
                }
                case 2: {
                    this.cachedActualType = null;
                    break;
                }
                case 3: {
                    this.cachedDeclaredType = null;
                    break;
                }
                case 1: {
                    this.cachedValue = null;
                    break;
                }
                case 4: {
                    this.cachedHexValue = null;
                    break;
                }
                case 5: {
                    this.cachedAddress = null;
                    break;
                }
                case 6: {
                    this.cachedID = null;
                }
            }
        }

        public Object getInfo() {
            return this.info;
        }

        public DebugDataInfo getDataInfo() {
            return this.data;
        }

        protected Font getFont(int n) {
            if (n == 0) {
                if (DataPanel.this.ancestorDepthZeroFont != null && this.ancestorDepth == 0 && !this.isDebugHeapAncestor) {
                    return DataPanel.this.ancestorDepthZeroFont;
                }
                if (DataPanel.this.heapAncestorOutsideHeapFont != null && this.isDebugHeapAncestorOutsideHeap) {
                    return DataPanel.this.heapAncestorOutsideHeapFont;
                }
            }
            return DataPanel.this.getNormalFont();
        }

        private boolean isUnrelated() {
            return this.ancestorHeapInfo != null && this.ancestorDepth == -1;
        }

        String getToolTip(int n, TreePath treePath) {
            String string = null;
            switch (n) {
                default: {
                    string = (String)this.getValueOfColumn(n);
                    break;
                }
                case 0: {
                    string = this.makeNameToolTip(treePath);
                    if (string != null && string.length() != 0) break;
                    string = this.displayName;
                    break;
                }
                case 1: {
                    string = (String)this.getValueOfColumn(n);
                    String string2 = this.getValueExpressionUsed();
                    if (string2 == null) break;
                    string = DbgArb.format(834, string2, string);
                    break;
                }
                case 2: {
                    if (this.displayType != null) {
                        string = this.displayType;
                        break;
                    }
                    if (this.actualClassInfo == null) break;
                    string = DataPanel.makeType(this.data, this.actualClassInfo, true, null);
                    break;
                }
                case 3: {
                    if (this.declaredClassInfo == null) break;
                    string = DataPanel.makeType(null, this.declaredClassInfo, true, this.info);
                }
            }
            if (string != null && string.length() > 0) {
                return string;
            }
            return null;
        }

        public String getShortLabel() {
            return this.getDisplayName();
        }

        public Object getData() {
            return this;
        }

        public boolean mayHaveChildren() {
            if (this.cachedMayHaveChildren == null && DataPanel.this.treeTable.isEnabled()) {
                this.cachedMayHaveChildren = this.ancestorDepth == 0 && !(this.info instanceof DebugHeapAncestor) && DataPanel.ra$dataPanelSettings(DataPanel.this).isHideUnrelated() ? Boolean.FALSE : (this.data instanceof DebugDataCompositeInfo ? (((DebugDataCompositeInfo)this.data).isNull() ? Boolean.FALSE : (Product.isRaptor() && this.actualClassInfo != null && this.actualClassInfo.getName().startsWith("$Oracle.Builtin.") ? Boolean.FALSE : Boolean.TRUE)) : (this.info instanceof DebugClassInfo ? Boolean.TRUE : (this.info instanceof DebugHeapSubset ? Boolean.FALSE : (this.info instanceof DebugHeapInfo ? Boolean.TRUE : (this.info instanceof DebugHeapAncestor ? Boolean.TRUE : Boolean.FALSE)))));
            }
            if (this.cachedMayHaveChildren != null) {
                return this.cachedMayHaveChildren;
            }
            return false;
        }

        public Iterator getChildren() {
            return Arrays.asList(this.getChildNodes()).iterator();
        }

        public DataFlavor[] getTransferDataFlavors() {
            return DataPanel.ra$transferFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            int n = DataPanel.ra$transferFlavors().length;
            int n2 = 0;
            while (n2 < n) {
                if (dataFlavor.equals(DataPanel.ra$transferFlavors()[n2])) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.equals(DataPanel.getExpressionFlavor())) {
                Expression expression = this.makeExpression(null);
                if (expression != null) {
                    return expression;
                }
            } else if (dataFlavor.equals(DataPanel.getHeapObjectFlavor()) && this.getAddressOfObject() != 0L) {
                return this.data;
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.getShortLabel();
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        protected Object getValueOfColumn(int n) {
            switch (n) {
                case 0: {
                    return this.getDisplayName();
                }
                case 2: {
                    return this.getActualType();
                }
                case 3: {
                    return this.getDeclaredType();
                }
                case 1: {
                    return this.getValue();
                }
                case 4: {
                    return this.getHexValue();
                }
                case 5: {
                    return this.getAddress();
                }
                case 6: {
                    return this.getID();
                }
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getExpressionPart() {
            return this.expressionPart;
        }

        String getDisplayName() {
            if (this.cachedDisplayName == null && DataPanel.this.treeTable.isEnabled()) {
                this.cachedDisplayName = this.displayName != null ? this.displayName : DataPanel.makeDisplayName(this.info, DataPanel.ra$dataPanelSettings(DataPanel.this).isShowPackages());
            }
            if (this.cachedDisplayName != null) {
                return this.cachedDisplayName;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getActualType() {
            if (this.cachedActualType == null && DataPanel.this.treeTable.isEnabled()) {
                this.cachedActualType = this.displayType != null ? this.displayType : DataPanel.makeType(this.data, this.actualClassInfo, DataPanel.ra$dataPanelSettings(DataPanel.this).isShowPackages(), null);
            }
            if (this.cachedActualType != null) {
                return this.cachedActualType;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getDeclaredType() {
            if (this.cachedDeclaredType == null && DataPanel.this.treeTable.isEnabled()) {
                this.cachedDeclaredType = DataPanel.makeType(null, this.declaredClassInfo, DataPanel.ra$dataPanelSettings(DataPanel.this).isShowPackages(), this.info);
            }
            if (this.cachedDeclaredType != null) {
                return this.cachedDeclaredType;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getValue() {
            if (this.cachedValue == null && DataPanel.this.treeTable.isEnabled()) {
                this.cachedValueExpressionUsed = null;
                if (this.displayValue != null) {
                    this.cachedValue = this.displayValue;
                } else {
                    String[] stringArray = new String[1];
                    this.cachedValue = DataPanel.makeDataValue(this.info, this.data, stringArray);
                    if (stringArray[0] != null) {
                        this.cachedValueExpressionUsed = stringArray[0];
                    }
                }
            }
            if (this.cachedValue != null) {
                return this.cachedValue;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getValueExpressionUsed() {
            return this.cachedValueExpressionUsed;
        }

        String getHexValue() {
            if (this.cachedHexValue == null && DataPanel.this.treeTable.isEnabled()) {
                this.cachedHexValue = DataPanel.makeHexValue(this.info, this.data);
            }
            if (this.cachedHexValue != null) {
                return this.cachedHexValue;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getAddress() {
            if (this.cachedAddress == null && DataPanel.this.treeTable.isEnabled()) {
                this.cachedAddress = DataPanel.NOT_AVAILABLE;
                long l = this.getAddressOfObject();
                if (l != 0L) {
                    this.cachedAddress = "0x" + Long.toHexString(l).toUpperCase();
                }
            }
            if (this.cachedAddress != null) {
                return this.cachedAddress;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getID() {
            if (this.cachedID == null && DataPanel.this.treeTable.isEnabled()) {
                long l;
                this.cachedID = DataPanel.NOT_AVAILABLE;
                if (this.data instanceof DebugDataCompositeInfo && (l = ((DebugDataCompositeInfo)this.data).getUniqueID()) != 0L) {
                    this.cachedID = Long.toString(l);
                }
            }
            if (this.cachedID != null) {
                return this.cachedID;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        public Iterator getLazyChildren() {
            if (this.children != null) {
                return Arrays.asList(this.children).iterator();
            }
            return Arrays.asList(new Object[0]).iterator();
        }

        int countChildNodes() {
            return this.getChildNodes().length;
        }

        DataItem[] getChildNodes() {
            if (this.children == null) {
                if (this.parentDataItem != null && !this.parentDataItem.isExpanded) {
                    return new DataItem[0];
                }
                if (this.data instanceof DebugDataObjectInfo) {
                    this.children = DataPanel.mav$makeDataItemsForObject(DataPanel.this, this, (DebugDataObjectInfo)this.data);
                } else if (this.data instanceof DebugDataArrayInfo) {
                    this.children = DataPanel.mav$makeDataItemsForArray(DataPanel.this, this, (DebugDataArrayInfo)this.data, this.arrayRange);
                } else if (this.info instanceof DebugClassInfo) {
                    this.children = DataPanel.mav$makeDataItemsForClass(DataPanel.this, this, (DebugClassInfo)this.info);
                } else if (this.info instanceof DebugHeapSubset) {
                    this.children = new DataItem[0];
                } else if (this.info instanceof DebugHeapInfo) {
                    this.children = DataPanel.mav$makeDataItemsForHeapInfo(DataPanel.this, this, (DebugHeapInfo)this.info);
                } else if (this.info instanceof DebugHeapAncestor) {
                    this.children = DataPanel.mav$makeDataItemsForHeapAncestor(DataPanel.this, this, (DebugHeapAncestor)this.info);
                }
                if (this.children == null) {
                    this.children = new DataItem[0];
                }
                int n = 0;
                while (n < this.children.length) {
                    this.children[n].parentDataItem = this;
                    ++n;
                }
            }
            return this.children;
        }

        void clearChildren(TreePath treePath) {
            DataTreeTableModel.mav$saveHighlight(DataPanel.this.model);
            this.children = null;
            DataPanel.this.model.fireChanged(treePath);
            DataTreeTableModel.mav$restoreHighlight(DataPanel.this.model, false);
        }

        boolean canViewWhole() {
            return this.data instanceof DebugDataCompositeInfo && ((DebugDataCompositeInfo)this.data).canGetWholeThing();
        }

        void viewWhole() {
            if (this.data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)this.data;
                String string = DbgArb.getString(349);
                MemoViewDialog.showMemoViewDialog(string, this.getActualType(), this.getDisplayName(), debugDataCompositeInfo);
            }
        }

        boolean canAdjustRange() {
            return this.ancestorHeapInfo == null && this.data instanceof DebugDataArrayInfo;
        }

        void adjustRange(TreePath treePath) {
            DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)this.data;
            int n = debugDataArrayInfo.getArrayStart();
            int n2 = debugDataArrayInfo.getArrayCount();
            AdjustRangeDialog adjustRangeDialog = AdjustRangeDialog.showAdjustRangeDialog(this.getActualType(), this.getDisplayName(), n, n2, this.arrayRange.getStart(), this.arrayRange.getCount());
            if (adjustRangeDialog != null) {
                this.arrayRange.setStart(adjustRangeDialog.getStart());
                this.arrayRange.setCount(adjustRangeDialog.getCount());
                DataPanel.ra$arrayRanges(DataPanel.this).put(debugDataArrayInfo, this.arrayRange);
                this.clearChildren(treePath);
            }
        }

        boolean canToggleValue() {
            return this.data != null && this.actualClassInfo.isPrimitive() && this.actualClassInfo.getName().equals("boolean") && this.data.canModifyDataWithString();
        }

        void toggleValue() {
            String string = this.getValue();
            String string2 = new Boolean(Boolean.valueOf(string) ^ true).toString();
            if (ModifyValueDialog.toggleValue(this.data, string2)) {
                JDebugger.getInstance().dataHasBeenModified();
            }
        }

        boolean canModifyValue() {
            if (!this.canToggleValue() && this.data != null) {
                boolean bl = this.data.canModifyDataWithString();
                boolean bl2 = false;
                boolean bl3 = false;
                if (this.data instanceof DebugDataCompositeInfo) {
                    DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)this.data;
                    bl2 = debugDataCompositeInfo.canSetAddressOfObject();
                    bl3 = debugDataCompositeInfo.canSetAddressOfObjectToNull();
                }
                if (bl || bl2 || bl3) {
                    return true;
                }
            }
            return false;
        }

        void modifyValue() {
            if (this.data != null) {
                boolean bl = this.data.canModifyDataWithString();
                boolean bl2 = false;
                boolean bl3 = false;
                if (this.data instanceof DebugDataCompositeInfo) {
                    DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)this.data;
                    bl2 = debugDataCompositeInfo.canSetAddressOfObject();
                    bl3 = debugDataCompositeInfo.canSetAddressOfObjectToNull();
                }
                if (bl || bl2 || bl3) {
                    boolean bl4;
                    String string;
                    String string2 = this.getValue();
                    if (string2.startsWith("\"") && string2.endsWith("\"")) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    if (DataPanel.ra$columnShowing(DataPanel.this)[4] && (string = this.getHexValue()) != null && string.length() > 0) {
                        string2 = string2 + "    " + string;
                    }
                    String string3 = null;
                    if (DataPanel.this.vm != null && DataPanel.this.vm.getCapabilities().canGetAddresses()) {
                        string3 = this.getAddress();
                    }
                    if (bl4 = ModifyValueDialog.showModifyValueDialog(this.getDeclaredType(), this.getDisplayName(), string2, string3, this.actualClassInfo, this.data, bl, bl2, bl3)) {
                        JDebugger.getInstance().dataHasBeenModified();
                    }
                }
            }
        }

        DataFlavor[] canDrag(TreePath treePath) {
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
            if (this.canWatchAndInspect(treePath)) {
                arrayList.add(DataPanel.getExpressionFlavor());
            }
            if (this.getAddressOfObject() != 0L) {
                arrayList.add(DataPanel.getHeapObjectFlavor());
            }
            if (arrayList.size() > 0) {
                arrayList.add(DataFlavor.stringFlavor);
                return arrayList.toArray(new DataFlavor[arrayList.size()]);
            }
            return null;
        }

        boolean canWatchAndInspect(TreePath treePath) {
            if (this.data == null && this.info instanceof DebugVariableInfo) {
                return false;
            }
            return this.makeExpression(treePath) != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String makeNameToolTip(TreePath treePath) {
            if (treePath == null) return null;
            String string = DataPanel.NOT_AVAILABLE;
            Object[] objectArray = treePath.getPath();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof DataItem) {
                    DataItem dataItem = (DataItem)object;
                    Object object2 = dataItem.getInfo();
                    if (object2 instanceof DebugVariableInfo || object2 instanceof DebugStackSlotInfo) {
                        string = string + dataItem.getExpressionPart();
                    } else if (object2 instanceof DebugClassInfo) {
                        string = string + DebugShared.makeCourtesyClassName((DebugClassInfo)object2, true);
                    } else if (object2 instanceof DebugArrayElementInfo) {
                        string = this.displayNameOverridden ? string + dataItem.getDisplayName() : string + dataItem.getExpressionPart();
                    } else if (object2 instanceof DebugFieldInfo) {
                        if (string.length() > 0) {
                            string = string + ".";
                        }
                        string = this.displayNameOverridden ? string + dataItem.getDisplayName() : string + dataItem.getExpressionPart();
                    } else if (object2 instanceof DebugDataInfo) {
                        String string2 = dataItem.getExpressionPart();
                        if (string2 == null) return null;
                        string = string + string2;
                    } else {
                        if (!(object2 instanceof EvaluationInfo)) return null;
                        if (n == 2 && n2 == 1) {
                            string = dataItem.getExpressionPart();
                        }
                    }
                }
                ++n2;
            }
            if (string == null || string.length() <= 0) return null;
            return string;
        }

        private Expression makeExpression(TreePath treePath) {
            if (this.expressionSaved == null && treePath != null) {
                Expression expression = new Expression(DataPanel.NOT_AVAILABLE);
                Object[] objectArray = treePath.getPath();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataItem dataItem;
                    Object object = objectArray[n2];
                    if (object instanceof DataItem && !(dataItem = (DataItem)object).prepareExpression(objectArray, n2, expression)) {
                        return null;
                    }
                    ++n2;
                }
                if (expression != null && expression.getExpression().length() > 0) {
                    this.expressionSaved = expression;
                }
            }
            return this.expressionSaved;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean prepareExpression(Object[] objectArray, int n, Expression expression) {
            String string = expression.getExpression();
            String string2 = expression.getName();
            String string3 = null;
            String string4 = null;
            if (this.info instanceof DebugVariableInfo || this.info instanceof DebugStackSlotInfo || this.info instanceof DebugArrayElementInfo) {
                string3 = this.getExpressionPart();
            } else if (this.info instanceof DebugClassInfo) {
                string3 = this.getExpressionPart();
                string4 = DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, true);
            } else if (this.info instanceof DebugDataInfo) {
                String string5 = this.getExpressionPart();
                if (string5 == null) return false;
                string3 = string5;
            } else if (this.info instanceof DebugFieldInfo) {
                string3 = string.length() > 0 ? "." + this.getExpressionPart() : this.getExpressionPart();
            } else {
                if (!(this.info instanceof EvaluationInfo) && !(this.info instanceof EvaluatorItem)) return false;
                if (objectArray.length == 2 && n == 1) {
                    string3 = this.getExpressionPart();
                }
            }
            if (string3 == null) return true;
            expression.setExpression(string + string3);
            if (string2 != null) {
                if (string4 != null) {
                    expression.setName(string2 + string4);
                    return true;
                } else {
                    expression.setName(string2 + string3);
                }
                return true;
            } else {
                if (string4 == null) return true;
                expression.setName(string4);
            }
            return true;
        }

        void watch(TreePath treePath) {
            Expression expression = this.makeExpression(treePath);
            if (expression != null) {
                EvaluatorItem evaluatorItem = new EvaluatorItem(expression);
                JDebugger.getInstance().addWatch(evaluatorItem);
            }
        }

        void inspect(TreePath treePath) {
            Expression expression = this.makeExpression(treePath);
            if (expression != null) {
                EvaluatorItem evaluatorItem = new EvaluatorItem(expression);
                JDebugger.getInstance().inspect(evaluatorItem);
            }
        }

        boolean canWatchInspectClassLoader() {
            DebugDataObjectInfo debugDataObjectInfo;
            DebugClassLoaderInfo debugClassLoaderInfo;
            return this.actualClassInfo != null && (debugClassLoaderInfo = this.actualClassInfo.getClassLoader()) != null && (debugDataObjectInfo = debugClassLoaderInfo.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull();
        }

        void watchClassLoader() {
            DebugDataObjectInfo debugDataObjectInfo;
            DebugClassLoaderInfo debugClassLoaderInfo;
            if (this.actualClassInfo != null && (debugClassLoaderInfo = this.actualClassInfo.getClassLoader()) != null && (debugDataObjectInfo = debugClassLoaderInfo.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull()) {
                String string = ClassesWindow.makeClassLoaderName(debugClassLoaderInfo);
                EvaluatorItem evaluatorItem = DataPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                JDebugger.getInstance().addWatch(evaluatorItem);
            }
        }

        void inspectClassLoader() {
            DebugDataObjectInfo debugDataObjectInfo;
            DebugClassLoaderInfo debugClassLoaderInfo;
            if (this.actualClassInfo != null && (debugClassLoaderInfo = this.actualClassInfo.getClassLoader()) != null && (debugDataObjectInfo = debugClassLoaderInfo.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull()) {
                String string = ClassesWindow.makeClassLoaderName(debugClassLoaderInfo);
                EvaluatorItem evaluatorItem = DataPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                JDebugger.getInstance().inspect(evaluatorItem);
            }
        }

        String canShowSource(int n) {
            String string;
            DebugClassInfo debugClassInfo = null;
            String string2 = null;
            if (n == DataPanel.this._GOTO_CMD_ID) {
                if (this.actualClassInfo != null) {
                    debugClassInfo = this.actualClassInfo;
                    string2 = DbgArb.format(330, this.getActualType());
                }
            } else if (n == DataPanel.this._GOTO_DECLARED_CMD_ID) {
                if (DataPanel.ra$columnShowing(DataPanel.this)[3] && this.declaredClassInfo != null && this.declaredClassInfo != this.actualClassInfo) {
                    debugClassInfo = this.declaredClassInfo;
                    string2 = DbgArb.format(333, this.getDeclaredType());
                }
            } else if (n == DataPanel.this._GOTO_FIELD_CMD_ID) {
                DebugFieldInfo debugFieldInfo = null;
                if (this.info instanceof DebugFieldInfo) {
                    debugFieldInfo = (DebugFieldInfo)this.info;
                } else if (this.info instanceof DebugHeapAncestorInStatic) {
                    debugFieldInfo = ((DebugHeapAncestorInStatic)this.info).getFieldInfo();
                }
                if (debugFieldInfo != null) {
                    debugClassInfo = debugFieldInfo.getDeclaringClassInfo();
                    String string3 = DataPanel.makeType(null, debugClassInfo, DataPanel.ra$dataPanelSettings(DataPanel.this).isShowPackages(), null);
                    string2 = DbgArb.format(336, string3 + "." + debugFieldInfo.getName());
                }
            }
            if (debugClassInfo != null && (string = debugClassInfo.getPrimarySourceFilename()) != null && string.length() > 0) {
                return string2;
            }
            return null;
        }

        void showSource(int n) {
            if (n == DataPanel.this._GOTO_CMD_ID || n == DataPanel.this._GOTO_DECLARED_CMD_ID) {
                DebugClassInfo debugClassInfo = null;
                if (n == DataPanel.this._GOTO_CMD_ID) {
                    debugClassInfo = this.actualClassInfo;
                } else if (n == DataPanel.this._GOTO_DECLARED_CMD_ID) {
                    debugClassInfo = this.declaredClassInfo;
                }
                if (debugClassInfo != null) {
                    DataPanel.this.debuggingProcess.showSourceFile(debugClassInfo);
                }
            } else if (n == DataPanel.this._GOTO_FIELD_CMD_ID) {
                DebugFieldInfo debugFieldInfo = null;
                if (this.info instanceof DebugFieldInfo) {
                    debugFieldInfo = (DebugFieldInfo)this.info;
                } else if (this.info instanceof DebugHeapAncestorInStatic) {
                    debugFieldInfo = ((DebugHeapAncestorInStatic)this.info).getFieldInfo();
                }
                if (debugFieldInfo != null) {
                    DataPanel.this.debuggingProcess.showSourceFile(debugFieldInfo);
                }
            }
        }

        long getAddressOfObject() {
            if (this.data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)this.data;
                return debugDataCompositeInfo.getAddressOfObject();
            }
            return 0L;
        }

        static DebugClassInfo ra$actualClassInfo(DataItem dataItem) {
            return dataItem.actualClassInfo;
        }

        static boolean mav$isUnrelated(DataItem dataItem) {
            return dataItem.isUnrelated();
        }

        static void wa$isExpanded(DataItem dataItem, boolean bl) {
            dataItem.isExpanded = bl;
        }
    }

    private final class DataInfoPath {
        private DebuggingProcess debuggingProcess;
        private List list;

        DataInfoPath(DebuggingProcess debuggingProcess, Object[] objectArray) {
            this.debuggingProcess = debuggingProcess;
            this.list = Arrays.asList(objectArray);
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int size() {
            return this.list.size();
        }

        Object getDataInfo(int n) {
            return this.list.get(n);
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.list.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof DataInfoPath) {
                DataInfoPath dataInfoPath = (DataInfoPath)object;
                return this.debuggingProcess == dataInfoPath.debuggingProcess && this.list.equals(dataInfoPath.list);
            }
            return false;
        }
    }

    private final class DataArrayRange {
        private DebuggingProcess debuggingProcess;
        private int start;
        private int count;

        DataArrayRange(DebuggingProcess debuggingProcess, DebugDataArrayInfo debugDataArrayInfo) {
            this.debuggingProcess = debuggingProcess;
            this.start = debugDataArrayInfo.getArrayStart();
            this.count = debugDataArrayInfo.getArrayCount();
            int n = DataPanel.maS$getDefaultArrayRangeMax();
            if (this.count == -1 || this.count > n) {
                this.count = n;
            }
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int getStart() {
            return this.start;
        }

        void setStart(int n) {
            this.start = n;
        }

        int getCount() {
            return this.count;
        }

        void setCount(int n) {
            this.count = n;
        }
    }
}

