/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

final class DataPanelSettingsPanel {
    private JCheckBox showColumnNameCheckBox;
    private JCheckBox showColumnValueCheckBox;
    private JCheckBox showColumnActualTypeCheckBox;
    private JCheckBox showColumnDeclaredTypeCheckBox;
    private JCheckBox showColumnHexValueCheckBox;
    private JCheckBox showColumnAddressCheckBox;
    private JCheckBox showColumnIDCheckBox;
    private JCheckBox sortFieldsByNameCheckBox;
    private JCheckBox showPackagesCheckBox;
    private JCheckBox hideStaticFieldsCheckBox;
    private JCheckBox hideFinalFieldsCheckBox;
    private JCheckBox hideNullArrayElementsCheckBox;

    void $init$() {
        this.showColumnNameCheckBox = new JCheckBox();
        this.showColumnValueCheckBox = new JCheckBox();
        this.showColumnActualTypeCheckBox = new JCheckBox();
        this.showColumnDeclaredTypeCheckBox = new JCheckBox();
        this.showColumnHexValueCheckBox = new JCheckBox();
        this.showColumnAddressCheckBox = new JCheckBox();
        this.showColumnIDCheckBox = new JCheckBox();
        this.sortFieldsByNameCheckBox = new JCheckBox();
        this.showPackagesCheckBox = new JCheckBox();
        this.hideStaticFieldsCheckBox = new JCheckBox();
        this.hideFinalFieldsCheckBox = new JCheckBox();
        this.hideNullArrayElementsCheckBox = new JCheckBox();
    }

    public DataPanelSettingsPanel() {
        this.$init$();
        ResourceUtils.resButton((AbstractButton)this.showColumnNameCheckBox, (String)DbgArb.getString(763));
        ResourceUtils.resButton((AbstractButton)this.showColumnValueCheckBox, (String)DbgArb.getString(766));
        ResourceUtils.resButton((AbstractButton)this.showColumnActualTypeCheckBox, (String)DbgArb.getString(764));
        ResourceUtils.resButton((AbstractButton)this.showColumnDeclaredTypeCheckBox, (String)DbgArb.getString(765));
        ResourceUtils.resButton((AbstractButton)this.showColumnHexValueCheckBox, (String)DbgArb.getString(767));
        ResourceUtils.resButton((AbstractButton)this.showColumnAddressCheckBox, (String)DbgArb.getString(768));
        ResourceUtils.resButton((AbstractButton)this.showColumnIDCheckBox, (String)DbgArb.getString(769));
        ResourceUtils.resButton((AbstractButton)this.sortFieldsByNameCheckBox, (String)DbgArb.getString(773));
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(779));
        ResourceUtils.resButton((AbstractButton)this.hideStaticFieldsCheckBox, (String)DbgArb.getString(775));
        ResourceUtils.resButton((AbstractButton)this.hideFinalFieldsCheckBox, (String)DbgArb.getString(776));
        ResourceUtils.resButton((AbstractButton)this.hideNullArrayElementsCheckBox, (String)DbgArb.getString(777));
    }

    JPanel makeChooseColumnsPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RunMgrArb.getString(94));
        jPanel.setBorder(titledBorder);
        if (insets != null) {
            Insets insets2 = titledBorder.getBorderInsets(jPanel);
            insets.top = insets2.top;
            insets.left = insets2.left;
            insets.bottom = insets2.bottom;
            insets.right = insets2.right;
        }
        jPanel.add(this.showColumnNameCheckBox);
        jPanel.add(new JLabel());
        jPanel.add(this.showColumnValueCheckBox);
        jPanel.add(this.showColumnHexValueCheckBox);
        jPanel.add(this.showColumnActualTypeCheckBox);
        jPanel.add(this.showColumnDeclaredTypeCheckBox);
        jPanel.add(this.showColumnAddressCheckBox);
        jPanel.add(this.showColumnIDCheckBox);
        return jPanel;
    }

    JPanel makeSortPanel(JCheckBox jCheckBox) {
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(770)));
        jPanel.add(this.sortFieldsByNameCheckBox);
        if (jCheckBox != null) {
            jPanel.add(jCheckBox);
        }
        return jPanel;
    }

    JPanel makeShowPanel(JCheckBox jCheckBox) {
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(771)));
        jPanel.add(this.showPackagesCheckBox);
        if (jCheckBox != null) {
            jPanel.add(jCheckBox);
        }
        return jPanel;
    }

    JPanel makeHidePanel(JCheckBox jCheckBox) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(772)));
        int n = 0;
        this.hideStaticFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        jPanel.add((Component)this.hideStaticFieldsCheckBox, new GridBagConstraints(0, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideFinalFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        jPanel.add((Component)this.hideFinalFieldsCheckBox, new GridBagConstraints(1, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideNullArrayElementsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        jPanel.add((Component)this.hideNullArrayElementsCheckBox, new GridBagConstraints(0, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (jCheckBox != null) {
            jCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
            jPanel.add((Component)jCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return jPanel;
    }

    void onEntry(DataPanelSettings dataPanelSettings) {
        boolean[] blArray = dataPanelSettings.getColumnVisible();
        this.showColumnNameCheckBox.setSelected(true);
        this.showColumnNameCheckBox.setEnabled(false);
        this.showColumnValueCheckBox.setSelected(blArray[1]);
        this.showColumnActualTypeCheckBox.setSelected(blArray[2]);
        this.showColumnDeclaredTypeCheckBox.setSelected(blArray[3]);
        this.showColumnHexValueCheckBox.setSelected(blArray[4]);
        this.showColumnAddressCheckBox.setSelected(blArray[5]);
        this.showColumnIDCheckBox.setSelected(blArray[6]);
        this.sortFieldsByNameCheckBox.setSelected(dataPanelSettings.isSortFieldsByName());
        this.showPackagesCheckBox.setSelected(dataPanelSettings.isShowPackages());
        this.hideStaticFieldsCheckBox.setSelected(dataPanelSettings.isHideStaticFields());
        this.hideFinalFieldsCheckBox.setSelected(dataPanelSettings.isHideFinalFields());
        this.hideNullArrayElementsCheckBox.setSelected(dataPanelSettings.isHideNullArrayElements());
    }

    void onExit(DataPanelSettings dataPanelSettings) throws TraversalException {
        boolean[] blArray = dataPanelSettings.getColumnVisible();
        blArray[0] = true;
        blArray[1] = this.showColumnValueCheckBox.isSelected();
        blArray[2] = this.showColumnActualTypeCheckBox.isSelected();
        blArray[3] = this.showColumnDeclaredTypeCheckBox.isSelected();
        blArray[4] = this.showColumnHexValueCheckBox.isSelected();
        blArray[5] = this.showColumnAddressCheckBox.isSelected();
        blArray[6] = this.showColumnIDCheckBox.isSelected();
        dataPanelSettings.setSortFieldsByName(this.sortFieldsByNameCheckBox.isSelected());
        dataPanelSettings.setShowPackages(this.showPackagesCheckBox.isSelected());
        dataPanelSettings.setHideStaticFields(this.hideStaticFieldsCheckBox.isSelected());
        dataPanelSettings.setHideFinalFields(this.hideFinalFieldsCheckBox.isSelected());
        dataPanelSettings.setHideNullArrayElements(this.hideNullArrayElementsCheckBox.isSelected());
    }
}

