/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.exception.SingletonClassException;
import oracle.jdeveloper.JDeveloperMenuConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataViewer
implements ContextMenuListener,
Controller,
Addin {
    private static DataViewer instance;
    private static final int VIEW_DIAGRAM_CMD_ID;
    private static IdeAction actionViewDiagram;
    private static JMenuItem menuitemViewDiagram;

    static {
        VIEW_DIAGRAM_CMD_ID = Ide.findOrCreateCmdID((String)"DebuggerViewDiagram");
    }

    public DataViewer() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.debug.DataViewer");
        }
        instance = this;
    }

    public void initialize() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_DIAGRAM_CMD_ID) {
            if (ideAction.isEnabled()) {
                DataViewer.showViewer(DataViewer.getObjectReference(context));
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_DIAGRAM_CMD_ID) {
            ideAction.setEnabled(DataViewer.isObjectReference(context));
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        this.update(actionViewDiagram, context);
        if (actionViewDiagram.isEnabled()) {
            if (menuitemViewDiagram == null) {
                menuitemViewDiagram = contextMenu.createMenuItem((ToggleAction)actionViewDiagram);
            }
            contextMenu.add((Component)menuitemViewDiagram, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static boolean isObjectReference(Context context) {
        try {
            Object object;
            if (context != null && (object = context.getProperty("com.sun.jdi.Value")) instanceof ObjectReference) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static ObjectReference getObjectReference(Context context) {
        try {
            if (DataViewer.isObjectReference(context)) {
                ObjectReference objectReference;
                ObjectReference objectReference2 = objectReference = (ObjectReference)context.getProperty("com.sun.jdi.Value");
                return objectReference2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static void showViewer(ObjectReference objectReference) {
    }

    private static String getValueText(Value value) {
        Field field;
        ObjectReference objectReference;
        ReferenceType referenceType;
        String string;
        if (value instanceof StringReference || value instanceof PrimitiveValue) {
            return value.toString();
        }
        if (value instanceof ObjectReference && (string = (referenceType = (objectReference = (ObjectReference)value).referenceType()).name()).startsWith("java.lang.") && (string.equals("java.lang.Boolean") || string.equals("java.lang.Byte") || string.equals("java.lang.Character") || string.equals("java.lang.Short") || string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.lang.Float") || string.equals("java.lang.Double")) && (field = referenceType.fieldByName("value")) != null) {
            Value value2 = objectReference.getValue(field);
            return DataViewer.getValueText(value2);
        }
        return null;
    }

    private static List<Field> removeStaticFields(List<Field> list) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : list) {
            if (!field.isStatic()) continue;
            arrayList.add(field);
        }
        for (Field field : arrayList) {
            list.remove(field);
        }
        return list;
    }
}

