/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.dnd.DropTargetListener;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

abstract class DataWindow
extends DockableWindow {
    protected String title;
    protected String helpId;
    protected DataPanel dataPanel;
    private Component gui;

    DataWindow(String string, String string2, String string3) {
        super(string);
        this.title = string2;
        this.helpId = string3;
    }

    protected void setDataPanel(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
    }

    void shutDown() {
        this.saveSettings();
    }

    void saveSettings() {
        this.dataPanel.saveSettings();
    }

    private void debugWindowSettingsChanged(DebugWindowSettings debugWindowSettings) {
        this.dataPanel.debugWindowSettingsChanged(debugWindowSettings);
    }

    void setUseFilters(boolean bl) {
        this.dataPanel.setUseFilters(bl);
    }

    public Component getGUI() {
        if (this.gui == null) {
            DebugWindowSettings debugWindowSettings = DebugWindowSettings.getInstance();
            this.gui = this.dataPanel.getGUI();
            this.dataPanel.loadSettings();
            this.debugWindowSettingsChanged(debugWindowSettings);
            this.dataPanel.dataPanelSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            debugWindowSettings.addChangeListener(new 1(this, debugWindowSettings));
        }
        return this.gui;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(this.helpId);
    }

    public Controller getController() {
        return this.dataPanel;
    }

    public Context getContext(EventObject eventObject) {
        return this.dataPanel.getContext(eventObject);
    }

    public int getDefaultVisibility(Layout layout) {
        boolean bl = JDebugger.getInstance().canShowDebuggingWindows(layout);
        int n = bl ? 1 : 0;
        return n;
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    public DropTargetListener getTabDropListener() {
        return this.dataPanel;
    }

    void everythingChanged() {
        this.dataPanel.everythingChanged();
    }

    void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo debugStackFrameInfo) {
        this.dataPanel.updateData(debuggingProcess, debugVirtualMachine, debugThreadInfo, debugStackFrameInfo);
    }

    void clearData() {
        this.dataPanel.clearData();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.dataPanel.processFinished(debuggingProcess);
    }

    static void mav$debugWindowSettingsChanged(DataWindow dataWindow, DebugWindowSettings debugWindowSettings) {
        dataWindow.debugWindowSettingsChanged(debugWindowSettings);
    }

    final class 1
    implements ChangeListener {
        private final /* synthetic */ DebugWindowSettings v$dbgSettings;
        final /* synthetic */ DataWindow this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            DataWindow.mav$debugWindowSettingsChanged(this.this$0, this.v$dbgSettings);
        }

        public 1(DataWindow dataWindow, DebugWindowSettings debugWindowSettings) {
            this.v$dbgSettings = debugWindowSettings;
            this.this$0 = dataWindow;
        }
    }
}

