/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.shared.DebugShared;

public class DebugConfiguration
extends HashStructureAdapter {
    private static final String DATA_KEY = DebugConfiguration.class.getName();
    private RunConfiguration runConfiguration;
    private static final String TRACING_INCLUDE = "tracingInclude";
    private static final String TRACING_EXCLUDE = "tracingExclude";
    private static final String REMOTE_PROTOCOL = "remoteProtocol";
    static final String PROTOCOL_OJVM = "ojvm";
    static final String PROTOCOL_JPDA = "jpda";
    static final String PROTOCOL_JPDA_LISTEN = "jpdaListen";
    static final String PROTOCOL_PROBE = "probe";
    private static final String REMOTE_PARAMETERS = "remoteParameter:";
    private static final String PROMPT_FOR_REMOTE_DEBUGGING = "promptForRemoteDebugging";
    private static final String OJVM_DEBUG_ARGUMENTS = "OJVMDebugArguments";
    private static final String OJVM_DEBUG_ARGUMENTS_DEFAULT = "-XXdebug,quiet,port<port>";
    private static final String JPDA_CLASSIC_DEBUG_ARGUMENTS = "JPDAClassicDebugArguments";
    private static final String JPDA_CLASSIC_DEBUG_ARGUMENTS_DEFAULT = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,address=<port>";
    private static final String JPDA_DEBUG_ARGUMENTS = "JPDADebugArguments";
    private static final String JPDA_DEBUG_ARGUMENTS_DEFAULT = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=<port>";

    private DebugConfiguration(HashStructure hashStructure, RunConfiguration runConfiguration) {
        super(hashStructure);
        this.runConfiguration = runConfiguration;
    }

    static DebugConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof RunConfiguration) {
            return new DebugConfiguration(DebugConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY), (RunConfiguration)propertyStorage);
        }
        RunConfiguration runConfiguration = RunConfiguration.getInstance(propertyStorage);
        return DebugConfiguration.getInstance(runConfiguration);
    }

    RunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    boolean isCustom() {
        if (this.runConfiguration != null) {
            return this.runConfiguration.isCustom();
        }
        return false;
    }

    String getTracingInclude() {
        return this._hash.getString(TRACING_INCLUDE, "");
    }

    void setTracingInclude(String string) {
        if (string == null) {
            string = "";
        }
        this._hash.putString(TRACING_INCLUDE, string);
    }

    List getTracingIncludeList() {
        ArrayList arrayList = new ArrayList();
        IdeUtil.string2List((String)this.getTracingInclude(), arrayList);
        return arrayList;
    }

    void setTracingIncludeList(List list) {
        this.setTracingInclude(IdeUtil.list2String((List)list));
    }

    String getTracingExclude() {
        return this._hash.getString(TRACING_EXCLUDE, DebugConfiguration.getDefaultTracingExclude());
    }

    void setTracingExclude(String string) {
        if (string == null) {
            string = "";
        }
        this._hash.putString(TRACING_EXCLUDE, string);
    }

    List getTracingExcludeList() {
        ArrayList arrayList = new ArrayList();
        IdeUtil.string2List((String)this.getTracingExclude(), arrayList);
        return arrayList;
    }

    void setTracingExcludeList(List list) {
        this.setTracingExclude(IdeUtil.list2String((List)list));
    }

    private static String getDefaultTracingExclude() {
        String[] stringArray = new String[]{"java", "javax", "sun", "sunw", "com.sun", "apple", "com.apple", "com.evermind", "com.oracle", "com.orionserver", "EDU.oswego", "oracle.as", "oracle.core", "oracle.dms", "oracle.hooks", "oracle.ide", "oracle.ias", "oracle.j2ee", "oracle.jdbc", "oracle.jdevimpl", "oracle.jsp", "oracle.oc4j", "oracle.ojc", "oracle.security", "oracle.sql", "oracle.webservices", "oracle.xml", "org.apache", "org.omg", "org.w3c", "org.xml"};
        List<String> list = Arrays.asList(stringArray);
        return IdeUtil.list2String(list);
    }

    static int getDebuggerFactory(String string) {
        if (PROTOCOL_OJVM.equals(string)) {
            return 0;
        }
        if (PROTOCOL_JPDA.equals(string)) {
            return 1;
        }
        if (PROTOCOL_JPDA_LISTEN.equals(string)) {
            return 2;
        }
        if (PROTOCOL_PROBE.equals(string)) {
            return 3;
        }
        return 0;
    }

    String getRemoteProtocol() {
        return this._hash.getString(REMOTE_PROTOCOL, PROTOCOL_OJVM);
    }

    void setRemoteProtocol(String string) {
        if (string == null) {
            string = PROTOCOL_OJVM;
        }
        this._hash.putString(REMOTE_PROTOCOL, string);
    }

    private String getRemoteParameterKey(String string, String string2) {
        return REMOTE_PARAMETERS + string + ":" + string2;
    }

    String getRemoteParameterValue(String string, String string2) {
        int n = DebugConfiguration.getDebuggerFactory(string);
        String string3 = DebugShared.getDefaultConnectArgValue(n, string2);
        return this._hash.getString(this.getRemoteParameterKey(string, string2), string3);
    }

    void putRemoteParameterValue(String string, String string2, String string3) {
        this._hash.putString(this.getRemoteParameterKey(string, string2), string3);
    }

    boolean isPromptForRemoteDebugging() {
        return this._hash.getBoolean(PROMPT_FOR_REMOTE_DEBUGGING, true);
    }

    void setPromptForRemoteDebugging(boolean bl) {
        this._hash.putBoolean(PROMPT_FOR_REMOTE_DEBUGGING, bl);
    }

    String getOJVMDebugArguments() {
        return this._hash.getString(OJVM_DEBUG_ARGUMENTS, OJVM_DEBUG_ARGUMENTS_DEFAULT);
    }

    void setOJVMDebugArguments(String string) {
        if (string == null) {
            string = OJVM_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(OJVM_DEBUG_ARGUMENTS, string);
    }

    String[] getOJVMDebugArguments(String string) {
        return DebugConfiguration.insertPort(this.getOJVMDebugArguments(), string);
    }

    String getJPDAClassicDebugArguments() {
        return this._hash.getString(JPDA_CLASSIC_DEBUG_ARGUMENTS, JPDA_CLASSIC_DEBUG_ARGUMENTS_DEFAULT);
    }

    void setJPDAClassicDebugArguments(String string) {
        if (string == null) {
            string = JPDA_CLASSIC_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(JPDA_CLASSIC_DEBUG_ARGUMENTS, string);
    }

    String[] getJPDAClassicDebugArguments(String string) {
        return DebugConfiguration.insertPort(this.getJPDAClassicDebugArguments(), string);
    }

    String getJPDADebugArguments() {
        return this._hash.getString(JPDA_DEBUG_ARGUMENTS, JPDA_DEBUG_ARGUMENTS_DEFAULT);
    }

    void setJPDADebugArguments(String string) {
        if (string == null) {
            string = JPDA_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(JPDA_DEBUG_ARGUMENTS, string);
    }

    String[] getJPDADebugArguments(String string) {
        return DebugConfiguration.insertPort(this.getJPDADebugArguments(), string);
    }

    private static String[] insertPort(String string, String string2) {
        int n = string.indexOf("<port>");
        if (n < 0) {
            return null;
        }
        string = n + 6 == string.length() ? string.substring(0, n) + string2 : string.substring(0, n) + string2 + string.substring(n + 6);
        return IdeUtil.convertStringToStringArray((String)string);
    }
}

