/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugContext {
    DebugVirtualMachine vm;
    DebugThreadInfo thread;
    DebugStackFrameInfo frame;
    DebugDataObjectInfo dataObject;
    Map variables = new HashMap();

    DebugContext() {
    }

    boolean setDebugContext(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo debugStackFrameInfo) {
        if (this.vm != debugVirtualMachine || this.thread != debugThreadInfo || this.frame != debugStackFrameInfo || this.dataObject != null) {
            this.vm = debugVirtualMachine;
            this.thread = debugThreadInfo;
            this.frame = debugStackFrameInfo;
            this.dataObject = null;
            this.clearVariables();
            return true;
        }
        return false;
    }

    boolean setDebugContext(DebugDataObjectInfo debugDataObjectInfo) {
        DebugVirtualMachine debugVirtualMachine = debugDataObjectInfo.getVM();
        if (this.vm != debugVirtualMachine || this.thread != null || this.frame != null || this.dataObject != debugDataObjectInfo) {
            this.vm = debugVirtualMachine;
            this.thread = null;
            this.frame = null;
            this.dataObject = debugDataObjectInfo;
            this.clearVariables();
            return true;
        }
        return false;
    }

    void clearVariables() {
        this.variables.clear();
    }

    void addVariable(String string, Object object) {
        this.variables.put(string, object);
    }

    void removeVariable(String string) {
        this.variables.remove(string);
    }
}

