/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.Site;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;
import oracle.ideri.util.Product;
import oracle.jdevimpl.runner.debug.BreakpointsWindow;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.WatchWindow;

final class DebugDockableFactory
implements DockableFactory {
    private JDebugger jdebugger;

    public DebugDockableFactory(JDebugger jDebugger) {
        this.jdebugger = jDebugger;
        DockStation dockStation = DockStation.getDockStation();
        dockStation.registerDockableFactory("Debugger", (DockableFactory)this);
    }

    public void install() {
        DockStation dockStation = DockStation.getDockStation();
        Dockable dockable = dockStation.findDockable(ExplorerManager.getExplorerManager().getDefaultViewId());
        LogWindow logWindow = LogManager.getIdeLogWindow();
        boolean bl = Product.isRaptor();
        BreakpointsWindow breakpointsWindow = this.jdebugger.getBreakpointsWindow(true);
        DockingParam dockingParam = new DockingParam();
        if (logWindow != null) {
            dockingParam.setTabbedWith((Dockable)logWindow);
        } else {
            dockingParam.setPosition(3);
        }
        dockStation.dock((Dockable)breakpointsWindow, dockingParam);
        if (!bl) {
            ThreadsWindow threadsWindow = this.jdebugger.getThreadsWindow(true);
            DockingParam dockingParam2 = new DockingParam();
            if (dockable != null) {
                dockingParam2.setTabbedWith(dockable);
            } else {
                dockingParam2.setPosition(0);
            }
            dockStation.dock((Dockable)threadsWindow, dockingParam2);
        }
        if (!bl) {
            ClassesWindow classesWindow = this.jdebugger.getClassesWindow(true);
            DockingParam dockingParam3 = new DockingParam();
            dockingParam3.setPosition(1);
            dockStation.dock((Dockable)classesWindow, dockingParam3);
        }
        StackWindow stackWindow = this.jdebugger.getStackWindow(true);
        DockingParam dockingParam4 = new DockingParam();
        if (dockable != null) {
            dockingParam4.setTabbedWith(dockable);
        } else {
            dockingParam4.setPosition(3);
        }
        dockStation.dock((Dockable)stackWindow, dockingParam4);
        SmartWindow smartWindow = this.jdebugger.getSmartWindow(true);
        DockingParam dockingParam5 = new DockingParam();
        dockingParam5.setPosition(3);
        dockStation.dock((Dockable)smartWindow, dockingParam5);
        LocalsWindow localsWindow = this.jdebugger.getLocalsWindow(true);
        DockingParam dockingParam6 = new DockingParam();
        dockingParam6.setTabbedWith((Dockable)smartWindow);
        dockStation.dock((Dockable)localsWindow, dockingParam6);
        WatchWindow watchWindow = this.jdebugger.getWatchWindow(true);
        DockingParam dockingParam7 = new DockingParam();
        dockingParam7.setTabbedWith((Dockable)localsWindow);
        dockStation.dock((Dockable)watchWindow, dockingParam7);
        if (!bl) {
            HeapWindow heapWindow = this.jdebugger.getHeapWindow(true);
            DockingParam dockingParam8 = new DockingParam();
            dockingParam8.setTabbedWith((Dockable)watchWindow);
            dockStation.dock((Dockable)heapWindow, dockingParam8);
        }
        if (!bl) {
            MonitorsWindow monitorsWindow = this.jdebugger.getMonitorsWindow(true);
            DockingParam dockingParam9 = new DockingParam();
            Point point = this.getCenterOfScreen((Dockable)monitorsWindow);
            Rectangle rectangle = new Rectangle(point.x, point.y, 400, 200);
            dockingParam9.setFloatingPosition(rectangle);
            dockStation.dock((Dockable)monitorsWindow, dockingParam9);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        String string = viewId.getId();
        return this.getDockable(string);
    }

    private Dockable getDockable(String string) {
        DockableWindow dockableWindow = string.equals("Debugger.BreakpointsWindow") ? this.jdebugger.getBreakpointsWindow(true) : (string.equals("Debugger.ThreadsWindow") ? this.jdebugger.getThreadsWindow(true) : (string.equals("Debugger.StackWindow") ? this.jdebugger.getStackWindow(true) : (string.equals("Debugger.LocalsWindow") ? this.jdebugger.getLocalsWindow(true) : (string.equals("Debugger.WatchWindow") ? this.jdebugger.getWatchWindow(true) : (string.equals("Debugger.SmartWindow") ? this.jdebugger.getSmartWindow(true) : (string.equals("Debugger.HeapWindow") ? this.jdebugger.getHeapWindow(true) : (string.equals("Debugger.ClassesWindow") ? this.jdebugger.getClassesWindow(true) : (string.equals("Debugger.MonitorsWindow") ? this.jdebugger.getMonitorsWindow(true) : (string.startsWith("Debugger.InspectorWindow") ? this.jdebugger.getInspectorWindow(string) : null)))))))));
        return dockableWindow;
    }

    void floatWindow(DockableWindow dockableWindow) {
        DockStation dockStation = DockStation.getDockStation();
        Point point = this.getCenterOfScreen((Dockable)dockableWindow);
        Rectangle rectangle = new Rectangle(point.x, point.y, 400, 300);
        DockingParam dockingParam = new DockingParam();
        dockingParam.setFloatingPosition(rectangle);
        dockStation.dock((Dockable)dockableWindow, dockingParam);
        dockStation.setDockableVisible((Dockable)dockableWindow, true);
        dockStation.activateDockable((Dockable)dockableWindow);
    }

    static void updateSiteGeometry(Dockable dockable) {
        JComponent jComponent = dockable.getHostedComponent();
        if (jComponent != null) {
            Dimension dimension = jComponent.getPreferredSize();
            Site site = dockable.getSite();
            site.geometry.width = dimension.width;
            site.geometry.height = dimension.height;
        }
    }

    private Point getCenterOfScreen(Dockable dockable) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Point point = new Point(dimension.width / 2, dimension.height / 2);
        Site site = dockable.getSite();
        point.x -= site.geometry.width / 2;
        point.y -= site.geometry.height / 2;
        return point;
    }
}

