/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.ClientSetting;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class DebugWindowSettings
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "DebugWindowOptions";
    static final String START_RUNNING = "running";
    static final String START_STEPOVER = "stepover";
    static final String START_STEPINTO = "stepinto";
    private int _tableResizeMode;
    private boolean _contextMenusOnMainMenu;
    private boolean _useFilters;
    private int _connectionRetries;
    private boolean _showToolTipInCodeEditor;
    private boolean _showToolbarInLogWindow;
    private boolean _promptForDebuggerHostForDatabaseDebugging;
    private boolean _localPortRange;
    private int _localPortRangeMin;
    private int _localPortRangeMax;
    private String _startOption;

    public static DebugWindowSettings getInstance() {
        Addin addin = AddinManager.getAddinManager().getAddin(JDebugger.class);
        return (DebugWindowSettings)ClientSetting.findOrCreate((String)AddinManager.getAddinManager().getExtensionForAddin(addin).getID()).getData(KEY_SETTINGS);
    }

    public DebugWindowSettings() {
        this.defaultInit();
    }

    public DebugWindowSettings(DebugWindowSettings debugWindowSettings) {
        if (debugWindowSettings == null) {
            this.defaultInit();
        } else {
            debugWindowSettings.copyToImpl(this);
        }
    }

    private void defaultInit() {
        this._tableResizeMode = 1;
        this._contextMenusOnMainMenu = false;
        this._useFilters = false;
        this._connectionRetries = 30;
        this._showToolTipInCodeEditor = true;
        this._showToolbarInLogWindow = true;
        this._promptForDebuggerHostForDatabaseDebugging = false;
        this._localPortRange = false;
        this._localPortRangeMin = 4000;
        this._localPortRangeMax = 4999;
        this._startOption = START_RUNNING;
    }

    public Object copyTo(Object object) {
        DebugWindowSettings debugWindowSettings = object != null ? (DebugWindowSettings)((Object)object) : new DebugWindowSettings();
        this.copyToImpl(debugWindowSettings);
        return debugWindowSettings;
    }

    protected final void copyToImpl(DebugWindowSettings debugWindowSettings) {
        debugWindowSettings._tableResizeMode = this._tableResizeMode;
        debugWindowSettings._contextMenusOnMainMenu = this._contextMenusOnMainMenu;
        debugWindowSettings._useFilters = this._useFilters;
        debugWindowSettings._connectionRetries = this._connectionRetries;
        debugWindowSettings._showToolTipInCodeEditor = this._showToolTipInCodeEditor;
        debugWindowSettings._showToolbarInLogWindow = this._showToolbarInLogWindow;
        debugWindowSettings._promptForDebuggerHostForDatabaseDebugging = this._promptForDebuggerHostForDatabaseDebugging;
        debugWindowSettings._localPortRange = this._localPortRange;
        debugWindowSettings._localPortRangeMin = this._localPortRangeMin;
        debugWindowSettings._localPortRangeMax = this._localPortRangeMax;
        debugWindowSettings._startOption = this._startOption;
        debugWindowSettings.fireChangeEvent();
    }

    public int getTableResizeMode() {
        return this._tableResizeMode;
    }

    public void setTableResizeMode(int n) {
        this._tableResizeMode = n;
    }

    public boolean isContextMenusOnMainMenu() {
        return this._contextMenusOnMainMenu;
    }

    public void setContextMenusOnMainMenu(boolean bl) {
        this._contextMenusOnMainMenu = bl;
    }

    public boolean isUseFilters() {
        return this._useFilters;
    }

    public void setUseFilters(boolean bl) {
        this._useFilters = bl;
    }

    public int getConnectionRetries() {
        return this._connectionRetries;
    }

    public void setConnectionRetries(int n) {
        this._connectionRetries = n;
    }

    public boolean isShowToolTipInCodeEditor() {
        return this._showToolTipInCodeEditor;
    }

    public void setShowToolTipInCodeEditor(boolean bl) {
        this._showToolTipInCodeEditor = bl;
    }

    public boolean isShowToolbarInLogWindow() {
        return this._showToolbarInLogWindow;
    }

    public void setShowToolbarInLogWindow(boolean bl) {
        this._showToolbarInLogWindow = bl;
    }

    public boolean isPromptForDebuggerHostForDatabaseDebugging() {
        return this._promptForDebuggerHostForDatabaseDebugging;
    }

    public void setPromptForDebuggerHostForDatabaseDebugging(boolean bl) {
        this._promptForDebuggerHostForDatabaseDebugging = bl;
    }

    public boolean isLocalPortRange() {
        return this._localPortRange;
    }

    public void setLocalPortRange(boolean bl) {
        this._localPortRange = bl;
    }

    public int getLocalPortRangeMin() {
        return this._localPortRangeMin;
    }

    public void setLocalPortRangeMin(int n) {
        this._localPortRangeMin = n;
    }

    public int getLocalPortRangeMax() {
        return this._localPortRangeMax;
    }

    public void setLocalPortRangeMax(int n) {
        this._localPortRangeMax = n;
    }

    public String getStartOption() {
        return this._startOption;
    }

    public void setStartOption(String string) {
        this._startOption = string;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DebugWindowSettings)((Object)object));
    }

    protected final boolean equalsImpl(DebugWindowSettings debugWindowSettings) {
        return this._tableResizeMode == debugWindowSettings._tableResizeMode && this._contextMenusOnMainMenu == debugWindowSettings._contextMenusOnMainMenu && this._useFilters == debugWindowSettings._useFilters && this._connectionRetries == debugWindowSettings._connectionRetries && this._showToolTipInCodeEditor == debugWindowSettings._showToolTipInCodeEditor && this._showToolbarInLogWindow == debugWindowSettings._showToolbarInLogWindow && this._promptForDebuggerHostForDatabaseDebugging == debugWindowSettings._promptForDebuggerHostForDatabaseDebugging && this._localPortRange == debugWindowSettings._localPortRange && this._localPortRangeMin == debugWindowSettings._localPortRangeMin && this._localPortRangeMax == debugWindowSettings._localPortRangeMax && ModelUtil.areEqual((Object)this._startOption, (Object)debugWindowSettings._startOption);
    }
}

