/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;

public final class DebugWindowSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private JCheckBox contextMenusCheckBox;
    private JCheckBox toolTipCheckBox;
    private JCheckBox toolbarCheckBox;
    private JLabel connectionRetriesLabel;
    private NumericSpinBox connectionRetriesBox;
    private JCheckBox promptHostDatabaseCheckBox;
    private JCheckBox localPortRangeCheckBox;
    private JLabel localPortRangeMinLabel;
    private NumericSpinBox localPortRangeMinBox;
    private JLabel localPortRangeMaxLabel;
    private NumericSpinBox localPortRangeMaxBox;
    private JRadioButton startRunningRadio;
    private JRadioButton startStepOverRadio;
    private JRadioButton startStepIntoRadio;

    public DebugWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_projset_debugwin_html");
        this.contextMenusCheckBox = new JCheckBox();
        this.toolTipCheckBox = new JCheckBox();
        this.toolbarCheckBox = new JCheckBox();
        this.connectionRetriesLabel = new JLabel();
        this.connectionRetriesBox = new NumericSpinBox(0, 1000);
        this.promptHostDatabaseCheckBox = new JCheckBox();
        this.localPortRangeCheckBox = new JCheckBox();
        this.localPortRangeMinLabel = new JLabel();
        this.localPortRangeMinBox = new NumericSpinBox(0, 65535);
        this.localPortRangeMaxLabel = new JLabel();
        this.localPortRangeMaxBox = new NumericSpinBox(0, 65535);
        this.startRunningRadio = new JRadioButton();
        this.startStepOverRadio = new JRadioButton();
        this.startStepIntoRadio = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.startRunningRadio);
        buttonGroup.add(this.startStepOverRadio);
        buttonGroup.add(this.startStepIntoRadio);
        ResourceUtils.resButton((AbstractButton)this.contextMenusCheckBox, (String)DbgArb.getString(724));
        ResourceUtils.resButton((AbstractButton)this.toolTipCheckBox, (String)DbgArb.getString(725));
        ResourceUtils.resButton((AbstractButton)this.toolbarCheckBox, (String)DbgArb.getString(726));
        ResourceUtils.resLabel((JLabel)this.connectionRetriesLabel, (Component)this.connectionRetriesBox, (String)DbgArb.getString(727));
        ResourceUtils.resButton((AbstractButton)this.promptHostDatabaseCheckBox, (String)DbgArb.getString(728));
        ResourceUtils.resButton((AbstractButton)this.localPortRangeCheckBox, (String)DbgArb.getString(729));
        ResourceUtils.resLabel((JLabel)this.localPortRangeMinLabel, (Component)this.localPortRangeMinBox, (String)DbgArb.getString(730));
        ResourceUtils.resLabel((JLabel)this.localPortRangeMaxLabel, (Component)this.localPortRangeMaxBox, (String)DbgArb.getString(731));
        ResourceUtils.resButton((AbstractButton)this.startRunningRadio, (String)DbgArb.getString(361));
        ResourceUtils.resButton((AbstractButton)this.startStepOverRadio, (String)DbgArb.getString(362));
        ResourceUtils.resButton((AbstractButton)this.startStepIntoRadio, (String)DbgArb.getString(363));
        this.localPortRangeCheckBox.addItemListener(this);
        this.setSpinBuddyAlignment(this.connectionRetriesBox);
        this.setSpinBuddyAlignment(this.localPortRangeMinBox);
        this.setSpinBuddyAlignment(this.localPortRangeMaxBox);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(this.contextMenusCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.toolTipCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.toolbarCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.makeConnectionRetriesPanel(), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.promptHostDatabaseCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.makeLocalPortRangePanel(), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.makeStartPanel(), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setSpinBuddyAlignment(NumericSpinBox numericSpinBox) {
        SpinBuddy spinBuddy = numericSpinBox.getSpinBuddy();
        if (spinBuddy instanceof JTextField) {
            ((JTextField)spinBuddy).setHorizontalAlignment(4);
        }
    }

    private JPanel makeConnectionRetriesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.connectionRetriesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.connectionRetriesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeLocalPortRangePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)this.localPortRangeCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMinLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 25, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMinBox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMaxLabel, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.localPortRangeMaxBox, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeStartPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(DbgArb.getString(360));
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.startRunningRadio, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)this.startStepOverRadio, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)this.startStepIntoRadio, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void enableLocalPortRange() {
        boolean bl = this.localPortRangeCheckBox.isSelected();
        this.localPortRangeMinLabel.setEnabled(bl);
        this.localPortRangeMinBox.setEnabled(bl);
        this.localPortRangeMaxLabel.setEnabled(bl);
        this.localPortRangeMaxBox.setEnabled(bl);
    }

    public void onEntry(TraversableContext traversableContext) {
        DebugWindowSettings debugWindowSettings = (DebugWindowSettings)((Object)traversableContext.find("DebugWindowOptions"));
        this.contextMenusCheckBox.setSelected(debugWindowSettings.isContextMenusOnMainMenu());
        this.toolTipCheckBox.setSelected(debugWindowSettings.isShowToolTipInCodeEditor());
        this.toolbarCheckBox.setSelected(debugWindowSettings.isShowToolbarInLogWindow());
        this.connectionRetriesBox.setIntValue(debugWindowSettings.getConnectionRetries());
        this.promptHostDatabaseCheckBox.setSelected(debugWindowSettings.isPromptForDebuggerHostForDatabaseDebugging());
        this.localPortRangeCheckBox.setSelected(debugWindowSettings.isLocalPortRange());
        this.localPortRangeMinBox.setIntValue(debugWindowSettings.getLocalPortRangeMin());
        this.localPortRangeMaxBox.setIntValue(debugWindowSettings.getLocalPortRangeMax());
        this.enableLocalPortRange();
        this.startRunningRadio.setSelected(false);
        this.startStepOverRadio.setSelected(false);
        this.startStepIntoRadio.setSelected(false);
        String string = debugWindowSettings.getStartOption();
        if (string.equals("stepover")) {
            this.startStepOverRadio.setSelected(true);
        } else if (string.equals("stepinto")) {
            this.startStepIntoRadio.setSelected(true);
        } else {
            this.startRunningRadio.setSelected(true);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.localPortRangeCheckBox.isSelected() && this.localPortRangeMinBox.getIntValue() > this.localPortRangeMaxBox.getIntValue()) {
            throw new TraversalException(DbgArb.getString(732));
        }
        DebugWindowSettings debugWindowSettings = (DebugWindowSettings)((Object)traversableContext.find("DebugWindowOptions"));
        debugWindowSettings.setContextMenusOnMainMenu(this.contextMenusCheckBox.isSelected());
        debugWindowSettings.setShowToolTipInCodeEditor(this.toolTipCheckBox.isSelected());
        debugWindowSettings.setShowToolbarInLogWindow(this.toolbarCheckBox.isSelected());
        debugWindowSettings.setConnectionRetries(this.connectionRetriesBox.getIntValue());
        debugWindowSettings.setPromptForDebuggerHostForDatabaseDebugging(this.promptHostDatabaseCheckBox.isSelected());
        debugWindowSettings.setLocalPortRange(this.localPortRangeCheckBox.isSelected());
        debugWindowSettings.setLocalPortRangeMin(this.localPortRangeMinBox.getIntValue());
        debugWindowSettings.setLocalPortRangeMax(this.localPortRangeMaxBox.getIntValue());
        String string = this.startStepOverRadio.isSelected() ? "stepover" : (this.startStepIntoRadio.isSelected() ? "stepinto" : "running");
        debugWindowSettings.setStartOption(string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.localPortRangeCheckBox) {
            this.enableLocalPortRange();
        }
    }
}

