/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DbgArb;

final class DebuggerHostDialog
extends JPanel
implements ItemListener,
DocumentListener,
ActionListener {
    private JEWTDialog dlg;
    private HistoryList hostHistoryList;
    private JComboBox hostComboBox;
    private JTextField hostEditor;
    private static String mostRecentHost;

    static String showDebuggerHostDialog(String string) {
        DebuggerHostDialog debuggerHostDialog = new DebuggerHostDialog(string);
        String string2 = DbgArb.getString(223);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)debuggerHostDialog, (Component)debuggerHostDialog.hostEditor, (String)string2);
        debuggerHostDialog.setJEWTDialog(jEWTDialog);
        jEWTDialog.setButtonMask(jEWTDialog.getButtonMask() & 0xFFFFFFFD);
        jEWTDialog.setOKButtonEnabled(debuggerHostDialog.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)debuggerHostDialog, "f1_deb_hostname_html");
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            return debuggerHostDialog.getHost();
        }
        return string;
    }

    private DebuggerHostDialog(String string) {
        super(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.hostHistoryList = Ide.loadHistoryList((String)"DebuggerHost");
        if (string != null) {
            this.hostHistoryList.update(string);
        }
        if (mostRecentHost != null) {
            this.hostHistoryList.update(mostRecentHost);
        }
        this.hostComboBox = new JComboBox<String>(this.hostHistoryList.getHistory());
        this.hostComboBox.setEditable(true);
        this.hostEditor = (JTextField)this.hostComboBox.getEditor().getEditorComponent();
        this.hostComboBox.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.hostEditor, (String)DbgArb.getString(224));
        if (mostRecentHost != null) {
            IdeUtil.comboBoxSelectItem((JComboBox)this.hostComboBox, (Object)mostRecentHost);
        } else if (string != null) {
            IdeUtil.comboBoxSelectItem((JComboBox)this.hostComboBox, (Object)string);
        } else {
            IdeUtil.comboBoxSelectItem((JComboBox)this.hostComboBox, (Object)"");
        }
        String string2 = DbgArb.format(225, Ide.getProgramShortName());
        int n = 50;
        int n2 = string2.length() / n + 1;
        JTextArea jTextArea = new JTextArea(string2, n2, n);
        jTextArea.setBackground(jLabel.getBackground());
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        int n3 = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n3++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.hostComboBox, new GridBagConstraints(0, n3++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jTextArea, new GridBagConstraints(0, n3, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.hostComboBox, (DocumentListener)this);
        this.hostComboBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        try {
            boolean bl = this.hostEditor.getText().length() > 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.hostComboBox) {
            this.hostEditor.setText((String)this.hostComboBox.getSelectedItem());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.processChange();
    }

    private String getHost() {
        mostRecentHost = this.hostHistoryList.comboBoxGetSelectedItem(this.hostComboBox);
        return mostRecentHost;
    }
}

