/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.Runner;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebuggingListener
extends BaseElement
implements DebugConnectionListener {
    private DebuggingProcess debuggingProcess;
    private boolean keepListening;
    private Workspace workspace;
    private Project project;
    private RunConfiguration runConfiguration;
    private DebugConfiguration debugConfiguration;
    private DebugConnector connector;
    private DebugConnectArg[] connectArgs;
    private String connectArgsLabel;

    DebuggingListener(DebuggingProcess debuggingProcess, boolean bl) {
        JDebugger.getInstance().makeDebuggingListenerActions();
        this.debuggingProcess = debuggingProcess;
        this.keepListening = bl;
        this.project = debuggingProcess.getProject();
        this.workspace = debuggingProcess.getWorkspace();
        this.runConfiguration = RunConfiguration.getInstance((PropertyStorage)this.project);
        this.debugConfiguration = DebugConfiguration.getInstance(this.runConfiguration);
        this.setIcon(DbgArb.getIcon(195));
    }

    boolean startListening() {
        return this.startListening(null);
    }

    boolean startListening(String string) {
        this.connector = DebugFactory.newInstance(2);
        this.connectArgs = this.connector.getConnectArgs();
        int n = this.connectArgs.length;
        boolean bl = false;
        while (true) {
            if (this.runConfiguration.isRemoteDebuggingProfiling()) {
                boolean bl2 = this.debugConfiguration.isPromptForRemoteDebugging();
                int n2 = 0;
                while (n2 < n) {
                    DebugConnectArg debugConnectArg = this.connectArgs[n2];
                    String string2 = this.debugConfiguration.getRemoteParameterValue("jpdaListen", debugConnectArg.getName());
                    if (string2 != null) {
                        debugConnectArg.setValue(string2);
                        if (string2.length() == 0 && !debugConnectArg.allowBlank()) {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (bl) {
                    bl2 = true;
                }
                if (bl2) {
                    String string3;
                    boolean[] blArray;
                    String[] stringArray = new String[n];
                    String[] stringArray2 = new String[n];
                    boolean[] blArray2 = new boolean[n];
                    int n3 = 0;
                    while (n3 < n) {
                        DebugConnectArg debugConnectArg = this.connectArgs[n3];
                        stringArray[n3] = debugConnectArg.getLabel();
                        stringArray2[n3] = debugConnectArg.getValue();
                        blArray2[n3] = debugConnectArg.allowBlank();
                        ++n3;
                    }
                    String string4 = DbgArb.getString(234);
                    boolean bl3 = RemoteConnectDialog.showRemoteConnectDialog(string4, stringArray, stringArray2, blArray2, blArray = new boolean[1], string3 = "f1_deb_listen_jpda_html");
                    if (!bl3) {
                        return false;
                    }
                    int n4 = 0;
                    while (n4 < n) {
                        DebugConnectArg debugConnectArg = this.connectArgs[n4];
                        debugConnectArg.setValue(stringArray2[n4]);
                        if (blArray[0] || this.debugConfiguration.isCustom()) {
                            this.debugConfiguration.putRemoteParameterValue("jpdaListen", debugConnectArg.getName(), stringArray2[n4]);
                        }
                        ++n4;
                    }
                    if (blArray[0]) {
                        this.debugConfiguration.setPromptForRemoteDebugging(false);
                    }
                }
            } else {
                DebugConnectArg debugConnectArg = DebugShared.findConnectArg(this.connectArgs, "port");
                if (debugConnectArg != null) {
                    debugConnectArg.setValue(string);
                }
            }
            try {
                this.connector.startListening(this.connectArgs, this);
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = 0;
                while (n5 < n) {
                    DebugConnectArg debugConnectArg = this.connectArgs[n5];
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(debugConnectArg.getLabel());
                    stringBuffer.append("=");
                    stringBuffer.append(debugConnectArg.getValue());
                    ++n5;
                }
                this.connectArgsLabel = stringBuffer.toString();
                boolean bl4 = true;
                return bl4;
            }
            catch (Exception exception) {
                block19: {
                    int n6;
                    if (!this.runConfiguration.isRemoteDebuggingProfiling()) break block19;
                    bl = true;
                    String[] stringArray = new String[]{DbgArb.getString(236), DbgArb.getString(237)};
                    if ((n6 = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), stringArray, DbgArb.getString(238), 0)) != 1) continue;
                }
                return false;
            }
            break;
        }
    }

    void stopListening() {
        try {
            this.connector.stopListening();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void listeningStarted() {
        SwingUtilities.invokeLater(new 3());
    }

    public boolean connectionEstablished(DebugVirtualMachine debugVirtualMachine) {
        SwingUtilities.invokeLater(new 2(this, debugVirtualMachine));
        return this.keepListening;
    }

    public void listeningStopped() {
        SwingUtilities.invokeLater(new 1());
    }

    public String getShortLabel() {
        if (this.connectArgsLabel != null && this.connectArgsLabel.length() > 0) {
            return DbgArb.format(194, this.connectArgsLabel);
        }
        return DbgArb.getString(193);
    }

    static DebuggingProcess ra$debuggingProcess(DebuggingListener debuggingListener) {
        return debuggingListener.debuggingProcess;
    }

    static void wa$debuggingProcess(DebuggingListener debuggingListener, DebuggingProcess debuggingProcess) {
        debuggingListener.debuggingProcess = debuggingProcess;
    }

    static Workspace ra$workspace(DebuggingListener debuggingListener) {
        return debuggingListener.workspace;
    }

    static Project ra$project(DebuggingListener debuggingListener) {
        return debuggingListener.project;
    }

    static DebugConnectArg[] ra$connectArgs(DebuggingListener debuggingListener) {
        return debuggingListener.connectArgs;
    }

    final class 3
    implements Runnable {
        public void run() {
            JDebugger.getInstance().listenerStarted(DebuggingListener.this);
            Runner.getRunner().getRunManagerFolder().add((Element)DebuggingListener.this);
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ DebugVirtualMachine v$vm;
        final /* synthetic */ DebuggingListener this$0;

        public void run() {
            DebuggingProcess debuggingProcess = DebuggingListener.ra$debuggingProcess(this.this$0);
            DebuggingListener.wa$debuggingProcess(this.this$0, null);
            if (debuggingProcess == null) {
                Context context = ContextBuilder.buildContext(null, (View)Runner.getRunner().getRunManagerWindow(), null, DebuggingListener.ra$workspace(this.this$0), DebuggingListener.ra$project(this.this$0));
                debuggingProcess = new DebuggingProcess(context);
            }
            debuggingProcess.accept(this.v$vm, DebuggingListener.ra$connectArgs(this.this$0));
        }

        public 2(DebuggingListener debuggingListener, DebugVirtualMachine debugVirtualMachine) {
            this.v$vm = debugVirtualMachine;
            this.this$0 = debuggingListener;
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            if (DebuggingListener.ra$debuggingProcess(DebuggingListener.this) != null) {
                DebuggingListener.ra$debuggingProcess(DebuggingListener.this).listenerStopped();
                DebuggingListener.wa$debuggingProcess(DebuggingListener.this, null);
            }
            JDebugger.getInstance().listenerStopped(DebuggingListener.this);
            Runner.getRunner().getRunManagerFolder().remove((Element)DebuggingListener.this);
        }
    }
}

