/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.IdeLayout;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.DebuggerAdapter;
import oracle.ide.runner.DebuggerEvent;
import oracle.ide.runner.DebuggerEventSource;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSynchStatement;
import oracle.javatools.util.NamedTimer;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DatabaseDebuggingHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.TracingPanel;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

public class DebuggingProcess
extends JRunProcess
implements DebugBreakpointLogListener,
DebugListener {
    private long timeProgramStopped;
    private long timeWindowsUpdated;
    private long timeBeforeConnect;
    private long timeAfterConnect;
    private Toolbar logPageToolbar;
    private boolean logPageToolbarSet;
    private String localPort;
    private static final boolean socketRelay = false;
    private boolean skipCompile;
    private DatabaseDebuggingHelper databaseDebuggingHelper;
    private boolean databaseDebugging;
    private boolean xsltDebugging;
    private boolean antDebugging;
    private Node xsltInputNode;
    private Node xsltOutputNode;
    private Editor xsltOutputEditor;
    private volatile Thread connectionThread;
    protected volatile DebugVirtualMachine vm;
    private final Object vmSync;
    private DebugThreadInfo currentThread;
    private DebugThreadInfo lastKnownGoodThread;
    private DebugStackFrameInfo currentStackFrame;
    private DebugLocation currentLocation;
    private DebugThreadInfo[][] deadlocks;
    private List runAfterSelectedList;
    private boolean stopped;
    private int loadedClassesCount;
    private boolean resuming;
    private boolean stepping;
    private final boolean[] pause;
    private List runWhilePausedList;
    private List runAfterPausedList;
    private static final int INTERNAL = 0;
    private static final int USER = 1;
    private DebugBreakpoint runToCursor;
    private SourceIcon sourceIconForIP;
    private SourceIcon sourceIconForIPBytecode;
    private List messages;
    private String disconnectedMessage;
    private long updateNormalWindowsEndTime;
    private long stepRequestTime;
    private TimerTask timerTaskUpdateNormalWindows;
    private TimerTask timerTaskUpdateOtherWindows;
    private EventSource debuggerEventSource;
    private DebuggerStartCallback debuggerStartCallback;
    private static Timer timer = null;
    private static Class databaseDebuggingHelperClass = null;
    private static HelpInfo helpInfo;
    static final Class starterFactorySubClass;
    private static int classLoadTracking;
    private static final int PRINT_SYSTEM_OUT = 1;
    private static final int PRINT_SYSTEM_ERR = 2;
    private static final int PRINT_LOG_WINDOW = 4;
    static String statusText;

    static {
        starterFactorySubClass = JStarterFactory.class;
        classLoadTracking = -1;
    }

    void $init$() {
        this.vmSync = new Object();
        this.pause = new boolean[2];
    }

    public DebuggingProcess(Context context) {
        this(context, null);
    }

    public DebuggingProcess(Context context, DebuggerStartCallback debuggerStartCallback) {
        super(context);
        this.$init$();
        try {
            if (databaseDebuggingHelperClass != null) {
                this.databaseDebuggingHelper = (DatabaseDebuggingHelper)databaseDebuggingHelperClass.newInstance();
                this.databaseDebuggingHelper.setDebuggingProcess(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDebugger.getInstance().debuggingProcessCreated();
        this.runAfterSelectedList = new ArrayList();
        this.runWhilePausedList = new ArrayList();
        this.runAfterPausedList = new ArrayList();
        this.messages = new ArrayList();
        this.debuggerStartCallback = debuggerStartCallback;
    }

    DebugConfiguration getDebugConfiguration() {
        return DebugConfiguration.getInstance((PropertyStorage)this.getJProject());
    }

    public boolean canRun(String string, Object object, Node node, List list) {
        if ("Java".equals(string)) {
            return this.canRunJava(node, list);
        }
        if ("Database".equals(string)) {
            return this.canRunInDatabase(node, object, list);
        }
        if ("XSLT".equals(string)) {
            return true;
        }
        if ("XQuery".equals(string)) {
            list.add(DbgArb.format(856, node.getShortLabel()));
            return false;
        }
        return false;
    }

    private boolean canRunJava(Node node, List list) {
        if (!this.isRemoteDebuggingProfiling()) {
            JDK jDK = this.getJdkDefinition();
            if (this.runConfiguration.usingOJVM(jDK)) {
                return true;
            }
            if (this.runConfiguration.usingMinimal(jDK) || this.runConfiguration.usingVanilla(jDK)) {
                list.add(DbgArb.format(850, node.getShortLabel()));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean canRunInDatabase(Node node, Object object, List list) {
        if (!this.isRemoteDebuggingProfiling() && this.databaseDebuggingHelper != null) {
            return this.databaseDebuggingHelper.canRunInDatabase(node, object, list);
        }
        return false;
    }

    public Object getValue(String string, Object object, String string2) {
        if ("Java".equals(string) && "FirstJavaCommandOptions".equals(string2)) {
            return this.getFirstJavaCommandOptions();
        }
        if ("Database".equals(string) && "DatabaseRunHelper".equals(string2)) {
            this.databaseDebugging = true;
            return this.databaseDebuggingHelper;
        }
        if ("XSLT".equals(string)) {
            if ("FirstXSLTCommandOptions".equals(string2)) {
                return this.getFirstXSLTCommandOptions();
            }
            if ("LastXSLTCommandOptions".equals(string2)) {
                return this.getLastXSLTCommandOptions();
            }
        }
        if ("Ant".equals(string)) {
            if ("FirstAntCommandOptions".equals(string2)) {
                return this.getFirstAntCommandOptions();
            }
            if ("LastAntCommandOptions".equals(string2)) {
                return this.getLastAntCommandOptions();
            }
        }
        return null;
    }

    private String[] getFirstJavaCommandOptions() {
        String string = this.localPort == null ? (this.localPort = Integer.toString(DebuggingProcess.getLocalPort())) : this.localPort;
        JDK jDK = this.getJdkDefinition();
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        if (this.runConfiguration.usingMinimal(jDK) || this.runConfiguration.usingVanilla(jDK)) {
            return null;
        }
        if (this.runConfiguration.usingOJVM(jDK)) {
            return debugConfiguration.getOJVMDebugArguments(string);
        }
        if (this.runConfiguration.usingClassic(jDK)) {
            return debugConfiguration.getJPDAClassicDebugArguments(string);
        }
        return debugConfiguration.getJPDADebugArguments(string);
    }

    private String[] getFirstXSLTCommandOptions() {
        this.xsltDebugging = true;
        this.xsltInputNode = XSLTRunnerAddin.getXSLTInputNode(this.getJProject(), true);
        this.xsltOutputNode = XSLTRunnerAddin.getXSLTOutputNode(this.getJProject(), true);
        if (this.localPort == null) {
            this.localPort = Integer.toString(DebuggingProcess.getLocalPort());
        }
        String[] stringArray = new String[]{XSLTRunnerAddin.getFirstXSLTDebugOption(this.localPort)};
        return stringArray;
    }

    private String[] getLastXSLTCommandOptions() {
        String[] stringArray = new String[]{XSLTRunnerAddin.getLastXSLTDebugOption()};
        return stringArray;
    }

    private String[] getFirstAntCommandOptions() {
        this.antDebugging = true;
        if (this.localPort == null) {
            this.localPort = Integer.toString(DebuggingProcess.getLocalPort());
        }
        return new String[]{"-Djdev.ant.debug.port=" + this.localPort};
    }

    private String[] getLastAntCommandOptions() {
        return new String[]{"-listener", "oracle.jdevimpl.debugger.ant.DebugBuildListener"};
    }

    public String getProcessLabelPrefix() {
        return DbgArb.getString(196);
    }

    public IdeLayout getProcessLayout() {
        return JDebugger.getInstance().getDebugLayout();
    }

    private void setLogPageNorthComponent() {
        this.logPageToolbarSet = true;
        LogPage logPage = this.getLogPage();
        if (logPage instanceof RunLogPage) {
            boolean bl = DebugWindowSettings.getInstance().isShowToolbarInLogWindow();
            ((RunLogPage)logPage).setNorthComponent((Component)(bl ? this.getLogPageToolbar() : null));
        }
    }

    private void clearLogPageNorthComponent() {
        this.logPageToolbarSet = false;
        LogPage logPage = this.getLogPage();
        if (logPage instanceof RunLogPage) {
            ((RunLogPage)logPage).setNorthComponent(null);
        }
    }

    void updateToolbarVisibility(boolean bl) {
        LogPage logPage;
        if (this.logPageToolbarSet && (logPage = this.getLogPage()) instanceof RunLogPage) {
            ((RunLogPage)logPage).setNorthComponent((Component)(bl ? this.getLogPageToolbar() : null));
        }
    }

    Toolbar getLogPageToolbar() {
        if (this.logPageToolbar == null) {
            this.logPageToolbar = new Toolbar();
        }
        return this.logPageToolbar;
    }

    void clearLogPageToolbar() {
        if (this.logPageToolbar != null) {
            this.logPageToolbar.dispose();
            this.logPageToolbar.removeAll();
            this.logPageToolbar.validate();
        }
    }

    public void selected() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        ClassesWindow classesWindow;
        DebugStackFrameInfo debugStackFrameInfo;
        DebugThreadInfo debugThreadInfo;
        DebugVirtualMachine debugVirtualMachine;
        super.selected();
        JDebugger jDebugger = JDebugger.getInstance();
        jDebugger.processSelected(this);
        if (this.vm != null && this.stopped) {
            debugVirtualMachine = this.vm;
            debugThreadInfo = this.currentThread;
            debugStackFrameInfo = this.currentStackFrame;
        } else {
            debugVirtualMachine = null;
            debugThreadInfo = null;
            debugStackFrameInfo = null;
        }
        this.showSourceIPIcon(false);
        jDebugger.getThreadsWindow(true).updateThreads(this, debugVirtualMachine, debugThreadInfo);
        SmartWindow smartWindow = jDebugger.getSmartWindow(false);
        if (smartWindow != null) {
            smartWindow.updateData(this, debugVirtualMachine, debugThreadInfo, debugStackFrameInfo);
        }
        if ((classesWindow = jDebugger.getClassesWindow(false)) != null) {
            classesWindow.updateClasses(this, debugVirtualMachine);
        }
        if ((heapWindow = jDebugger.getHeapWindow(false)) != null) {
            heapWindow.updateData(this, debugVirtualMachine, null, null);
        }
        if ((monitorsWindow = jDebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.updateMonitors(this, debugVirtualMachine);
        }
        while (this.runAfterSelectedList.size() > 0) {
            Runnable runnable = (Runnable)this.runAfterSelectedList.remove(0);
            runnable.run();
        }
    }

    public void doubleClicked() {
        super.doubleClicked();
        this.showIP();
    }

    public void unselected() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        ClassesWindow classesWindow;
        super.unselected();
        JDebugger jDebugger = JDebugger.getInstance();
        jDebugger.processUnselected(this);
        this.hideSourceIPIcon();
        jDebugger.getThreadsWindow(true).clearThreads();
        SmartWindow smartWindow = jDebugger.getSmartWindow(false);
        if (smartWindow != null) {
            smartWindow.clearData();
        }
        if ((classesWindow = jDebugger.getClassesWindow(false)) != null) {
            classesWindow.clearClasses();
        }
        if ((heapWindow = jDebugger.getHeapWindow(false)) != null) {
            heapWindow.clearData();
        }
        if ((monitorsWindow = jDebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.clearMonitors();
        }
    }

    public Icon getIcon() {
        return DbgArb.getIcon(197);
    }

    public HelpInfo getHelpInfo() {
        if (helpInfo == null) {
            helpInfo = new HelpInfo("f1_deb_log_debuggerprocess_html");
        }
        return helpInfo;
    }

    protected boolean compile() {
        if (this.skipCompile) {
            return true;
        }
        if (this.isRemoteDebuggingProfiling()) {
            return true;
        }
        return super.compile();
    }

    protected Class getStarterFactorySubClass() {
        return starterFactorySubClass;
    }

    protected void determineTargetAndStarter(Class clazz) {
        if (!this.isRemoteDebuggingProfiling()) {
            super.determineTargetAndStarter(clazz);
        }
    }

    protected boolean startTarget() {
        this.skipCompile = false;
        if (this.isRemoteDebuggingProfiling()) {
            DebugConfiguration debugConfiguration = this.getDebugConfiguration();
            if (debugConfiguration.getRemoteProtocol().equals("jpdaListen")) {
                DebuggingListener debuggingListener = new DebuggingListener(this, true);
                if (!debuggingListener.startListening()) {
                    return false;
                }
                if (this.debuggerStartCallback != null) {
                    this.debuggerStartCallback.readyToStart();
                }
                Runner.getRunner().viewRunManager();
            } else {
                if (this.runConfiguration.isClearLogBeforeRun()) {
                    this.getLogPage().clearAll();
                }
                if (!this.connectRemoteDebugging()) {
                    return false;
                }
                if (this.debuggerStartCallback != null) {
                    this.debuggerStartCallback.readyToStart();
                }
            }
        } else {
            if (!this.determineTargetAndStarterAlready) {
                this.determineTargetAndStarter();
            }
            if (this.starter != null && this.debuggerStartCallback != null) {
                this.debuggerStartCallback.readyToStart();
            }
            if (!super.startTarget()) {
                if (this.databaseDebugging) {
                    this.databaseDebuggingHelper.startTargetFailed();
                }
                return false;
            }
            if (!this.databaseDebugging) {
                this.connectLocalDebugging();
            }
        }
        return true;
    }

    static int getLocalPort() {
        DebugWindowSettings debugWindowSettings = DebugWindowSettings.getInstance();
        if (debugWindowSettings.isLocalPortRange()) {
            int n = debugWindowSettings.getLocalPortRangeMin();
            int n2 = debugWindowSettings.getLocalPortRangeMax();
            return Helpers.getLocalPort(n, n2);
        }
        return Helpers.getLocalPort();
    }

    private boolean connectRemoteDebugging() {
        int n = this.getDebuggerFactory();
        DebugConnector debugConnector = DebugFactory.newInstance(n);
        DebugConnectArg[] debugConnectArgArray = this.getDebugConnectArgs(debugConnector);
        int n2 = debugConnectArgArray.length;
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        String string = debugConfiguration.getRemoteProtocol();
        boolean bl = debugConfiguration.isPromptForRemoteDebugging();
        int n3 = 0;
        while (n3 < n2) {
            DebugConnectArg debugConnectArg = debugConnectArgArray[n3];
            String string2 = debugConfiguration.getRemoteParameterValue(string, debugConnectArg.getName());
            if (string2 != null) {
                debugConnectArg.setValue(string2);
                if (string2.length() == 0 && !debugConnectArg.allowBlank()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            String string3;
            boolean[] blArray;
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            boolean[] blArray2 = new boolean[n2];
            int n4 = 0;
            while (n4 < n2) {
                DebugConnectArg debugConnectArg = debugConnectArgArray[n4];
                stringArray[n4] = debugConnectArg.getLabel();
                stringArray2[n4] = debugConnectArg.getValue();
                blArray2[n4] = debugConnectArg.allowBlank();
                ++n4;
            }
            String string4 = n == 1 ? DbgArb.getString(233) : (n == 3 ? DbgArb.getString(235) : DbgArb.getString(232));
            boolean bl2 = RemoteConnectDialog.showRemoteConnectDialog(string4, stringArray, stringArray2, blArray2, blArray = new boolean[1], string3 = "f1_deb_attachto_ojvm_jpda_html");
            if (!bl2) {
                return false;
            }
            int n5 = 0;
            while (n5 < n2) {
                DebugConnectArg debugConnectArg = debugConnectArgArray[n5];
                debugConnectArg.setValue(stringArray2[n5]);
                if (blArray[0] || debugConfiguration.isCustom()) {
                    debugConfiguration.putRemoteParameterValue(string, debugConnectArg.getName(), stringArray2[n5]);
                }
                ++n5;
            }
            if (blArray[0]) {
                debugConfiguration.setPromptForRemoteDebugging(false);
            }
        }
        String string5 = this.findHostValue(debugConnectArgArray);
        String string6 = this.findPortValue(debugConnectArgArray);
        15 var24_24 = new 15();
        14 var25_25 = new 14();
        Runnable runnable = null;
        String string7 = bl ? DbgArb.format(209, string5, string6) : DbgArb.format(210, string5, string6);
        String string8 = DbgArb.format(211, string5, string6);
        this.connectToDebuggee(debugConnector, debugConnectArgArray, string7, string8, var24_24, var25_25, runnable);
        return true;
    }

    protected DebugConnectArg[] getDebugConnectArgs(DebugConnector debugConnector) {
        DebugConnectArg[] debugConnectArgArray = debugConnector.getConnectArgs();
        return debugConnectArgArray;
    }

    protected String findHostValue(DebugConnectArg[] debugConnectArgArray) {
        DebugConnectArg debugConnectArg = DebugShared.findConnectArg(debugConnectArgArray, "hostname");
        if (debugConnectArg != null) {
            String string = debugConnectArg.getValue();
            if (string == null || string.length() == 0) {
                string = DbgArb.getString(239);
            }
            return string;
        }
        int n = debugConnectArgArray.length;
        if (n >= 2) {
            int n2 = n - 2;
            String string = debugConnectArgArray[n2].getValue();
            if (string == null || string.length() == 0) {
                string = DbgArb.getString(239);
            }
            return string;
        }
        return "";
    }

    private String findPortValue(DebugConnectArg[] debugConnectArgArray) {
        DebugConnectArg debugConnectArg = DebugShared.findConnectArg(debugConnectArgArray, "port");
        if (debugConnectArg != null) {
            return debugConnectArg.getValue();
        }
        int n = debugConnectArgArray.length;
        if (n >= 1) {
            int n2 = n - 1;
            return debugConnectArgArray[n2].getValue();
        }
        return "";
    }

    protected boolean isRemoteDebuggingProfiling() {
        return this.runConfiguration.isRemoteDebuggingProfiling();
    }

    private void connectLocalDebugging() {
        13 var1_1 = new 13();
        DebugConnector debugConnector = null;
        try {
            debugConnector = DebugFactory.newInstance(this.getDebuggerFactory());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            var1_1.run();
            return;
        }
        DebugConnectArg[] debugConnectArgArray = debugConnector.getConnectArgs();
        DebugConnectArg debugConnectArg = DebugShared.findConnectArg(debugConnectArgArray, "port");
        if (debugConnectArg != null) {
            debugConnectArg.setValue(this.localPort);
        }
        12 var6_6 = new 12();
        11 var7_7 = new 11();
        String string = null;
        String string2 = DbgArb.getString(204);
        this.connectToDebuggee(debugConnector, debugConnectArgArray, string, string2, var6_6, var1_1, var7_7);
    }

    void connectToDebuggee(DebugConnector debugConnector, DebugConnectArg[] debugConnectArgArray, String string, String string2, Runnable runnable, Runnable runnable2, Runnable runnable3) {
        DebuggingProcess.showStatus(DbgArb.getString(229));
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            this.log(stringBuffer);
        }
        int n = DebugWindowSettings.getInstance().getConnectionRetries();
        this.setLogPageNorthComponent();
        this.connectionThread = new 10(this, "DebugConnection", debugConnector, debugConnectArgArray, string2, runnable, string, n, runnable3, runnable2);
        JDebugger.getInstance().debuggingProcessBeforeConnecting(this);
        this.connectionThread.start();
    }

    boolean canCancelConnection() {
        return this.connectionThread != null;
    }

    void cancelConnection() {
        Thread thread = this.connectionThread;
        if (thread != null) {
            this.log(new StringBuffer(DbgArb.getString(207)));
            thread.interrupt();
        }
    }

    private String isApplicationServer() {
        boolean bl = false;
        DebugClassInfo[] debugClassInfoArray = this.vm.listClasses(true);
        int n = 0;
        while (n < debugClassInfoArray.length) {
            String string;
            DebugClassInfo debugClassInfo = debugClassInfoArray[n];
            if (debugClassInfo.isObject() && !(string = debugClassInfo.getName()).startsWith("java") && !string.startsWith("sun")) {
                if (string.equals("com.evermind.server.OC4JServer")) {
                    return DbgArb.getString(214);
                }
                if (string.startsWith("org.jboss.")) {
                    return DbgArb.getString(216);
                }
                if (string.startsWith("com.ibm.websphere.")) {
                    return DbgArb.getString(220);
                }
                if (string.startsWith("weblogic.")) {
                    return DbgArb.getString(219);
                }
                if (string.startsWith("org.apache.tomcat.")) {
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            return DbgArb.getString(218);
        }
        return null;
    }

    void afterConnection(String string) {
        String string2;
        this.disconnectedMessage = string;
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        super.started();
        if (this.xsltDebugging) {
            this.showXSLTInput();
        }
        if (this.isRemoteDebuggingProfiling() && this.vm.wasRunning() && (string2 = this.isApplicationServer()) != null) {
            this.log(DbgArb.format(221, string2));
            this.log(DbgArb.getString(222));
        }
        this.vm.addDebugListener(this);
        this.vm.addBreakpointLogListener(this);
        this.setTracing();
        this.vm.setPauseInterval(100);
        this.stopped = true;
        List[] listArray = Breakpoint.getBreakpoints(this.getWorkspace(), this.getProject());
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : listArray[n2]) {
                breakpoint.putBreakpoint(this);
            }
            ++n2;
        }
        this.stopped = false;
        if (this.timeBeforeConnect != 0L) {
            this.timeAfterConnect = System.currentTimeMillis();
        }
        this.sendDebuggerEvent(1, 100);
        String string3 = DebugWindowSettings.getInstance().getStartOption();
        if (string3.equals("stepover")) {
            this.vm.start(true);
        } else if (string3.equals("stepinto")) {
            this.vm.start(false);
        } else {
            this.vm.resume();
        }
        this.setLogPageNorthComponent();
        JDebugger.getInstance().debuggingProcessStarted(this);
        waitCursor.hide();
        Runner.getRunner().selectProcess((RunProcess)this);
    }

    private void sendDebuggerEvent(int n, int n2) {
        block13: {
            try {
                if (this.debuggerEventSource == null) {
                    this.debuggerEventSource = new EventSource();
                }
                this.debuggerEventSource.eventOccurring(n, n2);
                DebuggerAdapter[] debuggerAdapterArray = JDebugger.getInstance().getDebuggerListeners();
                if (debuggerAdapterArray.length <= 0) break block13;
                DebuggerEvent debuggerEvent = new DebuggerEvent((Object)this.debuggerEventSource, n);
                switch (n) {
                    case 1: {
                        int n3 = 0;
                        while (n3 < debuggerAdapterArray.length) {
                            debuggerAdapterArray[n3].debuggerStarted(debuggerEvent);
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        int n4 = 0;
                        while (n4 < debuggerAdapterArray.length) {
                            debuggerAdapterArray[n4].debuggerStopping(debuggerEvent);
                            ++n4;
                        }
                        break;
                    }
                    case 3: {
                        int n5 = 0;
                        while (n5 < debuggerAdapterArray.length) {
                            debuggerAdapterArray[n5].debuggerResuming(debuggerEvent);
                            ++n5;
                        }
                        break;
                    }
                    case 4: {
                        int n6 = 0;
                        while (n6 < debuggerAdapterArray.length) {
                            debuggerAdapterArray[n6].debuggerFinished(debuggerEvent);
                            ++n6;
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean canSetTracing() {
        try {
            boolean bl = this.vm != null && this.vm.getCapabilities().canSetDebuggablePackages();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void setTracing() {
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        this.vm.setDebuggablePackages(debugConfiguration.getTracingInclude(), debugConfiguration.getTracingExclude());
    }

    protected final List getTracingIncludeList() {
        return this.getDebugConfiguration().getTracingIncludeList();
    }

    protected final List getTracingExcludeList() {
        return this.getDebugConfiguration().getTracingExcludeList();
    }

    public boolean canTerminate() {
        if (this.vm != null) {
            return true;
        }
        return super.canTerminate();
    }

    public void started() {
    }

    void accept(DebugVirtualMachine debugVirtualMachine, DebugConnectArg[] debugConnectArgArray) {
        String string;
        String string2;
        this.skipCompile = true;
        this.vm = debugVirtualMachine;
        String string3 = this.findPortValue(debugConnectArgArray);
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.connectionAccepted();
            string2 = DbgArb.format(226, string3);
            string = DbgArb.getString(201);
        } else {
            string2 = DbgArb.format(227, string3);
            string = DbgArb.getString(212);
        }
        this.log(string2);
        MessagePage messagePage = null;
        LogPage logPage = this.getLogPage();
        if (logPage instanceof MessagePage) {
            messagePage = (MessagePage)logPage;
        }
        debugVirtualMachine.afterConnection(messagePage);
        this.afterConnection(string);
    }

    void listenerStopped() {
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.listenerStopped();
        }
    }

    public void programStopped() {
        SwingUtilities.invokeLater(new 9());
    }

    public void breakpointChanged(DebugBreakpoint debugBreakpoint) {
        SwingUtilities.invokeLater(new 8(this, debugBreakpoint));
    }

    public void programTerminating() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void programTerminated() {
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        SwingUtilities.invokeLater(new 7());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionLost() {
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        SwingUtilities.invokeLater(new 6());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logBreakpoint(DebugBreakpoint debugBreakpoint, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
        String string = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint breakpoint = JDebugger.getInstance().findBreakpoint(debugBreakpoint);
            string = breakpoint.logBreakpoint(this.vm, debugThreadInfo, debugStackFrameInfoArray);
        }
        this.logMessages();
        if (string != null) {
            this.logMessage(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logException(DebugBreakpoint debugBreakpoint, String string, String string2, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
        String string3 = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint breakpoint = JDebugger.getInstance().findBreakpoint(debugBreakpoint);
            string3 = breakpoint.logException(this.vm, debugThreadInfo, debugStackFrameInfoArray, string, string2);
        }
        this.logMessages();
        if (string3 != null) {
            this.logMessage(string3);
        }
    }

    public void logClassLoad(DebugBreakpoint debugBreakpoint, String string, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
    }

    public void logAllocation(DebugBreakpoint debugBreakpoint, DebugHeapObjectInfo debugHeapObjectInfo, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDeadlock(DebugBreakpoint debugBreakpoint, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
        String string = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint breakpoint = JDebugger.getInstance().findBreakpoint(debugBreakpoint);
            string = breakpoint.logDeadlock(this.vm, debugThreadInfo, debugStackFrameInfoArray);
        }
        this.logMessages();
        if (string != null) {
            this.logMessage(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logWatchpoint(DebugBreakpoint debugBreakpoint, DebugFieldInfo debugFieldInfo, DebugDataInfo debugDataInfo, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo[] debugStackFrameInfoArray) {
        String string = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint breakpoint = JDebugger.getInstance().findBreakpoint(debugBreakpoint);
            string = breakpoint.logWatchpoint(this.vm, debugThreadInfo, debugStackFrameInfoArray, debugFieldInfo, debugDataInfo);
        }
        this.logMessages();
        if (string != null) {
            this.logMessage(string);
        }
    }

    private void logMessage(String string) {
        this.waitForRedirectOutput();
        SwingUtilities.invokeLater(new 5(this, string));
    }

    DebugVirtualMachine getVM() {
        return this.vm;
    }

    DebugThreadInfo[][] getDeadlocks() {
        if (this.deadlocks == null) {
            this.deadlocks = this.vm.getDeadlockedThreads();
        }
        return this.deadlocks;
    }

    boolean isStopped() {
        return this.vm != null && this.stopped && !this.resuming;
    }

    private boolean isLocationDebuggable() {
        DebugClassInfo debugClassInfo;
        return this.currentLocation != null && (debugClassInfo = this.currentLocation.getClassInfo()).isDebuggable();
    }

    void stackFramesPopped(DebugThreadInfo debugThreadInfo) {
        if (debugThreadInfo == this.currentThread) {
            this.updateCurrentLocation(true);
        }
        JDebugger.getInstance().stackFramesPopped();
    }

    void setCurrentThread(DebugThreadInfo debugThreadInfo) {
        this.setCurrentThread(debugThreadInfo, true);
    }

    private static boolean isThreadGood(DebugThreadInfo debugThreadInfo) {
        int n = debugThreadInfo.getStatus();
        return (n == 2 || n == 3 || n == 4 || n == 5) && debugThreadInfo.getStackFrameCount() > 0;
    }

    private void setCurrentThread(DebugThreadInfo debugThreadInfo, boolean bl) {
        if (debugThreadInfo != null) {
            this.currentThread = debugThreadInfo;
        } else if (this.lastKnownGoodThread != null && DebuggingProcess.isThreadGood(this.lastKnownGoodThread)) {
            this.currentThread = this.lastKnownGoodThread;
        } else {
            DebugThreadInfo debugThreadInfo2 = null;
            DebugThreadInfo debugThreadInfo3 = null;
            DebugThreadInfo debugThreadInfo4 = null;
            DebugThreadInfo debugThreadInfo5 = null;
            DebugThreadInfo[] debugThreadInfoArray = this.vm.listThreads();
            int n = debugThreadInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugThreadInfo debugThreadInfo6 = debugThreadInfoArray[n2];
                if (debugThreadInfo6.getGroupName().equals("main")) {
                    String string = debugThreadInfo6.getName();
                    if (debugThreadInfo2 == null && string.equals("main")) {
                        if (DebuggingProcess.isThreadGood(debugThreadInfo6)) {
                            debugThreadInfo2 = debugThreadInfo6;
                        }
                    } else if (debugThreadInfo3 == null && string.startsWith("AWT-Event")) {
                        if (DebuggingProcess.isThreadGood(debugThreadInfo6)) {
                            debugThreadInfo3 = debugThreadInfo6;
                        }
                    } else if (debugThreadInfo4 == null && DebuggingProcess.isThreadGood(debugThreadInfo6)) {
                        debugThreadInfo4 = debugThreadInfo6;
                    }
                } else if (debugThreadInfo5 == null && DebuggingProcess.isThreadGood(debugThreadInfo6)) {
                    debugThreadInfo5 = debugThreadInfo6;
                }
                ++n2;
            }
            if (debugThreadInfo2 != null) {
                this.currentThread = debugThreadInfo2;
            } else if (debugThreadInfo3 != null) {
                this.currentThread = debugThreadInfo3;
            } else if (debugThreadInfo4 != null) {
                this.currentThread = debugThreadInfo4;
            } else if (debugThreadInfo5 != null) {
                this.currentThread = debugThreadInfo5;
            }
        }
        if (this.currentThread != null) {
            this.lastKnownGoodThread = this.currentThread;
        }
        this.updateCurrentLocation(bl);
    }

    private void updateCurrentLocation(boolean bl) {
        if (bl) {
            this.hideSourceIPIcon();
        }
        this.currentStackFrame = null;
        this.currentLocation = null;
        if (this.currentThread != null) {
            this.currentStackFrame = DebuggingProcess.getNonNativeStackFrame(this.currentThread);
            DebugLocation debugLocation = this.currentLocation = this.currentStackFrame != null ? this.currentStackFrame.getLocation() : null;
        }
        if (bl) {
            this.showSourceIPIcon(true);
            SmartWindow smartWindow = JDebugger.getInstance().getSmartWindow(false);
            if (smartWindow != null) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            }
        }
    }

    boolean isCurrentThread(DebugThreadInfo debugThreadInfo) {
        return this.currentThread != null && this.currentThread.equals(debugThreadInfo);
    }

    public void superTerminate() {
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.starter != null && this.starter.canTerminateGracefully()) {
            if (this.vm != null) {
                this.sendDebuggerEvent(4, 402);
                this.debuggeeResuming(false, true);
                this.vm.disconnect(false);
                Object object = this.vmSync;
                synchronized (object) {
                    this.vm = null;
                }
                this.clearLogPageToolbar();
            }
            this.starter.terminateGracefully();
            return;
        }
        if (this.vm != null) {
            if (this.isRemoteDebuggingProfiling() && this.vm.wasRunning()) {
                String[] stringArray = new String[]{DbgArb.getString(827), DbgArb.getString(828), DbgArb.getString(829), DbgArb.getString(830)};
                Object[] objectArray = new String[]{DbgArb.getString(831), DbgArb.getString(832), DbgArb.getString(833)};
                int n = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), stringArray, DbgArb.getString(826), -1, 2, null, objectArray, objectArray[0]);
                if (n == -1 || n == 2) {
                    return;
                }
                if (n == 0) {
                    this.detach();
                    return;
                }
            }
            this.sendDebuggerEvent(4, 402);
            this.debuggeeResuming(false, true);
            DebugVirtualMachine debugVirtualMachine = this.vm;
            4 var5_6 = new 4(this, "DebugDisconnect", debugVirtualMachine);
            Object object = this.vmSync;
            synchronized (object) {
                this.vm = null;
            }
            this.clearLogPageToolbar();
            if (this.isRemoteDebuggingProfiling()) {
                this.finished();
            }
            var5_6.start();
        } else {
            super.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        BytecodeFileSystemHelper bytecodeFileSystemHelper = BytecodeFileSystemHelper.getInstance(false);
        if (bytecodeFileSystemHelper != null) {
            bytecodeFileSystemHelper.removeStaleMethods();
        }
        DebuggingProcess.clearStatus();
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.finished();
        }
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        this.lastKnownGoodThread = null;
        if (this.disconnectedMessage != null) {
            this.logMessage(this.disconnectedMessage);
            this.disconnectedMessage = null;
        }
        List[] listArray = Breakpoint.getBreakpoints(this.getWorkspace(), this.getProject());
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint : listArray[n2]) {
                breakpoint.processFinished(this);
            }
            ++n2;
        }
        this.clearLogPageNorthComponent();
        JDebugger.getInstance().debuggingProcessFinished(this);
        super.finished();
    }

    protected void showSourceFile(DebugLocation debugLocation, boolean bl) {
        if (debugLocation != null) {
            int n = debugLocation.getLine();
            if (n != 0) {
                DebugClassInfo debugClassInfo = debugLocation.getClassInfo();
                String string = debugLocation.getFilename();
                this.showSourceFile(debugClassInfo, string, n, bl);
            } else {
                this.showSourceFile(debugLocation.getMethod());
            }
        }
    }

    protected void showSourceFile(DebugMethodInfo debugMethodInfo) {
        try {
            SourceClass sourceClass;
            String string = debugMethodInfo.getClassInfo().getName();
            String string2 = debugMethodInfo.getNameWithoutClassOrSignature();
            String string3 = debugMethodInfo.getName();
            Project project = this.getJProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaClass javaClass = javaManager.getClass(string);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
                if (string2.equals("<clinit>")) {
                    JavaMethod javaMethod = javaClass.getClinitMethod();
                    if (javaMethod instanceof SourceMethod) {
                        SourceMethod sourceMethod = (SourceMethod)javaMethod;
                        URL uRL = sourceClass.getURL();
                        int n = -sourceMethod.getStartOffset();
                        SourceName sourceName = sourceMethod.getNameElement();
                        if (sourceName != null) {
                            n = -sourceName.getStartOffset();
                        }
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), uRL, n, true);
                        return;
                    }
                    List list = sourceClass.getSourceInitializers();
                    if (list != null && list.size() > 0) {
                        SourceClassInitializer sourceClassInitializer = (SourceClassInitializer)list.get(0);
                        URL uRL = sourceClass.getURL();
                        int n = -sourceClassInitializer.getStartOffset();
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), uRL, n, true);
                        return;
                    }
                }
                ArrayList<JavaMethod> arrayList = null;
                if (string2.equals("<init>")) {
                    arrayList = sourceClass.getDeclaredConstructors();
                } else {
                    Collection collection = sourceClass.getDeclaredMethods();
                    if (collection != null && collection.size() > 0) {
                        arrayList = new ArrayList<JavaMethod>();
                        for (JavaMethod javaMethod : collection) {
                            if (!javaMethod.getName().equals(string2)) continue;
                            arrayList.add(javaMethod);
                        }
                    }
                }
                if (arrayList != null) {
                    int n = string3.indexOf(40);
                    ++n;
                    for (Object e : arrayList) {
                        if (!(e instanceof SourceMethod)) continue;
                        SourceMethod sourceMethod = (SourceMethod)e;
                        boolean bl = true;
                        Iterator iterator = sourceMethod.getParameters().iterator();
                        while (iterator.hasNext()) {
                            String string4 = ((JavaVariable)iterator.next()).getResolvedType().getQualifiedName();
                            if (!string3.startsWith(string4, n)) {
                                bl = false;
                                break;
                            }
                            if (string3.charAt(n += string4.length()) != ',') continue;
                            ++n;
                        }
                        if (string3.charAt(n) != ')') {
                            bl = false;
                        }
                        if (!bl) continue;
                        URL uRL = sourceClass.getURL();
                        int n2 = -sourceMethod.getStartOffset();
                        SourceName sourceName = sourceMethod.getNameElement();
                        if (sourceName != null) {
                            n2 = -sourceName.getStartOffset();
                        }
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), uRL, n2, true);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 1;
        int[] nArray = debugMethodInfo.getMethodLineRange();
        if (nArray != null) {
            n = nArray[0];
        }
        DebugClassInfo debugClassInfo = debugMethodInfo.getClassInfo();
        this.showSourceFile(debugClassInfo, debugClassInfo.getPrimarySourceFilename(), n, false);
    }

    protected void showSourceFile(DebugFieldInfo debugFieldInfo) {
        try {
            JavaField javaField;
            SourceClass sourceClass;
            String string = debugFieldInfo.getDeclaringClassInfo().getName();
            String string2 = debugFieldInfo.getName();
            Project project = this.getJProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaClass javaClass = javaManager.getClass(string);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null && (javaField = sourceClass.getDeclaredField(string2)) instanceof SourceElement) {
                SourceName sourceName;
                SourceElement sourceElement = (SourceElement)javaField;
                URL uRL = sourceClass.getURL();
                int n = -sourceElement.getStartOffset();
                if (sourceElement instanceof SourceHasName && (sourceName = ((SourceHasName)sourceElement).getNameElement()) != null) {
                    n = -sourceName.getStartOffset();
                }
                Source.showSourceFile(this.getWorkspace(), this.getProject(), uRL, n, true);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DebugClassInfo debugClassInfo = debugFieldInfo.getDeclaringClassInfo();
        this.showSourceFile(debugClassInfo, debugClassInfo.getPrimarySourceFilename(), 1, false);
    }

    protected void showSourceFile(DebugClassInfo debugClassInfo) {
        try {
            SourceClass sourceClass;
            String string = debugClassInfo.getName();
            Project project = this.getJProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaClass javaClass = javaManager.getClass(string);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
                URL uRL = sourceClass.getURL();
                SourceName sourceName = sourceClass.getNameElement();
                int n = sourceName != null ? -sourceName.getStartOffset() : -sourceClass.getStartOffset();
                Source.showSourceFile(this.getWorkspace(), this.getProject(), uRL, n, true);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DebugMethodInfo[] debugMethodInfoArray = debugClassInfo.getMethods();
        if (debugMethodInfoArray != null) {
            int n = debugMethodInfoArray.length;
            DebugLocation debugLocation = null;
            int n2 = 0;
            while (n2 < n) {
                DebugLocation debugLocation2 = debugMethodInfoArray[n2].getFirstLocation();
                if (debugLocation2 != null) {
                    int n3 = debugLocation2.getLine();
                    if (debugLocation == null || n3 != 0 && n3 < debugLocation.getLine()) {
                        debugLocation = debugLocation2;
                    }
                }
                ++n2;
            }
            if (debugLocation != null) {
                this.showSourceFile(debugLocation, false);
                return;
            }
        }
        this.showSourceFile(debugClassInfo, debugClassInfo.getPrimarySourceFilename(), 1, false);
    }

    private Node findSourceFile(DebugClassInfo debugClassInfo, String string) {
        try {
            if (debugClassInfo != null && string != null && string.length() > 0) {
                Node node;
                String string2 = debugClassInfo.getPackage();
                Workspace workspace = this.getWorkspace();
                Project project = this.getProject();
                URL uRL = null;
                if (this.databaseDebugging) {
                    uRL = this.databaseDebuggingHelper.findSourceFile(workspace, project, string2, string);
                }
                if (uRL == null) {
                    uRL = Source.findSourceFile(workspace, project, string2, string);
                }
                if (uRL != null && (node = NodeFactory.findOrCreate(uRL)) != null) {
                    Node node2 = node;
                    return node2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected Node showSourceFile(DebugClassInfo debugClassInfo, String string, int n, boolean bl) {
        return this.showSourceFile(debugClassInfo, string, n, bl, null);
    }

    protected Node showSourceFile(DebugClassInfo debugClassInfo, String string, int n, boolean bl, String string2) {
        if (debugClassInfo != null) {
            Node node = this.findSourceFile(debugClassInfo, string);
            if (node != null && Source.showSourceFile(this.getWorkspace(), this.getProject(), node, n, bl)) {
                return node;
            }
            Source.showSourceFile(this.getWorkspace(), this.getProject(), debugClassInfo.getPackage(), debugClassInfo.getName(), string, n, bl, string2);
        }
        return null;
    }

    private void showXSLTInput() {
        try {
            if (this.xsltInputNode != null) {
                Source.showNodeInDefaultEditor(this.getWorkspace(), this.getProject(), this.xsltInputNode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showXSLTOutput() {
        try {
            CodeEditor codeEditor;
            if (this.xsltOutputNode != null) {
                if (this.xsltOutputNode.isOpen()) {
                    RevertNodeCommand.reload((Node)this.xsltOutputNode);
                }
                if (this.xsltOutputEditor == null) {
                    this.xsltOutputEditor = Source.showNodeInDefaultEditor(this.getWorkspace(), this.getProject(), this.xsltOutputNode);
                }
            }
            if (this.xsltOutputEditor instanceof CodeEditor && (codeEditor = (CodeEditor)this.xsltOutputEditor).getGUI() != null && codeEditor.isVisible()) {
                codeEditor.gotoLine(codeEditor.getLineCount(), 0, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showSourceIPIcon(boolean bl) {
        this.showSourceIPIcon(bl, null);
    }

    private void showSourceIPIcon(boolean bl, String string) {
        boolean bl2 = false;
        try {
            if (this.currentLocation != null) {
                int n = this.currentLocation.getLine();
                if (n > 0) {
                    DebugClassInfo debugClassInfo = this.currentLocation.getClassInfo();
                    String string2 = this.currentLocation.getFilename();
                    Node node = null;
                    node = bl ? this.showSourceFile(debugClassInfo, string2, n, false, string) : this.findSourceFile(debugClassInfo, string2);
                    if (string2.length() > 0) {
                        String string3 = debugClassInfo.getPackage();
                        Workspace workspace = this.getWorkspace();
                        URL uRL = workspace != null && workspace != Ide.getDefaultWorkspace() ? workspace.getURL() : null;
                        this.sourceIconForIP = new SourceIcon(uRL, null, string3, string2, n, node, DbgArb.getInstance(), 567, SourceIcon.ipStyle, 2, null);
                    }
                } else {
                    bl2 = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showSourceIconForIPBytecode(bl && bl2);
    }

    void showSourceIconForIPBytecode(boolean bl) {
        block5: {
            try {
                int n;
                URL uRL;
                int n2;
                BytecodeFileSystemHelper bytecodeFileSystemHelper;
                if (this.sourceIconForIPBytecode != null || this.currentLocation == null || (bytecodeFileSystemHelper = BytecodeFileSystemHelper.getInstance(false)) == null || (n2 = this.currentLocation.getBytecodeOffset()) == -1) break block5;
                DebugMethodInfo debugMethodInfo = this.currentLocation.getMethod();
                if (bl) {
                    this.showBytecode(debugMethodInfo, n2);
                    if (this.sourceIconForIPBytecode != null) {
                        return;
                    }
                }
                if ((uRL = bytecodeFileSystemHelper.getURL(this, debugMethodInfo)) == null || (n = bytecodeFileSystemHelper.getLineFromBytecodeOffset(uRL, n2)) == 0) break block5;
                Node node = NodeFactory.find((URL)uRL);
                Workspace workspace = this.getWorkspace();
                URL uRL2 = workspace != null && workspace != Ide.getDefaultWorkspace() ? workspace.getURL() : null;
                this.sourceIconForIPBytecode = new SourceIcon(uRL2, null, uRL, n, node, DbgArb.getInstance(), 567, SourceIcon.ipStyle, 2, null);
                if (node == null) break block5;
                Context context = Context.newIdeContext((Node)node);
                Project project = this.getProject();
                List list = EditorManager.getEditorManager().findEditors(context);
                if (list == null) break block5;
                for (Object e : list) {
                    if (!(e instanceof CodeEditor)) continue;
                    Source.showSourceFile(workspace, project, node, n, false);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    SourceIcon getSourceIconForIP() {
        return this.sourceIconForIP;
    }

    void showBytecode(DebugMethodInfo debugMethodInfo, int n) {
        BytecodeFileSystemHelper bytecodeFileSystemHelper = BytecodeFileSystemHelper.getInstance(true);
        URL uRL = bytecodeFileSystemHelper.addMethod(this, debugMethodInfo);
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node != null) {
                Workspace workspace = this.getWorkspace();
                Project project = this.getProject();
                int n2 = bytecodeFileSystemHelper.getLineFromBytecodeOffset(uRL, n);
                Source.showSourceFile(workspace, project, node, n2, false);
                this.showSourceIconForIPBytecode(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void hideSourceIPIcon() {
        if (this.sourceIconForIP != null) {
            this.sourceIconForIP.hide();
            this.sourceIconForIP = null;
        }
        if (this.sourceIconForIPBytecode != null) {
            this.sourceIconForIPBytecode.hide();
            this.sourceIconForIPBytecode = null;
        }
    }

    private void debuggeeResuming(boolean bl, boolean bl2) {
        int n = -1;
        if (ProfilingEvents.eventOn[6]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[6]);
        }
        if (this.timerTaskUpdateNormalWindows != null) {
            this.timerTaskUpdateNormalWindows.cancel();
            this.timerTaskUpdateNormalWindows = null;
        }
        if (this.timerTaskUpdateOtherWindows != null) {
            this.timerTaskUpdateOtherWindows.cancel();
            this.timerTaskUpdateOtherWindows = null;
        }
        this.stepRequestTime = 0L;
        this.resuming = true;
        JDebugger jDebugger = JDebugger.getInstance();
        if (jDebugger.isActiveDebuggingProcess(this)) {
            this.hideSourceIPIcon();
            ThreadsWindow threadsWindow = jDebugger.getThreadsWindow(true);
            SmartWindow smartWindow = jDebugger.getSmartWindow(false);
            ClassesWindow classesWindow = jDebugger.getClassesWindow(false);
            HeapWindow heapWindow = jDebugger.getHeapWindow(false);
            MonitorsWindow monitorsWindow = jDebugger.getMonitorsWindow(false);
            if (bl2) {
                threadsWindow.updateThreads(this, null, null);
                if (smartWindow != null) {
                    smartWindow.updateData(this, null, null, null);
                }
                if (classesWindow != null) {
                    classesWindow.updateClasses(this, null);
                }
                if (heapWindow != null) {
                    heapWindow.updateData(this, null, null, null);
                }
                if (monitorsWindow != null) {
                    monitorsWindow.updateMonitors(this, null);
                }
            } else {
                threadsWindow.clearThreads();
                if (smartWindow != null) {
                    smartWindow.clearData();
                }
                if (classesWindow != null) {
                    classesWindow.clearClasses();
                }
                if (heapWindow != null) {
                    heapWindow.clearData();
                }
                if (monitorsWindow != null) {
                    monitorsWindow.clearMonitors();
                }
            }
        }
        this.currentThread = null;
        this.currentStackFrame = null;
        this.currentLocation = null;
        this.deadlocks = null;
        this.stepping = bl;
        if (ProfilingEvents.eventOn[6]) {
            IdeProfile.endEvent((int)n);
        }
    }

    private void debuggeeResumed() {
        this.resuming = false;
        this.stopped = false;
        this.checkCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeProgramStopped() {
        DebuggingProcess.clearStatus();
        if (this.xsltDebugging) {
            this.showXSLTOutput();
        }
        boolean bl = true;
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            if (this.runAfterPausedList.size() > 0) {
                bl = false;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            try {
                this.debuggeeStopped(bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.doRunAfterPause(true);
            return;
        }
    }

    private void debuggeeStopped(boolean bl) {
        int n = -1;
        if (ProfilingEvents.eventOn[1]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[1]);
        }
        this.stopped = true;
        if (this.runToCursor != null) {
            this.runToCursor.remove();
            this.runToCursor = null;
        }
        Ide.getMainWindow().toFront();
        try {
            this.setCurrentThread(this.vm.getCurrentThread(), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JDebugger jDebugger = JDebugger.getInstance();
        int n2 = this.vm.getCurrentStatus();
        BytecodeFileSystemHelper bytecodeFileSystemHelper = BytecodeFileSystemHelper.getInstance(false);
        if (bytecodeFileSystemHelper != null) {
            bytecodeFileSystemHelper.updateMethods(this);
        }
        if (jDebugger.isActiveDebuggingProcess(this)) {
            try {
                boolean bl2 = true;
                String string = null;
                switch (n2) {
                    case 1: {
                        string = DbgArb.getString(355);
                        break;
                    }
                    case 2: {
                        string = DbgArb.getString(356);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        string = DbgArb.getString(357);
                        break;
                    }
                    case 7: {
                        string = DbgArb.getString(358);
                        break;
                    }
                    case 8: {
                        bl2 = false;
                        break;
                    }
                    case 10: {
                        string = DbgArb.getString(359);
                    }
                }
                this.showSourceIPIcon(bl2, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (n2 != 8 && this.currentLocation != null && !this.isLocationDebuggable() && this.vm.getCapabilities().canSetDebuggablePackages()) {
                    String string = DbgArb.format(878, this.runConfiguration.getName(), DbgArb.getString(19));
                    string = string + DbgArb.getString(880);
                    if (!this.runConfiguration.isCustom()) {
                        string = string + DbgArb.format(881, this.runConfiguration.getName());
                    }
                    string = string + DbgArb.getString(882);
                    String string2 = this.getLogPage().getTitleName();
                    boolean bl3 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)string2, null);
                    if (bl3) {
                        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
                        TracingPanel.showTracingDialog(debugConfiguration);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.checkCommands();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.classLoadTracking();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: {
                    this.sendDebuggerEvent(2, 200);
                    break;
                }
                case 7: {
                    this.sendDebuggerEvent(2, 201);
                    break;
                }
                case 8: {
                    this.sendDebuggerEvent(2, 202);
                }
            }
            try {
                boolean bl4 = this.timeWindowsUpdated != 0L && false;
                this.updateNormalWindows();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (this.timeWindowsUpdated != 0L && bl) {
                    this.timerTaskUpdateOtherWindows = new 2();
                    if (timer == null) {
                        timer = new NamedTimer("DebuggingProcessTimer");
                    }
                    timer.schedule(this.timerTaskUpdateOtherWindows, 500L);
                } else {
                    this.updateOtherWindows();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            if (n2 == 5) {
                jDebugger.viewMonitors();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.timeWindowsUpdated == 0L) {
            this.timeWindowsUpdated = System.currentTimeMillis();
            long l = this.getTimeAfterCompile();
        }
        if (this.checkForPotentialClipboardDeadlock()) {
            this.resume();
        }
        if (ProfilingEvents.eventOn[1]) {
            IdeProfile.endEvent((int)n);
        }
    }

    private void updateNormalWindows() {
        JDebugger jDebugger = JDebugger.getInstance();
        try {
            jDebugger.getThreadsWindow(true).updateThreads(this, this.vm, this.currentThread);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SmartWindow smartWindow = jDebugger.getSmartWindow(false);
            if (smartWindow != null) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateNormalWindowsEndTime = System.currentTimeMillis();
    }

    private void updateOtherWindows() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        JDebugger jDebugger = JDebugger.getInstance();
        ClassesWindow classesWindow = jDebugger.getClassesWindow(false);
        if (classesWindow != null) {
            classesWindow.updateClasses(this, this.vm);
        }
        if ((heapWindow = jDebugger.getHeapWindow(false)) != null) {
            heapWindow.updateData(this, this.vm, null, null);
        }
        if ((monitorsWindow = jDebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.updateMonitors(this, this.vm);
        }
    }

    private void classLoadTracking() {
        if (classLoadTracking == -1) {
            String string = Ide.getProperty((String)"DebuggerClassLoadTracking");
            classLoadTracking = string != null ? DebuggingProcess.parsePrint(string) : 0;
        }
        if (classLoadTracking != 0 && this.vm.countClasses() != this.loadedClassesCount) {
            DebugClassInfo[] debugClassInfoArray = this.vm.listClasses();
            int n = debugClassInfoArray.length;
            String string = this.loadedClassesCount == 0 ? DbgArb.format(863, Integer.toString(n)) : DbgArb.format(864, Integer.toString(n - this.loadedClassesCount));
            this.print(classLoadTracking, string);
            int n2 = n - this.loadedClassesCount;
            Object[] objectArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = debugClassInfoArray[n3 + this.loadedClassesCount].getName();
                ++n3;
            }
            Arrays.sort(objectArray);
            int n4 = 0;
            while (n4 < n2) {
                string = DbgArb.format(865, objectArray[n4]);
                this.print(classLoadTracking, string);
                ++n4;
            }
            this.loadedClassesCount = n;
            if (this.currentLocation != null) {
                String string2 = this.currentLocation.getFilename();
                int n5 = this.currentLocation.getLine();
                string = DbgArb.format(867, Integer.toString(n5), string2, Integer.toString(this.loadedClassesCount));
            } else {
                string = DbgArb.format(866, Integer.toString(this.loadedClassesCount));
            }
            this.print(classLoadTracking, string);
        }
    }

    private static int parsePrint(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;| \t");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("System.out")) {
                n |= 1;
                continue;
            }
            if (string.equalsIgnoreCase("System.err")) {
                n |= 2;
                continue;
            }
            if (!string.equalsIgnoreCase("LogWindow")) continue;
            n |= 4;
        }
        return n;
    }

    private void print(int n, String string) {
        if ((n & 1) != 0) {
            System.out.println(string);
        }
        if ((n & 2) != 0) {
            System.err.println(string);
        }
        if ((n & 4) != 0) {
            this.log(string);
        }
    }

    protected void checkCommands() {
        JDebugger.getInstance().checkCommandsBecauseDebuggingProcessStateChanged(this);
    }

    public boolean canPause() {
        return this.pause(false);
    }

    protected void pause() {
        this.pause(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pause(boolean bl) {
        try {
            if (this.vm == null) return false;
            if (this.stopped) return false;
            if (!this.vm.getCapabilities().canPauseProgram()) return false;
            if (!bl) return true;
            boolean[] blArray = this.pause;
            synchronized (this.pause) {
                this.pause[1] = true;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.vm.pauseProgram();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canResume() {
        return this.resume(false);
    }

    protected void resume() {
        this.resume(true);
    }

    private boolean resume(boolean bl) {
        try {
            if (this.vm != null && this.stopped) {
                if (bl) {
                    this.sendDebuggerEvent(3, 300);
                    this.debuggeeResuming(false, false);
                    this.vm.resume();
                    this.debuggeeResumed();
                }
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canDetach() {
        return this.detach(false);
    }

    void detach() {
        this.detach(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detach(boolean bl) {
        block6: {
            try {
                if (this.vm == null || !this.isRemoteDebuggingProfiling()) break block6;
                if (bl) {
                    this.sendDebuggerEvent(4, 403);
                    this.debuggeeResuming(false, true);
                    this.vm.disconnect(false);
                    Object object = this.vmSync;
                    synchronized (object) {
                        this.vm = null;
                    }
                    this.finished();
                }
                boolean bl2 = true;
                return bl2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    boolean canStepOver() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && this.isLocationDebuggable();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepOver(long l) {
        if (this.canStepOver()) {
            DebugThreadInfo debugThreadInfo = this.currentThread;
            this.sendDebuggerEvent(3, 301);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = l;
            debugThreadInfo.stepOver();
            this.debuggeeResumed();
        }
    }

    void stepOverBC(long l) {
        if (this.canStepOver()) {
            DebugThreadInfo debugThreadInfo = this.currentThread;
            this.sendDebuggerEvent(3, 301);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = l;
            debugThreadInfo.stepOverBC();
            this.debuggeeResumed();
        }
    }

    boolean canStepInto() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepInto(long l) {
        if (this.canStepInto()) {
            DebugThreadInfo debugThreadInfo = this.currentThread;
            this.sendDebuggerEvent(3, 302);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = l;
            debugThreadInfo.stepInto();
            this.debuggeeResumed();
        }
    }

    void stepIntoBC(long l) {
        if (this.canStepInto()) {
            DebugThreadInfo debugThreadInfo = this.currentThread;
            this.sendDebuggerEvent(3, 302);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = l;
            debugThreadInfo.stepIntoBC();
            this.debuggeeResumed();
        }
    }

    boolean canStepOut() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepOut(long l) {
        if (this.canStepOut()) {
            DebugThreadInfo debugThreadInfo = this.currentThread;
            this.sendDebuggerEvent(3, 303);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = l;
            debugThreadInfo.stepOut();
            this.debuggeeResumed();
        }
    }

    boolean canStepToEndOfMethod() {
        try {
            boolean bl = this.vm != null && this.stopped && this.vm.getCapabilities().canStepToEndOfMethod() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && this.isLocationDebuggable();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepToEndOfMethod(long l) {
        if (this.canStepToEndOfMethod()) {
            DebugThreadInfo debugThreadInfo = this.currentThread;
            this.sendDebuggerEvent(3, 304);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = l;
            debugThreadInfo.stepToEndOfMethod();
            this.debuggeeResumed();
        }
    }

    boolean canContinueStep() {
        if (this.xsltDebugging) {
            return false;
        }
        try {
            boolean bl = this.vm != null && this.stopped && this.vm.getCapabilities().canContinueStep() && this.stepping && !this.vm.didStepFinish();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void continueStep() {
        if (this.canContinueStep()) {
            this.sendDebuggerEvent(3, 305);
            this.debuggeeResuming(true, false);
            this.vm.continueStep();
            this.debuggeeResumed();
        }
    }

    boolean canRunToCursor(Context context) {
        return this.runToCursor(false, context);
    }

    void runToCursor(Context context) {
        this.runToCursor(true, context);
    }

    private boolean runToCursor(boolean bl, Context context) {
        try {
            String[] stringArray;
            int n;
            Node node;
            DebugLocation debugLocation;
            if (this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (debugLocation = this.currentLocation) != null && (node = Source.getNodeFromCodeEditor(context)) != null && (n = Source.getLineFromCodeEditor(context)) != 0 && (stringArray = this.node_to_packageAndFile(node)) != null && stringArray.length == 2) {
                if (bl) {
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    this.runToCursor = this.vm.putBreakpointPackageFileLine(string, string2, n);
                    if (this.runToCursor != null) {
                        this.sendDebuggerEvent(3, 306);
                        this.debuggeeResuming(false, false);
                        this.vm.resume();
                        this.debuggeeResumed();
                    }
                }
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canStepIntoMethodAtCursor(Context context) {
        return this.stepIntoMethodAtCursor(false, context);
    }

    void stepIntoMethodAtCursor(Context context) {
        this.stepIntoMethodAtCursor(true, context);
    }

    private boolean stepIntoMethodAtCursor(boolean bl, Context context) {
        try {
            SourceIcon sourceIcon;
            if (this.vm != null && this.stopped && context != null && this.currentLocation != null && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (sourceIcon = this.getSourceIconForIP()) != null) {
                CodeEditor codeEditor = sourceIcon.getCodeEditor();
                Node node = Source.getNodeFromCodeEditor(context);
                if (codeEditor != null && context.getView() == codeEditor && node instanceof JavaSourceNode) {
                    System.out.println("The context view is the same editor that has the ip icon.");
                    int n = codeEditor.getCaretLine();
                    DebugMethodInfo debugMethodInfo = this.currentLocation.getMethod();
                    int[] nArray = debugMethodInfo.getMethodLineRange();
                    if (nArray != null && nArray[0] <= n && n <= nArray[1]) {
                        SourceElement sourceElement;
                        System.out.println("The caret is on a line within the current method.");
                        int n2 = codeEditor.getCaretPosition();
                        JavaManager javaManager = JavaManager.getJavaManager(this.getJProject());
                        SourceFile sourceFile = javaManager.getSourceFile(node.getURL());
                        if (sourceFile != null && (sourceElement = sourceFile.getElementAt(n2)) instanceof SourceName) {
                            SourceName sourceName = (SourceName)sourceElement;
                            if ((sourceElement = sourceElement.getParent()) instanceof SourceMethodCallExpression) {
                                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                                System.out.println("The caret is on method call - " + sourceMethodCallExpression.getName());
                                if (bl) {
                                    SourceElement sourceElement2 = null;
                                    while (sourceElement != null) {
                                        if (sourceElement instanceof SourceStatement || sourceElement instanceof SourceVariableDeclaration) {
                                            sourceElement2 = sourceElement;
                                            break;
                                        }
                                        sourceElement = sourceElement.getParent();
                                    }
                                    if (sourceElement2 != null) {
                                        int n3 = sourceElement2.getStartOffset();
                                        int n4 = sourceElement2.getEndOffset();
                                        int n5 = sourceIcon.getLine();
                                        int n6 = JDebugger.getLineStartOffsetSkipWhite(codeEditor, n5);
                                        if (n6 < n3 || n6 >= n4) {
                                            System.out.println("The caret is not on IP statement.");
                                            int n7 = codeEditor.getLineFromOffset(n3);
                                            System.out.println("Need to execute to line " + n7);
                                        }
                                    }
                                }
                                boolean bl2 = true;
                                return bl2;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canSetNextStatement(Context context) {
        return this.setNextStatement(false, context);
    }

    void setNextStatement(Context context) {
        this.setNextStatement(true, context);
    }

    private boolean setNextStatement(boolean bl, Context context) {
        try {
            String[] stringArray;
            int n;
            Node node;
            DebugLocation debugLocation;
            DebugCapabilities debugCapabilities;
            if (this.vm != null && this.stopped && (debugCapabilities = this.vm.getCapabilities()).canSetLocation() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (debugLocation = this.currentLocation) != null && (node = Source.getNodeFromCodeEditor(context)) != null && (n = Source.getLineFromCodeEditor(context)) != 0 && (stringArray = this.node_to_packageAndFile(node)) != null && stringArray.length == 2) {
                String string = stringArray[0];
                String string2 = debugLocation.getClassInfo().getPackage();
                if (Source.packageMatches(string2, string)) {
                    DebugMethodInfo debugMethodInfo;
                    DebugLocation debugLocation2;
                    int n2;
                    String string3 = stringArray[1];
                    String string4 = debugLocation.getFilename();
                    if (string4.equals(string3) && n != (n2 = debugLocation.getLine()) && (debugLocation2 = (debugMethodInfo = debugLocation.getMethod()).getLocation(string3, n)) != null) {
                        SourceSynchStatement sourceSynchStatement;
                        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
                        JavaManager javaManager = JavaManager.getJavaManager(this.getJProject());
                        SourceFile sourceFile = javaManager.getSourceFile(node.getURL());
                        SourceSynchStatement sourceSynchStatement2 = this.getSourceSynchStatement(sourceFile, JDebugger.getLineStartOffsetSkipWhite(codeEditor, n2));
                        if (ModelUtil.areEqual((Object)sourceSynchStatement2, (Object)(sourceSynchStatement = this.getSourceSynchStatement(sourceFile, JDebugger.getLineStartOffsetSkipWhite(codeEditor, n))))) {
                            if (bl && this.currentThread.setLocation(debugLocation2)) {
                                this.hideSourceIPIcon();
                                this.currentStackFrame = DebuggingProcess.getNonNativeStackFrame(this.currentThread);
                                this.currentLocation = this.currentStackFrame != null ? this.currentStackFrame.getLocation() : null;
                                this.showSourceIPIcon(true);
                                JDebugger jDebugger = JDebugger.getInstance();
                                jDebugger.getThreadsWindow(true).updateThreads(this, this.vm, this.currentThread);
                                SmartWindow smartWindow = jDebugger.getSmartWindow(false);
                                if (smartWindow != null) {
                                    smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
                                }
                            }
                            boolean bl2 = true;
                            return bl2;
                        }
                        if (sourceSynchStatement2 != null) {
                            System.out.println("locationSync is from " + sourceSynchStatement2.getStartOffset() + " to " + sourceSynchStatement2.getEndOffset());
                        } else {
                            System.out.println("locationSync is null");
                        }
                        if (sourceSynchStatement != null) {
                            System.out.println("editorSync is from " + sourceSynchStatement.getStartOffset() + " to " + sourceSynchStatement.getEndOffset());
                        } else {
                            System.out.println("editorSync is null");
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private SourceSynchStatement getSourceSynchStatement(SourceFile sourceFile, int n) {
        if (sourceFile != null) {
            SourceElement sourceElement = sourceFile.getElementAt(n);
            while (sourceElement != null) {
                SourceSynchStatement sourceSynchStatement;
                SourceStatement sourceStatement;
                if (sourceElement instanceof SourceSynchStatement && (sourceStatement = (sourceSynchStatement = (SourceSynchStatement)sourceElement).getPrimaryClause()) != null && sourceStatement.getStartOffset() <= n && n < sourceStatement.getEndOffset()) {
                    return sourceSynchStatement;
                }
                sourceElement = sourceElement.getParent();
            }
        }
        return null;
    }

    boolean canShowIP() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentLocation != null && this.currentLocation.getLine() > 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void showIP() {
        if (this.canShowIP()) {
            this.showSourceFile(this.currentLocation, false);
        }
    }

    boolean canGC() {
        try {
            boolean bl = this.vm != null && this.stopped && this.vm.getCapabilities().canDoGarbageCollection();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void gc() {
        if (this.canGC()) {
            this.vm.doGarbageCollection();
            JDebugger.getInstance().dataHasBeenModified();
        }
    }

    void redefineClasses(Map map) {
        if (this.vm != null) {
            if (this.vm.getCapabilities().canRedefineClasses()) {
                String[] stringArray = this.vm.redefineClasses(map);
                if (stringArray == null) {
                    this.log(DbgArb.getString(873));
                    this.suggestPopFrame(map);
                } else {
                    DockUtil.showDockableWindow((DockableView)LogManager.getIdeLogWindow());
                    this.getLogPage().getLogPageView().show();
                    this.log(DbgArb.getString(874));
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        this.log("    " + stringArray[n2] + "\n");
                        ++n2;
                    }
                }
            } else {
                this.log(DbgArb.getString(872));
            }
        }
    }

    private void suggestPopFrame(Map map) {
        if (this.vm.getCurrentStatus() != 8) {
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = true;
            if (this.currentThread != null) {
                DebugStackFrameInfo[] debugStackFrameInfoArray = this.currentThread.listStack();
                int n = debugStackFrameInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    DebugClassInfo debugClassInfo;
                    DebugLocation debugLocation = debugStackFrameInfoArray[n2].getLocation();
                    if (debugLocation != null && (debugClassInfo = debugLocation.getClassInfo()) != null && map.containsKey(string = debugClassInfo.getName())) {
                        String string2 = DebugShared.makeCourtesyClassName(debugClassInfo, true);
                        String string3 = DbgArb.format(875, this.currentThread.getName(), string2);
                        if (!arrayList.contains(string3)) {
                            this.log(string3);
                            arrayList.add(string3);
                            if (n == 1) {
                                bl = false;
                            }
                        }
                    }
                    ++n2;
                }
            }
            if (!arrayList.isEmpty()) {
                if (bl) {
                    this.log(DbgArb.getString(876));
                } else {
                    this.log(DbgArb.getString(877));
                }
            }
        }
    }

    void classesWindowCreated(ClassesWindow classesWindow) {
        if (classesWindow != null) {
            if (this.vm != null && this.stopped) {
                classesWindow.updateClasses(this, this.vm);
            } else {
                classesWindow.updateClasses(this, null);
            }
        }
    }

    void smartWindowCreated(SmartWindow smartWindow) {
        if (smartWindow != null) {
            if (this.vm != null && this.stopped) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            } else {
                smartWindow.updateData(this, null, null, null);
            }
        }
    }

    void heapWindowCreated(HeapWindow heapWindow) {
        if (heapWindow != null) {
            if (this.vm != null && this.stopped) {
                heapWindow.updateData(this, this.vm, null, null);
            } else {
                heapWindow.updateData(this, null, null, null);
            }
        }
    }

    void monitorsWindowCreated(MonitorsWindow monitorsWindow) {
        if (monitorsWindow != null) {
            if (this.vm != null && this.stopped) {
                monitorsWindow.updateMonitors(this, this.vm);
            } else {
                monitorsWindow.updateMonitors(this, null);
            }
        }
    }

    private int getDebuggerFactory() {
        if (this.isRemoteDebuggingProfiling()) {
            DebugConfiguration debugConfiguration = this.getDebugConfiguration();
            String string = debugConfiguration.getRemoteProtocol();
            return DebugConfiguration.getDebuggerFactory(string);
        }
        if (this.databaseDebugging) {
            return this.databaseDebuggingHelper.getDebuggerFactory();
        }
        if (this.xsltDebugging) {
            return 1;
        }
        if (this.antDebugging) {
            return 4;
        }
        if (this.runConfiguration.usingOJVM(this.getJdkDefinition())) {
            return 0;
        }
        return 1;
    }

    static DebugLocation getNonNativeLocation(DebugThreadInfo debugThreadInfo) {
        DebugStackFrameInfo[] debugStackFrameInfoArray = debugThreadInfo.listStack();
        return DebuggingProcess.getNonNativeLocation(debugStackFrameInfoArray);
    }

    static DebugLocation getNonNativeLocation(DebugStackFrameInfo[] debugStackFrameInfoArray) {
        DebugStackFrameInfo debugStackFrameInfo = DebuggingProcess.getNonNativeStackFrame(debugStackFrameInfoArray);
        if (debugStackFrameInfo != null) {
            return debugStackFrameInfo.getLocation();
        }
        return null;
    }

    static DebugStackFrameInfo getNonNativeStackFrame(DebugThreadInfo debugThreadInfo) {
        DebugStackFrameInfo[] debugStackFrameInfoArray = debugThreadInfo.listStack();
        return DebuggingProcess.getNonNativeStackFrame(debugStackFrameInfoArray);
    }

    static DebugStackFrameInfo getNonNativeStackFrame(DebugStackFrameInfo[] debugStackFrameInfoArray) {
        int n = debugStackFrameInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMethodInfo debugMethodInfo;
            DebugLocation debugLocation;
            DebugStackFrameInfo debugStackFrameInfo = debugStackFrameInfoArray[n2];
            if (debugStackFrameInfo != null && (debugLocation = debugStackFrameInfo.getLocation()) != null && !Modifier.isNative((debugMethodInfo = debugLocation.getMethod()).getAccess())) {
                return debugStackFrameInfo;
            }
            ++n2;
        }
        return null;
    }

    static void showStatus(String string) {
        statusText = string;
        Ide.getStatusBar().setText(statusText);
    }

    static void clearStatus() {
        StatusBar statusBar = Ide.getStatusBar();
        if (statusText != null && statusText.equals(statusBar.getText())) {
            statusBar.setText("");
        }
        statusText = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWhilePaused(RunWhilePaused runWhilePaused) {
        if (this.vm != null) {
            if (this.stopped) {
                runWhilePaused.run(this, true);
            } else {
                boolean[] blArray = this.pause;
                synchronized (this.pause) {
                    this.pause[0] = true;
                    this.runWhilePausedList.add(runWhilePaused);
                    this.vm.pauseProgram();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
        } else {
            runWhilePaused.run(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAfterPaused(RunWhilePaused runWhilePaused) {
        if (this.vm != null) {
            if (this.stopped) {
                if (JDebugger.getInstance().isActiveDebuggingProcess(this)) {
                    runWhilePaused.run(this, true);
                } else {
                    1 var2_2 = new 1(this, runWhilePaused);
                    this.runAfterSelectedList.add(var2_2);
                    Runner.getRunner().selectProcess((RunProcess)this);
                }
            } else {
                boolean[] blArray = this.pause;
                synchronized (this.pause) {
                    this.pause[0] = true;
                    this.runAfterPausedList.add(runWhilePaused);
                    this.vm.pauseProgram();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
        } else {
            runWhilePaused.run(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForInternalPause(boolean bl) {
        boolean bl2 = false;
        RunWhilePaused[] runWhilePausedArray = null;
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            if (this.pause[0]) {
                if (bl) {
                    bl2 = !this.pause[1] && this.vm.getCurrentStatus() == 8 && this.runAfterPausedList.size() == 0;
                    this.vm.cancelPauseProgram();
                }
                runWhilePausedArray = this.runWhilePausedList.toArray(new RunWhilePaused[this.runWhilePausedList.size()]);
                this.runWhilePausedList.clear();
                this.pause[0] = false;
            }
            // ** MonitorExit[var8_4] (shouldn't be in output)
            if (runWhilePausedArray != null) {
                try {
                    RunWhilePaused[] runWhilePausedArray2 = runWhilePausedArray;
                    int n = runWhilePausedArray2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        runWhilePausedArray2[n2].run(this, bl);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (bl2) {
                    if (this.vm.getCapabilities().canContinueStep() && this.stepping && !this.vm.didStepFinish()) {
                        this.vm.continueStep();
                    } else {
                        this.vm.resume();
                    }
                }
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAfterPause(boolean bl) {
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            RunWhilePaused[] runWhilePausedArray = this.runAfterPausedList.toArray(new RunWhilePaused[this.runAfterPausedList.size()]);
            this.runAfterPausedList.clear();
            // ** MonitorExit[var5_2] (shouldn't be in output)
            if (runWhilePausedArray != null) {
                int n = runWhilePausedArray.length;
                int n2 = 0;
                while (n2 < n) {
                    runWhilePausedArray[n2].run(this, bl);
                    ++n2;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(String string) {
        List list = this.messages;
        synchronized (list) {
            this.messages.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages() {
        List list = this.messages;
        synchronized (list) {
            while (this.messages.size() > 0) {
                String string = (String)this.messages.remove(0);
                this.logMessage(string);
            }
        }
    }

    EvaluatorItem makeTemporaryEvaluatorItem(String string, DebugDataCompositeInfo debugDataCompositeInfo) {
        EvaluatorItem evaluatorItem = new EvaluatorItem((String)null);
        evaluatorItem.pin(this, debugDataCompositeInfo);
        evaluatorItem.setCanUnpin(false);
        evaluatorItem.setOptions(string, false, this);
        return evaluatorItem;
    }

    String[] url_to_packageAndFile(URL uRL) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            String[] stringArray = this.node_to_packageAndFile(node);
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    String[] node_to_packageAndFile(Node node) {
        try {
            String string = null;
            String string2 = null;
            if (node instanceof PackagedSource) {
                string = Source.getPackageFromNode(node, this.getJProject());
                string2 = Source.getFilenameFromNode(node);
            } else if (node instanceof AntNode) {
                if (this.antDebugging) {
                    string = "$org.apache.tools.ant";
                    string2 = URLFileSystem.getPlatformPathName((URL)node.getURL());
                }
            } else if (node instanceof XMLSourceNode && this.xsltDebugging) {
                URL uRL = node.getURL();
                string = XSLTRunnerAddin.getXSLTPackage(uRL);
                string2 = URLFileSystem.getFileName((URL)uRL);
            }
            if (string != null && string2 != null && string2.length() > 0) {
                String[] stringArray = new String[]{string, string2};
                String[] stringArray2 = stringArray;
                return stringArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static void setDatabaseDebuggingHelperClass(Class clazz) {
        databaseDebuggingHelperClass = clazz;
    }

    final void setPort(String string) {
        this.localPort = string;
    }

    final String getPort() {
        return this.localPort;
    }

    final void forceDetach() {
        if (this.vm != null) {
            this.vm.disconnect(false);
            this.vm = null;
        }
    }

    private boolean checkForPotentialClipboardDeadlock() {
        try {
            DebugDataObjectInfo debugDataObjectInfo;
            DebugDataObjectInfo debugDataObjectInfo2;
            DebugDataObjectInfo debugDataObjectInfo3;
            DebugClassInfo debugClassInfo;
            if (this.vm != null && (debugClassInfo = this.vm.findFirstClassByName("java.awt.Toolkit")) != null && (debugDataObjectInfo3 = (DebugDataObjectInfo)DebugShared.findStaticFieldData(debugClassInfo, "toolkit")) != null && (debugDataObjectInfo2 = (DebugDataObjectInfo)DebugShared.findFieldData(debugDataObjectInfo3, "clipboard")) != null && (debugDataObjectInfo = (DebugDataObjectInfo)DebugShared.findFieldData(debugDataObjectInfo2, "contents")) != null && !debugDataObjectInfo.isNull()) {
                if (debugDataObjectInfo2.getClassInfo().getName().equals("sun.awt.motif.X11Clipboard")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(DbgArb.getString(888));
                    stringBuffer.append("\n\n");
                    stringBuffer.append(DbgArb.format(889, Ide.getProgramShortName()));
                    stringBuffer.append("\n\n");
                    stringBuffer.append(DbgArb.getString(890));
                    if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)stringBuffer, (String)DbgArb.getString(887), null)) {
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(DbgArb.getString(888));
                    stringBuffer.append("\n");
                    stringBuffer.append(DbgArb.format(889, Ide.getProgramShortName()));
                    stringBuffer.append("\n");
                    this.log(stringBuffer);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static void wa$timeBeforeConnect(DebuggingProcess debuggingProcess, long l) {
        debuggingProcess.timeBeforeConnect = l;
    }

    static void wa$connectionThread(DebuggingProcess debuggingProcess, Thread thread) {
        debuggingProcess.connectionThread = thread;
    }

    static void mav$clearLogPageNorthComponent(DebuggingProcess debuggingProcess) {
        debuggingProcess.clearLogPageNorthComponent();
    }

    static DebugThreadInfo ra$currentThread(DebuggingProcess debuggingProcess) {
        return debuggingProcess.currentThread;
    }

    static Object ra$vmSync(DebuggingProcess debuggingProcess) {
        return debuggingProcess.vmSync;
    }

    static boolean mav$checkForInternalPause(DebuggingProcess debuggingProcess, boolean bl) {
        return debuggingProcess.checkForInternalPause(bl);
    }

    static boolean[] ra$pause(DebuggingProcess debuggingProcess) {
        return debuggingProcess.pause;
    }

    static long ra$timeProgramStopped(DebuggingProcess debuggingProcess) {
        return debuggingProcess.timeProgramStopped;
    }

    static void wa$timeProgramStopped(DebuggingProcess debuggingProcess, long l) {
        debuggingProcess.timeProgramStopped = l;
    }

    static void mav$logMessages(DebuggingProcess debuggingProcess) {
        debuggingProcess.logMessages();
    }

    static void mav$logMessage(DebuggingProcess debuggingProcess, String string) {
        debuggingProcess.logMessage(string);
    }

    static void mav$activeProgramStopped(DebuggingProcess debuggingProcess) {
        debuggingProcess.activeProgramStopped();
    }

    static List ra$runAfterSelectedList(DebuggingProcess debuggingProcess) {
        return debuggingProcess.runAfterSelectedList;
    }

    static DebugBreakpoint ra$runToCursor(DebuggingProcess debuggingProcess) {
        return debuggingProcess.runToCursor;
    }

    static boolean ra$xsltDebugging(DebuggingProcess debuggingProcess) {
        return debuggingProcess.xsltDebugging;
    }

    static void mav$showXSLTOutput(DebuggingProcess debuggingProcess) {
        debuggingProcess.showXSLTOutput();
    }

    static void mav$sendDebuggerEvent(DebuggingProcess debuggingProcess, int n, int n2) {
        debuggingProcess.sendDebuggerEvent(n, n2);
    }

    static void mav$doRunAfterPause(DebuggingProcess debuggingProcess, boolean bl) {
        debuggingProcess.doRunAfterPause(bl);
    }

    static boolean ra$stopped(DebuggingProcess debuggingProcess) {
        return debuggingProcess.stopped;
    }

    static boolean ra$resuming(DebuggingProcess debuggingProcess) {
        return debuggingProcess.resuming;
    }

    static TimerTask ra$timerTaskUpdateNormalWindows(DebuggingProcess debuggingProcess) {
        return debuggingProcess.timerTaskUpdateNormalWindows;
    }

    static void mav$updateNormalWindows(DebuggingProcess debuggingProcess) {
        debuggingProcess.updateNormalWindows();
    }

    static void wa$timerTaskUpdateNormalWindows(DebuggingProcess debuggingProcess, TimerTask timerTask) {
        debuggingProcess.timerTaskUpdateNormalWindows = timerTask;
    }

    static TimerTask ra$timerTaskUpdateOtherWindows(DebuggingProcess debuggingProcess) {
        return debuggingProcess.timerTaskUpdateOtherWindows;
    }

    static void mav$updateOtherWindows(DebuggingProcess debuggingProcess) {
        debuggingProcess.updateOtherWindows();
    }

    static void wa$timerTaskUpdateOtherWindows(DebuggingProcess debuggingProcess, TimerTask timerTask) {
        debuggingProcess.timerTaskUpdateOtherWindows = timerTask;
    }

    public final class 15
    implements Runnable {
        public void run() {
            DebugConfiguration debugConfiguration;
            String string = DebuggingProcess.this.vm.getName();
            if (string != null) {
                String string2 = DbgArb.format(213, string);
                DebuggingProcess.this.log(string2);
            }
            if ((debugConfiguration = DebuggingProcess.this.getDebugConfiguration()).getRemoteProtocol().equals("jpda") && string != null && string.startsWith("OJVM Client VM")) {
                String string3 = DbgArb.getString(857);
                DebuggingProcess.this.log(string3);
            }
            DebuggingProcess.this.afterConnection(DbgArb.getString(212));
        }
    }

    public final class 14
    implements Runnable {
        public void run() {
            String string = DbgArb.getString(228);
            DebuggingProcess.this.log(string);
        }
    }

    public final class 13
    implements Runnable {
        public void run() {
            String string = DbgArb.getString(206);
            DebuggingProcess.this.log(string);
            DebuggingProcess.this.superTerminate();
        }
    }

    public final class 12
    implements Runnable {
        public void run() {
            DebuggingProcess.this.afterConnection(DbgArb.getString(205));
        }
    }

    public final class 11
    implements Runnable {
        public void run() {
            DebuggingProcess.this.superTerminate();
        }
    }

    public final class 10
    extends Thread {
        private final /* synthetic */ DebugConnector v$connector;
        private final /* synthetic */ DebugConnectArg[] v$connectArgs;
        private final /* synthetic */ String v$successMsg;
        private final /* synthetic */ Runnable v$successRunnable;
        private final /* synthetic */ String v$tryMsg;
        private final /* synthetic */ int v$maxRetries;
        private final /* synthetic */ Runnable v$canceledRunnable;
        private final /* synthetic */ Runnable v$failureRunnable;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            int n = 0;
            boolean bl = true;
            boolean bl2 = false;
            Character c = new Character('.');
            DebuggingProcess.wa$timeBeforeConnect(this.this$0, System.currentTimeMillis());
            while (true) {
                try {
                    DebugVirtualMachine debugVirtualMachine = this.v$connector.connect(this.v$connectArgs);
                    DebuggingProcess.wa$connectionThread(this.this$0, null);
                    DebuggingProcess.clearStatus();
                    if (this.v$successMsg != null) {
                        this.this$0.log(this.v$successMsg);
                    }
                    MessagePage messagePage = null;
                    LogPage logPage = this.this$0.getLogPage();
                    if (logPage instanceof MessagePage) {
                        messagePage = (MessagePage)logPage;
                    }
                    debugVirtualMachine.afterConnection(messagePage);
                    SwingUtilities.invokeLater(new 3(this, debugVirtualMachine));
                    return;
                }
                catch (Exception exception) {
                    String string;
                    if (exception instanceof IOException && (string = exception.getMessage()) != null && string.equals("Target failed to handshake.")) {
                        bl = false;
                    }
                    if (this.v$tryMsg != null) {
                        this.this$0.log(c);
                    }
                    if (++n > this.v$maxRetries) {
                        bl = false;
                    }
                    if (!bl) continue;
                    if (n > this.v$maxRetries / 2) {
                        DebuggingProcess.showStatus(DbgArb.getString(230));
                    }
                    try {
                        Thread.sleep(250L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        this.this$0.log(DbgArb.getString(208));
                        bl2 = true;
                        bl = false;
                    }
                    if (bl) continue;
                    DebuggingProcess.wa$connectionThread(this.this$0, null);
                    DebuggingProcess.clearStatus();
                    if (bl2) {
                        SwingUtilities.invokeLater(new 2());
                    } else {
                        SwingUtilities.invokeLater(new 1());
                    }
                    return;
                }
                break;
            }
        }

        public 10(DebuggingProcess debuggingProcess, String string, DebugConnector debugConnector, DebugConnectArg[] debugConnectArgArray, String string2, Runnable runnable, String string3, int n, Runnable runnable2, Runnable runnable3) {
            this.v$failureRunnable = runnable3;
            this.v$canceledRunnable = runnable2;
            this.v$maxRetries = n;
            this.v$tryMsg = string3;
            this.v$successRunnable = runnable;
            this.v$successMsg = string2;
            this.v$connectArgs = debugConnectArgArray;
            this.v$connector = debugConnector;
            this.this$0 = debuggingProcess;
            super(string);
        }

        static Runnable ra$v$successRunnable(10 var0) {
            return var0.v$successRunnable;
        }

        static Runnable ra$v$canceledRunnable(10 var0) {
            return var0.v$canceledRunnable;
        }

        static Runnable ra$v$failureRunnable(10 var0) {
            return var0.v$failureRunnable;
        }

        public final class 3
        implements Runnable {
            private final /* synthetic */ DebugVirtualMachine v$vm;
            final /* synthetic */ 10 this$0;

            public void run() {
                this.this$0.this$0.vm = this.v$vm;
                DebuggingProcess.mav$clearLogPageNorthComponent(this.this$0.this$0);
                JDebugger.getInstance().debuggingProcessAfterConnecting(this.this$0.this$0);
                10.ra$v$successRunnable(this.this$0).run();
            }

            public 3(10 var1_1, DebugVirtualMachine debugVirtualMachine) {
                this.v$vm = debugVirtualMachine;
                this.this$0 = var1_1;
            }
        }

        public final class 2
        implements Runnable {
            public void run() {
                DebuggingProcess.mav$clearLogPageNorthComponent(10.this.this$0);
                JDebugger.getInstance().debuggingProcessAfterConnecting(10.this.this$0);
                if (10.ra$v$canceledRunnable(10.this) != null) {
                    10.ra$v$canceledRunnable(10.this).run();
                }
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                DebuggingProcess.mav$clearLogPageNorthComponent(10.this.this$0);
                JDebugger.getInstance().debuggingProcessAfterConnecting(10.this.this$0);
                10.ra$v$failureRunnable(10.this).run();
            }
        }
    }

    public class EventSource
    extends DebuggerEventSource {
        int languages = 0;
        int eventType;
        int state;
        boolean isPrepared;
        DebuggerEventSource.StackFrame[] stackFrames;

        EventSource() {
        }

        synchronized void eventOccurring(int n, int n2) {
            this.eventType = n;
            this.state = n2;
            this.isPrepared = false;
            this.stackFrames = null;
        }

        synchronized void prepareStackFrames() {
            if (!this.isPrepared) {
                DebuggerEventSource.StackFrame[] stackFrameArray;
                if (this.eventType == 2) {
                    if (DebuggingProcess.ra$currentThread(DebuggingProcess.this) != null) {
                        DebugStackFrameInfo[] debugStackFrameInfoArray = DebuggingProcess.ra$currentThread(DebuggingProcess.this).listStack();
                        stackFrameArray = new DebuggerEventSource.StackFrame[debugStackFrameInfoArray.length];
                        int n = 0;
                        while (n < debugStackFrameInfoArray.length) {
                            DebugDataInfo debugDataInfo;
                            DebugVariableInfo debugVariableInfo;
                            DebugLocation debugLocation = debugStackFrameInfoArray[n].getLocation();
                            DebugClassInfo debugClassInfo = debugLocation.getClassInfo();
                            String string = debugClassInfo.getName();
                            String string2 = DebugShared.makeCourtesyClassName(debugClassInfo, true);
                            DebugMethodInfo debugMethodInfo = debugLocation.getMethod();
                            String string3 = debugMethodInfo.getNameWithoutClassOrSignature();
                            String string4 = DebugShared.makeCourtesyMethodName(debugMethodInfo, false, false, debugStackFrameInfoArray[n]);
                            String string5 = debugMethodInfo.getParameterSignature();
                            String string6 = DebugShared.makeCourtesyMethodSignature(debugMethodInfo, DebuggingProcess.this.vm);
                            int n2 = debugMethodInfo.getAccess();
                            long l = 0L;
                            String string7 = null;
                            String string8 = null;
                            int n3 = debugStackFrameInfoArray[n].getLanguage();
                            if (!Modifier.isStatic(n2) && !Modifier.isNative(n2) && DebuggingProcess.this.vm.getCapabilities().canGetUniqueIDs() && (debugVariableInfo = BaseEvaluator.findThis(debugStackFrameInfoArray[n].listArguments())) != null && (debugDataInfo = debugVariableInfo.getDataInfo()) instanceof DebugDataCompositeInfo) {
                                DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)debugDataInfo;
                                l = JDebugger.getObjectNumber(debugDataCompositeInfo);
                                DebugClassInfo debugClassInfo2 = debugDataCompositeInfo.getClassInfo();
                                string7 = debugClassInfo2.getName();
                                string8 = DebugShared.makeCourtesyClassName(debugClassInfo2, true);
                            }
                            String string9 = debugLocation.getFilename();
                            int n4 = debugLocation.getLine();
                            stackFrameArray[n] = new DebuggerEventSource.StackFrame(string, string2, string3, string4, string5, string6, n2, l, string7, string8, string9, n4, n3);
                            ++n;
                        }
                    } else {
                        stackFrameArray = new DebuggerEventSource.StackFrame[]{};
                    }
                } else {
                    stackFrameArray = null;
                }
                this.stackFrames = stackFrameArray;
                this.isPrepared = true;
            }
        }

        public int getLanguages() {
            if (DebuggingProcess.this.vm != null) {
                this.languages = DebuggingProcess.this.vm.getLanguages();
            }
            return this.languages;
        }

        public int getState() {
            return this.state;
        }

        public DebuggerEventSource.StackFrame[] getStackFrames() {
            this.prepareStackFrames();
            return this.stackFrames;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("EventSource[");
            stringBuffer.append("state=");
            stringBuffer.append(this.state);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public final class 9
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string = null;
            Object object = DebuggingProcess.ra$vmSync(DebuggingProcess.this);
            synchronized (object) {
                if (DebuggingProcess.mav$checkForInternalPause(DebuggingProcess.this, DebuggingProcess.this.vm != null)) {
                    return;
                }
                boolean[] blArray = DebuggingProcess.ra$pause(DebuggingProcess.this);
                synchronized (blArray) {
                    DebuggingProcess.ra$pause((DebuggingProcess)DebuggingProcess.this)[1] = false;
                }
                if (DebuggingProcess.this.vm == null) {
                    return;
                }
                if (DebuggingProcess.ra$timeProgramStopped(DebuggingProcess.this) == 0L) {
                    DebuggingProcess.wa$timeProgramStopped(DebuggingProcess.this, System.currentTimeMillis());
                }
                if (DebuggingProcess.this.vm.getCurrentStatus() == 8) {
                    string = DbgArb.getString(353);
                }
            }
            DebuggingProcess.mav$logMessages(DebuggingProcess.this);
            if (string != null) {
                DebuggingProcess.mav$logMessage(DebuggingProcess.this, string);
            }
            if (DebuggingProcess.this.vm == null) {
                return;
            }
            if (JDebugger.getInstance().isActiveDebuggingProcess(DebuggingProcess.this)) {
                DebuggingProcess.mav$activeProgramStopped(DebuggingProcess.this);
            } else {
                1 var2_4 = new 1();
                DebuggingProcess.ra$runAfterSelectedList(DebuggingProcess.this).add(var2_4);
                Runner.getRunner().selectProcess((RunProcess)DebuggingProcess.this);
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                DebuggingProcess.mav$activeProgramStopped(DebuggingProcess.this);
            }
        }
    }

    public final class 8
    implements Runnable {
        private final /* synthetic */ DebugBreakpoint v$dbp;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            if (this.this$0.vm == null) {
                return;
            }
            if (this.v$dbp != DebuggingProcess.ra$runToCursor(this.this$0)) {
                JDebugger.getInstance().breakpointChanged(this.v$dbp, this.this$0);
            }
        }

        public 8(DebuggingProcess debuggingProcess, DebugBreakpoint debugBreakpoint) {
            this.v$dbp = debugBreakpoint;
            this.this$0 = debuggingProcess;
        }
    }

    public final class 7
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DebuggingProcess.mav$logMessages(DebuggingProcess.this);
            Object object = DebuggingProcess.ra$vmSync(DebuggingProcess.this);
            synchronized (object) {
                DebuggingProcess.mav$checkForInternalPause(DebuggingProcess.this, false);
            }
            if (DebuggingProcess.ra$xsltDebugging(DebuggingProcess.this)) {
                DebuggingProcess.mav$showXSLTOutput(DebuggingProcess.this);
            }
            DebuggingProcess.mav$sendDebuggerEvent(DebuggingProcess.this, 4, 400);
            if (DebuggingProcess.this.isRemoteDebuggingProfiling()) {
                DebuggingProcess.this.finished();
            } else {
                DebuggingProcess.this.superTerminate();
            }
            DebuggingProcess.this.checkCommands();
            DebuggingProcess.mav$doRunAfterPause(DebuggingProcess.this, false);
        }
    }

    public final class 6
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DebuggingProcess.mav$logMessages(DebuggingProcess.this);
            DebuggingProcess.mav$logMessage(DebuggingProcess.this, DbgArb.getString(231));
            Object object = DebuggingProcess.ra$vmSync(DebuggingProcess.this);
            synchronized (object) {
                DebuggingProcess.mav$checkForInternalPause(DebuggingProcess.this, false);
            }
            if (DebuggingProcess.ra$xsltDebugging(DebuggingProcess.this)) {
                DebuggingProcess.mav$showXSLTOutput(DebuggingProcess.this);
            }
            DebuggingProcess.mav$sendDebuggerEvent(DebuggingProcess.this, 4, 401);
            if (DebuggingProcess.this.isRemoteDebuggingProfiling()) {
                DebuggingProcess.this.finished();
            } else {
                DebuggingProcess.this.superTerminate();
            }
            DebuggingProcess.this.checkCommands();
            DebuggingProcess.mav$doRunAfterPause(DebuggingProcess.this, false);
        }
    }

    public final class 5
    implements Runnable {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            this.this$0.log(this.v$msg);
        }

        public 5(DebuggingProcess debuggingProcess, String string) {
            this.v$msg = string;
            this.this$0 = debuggingProcess;
        }
    }

    public final class 4
    extends Thread {
        private final /* synthetic */ DebugVirtualMachine v$vmFinal;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            if (this.v$vmFinal != null) {
                this.v$vmFinal.disconnect(true);
            }
        }

        public 4(DebuggingProcess debuggingProcess, String string, DebugVirtualMachine debugVirtualMachine) {
            this.v$vmFinal = debugVirtualMachine;
            this.this$0 = debuggingProcess;
            super(string);
        }
    }

    public final class 3
    extends TimerTask {
        public void run() {
            SwingUtilities.invokeLater(new 1());
        }

        public final class 1
        implements Runnable {
            public void run() {
                if (DebuggingProcess.ra$stopped(DebuggingProcess.this) && !DebuggingProcess.ra$resuming(DebuggingProcess.this) && DebuggingProcess.ra$timerTaskUpdateNormalWindows(DebuggingProcess.this) != null) {
                    DebuggingProcess.mav$updateNormalWindows(DebuggingProcess.this);
                }
                DebuggingProcess.wa$timerTaskUpdateNormalWindows(DebuggingProcess.this, null);
            }
        }
    }

    public final class 2
    extends TimerTask {
        public void run() {
            SwingUtilities.invokeLater(new 1());
        }

        public final class 1
        implements Runnable {
            public void run() {
                if (DebuggingProcess.ra$stopped(DebuggingProcess.this) && !DebuggingProcess.ra$resuming(DebuggingProcess.this) && DebuggingProcess.ra$timerTaskUpdateOtherWindows(DebuggingProcess.this) != null) {
                    DebuggingProcess.mav$updateOtherWindows(DebuggingProcess.this);
                }
                DebuggingProcess.wa$timerTaskUpdateOtherWindows(DebuggingProcess.this, null);
            }
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ RunWhilePaused v$runAfterPaused;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            this.v$runAfterPaused.run(this.this$0, true);
        }

        public 1(DebuggingProcess debuggingProcess, RunWhilePaused runWhilePaused) {
            this.v$runAfterPaused = runWhilePaused;
            this.this$0 = debuggingProcess;
        }
    }
}

