/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.runner.debug.DbgArb;

final class EditHeapClassDialog
extends JPanel
implements ItemListener,
DocumentListener,
ActionListener {
    private JEWTDialog dlg;
    private Project jproject;
    private String name;
    private HistoryList nameHistoryList;
    private JComboBox nameComboBox;
    private JTextField nameEditor;
    private JButton browseButton;
    private static final String nameHistoryName = "DebuggerHeapClass";

    static String showEditHeapClassDialog(String string, String string2, String string3, Project project, String string4) {
        EditHeapClassDialog editHeapClassDialog = new EditHeapClassDialog(string2, string3, project);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)editHeapClassDialog, (Component)editHeapClassDialog.nameEditor, (String)string);
        editHeapClassDialog.setJEWTDialog(jEWTDialog);
        jEWTDialog.setOKButtonEnabled(editHeapClassDialog.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)editHeapClassDialog, string4);
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            return editHeapClassDialog.getHeapClass();
        }
        return null;
    }

    private EditHeapClassDialog(String string, String string2, Project project) {
        super(new GridBagLayout());
        this.jproject = project;
        if (string2 == null) {
            string2 = "";
        }
        this.name = string2;
        JLabel jLabel = new JLabel();
        this.nameHistoryList = Ide.loadHistoryList((String)nameHistoryName);
        this.nameComboBox = new JComboBox<String>(this.nameHistoryList.getHistory());
        this.nameComboBox.setEditable(true);
        this.nameEditor = (JTextField)this.nameComboBox.getEditor().getEditorComponent();
        this.nameComboBox.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.nameEditor, (String)string);
        IdeUtil.comboBoxSelectItem((JComboBox)this.nameComboBox, (Object)string2);
        this.browseButton = new JButton();
        this.browseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.browseButton, (String)DbgArb.getString(678));
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.nameComboBox, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.browseButton, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.nameComboBox, (DocumentListener)this);
        this.nameComboBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1());
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        try {
            boolean bl = this.nameEditor.getText().length() > 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean veto() {
        JavaManager javaManager;
        JavaClass javaClass;
        String string = this.nameEditor.getText();
        if (string.length() > 0 && (javaClass = (javaManager = JavaManager.getJavaManager(this.jproject)).getClass(string)) == null) {
            String[] stringArray = new String[]{DbgArb.format(680, string), DbgArb.getString(681)};
            int n = JOptionPane.showConfirmDialog(this, stringArray, DbgArb.format(679, this.dlg.getTitle()), 0);
            return n != 0;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object == this.nameComboBox) {
            this.nameEditor.setText((String)this.nameComboBox.getSelectedItem());
        } else if (object == this.browseButton && (string = ClassPackageBrowserV2.browseClassOrPackage(this, this.jproject, 2)) != null) {
            this.nameEditor.setText(string);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.processChange();
    }

    private String getHeapClass() {
        return this.nameHistoryList.comboBoxGetSelectedItem(this.nameComboBox);
    }

    static boolean mav$veto(EditHeapClassDialog editHeapClassDialog) {
        return editHeapClassDialog.veto();
    }

    final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && EditHeapClassDialog.mav$veto(EditHeapClassDialog.this)) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }
    }
}

