/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.Evaluator;

final class EditWatchDialog
extends JPanel
implements ItemListener,
DocumentListener,
ActionListener {
    private JEWTDialog dlg;
    private String exp;
    private HistoryList expHistoryList;
    private JComboBox expComboBox;
    private JTextField expEditor;

    static String showEditWatchDialog(String string, String string2, String string3, String string4) {
        EditWatchDialog editWatchDialog = new EditWatchDialog(string2, string3, string4);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)editWatchDialog, (Component)editWatchDialog.expEditor, (String)string);
        editWatchDialog.setJEWTDialog(jEWTDialog);
        jEWTDialog.setOKButtonEnabled(editWatchDialog.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)editWatchDialog, "f1_deb_edit_watch_inspect_expdialog_html");
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            return editWatchDialog.getExpression();
        }
        return null;
    }

    private EditWatchDialog(String string, String string2, String string3) {
        super(new GridBagLayout());
        if (string3 == null) {
            string3 = "";
        }
        this.exp = string3;
        JLabel jLabel = new JLabel();
        this.expHistoryList = Ide.loadHistoryList((String)string2);
        this.expComboBox = new JComboBox<String>(this.expHistoryList.getHistory());
        this.expComboBox.setEditable(true);
        this.expEditor = (JTextField)this.expComboBox.getEditor().getEditorComponent();
        this.expComboBox.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.expEditor, (String)string);
        IdeUtil.comboBoxSelectItem((JComboBox)this.expComboBox, (Object)string3);
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.expComboBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.expComboBox, (DocumentListener)this);
        this.expComboBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        try {
            String string = this.expEditor.getText();
            if (string.length() > 0 && Evaluator.validate(string)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.expComboBox) {
            this.expEditor.setText((String)this.expComboBox.getSelectedItem());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.processChange();
    }

    private String getExpression() {
        return this.expHistoryList.comboBoxGetSelectedItem(this.expComboBox);
    }
}

