/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;

public class EvaluationInfo {
    private Object wrappedValue;
    private String value;
    private String hexValue;
    private DebugClassInfo classInfo;
    private DebugDataInfo data;

    EvaluationInfo(String string, DebugClassInfo debugClassInfo, DebugDataInfo debugDataInfo) throws Exception {
        this.init(string, "", debugClassInfo, debugDataInfo);
    }

    EvaluationInfo(String string, DebugClassInfo debugClassInfo) throws Exception {
        this.init(string, "", debugClassInfo, null);
    }

    EvaluationInfo(boolean bl, DebugClassInfo debugClassInfo) throws Exception {
        String string;
        String string2;
        Object object = this.wrappedValue = bl ? Boolean.TRUE : Boolean.FALSE;
        if (bl) {
            string2 = "true";
            string = "01";
        } else {
            string2 = "false";
            string = "00";
        }
        this.init(string2, string, debugClassInfo, null);
    }

    EvaluationInfo(byte by, DebugClassInfo debugClassInfo) throws Exception {
        this.wrappedValue = new Byte(by);
        String string = Byte.toString(by);
        byte by2 = by;
        String string2 = DebugShared.prepadOrTrunc(Integer.toHexString(by2), '0', 2);
        this.init(string, string2, debugClassInfo, null);
    }

    EvaluationInfo(char c, DebugClassInfo debugClassInfo) throws Exception {
        this.wrappedValue = new Character(c);
        char[] cArray = new char[]{'\'', c, '\''};
        char c2 = c;
        String string = new String(cArray) + "    " + c2;
        String string2 = DebugShared.prepadOrTrunc(Integer.toHexString(c2), '0', 4);
        this.init(string, string2, debugClassInfo, null);
    }

    EvaluationInfo(double d, DebugClassInfo debugClassInfo) throws Exception {
        this.wrappedValue = new Double(d);
        String string = Double.toString(d);
        long l = Double.doubleToLongBits(d);
        String string2 = DebugShared.prepadOrTrunc(Long.toHexString(l), '0', 16);
        this.init(string, string2, debugClassInfo, null);
    }

    EvaluationInfo(float f, DebugClassInfo debugClassInfo) throws Exception {
        this.wrappedValue = new Float(f);
        String string = Float.toString(f);
        int n = Float.floatToIntBits(f);
        String string2 = DebugShared.prepadOrTrunc(Integer.toHexString(n), '0', 8);
        this.init(string, string2, debugClassInfo, null);
    }

    EvaluationInfo(int n, DebugClassInfo debugClassInfo) throws Exception {
        this.wrappedValue = new Integer(n);
        String string = Integer.toString(n);
        String string2 = DebugShared.prepadOrTrunc(Integer.toHexString(n), '0', 8);
        this.init(string, string2, debugClassInfo, null);
    }

    EvaluationInfo(long l, DebugClassInfo debugClassInfo) throws Exception {
        this.wrappedValue = new Long(l);
        String string = Long.toString(l);
        String string2 = DebugShared.prepadOrTrunc(Long.toHexString(l), '0', 16);
        this.init(string, string2, debugClassInfo, null);
    }

    EvaluationInfo(short s, DebugClassInfo debugClassInfo) throws Exception {
        this.wrappedValue = new Short(s);
        String string = Short.toString(s);
        short s2 = s;
        String string2 = DebugShared.prepadOrTrunc(Integer.toHexString(s2), '0', 4);
        this.init(string, string2, debugClassInfo, null);
    }

    private void init(String string, String string2, DebugClassInfo debugClassInfo, DebugDataInfo debugDataInfo) throws Exception {
        if (debugClassInfo == null) {
            throw new Exception("EvaluationInfo classInfo is null");
        }
        this.value = string;
        this.hexValue = string2;
        this.classInfo = debugClassInfo;
        this.data = debugDataInfo;
    }

    DebugDataInfo getDataInfo() {
        return this.data;
    }

    String getValue() {
        return this.getValue(false);
    }

    String getValue(boolean bl) {
        if (bl && this.data instanceof DebugDataCompositeInfo && (this.value == null || this.value.length() == 0)) {
            return DebugShared.makeCourtesyValue((DebugDataCompositeInfo)this.data);
        }
        return this.value;
    }

    String getHexValue() {
        return this.hexValue;
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    boolean isNull() {
        return this.value.equals("null") && (this.classInfo.isObject() || this.classInfo.isInterface() || this.classInfo.isArray());
    }

    void copyFrom(EvaluationInfo evaluationInfo) {
        this.value = evaluationInfo.value;
        this.hexValue = evaluationInfo.hexValue;
        this.classInfo = evaluationInfo.classInfo;
        this.data = evaluationInfo.data;
    }

    Object getWrappedValue() {
        return this.wrappedValue;
    }

    public boolean getBooleanValue() {
        if (this.wrappedValue instanceof Boolean) {
            return (Boolean)this.wrappedValue;
        }
        return DebugSharedPrimitives.booleanDecode(this.value);
    }

    public byte getByteValue() {
        if (this.wrappedValue instanceof Byte) {
            return (Byte)this.wrappedValue;
        }
        return DebugSharedPrimitives.byteDecode(this.value);
    }

    public char getCharValue() {
        if (this.wrappedValue instanceof Character) {
            return ((Character)this.wrappedValue).charValue();
        }
        return DebugSharedPrimitives.charDecode(this.value);
    }

    public double getDoubleValue() {
        if (this.wrappedValue instanceof Double) {
            return (Double)this.wrappedValue;
        }
        return DebugSharedPrimitives.doubleDecode(this.value);
    }

    public float getFloatValue() {
        if (this.wrappedValue instanceof Float) {
            return ((Float)this.wrappedValue).floatValue();
        }
        return DebugSharedPrimitives.floatDecode(this.value);
    }

    public int getIntValue() {
        if (this.wrappedValue instanceof Integer) {
            return (Integer)this.wrappedValue;
        }
        return DebugSharedPrimitives.intDecode(this.value);
    }

    public long getLongValue() {
        if (this.wrappedValue instanceof Long) {
            return (Long)this.wrappedValue;
        }
        return DebugSharedPrimitives.longDecode(this.value);
    }

    public short getShortValue() {
        if (this.wrappedValue instanceof Short) {
            return (Short)this.wrappedValue;
        }
        return DebugSharedPrimitives.shortDecode(this.value);
    }

    public String getStringValue() {
        if (this.data instanceof DebugDataObjectInfo) {
            Object object;
            DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)this.data;
            if (this.classInfo.getName().equals("$oracle.xml.xslt.XMLString")) {
                return DebugShared.makeCourtesyValue(debugDataObjectInfo, false, false);
            }
            if (!debugDataObjectInfo.isNull() && (object = debugDataObjectInfo.getWholeThing()) instanceof String) {
                return (String)object;
            }
        } else if (!this.value.equals("null")) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(this.value);
            int n = fastStringBuffer.length();
            if (n >= 2 && fastStringBuffer.charAt(0) == '\"' && fastStringBuffer.charAt(n - 1) == '\"') {
                fastStringBuffer.removeCharAt(n - 1);
                fastStringBuffer.removeCharAt(0);
            }
            return fastStringBuffer.toString();
        }
        return null;
    }
}

