/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.AntEvaluator;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.JavaEvaluator;
import oracle.jdevimpl.runner.debug.PlsqlEvaluator;
import oracle.jdevimpl.runner.debug.XsltEvaluator;

public class Evaluator
extends DebugContext {
    private JavaEvaluator javaEvaluator;
    private PlsqlEvaluator plsqlEvaluator;
    private XsltEvaluator xsltEvaluator;
    private AntEvaluator antEvaluator;

    public Evaluator(boolean bl) {
        this.javaEvaluator = new JavaEvaluator(this, bl);
        this.plsqlEvaluator = new PlsqlEvaluator(this);
        this.xsltEvaluator = new XsltEvaluator(this);
        this.antEvaluator = new AntEvaluator(this);
    }

    public boolean setDebugContext(DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo debugStackFrameInfo) {
        if (super.setDebugContext(debugVirtualMachine, debugThreadInfo, debugStackFrameInfo)) {
            this.clearCache();
            return true;
        }
        return false;
    }

    boolean setDebugContext(DebugDataObjectInfo debugDataObjectInfo) {
        if (super.setDebugContext(debugDataObjectInfo)) {
            this.clearCache();
            return true;
        }
        return false;
    }

    void clearCache() {
        this.javaEvaluator.clearCache();
        this.plsqlEvaluator.clearCache();
        this.xsltEvaluator.clearCache();
        this.antEvaluator.clearCache();
    }

    static boolean validate(String string) {
        if (JavaEvaluator.validate(string)) {
            return true;
        }
        if (PlsqlEvaluator.validate(string)) {
            return true;
        }
        return XsltEvaluator.validate(string);
    }

    int evaluateCondition(String string) {
        BaseEvaluator[] baseEvaluatorArray = new BaseEvaluator[1];
        Object object = this.evaluate(string, baseEvaluatorArray);
        if (object != null && baseEvaluatorArray[0] != null) {
            return baseEvaluatorArray[0].evaluateConditionResult(object);
        }
        return -2;
    }

    public Object evaluate(String string) {
        return this.evaluate(string, null);
    }

    private Object evaluate(String string, BaseEvaluator[] baseEvaluatorArray) {
        if (this.vm != null) {
            int n;
            ArrayList<BaseEvaluator> arrayList = new ArrayList<BaseEvaluator>();
            if (this.frame != null) {
                switch (this.frame.getLanguage()) {
                    case 1: {
                        arrayList.add(this.javaEvaluator);
                        break;
                    }
                    case 2: {
                        arrayList.add(this.plsqlEvaluator);
                        break;
                    }
                    case 4: {
                        arrayList.add(this.xsltEvaluator);
                        break;
                    }
                    case 8: {
                        arrayList.add(this.antEvaluator);
                    }
                }
            }
            if (((n = this.vm.getLanguages()) & 1) != 0 && !arrayList.contains(this.javaEvaluator)) {
                arrayList.add(this.javaEvaluator);
            }
            if ((n & 2) != 0 && !arrayList.contains(this.plsqlEvaluator)) {
                arrayList.add(this.plsqlEvaluator);
            }
            if ((n & 4) != 0 && !arrayList.contains(this.xsltEvaluator)) {
                arrayList.add(this.xsltEvaluator);
            }
            if ((n & 8) != 0 && !arrayList.contains(this.antEvaluator)) {
                arrayList.add(this.antEvaluator);
            }
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                BaseEvaluator baseEvaluator = (BaseEvaluator)arrayList.get(n3);
                Object object = baseEvaluator.evaluate(string);
                if (object != null) {
                    if (baseEvaluatorArray != null) {
                        baseEvaluatorArray[0] = baseEvaluator;
                    }
                    return object;
                }
                ++n3;
            }
        }
        return null;
    }

    static DebugDataInfo getDataInfo(Object object) {
        return BaseEvaluator.getDataInfo(object);
    }
}

