/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.Expression;

public class EvaluatorItem
implements DebugPinListener {
    private String expression;
    private Map pinned;
    private Map discarded;
    private String name;
    private boolean showPinnedDiscarded;
    private DebuggingProcess temporary;
    private boolean canUnpin;

    public EvaluatorItem(String string) {
        this.expression = string;
        this.name = null;
        this.showPinnedDiscarded = true;
        this.canUnpin = true;
    }

    EvaluatorItem(Expression expression) {
        this(expression.getExpression());
        this.setOptions(expression.getName(), expression.isShowPinnedDiscarded(), expression.getTemporary());
    }

    void pin(DebuggingProcess debuggingProcess, DebugDataCompositeInfo debugDataCompositeInfo) {
        DebugPinnedInfo debugPinnedInfo = debugDataCompositeInfo.pinObject(this);
        if (debugPinnedInfo != null) {
            if (this.pinned == null) {
                this.pinned = new HashMap();
            }
            this.pinned.put(debuggingProcess, debugPinnedInfo);
        }
    }

    public void setOptions(String string, boolean bl, DebuggingProcess debuggingProcess) {
        this.name = string;
        this.showPinnedDiscarded = bl;
        this.temporary = debuggingProcess;
    }

    public String getName() {
        return this.name;
    }

    public boolean isShowPinnedDiscarded() {
        return this.showPinnedDiscarded;
    }

    public DebuggingProcess getTemporary() {
        return this.temporary;
    }

    void setCanUnpin(boolean bl) {
        this.canUnpin = bl;
    }

    boolean canUnpin(DebuggingProcess debuggingProcess) {
        return this.canUnpin && this.isPinned(debuggingProcess);
    }

    void unpin(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo debugPinnedInfo;
        if (this.pinned != null && (debugPinnedInfo = (DebugPinnedInfo)this.pinned.remove(debuggingProcess)) != null) {
            debugPinnedInfo.unpinObject();
        }
        if (this.discarded != null) {
            this.discarded.remove(debuggingProcess);
        }
    }

    void unpinForAll() {
        if (this.pinned != null) {
            for (DebuggingProcess debuggingProcess : this.pinned.keySet()) {
                if (!this.isPinned(debuggingProcess)) continue;
                this.unpin(debuggingProcess);
            }
        }
        if (this.discarded != null) {
            for (DebuggingProcess debuggingProcess : this.discarded.keySet()) {
                if (!this.isPinned(debuggingProcess)) continue;
                this.unpin(debuggingProcess);
            }
        }
    }

    public void pinnedObjectDiscarded(DebugVirtualMachine debugVirtualMachine, DebugPinnedInfo debugPinnedInfo) {
        if (this.pinned != null) {
            for (DebuggingProcess debuggingProcess : this.pinned.keySet()) {
                DebugPinnedInfo debugPinnedInfo2;
                if (debuggingProcess.getVM() != debugVirtualMachine || !(debugPinnedInfo2 = (DebugPinnedInfo)this.pinned.get(debuggingProcess)).equals(debugPinnedInfo)) continue;
                this.pinned.remove(debuggingProcess);
                if (this.discarded == null) {
                    this.discarded = new HashMap();
                }
                this.discarded.put(debuggingProcess, debugPinnedInfo);
                return;
            }
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.expression = string;
        if (this.pinned != null) {
            this.pinned.clear();
        }
        if (this.discarded != null) {
            this.discarded.clear();
        }
    }

    boolean isPinned(DebuggingProcess debuggingProcess) {
        Object v;
        if (this.pinned != null && (v = this.pinned.get(debuggingProcess)) != null) {
            return true;
        }
        return this.isDiscarded(debuggingProcess);
    }

    private long getPinnedId(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo debugPinnedInfo;
        if (this.pinned != null && (debugPinnedInfo = (DebugPinnedInfo)this.pinned.get(debuggingProcess)) != null) {
            return debugPinnedInfo.getUniqueID();
        }
        return 0L;
    }

    private boolean isDiscarded(DebuggingProcess debuggingProcess) {
        Object v;
        return this.discarded != null && (v = this.discarded.get(debuggingProcess)) != null;
    }

    long getDiscardedId(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo debugPinnedInfo;
        if (this.discarded != null && (debugPinnedInfo = (DebugPinnedInfo)this.discarded.get(debuggingProcess)) != null) {
            return debugPinnedInfo.getUniqueID();
        }
        return 0L;
    }

    Object evaluate(DebuggingProcess debuggingProcess, Evaluator evaluator) {
        if (this.isDiscarded(debuggingProcess)) {
            return null;
        }
        if (this.isPinned(debuggingProcess)) {
            DebugPinnedInfo debugPinnedInfo = (DebugPinnedInfo)this.pinned.get(debuggingProcess);
            return debugPinnedInfo.getDataInfo();
        }
        return evaluator.evaluate(this.expression);
    }

    public String getName(DebuggingProcess debuggingProcess) {
        String string = this.name != null ? this.name : this.expression;
        if (this.showPinnedDiscarded) {
            long l = this.getPinnedId(debuggingProcess);
            if (l != 0L) {
                return string + " " + DbgArb.format(686, Long.toHexString(l).toUpperCase());
            }
            l = this.getDiscardedId(debuggingProcess);
            if (l != 0L) {
                return string + " " + DbgArb.format(687, Long.toHexString(l).toUpperCase());
            }
        }
        return string;
    }
}

