/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockableWindow;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.EditWatchDialog;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.Expression;

abstract class EvaluatorPanel
extends DataPanel {
    protected Evaluator evaluator = new Evaluator(true);
    protected IdeAction _actionPin;
    protected IdeAction _actionUnpin;
    protected JMenuItem _menuitemPin;
    protected JMenuItem _menuitemUnpin;
    protected int _PIN_CMD_ID;
    protected int _UNPIN_CMD_ID;

    EvaluatorPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        super(dockableWindow, dataPanelSettings);
    }

    protected void debugContextChanged() {
        super.debugContextChanged();
        this.evaluator.setDebugContext(this.vm, this.thread, this.frame);
    }

    void everythingChanged() {
        this.evaluator.clearCache();
        super.everythingChanged();
    }

    protected void addPopupMenuItemsForDataItem(ContextMenu contextMenu, Context context) {
        if (this._actionPin != null) {
            this.update(this._actionPin, context);
            if (this._actionPin.isEnabled()) {
                if (this._menuitemPin == null) {
                    this._menuitemPin = contextMenu.createMenuItem((ToggleAction)this._actionPin);
                }
                contextMenu.add((Component)this._menuitemPin, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        if (this._actionUnpin != null) {
            this.update(this._actionUnpin, context);
            if (this._actionUnpin.isEnabled()) {
                if (this._menuitemUnpin == null) {
                    this._menuitemUnpin = contextMenu.createMenuItem((ToggleAction)this._actionUnpin);
                }
                contextMenu.add((Component)this._menuitemUnpin, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        super.addPopupMenuItemsForDataItem(contextMenu, context);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (ideAction.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                ideAction.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                ideAction.setEnabled(false);
                return true;
            }
        }
        if (n == this._PIN_CMD_ID) {
            DataPanel.DataItem dataItem = this.getSelectedDataItem();
            if (dataItem instanceof EvaluatorDataItem) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                ideAction.setEnabled(evaluatorDataItem.canPin());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._UNPIN_CMD_ID) {
            DataPanel.DataItem dataItem = this.getSelectedDataItem();
            if (dataItem instanceof EvaluatorDataItem) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                ideAction.setEnabled(evaluatorDataItem.canUnpin());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return super.update(ideAction, context);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this._PIN_CMD_ID) {
            DataPanel.DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof EvaluatorDataItem && treePath != null) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                evaluatorDataItem.pin(treePath);
            }
            return true;
        }
        if (n == this._UNPIN_CMD_ID) {
            DataPanel.DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof EvaluatorDataItem && treePath != null) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                evaluatorDataItem.unpin(treePath);
            }
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    protected void addDataItem(List list, EvaluatorItem evaluatorItem, boolean bl, boolean bl2) {
        Object object = evaluatorItem.evaluate(this.debuggingProcess, this.evaluator);
        if (object == null) {
            if (bl) {
                return;
            }
            object = evaluatorItem;
        }
        if (object instanceof DebugClassInfo && bl2) {
            return;
        }
        String string = evaluatorItem.getName(this.debuggingProcess);
        EvaluatorDataItem evaluatorDataItem = new EvaluatorDataItem(evaluatorItem, string, object);
        if (list != null) {
            list.add(evaluatorDataItem);
        } else {
            this.addTopDataItem(evaluatorDataItem);
        }
    }

    protected final class EvaluatorDataItem
    extends DataPanel.DataItem {
        EvaluatorItem ei;

        EvaluatorDataItem(EvaluatorItem evaluatorItem, String string, Object object) {
            super(object, string, evaluatorItem.isPinned(EvaluatorPanel.this.debuggingProcess) ? null : evaluatorItem.getExpression());
            this.ei = evaluatorItem;
        }

        private void reEvaluateExpression(TreePath treePath) {
            Object object = this.ei.evaluate(EvaluatorPanel.this.debuggingProcess, EvaluatorPanel.this.evaluator);
            if (object == null) {
                object = this.ei;
            }
            String string = this.ei.getName(EvaluatorPanel.this.debuggingProcess);
            String string2 = this.ei.isPinned(EvaluatorPanel.this.debuggingProcess) ? null : this.ei.getExpression();
            this.modifyInfo(object, string, string2, treePath);
        }

        protected boolean prepareExpression(Object[] objectArray, int n, Expression expression) {
            if (super.prepareExpression(objectArray, n, expression)) {
                String string = this.ei.getName();
                if (string != null) {
                    expression.setName(string);
                }
                expression.setShowPinnedDiscarded(this.ei.isShowPinnedDiscarded());
                expression.setTemporary(this.ei.getTemporary());
                return true;
            }
            return false;
        }

        protected boolean canEditExpression() {
            return this.ei.getExpression() != null;
        }

        protected boolean editExpression(String string, String string2, String string3, TreePath treePath) {
            String string4 = this.ei.getExpression();
            if ((string4 = EditWatchDialog.showEditWatchDialog(string, string2, string3, string4)) != null) {
                this.ei.setExpression(string4);
                this.reEvaluateExpression(treePath);
                return true;
            }
            return false;
        }

        boolean canPin() {
            return EvaluatorPanel.this.vm != null && EvaluatorPanel.this.vm.getCapabilities().canPin() && this.data instanceof DebugDataCompositeInfo && !((DebugDataCompositeInfo)this.data).isNull() && !this.ei.isPinned(EvaluatorPanel.this.debuggingProcess);
        }

        void pin(TreePath treePath) {
            DebugDataCompositeInfo debugDataCompositeInfo;
            if (EvaluatorPanel.this.vm != null && EvaluatorPanel.this.vm.getCapabilities().canPin() && this.data instanceof DebugDataCompositeInfo && !(debugDataCompositeInfo = (DebugDataCompositeInfo)this.data).isNull()) {
                this.ei.pin(EvaluatorPanel.this.debuggingProcess, debugDataCompositeInfo);
                this.reEvaluateExpression(treePath);
            }
        }

        boolean canUnpin() {
            return this.ei.canUnpin(EvaluatorPanel.this.debuggingProcess);
        }

        void unpin(TreePath treePath) {
            this.ei.unpin(EvaluatorPanel.this.debuggingProcess);
            this.reEvaluateExpression(treePath);
        }
    }
}

