/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.layout.Layout;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditHeapClassDialog;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class HeapWindow
extends DataWindow {
    private List pins;
    private List pinDebuggingProcesses;
    private List pinSubsets;
    private HeapWindowSettings heapWindowSettings = HeapWindowSettings.getInstance();
    private static IdeAction actionAddNewClass;
    private static IdeAction actionEditClass;
    private static IdeAction actionRemoveFolder;
    private static IdeAction actionShowAncestors;
    private static IdeAction actionExpandAncestor;
    private static IdeAction actionViewWhole;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionRemoveAllFolders;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAddNewClass;
    private static JMenuItem menuitemEditClass;
    private static JMenuItem menuitemRemoveFolder;
    private static JMenuItem menuitemShowAncestors;
    private static JMenuItem menuitemExpandAncestor;
    private static JMenuItem menuitemRemoveAllFolders;
    private static JMenuItem menuitemSettings;
    private static final int ADD_NEW_CLASS_CMD_ID;
    private static final int EDIT_CLASS_CMD_ID;
    private static final int REMOVE_FOLDER_CMD_ID;
    private static final int SHOW_ANCESTORS_CMD_ID;
    private static final int EXPAND_ANCESTOR_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int REMOVE_ALL_FOLDERS_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String HEAP_WINDOW_ID = "Debugger.HeapWindow";
    private static Icon heapTabIcon;
    private static final String HEAP_KEY_COUNT = "Heap.Count";
    private static final String HEAP_KEY_PREFIX = "Heap.";
    private static final String HEAP_KEY_DOT = ".";
    private static final String HEAP_KEY_SCOPE = "scope";
    private static final String HEAP_KEY_CLASS = "class";
    private static final String GlobalHeapScope = "GlobalHeapScope";

    static {
        ADD_NEW_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAddNewClass");
        EDIT_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapEditClass");
        REMOVE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveFolder");
        SHOW_ANCESTORS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapShowAncestors");
        EXPAND_ANCESTOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapExpandAncestor");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewWhole");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoField");
        REMOVE_ALL_FOLDERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveAllFolders");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSettings");
        heapTabIcon = null;
    }

    HeapWindow() {
        super(HEAP_WINDOW_ID, DbgArb.getString(661), "f1_deb_heapwindow_html");
        HeapWindow.makeActions();
        this.setDataPanel(new HeapPanel());
        this.setControllerForActions();
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public Icon getTabIcon() {
        if (heapTabIcon == null) {
            heapTabIcon = DbgArb.getIcon(79);
        }
        return heapTabIcon;
    }

    public String getMenuTitle() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        return this.title;
    }

    public Component getGUI() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        return super.getGUI();
    }

    void shutDown() {
        this.saveSettings();
        HeapPanel.mav$saveClasses((HeapPanel)this.dataPanel, (PropertyAccess)Ide.getIdeProperties());
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        HeapWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAddNewClass), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEditClass), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveFolder), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionShowAncestors), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAncestor), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAllFolders), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    private static void makeActions() {
        if (actionShowAncestors == null) {
            actionShowAncestors = IdeAction.get((int)SHOW_ANCESTORS_CMD_ID, null, (String)DbgArb.getString(670), null, (Integer)DbgArb.getInteger(671), null, (int)-1, null, (boolean)false);
            actionShowAncestors.setEnabled(false);
            actionExpandAncestor = IdeAction.get((int)EXPAND_ANCESTOR_CMD_ID, null, (String)DbgArb.getString(672), null, (Integer)DbgArb.getInteger(673), null, (int)-1, null, (boolean)false);
            actionExpandAncestor.setEnabled(false);
            actionEditClass = IdeAction.get((int)EDIT_CLASS_CMD_ID, null, (String)DbgArb.getString(662), null, (Integer)DbgArb.getInteger(663), null, (int)-1, null, (boolean)false);
            actionEditClass.setEnabled(false);
            actionRemoveFolder = IdeAction.get((int)REMOVE_FOLDER_CMD_ID, null, (String)DbgArb.getString(666), null, (Integer)DbgArb.getInteger(667), null, (int)-1, null, (boolean)false);
            actionRemoveFolder.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(317), null, (Integer)DbgArb.getInteger(318), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(319), null, (Integer)DbgArb.getInteger(320), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(321), null, (Integer)DbgArb.getInteger(322), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(323), null, (Integer)DbgArb.getInteger(324), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(325), null, (Integer)DbgArb.getInteger(326), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(327), null, (Integer)DbgArb.getInteger(328), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(341), null, (Integer)DbgArb.getInteger(342), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(343), null, (Integer)DbgArb.getInteger(344), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(329), null, (Integer)DbgArb.getInteger(331), null, (int)-1, null, (boolean)false);
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(332), null, (Integer)DbgArb.getInteger(334), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(335), null, (Integer)DbgArb.getInteger(337), null, (int)-1, null, (boolean)false);
            actionGotoField.setEnabled(false);
            actionAddNewClass = IdeAction.get((int)ADD_NEW_CLASS_CMD_ID, null, (String)DbgArb.getString(664), null, (Integer)DbgArb.getInteger(665), null, (int)-1, null, (boolean)false);
            actionAddNewClass.setEnabled(false);
            actionRemoveAllFolders = IdeAction.get((int)REMOVE_ALL_FOLDERS_CMD_ID, null, (String)DbgArb.getString(668), null, (Integer)DbgArb.getInteger(669), null, (int)-1, null, (boolean)false);
            actionRemoveAllFolders.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(345), null, (Integer)DbgArb.getInteger(346), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(347, ""), null, (Integer)DbgArb.getInteger(348), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionShowAncestors, actionExpandAncestor, actionEditClass, actionRemoveFolder, actionViewWhole, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionAddNewClass, actionRemoveAllFolders, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this.dataPanel);
    }

    void addHeapClass(String string) {
        ((HeapPanel)this.dataPanel).addClass(string);
    }

    static HeapWindowSettings ra$heapWindowSettings(HeapWindow heapWindow) {
        return heapWindow.heapWindowSettings;
    }

    static List ra$pins(HeapWindow heapWindow) {
        return heapWindow.pins;
    }

    static void wa$pins(HeapWindow heapWindow, List list) {
        heapWindow.pins = list;
    }

    static List ra$pinDebuggingProcesses(HeapWindow heapWindow) {
        return heapWindow.pinDebuggingProcesses;
    }

    static void wa$pinDebuggingProcesses(HeapWindow heapWindow, List list) {
        heapWindow.pinDebuggingProcesses = list;
    }

    static List ra$pinSubsets(HeapWindow heapWindow) {
        return heapWindow.pinSubsets;
    }

    static void wa$pinSubsets(HeapWindow heapWindow, List list) {
        heapWindow.pinSubsets = list;
    }

    static int ra$SHOW_ANCESTORS_CMD_ID() {
        return SHOW_ANCESTORS_CMD_ID;
    }

    static int ra$EXPAND_ANCESTOR_CMD_ID() {
        return EXPAND_ANCESTOR_CMD_ID;
    }

    static int ra$EDIT_CLASS_CMD_ID() {
        return EDIT_CLASS_CMD_ID;
    }

    static int ra$REMOVE_FOLDER_CMD_ID() {
        return REMOVE_FOLDER_CMD_ID;
    }

    static int ra$ADD_NEW_CLASS_CMD_ID() {
        return ADD_NEW_CLASS_CMD_ID;
    }

    static int ra$REMOVE_ALL_FOLDERS_CMD_ID() {
        return REMOVE_ALL_FOLDERS_CMD_ID;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionRemoveAllFolders() {
        return actionRemoveAllFolders;
    }

    static JMenuItem ra$menuitemRemoveAllFolders() {
        return menuitemRemoveAllFolders;
    }

    static void wa$menuitemRemoveAllFolders(JMenuItem jMenuItem) {
        menuitemRemoveAllFolders = jMenuItem;
    }

    static IdeAction ra$actionEditClass() {
        return actionEditClass;
    }

    static JMenuItem ra$menuitemEditClass() {
        return menuitemEditClass;
    }

    static void wa$menuitemEditClass(JMenuItem jMenuItem) {
        menuitemEditClass = jMenuItem;
    }

    static IdeAction ra$actionRemoveFolder() {
        return actionRemoveFolder;
    }

    static JMenuItem ra$menuitemRemoveFolder() {
        return menuitemRemoveFolder;
    }

    static void wa$menuitemRemoveFolder(JMenuItem jMenuItem) {
        menuitemRemoveFolder = jMenuItem;
    }

    static IdeAction ra$actionShowAncestors() {
        return actionShowAncestors;
    }

    static JMenuItem ra$menuitemShowAncestors() {
        return menuitemShowAncestors;
    }

    static void wa$menuitemShowAncestors(JMenuItem jMenuItem) {
        menuitemShowAncestors = jMenuItem;
    }

    static IdeAction ra$actionExpandAncestor() {
        return actionExpandAncestor;
    }

    static JMenuItem ra$menuitemExpandAncestor() {
        return menuitemExpandAncestor;
    }

    static void wa$menuitemExpandAncestor(JMenuItem jMenuItem) {
        menuitemExpandAncestor = jMenuItem;
    }

    static IdeAction ra$actionAddNewClass() {
        return actionAddNewClass;
    }

    static JMenuItem ra$menuitemAddNewClass() {
        return menuitemAddNewClass;
    }

    static void wa$menuitemAddNewClass(JMenuItem jMenuItem) {
        menuitemAddNewClass = jMenuItem;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    final class HeapPanel
    extends DataPanel
    implements DebugPinListener {
        private Map mapProjectHeapFolders;
        private Map mapProcessHeapFolders;

        HeapPanel() {
            super(HeapWindow.this, HeapWindow.ra$heapWindowSettings(HeapWindow.this).getDataPanelSettings());
            this.mapProjectHeapFolders = new HashMap();
            this.mapProcessHeapFolders = new HashMap();
            this.loadHeap((PropertyAccess)Ide.getIdeProperties());
            this._actionViewWhole = HeapWindow.ra$actionViewWhole();
            this._actionAdjustRange = HeapWindow.ra$actionAdjustRange();
            this._actionToggleValue = HeapWindow.ra$actionToggleValue();
            this._actionModifyValue = HeapWindow.ra$actionModifyValue();
            this._actionWatch = HeapWindow.ra$actionWatch();
            this._actionInspect = HeapWindow.ra$actionInspect();
            this._actionWatchClassLoader = HeapWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = HeapWindow.ra$actionInspectClassLoader();
            this._actionGoto = HeapWindow.ra$actionGoto();
            this._actionGotoDeclared = HeapWindow.ra$actionGotoDeclared();
            this._actionGotoField = HeapWindow.ra$actionGotoField();
            this._actionUseFilters = HeapWindow.ra$actionUseFilters();
            this._actionObjectPreferences = HeapWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = HeapWindow.ra$actionCollapseAll();
            this._actionSave = HeapWindow.ra$actionSave();
            this._VIEW_WHOLE_CMD_ID = HeapWindow.ra$VIEW_WHOLE_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = HeapWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = HeapWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = HeapWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = HeapWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = HeapWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = HeapWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = HeapWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = HeapWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = HeapWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = HeapWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = HeapWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = HeapWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = HeapWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = HeapWindow.ra$SAVE_CMD_ID();
        }

        protected void adjustGUI() {
            if (Version.DEBUG_BUILD != 0) {
                this.heapAncestorOutsideHeapFont = this.getBoldFont();
                this.ancestorDepthZeroFont = this.getBoldItalicFont();
            } else {
                this.ancestorDepthZeroFont = this.getBoldFont();
            }
            this.treeTable.addKeyListener((KeyListener)new 1());
        }

        private void loadHeap(PropertyAccess propertyAccess) {
            String string = propertyAccess.getProperty(HeapWindow.HEAP_KEY_COUNT, null);
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    int n2 = 0;
                    while (n2 < n) {
                        this.loadHeapItem(propertyAccess, n2);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean loadHeapItem(PropertyAccess propertyAccess, int n) {
            String string = HeapWindow.HEAP_KEY_PREFIX + n + HeapWindow.HEAP_KEY_DOT;
            String string2 = propertyAccess.getProperty(string + HeapWindow.HEAP_KEY_SCOPE, HeapWindow.GlobalHeapScope);
            String string3 = propertyAccess.getProperty(string + HeapWindow.HEAP_KEY_CLASS, null);
            if (string3 != null && string3.length() > 0) {
                ArrayList<String> arrayList = (ArrayList<String>)this.mapProjectHeapFolders.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    this.mapProjectHeapFolders.put(string2, arrayList);
                }
                arrayList.add(string3);
                return true;
            }
            return false;
        }

        private void saveClasses(PropertyAccess propertyAccess) {
            int n = 0;
            String string = propertyAccess.getProperty(HeapWindow.HEAP_KEY_COUNT, null);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n2 = 0;
            for (String string2 : this.mapProjectHeapFolders.keySet()) {
                List list = (List)this.mapProjectHeapFolders.get(string2);
                for (String string3 : list) {
                    this.saveClass(propertyAccess, n2, string2, string3);
                    ++n2;
                }
            }
            int n3 = n2;
            while (n3 < n) {
                this.removeSavedClass(propertyAccess, n3);
                ++n3;
            }
            propertyAccess.setProperty(HeapWindow.HEAP_KEY_COUNT, Integer.toString(n2));
        }

        private void saveClass(PropertyAccess propertyAccess, int n, String string, String string2) {
            String string3 = HeapWindow.HEAP_KEY_PREFIX + n + HeapWindow.HEAP_KEY_DOT;
            propertyAccess.setProperty(string3 + HeapWindow.HEAP_KEY_SCOPE, string);
            propertyAccess.setProperty(string3 + HeapWindow.HEAP_KEY_CLASS, string2);
        }

        private void removeSavedClass(PropertyAccess propertyAccess, int n) {
            String string = HeapWindow.HEAP_KEY_PREFIX + n + HeapWindow.HEAP_KEY_DOT;
            propertyAccess.setProperty(string + HeapWindow.HEAP_KEY_SCOPE, null);
            propertyAccess.setProperty(string + HeapWindow.HEAP_KEY_CLASS, null);
        }

        protected void addPopupMenuItemsForNew(ContextMenu contextMenu, Context context) {
            this.update(HeapWindow.ra$actionAddNewClass(), context);
            if (HeapWindow.ra$actionAddNewClass().isEnabled()) {
                if (HeapWindow.ra$menuitemAddNewClass() == null) {
                    HeapWindow.wa$menuitemAddNewClass(contextMenu.createMenuItem((ToggleAction)HeapWindow.ra$actionAddNewClass()));
                }
                contextMenu.add((Component)HeapWindow.ra$menuitemAddNewClass(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForNew(contextMenu, context);
        }

        protected void addPopupMenuItemsForDataItem(ContextMenu contextMenu, Context context) {
            this.update(HeapWindow.ra$actionEditClass(), context);
            if (HeapWindow.ra$actionEditClass().isEnabled()) {
                if (HeapWindow.ra$menuitemEditClass() == null) {
                    HeapWindow.wa$menuitemEditClass(contextMenu.createMenuItem((ToggleAction)HeapWindow.ra$actionEditClass()));
                }
                contextMenu.add((Component)HeapWindow.ra$menuitemEditClass(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(HeapWindow.ra$actionRemoveFolder(), context);
            if (HeapWindow.ra$actionRemoveFolder().isEnabled()) {
                if (HeapWindow.ra$menuitemRemoveFolder() == null) {
                    HeapWindow.wa$menuitemRemoveFolder(contextMenu.createMenuItem((ToggleAction)HeapWindow.ra$actionRemoveFolder()));
                }
                contextMenu.add((Component)HeapWindow.ra$menuitemRemoveFolder(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(HeapWindow.ra$actionShowAncestors(), context);
            if (HeapWindow.ra$actionShowAncestors().isEnabled()) {
                if (HeapWindow.ra$menuitemShowAncestors() == null) {
                    HeapWindow.wa$menuitemShowAncestors(contextMenu.createMenuItem((ToggleAction)HeapWindow.ra$actionShowAncestors()));
                }
                contextMenu.add((Component)HeapWindow.ra$menuitemShowAncestors(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(HeapWindow.ra$actionExpandAncestor(), context);
            if (HeapWindow.ra$actionExpandAncestor().isEnabled()) {
                if (HeapWindow.ra$menuitemExpandAncestor() == null) {
                    HeapWindow.wa$menuitemExpandAncestor(contextMenu.createMenuItem((ToggleAction)HeapWindow.ra$actionExpandAncestor()));
                }
                contextMenu.add((Component)HeapWindow.ra$menuitemExpandAncestor(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(contextMenu, context);
        }

        protected void addPopupMenuItemsForData(ContextMenu contextMenu, Context context) {
            this.update(HeapWindow.ra$actionRemoveAllFolders(), context);
            if (HeapWindow.ra$actionRemoveAllFolders().isEnabled()) {
                if (HeapWindow.ra$menuitemRemoveAllFolders() == null) {
                    HeapWindow.wa$menuitemRemoveAllFolders(contextMenu.createMenuItem((ToggleAction)HeapWindow.ra$actionRemoveAllFolders()));
                }
                contextMenu.add((Component)HeapWindow.ra$menuitemRemoveAllFolders(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForData(contextMenu, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(HeapWindow.ra$actionSettings(), context);
            if (HeapWindow.ra$actionSettings().isEnabled()) {
                if (HeapWindow.ra$menuitemSettings() == null) {
                    HeapWindow.wa$menuitemSettings(contextMenu.createMenuItem((ToggleAction)HeapWindow.ra$actionSettings()));
                }
                contextMenu.add((Component)HeapWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == HeapWindow.ra$SETTINGS_CMD_ID())) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == HeapWindow.ra$SHOW_ANCESTORS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem != null) {
                    ideAction.setEnabled(this.canShowAncestors(dataItem));
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == HeapWindow.ra$EXPAND_ANCESTOR_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem != null && treePath != null) {
                    ideAction.setEnabled(this.canExpandAncestor(dataItem));
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == HeapWindow.ra$EDIT_CLASS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                    ideAction.setEnabled(true);
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == HeapWindow.ra$REMOVE_FOLDER_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof HeapDataItem) {
                    ideAction.setEnabled(true);
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == HeapWindow.ra$ADD_NEW_CLASS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            if (n == HeapWindow.ra$REMOVE_ALL_FOLDERS_CMD_ID()) {
                ideAction.setEnabled(this.canRemoveAllFolders());
                return true;
            }
            if (n == HeapWindow.ra$SETTINGS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == HeapWindow.ra$SHOW_ANCESTORS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem != null) {
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    waitCursor.show();
                    this.showAncestors(dataItem);
                    waitCursor.hide();
                }
                return true;
            }
            if (n == HeapWindow.ra$EXPAND_ANCESTOR_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem != null && treePath != null) {
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    waitCursor.show();
                    this.expandAncestor(dataItem, treePath);
                    waitCursor.hide();
                }
                return true;
            }
            if (n == HeapWindow.ra$EDIT_CLASS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                    this.editClass((HeapClassFolderDataItem)dataItem, treePath);
                }
                return true;
            }
            if (n == HeapWindow.ra$REMOVE_FOLDER_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof HeapDataItem) {
                    this.removeFolder((HeapDataItem)dataItem);
                }
                return true;
            }
            if (n == HeapWindow.ra$ADD_NEW_CLASS_CMD_ID()) {
                this.addNewClass();
                return true;
            }
            if (n == HeapWindow.ra$REMOVE_ALL_FOLDERS_CMD_ID()) {
                this.removeAllFolders();
                return true;
            }
            if (n == HeapWindow.ra$SETTINGS_CMD_ID()) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(807)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        protected void addDataItems() {
            List list = this.getProcessHeapFolders(this.debuggingProcess);
            if (list != null) {
                List list2 = this.getRoot();
                for (Object e : list) {
                    if (e instanceof String) {
                        String string = (String)e;
                        Object object = this.makeHeapSubsetForClass(string);
                        HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(object);
                        list2.add(heapClassFolderDataItem);
                        continue;
                    }
                    if (!(e instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset heapAncestorSubset = (HeapAncestorSubset)e;
                    Object object = this.makeHeapSubsetForAncestors(heapAncestorSubset);
                    HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(object, heapAncestorSubset);
                    list2.add(heapAncestorsFolderDataItem);
                }
            }
        }

        private Object makeHeapSubsetForClass(String string) {
            DebugHeapInfo debugHeapInfo;
            DebugHeapSubsetClasses debugHeapSubsetClasses = new DebugHeapSubsetClasses(string);
            debugHeapSubsetClasses.addClass(string, false);
            if (this.vm != null && (debugHeapInfo = this.vm.getHeap(debugHeapSubsetClasses)) != null) {
                return debugHeapInfo;
            }
            return debugHeapSubsetClasses;
        }

        protected void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(ClassesWindow.getClassFlavor()) || dropTargetDragEvent.isDataFlavorSupported(ClassesWindow.getArrayFlavor()) || dropTargetDragEvent.isDataFlavorSupported(HeapPanel.getHeapObjectFlavor())) {
                dropTargetDragEvent.acceptDrag(1);
                return;
            }
            super.checkDrag(dropTargetDragEvent);
        }

        protected void checkDrop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isLocalTransfer()) {
                if (dropTargetDropEvent.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        ClassesWindow.ClassFlavorData classFlavorData = (ClassesWindow.ClassFlavorData)transferable.getTransferData(ClassesWindow.getClassFlavor());
                        this.addClass(classFlavorData.getName());
                        JDebugger.getInstance().viewHeap();
                        dropTargetDropEvent.acceptDrop(1);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {}
                } else if (dropTargetDropEvent.isDataFlavorSupported(ClassesWindow.getArrayFlavor())) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        ClassesWindow.ClassFlavorData classFlavorData = (ClassesWindow.ClassFlavorData)transferable.getTransferData(ClassesWindow.getArrayFlavor());
                        this.addClass(classFlavorData.getName());
                        JDebugger.getInstance().viewHeap();
                        dropTargetDropEvent.acceptDrop(1);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {}
                } else if (dropTargetDropEvent.isDataFlavorSupported(HeapPanel.getHeapObjectFlavor())) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)transferable.getTransferData(HeapPanel.getHeapObjectFlavor());
                        this.showAncestors(debugDataCompositeInfo);
                        JDebugger.getInstance().viewHeap();
                        dropTargetDropEvent.acceptDrop(1);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            super.checkDrop(dropTargetDropEvent);
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            if (HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this) != null) {
                int n = HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).size() - 1;
                while (n >= 0) {
                    if (debuggingProcess.equals(HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).get(n))) {
                        HeapWindow.ra$pins(HeapWindow.this).remove(n);
                        HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).remove(n);
                        HeapWindow.ra$pinSubsets(HeapWindow.this).remove(n);
                    }
                    --n;
                }
            }
            this.mapProcessHeapFolders.remove(debuggingProcess);
            super.processFinished(debuggingProcess);
        }

        private List getProcessHeapFolders(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                ArrayList arrayList = (ArrayList)this.mapProcessHeapFolders.get(debuggingProcess);
                if (arrayList == null) {
                    arrayList = new ArrayList(this.getProjectHeapFolders(debuggingProcess));
                    this.mapProcessHeapFolders.put(debuggingProcess, arrayList);
                }
                return arrayList;
            }
            return null;
        }

        private List getProjectHeapFolders(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                Project project = debuggingProcess.getProject();
                String string = project != null && project != Ide.getDefaultProject() ? project.getURL().toString() : HeapWindow.GlobalHeapScope;
                ArrayList arrayList = (ArrayList)this.mapProjectHeapFolders.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.mapProjectHeapFolders.put(string, arrayList);
                }
                return arrayList;
            }
            return null;
        }

        private int convertProcessHeapFolderIndexToProjectHeapFolderIndex(List list, int n) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Object e = list.get(n3);
                if (e instanceof String) {
                    ++n2;
                }
                ++n3;
            }
            return n2;
        }

        private void editClass(HeapClassFolderDataItem heapClassFolderDataItem, TreePath treePath) {
            List list;
            int n = this.getRoot().indexOf(heapClassFolderDataItem);
            if (n != -1 && (list = this.getProcessHeapFolders(this.debuggingProcess)) != null) {
                int n2 = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(list, n);
                String string = (String)list.get(n);
                String string2 = DbgArb.getString(674);
                String string3 = DbgArb.getString(675);
                String string4 = "f1_deb_edit_heap_classdialog_html";
                if ((string = EditHeapClassDialog.showEditHeapClassDialog(string2, string3, string, this.debuggingProcess.getProject(), string4)) != null) {
                    list.set(n, string);
                    List list2 = this.getProjectHeapFolders(this.debuggingProcess);
                    list2.set(n2, string);
                    Object object = this.makeHeapSubsetForClass(string);
                    heapClassFolderDataItem.modifyClass(object, treePath);
                }
            }
        }

        private void removeFolder(HeapDataItem heapDataItem) {
            List list;
            int n = this.getRoot().indexOf(heapDataItem);
            if (n != -1 && (list = this.getProcessHeapFolders(this.debuggingProcess)) != null) {
                int n2;
                int n3 = -1;
                if (heapDataItem instanceof HeapClassFolderDataItem) {
                    n3 = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(list, n);
                }
                this.removeTopDataItem(n);
                list.remove(n);
                if (heapDataItem instanceof HeapClassFolderDataItem) {
                    List list2 = this.getProjectHeapFolders(this.debuggingProcess);
                    list2.remove(n3);
                }
                if (heapDataItem instanceof HeapAncestorsFolderDataItem) {
                    HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = (HeapAncestorsFolderDataItem)heapDataItem;
                    HeapAncestorSubset.mav$unpin(heapAncestorsFolderDataItem.has);
                }
                if (n < (n2 = list.size())) {
                    this.selectTopDataItem(n);
                } else if (0 <= --n && n < n2) {
                    this.selectTopDataItem(n);
                }
            }
        }

        private void addNewClass() {
            String string = DbgArb.getString(676);
            String string2 = DbgArb.getString(677);
            String string3 = "f1_deb_add_class_folder_dialog_html";
            String string4 = EditHeapClassDialog.showEditHeapClassDialog(string, string2, null, this.debuggingProcess.getProject(), string3);
            if (string4 != null) {
                this.addClass(string4);
            }
        }

        private void addClass(DebugDataCompositeInfo debugDataCompositeInfo) {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            long l = debugDataCompositeInfo.getAddressOfObject();
            DebugClassInfo debugClassInfo = debugDataCompositeInfo.getClassInfo();
            HeapClassFolderDataItem heapClassFolderDataItem = this.addClass(debugClassInfo.getName(), false);
            TreePath treePath = new TreePath(this.getRoot()).pathByAddingChild(heapClassFolderDataItem);
            Iterator iterator = this.model.getChildren(heapClassFolderDataItem);
            while (iterator.hasNext()) {
                DataPanel.DataItem dataItem = (DataPanel.DataItem)iterator.next();
                if (dataItem.getAddressOfObject() != l) continue;
                TreePath treePath2 = treePath.pathByAddingChild(dataItem);
                this.treeTable.getTree().makeVisible(treePath2);
                JDebugger.getInstance().selectTreeTablePath(this.treeTable, treePath2, true);
                break;
            }
            waitCursor.hide();
        }

        HeapClassFolderDataItem addClass(String string) {
            return this.addClass(string, true);
        }

        HeapClassFolderDataItem addClass(String string, boolean bl) {
            List list = this.getProcessHeapFolders(this.debuggingProcess);
            if (list != null) {
                int n = list.indexOf(string);
                if (n == -1) {
                    n = list.size();
                    list.add(string);
                    n = list.size() - 1;
                    List list2 = this.getProjectHeapFolders(this.debuggingProcess);
                    list2.add(string);
                    Object object = this.makeHeapSubsetForClass(string);
                    HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(object);
                    this.addTopDataItem(heapClassFolderDataItem, bl);
                    return heapClassFolderDataItem;
                }
                if (bl) {
                    this.selectTopDataItem(n);
                }
                return (HeapClassFolderDataItem)this.getRoot().get(n);
            }
            return null;
        }

        private boolean canRemoveAllFolders() {
            List list = this.getProcessHeapFolders(this.debuggingProcess);
            return list != null && list.size() > 0;
        }

        private void removeAllFolders() {
            List list;
            this.unpinAncestorFolders();
            List list2 = this.getProcessHeapFolders(this.debuggingProcess);
            if (list2 != null) {
                list2.clear();
            }
            if ((list = this.getProjectHeapFolders(this.debuggingProcess)) != null) {
                list.clear();
            }
            this.everythingChanged();
        }

        private boolean canShowAncestors(DataPanel.DataItem dataItem) {
            return dataItem.getAddressOfObject() != 0L;
        }

        private void showAncestors(DataPanel.DataItem dataItem) {
            DebugDataInfo debugDataInfo = dataItem.getDataInfo();
            if (debugDataInfo instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)debugDataInfo;
                this.showAncestors(debugDataCompositeInfo);
            }
        }

        private void showAncestors(DebugDataCompositeInfo debugDataCompositeInfo) {
            long l = debugDataCompositeInfo.getAddressOfObject();
            HeapAncestorSubset heapAncestorSubset = new HeapAncestorSubset(l);
            List list = this.getProcessHeapFolders(this.debuggingProcess);
            if (list != null) {
                int n = list.indexOf(heapAncestorSubset);
                if (n == -1) {
                    list.add(heapAncestorSubset);
                    n = list.size() - 1;
                    this.pin(debugDataCompositeInfo, heapAncestorSubset);
                    Object object = this.makeHeapSubsetForAncestors(heapAncestorSubset);
                    HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(object, heapAncestorSubset);
                    this.addTopDataItem(heapAncestorsFolderDataItem);
                } else {
                    this.selectTopDataItem(n);
                }
            }
        }

        private void pin(DebugDataCompositeInfo debugDataCompositeInfo, HeapAncestorSubset heapAncestorSubset) {
            DebugPinnedInfo debugPinnedInfo = debugDataCompositeInfo.pinObject(this);
            if (HeapWindow.ra$pins(HeapWindow.this) == null) {
                HeapWindow.wa$pins(HeapWindow.this, new ArrayList());
            }
            if (HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this) == null) {
                HeapWindow.wa$pinDebuggingProcesses(HeapWindow.this, new ArrayList());
            }
            if (HeapWindow.ra$pinSubsets(HeapWindow.this) == null) {
                HeapWindow.wa$pinSubsets(HeapWindow.this, new ArrayList());
            }
            HeapWindow.ra$pins(HeapWindow.this).add(debugPinnedInfo);
            HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).add(this.debuggingProcess);
            HeapWindow.ra$pinSubsets(HeapWindow.this).add(heapAncestorSubset);
        }

        private void unpinAncestorFolders() {
            List list = this.getProcessHeapFolders(this.debuggingProcess);
            if (list != null) {
                for (Object e : list) {
                    if (!(e instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset heapAncestorSubset = (HeapAncestorSubset)e;
                    HeapAncestorSubset.mav$unpin(heapAncestorSubset);
                }
            }
        }

        public void pinnedObjectDiscarded(DebugVirtualMachine debugVirtualMachine, DebugPinnedInfo debugPinnedInfo) {
            List list;
            long l = debugPinnedInfo.getAddressOfObject();
            DebuggingProcess debuggingProcess = JDebugger.getInstance().findDebuggingProcess(debugVirtualMachine);
            if (debuggingProcess != null && (list = this.getProcessHeapFolders(debuggingProcess)) != null) {
                for (Object e : list) {
                    if (!(e instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset heapAncestorSubset = (HeapAncestorSubset)e;
                    if (heapAncestorSubset.address != l) continue;
                    HeapAncestorSubset.mav$discarded(heapAncestorSubset);
                }
            }
        }

        private Object makeHeapSubsetForAncestors(HeapAncestorSubset heapAncestorSubset) {
            DebugHeapInfo debugHeapInfo;
            String string = DbgArb.format(700, "@" + Long.toHexString(heapAncestorSubset.address).toUpperCase());
            if (heapAncestorSubset.discarded) {
                string = string + " " + DbgArb.getString(701);
            }
            int n = HeapWindow.ra$heapWindowSettings(HeapWindow.this).isIgnoreSoftWeak() ? 4 : 2;
            int n2 = HeapWindow.ra$heapWindowSettings(HeapWindow.this).getMaximumDepth();
            DebugHeapSubsetAncestors debugHeapSubsetAncestors = new DebugHeapSubsetAncestors(string, heapAncestorSubset.address, n2, n);
            if (!heapAncestorSubset.discarded && this.vm != null && (debugHeapInfo = this.vm.getHeap(debugHeapSubsetAncestors)) != null) {
                return debugHeapInfo;
            }
            return debugHeapSubsetAncestors;
        }

        private boolean canExpandAncestor(DataPanel.DataItem dataItem) {
            return dataItem.ancestorHeapInfo != null && (dataItem.info instanceof DebugHeapAncestor || dataItem.ancestorDepth != 0);
        }

        private void expandAncestor(DataPanel.DataItem dataItem, TreePath treePath) {
            if (this.canExpandAncestor(dataItem)) {
                Iterator iterator = dataItem.getChildren();
                while (iterator.hasNext()) {
                    DataPanel.DataItem dataItem2 = (DataPanel.DataItem)iterator.next();
                    if (!dataItem2.ancestorShortestDepth) continue;
                    this.treeTable.getTree().expandPath(treePath);
                    this.expandAncestor(dataItem2, treePath.pathByAddingChild(dataItem2));
                    break;
                }
            }
        }

        static void mav$saveClasses(HeapPanel heapPanel, PropertyAccess propertyAccess) {
            heapPanel.saveClasses(propertyAccess);
        }

        final class 1
        extends KeyAdapter {
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 127: {
                        Context context = HeapPanel.this.getContext(keyEvent);
                        HeapPanel.this.update(HeapWindow.ra$actionRemoveFolder(), context);
                        if (!HeapWindow.ra$actionRemoveFolder().isEnabled()) break;
                        HeapPanel.this.handleEvent(HeapWindow.ra$actionRemoveFolder(), context);
                        keyEvent.consume();
                    }
                }
            }
        }

        protected abstract class HeapDataItem
        extends DataPanel.DataItem {
            HeapDataItem(Object object) {
                super(object);
            }
        }

        protected final class HeapClassFolderDataItem
        extends HeapDataItem {
            HeapClassFolderDataItem(Object object) {
                super(object);
            }

            void modifyClass(Object object, TreePath treePath) {
                this.modifyInfo(object, null, null, treePath);
            }
        }

        protected final class HeapAncestorsFolderDataItem
        extends HeapDataItem {
            HeapAncestorSubset has;

            HeapAncestorsFolderDataItem(Object object, HeapAncestorSubset heapAncestorSubset) {
                super(object);
                this.has = heapAncestorSubset;
            }
        }

        final class HeapAncestorSubset {
            final long address;
            boolean discarded;

            HeapAncestorSubset(long l) {
                this.address = l;
                this.discarded = false;
            }

            private void unpin() {
                int n = HeapWindow.ra$pinSubsets(HeapWindow.this).indexOf(this);
                if (n != -1) {
                    DebugPinnedInfo debugPinnedInfo = (DebugPinnedInfo)HeapWindow.ra$pins(HeapWindow.this).get(n);
                    debugPinnedInfo.unpinObject();
                    HeapWindow.ra$pins(HeapWindow.this).remove(n);
                    HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).remove(n);
                    HeapWindow.ra$pinSubsets(HeapWindow.this).remove(n);
                }
            }

            private void discarded() {
                this.discarded = true;
                int n = HeapWindow.ra$pinSubsets(HeapWindow.this).indexOf(this);
                if (n != -1) {
                    HeapWindow.ra$pins(HeapWindow.this).remove(n);
                    HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).remove(n);
                    HeapWindow.ra$pinSubsets(HeapWindow.this).remove(n);
                }
            }

            public int hashCode() {
                return (int)this.address;
            }

            public boolean equals(Object object) {
                if (object instanceof HeapAncestorSubset) {
                    return this.address == ((HeapAncestorSubset)object).address;
                }
                return false;
            }

            static void mav$discarded(HeapAncestorSubset heapAncestorSubset) {
                heapAncestorSubset.discarded();
            }

            static void mav$unpin(HeapAncestorSubset heapAncestorSubset) {
                heapAncestorSubset.unpin();
            }
        }
    }
}

