/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.config.ClientSetting;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class HeapWindowSettings
implements Copyable {
    public static final String KEY_SETTINGS = "HeapWindowOptions";
    private DataPanelSettings _dataPanelSettings = new DataPanelSettings();
    private boolean _ignoreSoftWeak;
    private int _maximumDepth;

    static HeapWindowSettings getInstance() {
        return (HeapWindowSettings)ClientSetting.findOrCreate((String)JDebugger.getExtensionID()).getData(KEY_SETTINGS);
    }

    public HeapWindowSettings() {
        this.defaultInit();
    }

    public HeapWindowSettings(HeapWindowSettings heapWindowSettings) {
        if (heapWindowSettings == null) {
            this.defaultInit();
        } else {
            heapWindowSettings.copyTo(this);
        }
    }

    private void defaultInit() {
        this._ignoreSoftWeak = true;
        this._maximumDepth = -1;
    }

    public Object copyTo(Object object) {
        HeapWindowSettings heapWindowSettings = object != null ? (HeapWindowSettings)object : new HeapWindowSettings();
        heapWindowSettings._ignoreSoftWeak = this._ignoreSoftWeak;
        heapWindowSettings._maximumDepth = this._maximumDepth;
        this._dataPanelSettings.copyTo((Object)heapWindowSettings._dataPanelSettings);
        return heapWindowSettings;
    }

    public DataPanelSettings getDataPanelSettings() {
        return this._dataPanelSettings;
    }

    public void setDataPanelSettings(DataPanelSettings dataPanelSettings) {
        dataPanelSettings.copyTo((Object)this._dataPanelSettings);
    }

    public boolean isIgnoreSoftWeak() {
        return this._ignoreSoftWeak;
    }

    public void setIgnoreSoftWeak(boolean bl) {
        this._ignoreSoftWeak = bl;
    }

    public int getMaximumDepth() {
        return this._maximumDepth;
    }

    public void setMaximumDepth(int n) {
        this._maximumDepth = n;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((HeapWindowSettings)object);
    }

    protected final boolean equalsImpl(HeapWindowSettings heapWindowSettings) {
        return ModelUtil.areEqual((Object)((Object)this._dataPanelSettings), (Object)((Object)heapWindowSettings._dataPanelSettings)) && this._ignoreSoftWeak == heapWindowSettings._ignoreSoftWeak && this._maximumDepth == heapWindowSettings._maximumDepth;
    }
}

