/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.ide.Version;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;

public final class HeapWindowSettingsPanel
extends DefaultTraversablePanel {
    private DataPanelSettingsPanel dataPanel;
    private JCheckBox hideUnrelatedCheckBox;
    private JCheckBox ignoreSoftWeakCheckBox;
    private JCheckBox rootsOnlyCheckBox;
    private JLabel maximumDepthLabel;
    private NumericSpinBox maximumDepthBox;
    private JLabel spacerLabel;

    void $init$() {
        this.dataPanel = new DataPanelSettingsPanel();
        this.hideUnrelatedCheckBox = new JCheckBox();
        this.ignoreSoftWeakCheckBox = new JCheckBox();
        this.rootsOnlyCheckBox = new JCheckBox();
        this.maximumDepthLabel = new JLabel();
        this.maximumDepthBox = new NumericSpinBox(-1, 1000);
        this.spacerLabel = new JLabel();
    }

    public HeapWindowSettingsPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_heapwinsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.hideUnrelatedCheckBox, (String)DbgArb.getString(808));
        ResourceUtils.resButton((AbstractButton)this.ignoreSoftWeakCheckBox, (String)DbgArb.getString(809));
        ResourceUtils.resButton((AbstractButton)this.rootsOnlyCheckBox, (String)DbgArb.getString(810));
        ResourceUtils.resLabel((JLabel)this.maximumDepthLabel, (Component)this.maximumDepthBox, (String)DbgArb.getString(811));
        SpinBuddy spinBuddy = this.maximumDepthBox.getSpinBuddy();
        if (spinBuddy instanceof JTextField) {
            ((JTextField)spinBuddy).setHorizontalAlignment(4);
        }
        this.spacerLabel.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        Insets insets = new Insets(0, 0, 0, 0);
        this.add(this.dataPanel.makeChooseColumnsPanel(insets), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 8;
        this.add(this.dataPanel.makeSortPanel(null), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.dataPanel.makeShowPanel(null), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.dataPanel.makeHidePanel(this.hideUnrelatedCheckBox), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.makeExtraPanel(insets), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add(this.spacerLabel, gridBagConstraints);
    }

    private JPanel makeExtraPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        int n = 0;
        jPanel.add((Component)this.ignoreSoftWeakCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        if (Version.DEBUG_BUILD != 0) {
            jPanel.add((Component)this.rootsOnlyCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
            jPanel.add((Component)this.maximumDepthLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
            jPanel.add((Component)this.maximumDepthBox, new GridBagConstraints(1, n, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        }
        return jPanel;
    }

    public void onEntry(TraversableContext traversableContext) {
        HeapWindowSettings heapWindowSettings = (HeapWindowSettings)traversableContext.find("HeapWindowOptions");
        DataPanelSettings dataPanelSettings = heapWindowSettings.getDataPanelSettings();
        this.dataPanel.onEntry(dataPanelSettings);
        this.hideUnrelatedCheckBox.setSelected(dataPanelSettings.isHideUnrelated());
        this.ignoreSoftWeakCheckBox.setSelected(heapWindowSettings.isIgnoreSoftWeak());
        if (Version.DEBUG_BUILD != 0) {
            this.rootsOnlyCheckBox.setSelected(dataPanelSettings.isShowOnlyRootAncestors());
            this.maximumDepthBox.setIntValue(heapWindowSettings.getMaximumDepth());
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        HeapWindowSettings heapWindowSettings = (HeapWindowSettings)traversableContext.find("HeapWindowOptions");
        DataPanelSettings dataPanelSettings = heapWindowSettings.getDataPanelSettings();
        this.dataPanel.onExit(dataPanelSettings);
        dataPanelSettings.setHideUnrelated(this.hideUnrelatedCheckBox.isSelected());
        heapWindowSettings.setIgnoreSoftWeak(this.ignoreSoftWeakCheckBox.isSelected());
        if (Version.DEBUG_BUILD != 0) {
            dataPanelSettings.setShowOnlyRootAncestors(this.rootsOnlyCheckBox.isSelected());
            heapWindowSettings.setMaximumDepth(this.maximumDepthBox.getIntValue());
        }
    }
}

