/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.PropertyAccess;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditWatchDialog;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class InspectorWindow
extends DataWindow {
    private InspectorWindowSettings inspectorWindowSettings = InspectorWindowSettings.getInstance();
    private static IdeAction actionEditExpression;
    private static IdeAction actionPin;
    private static IdeAction actionUnpin;
    private static IdeAction actionViewWhole;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemEditExpression;
    private static JMenuItem menuitemSettings;
    private static final int EDIT_EXPRESSION_CMD_ID;
    private static final int PIN_CMD_ID;
    private static final int UNPIN_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String INSPECTOR_WINDOW_ID = "Debugger.InspectorWindow";
    private static int countInspectorWindows;
    private static final String expHistoryName = "DebuggerInspector";
    private static final String INSPECTOR_KEY_EXPRESSION = ".expression";

    static {
        EDIT_EXPRESSION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorEditExpression");
        PIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorPin");
        UNPIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorUnpin");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorViewWhole");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorSettings");
        countInspectorWindows = 0;
    }

    InspectorWindow(String string, Object object) {
        super(string, DbgArb.getString(654), "f1_deb_inspectorwindow_html");
        InspectorWindow.makeActions();
        if (object != null) {
            this.setDataPanel(new InspectorPanel(object));
        } else {
            this.setDataPanel(new InspectorPanel());
            InspectorWindow.useInspectorWindowId(string);
        }
    }

    public String getTitleName() {
        String string = this.title;
        if (this.dataPanel != null) {
            EvaluatorItem evaluatorItem = InspectorPanel.ra$ei((InspectorPanel)this.dataPanel);
            String string2 = evaluatorItem.getName();
            string = string2 != null ? string + " - " + string2 : string + " - " + evaluatorItem.getExpression();
        }
        return string;
    }

    void shutDown() {
        this.saveSettings();
        InspectorPanel.mav$saveExpression((InspectorPanel)this.dataPanel, (PropertyAccess)Ide.getIdeProperties());
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        InspectorWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEditExpression), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionPin), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUnpin), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    private static void makeActions() {
        if (actionEditExpression == null) {
            actionEditExpression = IdeAction.get((int)EDIT_EXPRESSION_CMD_ID, null, (String)DbgArb.getString(655), null, (Integer)DbgArb.getInteger(656), null, (int)-1, null, (boolean)false);
            actionEditExpression.setEnabled(false);
            actionPin = IdeAction.get((int)PIN_CMD_ID, null, (String)DbgArb.getString(682), null, (Integer)DbgArb.getInteger(683), null, (int)-1, null, (boolean)false);
            actionPin.setEnabled(false);
            actionUnpin = IdeAction.get((int)UNPIN_CMD_ID, null, (String)DbgArb.getString(684), null, (Integer)DbgArb.getInteger(685), null, (int)-1, null, (boolean)false);
            actionUnpin.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(317), null, (Integer)DbgArb.getInteger(318), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(319), null, (Integer)DbgArb.getInteger(320), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(321), null, (Integer)DbgArb.getInteger(322), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(323), null, (Integer)DbgArb.getInteger(324), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(325), null, (Integer)DbgArb.getInteger(326), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(327), null, (Integer)DbgArb.getInteger(328), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(341), null, (Integer)DbgArb.getInteger(342), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(343), null, (Integer)DbgArb.getInteger(344), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(329), null, (Integer)DbgArb.getInteger(331), null, (int)-1, null, (boolean)false);
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(332), null, (Integer)DbgArb.getInteger(334), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(335), null, (Integer)DbgArb.getInteger(337), null, (int)-1, null, (boolean)false);
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(345), null, (Integer)DbgArb.getInteger(346), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(347, ""), null, (Integer)DbgArb.getInteger(348), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    void inspectorActiveView(boolean bl) {
        if (bl) {
            this.setControllerForActions();
        } else {
            this.clearControllerForActions();
        }
    }

    private IdeAction[] getActions() {
        return new IdeAction[]{actionEditExpression, actionPin, actionUnpin, actionViewWhole, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = this.getActions();
        JDebugger.setControllerForActions(ideActionArray, this.dataPanel);
    }

    private void clearControllerForActions() {
        IdeAction[] ideActionArray = this.getActions();
        JDebugger.clearControllerForActions(ideActionArray, this.dataPanel);
    }

    static String inspectDialog(String string) {
        String string2;
        String string3 = DbgArb.getString(659);
        string = EditWatchDialog.showEditWatchDialog(string3, string2 = DbgArb.getString(660), expHistoryName, string);
        if (string != null) {
            return string;
        }
        return null;
    }

    static String getNewInspectorWindowId() {
        return INSPECTOR_WINDOW_ID + countInspectorWindows++;
    }

    private static void useInspectorWindowId(String string) {
        if (string.startsWith(INSPECTOR_WINDOW_ID)) {
            try {
                String string2 = string.substring(INSPECTOR_WINDOW_ID.length());
                int n = Integer.parseInt(string2);
                if (countInspectorWindows < n) {
                    countInspectorWindows = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isInspectorWindowId(String string) {
        if (string.startsWith(INSPECTOR_WINDOW_ID)) {
            int n = INSPECTOR_WINDOW_ID.length();
            String string2 = string.substring(n);
            try {
                int n2 = Integer.parseInt(string2);
                boolean bl = n2 < countInspectorWindows;
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int getType() {
        return super.getType() | 1;
    }

    public void stateChange(int n) {
        super.stateChange(n);
        if (n == 3) {
            JDebugger.getInstance().removeInspectorWindow(this);
        }
    }

    void removeInspector() {
        InspectorPanel.mav$removeInspector((InspectorPanel)this.dataPanel);
    }

    static int ra$EDIT_EXPRESSION_CMD_ID() {
        return EDIT_EXPRESSION_CMD_ID;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionEditExpression() {
        return actionEditExpression;
    }

    static JMenuItem ra$menuitemEditExpression() {
        return menuitemEditExpression;
    }

    static void wa$menuitemEditExpression(JMenuItem jMenuItem) {
        menuitemEditExpression = jMenuItem;
    }

    static IdeAction ra$actionPin() {
        return actionPin;
    }

    static IdeAction ra$actionUnpin() {
        return actionUnpin;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$PIN_CMD_ID() {
        return PIN_CMD_ID;
    }

    static int ra$UNPIN_CMD_ID() {
        return UNPIN_CMD_ID;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    static InspectorWindowSettings ra$inspectorWindowSettings(InspectorWindow inspectorWindow) {
        return inspectorWindow.inspectorWindowSettings;
    }

    final class InspectorPanel
    extends EvaluatorPanel {
        private EvaluatorItem ei;

        InspectorPanel() {
            super(InspectorWindow.this, InspectorWindow.ra$inspectorWindowSettings(InspectorWindow.this).getDataPanelSettings());
            this.loadExpression((PropertyAccess)Ide.getIdeProperties());
            this.hookUpActions();
        }

        InspectorPanel(Object object) {
            super(InspectorWindow.this, InspectorWindow.ra$inspectorWindowSettings(InspectorWindow.this).getDataPanelSettings());
            if (object instanceof EvaluatorItem) {
                this.ei = (EvaluatorItem)object;
            } else if (object instanceof String) {
                this.ei = new EvaluatorItem((String)object);
            }
            this.hookUpActions();
        }

        private void hookUpActions() {
            this._actionPin = InspectorWindow.ra$actionPin();
            this._actionUnpin = InspectorWindow.ra$actionUnpin();
            this._actionViewWhole = InspectorWindow.ra$actionViewWhole();
            this._actionAdjustRange = InspectorWindow.ra$actionAdjustRange();
            this._actionToggleValue = InspectorWindow.ra$actionToggleValue();
            this._actionModifyValue = InspectorWindow.ra$actionModifyValue();
            this._actionWatch = InspectorWindow.ra$actionWatch();
            this._actionInspect = InspectorWindow.ra$actionInspect();
            this._actionWatchClassLoader = InspectorWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = InspectorWindow.ra$actionInspectClassLoader();
            this._actionGoto = InspectorWindow.ra$actionGoto();
            this._actionGotoDeclared = InspectorWindow.ra$actionGotoDeclared();
            this._actionGotoField = InspectorWindow.ra$actionGotoField();
            this._actionUseFilters = InspectorWindow.ra$actionUseFilters();
            this._actionObjectPreferences = InspectorWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = InspectorWindow.ra$actionCollapseAll();
            this._actionSave = InspectorWindow.ra$actionSave();
            this._PIN_CMD_ID = InspectorWindow.ra$PIN_CMD_ID();
            this._UNPIN_CMD_ID = InspectorWindow.ra$UNPIN_CMD_ID();
            this._VIEW_WHOLE_CMD_ID = InspectorWindow.ra$VIEW_WHOLE_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = InspectorWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = InspectorWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = InspectorWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = InspectorWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = InspectorWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = InspectorWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = InspectorWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = InspectorWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = InspectorWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = InspectorWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = InspectorWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = InspectorWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = InspectorWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = InspectorWindow.ra$SAVE_CMD_ID();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            if (this.ei.isPinned(debuggingProcess)) {
                this.ei.unpin(debuggingProcess);
            }
            super.processFinished(debuggingProcess);
            if (this.ei.getTemporary() == debuggingProcess) {
                InspectorWindow.this.close();
            }
        }

        private String getKeyPrefix() {
            return this.dockableWindow.getId();
        }

        private void loadExpression(PropertyAccess propertyAccess) {
            String string = this.getKeyPrefix();
            String string2 = propertyAccess.getProperty(string + InspectorWindow.INSPECTOR_KEY_EXPRESSION, "");
            this.ei = string2 != null ? new EvaluatorItem(string2) : new EvaluatorItem("");
        }

        private void saveExpression(PropertyAccess propertyAccess) {
            String string = this.getKeyPrefix();
            String string2 = this.ei.getExpression();
            propertyAccess.setProperty(string + InspectorWindow.INSPECTOR_KEY_EXPRESSION, string2);
        }

        private void removeSavedExpression(PropertyAccess propertyAccess) {
            String string = this.getKeyPrefix();
            propertyAccess.setProperty(string + InspectorWindow.INSPECTOR_KEY_EXPRESSION, null);
        }

        private void removeInspector() {
            this.removeSavedExpression((PropertyAccess)Ide.getIdeProperties());
            if (this.ei != null) {
                this.ei.unpinForAll();
            }
        }

        protected void addPopupMenuItemsForDataItem(ContextMenu contextMenu, Context context) {
            this.update(InspectorWindow.ra$actionEditExpression(), context);
            if (InspectorWindow.ra$actionEditExpression().isEnabled()) {
                if (InspectorWindow.ra$menuitemEditExpression() == null) {
                    InspectorWindow.wa$menuitemEditExpression(contextMenu.createMenuItem((ToggleAction)InspectorWindow.ra$actionEditExpression()));
                }
                contextMenu.add((Component)InspectorWindow.ra$menuitemEditExpression(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(contextMenu, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(InspectorWindow.ra$actionSettings(), context);
            if (InspectorWindow.ra$actionSettings().isEnabled()) {
                if (InspectorWindow.ra$menuitemSettings() == null) {
                    InspectorWindow.wa$menuitemSettings(contextMenu.createMenuItem((ToggleAction)InspectorWindow.ra$actionSettings()));
                }
                contextMenu.add((Component)InspectorWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == InspectorWindow.ra$SETTINGS_CMD_ID())) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == InspectorWindow.ra$EDIT_EXPRESSION_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null) {
                    EvaluatorPanel.EvaluatorDataItem evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem;
                    ideAction.setEnabled(evaluatorDataItem.canEditExpression());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == InspectorWindow.ra$SETTINGS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == InspectorWindow.ra$EDIT_EXPRESSION_CMD_ID()) {
                EvaluatorPanel.EvaluatorDataItem evaluatorDataItem;
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null && (evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem).canEditExpression()) {
                    this.editExpression(evaluatorDataItem, treePath);
                }
                return true;
            }
            if (n == InspectorWindow.ra$SETTINGS_CMD_ID()) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(786)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        private void editExpression(EvaluatorPanel.EvaluatorDataItem evaluatorDataItem, TreePath treePath) {
            if (evaluatorDataItem.editExpression(DbgArb.getString(657), DbgArb.getString(658), InspectorWindow.expHistoryName, treePath)) {
                this.dockableWindow.updateTitle(null);
            }
        }

        protected void addDataItems() {
            List list = this.getRoot();
            this.addDataItem(list, this.ei, false, false);
        }

        static void mav$removeInspector(InspectorPanel inspectorPanel) {
            inspectorPanel.removeInspector();
        }

        static void mav$saveExpression(InspectorPanel inspectorPanel, PropertyAccess propertyAccess) {
            inspectorPanel.saveExpression(propertyAccess);
        }

        static EvaluatorItem ra$ei(InspectorPanel inspectorPanel) {
            return inspectorPanel.ei;
        }
    }
}

