/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.Compiler;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.DebuggerAdapter;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.runner.RunManager;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointsWindow;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettingsPanel2;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.ClassesWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugConfigurationPanel;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebugWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.HeapWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.InspectorWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.JavaEvaluator;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.LocalsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.MonitorsWindowDataSettingsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.MonitorsWindowThreadsSettingsPanel;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.RemoteDebugSettingsPanel;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SmartJava;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;
import oracle.jdevimpl.runner.debug.SmartWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.StackWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ToolTipEvaluator;
import oracle.jdevimpl.runner.debug.ToolTipJava;
import oracle.jdevimpl.runner.debug.TracingPanel;
import oracle.jdevimpl.runner.debug.WatchWindow;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;
import oracle.jdevimpl.runner.debug.WatchWindowSettingsPanel;
import oracle.jdevimpl.runner.run.JRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDebugger
extends Debugger
implements BuildSystemListener,
ViewSelectionListener,
IdeListener,
ShutdownHook,
Addin,
CursorListener,
Observer,
MenuListener,
CEToolTipProvider,
GutterClickListener,
EditorListener,
Controller,
ContextMenuListener,
ActiveViewListener {
    private static JDebugger instance;
    private DebugDockableFactory debugDockableFactory;
    private IdeLayout debugLayout;
    private DebugWindowSettings dbgSettings;
    private static ContextMenu contextMenu;
    static URL lastSavedFile;
    private Workspace activeWorkspace;
    private Project activeProject;
    private View activeView;
    private CodeEditor activeCodeEditor;
    private List[] activeBreakpoints;
    private InspectorWindow activeInspector;
    private DebuggingProcess activeDebuggingProcess;
    private volatile int duringClassRedefinition;
    private boolean isToolTipProvider;
    private ToolTipEvaluator toolTipEvaluator;
    private Map breakpointForDebugBreakpoint;
    private List<DebuggingProcess> debuggingProcesses;
    private List<DebuggingProcess> debuggingProcessesConnecting;
    private List<DebuggingListener> debuggingListeners;
    private List debuggerListeners;
    private BreakpointsWindow breakpointsWindow;
    private ThreadsWindow threadsWindow;
    private StackWindow stackWindow;
    private SmartWindow smartWindow;
    private LocalsWindow localsWindow;
    private WatchWindow watchWindow;
    private ClassesWindow classesWindow;
    private HeapWindow heapWindow;
    private MonitorsWindow monitorsWindow;
    private List inspectorWindows;
    private ObjectPreferences objectPreferences;
    private static JMenu viewDebuggerSubMenu;
    private static boolean viewDebuggerSubMenuBuilt;
    private static JMenu debugMenu;
    private static boolean debugMenuBuilt;
    private static JMenu debugContextSubMenu;
    private static boolean debugContextSubMenuAdded;
    private static boolean debugContextSubMenuBuilt;
    private static List<SmartDataProvider> smartDataProviders;
    private static List<ToolTipExpressionProvider> toolTipExpressionProviders;
    private static List<IdeAction> viewDebuggerActions;
    private static IdeAction actionViewBreakpoints;
    private static IdeAction actionViewThreads;
    private static IdeAction actionViewStack;
    private static IdeAction actionViewSmart;
    private static IdeAction actionViewLocals;
    private static IdeAction actionViewWatches;
    private static IdeAction actionViewClasses;
    private static IdeAction actionViewHeap;
    private static IdeAction actionViewMonitors;
    private static IdeAction actionDebugProject;
    private static IdeAction actionEmpty;
    private static IdeAction actionDebugSelection;
    private static IdeAction actionDebugToggleBreakpoint;
    private static IdeAction actionDebugPause;
    private static IdeAction actionDebugResume;
    private static IdeAction actionDebugDetach;
    private static IdeAction actionDebugReset;
    private static IdeAction actionDebugStepOver;
    private static IdeAction actionDebugStepOverBC;
    private static IdeAction actionDebugStepInto;
    private static IdeAction actionDebugStepIntoBC;
    private static IdeAction actionDebugStepOut;
    private static IdeAction actionDebugStepToEndOfMethod;
    private static IdeAction actionDebugContinueStep;
    private static IdeAction actionDebugRunToCursor;
    private static IdeAction actionDebugSetNextStatement;
    private static IdeAction actionDebugShowIP;
    private static IdeAction actionDebugGC;
    private static IdeAction actionContextMenuDebug;
    public static Component debugContextMenu;
    private static IdeAction actionNavigatorStopListening;
    private static IdeAction actionNavigatorDetachDebugger;
    private static JMenuItem menuitemNavigatorStopListening;
    private static JMenuItem menuitemNavigatorDetachDebugger;
    private static IdeAction actionCodeEditorGutterToggleBreakpoint;
    private static IdeAction actionCodeEditorToggleWatchpoint;
    private static IdeAction actionCodeEditorGutterEnableBreakpoint;
    private static IdeAction actionCodeEditorGutterDisableBreakpoint;
    private static IdeAction actionCodeEditorGutterEditBreakpoint;
    private static IdeAction actionCodeEditorWatch;
    private static IdeAction actionCodeEditorInspect;
    private static JMenuItem menuitemCodeEditorGutterToggleBreakpoint;
    private static JMenuItem menuitemCodeEditorToggleWatchpoint;
    private static JMenuItem menuitemCodeEditorGutterEnableBreakpoint;
    private static JMenuItem menuitemCodeEditorGutterDisableBreakpoint;
    private static JMenuItem menuitemCodeEditorGutterEditBreakpoint;
    private static JMenuItem menuitemCodeEditorRunToCursor;
    private static JMenuItem menuitemCodeEditorSetNextStatement;
    private static JMenuItem menuitemCodeEditorWatch;
    private static JMenuItem menuitemCodeEditorInspect;
    private static IdeAction actionStructureCreateWatchpoint;
    private static JMenuItem menuitemStructureCreateWatchpoint;
    private static IdeAction actionLogWindowCancelDebugConnection;
    private static IdeAction actionLogWindowShowIP;
    private static IdeAction actionLogWindowResume;
    private static IdeAction actionLogWindowStepOver;
    private static IdeAction actionLogWindowStepInto;
    private static IdeAction actionLogWindowStepOut;
    private static IdeAction actionLogWindowStepToEndOfMethod;
    private static IdeAction actionLogWindowStepOverBC;
    private static IdeAction actionLogWindowStepIntoBC;
    private static IdeAction actionLogWindowPause;
    private static IdeAction actionLogWindowReset;
    private static IdeAction actionLogWindowGC;
    private static JMenuItem menuitemLogWindowCancelDebugConnection;
    private static final int VIEW_BREAKPOINTS_CMD_ID;
    private static final int VIEW_THREADS_CMD_ID;
    private static final int VIEW_STACK_CMD_ID;
    private static final int VIEW_SMART_CMD_ID;
    private static final int VIEW_LOCALS_CMD_ID;
    private static final int VIEW_WATCHES_CMD_ID;
    private static final int VIEW_CLASSES_CMD_ID;
    private static final int VIEW_HEAP_CMD_ID;
    private static final int VIEW_MONITORS_CMD_ID;
    private static final String DEBUG_PROJECT_CMD_PREFIX = "DebugProjectCommand";
    private static final int DEBUG_PROJECT_CMD_ID;
    private static int[] debugProjectCmdIds;
    private static final int DEBUG_SELECTION_CMD_ID;
    private static final int DEBUG_PAUSE_CMD_ID;
    private static final int DEBUG_RESUME_CMD_ID;
    private static final int DEBUG_DETACH_CMD_ID;
    private static final int DEBUG_RESET_CMD_ID;
    private static final int DEBUG_STEPOVER_CMD_ID;
    private static final int DEBUG_STEPOVERBC_CMD_ID;
    private static final int DEBUG_STEPINTO_CMD_ID;
    private static final int DEBUG_STEPINTOBC_CMD_ID;
    private static final int DEBUG_STEPOUT_CMD_ID;
    private static final int DEBUG_STEPTOENDOFMETHOD_CMD_ID;
    private static final int DEBUG_CONTINUESTEP_CMD_ID;
    private static final int DEBUG_RUNTOCURSOR_CMD_ID;
    private static final int DEBUG_SETNEXTSTATEMENT_CMD_ID;
    private static final int DEBUG_SHOWIP_CMD_ID;
    private static final int DEBUG_GC_CMD_ID;
    private static final int CONTEXTMENU_DEBUG_CMD_ID;
    private static final int NAVIGATOR_STOPLISTENING_CMD_ID;
    private static final int NAVIGATOR_DETACHDEBUGGER_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_WATCH_CMD_ID;
    private static final int CODE_EDITOR_INSPECT_CMD_ID;
    private static final int STRUCTURE_CREATEWATCHPOINT_CMD_ID;
    private static final int LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID;
    private static final int LOG_WINDOW_SHOWIP_CMD_ID;
    private static final int LOG_WINDOW_RESUME_CMD_ID;
    private static final int LOG_WINDOW_STEPOVER_CMD_ID;
    private static final int LOG_WINDOW_STEPINTO_CMD_ID;
    private static final int LOG_WINDOW_STEPOUT_CMD_ID;
    private static final int LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID;
    private static final int LOG_WINDOW_STEPOVERBC_CMD_ID;
    private static final int LOG_WINDOW_STEPINTOBC_CMD_ID;
    private static final int LOG_WINDOW_PAUSE_CMD_ID;
    private static final int LOG_WINDOW_RESET_CMD_ID;
    private static final int LOG_WINDOW_GC_CMD_ID;
    static final String ACTION_OWNER = "Debugger.actionOwner";
    static final String DEBUGGER_ID = "Debugger";
    static final String DEBUG_LAYOUT_KEY = "debugLayout";
    volatile boolean firstDebuggingProcessCreated;

    static {
        lastSavedFile = null;
        viewDebuggerSubMenuBuilt = false;
        debugMenuBuilt = false;
        debugContextSubMenuAdded = false;
        debugContextSubMenuBuilt = false;
        smartDataProviders = new ArrayList<SmartDataProvider>();
        toolTipExpressionProviders = new ArrayList<ToolTipExpressionProvider>();
        viewDebuggerActions = new ArrayList<IdeAction>();
        VIEW_BREAKPOINTS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugBreakpointsCommand");
        VIEW_THREADS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugThreadsCommand");
        VIEW_STACK_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugStackCommand");
        VIEW_SMART_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugSmartCommand");
        VIEW_LOCALS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugLocalsCommand");
        VIEW_WATCHES_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugWatchesCommand");
        VIEW_CLASSES_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugClassesCommand");
        VIEW_HEAP_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugHeapCommand");
        VIEW_MONITORS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugMonitorsCommand");
        DEBUG_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)DEBUG_PROJECT_CMD_PREFIX);
        debugProjectCmdIds = new int[0];
        DEBUG_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");
        DEBUG_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPauseCommand");
        DEBUG_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResumeCommand");
        DEBUG_DETACH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugDetachCommand");
        DEBUG_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResetCommand");
        DEBUG_STEPOVER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverCommand");
        DEBUG_STEPOVERBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverBCCommand");
        DEBUG_STEPINTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoCommand");
        DEBUG_STEPINTOBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoBCCommand");
        DEBUG_STEPOUT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOutCommand");
        DEBUG_STEPTOENDOFMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepToEndOfMethodCommand");
        DEBUG_CONTINUESTEP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugContinueStepCommand");
        DEBUG_RUNTOCURSOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugRunToCursorCommand");
        DEBUG_SETNEXTSTATEMENT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSetNextStatementCommand");
        DEBUG_SHOWIP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugShowIPCommand");
        DEBUG_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugGCCommand");
        CONTEXTMENU_DEBUG_CMD_ID = Ide.findOrCreateCmdID((String)"ContextMenuDebug");
        NAVIGATOR_STOPLISTENING_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorStopListening");
        NAVIGATOR_DETACHDEBUGGER_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorDetachDebugger");
        CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorToggleBreakpointCommand");
        CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorToggleWatchpointCommand");
        CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorEnableBreakpointCommand");
        CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorDisableBreakpointCommand");
        CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorEditBreakpointCommand");
        CODE_EDITOR_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorWatchCommand");
        CODE_EDITOR_INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorInspectCommand");
        STRUCTURE_CREATEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStructureCreateWatchpointCommand");
        LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowCancelDebugConnectionCommand");
        LOG_WINDOW_SHOWIP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowShowIPCommand");
        LOG_WINDOW_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowResumeCommand");
        LOG_WINDOW_STEPOVER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepOverCommand");
        LOG_WINDOW_STEPINTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepIntoCommand");
        LOG_WINDOW_STEPOUT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepOutCommand");
        LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepToEndOfMethodCommand");
        LOG_WINDOW_STEPOVERBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepOverBCCommand");
        LOG_WINDOW_STEPINTOBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepIntoBCCommand");
        LOG_WINDOW_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowPauseCommand");
        LOG_WINDOW_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowResetCommand");
        LOG_WINDOW_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowGCCommand");
    }

    void $init$() {
        this.activeBreakpoints = new List[0];
        this.debuggerListeners = new ArrayList();
        this.firstDebuggingProcessCreated = true;
    }

    public JDebugger() throws SingletonClassException {
        this.$init$();
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.debug.JDebugger");
        }
        instance = this;
    }

    public static JDebugger getInstance() {
        return instance;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_BREAKPOINTS_CMD_ID) {
            this.viewBreakpoints();
            return true;
        }
        if (n == VIEW_THREADS_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getThreadsWindow(true));
            return true;
        }
        if (n == VIEW_STACK_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getStackWindow(true));
            return true;
        }
        if (n == VIEW_SMART_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getSmartWindow(true));
            return true;
        }
        if (n == VIEW_LOCALS_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getLocalsWindow(true));
            return true;
        }
        if (n == VIEW_WATCHES_CMD_ID) {
            this.viewWatches();
            return true;
        }
        if (n == VIEW_CLASSES_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getClassesWindow(true));
            return true;
        }
        if (n == VIEW_HEAP_CMD_ID) {
            this.viewHeap();
            return true;
        }
        if (n == VIEW_MONITORS_CMD_ID) {
            this.viewMonitors();
            return true;
        }
        if (n == DEBUG_PROJECT_CMD_ID) {
            this.startProcess(null);
            return true;
        }
        if (RunManager.arrayContains(debugProjectCmdIds, n)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)ideAction.getValue("UserData"));
            RunConfigurations.setActiveRunConfiguration(this.activeProject, runConfiguration);
            this.startProcess(null);
            return true;
        }
        if (n == DEBUG_SELECTION_CMD_ID) {
            this.startProcess(context);
            return true;
        }
        if (n == DEBUG_PAUSE_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.pause();
            }
            return true;
        }
        if (n == DEBUG_RESUME_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.resume();
            }
            return true;
        }
        if (n == DEBUG_DETACH_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.detach();
            }
            return true;
        }
        if (n == DEBUG_RESET_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.terminate();
            }
            return true;
        }
        if (n == DEBUG_STEPOVER_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOver(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (n == DEBUG_STEPOVERBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOverBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (n == DEBUG_STEPINTO_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (n == DEBUG_STEPINTOBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (n == DEBUG_STEPOUT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOut(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (n == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (n == DEBUG_CONTINUESTEP_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.continueStep();
            }
            return true;
        }
        if (n == DEBUG_RUNTOCURSOR_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.runToCursor(context);
            }
            return true;
        }
        if (n == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.setNextStatement(context);
            }
            return true;
        }
        if (n == DEBUG_SHOWIP_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.showIP();
            }
            return true;
        }
        if (n == DEBUG_GC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.gc();
            }
            return true;
        }
        if (n == CONTEXTMENU_DEBUG_CMD_ID) {
            context = (Context)ideAction.getValue("UserData");
            ideAction.putValue("UserData", null);
            this.startProcess(context);
            return true;
        }
        if (n == NAVIGATOR_STOPLISTENING_CMD_ID) {
            this.stopListening(context);
            return true;
        }
        if (n == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            this.detachDebugger(context);
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID) {
            this.toggleBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            this.toggleWatchpointFromCodeEditor(context, null);
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID) {
            this.enableBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID) {
            this.disableBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID) {
            this.editBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (n == CODE_EDITOR_WATCH_CMD_ID) {
            this.watchFromCodeEditor(context);
            return true;
        }
        if (n == CODE_EDITOR_INSPECT_CMD_ID) {
            this.inspectFromCodeEditor(context);
            return true;
        }
        if (n == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            this.createWatchpointFromStructure(context, null);
            return true;
        }
        if (n == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID || n == LOG_WINDOW_SHOWIP_CMD_ID || n == LOG_WINDOW_RESUME_CMD_ID || n == LOG_WINDOW_STEPOVER_CMD_ID || n == LOG_WINDOW_STEPINTO_CMD_ID || n == LOG_WINDOW_STEPOUT_CMD_ID || n == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID || n == LOG_WINDOW_STEPOVERBC_CMD_ID || n == LOG_WINDOW_STEPINTOBC_CMD_ID || n == LOG_WINDOW_PAUSE_CMD_ID || n == LOG_WINDOW_RESET_CMD_ID || n == LOG_WINDOW_GC_CMD_ID) {
            this.doLogWindowAction(context, n);
            return true;
        }
        return n == 5 || n == 6 || n == 18 || n == 17 || n == 78 || n == 19;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEBUG_PROJECT_CMD_ID) {
            this.updateDebugProjectAction(ideAction);
            return true;
        }
        if (RunManager.arrayContains(debugProjectCmdIds, n)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)ideAction.getValue("UserData"));
            boolean bl = RunConfigurations.isActiveRunConfiguration(this.activeProject, runConfiguration);
            ideAction.setState(bl);
            return true;
        }
        if (n == DEBUG_SELECTION_CMD_ID) {
            this.updateDebugSelectionAction(ideAction, context);
            return true;
        }
        if (n == DEBUG_PAUSE_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPause());
            return true;
        }
        if (n == DEBUG_RESUME_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canResume());
            return true;
        }
        if (n == DEBUG_DETACH_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canDetach());
            return true;
        }
        if (n == DEBUG_RESET_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canTerminate());
            return true;
        }
        if (n == DEBUG_STEPOVER_CMD_ID || n == DEBUG_STEPOVERBC_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOver());
            return true;
        }
        if (n == DEBUG_STEPINTO_CMD_ID || n == DEBUG_STEPINTOBC_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepInto());
            return true;
        }
        if (n == DEBUG_STEPOUT_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOut());
            return true;
        }
        if (n == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepToEndOfMethod());
            return true;
        }
        if (n == DEBUG_CONTINUESTEP_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canContinueStep());
            return true;
        }
        if (n == DEBUG_RUNTOCURSOR_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canRunToCursor(context));
            return true;
        }
        if (n == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canSetNextStatement(context));
            return true;
        }
        if (n == DEBUG_SHOWIP_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canShowIP());
            return true;
        }
        if (n == DEBUG_GC_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canGC());
            return true;
        }
        if (n == VIEW_BREAKPOINTS_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == VIEW_THREADS_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (n == VIEW_CLASSES_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (n == VIEW_STACK_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (n == VIEW_SMART_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (n == VIEW_LOCALS_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (n == VIEW_WATCHES_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (n == VIEW_HEAP_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows() && this.canShowHeapWindow());
            return true;
        }
        if (n == VIEW_MONITORS_CMD_ID) {
            ideAction.setEnabled(this.canShowDebuggingWindows() && this.canShowMonitorsWindow());
            return true;
        }
        if (n == CONTEXTMENU_DEBUG_CMD_ID) {
            context = (Context)ideAction.getValue("UserData");
            this.updateContextMenuDebugAction(ideAction, context);
            return true;
        }
        if (n == NAVIGATOR_STOPLISTENING_CMD_ID) {
            ideAction.setEnabled(this.canStopListening(context));
            return true;
        }
        if (n == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            ideAction.setEnabled(this.canDetachDebugger(context));
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID) {
            ideAction.setEnabled(this.toggleBreakpointFromCodeEditor(context, ideAction));
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            ideAction.setEnabled(this.toggleWatchpointFromCodeEditor(context, ideAction));
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID) {
            ideAction.setEnabled(this.enableBreakpointFromCodeEditor(context, ideAction));
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID) {
            ideAction.setEnabled(this.disableBreakpointFromCodeEditor(context, ideAction));
            return true;
        }
        if (n == CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID) {
            ideAction.setEnabled(this.editBreakpointFromCodeEditor(context, ideAction));
            return true;
        }
        if (n == CODE_EDITOR_WATCH_CMD_ID || n == CODE_EDITOR_INSPECT_CMD_ID) {
            ideAction.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped());
            return true;
        }
        if (n == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            ideAction.setEnabled(this.createWatchpointFromStructure(context, ideAction));
            return true;
        }
        if (n == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID || n == LOG_WINDOW_SHOWIP_CMD_ID || n == LOG_WINDOW_RESUME_CMD_ID || n == LOG_WINDOW_STEPOVER_CMD_ID || n == LOG_WINDOW_STEPINTO_CMD_ID || n == LOG_WINDOW_STEPOUT_CMD_ID || n == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID || n == LOG_WINDOW_STEPOVERBC_CMD_ID || n == LOG_WINDOW_STEPINTOBC_CMD_ID || n == LOG_WINDOW_PAUSE_CMD_ID || n == LOG_WINDOW_RESET_CMD_ID || n == LOG_WINDOW_GC_CMD_ID) {
            ideAction.setEnabled(this.canDoLogWindowAction(context, n));
            return true;
        }
        if (n == 5 || n == 6 || n == 18 || n == 17 || n == 78 || n == 19) {
            ideAction.setEnabled(false);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        DebuggingProcess debuggingProcess;
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view instanceof NavigatorWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(contextMenu, context);
            if (actionNavigatorStopListening != null) {
                this.update(actionNavigatorStopListening, context);
                if (actionNavigatorStopListening.isEnabled()) {
                    if (menuitemNavigatorStopListening == null) {
                        menuitemNavigatorStopListening = contextMenu.createMenuItem((ToggleAction)actionNavigatorStopListening);
                    }
                    contextMenu.add((Component)menuitemNavigatorStopListening, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionNavigatorDetachDebugger != null) {
                this.update(actionNavigatorDetachDebugger, context);
                if (actionNavigatorDetachDebugger.isEnabled()) {
                    if (menuitemNavigatorDetachDebugger == null) {
                        menuitemNavigatorDetachDebugger = contextMenu.createMenuItem((ToggleAction)actionNavigatorDetachDebugger);
                    }
                    contextMenu.add((Component)menuitemNavigatorDetachDebugger, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
        } else if (view instanceof Editor) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(contextMenu, context);
            this.update(actionCodeEditorToggleWatchpoint, context);
            if (actionCodeEditorToggleWatchpoint.isEnabled()) {
                if (menuitemCodeEditorToggleWatchpoint == null) {
                    menuitemCodeEditorToggleWatchpoint = contextMenu.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                contextMenu.add((Component)menuitemCodeEditorToggleWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugRunToCursor, context);
            if (actionDebugRunToCursor.isEnabled()) {
                if (menuitemCodeEditorRunToCursor == null) {
                    menuitemCodeEditorRunToCursor = contextMenu.createMenuItem((ToggleAction)actionDebugRunToCursor, JDeveloperMenuConstants.WEIGHT_DEBUG_RUN_TO_CURSOR);
                }
                contextMenu.add((Component)menuitemCodeEditorRunToCursor, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugSetNextStatement, context);
            if (actionDebugSetNextStatement.isEnabled()) {
                if (menuitemCodeEditorSetNextStatement == null) {
                    menuitemCodeEditorSetNextStatement = contextMenu.createMenuItem((ToggleAction)actionDebugSetNextStatement, JDeveloperMenuConstants.WEIGHT_DEBUG_SET_NEXT_STATEMENT);
                }
                contextMenu.add((Component)menuitemCodeEditorSetNextStatement, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionCodeEditorWatch, context);
            if (actionCodeEditorWatch.isEnabled()) {
                if (menuitemCodeEditorWatch == null) {
                    menuitemCodeEditorWatch = contextMenu.createMenuItem((ToggleAction)actionCodeEditorWatch, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_WATCH);
                }
                contextMenu.add((Component)menuitemCodeEditorWatch, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionCodeEditorInspect, context);
            if (actionCodeEditorInspect.isEnabled()) {
                if (menuitemCodeEditorInspect == null) {
                    menuitemCodeEditorInspect = contextMenu.createMenuItem((ToggleAction)actionCodeEditorInspect, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_INSPECT);
                }
                contextMenu.add((Component)menuitemCodeEditorInspect, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        } else if (view instanceof CodeEditorGutter.GutterView) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
                return;
            }
            this.update(actionCodeEditorGutterToggleBreakpoint, context);
            if (actionCodeEditorGutterToggleBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterToggleBreakpoint == null) {
                    menuitemCodeEditorGutterToggleBreakpoint = contextMenu.createMenuItem((ToggleAction)actionCodeEditorGutterToggleBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                contextMenu.add((Component)menuitemCodeEditorGutterToggleBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorToggleWatchpoint, context);
            if (actionCodeEditorToggleWatchpoint.isEnabled()) {
                if (menuitemCodeEditorToggleWatchpoint == null) {
                    menuitemCodeEditorToggleWatchpoint = contextMenu.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                contextMenu.add((Component)menuitemCodeEditorToggleWatchpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterEnableBreakpoint, context);
            if (actionCodeEditorGutterEnableBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterEnableBreakpoint == null) {
                    menuitemCodeEditorGutterEnableBreakpoint = contextMenu.createMenuItem((ToggleAction)actionCodeEditorGutterEnableBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_ENABLE_BREAKPOINT);
                }
                contextMenu.add((Component)menuitemCodeEditorGutterEnableBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterDisableBreakpoint, context);
            if (actionCodeEditorGutterDisableBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterDisableBreakpoint == null) {
                    menuitemCodeEditorGutterDisableBreakpoint = contextMenu.createMenuItem((ToggleAction)actionCodeEditorGutterDisableBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_ENABLE_BREAKPOINT);
                }
                contextMenu.add((Component)menuitemCodeEditorGutterDisableBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterEditBreakpoint, context);
            if (actionCodeEditorGutterEditBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterEditBreakpoint == null) {
                    menuitemCodeEditorGutterEditBreakpoint = contextMenu.createMenuItem((ToggleAction)actionCodeEditorGutterEditBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_EDIT_BREAKPOINT);
                }
                contextMenu.add((Component)menuitemCodeEditorGutterEditBreakpoint, 3.0f);
            }
        } else if (view instanceof ExplorerWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.update(actionStructureCreateWatchpoint, context);
            if (actionStructureCreateWatchpoint.isEnabled()) {
                if (menuitemStructureCreateWatchpoint == null) {
                    menuitemStructureCreateWatchpoint = contextMenu.createMenuItem((ToggleAction)actionStructureCreateWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                contextMenu.add((Component)menuitemStructureCreateWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        } else if (view instanceof RunLogPage && (debuggingProcess = this.findDebuggingProcess((RunLogPage)view, true)) != null) {
            this.update(actionLogWindowCancelDebugConnection, context);
            if (actionLogWindowCancelDebugConnection.isEnabled()) {
                if (menuitemLogWindowCancelDebugConnection == null) {
                    menuitemLogWindowCancelDebugConnection = contextMenu.createMenuItem((ToggleAction)actionLogWindowCancelDebugConnection);
                }
                contextMenu.add((Component)menuitemLogWindowCancelDebugConnection, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
        RunnableItem.reset();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void insertRunnableItems(ContextMenu contextMenu, Context context) {
        if (actionContextMenuDebug == null) {
            actionContextMenuDebug = IdeAction.get((int)CONTEXTMENU_DEBUG_CMD_ID, null, (String)DbgArb.getString(113), null, (Integer)DbgArb.getInteger(115), (ArrayResourceBundle)DbgArb.getInstance(), (int)116, null, (boolean)false);
            actionContextMenuDebug.putValue("NoCtxName", (Object)DbgArb.getString(113));
            actionContextMenuDebug.addController((Controller)this);
        }
        actionContextMenuDebug.putValue("UserData", (Object)context);
        this.update(actionContextMenuDebug, context);
        if (actionContextMenuDebug.isEnabled()) {
            MnemonicSolver.MenuLabel menuLabel;
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)actionContextMenuDebug, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_FILE);
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            MnemonicSolver mnemonicSolver = contextMenu.getMnemonicSolver();
            if (mnemonicSolver != null && (menuLabel = mnemonicSolver.findMenuLabel(jMenuItem)) != null) {
                menuLabel.setText(DbgArb.getString(113));
            }
        } else {
            actionContextMenuDebug.putValue("UserData", null);
        }
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            SourceIcon.gutterCreated(codeEditor);
            CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
            codeEditorGutter.addGutterClickListener((GutterClickListener)this);
            if (this.isToolTipProvider) {
                codeEditor.addCEToolTipProvider((CEToolTipProvider)this);
            }
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            SourceIcon.gutterDestroyed(codeEditor);
            CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
            codeEditorGutter.removeGutterClickListener((GutterClickListener)this);
            if (this.isToolTipProvider) {
                codeEditor.removeCEToolTipProvider((CEToolTipProvider)this);
            }
        }
    }

    public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
        CodeEditorGutter codeEditorGutter;
        Context context;
        if (gutter instanceof CodeEditorGutter && (context = (codeEditorGutter = (CodeEditorGutter)gutter).getContext()) != null) {
            this.toggleBreakpoint(context, codeEditorGutter.getCodeEditor(), n);
        }
    }

    public String getToolTipText(CodeEditor codeEditor, MouseEvent mouseEvent, int n) {
        if (this.shouldProvideToolTip()) {
            if (this.toolTipEvaluator == null) {
                this.toolTipEvaluator = new ToolTipEvaluator(this);
            }
            String string = this.toolTipEvaluator.getToolTip(codeEditor, n);
            return string;
        }
        return null;
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (this.activeView != null) {
            this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
        }
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.removeCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(false);
        }
        this.activeView = Ide.getMainWindow().getLastActiveView();
        Context context = this.activeView.getContext();
        this.activeCodeEditor = Source.getCodeEditorFromContext(context);
        InspectorWindow inspectorWindow = this.activeInspector = this.activeView instanceof InspectorWindow ? (InspectorWindow)this.activeView : null;
        if (this.activeView != null) {
            this.activeView.addViewSelectionListener((ViewSelectionListener)this);
        }
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.addCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(true);
        }
        this.checkCommandsBecauseActiveViewChanged();
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        this.checkCommandsBecauseViewSelectionChanged();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        15 var3_3 = new 15(this, updateMessage, object);
        if (SwingUtilities.isEventDispatchThread()) {
            var3_3.run();
        } else {
            SwingUtilities.invokeLater(var3_3);
        }
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        Ide.removeIdeListener((IdeListener)this);
        Breakpoint.loadBreakpoints();
        JDebugger.registerPanels();
        SourceIcon.createHighlightStyles();
        this.activeViewChanged(null);
        this.activeProjectChanged();
        Ide.getSystem().attach((Observer)this);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)this);
        }
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        LogManager.getLogManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)this);
        ExplorerManager.getExplorerManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        RefactoringManager refactoringManager = RefactoringManager.getRefactoringManager();
        if (refactoringManager != null) {
            refactoringManager.registerUrlHandler(Breakpoint.getRefactoringHandler(), 0.5);
        }
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 14());
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
        Ide.getSystem().detach((Observer)this);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.removeBuildSystemListener((BuildSystemListener)this);
        }
        NavigatorManager.getWorkspaceNavigatorManager().removeContextMenuListener((ContextMenuListener)this);
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        LogManager.getLogManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().removeContextMenuListener((ContextMenuListener)this);
        ExplorerManager.getExplorerManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
    }

    public void cursorUpdate(CodeEditor codeEditor) {
        this.checkCommandsBecauseCursorMoved();
    }

    public void initialize() {
        Debugger.setDebugger((Debugger)this);
        this.initializeIDESettings();
        this.dbgSettings = DebugWindowSettings.getInstance();
        this.dbgSettings.addChangeListener(new 13());
        this.makeActions();
        this.declareShortcuts();
        this.addViewDebuggerSubMenu();
        this.addDebugMenu();
        this.debugDockableFactory = new DebugDockableFactory(this);
        this.getDebugLayout();
        EditorManager.getEditorManager().addEditorListener((EditorListener)this);
        Ide.addIdeListener((IdeListener)this);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        EditorManager.getEditorManager().removeEditorListener((EditorListener)this);
        if (this.debuggingListeners != null) {
            int n = this.debuggingListeners.size() - 1;
            while (n >= 0) {
                DebuggingListener debuggingListener = this.debuggingListeners.get(n);
                debuggingListener.stopListening();
                --n;
            }
        }
        if (this.debuggingProcesses != null) {
            int n = this.debuggingProcesses.size() - 1;
            while (n >= 0) {
                DebuggingProcess debuggingProcess = this.debuggingProcesses.get(n);
                debuggingProcess.terminate();
                --n;
            }
        }
        if (this.objectPreferences != null) {
            this.objectPreferences.save();
        }
        Breakpoint.saveBreakpoints();
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.shutDown();
        }
        if (this.threadsWindow != null) {
            this.threadsWindow.shutDown();
        }
        if (this.stackWindow != null) {
            this.stackWindow.shutDown();
        }
        if (this.smartWindow != null) {
            this.smartWindow.shutDown();
        }
        if (this.localsWindow != null) {
            this.localsWindow.shutDown();
        }
        if (this.watchWindow != null) {
            this.watchWindow.shutDown();
        }
        if (this.classesWindow != null) {
            this.classesWindow.shutDown();
        }
        if (this.heapWindow != null) {
            this.heapWindow.shutDown();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.shutDown();
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.shutDown();
            }
        }
    }

    public void buildWillStart(Context context) {
        SwingUtilities.invokeLater(new 12());
    }

    public void buildFinished(int n, int n2, int n3) {
        new 11("JDebuggerWaitForCompiler").start();
    }

    public JMenu getDebugMenu() {
        return debugMenu;
    }

    public synchronized ContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
        }
        return contextMenu;
    }

    public boolean isDebugging() {
        if (this.debuggingProcesses != null) {
            return this.debuggingProcesses.isEmpty() ^ true;
        }
        return false;
    }

    public void startDebugger(Context context, DebuggerStartCallback debuggerStartCallback) {
        DebuggingProcess debuggingProcess = new DebuggingProcess(context, debuggerStartCallback);
        debuggingProcess.start();
    }

    public void redefineClasses(Map map) {
        this.redefineClasses(null, map);
    }

    public void redefineClasses(Project project, Map map) {
        URL uRL = project == null ? null : JavaProject.getInstance(project).getOutputDirectory();
        HashMap hashMap = new HashMap();
        hashMap.putAll(map);
        ++this.duringClassRedefinition;
        10 var5_5 = new 10(this, uRL, hashMap);
        9 var6_6 = new 9();
        this.pauseAndInvoke(var5_5, var6_6);
    }

    public boolean isStackTraceLine(String string) {
        try {
            int n = string.indexOf(40);
            if (n != -1) {
                int n2;
                int n3 = string.lastIndexOf(32, n);
                int n4 = string.lastIndexOf(46, n);
                int n5 = string.indexOf(58, n);
                if (n3 != -1 && n4 != -1 && n5 != -1 && n4 > n3 + 1 && n5 > n + 1 && (n2 = string.indexOf(41, n5)) != -1 && n2 > n5 + 1) {
                    int n6 = Integer.parseInt(string.substring(n5 + 1, n2));
                    String string2 = string.substring(n3 + 1, n4);
                    String string3 = string.substring(n + 1, n5);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, String string) {
        try {
            int n = string.indexOf(40);
            if (n != -1) {
                int n2;
                int n3 = string.lastIndexOf(32, n);
                int n4 = string.lastIndexOf(46, n);
                int n5 = string.indexOf(58, n);
                if (n3 != -1 && n4 != -1 && n5 != -1 && n4 > n3 + 1 && n5 > n + 1 && (n2 = string.indexOf(41, n5)) != -1 && n2 > n5 + 1) {
                    int n6 = Integer.parseInt(string.substring(n5 + 1, n2));
                    String string2 = string.substring(n3 + 1, n4);
                    String string3 = string.substring(n + 1, n5);
                    int n7 = string2.lastIndexOf(46);
                    String string4 = n7 != -1 ? string2.substring(0, n7) : "";
                    boolean bl = Source.showSourceFile(workspace, project, string4, string2, string3, n6, false, null);
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public URL parseStackTraceLine(Workspace workspace, Project project, String string) {
        try {
            int n = string.indexOf(40);
            if (n != -1) {
                int n2;
                int n3 = string.lastIndexOf(32, n);
                int n4 = string.lastIndexOf(46, n);
                int n5 = string.indexOf(58, n);
                if (n3 != -1 && n4 != -1 && n5 != -1 && n4 > n3 + 1 && n5 > n + 1 && (n2 = string.indexOf(41, n5)) != -1 && n2 > n5 + 1) {
                    URL uRL;
                    int n6 = Integer.parseInt(string.substring(n5 + 1, n2));
                    String string2 = string.substring(n3 + 1, n4);
                    String string3 = string.substring(n + 1, n5);
                    int n7 = string2.lastIndexOf(46);
                    String string4 = n7 != -1 ? string2.substring(0, n7) : "";
                    URL uRL2 = Source.findSourceFile(workspace, project, string4, string3);
                    URL uRL3 = uRL = URLFactory.replaceRefPart((URL)uRL2, (String)Integer.toString(n6));
                    return uRL3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, URL uRL) {
        int n = 0;
        try {
            String string = uRL.getRef();
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL uRL2 = URLFactory.replaceRefPart((URL)uRL, null);
        return Source.showSourceFile(workspace, project, uRL2, n, true);
    }

    public void addSmartDataProvider(SmartDataProvider smartDataProvider) {
        smartDataProviders.add(smartDataProvider);
    }

    public void removeSmartDataProvider(SmartDataProvider smartDataProvider) {
        smartDataProviders.remove(smartDataProvider);
    }

    public void addToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        toolTipExpressionProviders.add(toolTipExpressionProvider);
    }

    public void removeToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        toolTipExpressionProviders.remove(toolTipExpressionProvider);
    }

    public void addRunAndDebugToContextMenu(ContextMenu contextMenu, Context context) {
        JRunner.getInstance().insertRunnableItems(contextMenu, context);
        this.insertRunnableItems(contextMenu, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebuggerListener(DebuggerAdapter debuggerAdapter) {
        List list = this.debuggerListeners;
        synchronized (list) {
            if (!this.debuggerListeners.contains(debuggerAdapter)) {
                this.debuggerListeners.add(debuggerAdapter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerListener(DebuggerAdapter debuggerAdapter) {
        List list = this.debuggerListeners;
        synchronized (list) {
            this.debuggerListeners.remove(debuggerAdapter);
        }
    }

    public Object evaluateNumericExpression(String string) {
        JavaEvaluator javaEvaluator = new JavaEvaluator(new DebugContext(), false);
        Object object = javaEvaluator.evaluate(string);
        if (object instanceof EvaluationInfo) {
            EvaluationInfo evaluationInfo = (EvaluationInfo)object;
            return evaluationInfo.getWrappedValue();
        }
        return null;
    }

    public void addObjectPreferencesExpression(String string, String string2, boolean bl) {
        this.getObjectPreferences();
        this.objectPreferences.addValueExpressionSuggestion(string, string2);
        if (bl) {
            this.objectPreferences.setValueExpression(string, string2);
        }
    }

    public void addObjectPreferencesExpansion(String string, String string2, boolean bl) {
        this.getObjectPreferences();
        this.objectPreferences.addExpandExpressionSuggestion(string, string2);
        if (bl) {
            this.objectPreferences.setExpandExpression(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebuggerAdapter[] getDebuggerListeners() {
        List list = this.debuggerListeners;
        synchronized (list) {
            DebuggerAdapter[] debuggerAdapterArray = this.debuggerListeners.toArray(new DebuggerAdapter[this.debuggerListeners.size()]);
            return debuggerAdapterArray;
        }
    }

    synchronized IdeLayout getDebugLayout() {
        if (this.debugLayout == null) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            URL uRL = extensionRegistry.getSystemDirectory("oracle.ide");
            String string = uRL.getPath() + "Debugging" + ".layout";
            this.debugLayout = new IdeLayout(URLFactory.newFileURL((String)string), DbgArb.getString(588), DbgArb.getInstance(), 589);
            this.debugLayout.setProperty(DEBUG_LAYOUT_KEY, Boolean.toString(true));
            Layouts.getLayouts().add((Element)this.debugLayout);
        }
        return this.debugLayout;
    }

    private void makeActions() {
        String string = DbgArb.getString(0);
        int n = Ide.findOrCreateCmdID((String)"DebugProjectCommandEmpty");
        actionEmpty = IdeAction.get((int)n, null, (String)RunMgrArb.getString(2), (String)string, null, null, null, (boolean)false);
        actionDebugProject = IdeAction.get((int)DEBUG_PROJECT_CMD_ID, null, (String)DbgArb.getString(2), (String)string, (Integer)DbgArb.getInteger(4), (ArrayResourceBundle)DbgArb.getInstance(), (int)5, null, (boolean)false);
        actionDebugProject.putValue("NoCtxName", (Object)DbgArb.getString(2));
        actionDebugProject.addController((Controller)this);
        actionDebugProject.putValue("ActionMenuActions", (Object)new IdeAction[]{actionEmpty});
        actionDebugSelection = IdeAction.get((int)DEBUG_SELECTION_CMD_ID, null, (String)DbgArb.getString(6), (String)string, (Integer)DbgArb.getInteger(8), (ArrayResourceBundle)DbgArb.getInstance(), (int)9, null, (boolean)false);
        actionDebugSelection.putValue("NoCtxName", (Object)DbgArb.getString(6));
        actionDebugSelection.addController((Controller)this);
        actionDebugToggleBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(128), (String)string, (Integer)DbgArb.getInteger(129), (ArrayResourceBundle)DbgArb.getInstance(), (int)130, null, (boolean)false);
        actionDebugToggleBreakpoint.addController((Controller)this);
        actionDebugPause = IdeAction.get((int)DEBUG_PAUSE_CMD_ID, null, (String)DbgArb.getString(10), (String)string, (Integer)DbgArb.getInteger(11), (ArrayResourceBundle)DbgArb.getInstance(), (int)12, null, (boolean)false);
        actionDebugPause.addController((Controller)this);
        actionDebugResume = IdeAction.get((int)DEBUG_RESUME_CMD_ID, null, (String)DbgArb.getString(13), (String)string, (Integer)DbgArb.getInteger(14), (ArrayResourceBundle)DbgArb.getInstance(), (int)15, null, (boolean)false);
        actionDebugResume.addController((Controller)this);
        actionDebugDetach = IdeAction.get((int)DEBUG_DETACH_CMD_ID, null, (String)DbgArb.getString(16), (String)string, (Integer)DbgArb.getInteger(17), (ArrayResourceBundle)DbgArb.getInstance(), (int)18, null, (boolean)false);
        actionDebugDetach.addController((Controller)this);
        actionDebugReset = IdeAction.get((int)DEBUG_RESET_CMD_ID, null, (String)IdeArb.getString((int)148), (String)string, null, (ArrayResourceBundle)IdeArb.getInstance(), (int)150, null, (boolean)false);
        actionDebugReset.addController((Controller)this);
        actionDebugStepOver = IdeAction.get((int)DEBUG_STEPOVER_CMD_ID, null, (String)DbgArb.getString(19), (String)string, (Integer)DbgArb.getInteger(20), (ArrayResourceBundle)DbgArb.getInstance(), (int)21, null, (boolean)false);
        actionDebugStepOver.addController((Controller)this);
        actionDebugStepOverBC = IdeAction.get((int)DEBUG_STEPOVERBC_CMD_ID, null, (String)DbgArb.getString(22), (String)string, (Integer)DbgArb.getInteger(23), (ArrayResourceBundle)DbgArb.getInstance(), (int)24, null, (boolean)false);
        actionDebugStepOverBC.addController((Controller)this);
        actionDebugStepInto = IdeAction.get((int)DEBUG_STEPINTO_CMD_ID, null, (String)DbgArb.getString(25), (String)string, (Integer)DbgArb.getInteger(26), (ArrayResourceBundle)DbgArb.getInstance(), (int)27, null, (boolean)false);
        actionDebugStepInto.addController((Controller)this);
        actionDebugStepIntoBC = IdeAction.get((int)DEBUG_STEPINTOBC_CMD_ID, null, (String)DbgArb.getString(28), (String)string, (Integer)DbgArb.getInteger(29), (ArrayResourceBundle)DbgArb.getInstance(), (int)30, null, (boolean)false);
        actionDebugStepIntoBC.addController((Controller)this);
        actionDebugStepOut = IdeAction.get((int)DEBUG_STEPOUT_CMD_ID, null, (String)DbgArb.getString(31), (String)string, (Integer)DbgArb.getInteger(32), (ArrayResourceBundle)DbgArb.getInstance(), (int)33, null, (boolean)false);
        actionDebugStepOut.addController((Controller)this);
        actionDebugStepToEndOfMethod = IdeAction.get((int)DEBUG_STEPTOENDOFMETHOD_CMD_ID, null, (String)DbgArb.getString(34), (String)string, (Integer)DbgArb.getInteger(35), (ArrayResourceBundle)DbgArb.getInstance(), (int)36, null, (boolean)false);
        actionDebugStepToEndOfMethod.addController((Controller)this);
        actionDebugContinueStep = IdeAction.get((int)DEBUG_CONTINUESTEP_CMD_ID, null, (String)DbgArb.getString(37), (String)string, (Integer)DbgArb.getInteger(38), (ArrayResourceBundle)DbgArb.getInstance(), (int)39, null, (boolean)false);
        actionDebugContinueStep.addController((Controller)this);
        actionDebugRunToCursor = IdeAction.get((int)DEBUG_RUNTOCURSOR_CMD_ID, null, (String)DbgArb.getString(40), (String)string, (Integer)DbgArb.getInteger(41), (ArrayResourceBundle)DbgArb.getInstance(), (int)42, null, (boolean)false);
        actionDebugRunToCursor.addController((Controller)this);
        actionDebugSetNextStatement = IdeAction.get((int)DEBUG_SETNEXTSTATEMENT_CMD_ID, null, (String)DbgArb.getString(47), (String)string, (Integer)DbgArb.getInteger(48), (ArrayResourceBundle)DbgArb.getInstance(), (int)49, null, (boolean)false);
        actionDebugSetNextStatement.addController((Controller)this);
        actionDebugShowIP = IdeAction.get((int)DEBUG_SHOWIP_CMD_ID, null, (String)DbgArb.getString(50), (String)string, (Integer)DbgArb.getInteger(51), (ArrayResourceBundle)DbgArb.getInstance(), (int)52, null, (boolean)false);
        actionDebugShowIP.addController((Controller)this);
        actionDebugGC = IdeAction.get((int)DEBUG_GC_CMD_ID, null, (String)DbgArb.getString(53), (String)string, (Integer)DbgArb.getInteger(54), (ArrayResourceBundle)DbgArb.getInstance(), (int)55, null, (boolean)false);
        actionDebugGC.addController((Controller)this);
        String string2 = IdeMainWindow.ACTION_CATEGORY_VIEW;
        actionViewBreakpoints = IdeAction.get((int)VIEW_BREAKPOINTS_CMD_ID, null, (String)DbgArb.getString(58), (String)string2, (Integer)DbgArb.getInteger(59), (ArrayResourceBundle)DbgArb.getInstance(), (int)60, null, (boolean)true);
        actionViewBreakpoints.addController((Controller)this);
        actionViewThreads = IdeAction.get((int)VIEW_THREADS_CMD_ID, null, (String)DbgArb.getString(61), (String)string2, (Integer)DbgArb.getInteger(62), (ArrayResourceBundle)DbgArb.getInstance(), (int)63, null, (boolean)false);
        actionViewThreads.addController((Controller)this);
        actionViewStack = IdeAction.get((int)VIEW_STACK_CMD_ID, null, (String)DbgArb.getString(64), (String)string2, (Integer)DbgArb.getInteger(65), (ArrayResourceBundle)DbgArb.getInstance(), (int)66, null, (boolean)false);
        actionViewStack.addController((Controller)this);
        actionViewSmart = IdeAction.get((int)VIEW_SMART_CMD_ID, null, (String)DbgArb.getString(67), (String)string2, (Integer)DbgArb.getInteger(68), (ArrayResourceBundle)DbgArb.getInstance(), (int)69, null, (boolean)false);
        actionViewSmart.addController((Controller)this);
        actionViewLocals = IdeAction.get((int)VIEW_LOCALS_CMD_ID, null, (String)DbgArb.getString(70), (String)string2, (Integer)DbgArb.getInteger(71), (ArrayResourceBundle)JavaIcons.getInstance(), (int)2, null, (boolean)false);
        actionViewLocals.addController((Controller)this);
        actionViewWatches = IdeAction.get((int)VIEW_WATCHES_CMD_ID, null, (String)DbgArb.getString(72), (String)string2, (Integer)DbgArb.getInteger(73), (ArrayResourceBundle)DbgArb.getInstance(), (int)74, null, (boolean)false);
        actionViewWatches.addController((Controller)this);
        actionViewClasses = IdeAction.get((int)VIEW_CLASSES_CMD_ID, null, (String)DbgArb.getString(75), (String)string2, (Integer)DbgArb.getInteger(76), (ArrayResourceBundle)JavaIcons.getInstance(), (int)0, null, (boolean)false);
        actionViewClasses.addController((Controller)this);
        actionViewHeap = IdeAction.get((int)VIEW_HEAP_CMD_ID, null, (String)DbgArb.getString(77), (String)string2, (Integer)DbgArb.getInteger(78), (ArrayResourceBundle)DbgArb.getInstance(), (int)79, null, (boolean)false);
        actionViewHeap.addController((Controller)this);
        actionViewMonitors = IdeAction.get((int)VIEW_MONITORS_CMD_ID, null, (String)DbgArb.getString(80), (String)string2, (Integer)DbgArb.getInteger(81), (ArrayResourceBundle)DbgArb.getInstance(), (int)82, null, (boolean)false);
        actionViewMonitors.addController((Controller)this);
        viewDebuggerActions.add(actionViewBreakpoints);
        viewDebuggerActions.add(actionViewStack);
        viewDebuggerActions.add(actionViewSmart);
        viewDebuggerActions.add(actionViewLocals);
        viewDebuggerActions.add(actionViewWatches);
        if (!Product.isRaptor()) {
            viewDebuggerActions.add(actionViewThreads);
            viewDebuggerActions.add(actionViewClasses);
            viewDebuggerActions.add(actionViewHeap);
            viewDebuggerActions.add(actionViewMonitors);
        }
        Collections.sort(viewDebuggerActions, new 8());
        actionCodeEditorGutterToggleBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(128), (String)string, (Integer)DbgArb.getInteger(129), (ArrayResourceBundle)DbgArb.getInstance(), (int)130, null, (boolean)false);
        actionCodeEditorGutterToggleBreakpoint.addController((Controller)this);
        actionCodeEditorToggleWatchpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID, null, (String)DbgArb.getString(131), (String)string, (Integer)DbgArb.getInteger(132), (ArrayResourceBundle)DbgArb.getInstance(), (int)133, null, (boolean)false);
        actionCodeEditorToggleWatchpoint.addController((Controller)this);
        actionCodeEditorGutterEnableBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(134), (String)string, (Integer)DbgArb.getInteger(136), (ArrayResourceBundle)DbgArb.getInstance(), (int)137, null, (boolean)false);
        actionCodeEditorGutterEnableBreakpoint.addController((Controller)this);
        actionCodeEditorGutterDisableBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(138), (String)string, (Integer)DbgArb.getInteger(140), (ArrayResourceBundle)DbgArb.getInstance(), (int)141, null, (boolean)false);
        actionCodeEditorGutterDisableBreakpoint.addController((Controller)this);
        actionCodeEditorGutterEditBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(142), (String)string, (Integer)DbgArb.getInteger(144), (ArrayResourceBundle)DbgArb.getInstance(), (int)145, null, (boolean)false);
        actionCodeEditorGutterEditBreakpoint.addController((Controller)this);
        actionCodeEditorWatch = IdeAction.get((int)CODE_EDITOR_WATCH_CMD_ID, null, (String)DbgArb.getString(146), (String)string, (Integer)DbgArb.getInteger(147), (ArrayResourceBundle)DbgArb.getInstance(), (int)148, null, (boolean)false);
        actionCodeEditorWatch.addController((Controller)this);
        actionCodeEditorInspect = IdeAction.get((int)CODE_EDITOR_INSPECT_CMD_ID, null, (String)DbgArb.getString(149), (String)string, (Integer)DbgArb.getInteger(150), (ArrayResourceBundle)DbgArb.getInstance(), (int)151, null, (boolean)false);
        actionCodeEditorInspect.addController((Controller)this);
        actionStructureCreateWatchpoint = IdeAction.get((int)STRUCTURE_CREATEWATCHPOINT_CMD_ID, null, (String)DbgArb.getString(158), (String)string, (Integer)DbgArb.getInteger(159), (ArrayResourceBundle)DbgArb.getInstance(), (int)160, null, (boolean)false);
        actionStructureCreateWatchpoint.addController((Controller)this);
    }

    void makeDebuggingListenerActions() {
        if (actionNavigatorStopListening != null) {
            return;
        }
        actionNavigatorStopListening = IdeAction.get((int)NAVIGATOR_STOPLISTENING_CMD_ID, null, (String)DbgArb.getString(122), null, (Integer)DbgArb.getInteger(123), (ArrayResourceBundle)DbgArb.getInstance(), (int)124, null, (boolean)false);
        actionNavigatorStopListening.addController((Controller)this);
    }

    private void makeDebuggingProcessActions() {
        if (actionNavigatorDetachDebugger != null) {
            return;
        }
        actionNavigatorDetachDebugger = IdeAction.get((int)NAVIGATOR_DETACHDEBUGGER_CMD_ID, null, (String)DbgArb.getString(125), null, (Integer)DbgArb.getInteger(126), (ArrayResourceBundle)DbgArb.getInstance(), (int)127, null, (boolean)false);
        actionNavigatorDetachDebugger.addController((Controller)this);
        actionLogWindowCancelDebugConnection = IdeAction.get((int)LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID, null, (String)DbgArb.getString(161), null, (Integer)DbgArb.getInteger(162), (ArrayResourceBundle)IdeArb.getInstance(), (int)150, null, (boolean)false);
        actionLogWindowCancelDebugConnection.addController((Controller)this);
        actionLogWindowShowIP = IdeAction.get((int)LOG_WINDOW_SHOWIP_CMD_ID, null, (String)DbgArb.getString(163), null, (Integer)DbgArb.getInteger(164), (ArrayResourceBundle)DbgArb.getInstance(), (int)165, null, (boolean)false);
        actionLogWindowShowIP.addController((Controller)this);
        actionLogWindowResume = IdeAction.get((int)LOG_WINDOW_RESUME_CMD_ID, null, (String)DbgArb.getString(166), null, (Integer)DbgArb.getInteger(167), (ArrayResourceBundle)DbgArb.getInstance(), (int)168, null, (boolean)false);
        actionLogWindowResume.addController((Controller)this);
        actionLogWindowStepOver = IdeAction.get((int)LOG_WINDOW_STEPOVER_CMD_ID, null, (String)DbgArb.getString(169), null, (Integer)DbgArb.getInteger(170), (ArrayResourceBundle)DbgArb.getInstance(), (int)171, null, (boolean)false);
        actionLogWindowStepOver.addController((Controller)this);
        actionLogWindowStepInto = IdeAction.get((int)LOG_WINDOW_STEPINTO_CMD_ID, null, (String)DbgArb.getString(172), null, (Integer)DbgArb.getInteger(173), (ArrayResourceBundle)DbgArb.getInstance(), (int)174, null, (boolean)false);
        actionLogWindowStepInto.addController((Controller)this);
        actionLogWindowStepOut = IdeAction.get((int)LOG_WINDOW_STEPOUT_CMD_ID, null, (String)DbgArb.getString(175), null, (Integer)DbgArb.getInteger(176), (ArrayResourceBundle)DbgArb.getInstance(), (int)177, null, (boolean)false);
        actionLogWindowStepOut.addController((Controller)this);
        actionLogWindowStepToEndOfMethod = IdeAction.get((int)LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID, null, (String)DbgArb.getString(178), null, (Integer)DbgArb.getInteger(179), (ArrayResourceBundle)DbgArb.getInstance(), (int)180, null, (boolean)false);
        actionLogWindowStepToEndOfMethod.addController((Controller)this);
        actionLogWindowStepOverBC = IdeAction.get((int)LOG_WINDOW_STEPOVERBC_CMD_ID, null, (String)DbgArb.getString(181), null, (Integer)DbgArb.getInteger(182), (ArrayResourceBundle)DbgArb.getInstance(), (int)183, null, (boolean)false);
        actionLogWindowStepOverBC.addController((Controller)this);
        actionLogWindowStepIntoBC = IdeAction.get((int)LOG_WINDOW_STEPINTOBC_CMD_ID, null, (String)DbgArb.getString(184), null, (Integer)DbgArb.getInteger(185), (ArrayResourceBundle)DbgArb.getInstance(), (int)186, null, (boolean)false);
        actionLogWindowStepIntoBC.addController((Controller)this);
        actionLogWindowPause = IdeAction.get((int)LOG_WINDOW_PAUSE_CMD_ID, null, (String)DbgArb.getString(187), null, (Integer)DbgArb.getInteger(188), (ArrayResourceBundle)DbgArb.getInstance(), (int)189, null, (boolean)false);
        actionLogWindowPause.addController((Controller)this);
        actionLogWindowReset = IdeAction.get((int)LOG_WINDOW_RESET_CMD_ID, null, (String)IdeArb.getString((int)148), null, (Integer)IdeArb.getInteger((int)149), (ArrayResourceBundle)IdeArb.getInstance(), (int)150, null, (boolean)false);
        actionLogWindowReset.addController((Controller)this);
        actionLogWindowGC = IdeAction.get((int)LOG_WINDOW_GC_CMD_ID, null, (String)DbgArb.getString(190), null, (Integer)DbgArb.getInteger(191), (ArrayResourceBundle)DbgArb.getInstance(), (int)192, null, (boolean)false);
        actionLogWindowGC.addController((Controller)this);
    }

    private void addViewDebuggerSubMenu() {
        Menubar menubar = Ide.getMenubar();
        viewDebuggerSubMenu = menubar.createSubMenu(DbgArb.getString(56), DbgArb.getInteger(57), JDeveloperMenuConstants.WEIGHT_VIEW_DEBUGGER);
        viewDebuggerSubMenu.addMenuListener(this);
        if (viewDebuggerActions.size() > 0) {
            viewDebuggerSubMenu.add(menubar.createMenuItem((ToggleAction)viewDebuggerActions.get(0)));
        }
        menubar.add((Component)viewDebuggerSubMenu, MenuManager.getJMenu((String)"View"), JDeveloperMenuConstants.SECTION_VIEW_DEBUG_RUN);
    }

    private void addDebugMenu() {
        Menubar menubar = Ide.getMenubar();
        debugMenu = menubar.createMenu(DbgArb.getString(0), DbgArb.getInteger(1), JDeveloperMenuConstants.WEIGHT_DEBUG_MENU, JDeveloperMenuConstants.SECTION_DEBUG_ADDINS);
        debugMenu.addMenuListener(this);
        menubar.add((Component)debugMenu);
    }

    private void declareShortcuts() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/debug/accelerators.xml");
    }

    static String getExtensionID() {
        return AddinManager.getAddinManager().getExtensionIDForAddin(JDebugger.class);
    }

    private void initializeIDESettings() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)AddinManager.getAddinManager().getExtensionForAddin((Addin)this).getID());
        if (!clientSetting.hasData("DebugWindowOptions")) {
            clientSetting.putData("DebugWindowOptions", (Copyable)new DebugWindowSettings());
        }
        if (!clientSetting.hasData("BreakpointsWindowOptions")) {
            clientSetting.putData("BreakpointsWindowOptions", (Copyable)new BreakpointsWindowSettings());
        }
        if (!clientSetting.hasData("InspectorWindowOptions")) {
            clientSetting.putData("InspectorWindowOptions", (Copyable)new InspectorWindowSettings());
        }
        if (!clientSetting.hasData("LocalsWindowOptions")) {
            clientSetting.putData("LocalsWindowOptions", (Copyable)new LocalsWindowSettings());
        }
        if (!clientSetting.hasData("SmartWindowOptions")) {
            clientSetting.putData("SmartWindowOptions", (Copyable)new SmartWindowSettings());
        }
        if (!clientSetting.hasData("StackWindowOptions")) {
            clientSetting.putData("StackWindowOptions", (Copyable)new StackWindowSettings());
        }
        if (!clientSetting.hasData("WatchWindowOptions")) {
            clientSetting.putData("WatchWindowOptions", (Copyable)new WatchWindowSettings());
        }
        if (!clientSetting.hasData("ThreadsWindowOptions")) {
            clientSetting.putData("ThreadsWindowOptions", (Copyable)new ThreadsWindowSettings());
        }
        if (!clientSetting.hasData("ClassesWindowOptions")) {
            clientSetting.putData("ClassesWindowOptions", (Copyable)new ClassesWindowSettings());
        }
        if (!clientSetting.hasData("HeapWindowOptions")) {
            clientSetting.putData("HeapWindowOptions", (Copyable)new HeapWindowSettings());
        }
        if (!clientSetting.hasData("MonitorsWindowOptions")) {
            clientSetting.putData("MonitorsWindowOptions", (Copyable)new MonitorsWindowSettings());
        }
    }

    private static void registerPanels() {
        Navigable navigable = new Navigable(DbgArb.getString(716), DebugWindowSettingsPanel.class);
        Navigable navigable2 = new Navigable(DbgArb.getString(733), BreakpointsWindowSettingsPanel.class);
        Navigable navigable3 = new Navigable(DbgArb.getString(734), BreakpointsWindowSettingsPanel2.class);
        navigable2.addChildNavigable(navigable3);
        navigable.addChildNavigable(navigable2);
        navigable2 = new Navigable(DbgArb.getString(756), StackWindowSettingsPanel.class);
        navigable.addChildNavigable(navigable2);
        navigable2 = new Navigable(DbgArb.getString(782), SmartWindowSettingsPanel.class);
        navigable.addChildNavigable(navigable2);
        navigable2 = new Navigable(DbgArb.getString(762), LocalsWindowSettingsPanel.class);
        navigable.addChildNavigable(navigable2);
        navigable2 = new Navigable(DbgArb.getString(781), WatchWindowSettingsPanel.class);
        navigable.addChildNavigable(navigable2);
        navigable2 = new Navigable(DbgArb.getString(786), InspectorWindowSettingsPanel.class);
        navigable.addChildNavigable(navigable2);
        if (!Product.isRaptor()) {
            navigable2 = new Navigable(DbgArb.getString(749), ThreadsWindowSettingsPanel.class);
            navigable.addChildNavigable(navigable2);
            navigable2 = new Navigable(DbgArb.getString(787), ClassesWindowSettingsPanel.class);
            navigable.addChildNavigable(navigable2);
            navigable2 = new Navigable(DbgArb.getString(807), HeapWindowSettingsPanel.class);
            navigable.addChildNavigable(navigable2);
            navigable2 = new Navigable(DbgArb.getString(812), MonitorsWindowDataSettingsPanel.class);
            navigable3 = new Navigable(DbgArb.getString(813), MonitorsWindowThreadsSettingsPanel.class);
            navigable2.addChildNavigable(navigable3);
            navigable.addChildNavigable(navigable2);
        }
        IdeSettings.registerUI((Navigable)navigable);
        navigable2 = new Navigable(DbgArb.getString(893), DebugConfigurationPanel.class);
        navigable3 = new Navigable(DbgArb.getString(364), RemoteDebugSettingsPanel.class);
        navigable2.addChildNavigable(navigable3);
        Runner.getRunner().addRunConfigurationToolNavigable(navigable2);
    }

    private void activeProjectChanged() {
        if (this.activeWorkspace != null) {
            this.activeWorkspace.detach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        Workspace workspace = this.activeWorkspace;
        Project project = this.activeProject;
        this.activeWorkspace = Ide.getActiveWorkspace();
        this.activeProject = Ide.getActiveProject();
        if (this.activeWorkspace != null) {
            this.activeWorkspace.attach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
        this.updateRunConfigurationList();
        this.checkCommandsBecauseActiveProjectChanged();
        if (this.activeWorkspace != workspace || this.activeProject != project || this.activeBreakpoints.length == 0) {
            Breakpoint.hideBreakpointIcons(this.activeBreakpoints);
            this.activeBreakpoints = Breakpoint.getBreakpoints(this.activeWorkspace, this.activeProject);
            Breakpoint.showBreakpointIcons(this.activeBreakpoints);
            if (this.breakpointsWindow != null) {
                this.breakpointsWindow.setBreakpoints(this.activeWorkspace, this.activeProject, this.activeBreakpoints);
            }
        }
    }

    private void debugWindowSettingsChanged() {
        if (debugMenuBuilt) {
            if (this.dbgSettings.isContextMenusOnMainMenu()) {
                if (!debugContextSubMenuAdded) {
                    debugMenu.add(debugContextSubMenu);
                    debugContextSubMenuAdded = true;
                }
            } else if (debugContextSubMenuAdded) {
                debugMenu.remove(debugContextSubMenu);
                debugContextSubMenuAdded = false;
            }
        }
        this.updateToolTipProvider();
        boolean bl = this.dbgSettings.isShowToolbarInLogWindow();
        if (this.debuggingProcessesConnecting != null) {
            int n = this.debuggingProcessesConnecting.size() - 1;
            while (n >= 0) {
                DebuggingProcess debuggingProcess = this.debuggingProcessesConnecting.get(n);
                debuggingProcess.updateToolbarVisibility(bl);
                --n;
            }
        }
        if (this.debuggingProcesses != null) {
            int n = this.debuggingProcesses.size() - 1;
            while (n >= 0) {
                DebuggingProcess debuggingProcess = this.debuggingProcesses.get(n);
                debuggingProcess.updateToolbarVisibility(bl);
                --n;
            }
        }
    }

    void tracingChanged() {
        7 var1_1 = new 7();
        6 var2_2 = new 6();
        this.pauseAndInvoke(var1_1, var2_2);
        ClassesWindow classesWindow = this.getClassesWindow(false);
        if (classesWindow != null) {
            classesWindow.tracingChanged();
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object = menuEvent.getSource();
        if (object == debugMenu) {
            debugMenu.removeMenuListener(this);
            this.buildDebugMenu();
        } else if (object == viewDebuggerSubMenu) {
            viewDebuggerSubMenu.removeMenuListener(this);
            this.buildViewDebuggerSubMenu();
        } else if (object == debugContextSubMenu) {
            debugContextSubMenu.removeMenuListener(this);
            JDebugger.buildDebugContextSubMenu();
        }
    }

    private void buildDebugMenu() {
        if (!debugMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            Context[] contextArray = new Context[]{Ide.getMainWindow().getLastActiveView().getContext()};
            if (!Product.isRaptor()) {
                this.updateIfNotVisible(actionDebugProject, contextArray);
                menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugProject, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_PROJECT), debugMenu, 1.0f);
            }
            this.updateIfNotVisible(actionDebugSelection, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugSelection, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_FILE), debugMenu, 1.0f);
            this.updateIfNotVisible(actionDebugToggleBreakpoint, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugToggleBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_BREAKPOINT);
            this.updateIfNotVisible(actionDebugPause, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugPause, JDeveloperMenuConstants.WEIGHT_DEBUG_PAUSE), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugResume, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugResume, JDeveloperMenuConstants.WEIGHT_DEBUG_RESUME), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugDetach, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugDetach, JDeveloperMenuConstants.WEIGHT_DEBUG_DETACH), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugStepOver, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepOver, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_OVER), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepInto, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepInto, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepOut, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepOut, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_OUT), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepToEndOfMethod, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepToEndOfMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_TO_END_OF_METHOD), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugContinueStep, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugContinueStep, JDeveloperMenuConstants.WEIGHT_DEBUG_CONTINUE_STEP), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugRunToCursor, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugRunToCursor, JDeveloperMenuConstants.WEIGHT_DEBUG_RUN_TO_CURSOR), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugSetNextStatement, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugSetNextStatement, JDeveloperMenuConstants.WEIGHT_DEBUG_SET_NEXT_STATEMENT), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugShowIP, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugShowIP, JDeveloperMenuConstants.WEIGHT_DEBUG_FIND_EXECUTION_POINT), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugGC, contextArray);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugGC, JDeveloperMenuConstants.WEIGHT_DEBUG_GARBAGE_COLLECT), debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_GARBAGE);
            debugContextSubMenu = menubar.createSubMenu(DbgArb.getString(83), DbgArb.getInteger(84));
            debugContextSubMenu.addMenuListener(this);
            JMenu jMenu = menubar.createSubMenu(DbgArb.getString(85), DbgArb.getInteger(86));
            BreakpointsWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            if (this.dbgSettings.isContextMenusOnMainMenu()) {
                menubar.add((Component)debugContextSubMenu, debugMenu, JDeveloperMenuConstants.SECTION_DEBUG_GARBAGE);
                debugContextSubMenuAdded = true;
            }
            debugMenuBuilt = true;
        }
    }

    private void buildViewDebuggerSubMenu() {
        if (!viewDebuggerSubMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            int n = viewDebuggerActions.size();
            int n2 = 1;
            while (n2 < n) {
                IdeAction ideAction = viewDebuggerActions.get(n2);
                this.update(ideAction, context);
                viewDebuggerSubMenu.add(menubar.createMenuItem((ToggleAction)ideAction));
                ++n2;
            }
            viewDebuggerSubMenuBuilt = true;
            viewDebuggerActions = null;
        }
    }

    private static void buildDebugContextSubMenu() {
        if (!debugContextSubMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            JMenu jMenu = menubar.createSubMenu(DbgArb.getString(87), DbgArb.getInteger(88));
            ThreadsWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(89), DbgArb.getInteger(90));
            StackWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(95), DbgArb.getInteger(96));
            SmartWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(91), DbgArb.getInteger(92));
            LocalsWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(93), DbgArb.getInteger(94));
            WatchWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(97), DbgArb.getInteger(98));
            InspectorWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(99), DbgArb.getInteger(100));
            ClassesWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(101), DbgArb.getInteger(102));
            HeapWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            jMenu = menubar.createSubMenu(DbgArb.getString(103), DbgArb.getInteger(104));
            MonitorsWindow.addContextMenuToMainMenu(menubar, jMenu);
            debugContextSubMenu.add(jMenu);
            debugContextSubMenuBuilt = true;
        }
    }

    private void updateDebugProjectAction(IdeAction ideAction) {
        String string;
        ideAction.setEnabled(this.canStartProcess(null));
        if (this.activeProject != null) {
            String string2 = this.activeProject.getShortLabel();
            string = DbgArb.format(3, string2);
        } else {
            string = DbgArb.getString(2);
        }
        ideAction.putValue("Name", (Object)string);
    }

    private void updateDebugSelectionAction(IdeAction ideAction, Context context) {
        String string;
        Project project = context.getProject();
        if (project != null && RunConfiguration.getInstance((PropertyStorage)project).isRemoteDebuggingProfiling()) {
            ideAction.setEnabled(false);
            ideAction.putValue("Name", (Object)DbgArb.getString(6));
            return;
        }
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof Project) {
            ideAction.setEnabled(false);
            ideAction.putValue("Name", (Object)DbgArb.getString(6));
            return;
        }
        ideAction.setEnabled(this.canStartProcess(context));
        if (node != null && Runner.getRunner().couldNodeBeRunnable(node, DebuggingProcess.starterFactorySubClass)) {
            String string2 = node.getShortLabel();
            string = DbgArb.format(7, string2);
        } else {
            string = DbgArb.getString(6);
        }
        ideAction.putValue("Name", (Object)string);
    }

    private void updateContextMenuDebugAction(IdeAction ideAction, Context context) {
        Project project;
        boolean bl = Runner.getRunner().enableRunDebugActions(context, DebuggingProcess.starterFactorySubClass) && this.canStartProcess(context);
        ideAction.setEnabled(bl);
        if (bl && (project = context.getProject()) != null && RunConfiguration.getInstance((PropertyStorage)project).isRemoteDebuggingProfiling()) {
            ideAction.putValue("Name", (Object)DbgArb.getString(114));
            return;
        }
        ideAction.putValue("Name", (Object)DbgArb.getString(113));
    }

    private void updateDebugActions() {
        Context[] contextArray = new Context[1];
        this.updateIfVisible(actionDebugProject, contextArray);
        this.updateIfVisible(actionDebugSelection, contextArray);
    }

    private boolean isActionVisible(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        return n == DEBUG_PROJECT_CMD_ID || n == DEBUG_RESUME_CMD_ID || n == DEBUG_STEPOVER_CMD_ID || n == DEBUG_STEPINTO_CMD_ID || n == DEBUG_STEPOUT_CMD_ID || n == DEBUG_STEPTOENDOFMETHOD_CMD_ID || n == DEBUG_PAUSE_CMD_ID || n == DEBUG_RESET_CMD_ID || n == DEBUG_GC_CMD_ID || n == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID || n == LOG_WINDOW_SHOWIP_CMD_ID || n == LOG_WINDOW_RESUME_CMD_ID || n == LOG_WINDOW_STEPOVER_CMD_ID || n == LOG_WINDOW_STEPINTO_CMD_ID || n == LOG_WINDOW_STEPOUT_CMD_ID || n == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID || n == LOG_WINDOW_STEPOVERBC_CMD_ID || n == LOG_WINDOW_STEPINTOBC_CMD_ID || n == LOG_WINDOW_PAUSE_CMD_ID || n == LOG_WINDOW_RESET_CMD_ID || n == LOG_WINDOW_GC_CMD_ID;
    }

    private void updateIfVisible(IdeAction ideAction, Context[] contextArray) {
        if (this.isActionVisible(ideAction)) {
            if (contextArray[0] == null) {
                contextArray[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(ideAction, contextArray[0]);
        }
    }

    private void updateIfNotVisible(IdeAction ideAction, Context[] contextArray) {
        if (!this.isActionVisible(ideAction)) {
            if (contextArray[0] == null) {
                contextArray[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(ideAction, contextArray[0]);
        }
    }

    private void checkCommandsBecauseActiveProjectChanged() {
        this.updateDebugActions();
    }

    private void checkCommandsBecauseActiveViewChanged() {
        this.updateDebugActions();
        Context[] contextArray = new Context[1];
        this.updateIfVisible(actionDebugRunToCursor, contextArray);
        this.updateIfVisible(actionDebugSetNextStatement, contextArray);
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsBecauseViewSelectionChanged() {
        this.updateDebugActions();
    }

    private void checkCommandsBecauseCursorMoved() {
        if (this.activeDebuggingProcess != null) {
            Context[] contextArray = new Context[1];
            this.updateIfVisible(actionDebugRunToCursor, contextArray);
            this.updateIfVisible(actionDebugSetNextStatement, contextArray);
        }
    }

    private boolean shouldProvideToolTip() {
        return this.duringClassRedefinition == 0 && this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped() && this.dbgSettings.isShowToolTipInCodeEditor();
    }

    private void updateToolTipProvider() {
        block5: {
            boolean bl = this.shouldProvideToolTip();
            if (this.isToolTipProvider == bl) break block5;
            this.isToolTipProvider = bl;
            CodeEditor[] codeEditorArray = SourceIcon.getOpenCodeEditors();
            if (this.isToolTipProvider) {
                int n = codeEditorArray.length - 1;
                while (n >= 0) {
                    codeEditorArray[n].addCEToolTipProvider((CEToolTipProvider)this);
                    --n;
                }
            } else {
                if (this.toolTipEvaluator != null) {
                    this.toolTipEvaluator.clearEvaluator();
                }
                int n = codeEditorArray.length - 1;
                while (n >= 0) {
                    codeEditorArray[n].removeCEToolTipProvider((CEToolTipProvider)this);
                    --n;
                }
            }
        }
    }

    private void checkCommandsBecauseActiveDebuggingProcessChanged() {
        this.updateToolTipProvider();
        Context[] contextArray = new Context[1];
        this.updateIfVisible(actionDebugPause, contextArray);
        this.updateIfVisible(actionDebugResume, contextArray);
        this.updateIfVisible(actionDebugDetach, contextArray);
        this.updateIfVisible(actionDebugReset, contextArray);
        this.updateIfVisible(actionDebugStepOver, contextArray);
        this.updateIfVisible(actionDebugStepOverBC, contextArray);
        this.updateIfVisible(actionDebugStepInto, contextArray);
        this.updateIfVisible(actionDebugStepIntoBC, contextArray);
        this.updateIfVisible(actionDebugStepOut, contextArray);
        this.updateIfVisible(actionDebugStepToEndOfMethod, contextArray);
        this.updateIfVisible(actionDebugContinueStep, contextArray);
        this.updateIfVisible(actionDebugRunToCursor, contextArray);
        this.updateIfVisible(actionDebugSetNextStatement, contextArray);
        this.updateIfVisible(actionDebugShowIP, contextArray);
        this.updateIfVisible(actionDebugGC, contextArray);
    }

    void checkCommandsBecauseDebuggingProcessStateChanged(DebuggingProcess debuggingProcess) {
        if (debuggingProcess == this.activeDebuggingProcess) {
            this.updateToolTipProvider();
            Context[] contextArray = new Context[1];
            this.updateIfVisible(actionDebugPause, contextArray);
            this.updateIfVisible(actionDebugResume, contextArray);
            this.updateIfVisible(actionDebugDetach, contextArray);
            this.updateIfVisible(actionDebugReset, contextArray);
            this.updateIfVisible(actionDebugStepOver, contextArray);
            this.updateIfVisible(actionDebugStepOverBC, contextArray);
            this.updateIfVisible(actionDebugStepInto, contextArray);
            this.updateIfVisible(actionDebugStepIntoBC, contextArray);
            this.updateIfVisible(actionDebugStepOut, contextArray);
            this.updateIfVisible(actionDebugStepToEndOfMethod, contextArray);
            this.updateIfVisible(actionDebugContinueStep, contextArray);
            this.updateIfVisible(actionDebugRunToCursor, contextArray);
            this.updateIfVisible(actionDebugSetNextStatement, contextArray);
            this.updateIfVisible(actionDebugShowIP, contextArray);
            this.updateIfVisible(actionDebugGC, contextArray);
        }
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsForTopLogPage() {
        LogPage logPage = LogManager.getIdeLogWindow().getPage();
        if (logPage instanceof RunLogPage) {
            DebuggingProcess debuggingProcess;
            Context[] contextArray = new Context[]{logPage.getLogPageView().getContext()};
            DebuggingProcess debuggingProcess2 = this.findDebuggingProcess((RunLogPage)logPage, true);
            if (debuggingProcess2 != null) {
                this.updateIfVisible(actionLogWindowCancelDebugConnection, contextArray);
            }
            if ((debuggingProcess = this.findDebuggingProcess((RunLogPage)logPage, false)) != null) {
                this.updateIfVisible(actionLogWindowShowIP, contextArray);
                this.updateIfVisible(actionLogWindowResume, contextArray);
                this.updateIfVisible(actionLogWindowStepOver, contextArray);
                this.updateIfVisible(actionLogWindowStepInto, contextArray);
                this.updateIfVisible(actionLogWindowStepOut, contextArray);
                this.updateIfVisible(actionLogWindowStepToEndOfMethod, contextArray);
                this.updateIfVisible(actionLogWindowStepOverBC, contextArray);
                this.updateIfVisible(actionLogWindowStepIntoBC, contextArray);
                this.updateIfVisible(actionLogWindowPause, contextArray);
                this.updateIfVisible(actionLogWindowReset, contextArray);
                this.updateIfVisible(actionLogWindowGC, contextArray);
            }
        }
    }

    private void checkCommandsBecauseTracingChanged() {
        Context[] contextArray = new Context[1];
        this.updateIfVisible(actionDebugStepOver, contextArray);
        this.updateIfVisible(actionDebugStepOverBC, contextArray);
        this.updateIfVisible(actionDebugStepInto, contextArray);
        this.updateIfVisible(actionDebugStepIntoBC, contextArray);
        this.updateIfVisible(actionDebugStepToEndOfMethod, contextArray);
        this.checkCommandsForTopLogPage();
    }

    private boolean canStartProcess(Context context) {
        Node node;
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && compiler.isBusy(null)) {
            return false;
        }
        if (context != null && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean bl = false;
        if (context != null) {
            bl = this.isContextNodeRunnable(context);
        } else if (this.activeProject != null) {
            bl = true;
        } else {
            Context context2 = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (context2 != null) {
                bl = this.isContextNodeRunnable(context2);
            }
        }
        return bl;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node, DebuggingProcess.starterFactorySubClass);
    }

    private void startProcess(Context context) {
        DebuggingProcess debuggingProcess = this.createDebuggingProcess(context);
        debuggingProcess.start();
    }

    private DebuggingProcess createDebuggingProcess(Context context) {
        if (this.activeProject != null && context != null && RunProcess.getContextNodeForRun((Context)context) == this.activeProject) {
            context = null;
        }
        if (context != null) {
            Workspace workspace = context.getWorkspace();
            Project project = context.getProject();
            if (workspace == null || project == null) {
                workspace = this.activeWorkspace;
                project = this.activeProject;
            }
            context.setWorkspace(workspace);
            context.setProject(project);
        }
        DebuggingProcess debuggingProcess = new DebuggingProcess(context);
        return debuggingProcess;
    }

    private boolean canStopListening(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            int n = elementArray.length - 1;
            while (n >= 0) {
                Element element = elementArray[n];
                if (!(element instanceof DebuggingListener)) {
                    return false;
                }
                --n;
            }
            return true;
        }
        return false;
    }

    private void stopListening(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            int n = elementArray.length - 1;
            while (n >= 0) {
                Element element = elementArray[n];
                if (element instanceof DebuggingListener) {
                    DebuggingListener debuggingListener = (DebuggingListener)element;
                    debuggingListener.stopListening();
                }
                --n;
            }
        }
    }

    private boolean canDetachDebugger(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            int n = elementArray.length - 1;
            while (n >= 0) {
                Element element = elementArray[n];
                if (element instanceof DebuggingProcess) {
                    DebuggingProcess debuggingProcess = (DebuggingProcess)element;
                    if (!debuggingProcess.canDetach()) {
                        return false;
                    }
                } else {
                    return false;
                }
                --n;
            }
            return true;
        }
        return false;
    }

    private void detachDebugger(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            int n = elementArray.length - 1;
            while (n >= 0) {
                DebuggingProcess debuggingProcess;
                Element element = elementArray[n];
                if (element instanceof DebuggingProcess && (debuggingProcess = (DebuggingProcess)element).canDetach()) {
                    debuggingProcess.detach();
                }
                --n;
            }
        }
    }

    BreakpointsWindow getBreakpointsWindow(boolean bl) {
        if (this.breakpointsWindow == null && bl) {
            this.breakpointsWindow = new BreakpointsWindow(this.activeWorkspace, this.activeProject, this.activeBreakpoints);
        }
        return this.breakpointsWindow;
    }

    ThreadsWindow getThreadsWindow(boolean bl) {
        if (this.threadsWindow == null && bl) {
            this.threadsWindow = new ThreadsWindow();
            if (this.stackWindow != null) {
                this.threadsWindow.setStackWindow(this.stackWindow);
            }
        }
        return this.threadsWindow;
    }

    StackWindow getStackWindow(boolean bl) {
        this.getThreadsWindow(bl);
        if (this.stackWindow == null && bl) {
            this.stackWindow = new StackWindow();
            if (this.threadsWindow != null) {
                this.threadsWindow.setStackWindow(this.stackWindow);
            }
            if (this.localsWindow != null) {
                this.stackWindow.setLocalsWindow(this.localsWindow);
            }
            if (this.watchWindow != null) {
                this.stackWindow.setWatchWindow(this.watchWindow);
            }
        }
        return this.stackWindow;
    }

    SmartWindow getSmartWindow(boolean bl) {
        if (this.smartWindow == null && bl) {
            this.smartWindow = new SmartWindow();
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.smartWindowCreated(this.smartWindow);
            }
        }
        return this.smartWindow;
    }

    LocalsWindow getLocalsWindow(boolean bl) {
        this.getStackWindow(bl);
        if (this.localsWindow == null && bl) {
            this.localsWindow = new LocalsWindow();
            if (this.stackWindow != null) {
                this.stackWindow.setLocalsWindow(this.localsWindow);
            }
        }
        return this.localsWindow;
    }

    WatchWindow getWatchWindow(boolean bl) {
        this.getStackWindow(bl);
        if (this.watchWindow == null && bl) {
            this.watchWindow = new WatchWindow();
            if (this.stackWindow != null) {
                this.stackWindow.setWatchWindow(this.watchWindow);
            }
        }
        return this.watchWindow;
    }

    ClassesWindow getClassesWindow(boolean bl) {
        if (this.classesWindow == null && bl) {
            this.classesWindow = new ClassesWindow();
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.classesWindowCreated(this.classesWindow);
            }
        }
        return this.classesWindow;
    }

    HeapWindow getHeapWindow(boolean bl) {
        if (this.heapWindow == null && bl) {
            this.heapWindow = new HeapWindow();
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.heapWindowCreated(this.heapWindow);
            }
        }
        return this.heapWindow;
    }

    MonitorsWindow getMonitorsWindow(boolean bl) {
        if (this.monitorsWindow == null && bl) {
            this.monitorsWindow = new MonitorsWindow();
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.monitorsWindowCreated(this.monitorsWindow);
            }
        }
        return this.monitorsWindow;
    }

    public EvaluatorItem addWatch(Object object) {
        this.viewWatches();
        this.getWatchWindow(true);
        return this.watchWindow.addWatch(object);
    }

    public boolean removeWatch(EvaluatorItem evaluatorItem) {
        this.getWatchWindow(true);
        return this.watchWindow.removeWatch(evaluatorItem);
    }

    public InspectorWindow inspect(Object object) {
        String string = InspectorWindow.getNewInspectorWindowId();
        InspectorWindow inspectorWindow = new InspectorWindow(string, object);
        this.addInspectorWindow(inspectorWindow, true);
        return inspectorWindow;
    }

    private void addInspectorWindow(InspectorWindow inspectorWindow, boolean bl) {
        if (this.inspectorWindows == null) {
            this.inspectorWindows = new ArrayList();
        }
        this.inspectorWindows.add(inspectorWindow);
        this.getStackWindow(true);
        this.stackWindow.newInspectorWindow(inspectorWindow);
        if (bl) {
            this.debugDockableFactory.floatWindow(inspectorWindow);
        }
    }

    InspectorWindow getInspectorWindow(String string) {
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                if (!string.equals(inspectorWindow.getId())) continue;
                return inspectorWindow;
            }
        }
        InspectorWindow inspectorWindow = new InspectorWindow(string, null);
        this.addInspectorWindow(inspectorWindow, false);
        return inspectorWindow;
    }

    void removeInspectorWindow(InspectorWindow inspectorWindow) {
        if (this.inspectorWindows != null) {
            this.inspectorWindows.remove((Object)inspectorWindow);
            inspectorWindow.removeInspector();
        }
    }

    Iterator getInspectorWindows() {
        if (this.inspectorWindows != null) {
            List list = (List)((ArrayList)this.inspectorWindows).clone();
            return list.iterator();
        }
        return new ArrayList().iterator();
    }

    DebuggingProcess[] getDebuggingProcessesForBreakpoint(Breakpoint breakpoint) {
        ArrayList<DebuggingProcess> arrayList = new ArrayList<DebuggingProcess>();
        if (this.debuggingProcesses != null) {
            block0: for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                List[] listArray = Breakpoint.getBreakpoints(debuggingProcess.getWorkspace(), debuggingProcess.getProject());
                int n = listArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (listArray[n2].contains(breakpoint)) {
                        arrayList.add(debuggingProcess);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return arrayList.toArray(new DebuggingProcess[arrayList.size()]);
    }

    void addBreakpoint(Breakpoint breakpoint, Runnable runnable) {
        Breakpoint.addBreakpointToOwner(breakpoint, true);
        breakpoint.putBreakpoint(runnable);
        String string = null;
        String string2 = null;
        int n = breakpoint.getType();
        if (n == 0) {
            string = breakpoint.getPackage();
            String string3 = breakpoint.getFile();
            int n2 = string3.indexOf(46);
            if (n2 != -1) {
                string3 = string3.substring(0, n2);
            }
            string2 = string + "." + string3;
        } else if (n == 1) {
            String string4 = breakpoint.getMethod();
            int n3 = string4.lastIndexOf(46);
            if (n3 != -1) {
                string = string4.substring(0, n3);
            }
        } else if (n == 7) {
            int n4;
            int n5;
            String string5 = breakpoint.getMethod();
            int n6 = string5.indexOf("(");
            if (n6 != -1 && (n5 = string5.lastIndexOf(" ", n6) + 1) != -1 && (n4 = string5.lastIndexOf(".", n6)) != -1) {
                string = string5.substring(n5, n4);
            }
        } else if (n == 4) {
            string = breakpoint.getClassName();
        }
        if (!(string == null && string2 == null || this.activeDebuggingProcess != null && !this.activeDebuggingProcess.canSetTracing())) {
            DebugConfiguration debugConfiguration = null;
            if (this.activeDebuggingProcess != null) {
                debugConfiguration = this.activeDebuggingProcess.getDebugConfiguration();
            } else if (this.activeProject != null) {
                debugConfiguration = DebugConfiguration.getInstance((PropertyStorage)this.activeProject);
            }
            if (debugConfiguration != null) {
                List list = debugConfiguration.getTracingIncludeList();
                List list2 = debugConfiguration.getTracingExcludeList();
                if (string != null && !DebugShared.isClassOrPackageDebuggable(string, list, list2) || string2 != null && !DebugShared.isClassOrPackageDebuggable(string2, list, list2)) {
                    RunConfiguration runConfiguration = debugConfiguration.getRunConfiguration();
                    String string6 = DbgArb.format(879, runConfiguration.getName(), DbgArb.getString(19));
                    string6 = string6 + DbgArb.getString(880);
                    if (!runConfiguration.isCustom()) {
                        string6 = string6 + DbgArb.format(881, runConfiguration.getName());
                    }
                    string6 = string6 + DbgArb.getString(882);
                    String string7 = DbgArb.getString(883);
                    boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string6, (String)string7, null);
                    if (bl) {
                        TracingPanel.showTracingDialog(debugConfiguration);
                    }
                }
            }
        }
    }

    void updateBreakpointsWindow() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.everythingChanged();
        }
    }

    void updateBreakpointsWindowDescription() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointDescriptionChanged();
        }
    }

    void updateBreakpointsWindowStatus() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointStatusChanged();
        }
    }

    void updateBreakpointsWindowInstanceFilters() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointInstanceFiltersChanged();
        }
    }

    private Breakpoint findBreakpointByIconLocation(CodeEditor codeEditor, int n, Boolean bl) {
        Breakpoint breakpoint = null;
        URL uRL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        int n2 = this.activeBreakpoints.length;
        int n3 = 0;
        while (n3 < n2) {
            for (Breakpoint breakpoint2 : this.activeBreakpoints[n3]) {
                if (bl != null && (bl == false ? breakpoint2.getType() == 6 : breakpoint2.getType() != 6) || !breakpoint2.matchesIconLocation(codeEditor, n)) continue;
                if (uRL == null || URLFileSystem.equals((URL)uRL, (URL)breakpoint2.getOwnerURL())) {
                    return breakpoint2;
                }
                breakpoint = breakpoint2;
            }
            ++n3;
        }
        return breakpoint;
    }

    private void toggleBreakpoint(Context context, CodeEditor codeEditor, int n) {
        Breakpoint breakpoint = this.findBreakpointByIconLocation(codeEditor, n, Boolean.FALSE);
        if (breakpoint != null) {
            breakpoint.removeBreakpoint();
            this.updateBreakpointsWindow();
        } else {
            this.createBreakpoint(context, n);
        }
    }

    private void createBreakpoint(Context context, int n) {
        URL uRL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        Node node = context.getNode();
        if (node != null) {
            Breakpoint breakpoint = null;
            if (JDebugger.usePackageFileLine(node)) {
                String string = Source.getPackageFromNode(node, context.getProject());
                String string2 = Source.getFilenameFromNode(node);
                if (string != null && string2 != null && string2.length() > 0) {
                    breakpoint = new Breakpoint(uRL, 0, string, string2, n);
                }
            } else {
                String string;
                URL uRL2 = node.getURL();
                boolean bl = false;
                BytecodeFileSystemHelper bytecodeFileSystemHelper = BytecodeFileSystemHelper.getInstance(false);
                if (bytecodeFileSystemHelper != null && (string = BytecodeFileSystemHelper.getMethodName(uRL2)) != null) {
                    bl = true;
                    int n2 = bytecodeFileSystemHelper.getBytecodeOffsetFromLine(uRL2, n);
                    if (n2 != -1) {
                        breakpoint = new Breakpoint(uRL, 7, string, n2);
                    }
                }
                if (!bl) {
                    breakpoint = new Breakpoint(uRL, 5, uRL2, n);
                }
            }
            if (breakpoint != null) {
                if (this.breakpointsWindow != null) {
                    this.breakpointsWindow.addNewBreakpoint(breakpoint);
                } else {
                    this.addBreakpoint(breakpoint, null);
                }
            }
        }
    }

    Breakpoint findWatchpoint(String string, String string2) {
        Breakpoint breakpoint = null;
        URL uRL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        int n = this.activeBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            for (Breakpoint breakpoint2 : this.activeBreakpoints[n2]) {
                if (breakpoint2.getType() != 6 || !breakpoint2.getClassName().equals(string) || !breakpoint2.getFieldName().equals(string2)) continue;
                if (uRL == null || URLFileSystem.equals((URL)uRL, (URL)breakpoint2.getOwnerURL())) {
                    return breakpoint2;
                }
                breakpoint = breakpoint2;
            }
            ++n2;
        }
        return breakpoint;
    }

    private void createWatchpoint(String string, String string2) {
        URL uRL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        Breakpoint breakpoint = new Breakpoint(uRL, 6, string, string2, false, true);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.addNewBreakpoint(breakpoint);
        } else {
            this.addBreakpoint(breakpoint, null);
        }
    }

    private void toggleWatchpoint(String string, String string2) {
        Breakpoint breakpoint = this.findWatchpoint(string, string2);
        if (breakpoint != null) {
            breakpoint.removeBreakpoint();
            this.updateBreakpointsWindow();
        } else {
            this.createWatchpoint(string, string2);
        }
    }

    static URL getNewBreakpointOwnerURL(Workspace workspace, Project project) {
        String string = BreakpointsWindowSettings.getInstance().getBreakpointScope();
        if (string.equals("workspace") && workspace != null && workspace != Ide.getDefaultWorkspace()) {
            return workspace.getURL();
        }
        if (string.equals("project") && project != null && project != Ide.getDefaultProject()) {
            return project.getURL();
        }
        return null;
    }

    static boolean usePackageFileLine(Node node) {
        return node instanceof PackagedSource;
    }

    void breakpointHasBeenPut(Breakpoint breakpoint, DebugBreakpoint debugBreakpoint) {
        if (this.breakpointForDebugBreakpoint == null) {
            this.breakpointForDebugBreakpoint = new HashMap();
        }
        this.breakpointForDebugBreakpoint.put(debugBreakpoint, breakpoint);
    }

    void breakpointHasBeenRemoved(Breakpoint breakpoint, DebugBreakpoint debugBreakpoint) {
        this.breakpointForDebugBreakpoint.remove(debugBreakpoint);
    }

    Breakpoint findBreakpoint(DebugBreakpoint debugBreakpoint) {
        if (this.breakpointForDebugBreakpoint != null) {
            return (Breakpoint)this.breakpointForDebugBreakpoint.get(debugBreakpoint);
        }
        return null;
    }

    void breakpointChanged(DebugBreakpoint debugBreakpoint, DebuggingProcess debuggingProcess) {
        Breakpoint breakpoint = this.findBreakpoint(debugBreakpoint);
        if (breakpoint != null) {
            breakpoint.changed(debugBreakpoint, debuggingProcess);
            this.updateBreakpointsWindow();
        }
    }

    void viewBreakpoints() {
        DockUtil.showDockableWindow((DockableView)this.getBreakpointsWindow(true));
    }

    void viewWatches() {
        DockUtil.showDockableWindow((DockableView)this.getWatchWindow(true));
    }

    void viewHeap() {
        DockUtil.showDockableWindow((DockableView)this.getHeapWindow(true));
    }

    void viewMonitors() {
        boolean bl = DockStation.getDockStation().getDockable(new ViewId("Debugger.MonitorsWindow")) == null;
        MonitorsWindow monitorsWindow = this.getMonitorsWindow(true);
        if (bl) {
            this.debugDockableFactory.floatWindow(monitorsWindow);
        } else {
            DockUtil.showDockableWindow((DockableView)monitorsWindow);
        }
    }

    void listenerStarted(DebuggingListener debuggingListener) {
        if (this.debuggingListeners == null) {
            this.debuggingListeners = new ArrayList<DebuggingListener>();
        }
        this.debuggingListeners.add(debuggingListener);
    }

    void listenerStopped(DebuggingListener debuggingListener) {
        this.debuggingListeners.remove(debuggingListener);
    }

    void debuggingProcessCreated() {
        if (this.firstDebuggingProcessCreated) {
            this.firstDebuggingProcessCreated = false;
            this.makeDebuggingProcessActions();
            this.addSmartDataProvider(new SmartJava());
            this.addToolTipExpressionProvider(new ToolTipJava());
        }
    }

    void debuggingProcessBeforeConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting == null) {
            this.debuggingProcessesConnecting = new ArrayList<DebuggingProcess>();
        }
        this.debuggingProcessesConnecting.add(debuggingProcess);
        Toolbar toolbar = debuggingProcess.getLogPageToolbar();
        if (toolbar != null) {
            toolbar.add((ToggleAction)actionLogWindowCancelDebugConnection);
            toolbar.validate();
            this.checkCommandsForTopLogPage();
        }
    }

    void debuggingProcessAfterConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting != null) {
            this.debuggingProcessesConnecting.remove(debuggingProcess);
        }
        debuggingProcess.clearLogPageToolbar();
    }

    void debuggingProcessStarted(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcesses == null) {
            this.debuggingProcesses = new ArrayList<DebuggingProcess>();
        }
        this.debuggingProcesses.add(debuggingProcess);
        Toolbar toolbar = debuggingProcess.getLogPageToolbar();
        if (toolbar != null) {
            this.addNormalButtons(toolbar);
            this.checkCommandsForTopLogPage();
        }
        this.getThreadsWindow(true).getGUI();
        this.getStackWindow(true).getGUI();
    }

    private void addNormalButtons(Toolbar toolbar) {
        toolbar.add((ToggleAction)actionLogWindowShowIP);
        toolbar.add((ToggleAction)actionLogWindowResume);
        toolbar.add((ToggleAction)actionLogWindowStepOver);
        toolbar.add((ToggleAction)actionLogWindowStepInto);
        toolbar.add((ToggleAction)actionLogWindowStepOut);
        toolbar.add((ToggleAction)actionLogWindowStepToEndOfMethod);
        if (BytecodeFileSystemHelper.getInstance(false) != null) {
            toolbar.add((ToggleAction)actionLogWindowStepOverBC);
            toolbar.add((ToggleAction)actionLogWindowStepIntoBC);
        }
        toolbar.add((ToggleAction)actionLogWindowPause);
        toolbar.add((ToggleAction)actionLogWindowReset);
        toolbar.add((ToggleAction)actionLogWindowGC);
        toolbar.validate();
    }

    void addStepBytecodeActions() {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                Toolbar toolbar = debuggingProcess.getLogPageToolbar();
                if (toolbar == null) continue;
                toolbar.dispose();
                toolbar.removeAll();
                this.addNormalButtons(toolbar);
            }
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof RunLogPage) {
                Context[] contextArray = new Context[]{logPage.getLogPageView().getContext()};
                this.updateIfVisible(actionLogWindowStepOverBC, contextArray);
                this.updateIfVisible(actionLogWindowStepIntoBC, contextArray);
            }
        }
    }

    void pauseAndInvoke(RunWhilePaused runWhilePaused, Runnable runnable) {
        DebuggingProcess[] debuggingProcessArray = this.debuggingProcesses != null ? this.debuggingProcesses.toArray(new DebuggingProcess[this.debuggingProcesses.size()]) : new DebuggingProcess[]{};
        JDebugger.pauseAndInvoke(debuggingProcessArray, runWhilePaused, runnable);
    }

    static void pauseAndInvoke(DebuggingProcess[] debuggingProcessArray, RunWhilePaused runWhilePaused, Runnable runnable) {
        int n = debuggingProcessArray.length;
        if (n > 0) {
            int[] nArray = new int[]{n};
            5 var5_5 = new 5(runWhilePaused, nArray, runnable);
            int n2 = 0;
            while (n2 < n) {
                debuggingProcessArray[n2].runWhilePaused(var5_5);
                ++n2;
            }
        } else if (runnable != null) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    DebuggingProcess findDebuggingProcess(DebugVirtualMachine debugVirtualMachine) {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                if (debuggingProcess.getVM() != debugVirtualMachine) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    DebuggingProcess findDebuggingProcess(RunLogPage runLogPage, boolean bl) {
        List<DebuggingProcess> list;
        List<DebuggingProcess> list2 = list = bl ? this.debuggingProcessesConnecting : this.debuggingProcesses;
        if (list != null) {
            for (DebuggingProcess debuggingProcess : list) {
                if (debuggingProcess.getLogPage() != runLogPage) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    void processSelected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = debuggingProcess;
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] listArray = Breakpoint.getBreakpoints(workspace, project);
        Breakpoint.updateBreakpointIcons(listArray);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
    }

    void processUnselected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = null;
        SourceIcon.removeColumn(2);
        Container container = contextMenu.getGUI(false);
        if (container != null && container.isVisible()) {
            container.setVisible(false);
        }
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] listArray = Breakpoint.getBreakpoints(workspace, project);
        Breakpoint.updateBreakpointIcons(listArray);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
    }

    void debuggingProcessFinished(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess == debuggingProcess) {
            this.activeDebuggingProcess = null;
            SourceIcon.removeColumn(2);
        }
        if (this.debuggingProcesses != null) {
            this.debuggingProcesses.remove(debuggingProcess);
        }
        debuggingProcess.clearLogPageToolbar();
        if (this.threadsWindow != null) {
            this.threadsWindow.processFinished(debuggingProcess);
        }
        if (this.smartWindow != null) {
            this.smartWindow.processFinished(debuggingProcess);
        }
        if (this.classesWindow != null) {
            this.classesWindow.processFinished(debuggingProcess);
        }
        if (this.heapWindow != null) {
            this.heapWindow.processFinished(debuggingProcess);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.processFinished(debuggingProcess);
        }
    }

    boolean isActiveDebuggingProcess(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess != null) {
            return this.activeDebuggingProcess.equals(debuggingProcess);
        }
        return false;
    }

    DebuggingProcess getActiveDebuggingProcess() {
        return this.activeDebuggingProcess;
    }

    boolean canShowDebuggingWindows() {
        return this.activeDebuggingProcess != null;
    }

    static boolean isDebuggingLayout(Layout layout) {
        String string = layout.getProperty(DEBUG_LAYOUT_KEY, Boolean.toString(false));
        return Boolean.toString(true).equals(string);
    }

    boolean canShowDebuggingWindows(Layout layout) {
        return this.canShowDebuggingWindows() && JDebugger.isDebuggingLayout(layout);
    }

    boolean canShowHeapWindow() {
        if (this.activeDebuggingProcess != null) {
            try {
                DebugVirtualMachine debugVirtualMachine = this.activeDebuggingProcess.getVM();
                if (debugVirtualMachine != null) {
                    boolean bl = debugVirtualMachine.getCapabilities().canGetHeap();
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    boolean canShowMonitorsWindow() {
        if (this.activeDebuggingProcess != null) {
            try {
                DebugVirtualMachine debugVirtualMachine = this.activeDebuggingProcess.getVM();
                if (debugVirtualMachine != null) {
                    boolean bl = debugVirtualMachine.getCapabilities().canGetMonitors();
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private Breakpoint getBreakpointFromGutterMarkRightClick(Context context) {
        Object object;
        GutterMark gutterMark;
        if (context.getView() instanceof CodeEditorGutter.GutterView && (gutterMark = CodeEditorGutter.getMarkForContext((Context)context)) != null && (object = gutterMark.getUserData()) instanceof SourceIcon) {
            SourceIcon sourceIcon = (SourceIcon)object;
            Breakpoint breakpoint = sourceIcon.getBreakpoint();
            return breakpoint;
        }
        return null;
    }

    private boolean toggleBreakpointFromCodeEditor(Context context, IdeAction ideAction) {
        int n;
        Breakpoint breakpoint = this.getBreakpointFromGutterMarkRightClick(context);
        if (breakpoint != null && breakpoint.getType() != 6) {
            if (ideAction == null) {
                breakpoint.removeBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (n = Source.getLineFromCodeEditor(context)) != 0) {
            if (ideAction == null) {
                this.toggleBreakpoint(context, codeEditor, n);
            }
            return true;
        }
        return false;
    }

    private boolean toggleWatchpointFromCodeEditor(Context context, IdeAction ideAction) {
        Node node;
        Breakpoint breakpoint = this.getBreakpointFromGutterMarkRightClick(context);
        if (breakpoint != null && breakpoint.getType() == 6) {
            if (ideAction == null) {
                breakpoint.removeBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (node = Source.getNodeFromCodeEditor(context)) instanceof JavaSourceNode) {
            JavaManager javaManager;
            SourceFile sourceFile;
            int n = 0;
            if (context.getView() instanceof CodeEditorGutter.GutterView) {
                int n2 = Source.getLineFromCodeEditor(context);
                if (n2 == 0) {
                    return false;
                }
                n = JDebugger.getLineStartOffsetSkipWhite(codeEditor, n2);
            } else {
                n = codeEditor.getCaretPosition();
            }
            Project project = context.getProject();
            if (project != null && (sourceFile = (javaManager = JavaManager.getJavaManager(project)).getSourceFile(node.getURL())) != null) {
                SourceElement sourceElement = sourceFile.getElementAt(n);
                SourceFieldVariable sourceFieldVariable = null;
                if (sourceElement instanceof SourceName) {
                    Iterator iterator;
                    if ((sourceElement = sourceElement.getParent()) instanceof SourceFieldVariable) {
                        sourceFieldVariable = (SourceFieldVariable)sourceElement;
                    } else if (sourceElement instanceof SourceTypeReference && (sourceElement = sourceElement.getParent()) instanceof SourceFieldDeclaration && (iterator = ((SourceFieldDeclaration)sourceElement).getVariables().iterator()).hasNext()) {
                        sourceFieldVariable = (SourceFieldVariable)iterator.next();
                    }
                }
                if (sourceFieldVariable != null) {
                    SourcePackage sourcePackage;
                    SourceClass sourceClass = sourceFieldVariable.getEnclosingClass();
                    String string = sourceClass.getName();
                    if (string.indexOf(".") == -1 && (sourcePackage = sourceFile.getSourcePackage()) != null) {
                        string = sourcePackage.getName() + "." + string;
                    }
                    String string2 = sourceFieldVariable.getName();
                    if (ideAction == null) {
                        this.toggleWatchpoint(string, string2);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean enableBreakpointFromCodeEditor(Context context, IdeAction ideAction) {
        int n;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (n = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint breakpoint = this.getBreakpointFromGutterMarkRightClick(context);
            if (breakpoint == null) {
                breakpoint = this.findBreakpointByIconLocation(codeEditor, n, null);
            }
            if (breakpoint != null && !breakpoint.isEnabledNow()) {
                if (ideAction != null) {
                    if (breakpoint.getType() == 6) {
                        ideAction.putValue("Name", (Object)DbgArb.getString(135));
                    } else {
                        ideAction.putValue("Name", (Object)DbgArb.getString(134));
                    }
                } else {
                    breakpoint.setEnabled(true);
                }
                return true;
            }
        }
        return false;
    }

    private boolean disableBreakpointFromCodeEditor(Context context, IdeAction ideAction) {
        int n;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (n = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint breakpoint = this.getBreakpointFromGutterMarkRightClick(context);
            if (breakpoint == null) {
                breakpoint = this.findBreakpointByIconLocation(codeEditor, n, null);
            }
            if (breakpoint != null && breakpoint.isEnabledNow()) {
                if (ideAction != null) {
                    if (breakpoint.getType() == 6) {
                        ideAction.putValue("Name", (Object)DbgArb.getString(139));
                    } else {
                        ideAction.putValue("Name", (Object)DbgArb.getString(138));
                    }
                } else {
                    breakpoint.setEnabled(false);
                }
                return true;
            }
        }
        return false;
    }

    private boolean editBreakpointFromCodeEditor(Context context, IdeAction ideAction) {
        int n;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (n = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint breakpoint = this.getBreakpointFromGutterMarkRightClick(context);
            if (breakpoint == null) {
                breakpoint = this.findBreakpointByIconLocation(codeEditor, n, null);
            }
            if (breakpoint != null) {
                if (ideAction != null) {
                    if (breakpoint.getType() == 6) {
                        ideAction.putValue("Name", (Object)DbgArb.getString(143));
                    } else {
                        ideAction.putValue("Name", (Object)DbgArb.getString(142));
                    }
                } else {
                    this.getBreakpointsWindow(true).editBreakpoint(breakpoint);
                }
                return true;
            }
        }
        return false;
    }

    private boolean createWatchpointFromStructure(Context context, IdeAction ideAction) {
        Element element = context.getElement();
        if (element instanceof FieldElement) {
            String string;
            Breakpoint breakpoint;
            String string2;
            FieldElement fieldElement = (FieldElement)element;
            ClassElement classElement = fieldElement.getEnclosingClass();
            String string3 = classElement.getSymbolName();
            if (string3.indexOf(".") == -1 && (string2 = classElement.getPackageName()) != null && string2.length() > 0) {
                string3 = string2 + "." + string3;
            }
            if ((breakpoint = this.findWatchpoint(string3, string = fieldElement.getSymbolName())) == null) {
                if (ideAction == null) {
                    this.createWatchpoint(string3, string);
                }
                return true;
            }
        }
        return false;
    }

    static String trimExpression(String string) {
        int n = string.indexOf(13);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(10)) != -1) {
            string = string.substring(0, n);
        }
        string = string.trim();
        return string;
    }

    private void watchFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            String string = "";
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                string = codeEditor.getSelectedText();
                string = string != null ? JDebugger.trimExpression(string) : "";
            }
            this.getWatchWindow(true);
            if (this.watchWindow.addWatchDialog(string)) {
                this.viewWatches();
            }
        }
    }

    private void inspectFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            String string = "";
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                string = codeEditor.getSelectedText();
                string = string != null ? JDebugger.trimExpression(string) : "";
            }
            if ((string = InspectorWindow.inspectDialog(string)) != null) {
                this.inspect(string);
            }
        }
    }

    private static RunLogPage getRunLogPage(Context context) {
        LogPage logPage;
        View view = context.getView();
        if (view instanceof RunLogPage) {
            return (RunLogPage)view;
        }
        LogWindow logWindow = LogManager.getLogManager().getLogWindow();
        if (logWindow != null && (logPage = logWindow.getPage()) instanceof RunLogPage) {
            return (RunLogPage)logPage;
        }
        return null;
    }

    private boolean canDoLogWindowAction(Context context, int n) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (n == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    return debuggingProcess.canCancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null) {
                    if (n == LOG_WINDOW_SHOWIP_CMD_ID) {
                        return debuggingProcess.canShowIP();
                    }
                    if (n == LOG_WINDOW_RESUME_CMD_ID) {
                        return debuggingProcess.canResume();
                    }
                    if (n == LOG_WINDOW_STEPOVER_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (n == LOG_WINDOW_STEPINTO_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (n == LOG_WINDOW_STEPOUT_CMD_ID) {
                        return debuggingProcess.canStepOut();
                    }
                    if (n == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID) {
                        return debuggingProcess.canStepToEndOfMethod();
                    }
                    if (n == LOG_WINDOW_STEPOVERBC_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (n == LOG_WINDOW_STEPINTOBC_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (n == LOG_WINDOW_PAUSE_CMD_ID) {
                        return debuggingProcess.canPause();
                    }
                    if (n == LOG_WINDOW_RESET_CMD_ID) {
                        return debuggingProcess.canTerminate();
                    }
                    if (n == LOG_WINDOW_GC_CMD_ID) {
                        return debuggingProcess.canGC();
                    }
                }
            }
        }
        return false;
    }

    private void doLogWindowAction(Context context, int n) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (n == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    debuggingProcess.cancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null) {
                    if (n == LOG_WINDOW_SHOWIP_CMD_ID) {
                        debuggingProcess.showIP();
                    } else if (n == LOG_WINDOW_RESUME_CMD_ID) {
                        debuggingProcess.resume();
                    } else if (n == LOG_WINDOW_STEPOVER_CMD_ID) {
                        debuggingProcess.stepOver(JDebugger.getEventTime(context));
                    } else if (n == LOG_WINDOW_STEPINTO_CMD_ID) {
                        debuggingProcess.stepInto(JDebugger.getEventTime(context));
                    } else if (n == LOG_WINDOW_STEPOUT_CMD_ID) {
                        debuggingProcess.stepOut(JDebugger.getEventTime(context));
                    } else if (n == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID) {
                        debuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
                    } else if (n == LOG_WINDOW_STEPOVERBC_CMD_ID) {
                        debuggingProcess.stepOverBC(JDebugger.getEventTime(context));
                    } else if (n == LOG_WINDOW_STEPINTOBC_CMD_ID) {
                        debuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
                    } else if (n == LOG_WINDOW_PAUSE_CMD_ID) {
                        debuggingProcess.pause();
                    } else if (n == LOG_WINDOW_RESET_CMD_ID) {
                        debuggingProcess.terminate();
                    } else if (n == LOG_WINDOW_GC_CMD_ID) {
                        debuggingProcess.gc();
                    }
                }
            }
        }
    }

    void showContextMenu(MouseEvent mouseEvent, DockableWindow dockableWindow, JComponent jComponent) {
        DockStation.getDockStation().activateDockable((Dockable)dockableWindow);
        if (jComponent != null && jComponent.isEnabled() && mouseEvent.getSource() == jComponent) {
            int n;
            JTable jTable;
            if (jComponent instanceof JFastTreeTable) {
                JFastTreeTable jFastTreeTable = (JFastTreeTable)jComponent;
                JTree jTree = jFastTreeTable.getTree();
                int n2 = mouseEvent.getY();
                int n3 = jFastTreeTable.getWidth();
                int n4 = 20;
                while (n4 < n3) {
                    TreePath treePath = jTree.getPathForLocation(n4, n2);
                    if (treePath != null) {
                        boolean bl = false;
                        TreePath[] treePathArray = jTree.getSelectionPaths();
                        if (treePathArray != null) {
                            int n5 = treePathArray.length - 1;
                            while (n5 >= 0) {
                                if (treePath.equals(treePathArray[n5])) {
                                    bl = true;
                                    break;
                                }
                                --n5;
                            }
                        }
                        if (!bl) {
                            this.selectTreeTablePath(jFastTreeTable, treePath, false);
                        }
                    }
                    n4 += 20;
                }
            } else if (jComponent instanceof JTable && (jTable = (JTable)jComponent).isEnabled() && (n = jTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(n, n);
            }
        }
        SwingUtilities.invokeLater(new 4(this, mouseEvent));
    }

    void selectTreeTablePath(JFastTreeTable jFastTreeTable, TreePath treePath, boolean bl) {
        JTree jTree = jFastTreeTable.getTree();
        if (bl) {
            SwingUtilities.invokeLater(new 3(this, jTree, treePath, jFastTreeTable));
        }
        SwingUtilities.invokeLater(new 2(this, jTree, treePath));
    }

    static void adjustColumnsAfterResize(JScrollPane jScrollPane, JTable jTable) {
        int n;
        if (jTable.getAutoResizeMode() == 0) {
            n = jTable.getWidth();
        } else {
            n = 0;
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                n += tableColumn.getPreferredWidth();
            }
        }
        int n2 = jScrollPane.getViewport().getWidth() - n;
        if (n2 > 0) {
            boolean bl = true;
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                int n3 = tableColumn.getPreferredWidth();
                if (bl) {
                    int n4 = tableColumnModel.getColumnCount() - 1;
                    int n5 = n4 > 0 ? n2 / 2 : n2;
                    n3 += n5;
                    if ((n2 -= n5) > 0 && n4 > 0) {
                        n2 /= n4;
                    }
                } else {
                    n3 += n2;
                }
                tableColumn.setPreferredWidth(n3);
                bl = false;
                if (n2 <= 0) break;
            }
        }
    }

    static void addColumnsMenu(JTable jTable, ColumnMenuListener columnMenuListener, boolean[] blArray) {
        int n = blArray.length;
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n2 = tableColumn.getModelIndex();
            if (n2 >= n || !blArray[n2]) continue;
            arrayList.add(tableColumn);
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.addMouseListener(new 1(arrayList, columnMenuListener, jTable));
    }

    static boolean isDoubleClickInTreeTable(JFastTreeTable jFastTreeTable, MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2) {
            int n = jFastTreeTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            int n2 = jFastTreeTable.convertColumnIndexToModel(n);
            if (n2 == 0) {
                JTree jTree = jFastTreeTable.getTree();
                TreePath treePath = jTree.getSelectionPath();
                if (treePath != null) {
                    Rectangle rectangle = jTree.getPathBounds(treePath);
                    rectangle.width = 1000;
                    Point point = mouseEvent.getPoint();
                    if (rectangle.contains(point)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    ObjectPreferences getObjectPreferences() {
        if (this.objectPreferences == null) {
            this.objectPreferences = new ObjectPreferences();
            this.objectPreferences.load();
        }
        return this.objectPreferences;
    }

    void setUseFilters(boolean bl) {
        this.dbgSettings.setUseFilters(bl);
        if (this.smartWindow != null) {
            this.smartWindow.setUseFilters(bl);
        }
        if (this.localsWindow != null) {
            this.localsWindow.setUseFilters(bl);
        }
        if (this.watchWindow != null) {
            this.watchWindow.setUseFilters(bl);
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.setUseFilters(bl);
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.setUseFilters(bl);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.setUseFilters(bl);
        }
    }

    void dataHasBeenModified() {
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        this.updateDataWindows();
        if (this.threadsWindow != null) {
            this.threadsWindow.everythingChanged();
        }
        if (this.classesWindow != null) {
            this.classesWindow.everythingChanged();
        }
        waitCursor.hide();
    }

    void updateDataWindows() {
        if (this.smartWindow != null) {
            this.smartWindow.everythingChanged();
        }
        if (this.localsWindow != null) {
            this.localsWindow.everythingChanged();
        }
        if (this.watchWindow != null) {
            this.watchWindow.everythingChanged();
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.everythingChanged();
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
    }

    static List<SmartDataProvider> getSmartDataProviders() {
        return smartDataProviders;
    }

    static List<ToolTipExpressionProvider> getToolTipExpressionProviders() {
        return toolTipExpressionProviders;
    }

    void stackFramesPopped() {
        if (this.stackWindow != null) {
            this.stackWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
    }

    static PrintWriter printHtmlHeader(URL uRL, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)), IdeUtil.getIdeIanaEncoding()));
        printWriter.println("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + IdeUtil.getIdeIanaEncoding() + "\">");
        printWriter.println("<meta name=\"Author\" content=\"JDeveloper Debugger\">");
        printWriter.println("<title>" + string + "</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        return printWriter;
    }

    static void printHtmlFooter(PrintWriter printWriter) {
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    static void setControllerForActions(IdeAction[] ideActionArray, Controller controller) {
        int n = 0;
        while (n < ideActionArray.length) {
            IdeAction ideAction = ideActionArray[n];
            if (ideAction != null) {
                ideAction.addController(controller);
                ideAction.putValue(ACTION_OWNER, (Object)controller);
            }
            ++n;
        }
    }

    static void clearControllerForActions(IdeAction[] ideActionArray, Controller controller) {
        int n = 0;
        while (n < ideActionArray.length) {
            IdeAction ideAction = ideActionArray[n];
            if (ideAction != null) {
                ideAction.removeController(controller);
                ideAction.putValue(ACTION_OWNER, null);
                ideAction.setEnabled(false);
            }
            ++n;
        }
    }

    static String fixTreeCellAccessibleName(String string, boolean bl) {
        if (string != null) {
            string = bl ? DbgArb.format(885, string) : DbgArb.format(886, string);
        }
        return string;
    }

    static long getObjectNumber(DebugDataCompositeInfo debugDataCompositeInfo) {
        long l;
        DebugVirtualMachine debugVirtualMachine = debugDataCompositeInfo.getVM();
        DebugCapabilities debugCapabilities = debugVirtualMachine.getCapabilities();
        if (debugCapabilities.canGetUniqueIDs()) {
            long l2 = debugDataCompositeInfo.getUniqueID();
            if (l2 != 0L) {
                return l2;
            }
        } else if (debugCapabilities.canGetAddresses() && (l = debugDataCompositeInfo.getAddressOfObject()) != 0L) {
            return l;
        }
        return 0L;
    }

    private static URL getUrlForClassSourceFile(Project project, String string) {
        SourceClass sourceClass;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaClass javaClass = javaManager.getClass(string);
        if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
            return sourceClass.getURL();
        }
        return null;
    }

    private static URL getUrlForPackage(Project project, String string) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaPackage javaPackage = javaManager.getPackage(string);
        Collection collection = javaPackage.getDeclaredClasses();
        if (collection != null && collection.size() > 0) {
            for (JavaClass javaClass : collection) {
                SourceClass sourceClass;
                if (javaClass == null || (sourceClass = (SourceClass)javaClass.getSourceElement()) == null) continue;
                URL uRL = sourceClass.getURL();
                URL uRL2 = URLFileSystem.getParent((URL)uRL);
                return uRL2;
            }
        }
        return null;
    }

    private static String[] getFileNamesFromUrls(URL[] uRLArray) {
        int n = uRLArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = URLFileSystem.getFileName((URL)uRLArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    private static long getEventTime(Context context) {
        EventObject eventObject = context.getEvent();
        if (eventObject instanceof ActionEvent) {
            return ((ActionEvent)eventObject).getWhen();
        }
        return 0L;
    }

    static int getLineStartOffsetSkipWhite(CodeEditor codeEditor, int n) {
        int n2 = codeEditor.getLineStartOffset(n);
        try {
            String string = codeEditor.getText(n2, codeEditor.getLineEndOffset(n) - n2);
            int n3 = 0;
            while (Character.isWhitespace(string.charAt(n3))) {
                ++n2;
                ++n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    private void updateRunConfigurationList() {
        RunConfigurations runConfigurations;
        RunConfiguration[] runConfigurationArray;
        int n;
        IdeAction[] ideActionArray = null;
        if (this.activeProject != null && this.activeProject.isOpen() && (n = (runConfigurationArray = (runConfigurations = RunConfigurations.getInstance((PropertyStorage)this.activeProject)).getVisibleRunConfigurations()).length) > 0) {
            debugProjectCmdIds = new int[n];
            ideActionArray = new IdeAction[n];
            String string = DbgArb.getString(0);
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            int n2 = 0;
            while (n2 < n) {
                RunConfiguration runConfiguration = runConfigurationArray[n2];
                String string2 = runConfiguration.getName();
                int n3 = Ide.findOrCreateCmdID((String)(DEBUG_PROJECT_CMD_PREFIX + n2));
                IdeAction ideAction = IdeAction.get((int)n3, null, (String)string2, (String)string, null, null, (Object)((Object)runConfiguration), (boolean)true);
                ideAction.putValue("Name", (Object)string2);
                ideAction.putValue("UserData", (Object)runConfiguration);
                ideAction.putValue("Radio", (Object)Boolean.TRUE);
                ideAction.addController((Controller)this);
                JDebugger.debugProjectCmdIds[n2] = n3;
                ideActionArray[n2] = ideAction;
                this.update(ideAction, context);
                ++n2;
            }
        }
        if (ideActionArray == null) {
            debugProjectCmdIds = new int[0];
            ideActionArray = new IdeAction[]{actionEmpty};
        }
        int n4 = ideActionArray.length;
        IdeAction[] ideActionArray2 = new IdeAction[n4 + 2];
        System.arraycopy(ideActionArray, 0, ideActionArray2, 0, n4);
        ideActionArray = ideActionArray2;
        ideActionArray[n4++] = null;
        ideActionArray[n4++] = RunManager.getManageRunConfigurationsAction();
        actionDebugProject.putValue("ActionMenuActions", (Object)ideActionArray);
    }

    public Action getActionDebugProject() {
        return actionDebugProject;
    }

    static boolean isSecretFeatureEnabled(String string) {
        return Ide.getProperty((String)string) != null;
    }

    static void mav$activeProjectChanged(JDebugger jDebugger) {
        jDebugger.activeProjectChanged();
    }

    static Project ra$activeProject(JDebugger jDebugger) {
        return jDebugger.activeProject;
    }

    static void mav$updateRunConfigurationList(JDebugger jDebugger) {
        jDebugger.updateRunConfigurationList();
    }

    static void mav$checkCommandsBecauseActiveProjectChanged(JDebugger jDebugger) {
        jDebugger.checkCommandsBecauseActiveProjectChanged();
    }

    static void mav$debugWindowSettingsChanged(JDebugger jDebugger) {
        jDebugger.debugWindowSettingsChanged();
    }

    static void mav$updateDebugActions(JDebugger jDebugger) {
        jDebugger.updateDebugActions();
    }

    static int ra$duringClassRedefinition(JDebugger jDebugger) {
        return jDebugger.duringClassRedefinition;
    }

    static void wa$duringClassRedefinition(JDebugger jDebugger, int n) {
        jDebugger.duringClassRedefinition = n;
    }

    static void mav$checkCommandsBecauseTracingChanged(JDebugger jDebugger) {
        jDebugger.checkCommandsBecauseTracingChanged();
    }

    public final class 15
    implements Runnable {
        private final /* synthetic */ UpdateMessage v$change;
        private final /* synthetic */ Object v$observed;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            int n = this.v$change.getMessageID();
            if (this.v$observed == Ide.getSystem()) {
                if (n == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    JDebugger.mav$activeProjectChanged(this.this$0);
                }
            } else if (this.v$observed instanceof Workspace) {
                if (n == UpdateMessage.OBJECT_RENAMED) {
                    Breakpoint.breakpointOwnerRenamed(this.v$change);
                }
            } else if (this.v$observed instanceof Project && n == UpdateMessage.OBJECT_RENAMED) {
                Breakpoint.breakpointOwnerRenamed(this.v$change);
            }
        }

        public 15(JDebugger jDebugger, UpdateMessage updateMessage, Object object) {
            this.v$observed = object;
            this.v$change = updateMessage;
            this.this$0 = jDebugger;
        }
    }

    public final class 14
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            if (project == JDebugger.ra$activeProject(JDebugger.this)) {
                this.updateNowOrLater();
            }
        }

        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            if (projectChangeEvent.getProject() == JDebugger.ra$activeProject(JDebugger.this)) {
                this.updateNowOrLater();
            }
        }

        private void updateNowOrLater() {
            1 var1_1 = new 1();
            if (SwingUtilities.isEventDispatchThread()) {
                var1_1.run();
            } else {
                SwingUtilities.invokeLater(var1_1);
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                JDebugger.mav$updateRunConfigurationList(JDebugger.this);
                JDebugger.this.tracingChanged();
                JDebugger.mav$checkCommandsBecauseActiveProjectChanged(JDebugger.this);
            }
        }
    }

    public final class 13
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JDebugger.mav$debugWindowSettingsChanged(JDebugger.this);
        }
    }

    public final class 12
    implements Runnable {
        public void run() {
            JDebugger.mav$updateDebugActions(JDebugger.this);
        }
    }

    public final class 11
    extends Thread {
        public void run() {
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new 1());
        }

        public 11(String string) {
            super(string);
        }

        public final class 1
        implements Runnable {
            public void run() {
                JDebugger.mav$updateDebugActions(JDebugger.this);
            }
        }
    }

    public final class 10
    implements RunWhilePaused {
        private final /* synthetic */ URL v$outputDirectory;
        private final /* synthetic */ Map v$nameToGuts;
        final /* synthetic */ JDebugger this$0;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            if (bl) {
                Project project = debuggingProcess.getJProject();
                if (this.v$outputDirectory == null || URLFileSystem.equals((URL)this.v$outputDirectory, (URL)JavaProject.getInstance(project).getOutputDirectory()) || PathsConfiguration.getInstance(project).getRunClassPath().contains(this.v$outputDirectory)) {
                    debuggingProcess.redefineClasses(this.v$nameToGuts);
                    Breakpoint.updateBreakpointIcons(Breakpoint.getBreakpoints(debuggingProcess.getWorkspace(), debuggingProcess.getProject()));
                    this.this$0.updateBreakpointsWindowStatus();
                }
            }
        }

        public 10(JDebugger jDebugger, URL uRL, Map map) {
            this.v$nameToGuts = map;
            this.v$outputDirectory = uRL;
            this.this$0 = jDebugger;
        }
    }

    public final class 9
    implements Runnable {
        public void run() {
            JDebugger jDebugger = JDebugger.this;
            JDebugger.wa$duringClassRedefinition(jDebugger, JDebugger.ra$duringClassRedefinition(jDebugger) - 1);
        }
    }

    public final class 8
    implements Comparator {
        public int compare(IdeAction ideAction, IdeAction ideAction2) {
            String string = (String)ideAction.getValue("Name");
            String string2 = (String)ideAction2.getValue("Name");
            return string.compareTo(string2);
        }
    }

    public final class 7
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            if (debuggingProcess != null && bl) {
                debuggingProcess.setTracing();
            }
        }
    }

    public final class 6
    implements Runnable {
        public void run() {
            JDebugger.mav$checkCommandsBecauseTracingChanged(JDebugger.this);
        }
    }

    public static final class 5
    implements RunWhilePaused {
        private final /* synthetic */ RunWhilePaused v$runWhilePaused;
        private final /* synthetic */ int[] v$countDown;
        private final /* synthetic */ Runnable v$runOnceLater;

        public void run(DebuggingProcess debuggingProcess, boolean bl) {
            if (debuggingProcess != null && bl) {
                this.v$runWhilePaused.run(debuggingProcess, bl);
            }
            this.v$countDown[0] = this.v$countDown[0] - 1;
            if (this.v$countDown[0] == 0 && this.v$runOnceLater != null) {
                SwingUtilities.invokeLater(this.v$runOnceLater);
            }
        }

        public 5(RunWhilePaused runWhilePaused, int[] nArray, Runnable runnable) {
            this.v$runOnceLater = runnable;
            this.v$countDown = nArray;
            this.v$runWhilePaused = runWhilePaused;
        }
    }

    public final class 4
    implements Runnable {
        private final /* synthetic */ MouseEvent v$e;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            Context context = Ide.getMainWindow().getLastActiveView().getContext((EventObject)this.v$e);
            ContextMenu contextMenu = this.this$0.getContextMenu();
            contextMenu.show(context);
        }

        public 4(JDebugger jDebugger, MouseEvent mouseEvent) {
            this.v$e = mouseEvent;
            this.this$0 = jDebugger;
        }
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ JTree v$tree;
        private final /* synthetic */ TreePath v$treePath;
        private final /* synthetic */ JFastTreeTable v$treeTable;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            int n = this.v$tree.getRowForPath(this.v$treePath);
            Rectangle rectangle = this.v$treeTable.getCellRect(n, 0, true);
            if (rectangle != null) {
                this.v$treeTable.scrollRectToVisible(rectangle);
            }
        }

        public 3(JDebugger jDebugger, JTree jTree, TreePath treePath, JFastTreeTable jFastTreeTable) {
            this.v$treeTable = jFastTreeTable;
            this.v$treePath = treePath;
            this.v$tree = jTree;
            this.this$0 = jDebugger;
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ JTree v$tree;
        private final /* synthetic */ TreePath v$treePath;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            this.v$tree.setSelectionPath(this.v$treePath);
        }

        public 2(JDebugger jDebugger, JTree jTree, TreePath treePath) {
            this.v$treePath = treePath;
            this.v$tree = jTree;
            this.this$0 = jDebugger;
        }
    }

    public static final class oracle.jdevimpl.runner.debug.JDebugger$1
    extends MouseAdapter {
        private final /* synthetic */ List v$allColumns;
        private final /* synthetic */ ColumnMenuListener v$columnMenuListener;
        private final /* synthetic */ JTable v$table;

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            Context context = Ide.getMainWindow().getLastActiveView().getContext((EventObject)mouseEvent);
            ContextMenu contextMenu = new ContextMenu();
            contextMenu.addContextMenuListener((ContextMenuListener)new 1());
            contextMenu.show(context);
        }

        public oracle.jdevimpl.runner.debug.JDebugger$1(List list, ColumnMenuListener columnMenuListener, JTable jTable) {
            this.v$table = jTable;
            this.v$columnMenuListener = columnMenuListener;
            this.v$allColumns = list;
        }

        static List ra$v$allColumns(oracle.jdevimpl.runner.debug.JDebugger$1 var0) {
            return var0.v$allColumns;
        }

        static JTable ra$v$table(oracle.jdevimpl.runner.debug.JDebugger$1 var0) {
            return var0.v$table;
        }

        static ColumnMenuListener ra$v$columnMenuListener(oracle.jdevimpl.runner.debug.JDebugger$1 var0) {
            return var0.v$columnMenuListener;
        }

        public final class oracle.jdevimpl.runner.debug.JDebugger$1$1
        implements ContextMenuListener {
            public void menuWillShow(ContextMenu contextMenu) {
                HashMap<Integer, JCheckBoxMenuItem> hashMap = new HashMap<Integer, JCheckBoxMenuItem>();
                for (TableColumn tableColumn : oracle.jdevimpl.runner.debug.JDebugger$1.ra$v$allColumns(1.this)) {
                    int n = tableColumn.getModelIndex();
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(tableColumn.getHeaderValue().toString());
                    jCheckBoxMenuItem.addActionListener(new 1(this, jCheckBoxMenuItem, n));
                    hashMap.put(n, jCheckBoxMenuItem);
                    contextMenu.add((Component)jCheckBoxMenuItem);
                }
                TableColumnModel tableColumnModel = oracle.jdevimpl.runner.debug.JDebugger$1.ra$v$table(1.this).getColumnModel();
                Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn = enumeration.nextElement();
                    int n = tableColumn.getModelIndex();
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)hashMap.get(n);
                    if (jCheckBoxMenuItem == null) continue;
                    jCheckBoxMenuItem.setState(true);
                }
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }

            public final class 1
            implements ActionListener {
                private final /* synthetic */ JCheckBoxMenuItem v$menuItem;
                private final /* synthetic */ int v$modelIndex;
                final /* synthetic */ oracle.jdevimpl.runner.debug.JDebugger$1$1 this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.v$menuItem.getState()) {
                        oracle.jdevimpl.runner.debug.JDebugger$1.ra$v$columnMenuListener(this.this$0.1.this).showColumn(this.v$modelIndex);
                    } else {
                        oracle.jdevimpl.runner.debug.JDebugger$1.ra$v$columnMenuListener(this.this$0.1.this).hideColumn(this.v$modelIndex);
                    }
                }

                public 1(oracle.jdevimpl.runner.debug.JDebugger$1$1 var1_1, JCheckBoxMenuItem jCheckBoxMenuItem, int n) {
                    this.v$modelIndex = n;
                    this.v$menuItem = jCheckBoxMenuItem;
                    this.this$0 = var1_1;
                }
            }
        }
    }
}

