/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceHasType;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.EvaluationInfo;

class JavaEvaluator
extends BaseEvaluator {
    private boolean allowMethodInvocation;
    private static final String PRIMITIVE_TYPE_BOOLEAN = "boolean";
    private static final String PRIMITIVE_TYPE_BYTE = "byte";
    private static final String PRIMITIVE_TYPE_CHAR = "char";
    private static final String PRIMITIVE_TYPE_DOUBLE = "double";
    private static final String PRIMITIVE_TYPE_FLOAT = "float";
    private static final String PRIMITIVE_TYPE_INT = "int";
    private static final String PRIMITIVE_TYPE_LONG = "long";
    private static final String PRIMITIVE_TYPE_SHORT = "short";
    private static final char SIGNATURE_OBJECT = 'L';
    private static final char SIGNATURE_BOOLEAN = 'Z';
    private static final char SIGNATURE_BYTE = 'B';
    private static final char SIGNATURE_CHAR = 'C';
    private static final char SIGNATURE_DOUBLE = 'D';
    private static final char SIGNATURE_FLOAT = 'F';
    private static final char SIGNATURE_INT = 'I';
    private static final char SIGNATURE_LONG = 'J';
    private static final char SIGNATURE_SHORT = 'S';

    private static boolean isPrimitiveType(String string) {
        return string.equals(PRIMITIVE_TYPE_BOOLEAN) || string.equals(PRIMITIVE_TYPE_BYTE) || string.equals(PRIMITIVE_TYPE_CHAR) || string.equals(PRIMITIVE_TYPE_SHORT) || string.equals(PRIMITIVE_TYPE_INT) || string.equals(PRIMITIVE_TYPE_LONG) || string.equals(PRIMITIVE_TYPE_FLOAT) || string.equals(PRIMITIVE_TYPE_DOUBLE);
    }

    JavaEvaluator(DebugContext debugContext, boolean bl) {
        super(debugContext);
        this.allowMethodInvocation = bl;
    }

    private static SourceExpression getSourceExpression(String string) {
        try {
            SourceExpression sourceExpression;
            SourceFile sourceFile = SourceFactory.createFile((int)3);
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceExpression sourceExpression2 = sourceExpression = sourceFactory.createExpressionFromText(string);
            return sourceExpression2;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return null;
        }
    }

    static boolean validate(String string) {
        return JavaEvaluator.getSourceExpression(string) != null;
    }

    int evaluateConditionResult(Object object) {
        block4: {
            try {
                EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
                if (evaluationInfo != null && evaluationInfo.getClassInfo().getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
                    if (evaluationInfo.getBooleanValue()) {
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)throwable;
            }
        }
        return -1;
    }

    Object evaluate(String string) {
        block3: {
            SourceExpression sourceExpression = null;
            try {
                sourceExpression = JavaEvaluator.getSourceExpression(string);
                if (sourceExpression != null) {
                    Object object;
                    Object object2 = object = this.evaluateSourceExpression_evaluateSimple(sourceExpression);
                    return object2;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
        return null;
    }

    private Object evaluateSourceExpression(SourceExpression sourceExpression) throws Exception {
        switch (sourceExpression.getOperatorCode()) {
            case 4: {
                throw new Exception("Unable to evaluate source expression: annotation");
            }
            case 16: {
                return this.evaluateArrayAccess(sourceExpression);
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 52: 
            case 57: {
                throw new Exception("Unable to evaluate source expression: assignment");
            }
            case 19: {
                return this.evaluateDot(sourceExpression);
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 42: 
            case 43: 
            case 51: 
            case 56: {
                return this.evaluateInfix(sourceExpression);
            }
            case 5: 
            case 26: {
                throw new Exception("Unable to evaluate source expression: list");
            }
            case 27: {
                return this.evaluateLiteral(sourceExpression);
            }
            case 24: {
                return this.evaluateMethodCall(sourceExpression);
            }
            case 39: {
                throw new Exception("Unable to evaluate source expression: new array");
            }
            case 40: {
                throw new Exception("Unable to evaluate source expression: new object");
            }
            case 15: {
                return this.evaluateQuestion(sourceExpression);
            }
            case 53: {
                return this.evaluateSimpleName(sourceExpression);
            }
            case 54: {
                return this.evaluateType(sourceExpression);
            }
            case 55: {
                return this.evaluateTypecast(sourceExpression);
            }
            case 9: 
            case 14: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return this.evaluateUnary(sourceExpression);
            }
            case 38: {
                return this.evaluateWrapper(sourceExpression);
            }
        }
        throw new Exception("Unable to evaluate source expression");
    }

    private Object evaluateSourceExpression_evaluateSimple(SourceExpression sourceExpression) throws Exception {
        Object object = this.evaluateSourceExpression(sourceExpression);
        if (object instanceof String) {
            object = this.evaluateSimple((String)object);
        }
        return object;
    }

    private EvaluationInfo evaluateSourceExpression_convertToEvaluationInfo(SourceExpression sourceExpression) throws Exception {
        Object object = this.evaluateSourceExpression(sourceExpression);
        return this.convertToEvaluationInfo(object);
    }

    private Object evaluateArrayAccess(SourceExpression sourceExpression) throws Exception {
        Object object = this.evaluateSourceExpression_evaluateSimple(sourceExpression.getFirstOperand());
        DebugDataInfo debugDataInfo = JavaEvaluator.getDataInfo(object);
        SourceExpression sourceExpression2 = sourceExpression.getSecondOperand();
        int n = sourceExpression2.getOperandCount();
        int n2 = 0;
        while (n2 < n) {
            DebugDataArrayInfo debugDataArrayInfo;
            if (!(debugDataInfo instanceof DebugDataArrayInfo) || (debugDataArrayInfo = (DebugDataArrayInfo)debugDataInfo).isNull()) break;
            int n3 = debugDataArrayInfo.getArrayStart();
            int n4 = debugDataArrayInfo.getArrayCount();
            EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression2.getOperandAt(n2));
            int n5 = evaluationInfo.getIntValue();
            if (n3 > n5 || n4 != -1 && n5 >= n3 + n4) break;
            DebugArrayElementInfo debugArrayElementInfo = debugDataArrayInfo.getArrayElements(n5, 1)[0];
            if (n2 == n - 1) {
                return debugArrayElementInfo;
            }
            debugDataInfo = debugArrayElementInfo.getDataInfo();
            ++n2;
        }
        throw new Exception("Unable to evaluate array access");
    }

    private Object evaluateDot(SourceExpression sourceExpression) throws Exception {
        DebugClassInfo debugClassInfo;
        DebugFieldInfo[] debugFieldInfoArray;
        Object object;
        Object object2 = null;
        String string = null;
        boolean bl = false;
        SourceExpression sourceExpression2 = sourceExpression.getFirstOperand();
        int n = sourceExpression2.getOperatorCode();
        if (n == 53 && ((SourceHasName)sourceExpression2).getName().equals("super")) {
            object2 = this.evaluateSimple("this");
            bl = true;
        } else {
            object2 = this.evaluateSourceExpression(sourceExpression.getFirstOperand());
            if (object2 instanceof String) {
                string = (String)object2;
                object2 = this.evaluateSimple(string);
            }
        }
        String string2 = ((SourceHasName)sourceExpression).getName();
        DebugDataInfo debugDataInfo = JavaEvaluator.getDataInfo(object2);
        if (debugDataInfo instanceof DebugDataObjectInfo) {
            DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo;
            if (!bl && debugDataObjectInfo.canGetFieldByName()) {
                DebugFieldInfo debugFieldInfo = debugDataObjectInfo.getField(string2);
                if (debugFieldInfo != null) {
                    return debugFieldInfo;
                }
            } else {
                DebugClassInfo debugClassInfo2 = debugDataObjectInfo.getClassInfo();
                int n2 = 0;
                if (bl) {
                    n2 = 1;
                    debugClassInfo2 = debugClassInfo2.getSuperClass(1);
                }
                DebugClassInfo debugClassInfo3 = debugClassInfo2;
                while (debugClassInfo3 != null) {
                    DebugFieldInfo[] debugFieldInfoArray2 = debugDataObjectInfo.getFields(n2);
                    Object object3 = this.checkFields(string2, debugFieldInfoArray2);
                    if (object3 != null) {
                        return object3;
                    }
                    debugClassInfo3 = debugClassInfo3.getSuperClass(1);
                }
            }
        }
        if (object2 instanceof DebugClassInfo && (object = this.checkFields(string2, debugFieldInfoArray = (debugClassInfo = (DebugClassInfo)object2).getStaticFields(-1))) != null) {
            return object;
        }
        if (string != null) {
            return string + "." + string2;
        }
        throw new Exception("Unable to evaluate dot");
    }

    private EvaluationInfo evaluateInfix(SourceExpression sourceExpression) throws Exception {
        int n = sourceExpression.getOperatorCode();
        switch (n) {
            case 23: {
                return this.evaluateInstanceOfOperator(sourceExpression);
            }
            case 3: 
            case 43: {
                return this.evaluateLogicalInfixOperator(sourceExpression, n);
            }
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 30: 
            case 42: {
                return this.evaluateComparisonOperator(sourceExpression, n);
            }
            case 28: 
            case 51: 
            case 56: {
                return this.evaluateShiftOperator(sourceExpression, n);
            }
            case 17: 
            case 31: 
            case 33: {
                return this.evaluateArithmeticInfixOperator(sourceExpression, n);
            }
            case 1: 
            case 7: 
            case 10: 
            case 12: 
            case 35: {
                return this.evaluateArithmeticInfixOperatorMulti(sourceExpression, n);
            }
        }
        throw new Exception("Unable to evaluate infix");
    }

    private EvaluationInfo evaluateInstanceOfOperator(SourceExpression sourceExpression) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        String string = ((SourceHasType)sourceExpression.getSecondOperand()).getSourceType().getName();
        DebugClassInfo debugClassInfo = evaluationInfo.getClassInfo();
        DebugClassInfo debugClassInfo2 = this.findClass(string);
        if (!debugClassInfo.isPrimitive() && debugClassInfo2 != null && !debugClassInfo2.isPrimitive()) {
            string = debugClassInfo2.getName();
            if (debugClassInfo2.isInterface()) {
                DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces(-1);
                int n = debugClassInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = debugClassInfoArray[n2].getName();
                    if (string2.equals(string)) {
                        return new EvaluationInfo(true, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                    }
                    ++n2;
                }
                return new EvaluationInfo(false, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            if (debugClassInfo2.isObject() || debugClassInfo2.isArray()) {
                DebugClassInfo debugClassInfo3 = debugClassInfo;
                while (debugClassInfo3 != null) {
                    String string3 = debugClassInfo3.getName();
                    if (string3.equals(string)) {
                        return new EvaluationInfo(true, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                    }
                    debugClassInfo3 = debugClassInfo3.getSuperClass(1);
                }
                return new EvaluationInfo(false, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
        }
        throw new Exception("Unable to evaluate instanceof operator");
    }

    private EvaluationInfo evaluateLogicalInfixOperator(SourceExpression sourceExpression, int n) throws Exception {
        boolean bl;
        switch (n) {
            case 43: {
                bl = true;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            default: {
                throw new Exception("Unable to evaluate logical infix operator");
            }
        }
        int n2 = sourceExpression.getOperandCount();
        int n3 = 0;
        while (n3 < n2) {
            EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getOperandAt(n3));
            DebugClassInfo debugClassInfo = evaluationInfo.getClassInfo();
            if (debugClassInfo.getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
                if (evaluationInfo.getBooleanValue() == bl) {
                    return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
            } else {
                throw new Exception("Unable to evaluate logical infix operator");
            }
            ++n3;
        }
        return new EvaluationInfo(bl ^ true, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
    }

    private EvaluationInfo evaluateComparisonOperator(SourceExpression sourceExpression, int n) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        EvaluationInfo evaluationInfo2 = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getSecondOperand());
        char c = this.comparisonPromotion(evaluationInfo, evaluationInfo2);
        switch (c) {
            case 'L': {
                long l = this.getComparableId(evaluationInfo);
                long l2 = this.getComparableId(evaluationInfo2);
                boolean bl = false;
                switch (n) {
                    case 20: {
                        bl = l == l2;
                        break;
                    }
                    case 42: {
                        bl = l != l2;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 25: 
                    case 30: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'Z': {
                boolean bl = evaluationInfo.getBooleanValue();
                boolean bl2 = evaluationInfo2.getBooleanValue();
                boolean bl3 = false;
                switch (n) {
                    case 20: {
                        bl3 = bl == bl2;
                        break;
                    }
                    case 42: {
                        bl3 = bl != bl2;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 25: 
                    case 30: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return new EvaluationInfo(bl3, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'I': {
                int n2 = evaluationInfo.getIntValue();
                int n3 = evaluationInfo2.getIntValue();
                boolean bl = false;
                switch (n) {
                    case 20: {
                        bl = n2 == n3;
                        break;
                    }
                    case 42: {
                        bl = n2 != n3;
                        break;
                    }
                    case 30: {
                        bl = n2 < n3;
                        break;
                    }
                    case 22: {
                        bl = n2 > n3;
                        break;
                    }
                    case 25: {
                        bl = n2 <= n3;
                        break;
                    }
                    case 21: {
                        bl = n2 >= n3;
                    }
                }
                return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'J': {
                long l = evaluationInfo.getLongValue();
                long l3 = evaluationInfo2.getLongValue();
                boolean bl = false;
                switch (n) {
                    case 20: {
                        bl = l == l3;
                        break;
                    }
                    case 42: {
                        bl = l != l3;
                        break;
                    }
                    case 30: {
                        bl = l < l3;
                        break;
                    }
                    case 22: {
                        bl = l > l3;
                        break;
                    }
                    case 25: {
                        bl = l <= l3;
                        break;
                    }
                    case 21: {
                        bl = l >= l3;
                    }
                }
                return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'F': {
                float f = evaluationInfo.getFloatValue();
                float f2 = evaluationInfo2.getFloatValue();
                boolean bl = false;
                switch (n) {
                    case 20: {
                        bl = f == f2;
                        break;
                    }
                    case 42: {
                        bl = f != f2;
                        break;
                    }
                    case 30: {
                        bl = f < f2;
                        break;
                    }
                    case 22: {
                        bl = f > f2;
                        break;
                    }
                    case 25: {
                        bl = f <= f2;
                        break;
                    }
                    case 21: {
                        bl = f >= f2;
                    }
                }
                return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'D': {
                double d = evaluationInfo.getDoubleValue();
                double d2 = evaluationInfo2.getDoubleValue();
                boolean bl = false;
                switch (n) {
                    case 20: {
                        bl = d == d2;
                        break;
                    }
                    case 42: {
                        bl = d != d2;
                        break;
                    }
                    case 30: {
                        bl = d < d2;
                        break;
                    }
                    case 22: {
                        bl = d > d2;
                        break;
                    }
                    case 25: {
                        bl = d <= d2;
                        break;
                    }
                    case 21: {
                        bl = d >= d2;
                    }
                }
                return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    private EvaluationInfo evaluateShiftOperator(SourceExpression sourceExpression, int n) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        EvaluationInfo evaluationInfo2 = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getSecondOperand());
        char c = this.numericPromotion(evaluationInfo);
        switch (c) {
            case 'I': {
                int n2 = evaluationInfo.getIntValue();
                int n3 = evaluationInfo2.getIntValue();
                int n4 = 0;
                switch (n) {
                    case 28: {
                        n4 = n2 << n3;
                        break;
                    }
                    case 51: {
                        n4 = n2 >> n3;
                        break;
                    }
                    case 56: {
                        n4 = n2 >>> n3;
                    }
                }
                return new EvaluationInfo(n4, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long l = evaluationInfo.getLongValue();
                int n5 = evaluationInfo2.getIntValue();
                long l2 = 0L;
                switch (n) {
                    case 28: {
                        l2 = l << n5;
                        break;
                    }
                    case 51: {
                        l2 = l >> n5;
                        break;
                    }
                    case 56: {
                        l2 = l >>> n5;
                    }
                }
                return new EvaluationInfo(l2, this.findClass(PRIMITIVE_TYPE_LONG));
            }
        }
        throw new Exception("Unable to evaluate shift operator");
    }

    private EvaluationInfo evaluateArithmeticInfixOperator(SourceExpression sourceExpression, int n) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        EvaluationInfo evaluationInfo2 = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getSecondOperand());
        return this.evaluateArithmeticInfixOperator(evaluationInfo, evaluationInfo2, n);
    }

    private EvaluationInfo evaluateArithmeticInfixOperatorMulti(SourceExpression sourceExpression, int n) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        int n2 = sourceExpression.getOperandCount();
        int n3 = 1;
        while (n3 < n2) {
            EvaluationInfo evaluationInfo2 = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getOperandAt(n3));
            evaluationInfo = n == 1 && (this.isStringClass(evaluationInfo.getClassInfo()) || this.isStringClass(evaluationInfo2.getClassInfo())) ? this.evaluateStringConcatenation(evaluationInfo, evaluationInfo2) : this.evaluateArithmeticInfixOperator(evaluationInfo, evaluationInfo2, n);
            ++n3;
        }
        return evaluationInfo;
    }

    private EvaluationInfo evaluateArithmeticInfixOperator(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2, int n) throws Exception {
        char c = this.numericPromotion(evaluationInfo, evaluationInfo2);
        switch (c) {
            case 'I': {
                int n2 = evaluationInfo.getIntValue();
                int n3 = evaluationInfo2.getIntValue();
                int n4 = 0;
                switch (n) {
                    case 1: {
                        n4 = n2 + n3;
                        break;
                    }
                    case 31: {
                        n4 = n2 - n3;
                        break;
                    }
                    case 35: {
                        n4 = n2 * n3;
                        break;
                    }
                    case 17: {
                        n4 = n2 / n3;
                        break;
                    }
                    case 33: {
                        n4 = n2 % n3;
                        break;
                    }
                    case 10: {
                        n4 = n2 | n3;
                        break;
                    }
                    case 12: {
                        n4 = n2 ^ n3;
                        break;
                    }
                    case 7: {
                        n4 = n2 & n3;
                    }
                }
                return new EvaluationInfo(n4, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long l = evaluationInfo.getLongValue();
                long l2 = evaluationInfo2.getLongValue();
                long l3 = 0L;
                switch (n) {
                    case 1: {
                        l3 = l + l2;
                        break;
                    }
                    case 31: {
                        l3 = l - l2;
                        break;
                    }
                    case 35: {
                        l3 = l * l2;
                        break;
                    }
                    case 17: {
                        l3 = l / l2;
                        break;
                    }
                    case 33: {
                        l3 = l % l2;
                        break;
                    }
                    case 10: {
                        l3 = l | l2;
                        break;
                    }
                    case 12: {
                        l3 = l ^ l2;
                        break;
                    }
                    case 7: {
                        l3 = l & l2;
                    }
                }
                return new EvaluationInfo(l3, this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 'F': {
                float f = evaluationInfo.getFloatValue();
                float f2 = evaluationInfo2.getFloatValue();
                float f3 = 0.0f;
                switch (n) {
                    case 1: {
                        f3 = f + f2;
                        break;
                    }
                    case 31: {
                        f3 = f - f2;
                        break;
                    }
                    case 35: {
                        f3 = f * f2;
                        break;
                    }
                    case 17: {
                        f3 = f / f2;
                        break;
                    }
                    case 33: {
                        f3 = f % f2;
                        break;
                    }
                    case 7: 
                    case 10: 
                    case 12: {
                        throw new Exception("Unable to evaluate arithmetic infix operator");
                    }
                }
                return new EvaluationInfo(f3, this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 'D': {
                double d = evaluationInfo.getDoubleValue();
                double d2 = evaluationInfo2.getDoubleValue();
                double d3 = 0.0;
                switch (n) {
                    case 1: {
                        d3 = d + d2;
                        break;
                    }
                    case 31: {
                        d3 = d - d2;
                        break;
                    }
                    case 35: {
                        d3 = d * d2;
                        break;
                    }
                    case 17: {
                        d3 = d / d2;
                        break;
                    }
                    case 33: {
                        d3 = d % d2;
                        break;
                    }
                    case 7: 
                    case 10: 
                    case 12: {
                        throw new Exception("Unable to evaluate arithmetic infix operator");
                    }
                }
                return new EvaluationInfo(d3, this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
        }
        throw new Exception("Unable to evaluate arithmetic infix operator");
    }

    private EvaluationInfo evaluateStringConcatenation(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2) throws Exception {
        String string = this.convertToStringForConcatenation(evaluationInfo);
        String string2 = this.convertToStringForConcatenation(evaluationInfo2);
        String string3 = string + string2;
        return new EvaluationInfo('\"' + string3 + '\"', this.findStringClass());
    }

    private String convertToStringForConcatenation(EvaluationInfo evaluationInfo) throws Exception {
        EvaluationInfo evaluationInfo2;
        DebugClassInfo debugClassInfo = evaluationInfo.getClassInfo();
        if (evaluationInfo.isNull()) {
            return "null";
        }
        if (this.isStringClass(debugClassInfo)) {
            return evaluationInfo.getStringValue();
        }
        if (debugClassInfo.isPrimitive()) {
            return evaluationInfo.getValue();
        }
        Object object = this.evaluateMethodInvocation(evaluationInfo, false, "toString", new ArrayList(0));
        if (object != null && (evaluationInfo2 = this.convertToEvaluationInfo(object)) != null && this.isStringClass(evaluationInfo2.getClassInfo())) {
            return evaluationInfo2.getStringValue();
        }
        throw new Exception("Unable to evaluate string concatenation");
    }

    private EvaluationInfo evaluateLiteral(SourceExpression sourceExpression) throws Exception {
        String string = sourceExpression.getText();
        switch (((SourceLiteralExpression)sourceExpression).getTokenValue()) {
            case 8: {
                return new EvaluationInfo(DebugSharedPrimitives.intDecode(string), this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 9: {
                int n = string.length();
                char c = string.charAt(n - 1);
                if (c == 'l' || c == 'L') {
                    string = string.substring(0, n - 1);
                }
                return new EvaluationInfo(DebugSharedPrimitives.longDecode(string), this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 10: {
                int n = string.length();
                char c = string.charAt(n - 1);
                if (c == 'f' || c == 'F') {
                    string = string.substring(0, n - 1);
                }
                return new EvaluationInfo(DebugSharedPrimitives.floatDecode(string), this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 11: {
                int n = string.length();
                char c = string.charAt(n - 1);
                if (c == 'd' || c == 'D') {
                    string = string.substring(0, n - 1);
                }
                return new EvaluationInfo(DebugSharedPrimitives.doubleDecode(string), this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
            case 12: {
                return new EvaluationInfo(DebugSharedPrimitives.booleanDecode(string), this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 13: {
                return new EvaluationInfo(DebugSharedPrimitives.charDecode(string), this.findClass(PRIMITIVE_TYPE_CHAR));
            }
            case 14: {
                return new EvaluationInfo(string, this.findStringClass());
            }
            case 15: {
                return new EvaluationInfo("null", this.findClass("java.lang.Object"), null);
            }
        }
        throw new Exception("Unable to evaluate literal");
    }

    private Object evaluateMethodCall(SourceExpression sourceExpression) throws Exception {
        Object object = null;
        boolean bl = false;
        String string = ((SourceHasName)sourceExpression).getName();
        List list = null;
        int n = sourceExpression.getOperandCount();
        if (n == 1) {
            object = this.evaluateSimple("this");
            list = sourceExpression.getFirstOperand().getOperands();
        } else if (n == 2) {
            SourceExpression sourceExpression2 = sourceExpression.getFirstOperand();
            int n2 = sourceExpression2.getOperatorCode();
            if (n2 == 53 && ((SourceHasName)sourceExpression2).getName().equals("super")) {
                object = this.evaluateSimple("this");
                bl = true;
            } else {
                object = this.evaluateSourceExpression_evaluateSimple(sourceExpression2);
            }
            list = sourceExpression.getSecondOperand().getOperands();
        } else if (n == 3) {
            // empty if block
        }
        if (object != null && list != null) {
            return this.evaluateMethodInvocation(object, bl, string, list);
        }
        throw new Exception("Unable to evaluate method call");
    }

    private Object evaluateMethodInvocation(Object object, boolean bl, String string, List list) throws Exception {
        if (this.allowMethodInvocation && this.debugContext.vm != null && this.debugContext.vm.getCapabilities().canInvokeMethod()) {
            EvaluationInfo evaluationInfo;
            DebugClassInfo debugClassInfo;
            DebugDataInfo debugDataInfo;
            int n = list.size();
            EvaluationInfo[] evaluationInfoArray = new EvaluationInfo[n];
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = 0;
            while (n2 < n) {
                EvaluationInfo evaluationInfo2;
                evaluationInfoArray[n2] = evaluationInfo2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(n2));
                DebugDataInfo debugDataInfo2 = evaluationInfo2.getDataInfo();
                if (debugDataInfo2 != null) {
                    arrayList.add(debugDataInfo2);
                } else {
                    Object object2 = evaluationInfo2.getWrappedValue();
                    if (object2 != null) {
                        arrayList.add(object2);
                    } else if (this.isStringClass(evaluationInfo2.getClassInfo())) {
                        String string2 = evaluationInfo2.getStringValue();
                        arrayList.add(string2);
                    } else if (evaluationInfo2.isNull()) {
                        arrayList.add(null);
                    } else {
                        throw new Exception("Unable to evaluate method invocation");
                    }
                }
                ++n2;
            }
            DebugMethodInfo debugMethodInfo = null;
            if (object instanceof DebugClassInfo) {
                DebugClassInfo debugClassInfo2 = (DebugClassInfo)object;
                debugMethodInfo = this.findMethod(debugClassInfo2, string, 8, evaluationInfoArray);
            }
            if (debugMethodInfo == null && (debugDataInfo = JavaEvaluator.getDataInfo(object)) instanceof DebugDataObjectInfo) {
                DebugClassInfo debugClassInfo3 = debugDataInfo.getClassInfo();
                if (bl) {
                    debugClassInfo3 = debugClassInfo3.getSuperClass(1);
                }
                if ((debugMethodInfo = this.findMethod(debugClassInfo3, string, 0, evaluationInfoArray)) != null && (debugMethodInfo.getAccess() & 8) == 0) {
                    arrayList.add(0, debugDataInfo);
                }
            }
            if (debugMethodInfo == null && this.isStringClass((debugClassInfo = (evaluationInfo = this.convertToEvaluationInfo(object)).getClassInfo()).getName())) {
                String string3 = evaluationInfo.getStringValue();
                debugMethodInfo = this.findMethod(debugClassInfo, string, 0, evaluationInfoArray);
                if (debugMethodInfo != null && (debugMethodInfo.getAccess() & 8) == 0) {
                    arrayList.add(0, string3);
                }
            }
            if (debugMethodInfo != null) {
                DebugDataInfo debugDataInfo3 = debugMethodInfo.invoke(arrayList);
                return debugDataInfo3;
            }
            throw new Exception("Unable to evaluate method invocation");
        }
        return this.simulateMethodInvocation(object, string, list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object simulateMethodInvocation(Object object, String string, List list) throws Exception {
        String string2;
        EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
        if (string.equals("equals") && list.size() == 1) {
            EvaluationInfo evaluationInfo2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
            try {
                long l = this.getComparableId(evaluationInfo);
                long l2 = this.getComparableId(evaluationInfo2);
                if (l == l2) {
                    return new EvaluationInfo(true, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isStringClass(string2 = evaluationInfo.getClassInfo().getName())) {
            boolean bl = false;
            boolean bl2 = true;
            int n = 2;
            int n2 = 3;
            int n3 = 4;
            int n4 = 5;
            int n5 = 6;
            int n6 = 7;
            int n7 = 8;
            int n8 = 9;
            int n9 = 10;
            int n10 = 11;
            int n11 = 12;
            int n12 = 13;
            int n13 = 14;
            int n14 = 15;
            int n15 = 16;
            int n16 = 17;
            int n17 = 18;
            int n18 = 19;
            int n19 = 20;
            int n20 = 21;
            int n21 = -1;
            if (string.equals("charAt")) {
                n21 = 0;
            } else if (string.equals("compareTo")) {
                n21 = 1;
            } else if (string.equals("compareToIgnoreCase")) {
                n21 = 2;
            } else if (string.equals("concat")) {
                n21 = 3;
            } else if (string.equals("endsWith")) {
                n21 = 4;
            } else if (string.equals("equals")) {
                n21 = 5;
            } else if (string.equals("equalsIgnoreCase")) {
                n21 = 6;
            } else if (string.equals("indexOf")) {
                n21 = 7;
            } else if (string.equals("intern")) {
                n21 = 8;
            } else if (string.equals("lastIndexOf")) {
                n21 = 9;
            } else if (string.equals("length")) {
                n21 = 10;
            } else if (string.equals("matches")) {
                n21 = 11;
            } else if (string.equals("regionMatches")) {
                n21 = 12;
            } else if (string.equals("replace")) {
                n21 = 13;
            } else if (string.equals("replaceAll")) {
                n21 = 14;
            } else if (string.equals("replaceFirst")) {
                n21 = 15;
            } else if (string.equals("startsWith")) {
                n21 = 16;
            } else if (string.equals("substring")) {
                n21 = 17;
            } else if (string.equals("toLowerCase")) {
                n21 = 18;
            } else if (string.equals("toString")) {
                n21 = 19;
            } else if (string.equals("toUpperCase")) {
                n21 = 20;
            } else if (string.equals("trim")) {
                n21 = 21;
            }
            if (n21 == -1) throw new Exception("Unable to simulate method invocation");
            String string3 = evaluationInfo.getStringValue();
            if (string3 == null) throw new Exception("Unable to simulate method invocation");
            switch (n21) {
                case 0: {
                    if (list.size() != 1) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo evaluationInfo3 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                    if (!evaluationInfo3.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int n22 = evaluationInfo3.getIntValue();
                    char c = string3.charAt(n22);
                    return new EvaluationInfo(c, this.findClass(PRIMITIVE_TYPE_CHAR));
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    if (list.size() != 1) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo evaluationInfo4 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                    if (!this.isStringClass(evaluationInfo4.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String string4 = evaluationInfo4.getStringValue();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    int n23 = 0;
                    boolean bl5 = false;
                    String string5 = null;
                    boolean bl6 = false;
                    if (n21 == 5) {
                        bl3 = string3.equals(string4);
                        bl4 = true;
                    } else if (n21 == 6) {
                        bl3 = string3.equalsIgnoreCase(string4);
                        bl4 = true;
                    } else if (n21 == 1) {
                        n23 = string3.compareTo(string4);
                        bl5 = true;
                    } else if (n21 == 2) {
                        n23 = string3.compareToIgnoreCase(string4);
                        bl5 = true;
                    } else if (n21 == 4) {
                        bl3 = string3.endsWith(string4);
                        bl4 = true;
                    } else if (n21 == 11) {
                        bl3 = string3.matches(string4);
                        bl4 = true;
                    } else if (n21 == 3) {
                        string5 = string3.concat(string4);
                        bl6 = true;
                    }
                    if (bl4) {
                        return new EvaluationInfo(bl3, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                    }
                    if (bl5) {
                        return new EvaluationInfo(n23, this.findClass(PRIMITIVE_TYPE_INT));
                    }
                    if (!bl6) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo('\"' + string5 + '\"', this.findStringClass());
                }
                case 16: {
                    if (list.size() == 1) {
                        EvaluationInfo evaluationInfo5 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                        if (!this.isStringClass(evaluationInfo5.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                        String string6 = evaluationInfo5.getStringValue();
                        boolean bl7 = string3.startsWith(string6);
                        return new EvaluationInfo(bl7, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                    }
                    if (list.size() != 2) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo evaluationInfo6 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                    if (!this.isStringClass(evaluationInfo6.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String string7 = evaluationInfo6.getStringValue();
                    EvaluationInfo evaluationInfo7 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(1));
                    if (!evaluationInfo7.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int n24 = evaluationInfo7.getIntValue();
                    boolean bl8 = string3.startsWith(string7, n24);
                    return new EvaluationInfo(bl8, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
                case 8: 
                case 10: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    if (list.size() != 0) throw new Exception("Unable to simulate method invocation");
                    int n25 = 0;
                    boolean bl9 = false;
                    String string8 = null;
                    boolean bl10 = false;
                    if (n21 == 10) {
                        n25 = string3.length();
                        bl9 = true;
                    } else if (n21 == 8) {
                        string8 = string3.intern();
                        bl10 = true;
                    } else if (n21 == 18) {
                        string8 = string3.toLowerCase();
                        bl10 = true;
                    } else if (n21 == 19) {
                        string8 = string3.toString();
                        bl10 = true;
                    } else if (n21 == 20) {
                        string8 = string3.toUpperCase();
                        bl10 = true;
                    } else if (n21 == 21) {
                        string8 = string3.trim();
                        bl10 = true;
                    }
                    if (bl9) {
                        return new EvaluationInfo(n25, this.findClass(PRIMITIVE_TYPE_INT));
                    }
                    if (!bl10) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo('\"' + string8 + '\"', this.findStringClass());
                }
                case 7: 
                case 9: {
                    EvaluationInfo evaluationInfo8;
                    int n26 = 0;
                    boolean bl11 = false;
                    if (list.size() == 1) {
                        EvaluationInfo evaluationInfo9 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                        String string9 = evaluationInfo9.getClassInfo().getName();
                        if (string9.equals(PRIMITIVE_TYPE_INT)) {
                            int n27 = evaluationInfo9.getIntValue();
                            if (n21 == 7) {
                                n26 = string3.indexOf(n27);
                                bl11 = true;
                            } else if (n21 == 9) {
                                n26 = string3.lastIndexOf(n27);
                                bl11 = true;
                            }
                        } else if (this.isStringClass(string9)) {
                            String string10 = evaluationInfo9.getStringValue();
                            if (n21 == 7) {
                                n26 = string3.indexOf(string10);
                                bl11 = true;
                            } else if (n21 == 9) {
                                n26 = string3.lastIndexOf(string10);
                                bl11 = true;
                            }
                        }
                    } else if (list.size() == 2 && (evaluationInfo8 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(1))).getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                        int n28 = evaluationInfo8.getIntValue();
                        EvaluationInfo evaluationInfo10 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                        String string11 = evaluationInfo10.getClassInfo().getName();
                        if (string11.equals(PRIMITIVE_TYPE_INT)) {
                            int n29 = evaluationInfo10.getIntValue();
                            if (n21 == 7) {
                                n26 = string3.indexOf(n29, n28);
                                bl11 = true;
                            } else if (n21 == 9) {
                                n26 = string3.lastIndexOf(n29, n28);
                                bl11 = true;
                            }
                        } else if (this.isStringClass(string11)) {
                            String string12 = evaluationInfo10.getStringValue();
                            if (n21 == 7) {
                                n26 = string3.indexOf(string12, n28);
                                bl11 = true;
                            } else if (n21 == 9) {
                                n26 = string3.lastIndexOf(string12, n28);
                                bl11 = true;
                            }
                        }
                    }
                    if (!bl11) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo(n26, this.findClass(PRIMITIVE_TYPE_INT));
                }
                case 12: {
                    EvaluationInfo evaluationInfo11;
                    boolean bl12 = false;
                    boolean bl13 = false;
                    if (list.size() == 5) {
                        EvaluationInfo evaluationInfo12 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                        if (evaluationInfo12.getClassInfo().getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
                            boolean bl14 = evaluationInfo12.getBooleanValue();
                            EvaluationInfo evaluationInfo13 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(1));
                            if (evaluationInfo13.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                int n30 = evaluationInfo13.getIntValue();
                                EvaluationInfo evaluationInfo14 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(2));
                                if (this.isStringClass(evaluationInfo14.getClassInfo())) {
                                    String string13 = evaluationInfo14.getStringValue();
                                    EvaluationInfo evaluationInfo15 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(3));
                                    if (evaluationInfo15.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                        int n31 = evaluationInfo15.getIntValue();
                                        EvaluationInfo evaluationInfo16 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(4));
                                        if (evaluationInfo16.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                            int n32 = evaluationInfo16.getIntValue();
                                            bl12 = string3.regionMatches(bl14, n30, string13, n31, n32);
                                            bl13 = true;
                                        }
                                    }
                                }
                            }
                        }
                    } else if (list.size() == 4 && (evaluationInfo11 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0))).getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                        int n33 = evaluationInfo11.getIntValue();
                        EvaluationInfo evaluationInfo17 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(1));
                        if (this.isStringClass(evaluationInfo17.getClassInfo())) {
                            String string14 = evaluationInfo17.getStringValue();
                            EvaluationInfo evaluationInfo18 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(2));
                            if (evaluationInfo18.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                int n34 = evaluationInfo18.getIntValue();
                                EvaluationInfo evaluationInfo19 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(3));
                                if (evaluationInfo19.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                    int n35 = evaluationInfo19.getIntValue();
                                    bl12 = string3.regionMatches(n33, string14, n34, n35);
                                    bl13 = true;
                                }
                            }
                        }
                    }
                    if (!bl13) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo(bl12, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
                case 13: {
                    if (list.size() != 2) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo evaluationInfo20 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                    if (!evaluationInfo20.getClassInfo().getName().equals(PRIMITIVE_TYPE_CHAR)) throw new Exception("Unable to simulate method invocation");
                    char c = evaluationInfo20.getCharValue();
                    EvaluationInfo evaluationInfo21 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(1));
                    if (!evaluationInfo21.getClassInfo().getName().equals(PRIMITIVE_TYPE_CHAR)) throw new Exception("Unable to simulate method invocation");
                    char c2 = evaluationInfo21.getCharValue();
                    String string15 = string3.replace(c, c2);
                    return new EvaluationInfo('\"' + string15 + '\"', this.findStringClass());
                }
                case 14: 
                case 15: {
                    if (list.size() != 2) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo evaluationInfo22 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                    if (!this.isStringClass(evaluationInfo22.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String string16 = evaluationInfo22.getStringValue();
                    EvaluationInfo evaluationInfo23 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(1));
                    if (!this.isStringClass(evaluationInfo23.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String string17 = evaluationInfo23.getStringValue();
                    String string18 = null;
                    boolean bl15 = false;
                    if (n21 == 14) {
                        string18 = string3.replaceAll(string16, string17);
                        bl15 = true;
                    } else if (n21 == 15) {
                        string18 = string3.replaceFirst(string16, string17);
                        bl15 = true;
                    }
                    if (!bl15) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo('\"' + string18 + '\"', this.findStringClass());
                }
                case 17: {
                    if (list.size() == 1) {
                        EvaluationInfo evaluationInfo24 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                        if (!evaluationInfo24.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                        int n36 = evaluationInfo24.getIntValue();
                        String string19 = string3.substring(n36);
                        return new EvaluationInfo('\"' + string19 + '\"', this.findStringClass());
                    }
                    if (list.size() != 2) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo evaluationInfo25 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
                    if (!evaluationInfo25.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int n37 = evaluationInfo25.getIntValue();
                    EvaluationInfo evaluationInfo26 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(1));
                    if (!evaluationInfo26.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int n38 = evaluationInfo26.getIntValue();
                    String string20 = string3.substring(n37, n38);
                    return new EvaluationInfo('\"' + string20 + '\"', this.findStringClass());
                }
            }
            throw new Exception("Unable to simulate method invocation");
        } else {
            if (!(string2.equals("java.lang.Boolean") || string2.equals("java.lang.Byte") || string2.equals("java.lang.Character") || string2.equals("java.lang.Double") || string2.equals("java.lang.Float") || string2.equals("java.lang.Integer") || string2.equals("java.lang.Long") || string2.equals("java.lang.Short"))) {
                if (!string2.startsWith("$Oracle.Builtin.")) throw new Exception("Unable to simulate method invocation");
            }
            if (!string.equals("equals")) throw new Exception("Unable to simulate method invocation");
            if (list.size() != 1) throw new Exception("Unable to simulate method invocation");
            EvaluationInfo evaluationInfo27 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)list.get(0));
            boolean bl = false;
            if (!evaluationInfo27.getClassInfo().getName().equals(string2)) throw new Exception("Unable to simulate method invocation");
            DebugDataInfo debugDataInfo = evaluationInfo.getDataInfo();
            DebugDataInfo debugDataInfo2 = evaluationInfo27.getDataInfo();
            if (!(debugDataInfo instanceof DebugDataObjectInfo)) return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            if (!(debugDataInfo2 instanceof DebugDataObjectInfo)) return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo;
            DebugDataObjectInfo debugDataObjectInfo2 = (DebugDataObjectInfo)debugDataInfo2;
            if (debugDataObjectInfo.isNull()) return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            String string21 = DebugShared.makeCourtesyValue(debugDataObjectInfo);
            String string22 = null;
            if (!debugDataObjectInfo2.isNull()) {
                string22 = DebugShared.makeCourtesyValue(debugDataObjectInfo2);
            }
            bl = string21.equals(string22);
            return new EvaluationInfo(bl, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
        }
    }

    private Object evaluateQuestion(SourceExpression sourceExpression) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        DebugClassInfo debugClassInfo = evaluationInfo.getClassInfo();
        if (debugClassInfo.getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
            boolean bl = evaluationInfo.getBooleanValue();
            if (bl) {
                return this.evaluateSourceExpression(sourceExpression.getSecondOperand());
            }
            return this.evaluateSourceExpression(sourceExpression.getThirdOperand());
        }
        throw new Exception("Unable to evaluate question-colon operator");
    }

    private String evaluateSimpleName(SourceExpression sourceExpression) {
        return ((SourceHasName)sourceExpression).getName();
    }

    private Object evaluateType(SourceExpression sourceExpression) throws Exception {
        String string = ((SourceHasType)sourceExpression).getSourceType().getName();
        DebugClassInfo debugClassInfo = this.findClass(string);
        if (debugClassInfo != null) {
            return debugClassInfo;
        }
        throw new Exception("Unable to evaluate type");
    }

    private Object evaluateTypecast(SourceExpression sourceExpression) throws Exception {
        block6: {
            DebugClassInfo debugClassInfo;
            Object object;
            DebugClassInfo debugClassInfo2;
            String string;
            block7: {
                string = ((SourceHasType)sourceExpression.getFirstOperand()).getSourceType().getName();
                debugClassInfo2 = this.findClass(string);
                if (debugClassInfo2 == null) break block6;
                string = debugClassInfo2.getName();
                boolean bl = debugClassInfo2.isPrimitive();
                object = this.evaluateSourceExpression(sourceExpression.getSecondOperand());
                EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
                debugClassInfo = evaluationInfo.getClassInfo();
                if (debugClassInfo.isPrimitive() != bl) {
                    throw new Exception("Unable to evaluate typecast");
                }
                if (bl) {
                    String string2 = debugClassInfo.getName();
                    return this.performPrimitiveTypecast(object, evaluationInfo, string2, string);
                }
                if (!debugClassInfo2.isInterface()) break block7;
                DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces(-1);
                int n = debugClassInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = debugClassInfoArray[n2].getName();
                    if (string3.equals(string)) {
                        return object;
                    }
                    ++n2;
                }
                break block6;
            }
            if (!debugClassInfo2.isObject() && !debugClassInfo2.isArray()) break block6;
            DebugClassInfo debugClassInfo3 = debugClassInfo;
            while (debugClassInfo3 != null) {
                String string4 = debugClassInfo3.getName();
                if (string4.equals(string)) {
                    return object;
                }
                debugClassInfo3 = debugClassInfo3.getSuperClass(1);
            }
        }
        throw new Exception("Unable to evaluate typecast");
    }

    private Object evaluateUnary(SourceExpression sourceExpression) throws Exception {
        int n = sourceExpression.getOperatorCode();
        switch (n) {
            case 41: {
                return this.evaluateLogicalPrefixOperator(sourceExpression, n);
            }
            case 9: 
            case 37: 
            case 44: 
            case 47: 
            case 48: {
                return this.evaluateArithmeticPrefixOperator(sourceExpression, n);
            }
            case 45: 
            case 46: {
                return this.evaluateArithmeticPostfixOperator(sourceExpression);
            }
            case 14: {
                return this.evaluateClassLiteralOperators(sourceExpression);
            }
            case 49: {
                break;
            }
        }
        throw new Exception("Unable to evaluate unary operator");
    }

    private EvaluationInfo evaluateLogicalPrefixOperator(SourceExpression sourceExpression, int n) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        DebugClassInfo debugClassInfo = evaluationInfo.getClassInfo();
        if (debugClassInfo.getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
            boolean bl = evaluationInfo.getBooleanValue();
            boolean bl2 = false;
            switch (n) {
                case 41: {
                    bl2 = bl ^ true;
                }
            }
            return new EvaluationInfo(bl2, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
        }
        throw new Exception("Unable to evaluate logical prefix operator");
    }

    private EvaluationInfo evaluateArithmeticPrefixOperator(SourceExpression sourceExpression, int n) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        char c = this.numericPromotion(evaluationInfo);
        switch (c) {
            case 'I': {
                int n2 = evaluationInfo.getIntValue();
                int n3 = 0;
                switch (n) {
                    case 9: {
                        n3 = ~n2;
                        break;
                    }
                    case 44: {
                        n3 = n2;
                        break;
                    }
                    case 37: {
                        n3 = -n2;
                        break;
                    }
                    case 48: {
                        n3 = ++n2;
                        break;
                    }
                    case 47: {
                        n3 = --n2;
                    }
                }
                return new EvaluationInfo(n3, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long l = evaluationInfo.getLongValue();
                long l2 = 0L;
                switch (n) {
                    case 9: {
                        l2 = l ^ (long)-1;
                        break;
                    }
                    case 44: {
                        l2 = l;
                        break;
                    }
                    case 37: {
                        l2 = -l;
                        break;
                    }
                    case 48: {
                        l2 = ++l;
                        break;
                    }
                    case 47: {
                        l2 = --l;
                    }
                }
                return new EvaluationInfo(l2, this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 'F': {
                float f = evaluationInfo.getFloatValue();
                float f2 = 0.0f;
                switch (n) {
                    case 9: {
                        throw new Exception("Unable to evaluate arithmetic prefix operator");
                    }
                    case 44: {
                        f2 = f;
                        break;
                    }
                    case 37: {
                        f2 = -f;
                        break;
                    }
                    case 48: {
                        f2 = f += 1.0f;
                        break;
                    }
                    case 47: {
                        f2 = f -= 1.0f;
                    }
                }
                return new EvaluationInfo(f2, this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 'D': {
                double d = evaluationInfo.getDoubleValue();
                double d2 = 0.0;
                switch (n) {
                    case 9: {
                        throw new Exception("Unable to evaluate arithmetic prefix operator");
                    }
                    case 44: {
                        d2 = d;
                        break;
                    }
                    case 37: {
                        d2 = -d;
                        break;
                    }
                    case 48: {
                        d2 = d + 1.0;
                        break;
                    }
                    case 47: {
                        d2 = d - 1.0;
                    }
                }
                return new EvaluationInfo(d2, this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
        }
        throw new Exception("Unable to evaluate arithmetic prefix operator");
    }

    private EvaluationInfo evaluateArithmeticPostfixOperator(SourceExpression sourceExpression) throws Exception {
        EvaluationInfo evaluationInfo = this.evaluateSourceExpression_convertToEvaluationInfo(sourceExpression.getFirstOperand());
        char c = this.numericPromotion(evaluationInfo);
        switch (c) {
            case 'I': {
                int n = evaluationInfo.getIntValue();
                return new EvaluationInfo(n, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long l = evaluationInfo.getLongValue();
                return new EvaluationInfo(l, this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 'F': {
                float f = evaluationInfo.getFloatValue();
                return new EvaluationInfo(f, this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 'D': {
                double d = evaluationInfo.getDoubleValue();
                return new EvaluationInfo(d, this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
        }
        throw new Exception("Unable to evaluate postfix operator");
    }

    private Object evaluateClassLiteralOperators(SourceExpression sourceExpression) throws Exception {
        String string = ((SourceHasType)sourceExpression.getFirstOperand()).getSourceType().getName();
        DebugClassInfo debugClassInfo = this.findClass(string);
        if (debugClassInfo != null) {
            return debugClassInfo.getClassObject();
        }
        throw new Exception("Unable to class literal operator");
    }

    private Object evaluateWrapper(SourceExpression sourceExpression) throws Exception {
        return this.evaluateSourceExpression(sourceExpression.getFirstOperand());
    }

    private char comparisonPromotion(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2) throws Exception {
        DebugClassInfo debugClassInfo = evaluationInfo.getClassInfo();
        DebugClassInfo debugClassInfo2 = evaluationInfo2.getClassInfo();
        if (debugClassInfo.isObject() || debugClassInfo.isInterface() || debugClassInfo.isArray()) {
            if (debugClassInfo2.isObject() || debugClassInfo2.isInterface() || debugClassInfo2.isArray()) {
                return 'L';
            }
            throw new Exception("Unable to evaluate comparison operator");
        }
        if (debugClassInfo2.isObject() || debugClassInfo2.isInterface() || debugClassInfo2.isArray()) {
            throw new Exception("Unable to evaluate comparison operator");
        }
        String string = debugClassInfo.getName();
        String string2 = debugClassInfo2.getName();
        if (string.equals(PRIMITIVE_TYPE_BOOLEAN)) {
            if (string2.equals(PRIMITIVE_TYPE_BOOLEAN)) {
                return 'Z';
            }
            throw new Exception("Unable to evaluate comparison operator");
        }
        if (string2.equals(PRIMITIVE_TYPE_BOOLEAN)) {
            throw new Exception("Unable to evaluate comparison operator");
        }
        return this.numericPromotion(evaluationInfo, string, evaluationInfo2, string2);
    }

    private char numericPromotion(EvaluationInfo evaluationInfo) throws Exception {
        DebugClassInfo debugClassInfo;
        String string = "";
        if (evaluationInfo != null && (debugClassInfo = evaluationInfo.getClassInfo()) != null) {
            string = debugClassInfo.getName();
        }
        return this.numericPromotion(evaluationInfo, string);
    }

    private char numericPromotion(EvaluationInfo evaluationInfo, String string) throws Exception {
        if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
            return 'D';
        }
        if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
            return 'F';
        }
        if (string.equals(PRIMITIVE_TYPE_LONG)) {
            return 'J';
        }
        EvaluationInfo evaluationInfo2 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo, evaluationInfo, string, PRIMITIVE_TYPE_INT);
        if (evaluationInfo2 != evaluationInfo) {
            evaluationInfo.copyFrom(evaluationInfo2);
        }
        return 'I';
    }

    private char numericPromotion(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2) throws Exception {
        DebugClassInfo debugClassInfo;
        DebugClassInfo debugClassInfo2;
        String string = "";
        String string2 = "";
        if (evaluationInfo != null && (debugClassInfo2 = evaluationInfo.getClassInfo()) != null) {
            string = debugClassInfo2.getName();
        }
        if (evaluationInfo2 != null && (debugClassInfo = evaluationInfo2.getClassInfo()) != null) {
            string2 = debugClassInfo.getName();
        }
        return this.numericPromotion(evaluationInfo, string, evaluationInfo2, string2);
    }

    private char numericPromotion(EvaluationInfo evaluationInfo, String string, EvaluationInfo evaluationInfo2, String string2) throws Exception {
        EvaluationInfo evaluationInfo3;
        if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
            EvaluationInfo evaluationInfo4 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo2, evaluationInfo2, string2, PRIMITIVE_TYPE_DOUBLE);
            if (evaluationInfo4 != evaluationInfo2) {
                evaluationInfo2.copyFrom(evaluationInfo4);
            }
            return 'D';
        }
        if (string2.equals(PRIMITIVE_TYPE_DOUBLE)) {
            EvaluationInfo evaluationInfo5 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo, evaluationInfo, string, PRIMITIVE_TYPE_DOUBLE);
            if (evaluationInfo5 != evaluationInfo) {
                evaluationInfo.copyFrom(evaluationInfo5);
            }
            return 'D';
        }
        if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
            EvaluationInfo evaluationInfo6 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo2, evaluationInfo2, string2, PRIMITIVE_TYPE_FLOAT);
            if (evaluationInfo6 != evaluationInfo2) {
                evaluationInfo2.copyFrom(evaluationInfo6);
            }
            return 'F';
        }
        if (string2.equals(PRIMITIVE_TYPE_FLOAT)) {
            EvaluationInfo evaluationInfo7 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo, evaluationInfo, string, PRIMITIVE_TYPE_FLOAT);
            if (evaluationInfo7 != evaluationInfo) {
                evaluationInfo.copyFrom(evaluationInfo7);
            }
            return 'F';
        }
        if (string.equals(PRIMITIVE_TYPE_LONG)) {
            EvaluationInfo evaluationInfo8 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo2, evaluationInfo2, string2, PRIMITIVE_TYPE_LONG);
            if (evaluationInfo8 != evaluationInfo2) {
                evaluationInfo2.copyFrom(evaluationInfo8);
            }
            return 'J';
        }
        if (string2.equals(PRIMITIVE_TYPE_LONG)) {
            EvaluationInfo evaluationInfo9 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo, evaluationInfo, string, PRIMITIVE_TYPE_LONG);
            if (evaluationInfo9 != evaluationInfo) {
                evaluationInfo.copyFrom(evaluationInfo9);
            }
            return 'J';
        }
        EvaluationInfo evaluationInfo10 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo2, evaluationInfo2, string2, PRIMITIVE_TYPE_INT);
        if (evaluationInfo10 != evaluationInfo2) {
            evaluationInfo2.copyFrom(evaluationInfo10);
        }
        if ((evaluationInfo3 = (EvaluationInfo)this.performPrimitiveTypecast(evaluationInfo, evaluationInfo, string, PRIMITIVE_TYPE_INT)) != evaluationInfo) {
            evaluationInfo.copyFrom(evaluationInfo3);
        }
        return 'I';
    }

    private Object performPrimitiveTypecast(Object object, EvaluationInfo evaluationInfo, String string, String string2) throws Exception {
        if (string.equals(string2)) {
            return object;
        }
        if (string2.equals(PRIMITIVE_TYPE_BOOLEAN)) {
            throw new Exception("Unable to evaluate typecast");
        }
        if (string2.equals(PRIMITIVE_TYPE_BYTE)) {
            byte by = 0;
            if (string.equals(PRIMITIVE_TYPE_CHAR)) {
                char c = evaluationInfo.getCharValue();
                by = (byte)c;
            } else if (string.equals(PRIMITIVE_TYPE_SHORT)) {
                short s = evaluationInfo.getShortValue();
                by = (byte)s;
            } else if (string.equals(PRIMITIVE_TYPE_INT)) {
                int n = evaluationInfo.getIntValue();
                by = (byte)n;
            } else if (string.equals(PRIMITIVE_TYPE_LONG)) {
                long l = evaluationInfo.getLongValue();
                by = (byte)l;
            } else if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
                float f = evaluationInfo.getFloatValue();
                by = (byte)f;
            } else if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double d = evaluationInfo.getDoubleValue();
                by = (byte)d;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(by, this.findClass(PRIMITIVE_TYPE_BYTE));
        }
        if (string2.equals(PRIMITIVE_TYPE_CHAR)) {
            char c = '\u0000';
            if (string.equals(PRIMITIVE_TYPE_BYTE)) {
                byte by = evaluationInfo.getByteValue();
                c = (char)by;
            } else if (string.equals(PRIMITIVE_TYPE_SHORT)) {
                short s = evaluationInfo.getShortValue();
                c = (char)s;
            } else if (string.equals(PRIMITIVE_TYPE_INT)) {
                int n = evaluationInfo.getIntValue();
                c = (char)n;
            } else if (string.equals(PRIMITIVE_TYPE_LONG)) {
                long l = evaluationInfo.getLongValue();
                c = (char)l;
            } else if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
                float f = evaluationInfo.getFloatValue();
                c = (char)f;
            } else if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double d = evaluationInfo.getDoubleValue();
                c = (char)d;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(c, this.findClass(PRIMITIVE_TYPE_CHAR));
        }
        if (string2.equals(PRIMITIVE_TYPE_SHORT)) {
            short s = 0;
            if (string.equals(PRIMITIVE_TYPE_BYTE)) {
                byte by = evaluationInfo.getByteValue();
                s = by;
            } else if (string.equals(PRIMITIVE_TYPE_CHAR)) {
                char c = evaluationInfo.getCharValue();
                s = (short)c;
            } else if (string.equals(PRIMITIVE_TYPE_INT)) {
                int n = evaluationInfo.getIntValue();
                s = (short)n;
            } else if (string.equals(PRIMITIVE_TYPE_LONG)) {
                long l = evaluationInfo.getLongValue();
                s = (short)l;
            } else if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
                float f = evaluationInfo.getFloatValue();
                s = (short)f;
            } else if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double d = evaluationInfo.getDoubleValue();
                s = (short)d;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(s, this.findClass(PRIMITIVE_TYPE_SHORT));
        }
        if (string2.equals(PRIMITIVE_TYPE_INT)) {
            int n = 0;
            if (string.equals(PRIMITIVE_TYPE_BYTE)) {
                int n2;
                n = n2 = evaluationInfo.getByteValue();
            } else if (string.equals(PRIMITIVE_TYPE_CHAR)) {
                int n3;
                n = n3 = evaluationInfo.getCharValue();
            } else if (string.equals(PRIMITIVE_TYPE_SHORT)) {
                int n4;
                n = n4 = evaluationInfo.getShortValue();
            } else if (string.equals(PRIMITIVE_TYPE_LONG)) {
                long l = evaluationInfo.getLongValue();
                n = (int)l;
            } else if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
                float f = evaluationInfo.getFloatValue();
                n = (int)f;
            } else if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double d = evaluationInfo.getDoubleValue();
                n = (int)d;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(n, this.findClass(PRIMITIVE_TYPE_INT));
        }
        if (string2.equals(PRIMITIVE_TYPE_LONG)) {
            long l = 0L;
            if (string.equals(PRIMITIVE_TYPE_BYTE)) {
                byte by = evaluationInfo.getByteValue();
                l = by;
            } else if (string.equals(PRIMITIVE_TYPE_CHAR)) {
                char c = evaluationInfo.getCharValue();
                l = c;
            } else if (string.equals(PRIMITIVE_TYPE_SHORT)) {
                short s = evaluationInfo.getShortValue();
                l = s;
            } else if (string.equals(PRIMITIVE_TYPE_INT)) {
                int n = evaluationInfo.getIntValue();
                l = n;
            } else if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
                float f = evaluationInfo.getFloatValue();
                l = (long)f;
            } else if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double d = evaluationInfo.getDoubleValue();
                l = (long)d;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(l, this.findClass(PRIMITIVE_TYPE_LONG));
        }
        if (string2.equals(PRIMITIVE_TYPE_FLOAT)) {
            float f = 0.0f;
            if (string.equals(PRIMITIVE_TYPE_BYTE)) {
                byte by = evaluationInfo.getByteValue();
                f = by;
            } else if (string.equals(PRIMITIVE_TYPE_CHAR)) {
                char c = evaluationInfo.getCharValue();
                f = c;
            } else if (string.equals(PRIMITIVE_TYPE_SHORT)) {
                short s = evaluationInfo.getShortValue();
                f = s;
            } else if (string.equals(PRIMITIVE_TYPE_INT)) {
                int n = evaluationInfo.getIntValue();
                f = n;
            } else if (string.equals(PRIMITIVE_TYPE_LONG)) {
                long l = evaluationInfo.getLongValue();
                f = l;
            } else if (string.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double d = evaluationInfo.getDoubleValue();
                f = (float)d;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(f, this.findClass(PRIMITIVE_TYPE_FLOAT));
        }
        if (string2.equals(PRIMITIVE_TYPE_DOUBLE)) {
            double d = 0.0;
            if (string.equals(PRIMITIVE_TYPE_BYTE)) {
                byte by = evaluationInfo.getByteValue();
                d = by;
            } else if (string.equals(PRIMITIVE_TYPE_CHAR)) {
                char c = evaluationInfo.getCharValue();
                d = c;
            } else if (string.equals(PRIMITIVE_TYPE_SHORT)) {
                short s = evaluationInfo.getShortValue();
                d = s;
            } else if (string.equals(PRIMITIVE_TYPE_INT)) {
                int n = evaluationInfo.getIntValue();
                d = n;
            } else if (string.equals(PRIMITIVE_TYPE_LONG)) {
                long l = evaluationInfo.getLongValue();
                d = l;
            } else if (string.equals(PRIMITIVE_TYPE_FLOAT)) {
                float f = evaluationInfo.getFloatValue();
                d = f;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(d, this.findClass(PRIMITIVE_TYPE_DOUBLE));
        }
        throw new Exception("Unable to evaluate typecast");
    }

    private boolean canPerformPrimitiveArgumentConversion(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.equals(PRIMITIVE_TYPE_BYTE) ? string2.equals(PRIMITIVE_TYPE_SHORT) || string2.equals(PRIMITIVE_TYPE_INT) || string2.equals(PRIMITIVE_TYPE_LONG) || string2.equals(PRIMITIVE_TYPE_FLOAT) || string2.equals(PRIMITIVE_TYPE_DOUBLE) : (string.equals(PRIMITIVE_TYPE_SHORT) ? string2.equals(PRIMITIVE_TYPE_INT) || string2.equals(PRIMITIVE_TYPE_LONG) || string2.equals(PRIMITIVE_TYPE_FLOAT) || string2.equals(PRIMITIVE_TYPE_DOUBLE) : (string.equals(PRIMITIVE_TYPE_CHAR) ? string2.equals(PRIMITIVE_TYPE_INT) || string2.equals(PRIMITIVE_TYPE_LONG) || string2.equals(PRIMITIVE_TYPE_FLOAT) || string2.equals(PRIMITIVE_TYPE_DOUBLE) : (string.equals(PRIMITIVE_TYPE_INT) ? string2.equals(PRIMITIVE_TYPE_LONG) || string2.equals(PRIMITIVE_TYPE_FLOAT) || string2.equals(PRIMITIVE_TYPE_DOUBLE) : (string.equals(PRIMITIVE_TYPE_LONG) ? string2.equals(PRIMITIVE_TYPE_FLOAT) || string2.equals(PRIMITIVE_TYPE_DOUBLE) : string.equals(PRIMITIVE_TYPE_FLOAT) && string2.equals(PRIMITIVE_TYPE_DOUBLE)))));
    }

    private boolean canPerformReferenceArgumentConversion(EvaluationInfo evaluationInfo, DebugClassInfo debugClassInfo, String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (debugClassInfo == null) {
            debugClassInfo = this.findClass(string);
        }
        DebugClassInfo debugClassInfo2 = this.findClass(string2);
        if (debugClassInfo != null && debugClassInfo2 != null) {
            string = debugClassInfo.getName();
            string2 = debugClassInfo2.getName();
            if (evaluationInfo != null && evaluationInfo.isNull() && (debugClassInfo2.isObject() || debugClassInfo2.isInterface() || debugClassInfo2.isArray())) {
                return true;
            }
            if (debugClassInfo.isObject()) {
                if (debugClassInfo2.isObject()) {
                    if (string2.equals("java.lang.Object")) {
                        return true;
                    }
                    DebugClassInfo debugClassInfo3 = debugClassInfo.getSuperClass(1);
                    while (debugClassInfo3 != null) {
                        if (debugClassInfo3.getName().equals(string2)) {
                            return true;
                        }
                        debugClassInfo3 = debugClassInfo3.getSuperClass(1);
                    }
                }
                if (debugClassInfo2.isInterface()) {
                    DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces(-1);
                    int n = debugClassInfoArray.length - 1;
                    while (n >= 0) {
                        if (debugClassInfoArray[n].getName().equals(string2)) {
                            return true;
                        }
                        --n;
                    }
                }
            } else if (debugClassInfo.isInterface()) {
                if (debugClassInfo2.isInterface()) {
                    DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces(-1);
                    int n = debugClassInfoArray.length - 1;
                    while (n >= 0) {
                        if (debugClassInfoArray[n].getName().equals(string2)) {
                            return true;
                        }
                        --n;
                    }
                }
                if (string2.equals("java.lang.Object")) {
                    return true;
                }
            } else if (debugClassInfo.isArray()) {
                String string3;
                String string4;
                if (string2.equals("java.lang.Object")) {
                    return true;
                }
                if (string2.equals("java.lang.Cloneable")) {
                    return true;
                }
                if (debugClassInfo2.isArray() && string.endsWith("[]") && string2.endsWith("[]") && this.canPerformReferenceArgumentConversion(null, null, string4 = string.substring(0, string.length() - 2), string3 = string2.substring(0, string2.length() - 2))) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canPerformArgumentConversion(EvaluationInfo evaluationInfo, DebugClassInfo debugClassInfo, String string, String string2) {
        return JavaEvaluator.isPrimitiveType(string2) ? this.canPerformPrimitiveArgumentConversion(string, string2) : this.canPerformReferenceArgumentConversion(evaluationInfo, debugClassInfo, string, string2);
    }

    private boolean isMethodMoreSpecific(DebugClassInfo debugClassInfo, List list, DebugClassInfo debugClassInfo2, List list2) {
        if (this.canPerformArgumentConversion(null, debugClassInfo, debugClassInfo.getName(), debugClassInfo2.getName())) {
            int n = list.size();
            if (list2.size() == n) {
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    String string2 = (String)list.get(n2);
                    if (!this.canPerformArgumentConversion(null, null, string2, string = (String)list2.get(n2))) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    private DebugMethodInfo findMethod(DebugClassInfo debugClassInfo, String string, int n, EvaluationInfo[] evaluationInfoArray) {
        DebugMethodInfo debugMethodInfo = null;
        DebugClassInfo debugClassInfo2 = null;
        ArrayList<String> arrayList = null;
        boolean bl = false;
        int n2 = evaluationInfoArray.length;
        while (debugClassInfo != null) {
            DebugMethodInfo[] debugMethodInfoArray = debugClassInfo.getMethods();
            int n3 = debugMethodInfoArray.length - 1;
            while (n3 >= 0) {
                DebugMethodInfo debugMethodInfo2 = debugMethodInfoArray[n3];
                if ((n == 0 || (debugMethodInfo2.getAccess() & n) != 0) && string.equals(debugMethodInfo2.getNameWithoutClassOrSignature())) {
                    String string2 = debugMethodInfo2.getParameterSignature();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    if (string2.startsWith("(") && string2.endsWith(")")) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList2.add(stringTokenizer.nextToken().trim());
                    }
                    if (arrayList2.size() == n2) {
                        boolean bl2 = true;
                        boolean bl3 = true;
                        int n4 = 0;
                        while (n4 < n2) {
                            String string3;
                            DebugClassInfo debugClassInfo3 = evaluationInfoArray[n4].getClassInfo();
                            String string4 = debugClassInfo3.getName();
                            if (!string4.equals(string3 = (String)arrayList2.get(n4))) {
                                bl2 = false;
                                if (!this.canPerformArgumentConversion(evaluationInfoArray[n4], debugClassInfo3, string4, string3)) {
                                    bl3 = false;
                                    break;
                                }
                            }
                            ++n4;
                        }
                        if (bl2) {
                            return debugMethodInfo2;
                        }
                        if (bl3) {
                            if (debugMethodInfo == null) {
                                debugMethodInfo = debugMethodInfo2;
                                debugClassInfo2 = debugClassInfo;
                                arrayList = arrayList2;
                                bl = false;
                            } else if (!arrayList2.equals(arrayList)) {
                                if (this.isMethodMoreSpecific(debugClassInfo, arrayList2, debugClassInfo2, arrayList)) {
                                    debugMethodInfo = debugMethodInfo2;
                                    debugClassInfo2 = debugClassInfo;
                                    arrayList = arrayList2;
                                    bl = false;
                                } else if (!this.isMethodMoreSpecific(debugClassInfo2, arrayList, debugClassInfo, arrayList2)) {
                                    bl = true;
                                }
                            }
                        }
                    }
                }
                --n3;
            }
            debugClassInfo = debugClassInfo.getSuperClass(1);
        }
        if (!bl) {
            return debugMethodInfo;
        }
        return null;
    }

    private EvaluationInfo convertToEvaluationInfo(Object object) throws Exception {
        DebugDataInfo debugDataInfo;
        if (object instanceof EvaluationInfo) {
            return (EvaluationInfo)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.equals("null")) {
                return new EvaluationInfo("null", this.findClass("java.lang.Object"), null);
            }
            Object object2 = this.evaluateSimple(string);
            if (object2 != null) {
                object = object2;
            }
            if (object instanceof EvaluationInfo) {
                return (EvaluationInfo)object;
            }
        }
        if ((debugDataInfo = JavaEvaluator.getDataInfo(object)) != null) {
            return new EvaluationInfo(debugDataInfo.getValue(), debugDataInfo.getClassInfo(), debugDataInfo);
        }
        throw new Exception("Unable to evaluate: " + object);
    }

    protected DebugClassInfo findClass(String string) {
        DebugClassInfo debugClassInfo = super.findClass(string);
        if (debugClassInfo != null) {
            return debugClassInfo;
        }
        if (this.debugContext.vm == null && JavaEvaluator.isPrimitiveType(string)) {
            return DebugSharedPrimitives.getPrimitiveClassInfo(string);
        }
        return null;
    }

    protected DebugClassInfo findPrimitiveIntClass() {
        return this.findClass(PRIMITIVE_TYPE_INT);
    }

    private boolean isStringClass(DebugClassInfo debugClassInfo) {
        return this.isStringClass(debugClassInfo.getName());
    }

    protected boolean isStringClass(String string) {
        return string.equals("java.lang.String");
    }

    protected DebugClassInfo findStringClass() {
        return this.findClass("java.lang.String");
    }
}

