/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.FastStringBuffer;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;

final class LocalsWindow
extends DataWindow {
    private LocalsWindowSettings localsWindowSettings = LocalsWindowSettings.getInstance();
    private static IdeAction actionViewWhole;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String LOCALS_WINDOW_ID = "Debugger.LocalsWindow";
    private static Icon localsTabIcon;

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsViewWhole");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsSettings");
        localsTabIcon = null;
    }

    LocalsWindow() {
        super(LOCALS_WINDOW_ID, DbgArb.getString(630), "f1_deb_datawindow_html");
        LocalsWindow.makeActions();
        this.setDataPanel(new LocalsPanel());
        this.setControllerForActions();
    }

    public Icon getTabIcon() {
        if (localsTabIcon == null) {
            localsTabIcon = JavaIcons.getIcon(2);
        }
        return localsTabIcon;
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        LocalsWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    private static void makeActions() {
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(317), null, (Integer)DbgArb.getInteger(318), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(319), null, (Integer)DbgArb.getInteger(320), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(321), null, (Integer)DbgArb.getInteger(322), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(323), null, (Integer)DbgArb.getInteger(324), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(325), null, (Integer)DbgArb.getInteger(326), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(327), null, (Integer)DbgArb.getInteger(328), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(341), null, (Integer)DbgArb.getInteger(342), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(343), null, (Integer)DbgArb.getInteger(344), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(329), null, (Integer)DbgArb.getInteger(331), null, (int)-1, null, (boolean)false);
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(332), null, (Integer)DbgArb.getInteger(334), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(335), null, (Integer)DbgArb.getInteger(337), null, (int)-1, null, (boolean)false);
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(345), null, (Integer)DbgArb.getInteger(346), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(347, ""), null, (Integer)DbgArb.getInteger(348), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionViewWhole, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this.dataPanel);
    }

    static LocalsWindowSettings ra$localsWindowSettings(LocalsWindow localsWindow) {
        return localsWindow.localsWindowSettings;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    final class LocalsPanel
    extends DataPanel {
        LocalsPanel() {
            super(LocalsWindow.this, LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).getDataPanelSettings());
            this._actionViewWhole = LocalsWindow.ra$actionViewWhole();
            this._actionAdjustRange = LocalsWindow.ra$actionAdjustRange();
            this._actionToggleValue = LocalsWindow.ra$actionToggleValue();
            this._actionModifyValue = LocalsWindow.ra$actionModifyValue();
            this._actionWatch = LocalsWindow.ra$actionWatch();
            this._actionInspect = LocalsWindow.ra$actionInspect();
            this._actionWatchClassLoader = LocalsWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = LocalsWindow.ra$actionInspectClassLoader();
            this._actionGoto = LocalsWindow.ra$actionGoto();
            this._actionGotoDeclared = LocalsWindow.ra$actionGotoDeclared();
            this._actionGotoField = LocalsWindow.ra$actionGotoField();
            this._actionUseFilters = LocalsWindow.ra$actionUseFilters();
            this._actionObjectPreferences = LocalsWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = LocalsWindow.ra$actionCollapseAll();
            this._actionSave = LocalsWindow.ra$actionSave();
            this._VIEW_WHOLE_CMD_ID = LocalsWindow.ra$VIEW_WHOLE_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = LocalsWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = LocalsWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = LocalsWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = LocalsWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = LocalsWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = LocalsWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = LocalsWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = LocalsWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = LocalsWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = LocalsWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = LocalsWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = LocalsWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = LocalsWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = LocalsWindow.ra$SAVE_CMD_ID();
        }

        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(LocalsWindow.ra$actionSettings(), context);
            if (LocalsWindow.ra$actionSettings().isEnabled()) {
                if (LocalsWindow.ra$menuitemSettings() == null) {
                    LocalsWindow.wa$menuitemSettings(contextMenu.createMenuItem((ToggleAction)LocalsWindow.ra$actionSettings()));
                }
                contextMenu.add((Component)LocalsWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == LocalsWindow.ra$SETTINGS_CMD_ID())) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == LocalsWindow.ra$SETTINGS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == LocalsWindow.ra$SETTINGS_CMD_ID()) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(762)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        protected void addDataItems() {
            DebugLocation debugLocation;
            DebugDataObjectInfo debugDataObjectInfo;
            List list = this.getRoot();
            if (this.vm != null && this.thread != null && this.thread.equals(this.vm.getCurrentThread()) && this.frame != null && this.frame.getFrameNumber() == 0 && (debugDataObjectInfo = this.vm.getCurrentThrow()) != null) {
                String string = BaseEvaluator.getThrowExpressionPart();
                list.add(new DataPanel.DataItem(debugDataObjectInfo, string, string));
            }
            if (this.frame != null) {
                DebugStackSlotInfo[] debugStackSlotInfoArray;
                int n;
                DebugVariableInfo[] debugVariableInfoArray = this.frame.listArguments();
                int n2 = debugVariableInfoArray.length;
                DebugVariableInfo[] debugVariableInfoArray2 = this.frame.listLocals();
                int n3 = debugVariableInfoArray2.length;
                DebugFieldInfo[] debugFieldInfoArray = this.getSyntheticValues(debugVariableInfoArray);
                int n4 = debugFieldInfoArray.length;
                boolean bl = n3 > 0;
                int n5 = n2 + n3 + n4;
                if (n5 > 0) {
                    Object[] objectArray = new Object[n5];
                    if (n2 > 0) {
                        System.arraycopy(debugVariableInfoArray, 0, objectArray, 0, n2);
                    }
                    if (n3 > 0) {
                        System.arraycopy(debugVariableInfoArray2, 0, objectArray, n2, n3);
                    }
                    if (n4 > 0) {
                        System.arraycopy(debugFieldInfoArray, 0, objectArray, n2 + n3, n4);
                    }
                    if (LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).isSortVarsByName()) {
                        Arrays.sort(objectArray, new 1());
                    }
                    int n6 = 0;
                    while (n6 < n5) {
                        if (objectArray[n6] instanceof DebugFieldInfo) {
                            DebugFieldInfo debugFieldInfo = (DebugFieldInfo)objectArray[n6];
                            String string = this.getDisplayName(debugFieldInfo);
                            list.add(new DataPanel.DataItem(debugFieldInfo, string, string));
                        } else {
                            DebugVariableInfo debugVariableInfo = (DebugVariableInfo)objectArray[n6];
                            if (!LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).isHideOutOfScopeVars() || debugVariableInfo.isInScope()) {
                                if (debugVariableInfo.getName().startsWith("<")) {
                                    int n7 = 0;
                                    while (n7 < n2) {
                                        if (debugVariableInfo == debugVariableInfoArray[n7]) {
                                            String string = BaseEvaluator.getSlotExpressionPartPrefix() + n7;
                                            list.add(new DataPanel.DataItem(debugVariableInfo, string, string));
                                            break;
                                        }
                                        ++n7;
                                    }
                                } else {
                                    if (!debugVariableInfo.getName().equals("this")) {
                                        bl = true;
                                    }
                                    list.add(new DataPanel.DataItem(debugVariableInfo));
                                }
                            }
                        }
                        ++n6;
                    }
                }
                if (!bl && (n = (debugStackSlotInfoArray = this.frame.listSlots()).length) > 0) {
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < n2) {
                        n8 += debugVariableInfoArray[n9].getSlotSize();
                        ++n9;
                    }
                    int n10 = n8;
                    while (n10 < n) {
                        String string = BaseEvaluator.getSlotExpressionPartPrefix() + n10;
                        list.add(new DataPanel.DataItem(debugStackSlotInfoArray[n10], string, string));
                        ++n10;
                    }
                }
            }
            if (this.thread != null && this.frame != null && this.frame.getFrameNumber() == 0) {
                DebugDataInfo debugDataInfo;
                DebugDataInfo debugDataInfo2;
                boolean bl = false;
                DebugVariableInfo debugVariableInfo = this.thread.getReturnValue();
                if (debugVariableInfo != null && (debugDataInfo2 = debugVariableInfo.getDataInfo()) != null) {
                    String string = BaseEvaluator.getReturnExpressionPart();
                    list.add(new DataPanel.DataItem(debugVariableInfo, string, string));
                    bl = true;
                }
                if (!bl && (debugVariableInfo = this.thread.getReturnedValue()) != null && (debugDataInfo = debugVariableInfo.getDataInfo()) != null) {
                    String string = BaseEvaluator.getReturnedExpressionPart();
                    list.add(new DataPanel.DataItem(debugVariableInfo, string, string));
                }
            }
            if (this.frame != null && LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).isShowStaticFolder() && (debugLocation = this.frame.getLocation()) != null) {
                DebugClassInfo debugClassInfo = debugLocation.getClassInfo();
                String string = debugClassInfo.getName();
                if (string.startsWith("$Oracle.")) {
                    if (string.startsWith("$Oracle.PackageBody.")) {
                        DebugClassInfo debugClassInfo2 = debugClassInfo;
                        DataPanel.DataItem dataItem = new DataPanel.DataItem(debugClassInfo2);
                        list.add(dataItem);
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
                        int n = 0;
                        while (n < 4) {
                            fastStringBuffer.removeCharAt(15);
                            ++n;
                        }
                        String string2 = fastStringBuffer.toString();
                        DebugClassInfo debugClassInfo3 = this.vm.findFirstClassByName(string2);
                        DataPanel.DataItem dataItem2 = new DataPanel.DataItem(debugClassInfo3);
                        list.add(dataItem2);
                    } else if (string.startsWith("$Oracle.Package.")) {
                        DebugClassInfo debugClassInfo4 = debugClassInfo;
                        DataPanel.DataItem dataItem = new DataPanel.DataItem(debugClassInfo4);
                        list.add(dataItem);
                    }
                } else if (debugClassInfo.getLanguage() != 8) {
                    String string3;
                    DebugClassInfo debugClassInfo5;
                    int n = string.indexOf(36);
                    if (n != -1 && (debugClassInfo5 = this.vm.findFirstClassByName(string3 = string.substring(0, n))) != null) {
                        debugClassInfo = debugClassInfo5;
                    }
                    DataPanel.DataItem dataItem = new DataPanel.DataItem(debugClassInfo);
                    list.add(dataItem);
                }
            }
        }

        private String getDisplayName(Object object) {
            String string;
            if (object instanceof DebugFieldInfo) {
                string = ((DebugFieldInfo)object).getName();
                if (string.startsWith("val$")) {
                    string = string.substring(4);
                }
                if (string.startsWith("v$")) {
                    string = string.substring(2);
                }
            } else {
                string = ((DebugVariableInfo)object).getName();
            }
            return string;
        }

        private DebugFieldInfo[] getSyntheticValues(DebugVariableInfo[] debugVariableInfoArray) {
            ArrayList<DebugFieldInfo> arrayList = new ArrayList<DebugFieldInfo>();
            int n = debugVariableInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (debugVariableInfoArray[n2].getName().equals("this")) {
                    DebugDataObjectInfo debugDataObjectInfo;
                    DebugClassInfo debugClassInfo;
                    DebugDataInfo debugDataInfo = debugVariableInfoArray[n2].getDataInfo();
                    if (!(debugDataInfo instanceof DebugDataObjectInfo) || (debugClassInfo = (debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo).getClassInfo()) == null || debugClassInfo.getName().indexOf(36) == -1) break;
                    DebugFieldInfo[] debugFieldInfoArray = debugDataObjectInfo.getFields(0, false, true, false);
                    int n3 = debugFieldInfoArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n4];
                        String string = debugFieldInfo.getName();
                        if (string.startsWith("val$")) {
                            arrayList.add(debugFieldInfo);
                        } else if (string.startsWith("v$")) {
                            arrayList.add(debugFieldInfo);
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
            return arrayList.toArray(new DebugFieldInfo[arrayList.size()]);
        }

        static String mav$getDisplayName(LocalsPanel localsPanel, Object object) {
            return localsPanel.getDisplayName(object);
        }

        final class 1
        implements Comparator {
            public int compare(Object object, Object object2) {
                String string = LocalsPanel.mav$getDisplayName(LocalsPanel.this, object);
                String string2 = LocalsPanel.mav$getDisplayName(LocalsPanel.this, object2);
                return string.compareToIgnoreCase(string2);
            }
        }
    }
}

