/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.config.ClientSetting;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class LocalsWindowSettings
implements Copyable {
    public static final String KEY_SETTINGS = "LocalsWindowOptions";
    private DataPanelSettings _dataPanelSettings = new DataPanelSettings();
    private boolean _sortVarsByName;
    private boolean _hideOutOfScopeVars;
    private boolean _showStaticFolder;

    static LocalsWindowSettings getInstance() {
        return (LocalsWindowSettings)ClientSetting.findOrCreate((String)JDebugger.getExtensionID()).getData(KEY_SETTINGS);
    }

    public LocalsWindowSettings() {
        this.defaultInit();
    }

    public LocalsWindowSettings(LocalsWindowSettings localsWindowSettings) {
        if (localsWindowSettings == null) {
            this.defaultInit();
        } else {
            localsWindowSettings.copyTo(this);
        }
    }

    private void defaultInit() {
        this._sortVarsByName = false;
        this._hideOutOfScopeVars = true;
        this._showStaticFolder = true;
    }

    public Object copyTo(Object object) {
        LocalsWindowSettings localsWindowSettings = object != null ? (LocalsWindowSettings)object : new LocalsWindowSettings();
        localsWindowSettings._sortVarsByName = this._sortVarsByName;
        localsWindowSettings._hideOutOfScopeVars = this._hideOutOfScopeVars;
        localsWindowSettings._showStaticFolder = this._showStaticFolder;
        this._dataPanelSettings.copyTo((Object)localsWindowSettings._dataPanelSettings);
        return localsWindowSettings;
    }

    public DataPanelSettings getDataPanelSettings() {
        return this._dataPanelSettings;
    }

    public void setDataPanelSettings(DataPanelSettings dataPanelSettings) {
        dataPanelSettings.copyTo((Object)this._dataPanelSettings);
    }

    public boolean isSortVarsByName() {
        return this._sortVarsByName;
    }

    public void setSortVarsByName(boolean bl) {
        this._sortVarsByName = bl;
    }

    public boolean isHideOutOfScopeVars() {
        return this._hideOutOfScopeVars;
    }

    public void setHideOutOfScopeVars(boolean bl) {
        this._hideOutOfScopeVars = bl;
    }

    public boolean isShowStaticFolder() {
        return this._showStaticFolder;
    }

    public void setShowStaticFolder(boolean bl) {
        this._showStaticFolder = bl;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((LocalsWindowSettings)object);
    }

    protected final boolean equalsImpl(LocalsWindowSettings localsWindowSettings) {
        return ModelUtil.areEqual((Object)((Object)this._dataPanelSettings), (Object)((Object)localsWindowSettings._dataPanelSettings)) && this._sortVarsByName == localsWindowSettings._sortVarsByName && this._hideOutOfScopeVars == localsWindowSettings._hideOutOfScopeVars && this._showStaticFolder == localsWindowSettings._showStaticFolder;
    }
}

