/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;
import oracle.jdevimpl.runner.debug.SourceIcon;

class LocationInfo {
    private DebugStackFrameInfo savedFrame;
    private DebugLocation location;
    private DebugMethodInfo method;
    private CodeEditor codeEditor;
    private int line;
    private List<String> expressions;
    private int numberOfLines;

    LocationInfo(DebuggingProcess debuggingProcess, DebugStackFrameInfo debugStackFrameInfo) {
        this.savedFrame = debugStackFrameInfo;
        this.location = debugStackFrameInfo.getLocation();
        this.method = this.location != null ? this.location.getMethod() : null;
        SourceIcon sourceIcon = debuggingProcess.getSourceIconForIP();
        if (sourceIcon != null) {
            this.codeEditor = sourceIcon.getCodeEditor();
            this.line = sourceIcon.getLine();
        }
    }

    boolean isSameFrame(DebugStackFrameInfo debugStackFrameInfo) {
        return this.savedFrame == debugStackFrameInfo;
    }

    DebugMethodInfo getMethod() {
        return this.method;
    }

    private boolean isAtStartOfMethod() {
        if (this.location != null) {
            int n = this.location.getBytecodeOffset();
            if (this.method != null && this.method.getNameWithoutClassOrSignature().equals("<init>") ? n <= 4 : n == 0) {
                return true;
            }
        }
        return false;
    }

    List getExpressions(SmartWindowSettings smartWindowSettings, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo debugStackFrameInfo) {
        block21: {
            if (this.expressions == null || this.numberOfLines != smartWindowSettings.getNumberOfLines()) {
                this.expressions = new ArrayList<String>();
                if (this.isAtStartOfMethod()) {
                    DebugVariableInfo[] debugVariableInfoArray = debugStackFrameInfo.listArguments();
                    int n = debugVariableInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        this.expressions.add(debugVariableInfoArray[n2].getName());
                        ++n2;
                    }
                } else if (this.method != null && (this.method.getAccess() & 8) == 0) {
                    this.expressions.add("this");
                }
                if (debugVirtualMachine != null && debugVirtualMachine.getCurrentThrow() != null) {
                    this.expressions.add(BaseEvaluator.getThrowExpressionPart());
                }
                if (debugThreadInfo != null) {
                    if (debugThreadInfo.getReturnValue() != null) {
                        this.expressions.add(BaseEvaluator.getReturnExpressionPart());
                    } else if (debugThreadInfo.getReturnedValue() != null) {
                        this.expressions.add(BaseEvaluator.getReturnedExpressionPart());
                    }
                }
                this.numberOfLines = smartWindowSettings.getNumberOfLines();
                try {
                    Context context;
                    Node node;
                    if (this.codeEditor == null || this.line <= 0 || !((node = (context = this.codeEditor.getContext()).getNode()) instanceof TextNode)) break block21;
                    int n = this.codeEditor.getLineStartOffset(this.line);
                    int n3 = n + 1;
                    int n4 = this.line + this.numberOfLines - 1;
                    while (n4 >= this.line) {
                        try {
                            n3 = this.codeEditor.getLineEndOffset(n4);
                            if (n3 >= n) {
                                break;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        --n4;
                    }
                    TextNode textNode = (TextNode)node;
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    textBuffer.readLock();
                    try {
                        List<SmartDataProvider> list = JDebugger.getSmartDataProviders();
                        int n5 = list.size() - 1;
                        while (n5 >= 0) {
                            SmartDataProvider smartDataProvider = list.get(n5);
                            if (smartDataProvider.canUnderstand(node)) {
                                smartDataProvider.getExpressions((ReadTextBuffer)textBuffer, n, n3, this.expressions);
                            }
                            --n5;
                        }
                    }
                    finally {
                        textBuffer.readUnlock();
                        textNode.releaseTextBuffer();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.expressions;
    }
}

