/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Encodings;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ModifyValueDialog;

final class MemoViewDialog
extends JPanel
implements CaretListener,
ActionListener,
ItemListener {
    private DebugDataCompositeInfo dci;
    private Object memo;
    private MakeString makeString;
    private JCheckBox viewAsStringCheckbox;
    private JLabel encodingsLabel;
    private JComboBox encodingsComboBox;
    private JTextArea textArea;
    private JButton modifyButton;
    private Font font;
    private static boolean HEX_INDEXES = false;
    private static char[] hexDigits = null;
    private static char[] hexBuf = null;
    private static char[] decDigits = null;
    private static char[] decBuf = null;

    static void showMemoViewDialog(String string, String string2, String string3, DebugDataCompositeInfo debugDataCompositeInfo) {
        MemoViewDialog memoViewDialog = new MemoViewDialog(string2, string3, debugDataCompositeInfo);
        HelpSystem.getHelpSystem().registerTopic((JComponent)memoViewDialog, "f1_deb_show_wholevaluedialog_html");
        OnePageWizardDialogFactory.runDialog((Component)memoViewDialog, (Component)memoViewDialog.textArea, (String)string, (int)5);
    }

    private MemoViewDialog(String string, String string2, DebugDataCompositeInfo debugDataCompositeInfo) {
        super(new GridBagLayout());
        this.dci = debugDataCompositeInfo;
        this.makeMemo();
        this.makeString = new MakeString();
        JLabel jLabel = new JLabel(string + " " + string2);
        Container container = null;
        if (this.memo instanceof byte[] || this.memo instanceof char[] || this.memo instanceof String) {
            this.viewAsStringCheckbox = new JCheckBox();
            if (this.memo instanceof String || this.memo instanceof char[]) {
                this.viewAsStringCheckbox.setSelected(true);
            }
            ResourceUtils.resButton((AbstractButton)this.viewAsStringCheckbox, (String)DbgArb.getString(350));
            if (container == null) {
                container = new JPanel(new FlowLayout(0, 5, 5));
            }
            container.add(this.viewAsStringCheckbox);
        }
        if (this.memo instanceof byte[]) {
            this.encodingsLabel = new JLabel();
            this.encodingsComboBox = new JComboBox();
            ResourceUtils.resLabel((JLabel)this.encodingsLabel, (Component)this.encodingsComboBox, (String)DbgArb.getString(351));
            Object[] objectArray = Encodings.getEncodings();
            String string3 = Encodings.getDefaultEncoding();
            this.encodingsComboBox.setModel(new NonNullableComboBoxModel(objectArray));
            this.encodingsComboBox.setSelectedItem(string3);
            if (container == null) {
                container = new JPanel(new FlowLayout(0, 5, 5));
            }
            container.add(this.encodingsLabel);
            container.add(this.encodingsComboBox);
        }
        this.textArea = new JTextArea();
        this.font = EditorProperties.getProperties().getBaseFont();
        this.textArea.setCaret(new 2());
        this.textArea.setFont(this.font);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        if (debugDataCompositeInfo instanceof DebugDataArrayInfo) {
            this.modifyButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.modifyButton, (String)DbgArb.getString(352));
        }
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        if (container != null) {
            this.add((Component)container, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.add((Component)jScrollPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 5), 0, 0));
        if (this.modifyButton != null) {
            this.add((Component)this.modifyButton, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        }
        this.setPreferredSize(new Dimension(762, 306));
        if (this.viewAsStringCheckbox != null) {
            this.viewAsStringCheckbox.addItemListener(this);
        }
        if (this.encodingsLabel != null) {
            this.encodingsComboBox.addItemListener(this);
        }
        if (this.modifyButton != null) {
            this.textArea.addCaretListener(this);
            this.modifyButton.addActionListener(this);
        }
        this.updateTextArea();
    }

    private void makeMemo() {
        this.memo = this.dci.getWholeThing();
        if (this.memo instanceof String && this.dci instanceof DebugDataArrayInfo) {
            this.memo = ((String)this.memo).toCharArray();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateTextArea();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.modifyButton.setEnabled(this.canModify());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.modifyButton) {
            this.modify();
        }
    }

    private void updateTextArea() {
        this.makeString.makeString();
        this.textArea.setText(this.makeString.getResult());
        this.textArea.setSelectionStart(0);
        this.textArea.setSelectionEnd(0);
    }

    private boolean canModify() {
        try {
            if (this.dci instanceof DebugDataArrayInfo && this.makeString.isModifyableNow()) {
                int n = this.makeString.getArrayIndexFromStringOffsets(this.textArea.getSelectionStart(), this.textArea.getSelectionEnd());
                DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)this.dci;
                int n2 = debugDataArrayInfo.getArrayStart();
                int n3 = debugDataArrayInfo.getArrayCount();
                boolean bl = n2 <= n && (n3 == -1 || n < n2 + n3);
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void modify() {
        try {
            if (this.dci instanceof DebugDataArrayInfo && this.makeString.isModifyableNow()) {
                DebugDataInfo debugDataInfo;
                DebugArrayElementInfo[] debugArrayElementInfoArray;
                int n = this.textArea.getSelectionStart();
                int n2 = this.textArea.getSelectionEnd();
                int n3 = this.makeString.getArrayIndexFromStringOffsets(n, n2);
                DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)this.dci;
                int n4 = debugDataArrayInfo.getArrayStart();
                int n5 = debugDataArrayInfo.getArrayCount();
                if (n4 <= n3 && (n5 == -1 || n3 < n4 + n5) && (debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements(n3, 1)) != null && debugArrayElementInfoArray.length == 1 && (debugDataInfo = debugArrayElementInfoArray[0].getDataInfo()) != null && debugDataInfo.canModifyDataWithString()) {
                    DebugClassInfo debugClassInfo;
                    String string;
                    String string2;
                    DebugPinnedInfo debugPinnedInfo = debugDataArrayInfo.pinObject(new 1());
                    DebugClassInfo debugClassInfo2 = debugDataArrayInfo.getArrayElementClassInfo();
                    String string3 = DebugShared.makeCourtesyClassName(debugClassInfo2, true);
                    boolean bl = ModifyValueDialog.showModifyValueDialog(string3, string2 = "[" + n3 + "]", string = "0x" + debugDataInfo.getHexValue() + "    " + debugDataInfo.getValue(), null, debugClassInfo = debugDataInfo.getClassInfo(), debugDataInfo, true, false, false);
                    if (bl) {
                        if (this.dci != null) {
                            this.dci = debugPinnedInfo.getDataInfo();
                            this.makeMemo();
                        }
                        debugPinnedInfo.unpinObject();
                        debugPinnedInfo = null;
                        this.makeString.clear();
                        this.updateTextArea();
                        this.textArea.setSelectionStart(n);
                        this.textArea.setSelectionEnd(n2);
                        JDebugger.getInstance().dataHasBeenModified();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initHexStuff() {
        if (hexDigits == null) {
            hexDigits = new char[16];
            MemoViewDialog.hexDigits[0] = 48;
            MemoViewDialog.hexDigits[1] = 49;
            MemoViewDialog.hexDigits[2] = 50;
            MemoViewDialog.hexDigits[3] = 51;
            MemoViewDialog.hexDigits[4] = 52;
            MemoViewDialog.hexDigits[5] = 53;
            MemoViewDialog.hexDigits[6] = 54;
            MemoViewDialog.hexDigits[7] = 55;
            MemoViewDialog.hexDigits[8] = 56;
            MemoViewDialog.hexDigits[9] = 57;
            MemoViewDialog.hexDigits[10] = 65;
            MemoViewDialog.hexDigits[11] = 66;
            MemoViewDialog.hexDigits[12] = 67;
            MemoViewDialog.hexDigits[13] = 68;
            MemoViewDialog.hexDigits[14] = 69;
            MemoViewDialog.hexDigits[15] = 70;
        }
        if (hexBuf == null) {
            String string = Long.toHexString(Long.MAX_VALUE);
            hexBuf = new char[string.length()];
        }
    }

    private static void appendHex(int n, int n2, StringBuffer stringBuffer) {
        int n3 = n2;
        while (--n3 >= 0) {
            MemoViewDialog.hexBuf[n3] = hexDigits[n & 0xF];
            n >>= 4;
        }
        stringBuffer.append(hexBuf, 0, n2);
    }

    private static void appendHex(long l, int n, StringBuffer stringBuffer) {
        int n2 = n;
        while (--n2 >= 0) {
            MemoViewDialog.hexBuf[n2] = hexDigits[(int)l & 0xF];
            l >>= 4;
        }
        stringBuffer.append(hexBuf, 0, n);
    }

    private static void initDecStuff() {
        if (decDigits == null) {
            decDigits = new char[10];
            MemoViewDialog.decDigits[0] = 48;
            MemoViewDialog.decDigits[1] = 49;
            MemoViewDialog.decDigits[2] = 50;
            MemoViewDialog.decDigits[3] = 51;
            MemoViewDialog.decDigits[4] = 52;
            MemoViewDialog.decDigits[5] = 53;
            MemoViewDialog.decDigits[6] = 54;
            MemoViewDialog.decDigits[7] = 55;
            MemoViewDialog.decDigits[8] = 56;
            MemoViewDialog.decDigits[9] = 57;
        }
        if (decBuf == null) {
            String string = Long.toString(Long.MAX_VALUE);
            decBuf = new char[string.length()];
        }
    }

    private static void appendDec(int n, int n2, StringBuffer stringBuffer) {
        int n3 = n2;
        while (--n3 >= 0) {
            if (n > 0) {
                MemoViewDialog.decBuf[n3] = decDigits[n % 10];
                n /= 10;
                continue;
            }
            MemoViewDialog.decBuf[n3] = 48;
        }
        stringBuffer.append(decBuf, 0, n2);
    }

    private static void appendDec(long l, int n, StringBuffer stringBuffer) {
        int n2 = n;
        while (--n2 >= 0) {
            if (l > 0L) {
                MemoViewDialog.decBuf[n2] = decDigits[(int)l % 10];
                l /= (long)10;
                continue;
            }
            MemoViewDialog.decBuf[n2] = 48;
        }
        stringBuffer.append(decBuf, 0, n);
    }

    private static void appendIndexRange(int n, int n2, int n3, int n4, StringBuffer stringBuffer) {
        stringBuffer.append('[');
        int n5 = n;
        if (HEX_INDEXES) {
            MemoViewDialog.appendHex(n5, n4, stringBuffer);
        } else {
            MemoViewDialog.appendDec(n5, n4, stringBuffer);
        }
        stringBuffer.append("..");
        int n6 = n + n2 - 1;
        if (n6 > n3 - 1) {
            n6 = n3 - 1;
        }
        if (HEX_INDEXES) {
            MemoViewDialog.appendHex(n6, n4, stringBuffer);
        } else {
            MemoViewDialog.appendDec(n6, n4, stringBuffer);
        }
        stringBuffer.append("] ");
    }

    static void wa$dci(MemoViewDialog memoViewDialog, DebugDataCompositeInfo debugDataCompositeInfo) {
        memoViewDialog.dci = debugDataCompositeInfo;
    }

    static void maS$appendIndexRange(int n, int n2, int n3, int n4, StringBuffer stringBuffer) {
        MemoViewDialog.appendIndexRange(n, n2, n3, n4, stringBuffer);
    }

    static void maS$appendHex(long l, int n, StringBuffer stringBuffer) {
        MemoViewDialog.appendHex(l, n, stringBuffer);
    }

    static void maS$appendHex(int n, int n2, StringBuffer stringBuffer) {
        MemoViewDialog.appendHex(n, n2, stringBuffer);
    }

    static Font ra$font(MemoViewDialog memoViewDialog) {
        return memoViewDialog.font;
    }

    static boolean ra$HEX_INDEXES() {
        return HEX_INDEXES;
    }

    static Object ra$memo(MemoViewDialog memoViewDialog) {
        return memoViewDialog.memo;
    }

    static JCheckBox ra$viewAsStringCheckbox(MemoViewDialog memoViewDialog) {
        return memoViewDialog.viewAsStringCheckbox;
    }

    static JComboBox ra$encodingsComboBox(MemoViewDialog memoViewDialog) {
        return memoViewDialog.encodingsComboBox;
    }

    static void maS$initHexStuff() {
        MemoViewDialog.initHexStuff();
    }

    static void maS$initDecStuff() {
        MemoViewDialog.initDecStuff();
    }

    final class 2
    extends DefaultCaret {
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    final class 1
    implements DebugPinListener {
        public void pinnedObjectDiscarded(DebugVirtualMachine debugVirtualMachine, DebugPinnedInfo debugPinnedInfo) {
            MemoViewDialog.wa$dci(MemoViewDialog.this, null);
        }
    }

    class MakeString {
        private boolean viewAsString;
        private String encoding;
        private int count;
        private int hexLength;
        private int itemsPerRow;
        private int indexLength;
        private int indexRangeLength;
        private int itemLength;
        private int rowCount;
        private int beforeFirstHex;
        private int beforeFirstChar;
        private int perRow;
        private String result;

        MakeString() {
            MemoViewDialog.maS$initHexStuff();
            MemoViewDialog.maS$initDecStuff();
        }

        boolean isModifyableNow() {
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof byte[]) {
                return MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected() ^ true;
            }
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof char[]) {
                return MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected() ^ true;
            }
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof short[]) {
                return true;
            }
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof int[]) {
                return true;
            }
            return MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof long[];
        }

        void makeString() {
            try {
                if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof byte[]) {
                    boolean bl = MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected();
                    String string = (String)MemoViewDialog.ra$encodingsComboBox(MemoViewDialog.this).getSelectedItem();
                    if (this.result == null || this.viewAsString != bl || ModelUtil.areDifferent((Object)this.encoding, (Object)string)) {
                        this.viewAsString = bl;
                        this.encoding = string;
                        if (bl) {
                            this.result = new String((byte[])MemoViewDialog.ra$memo(MemoViewDialog.this), string);
                        } else {
                            this.makeBytes((byte[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                        }
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof char[]) {
                    boolean bl = MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected();
                    if (this.result == null || this.viewAsString != bl) {
                        this.viewAsString = bl;
                        if (bl) {
                            this.result = new String((char[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                        } else {
                            this.makeChars((char[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                        }
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof String) {
                    boolean bl = MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected();
                    if (this.result == null || this.viewAsString != bl) {
                        this.viewAsString = bl;
                        if (bl) {
                            this.result = (String)MemoViewDialog.ra$memo(MemoViewDialog.this);
                        } else {
                            this.makeChars(((String)MemoViewDialog.ra$memo(MemoViewDialog.this)).toCharArray());
                        }
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof short[]) {
                    if (this.result == null) {
                        this.makeShorts((short[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof int[]) {
                    if (this.result == null) {
                        this.makeInts((int[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof long[]) {
                    if (this.result == null) {
                        this.makeLongs((long[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                    }
                } else {
                    this.result = null;
                }
            }
            catch (Exception exception) {
                this.result = null;
            }
        }

        String getResult() {
            if (this.result == null) {
                return "";
            }
            return this.result;
        }

        int getArrayIndexFromStringOffsets(int n, int n2) {
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            int n4 = n / this.perRow;
            int n5 = n4 * this.itemsPerRow;
            int n6 = n % this.perRow;
            if (this.beforeFirstHex <= n6 && n6 < this.beforeFirstHex + this.itemsPerRow * this.itemLength) {
                if ((n6 -= this.beforeFirstHex) % this.itemLength == 0) {
                    n5 += n6 / this.itemLength;
                    if (n2 == n + this.hexLength) {
                        return n5;
                    }
                }
            } else if (this.beforeFirstChar != 0 && this.beforeFirstChar <= n6 && n6 < this.beforeFirstChar + this.itemsPerRow) {
                n5 += n6 - this.beforeFirstChar;
                if (n2 == n + 1) {
                    return n5;
                }
            }
            return -1;
        }

        void clear() {
            this.count = 0;
            this.hexLength = 0;
            this.itemsPerRow = 0;
            this.indexLength = 0;
            this.indexRangeLength = 0;
            this.itemLength = 0;
            this.rowCount = 0;
            this.beforeFirstHex = 0;
            this.beforeFirstChar = 0;
            this.perRow = 0;
            this.result = null;
        }

        private void setup(int n, int n2) {
            this.count = n;
            this.hexLength = n2;
            this.itemsPerRow = 32 / n2;
            this.indexLength = MemoViewDialog.ra$HEX_INDEXES() ? Integer.toHexString(this.count - 1).length() : Integer.toString(this.count - 1).length();
            this.indexRangeLength = 2 * this.indexLength + 5;
            this.itemLength = n2 + 1;
            this.rowCount = this.count / this.itemsPerRow + 1;
        }

        private void makeBytes(byte[] byArray) {
            this.clear();
            this.setup(byArray.length, 2);
            StringBuffer stringBuffer = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int n = 0;
            while (n < this.count) {
                MemoViewDialog.maS$appendIndexRange(n, this.itemsPerRow, this.count, this.indexLength, stringBuffer);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = stringBuffer.length();
                }
                int n2 = n;
                int n3 = 0;
                while (n3 < this.itemsPerRow) {
                    if (n < this.count) {
                        MemoViewDialog.maS$appendHex(byArray[n++], this.hexLength, stringBuffer);
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append("   ");
                    }
                    ++n3;
                }
                stringBuffer.append("   ");
                StringBuffer stringBuffer2 = new StringBuffer();
                try {
                    String string = new String(byArray, n2, n - n2, this.encoding);
                    if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplayUpTo(string) == -1) {
                        stringBuffer2.append(string);
                    } else {
                        int n4 = string.length();
                        int n5 = 0;
                        while (n5 < n4) {
                            char c = string.charAt(n5);
                            if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplay(c)) {
                                stringBuffer2.append(c);
                            } else {
                                stringBuffer2.append(' ');
                            }
                            ++n5;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n6 = this.itemsPerRow;
                while (stringBuffer2.length() > n6) {
                    stringBuffer2.append(' ');
                }
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = stringBuffer.length();
            }
            this.result = stringBuffer.toString();
        }

        private void makeChars(char[] cArray) {
            this.clear();
            this.setup(cArray.length, 4);
            StringBuffer stringBuffer = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int n = 0;
            while (n < this.count) {
                MemoViewDialog.maS$appendIndexRange(n, this.itemsPerRow, this.count, this.indexLength, stringBuffer);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = stringBuffer.length();
                }
                int n2 = n;
                int n3 = 0;
                while (n3 < this.itemsPerRow) {
                    if (n < this.count) {
                        MemoViewDialog.maS$appendHex(cArray[n++], this.hexLength, stringBuffer);
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append("     ");
                    }
                    ++n3;
                }
                stringBuffer.append("   ");
                if (this.beforeFirstChar == 0) {
                    this.beforeFirstChar = stringBuffer.length();
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                try {
                    String string = new String(cArray, n2, n - n2);
                    if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplayUpTo(string) == -1) {
                        stringBuffer2.append(string);
                    } else {
                        int n4 = string.length();
                        int n5 = 0;
                        while (n5 < n4) {
                            char c = string.charAt(n5);
                            if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplay(c)) {
                                stringBuffer2.append(c);
                            } else {
                                stringBuffer2.append(' ');
                            }
                            ++n5;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n6 = this.itemsPerRow;
                while (stringBuffer2.length() > n6) {
                    stringBuffer2.append(' ');
                }
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = stringBuffer.length();
            }
            this.result = stringBuffer.toString();
        }

        private void makeShorts(short[] sArray) {
            this.clear();
            this.setup(sArray.length, 4);
            StringBuffer stringBuffer = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int n = 0;
            while (n < this.count) {
                MemoViewDialog.maS$appendIndexRange(n, this.itemsPerRow, this.count, this.indexLength, stringBuffer);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = stringBuffer.length();
                }
                int n2 = 0;
                while (n2 < this.itemsPerRow) {
                    if (n < this.count) {
                        MemoViewDialog.maS$appendHex(sArray[n++], this.hexLength, stringBuffer);
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append("     ");
                    }
                    ++n2;
                }
                stringBuffer.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = stringBuffer.length();
            }
            this.result = stringBuffer.toString();
        }

        private void makeInts(int[] nArray) {
            this.clear();
            this.setup(nArray.length, 8);
            StringBuffer stringBuffer = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int n = 0;
            while (n < this.count) {
                MemoViewDialog.maS$appendIndexRange(n, this.itemsPerRow, this.count, this.indexLength, stringBuffer);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = stringBuffer.length();
                }
                int n2 = 0;
                while (n2 < this.itemsPerRow) {
                    if (n < this.count) {
                        MemoViewDialog.maS$appendHex(nArray[n++], this.hexLength, stringBuffer);
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append("         ");
                    }
                    ++n2;
                }
                stringBuffer.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = stringBuffer.length();
            }
            this.result = stringBuffer.toString();
        }

        private void makeLongs(long[] lArray) {
            this.clear();
            this.setup(lArray.length, 16);
            StringBuffer stringBuffer = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int n = 0;
            while (n < this.count) {
                MemoViewDialog.maS$appendIndexRange(n, this.itemsPerRow, this.count, this.indexLength, stringBuffer);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = stringBuffer.length();
                }
                int n2 = 0;
                while (n2 < this.itemsPerRow) {
                    if (n < this.count) {
                        MemoViewDialog.maS$appendHex(lArray[n++], this.hexLength, stringBuffer);
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append("                 ");
                    }
                    ++n2;
                }
                stringBuffer.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = stringBuffer.length();
            }
            this.result = stringBuffer.toString();
        }
    }
}

