/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.runner.debug.DbgArb;

final class ModifyValueDialog
extends JPanel
implements ItemListener,
DocumentListener,
ActionListener {
    private JEWTDialog dlg;
    private DebugClassInfo clazz;
    private int primitive;
    private DebugDataInfo data;
    private boolean canModifyDataWithString;
    private boolean canSetAddressOfObject;
    private boolean canSetAddressOfObjectToNull;
    private HistoryList newValueHistoryList;
    private JComboBox newValueComboBox;
    private JTextField newValueEditor;
    private JCheckBox addressCheckBox;
    private static final String newValueHistoryName = "DebuggerModifyValue";
    private static final int PRIMITIVE_byte = 0;
    private static final int PRIMITIVE_char = 1;
    private static final int PRIMITIVE_double = 2;
    private static final int PRIMITIVE_float = 3;
    private static final int PRIMITIVE_int = 4;
    private static final int PRIMITIVE_long = 5;
    private static final int PRIMITIVE_short = 6;
    private static final int PRIMITIVE_boolean = 7;

    static boolean showModifyValueDialog(String string, String string2, String string3, String string4, DebugClassInfo debugClassInfo, DebugDataInfo debugDataInfo, boolean bl, boolean bl2, boolean bl3) {
        ModifyValueDialog modifyValueDialog = new ModifyValueDialog(string, string2, string3, string4, debugClassInfo, debugDataInfo, bl, bl2, bl3);
        String string5 = DbgArb.getString(574);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)modifyValueDialog, (Component)modifyValueDialog.newValueEditor, (String)string5);
        modifyValueDialog.setJEWTDialog(jEWTDialog);
        jEWTDialog.setOKButtonEnabled(modifyValueDialog.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)modifyValueDialog, "f1_deb_modifyvaluedialog_html");
        return WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    static boolean toggleValue(DebugDataInfo debugDataInfo, String string) {
        if (debugDataInfo.modifyDataWithString(string)) {
            return true;
        }
        String string2 = DbgArb.getString(584);
        String[] stringArray = new String[]{DbgArb.getString(585), DbgArb.getString(586), DbgArb.getString(587)};
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringArray, string2, 0);
        return false;
    }

    private ModifyValueDialog(String string, String string2, String string3, String string4, DebugClassInfo debugClassInfo, DebugDataInfo debugDataInfo, boolean bl, boolean bl2, boolean bl3) {
        super(new GridBagLayout());
        this.clazz = debugClassInfo;
        this.data = debugDataInfo;
        this.canModifyDataWithString = bl;
        this.canSetAddressOfObject = bl2;
        this.canSetAddressOfObjectToNull = bl3;
        this.primitive = -1;
        if (debugClassInfo.isPrimitive()) {
            String string5 = debugClassInfo.getName();
            if (string5.equals("byte")) {
                this.primitive = 0;
            } else if (string5.equals("char")) {
                this.primitive = 1;
            } else if (string5.equals("double")) {
                this.primitive = 2;
            } else if (string5.equals("float")) {
                this.primitive = 3;
            } else if (string5.equals("int")) {
                this.primitive = 4;
            } else if (string5.equals("long")) {
                this.primitive = 5;
            } else if (string5.equals("short")) {
                this.primitive = 6;
            } else if (string5.equals("boolean")) {
                this.primitive = 7;
            }
        }
        JLabel jLabel = new JLabel(string + " " + string2);
        JLabel jLabel2 = new JLabel();
        JTextArea jTextArea = new JTextArea();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)jTextArea, (String)DbgArb.getString(575));
        jTextArea.setText(this.makeCurrentValue(string3, string4));
        jTextArea.setBorder(new JTextField().getBorder());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(false);
        jTextArea.setForeground(jTextArea.getDisabledTextColor());
        JLabel jLabel3 = new JLabel();
        this.newValueHistoryList = Ide.loadHistoryList((String)newValueHistoryName);
        this.newValueComboBox = new JComboBox<String>(this.newValueHistoryList.getHistory());
        this.newValueComboBox.setEditable(true);
        this.newValueEditor = (JTextField)this.newValueComboBox.getEditor().getEditorComponent();
        this.newValueComboBox.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.newValueEditor, (String)DbgArb.getString(577));
        this.addressCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.addressCheckBox, (String)DbgArb.getString(578));
        this.addressCheckBox.setSelected(bl ^ true);
        this.addressCheckBox.setEnabled(bl && (bl2 || bl3));
        String string6 = this.addressCheckBox.isSelected() ? string4 : string3;
        if (string6 == null) {
            string6 = "";
        }
        IdeUtil.comboBoxSelectItem((JComboBox)this.newValueComboBox, (Object)string6);
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)jTextArea, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.newValueComboBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.addressCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.newValueComboBox, (DocumentListener)this);
        this.newValueComboBox.addItemListener(this);
        this.addressCheckBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1());
    }

    private String makeCurrentValue(String string, String string2) {
        if (string != null) {
            if (string2 != null) {
                return string + "\n" + DbgArb.format(576, string2);
            }
            return string;
        }
        if (string2 != null) {
            return DbgArb.format(576, string2);
        }
        return "";
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        block15: {
            try {
                String string = this.newValueEditor.getText();
                if (this.addressCheckBox.isSelected()) {
                    long l = ModifyValueDialog.parseAddress(string);
                    if (this.canSetAddressOfObject) {
                        boolean bl = true;
                        return bl;
                    }
                    if (this.canSetAddressOfObjectToNull && l == 0L) {
                        boolean bl = true;
                        return bl;
                    }
                    break block15;
                }
                switch (this.primitive) {
                    default: {
                        boolean bl = true;
                        return bl;
                    }
                    case 0: {
                        DebugSharedPrimitives.byteDecode(string);
                        boolean bl = true;
                        return bl;
                    }
                    case 1: {
                        DebugSharedPrimitives.charDecode(string);
                        boolean bl = true;
                        return bl;
                    }
                    case 2: {
                        DebugSharedPrimitives.doubleDecode(string);
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        DebugSharedPrimitives.floatDecode(string);
                        boolean bl = true;
                        return bl;
                    }
                    case 4: {
                        DebugSharedPrimitives.intDecode(string);
                        boolean bl = true;
                        return bl;
                    }
                    case 5: {
                        DebugSharedPrimitives.longDecode(string);
                        boolean bl = true;
                        return bl;
                    }
                    case 6: {
                        DebugSharedPrimitives.shortDecode(string);
                        boolean bl = true;
                        return bl;
                    }
                    case 7: 
                }
                DebugSharedPrimitives.booleanDecode(string);
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static long parseAddress(String string) throws NumberFormatException {
        if ("null".equals(string)) {
            return 0L;
        }
        return DebugSharedPrimitives.longDecode(string);
    }

    private boolean setDataNewValue() {
        String string = this.newValueHistoryList.comboBoxGetSelectedItem(this.newValueComboBox);
        String string2 = null;
        if (this.addressCheckBox.isSelected()) {
            long l = ModifyValueDialog.parseAddress(string);
            if (!((DebugDataCompositeInfo)this.data).setAddressOfObject(l)) {
                string2 = DbgArb.getString(582);
            }
        } else if (!this.data.modifyDataWithString(string)) {
            string2 = DbgArb.getString(583);
        }
        if (string2 != null) {
            String string3 = DbgArb.getString(574);
            String[] stringArray = new String[]{DbgArb.getString(579), DbgArb.getString(580), DbgArb.getString(581), string2};
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringArray, string3, 0);
            return false;
        }
        return true;
    }

    public void cancel() {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.newValueComboBox) {
            this.newValueEditor.setText((String)this.newValueComboBox.getSelectedItem());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.processChange();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.processChange();
    }

    static boolean mav$setDataNewValue(ModifyValueDialog modifyValueDialog) {
        return modifyValueDialog.setDataNewValue();
    }

    final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !ModifyValueDialog.mav$setDataNewValue(ModifyValueDialog.this)) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }
    }
}

