/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsPanel;

final class MonitorsWindow
extends DockableWindow {
    private static IdeAction actionNotify;
    private static IdeAction actionNotifyAll;
    private static IdeAction actionViewWhole;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemNotify;
    private static JMenuItem menuitemNotifyAll;
    private static JMenuItem menuitemSettings;
    private static final int NOTIFY_CMD_ID;
    private static final int NOTIFY_ALL_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    private static IdeAction actionOwningThreadGoTo;
    private static IdeAction actionOwningThreadSave;
    private static IdeAction actionOwningThreadSettings;
    private static final int OWNING_THREAD_GOTO_CMD_ID;
    private static final int OWNING_THREAD_SAVE_CMD_ID;
    private static final int OWNING_THREAD_SETTINGS_CMD_ID;
    private static IdeAction actionWaitingThreadsGoTo;
    private static IdeAction actionWaitingThreadsSave;
    private static IdeAction actionWaitingThreadsSettings;
    private static final int WAITING_THREADS_GOTO_CMD_ID;
    private static final int WAITING_THREADS_SAVE_CMD_ID;
    private static final int WAITING_THREADS_SETTINGS_CMD_ID;
    private static IdeAction actionBlockedThreadsGoTo;
    private static IdeAction actionBlockedThreadsSave;
    private static IdeAction actionBlockedThreadsSettings;
    private static final int BLOCKED_THREADS_GOTO_CMD_ID;
    private static final int BLOCKED_THREADS_SAVE_CMD_ID;
    private static final int BLOCKED_THREADS_SETTINGS_CMD_ID;
    static final String MONITORS_WINDOW_ID = "Debugger.MonitorsWindow";
    private static Icon monitorsTabIcon;
    static final int OWNING_THREAD_PANEL_ID = 1;
    static final int WAITING_THREADS_PANEL_ID = 2;
    static final int BLOCKED_THREADS_PANEL_ID = 3;
    private String title;
    private MonitorsPanel monitorsPanel;
    private MonitorsThreadsPanel owningThreadPanel;
    private MonitorsThreadsPanel waitingThreadsPanel;
    private MonitorsThreadsPanel blockedThreadsPanel;
    private JSplitPane splitPane;
    private MonitorsWindowSettings monitorsWindowSettings = MonitorsWindowSettings.getInstance();

    static {
        NOTIFY_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsNotify");
        NOTIFY_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsNotifyAll");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsViewWhole");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsModifyValue");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsSettings");
        OWNING_THREAD_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadGoTo");
        OWNING_THREAD_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadSave");
        OWNING_THREAD_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadSettings");
        WAITING_THREADS_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsGoTo");
        WAITING_THREADS_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsSave");
        WAITING_THREADS_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsSettings");
        BLOCKED_THREADS_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsGoTo");
        BLOCKED_THREADS_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsSave");
        BLOCKED_THREADS_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsSettings");
        monitorsTabIcon = null;
    }

    MonitorsWindow() {
        super(MONITORS_WINDOW_ID);
        this.title = DbgArb.getString(688);
        MonitorsWindow.makeActions();
        this.owningThreadPanel = new MonitorsThreadsPanel(1, DbgArb.getString(691), 1);
        this.waitingThreadsPanel = new MonitorsThreadsPanel(2, DbgArb.getString(693), 2);
        this.blockedThreadsPanel = new MonitorsThreadsPanel(3, DbgArb.getString(695), 2);
        this.monitorsPanel = new MonitorsPanel(this.owningThreadPanel, this.waitingThreadsPanel, this.blockedThreadsPanel);
        this.setControllerForActions();
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public Icon getTabIcon() {
        if (monitorsTabIcon == null) {
            monitorsTabIcon = DbgArb.getIcon(82);
        }
        return monitorsTabIcon;
    }

    private void makeSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setLeftComponent(this.makeLeftPanel());
            this.splitPane.setRightComponent(this.makeRightPanel());
            this.splitPane.setResizeWeight(0.5);
        }
    }

    private JPanel makeLeftPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        Component component = this.monitorsPanel.getGUI();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)component, (String)DbgArb.getString(689));
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add(component, new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return jPanel;
    }

    private JPanel makeRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        Component component = this.owningThreadPanel.getGUI();
        Component component2 = this.waitingThreadsPanel.getGUI();
        Component component3 = this.blockedThreadsPanel.getGUI();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)component, (String)DbgArb.getString(690));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)component2, (String)DbgArb.getString(692));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)component3, (String)DbgArb.getString(694));
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add(component, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.2, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add(component2, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.4, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add(component3, new GridBagConstraints(0, n, 0, 1, 1.0, 0.4, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return jPanel;
    }

    void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        this.monitorsPanel.loadSettings();
        this.owningThreadPanel.loadSettings();
        this.waitingThreadsPanel.loadSettings();
        this.blockedThreadsPanel.loadSettings();
    }

    private void debugWindowSettingsChanged(DebugWindowSettings debugWindowSettings) {
        this.monitorsPanel.debugWindowSettingsChanged(debugWindowSettings);
    }

    void setUseFilters(boolean bl) {
        this.monitorsPanel.setUseFilters(bl);
    }

    private void saveSettings() {
        this.monitorsPanel.saveSettings();
        this.owningThreadPanel.saveSettings();
        this.waitingThreadsPanel.saveSettings();
        this.blockedThreadsPanel.saveSettings();
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        MonitorsWindow.makeActions();
        JMenu jMenu2 = menubar.createSubMenu(DbgArb.getString(105), DbgArb.getInteger(106));
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionNotify), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionNotifyAll), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), jMenu2, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), jMenu2, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu2, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu2, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu2, f);
        jMenu.add(jMenu2);
        JMenu jMenu3 = menubar.createSubMenu(DbgArb.getString(107), DbgArb.getInteger(108));
        f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOwningThreadGoTo), jMenu3, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOwningThreadSave), jMenu3, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOwningThreadSettings), jMenu3, f);
        jMenu.add(jMenu3);
        JMenu jMenu4 = menubar.createSubMenu(DbgArb.getString(109), DbgArb.getInteger(110));
        f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWaitingThreadsGoTo), jMenu4, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWaitingThreadsSave), jMenu4, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWaitingThreadsSettings), jMenu4, f);
        jMenu.add(jMenu4);
        JMenu jMenu5 = menubar.createSubMenu(DbgArb.getString(111), DbgArb.getInteger(112));
        f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBlockedThreadsGoTo), jMenu5, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBlockedThreadsSave), jMenu5, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBlockedThreadsSettings), jMenu5, f);
        jMenu.add(jMenu5);
    }

    private static void makeActions() {
        if (actionNotify == null) {
            actionNotify = IdeAction.get((int)NOTIFY_CMD_ID, null, (String)DbgArb.getString(696), null, (Integer)DbgArb.getInteger(697), null, (int)-1, null, (boolean)false);
            actionNotify.setEnabled(false);
            actionNotifyAll = IdeAction.get((int)NOTIFY_ALL_CMD_ID, null, (String)DbgArb.getString(698), null, (Integer)DbgArb.getInteger(699), null, (int)-1, null, (boolean)false);
            actionNotifyAll.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(317), null, (Integer)DbgArb.getInteger(318), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(319), null, (Integer)DbgArb.getInteger(320), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(321), null, (Integer)DbgArb.getInteger(322), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(323), null, (Integer)DbgArb.getInteger(324), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(341), null, (Integer)DbgArb.getInteger(342), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(343), null, (Integer)DbgArb.getInteger(344), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(329), null, (Integer)DbgArb.getInteger(331), null, (int)-1, null, (boolean)false);
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(332), null, (Integer)DbgArb.getInteger(334), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(335), null, (Integer)DbgArb.getInteger(337), null, (int)-1, null, (boolean)false);
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(345), null, (Integer)DbgArb.getInteger(346), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(347, ""), null, (Integer)DbgArb.getInteger(348), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
            actionOwningThreadGoTo = IdeAction.get((int)OWNING_THREAD_GOTO_CMD_ID, null, (String)DbgArb.getString(261), null, (Integer)DbgArb.getInteger(262), null, (int)-1, null, (boolean)false);
            actionOwningThreadGoTo.setEnabled(false);
            actionOwningThreadSettings = IdeAction.get((int)OWNING_THREAD_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionOwningThreadSettings.setEnabled(false);
            actionOwningThreadSave = IdeAction.get((int)OWNING_THREAD_SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionOwningThreadSave.setEnabled(false);
            actionWaitingThreadsGoTo = IdeAction.get((int)WAITING_THREADS_GOTO_CMD_ID, null, (String)DbgArb.getString(261), null, (Integer)DbgArb.getInteger(262), null, (int)-1, null, (boolean)false);
            actionWaitingThreadsGoTo.setEnabled(false);
            actionWaitingThreadsSettings = IdeAction.get((int)WAITING_THREADS_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionWaitingThreadsSettings.setEnabled(false);
            actionWaitingThreadsSave = IdeAction.get((int)WAITING_THREADS_SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionWaitingThreadsSave.setEnabled(false);
            actionBlockedThreadsGoTo = IdeAction.get((int)BLOCKED_THREADS_GOTO_CMD_ID, null, (String)DbgArb.getString(261), null, (Integer)DbgArb.getInteger(262), null, (int)-1, null, (boolean)false);
            actionBlockedThreadsGoTo.setEnabled(false);
            actionBlockedThreadsSettings = IdeAction.get((int)BLOCKED_THREADS_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionBlockedThreadsSettings.setEnabled(false);
            actionBlockedThreadsSave = IdeAction.get((int)BLOCKED_THREADS_SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionBlockedThreadsSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionNotify, actionNotifyAll, actionViewWhole, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this.monitorsPanel);
        ideActionArray = new IdeAction[]{actionOwningThreadGoTo, actionOwningThreadSettings, actionOwningThreadSave};
        JDebugger.setControllerForActions(ideActionArray, this.owningThreadPanel);
        ideActionArray = new IdeAction[]{actionWaitingThreadsGoTo, actionWaitingThreadsSettings, actionWaitingThreadsSave};
        JDebugger.setControllerForActions(ideActionArray, this.waitingThreadsPanel);
        ideActionArray = new IdeAction[]{actionBlockedThreadsGoTo, actionBlockedThreadsSettings, actionBlockedThreadsSave};
        JDebugger.setControllerForActions(ideActionArray, this.blockedThreadsPanel);
    }

    public String getMenuTitle() {
        if (!JDebugger.getInstance().canShowMonitorsWindow()) {
            return null;
        }
        return this.title;
    }

    public Component getGUI() {
        if (!JDebugger.getInstance().canShowMonitorsWindow()) {
            return null;
        }
        if (this.splitPane == null) {
            DebugWindowSettings debugWindowSettings = DebugWindowSettings.getInstance();
            this.makeSplitPane();
            this.loadSettings();
            this.debugWindowSettingsChanged(debugWindowSettings);
            this.monitorsPanel.dataPanelSettingsChanged(false);
            this.owningThreadPanel.threadsPanelSettingsChanged(false);
            this.waitingThreadsPanel.threadsPanelSettingsChanged(false);
            this.blockedThreadsPanel.threadsPanelSettingsChanged(false);
            this.splitPane.resetToPreferredSizes();
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            debugWindowSettings.addChangeListener(new 1(this, debugWindowSettings));
        }
        return this.splitPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_monitorswindow_html");
    }

    public Controller getController() {
        Object object = this.findFocus();
        if (object instanceof Controller) {
            return (Controller)object;
        }
        return this.monitorsPanel;
    }

    public Context getContext(EventObject eventObject) {
        Object object = this.findFocus();
        if (object == this.monitorsPanel) {
            return this.monitorsPanel.getContext(eventObject);
        }
        if (object == this.owningThreadPanel) {
            return this.owningThreadPanel.getContext(eventObject);
        }
        if (object == this.waitingThreadsPanel) {
            return this.waitingThreadsPanel.getContext(eventObject);
        }
        if (object == this.blockedThreadsPanel) {
            return this.blockedThreadsPanel.getContext(eventObject);
        }
        return this.monitorsPanel.getContext(eventObject);
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    private Object findFocus() {
        Window window;
        Component component;
        Component component2 = this.splitPane;
        while (component2 != null && !(component2 instanceof Window)) {
            component2 = component2.getParent();
        }
        if (component2 != null && (component = (window = (Window)component2).getFocusOwner()) != null) {
            Component component3 = this.monitorsPanel.getGUI();
            Component component4 = this.owningThreadPanel.getGUI();
            Component component5 = this.waitingThreadsPanel.getGUI();
            Component component6 = this.blockedThreadsPanel.getGUI();
            component2 = component;
            while (component2 != null) {
                if (component2 == component3) {
                    return this.monitorsPanel;
                }
                if (component2 == component4) {
                    return this.owningThreadPanel;
                }
                if (component2 == component5) {
                    return this.waitingThreadsPanel;
                }
                if (component2 == component6) {
                    return this.blockedThreadsPanel;
                }
                component2 = component2.getParent();
            }
        }
        return null;
    }

    void everythingChanged() {
        this.monitorsPanel.everythingChanged();
    }

    void updateMonitors(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine) {
        this.monitorsPanel.updateData(debuggingProcess, debugVirtualMachine, null, null);
    }

    void clearMonitors() {
        this.monitorsPanel.clearData();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.monitorsPanel.processFinished(debuggingProcess);
    }

    static void mav$debugWindowSettingsChanged(MonitorsWindow monitorsWindow, DebugWindowSettings debugWindowSettings) {
        monitorsWindow.debugWindowSettingsChanged(debugWindowSettings);
    }

    static int ra$NOTIFY_CMD_ID() {
        return NOTIFY_CMD_ID;
    }

    static int ra$NOTIFY_ALL_CMD_ID() {
        return NOTIFY_ALL_CMD_ID;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionNotify() {
        return actionNotify;
    }

    static JMenuItem ra$menuitemNotify() {
        return menuitemNotify;
    }

    static void wa$menuitemNotify(JMenuItem jMenuItem) {
        menuitemNotify = jMenuItem;
    }

    static IdeAction ra$actionNotifyAll() {
        return actionNotifyAll;
    }

    static JMenuItem ra$menuitemNotifyAll() {
        return menuitemNotifyAll;
    }

    static void wa$menuitemNotifyAll(JMenuItem jMenuItem) {
        menuitemNotifyAll = jMenuItem;
    }

    static MonitorsWindowSettings ra$monitorsWindowSettings(MonitorsWindow monitorsWindow) {
        return monitorsWindow.monitorsWindowSettings;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    static IdeAction ra$actionOwningThreadGoTo() {
        return actionOwningThreadGoTo;
    }

    static IdeAction ra$actionOwningThreadSettings() {
        return actionOwningThreadSettings;
    }

    static IdeAction ra$actionOwningThreadSave() {
        return actionOwningThreadSave;
    }

    static int ra$OWNING_THREAD_GOTO_CMD_ID() {
        return OWNING_THREAD_GOTO_CMD_ID;
    }

    static int ra$OWNING_THREAD_SETTINGS_CMD_ID() {
        return OWNING_THREAD_SETTINGS_CMD_ID;
    }

    static int ra$OWNING_THREAD_SAVE_CMD_ID() {
        return OWNING_THREAD_SAVE_CMD_ID;
    }

    static IdeAction ra$actionWaitingThreadsGoTo() {
        return actionWaitingThreadsGoTo;
    }

    static IdeAction ra$actionWaitingThreadsSettings() {
        return actionWaitingThreadsSettings;
    }

    static IdeAction ra$actionWaitingThreadsSave() {
        return actionWaitingThreadsSave;
    }

    static int ra$WAITING_THREADS_GOTO_CMD_ID() {
        return WAITING_THREADS_GOTO_CMD_ID;
    }

    static int ra$WAITING_THREADS_SETTINGS_CMD_ID() {
        return WAITING_THREADS_SETTINGS_CMD_ID;
    }

    static int ra$WAITING_THREADS_SAVE_CMD_ID() {
        return WAITING_THREADS_SAVE_CMD_ID;
    }

    static IdeAction ra$actionBlockedThreadsGoTo() {
        return actionBlockedThreadsGoTo;
    }

    static IdeAction ra$actionBlockedThreadsSettings() {
        return actionBlockedThreadsSettings;
    }

    static IdeAction ra$actionBlockedThreadsSave() {
        return actionBlockedThreadsSave;
    }

    static int ra$BLOCKED_THREADS_GOTO_CMD_ID() {
        return BLOCKED_THREADS_GOTO_CMD_ID;
    }

    static int ra$BLOCKED_THREADS_SETTINGS_CMD_ID() {
        return BLOCKED_THREADS_SETTINGS_CMD_ID;
    }

    static int ra$BLOCKED_THREADS_SAVE_CMD_ID() {
        return BLOCKED_THREADS_SAVE_CMD_ID;
    }

    final class 1
    implements ChangeListener {
        private final /* synthetic */ DebugWindowSettings v$dbgSettings;
        final /* synthetic */ MonitorsWindow this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            MonitorsWindow.mav$debugWindowSettingsChanged(this.this$0, this.v$dbgSettings);
        }

        public 1(MonitorsWindow monitorsWindow, DebugWindowSettings debugWindowSettings) {
            this.v$dbgSettings = debugWindowSettings;
            this.this$0 = monitorsWindow;
        }
    }

    final class MonitorsPanel
    extends DataPanel {
        private MonitorsThreadsPanel owningThreadPanel;
        private MonitorsThreadsPanel waitingThreadsPanel;
        private MonitorsThreadsPanel blockedThreadsPanel;
        private static final String MONITORS_ID = ".Monitors";

        MonitorsPanel(MonitorsThreadsPanel monitorsThreadsPanel, MonitorsThreadsPanel monitorsThreadsPanel2, MonitorsThreadsPanel monitorsThreadsPanel3) {
            super(MonitorsWindow.this, MonitorsWindow.ra$monitorsWindowSettings(MonitorsWindow.this).getDataPanelSettings());
            this.selectFirstRowIfNoPreviousSelection = true;
            this.owningThreadPanel = monitorsThreadsPanel;
            this.waitingThreadsPanel = monitorsThreadsPanel2;
            this.blockedThreadsPanel = monitorsThreadsPanel3;
            this._actionViewWhole = MonitorsWindow.ra$actionViewWhole();
            this._actionAdjustRange = MonitorsWindow.ra$actionAdjustRange();
            this._actionToggleValue = MonitorsWindow.ra$actionToggleValue();
            this._actionModifyValue = MonitorsWindow.ra$actionModifyValue();
            this._actionWatch = null;
            this._actionInspect = null;
            this._actionWatchClassLoader = MonitorsWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = MonitorsWindow.ra$actionInspectClassLoader();
            this._actionGoto = MonitorsWindow.ra$actionGoto();
            this._actionGotoDeclared = MonitorsWindow.ra$actionGotoDeclared();
            this._actionGotoField = MonitorsWindow.ra$actionGotoField();
            this._actionUseFilters = MonitorsWindow.ra$actionUseFilters();
            this._actionObjectPreferences = MonitorsWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = MonitorsWindow.ra$actionCollapseAll();
            this._actionSave = MonitorsWindow.ra$actionSave();
            this._VIEW_WHOLE_CMD_ID = MonitorsWindow.ra$VIEW_WHOLE_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = MonitorsWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = MonitorsWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = MonitorsWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = -1;
            this._INSPECT_CMD_ID = -1;
            this._WATCH_CLASSLOADER_CMD_ID = MonitorsWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = MonitorsWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = MonitorsWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = MonitorsWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = MonitorsWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = MonitorsWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = MonitorsWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = MonitorsWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = MonitorsWindow.ra$SAVE_CMD_ID();
        }

        protected void adjustGUI() {
            this.columnDefaultWidth[2] = this.columnDefaultWidth[2] * 2;
            this.column[2].setPreferredWidth(this.columnDefaultWidth[2]);
        }

        protected void addPopupMenuItemsForDataItem(ContextMenu contextMenu, Context context) {
            this.update(MonitorsWindow.ra$actionNotify(), context);
            if (MonitorsWindow.ra$actionNotify().isEnabled()) {
                if (MonitorsWindow.ra$menuitemNotify() == null) {
                    MonitorsWindow.wa$menuitemNotify(contextMenu.createMenuItem((ToggleAction)MonitorsWindow.ra$actionNotify()));
                }
                contextMenu.add((Component)MonitorsWindow.ra$menuitemNotify(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(MonitorsWindow.ra$actionNotifyAll(), context);
            if (MonitorsWindow.ra$actionNotifyAll().isEnabled()) {
                if (MonitorsWindow.ra$menuitemNotifyAll() == null) {
                    MonitorsWindow.wa$menuitemNotifyAll(contextMenu.createMenuItem((ToggleAction)MonitorsWindow.ra$actionNotifyAll()));
                }
                contextMenu.add((Component)MonitorsWindow.ra$menuitemNotifyAll(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(contextMenu, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(MonitorsWindow.ra$actionSettings(), context);
            if (MonitorsWindow.ra$actionSettings().isEnabled()) {
                if (MonitorsWindow.ra$menuitemSettings() == null) {
                    MonitorsWindow.wa$menuitemSettings(contextMenu.createMenuItem((ToggleAction)MonitorsWindow.ra$actionSettings()));
                }
                contextMenu.add((Component)MonitorsWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == MonitorsWindow.ra$SETTINGS_CMD_ID())) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == MonitorsWindow.ra$NOTIFY_CMD_ID() || n == MonitorsWindow.ra$NOTIFY_ALL_CMD_ID()) {
                DebugMonitorInfo debugMonitorInfo = this.getSelectedMonitorInfo();
                if (debugMonitorInfo != null && debugMonitorInfo.canDoNotify()) {
                    ideAction.setEnabled(true);
                    return true;
                }
                ideAction.setEnabled(false);
                return true;
            }
            if (n == MonitorsWindow.ra$SETTINGS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == MonitorsWindow.ra$NOTIFY_CMD_ID()) {
                DebugMonitorInfo debugMonitorInfo = this.getSelectedMonitorInfo();
                if (debugMonitorInfo != null && debugMonitorInfo.canDoNotify()) {
                    debugMonitorInfo.doNotify();
                    this.updateOtherPanels();
                }
                return true;
            }
            if (n == MonitorsWindow.ra$NOTIFY_ALL_CMD_ID()) {
                DebugMonitorInfo debugMonitorInfo = this.getSelectedMonitorInfo();
                if (debugMonitorInfo != null && debugMonitorInfo.canDoNotify()) {
                    debugMonitorInfo.doNotifyAll();
                    this.updateOtherPanels();
                }
                return true;
            }
            if (n == MonitorsWindow.ra$SETTINGS_CMD_ID()) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(812)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        protected void addDataItems() {
            if (this.vm != null) {
                List list = this.getRoot();
                DebugMonitorInfo[] debugMonitorInfoArray = this.vm.listMonitorsInUse();
                int n = debugMonitorInfoArray.length;
                boolean[] blArray = new boolean[n];
                int n2 = 0;
                while (n2 < n) {
                    DebugMonitorInfo debugMonitorInfo = debugMonitorInfoArray[n2];
                    blArray[n2] = this.isDeadlocked(debugMonitorInfo);
                    ++n2;
                }
                int n3 = 0;
                while (n3 < n) {
                    if (blArray[n3]) {
                        DebugMonitorInfo debugMonitorInfo = debugMonitorInfoArray[n3];
                        list.add(new MonitorDataItem(debugMonitorInfo, true));
                    }
                    ++n3;
                }
                int n4 = 0;
                while (n4 < n) {
                    if (!blArray[n4]) {
                        DebugMonitorInfo debugMonitorInfo = debugMonitorInfoArray[n4];
                        list.add(new MonitorDataItem(debugMonitorInfo, false));
                    }
                    ++n4;
                }
            }
        }

        private boolean isDeadlocked(DebugMonitorInfo debugMonitorInfo) {
            DebugThreadInfo[][] debugThreadInfoArray = this.debuggingProcess.getDeadlocks();
            int n = debugThreadInfoArray.length;
            if (n != 0) {
                int n2 = 0;
                while (n2 < n) {
                    int n3 = debugThreadInfoArray[n2].length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DebugThreadInfo debugThreadInfo = debugThreadInfoArray[n2][n4];
                        DebugMonitorInfo debugMonitorInfo2 = debugThreadInfo.getMonitorThreadBlockedFor();
                        if (debugMonitorInfo.equals(debugMonitorInfo2)) {
                            return true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            super.valueChanged(treeSelectionEvent);
            this.updateOtherPanels();
        }

        void clearData() {
            super.clearData();
            this.updateOtherPanels();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            super.processFinished(debuggingProcess);
            this.owningThreadPanel.processFinished(debuggingProcess);
            this.waitingThreadsPanel.processFinished(debuggingProcess);
            this.blockedThreadsPanel.processFinished(debuggingProcess);
        }

        private DebugMonitorInfo getSelectedMonitorInfo() {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                Object[] objectArray = treePath.getPath();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    MonitorDataItem monitorDataItem;
                    Object object;
                    Object object2 = objectArray[n];
                    if (object2 instanceof MonitorDataItem && (object = (monitorDataItem = (MonitorDataItem)object2).getInfo()) instanceof DebugMonitorInfo) {
                        return (DebugMonitorInfo)object;
                    }
                    --n;
                }
            }
            return null;
        }

        private void updateOtherPanels() {
            if (this.treeTable != null && this.treeTable.isEnabled()) {
                if (this.debuggingProcess != null && this.vm != null) {
                    DebugMonitorInfo debugMonitorInfo = this.getSelectedMonitorInfo();
                    if (debugMonitorInfo != null) {
                        this.owningThreadPanel.setThread(debugMonitorInfo.getOwnerThread());
                        this.waitingThreadsPanel.setThreads(debugMonitorInfo.listWaitingThreads());
                        this.blockedThreadsPanel.setThreads(debugMonitorInfo.listBlockedThreads());
                    } else {
                        this.owningThreadPanel.setThreads(null);
                        this.waitingThreadsPanel.setThreads(null);
                        this.blockedThreadsPanel.setThreads(null);
                    }
                    this.owningThreadPanel.updateThreads(this.debuggingProcess, this.vm, null);
                    this.waitingThreadsPanel.updateThreads(this.debuggingProcess, this.vm, null);
                    this.blockedThreadsPanel.updateThreads(this.debuggingProcess, this.vm, null);
                } else {
                    this.owningThreadPanel.updateThreads(null, null, null);
                    this.waitingThreadsPanel.updateThreads(null, null, null);
                    this.blockedThreadsPanel.updateThreads(null, null, null);
                }
            } else {
                this.owningThreadPanel.clearThreads();
                this.waitingThreadsPanel.clearThreads();
                this.blockedThreadsPanel.clearThreads();
            }
        }

        protected final class MonitorDataItem
        extends DataPanel.DataItem {
            boolean deadlocked;

            MonitorDataItem(Object object, boolean bl) {
                super(object);
                this.deadlocked = bl;
            }

            protected Font getFont(int n) {
                if (n == 0 && this.deadlocked) {
                    return MonitorsPanel.this.getBoldFont();
                }
                return super.getFont(n);
            }
        }
    }

    final class MonitorsThreadsPanel
    extends ThreadsPanel {
        private String accessibleName;
        private DebugThreadInfo[] threads;
        private IdeAction _actionSettings;
        private JMenuItem _menuitemSettings;
        private int _SETTINGS_CMD_ID;

        MonitorsThreadsPanel(int n, String string, int n2) {
            super(MonitorsWindow.this, MonitorsWindow.ra$monitorsWindowSettings(MonitorsWindow.this).getThreadsPanelSettings());
            this.accessibleName = string;
            this.preferredVisibleRowCount = n2;
            this.boldCurrentThreadName = false;
            switch (n) {
                case 1: {
                    this._actionGoTo = MonitorsWindow.ra$actionOwningThreadGoTo();
                    this._actionSettings = MonitorsWindow.ra$actionOwningThreadSettings();
                    this._actionSave = MonitorsWindow.ra$actionOwningThreadSave();
                    this._GOTO_CMD_ID = MonitorsWindow.ra$OWNING_THREAD_GOTO_CMD_ID();
                    this._SETTINGS_CMD_ID = MonitorsWindow.ra$OWNING_THREAD_SETTINGS_CMD_ID();
                    this._SAVE_CMD_ID = MonitorsWindow.ra$OWNING_THREAD_SAVE_CMD_ID();
                    break;
                }
                case 2: {
                    this._actionGoTo = MonitorsWindow.ra$actionWaitingThreadsGoTo();
                    this._actionSettings = MonitorsWindow.ra$actionWaitingThreadsSettings();
                    this._actionSave = MonitorsWindow.ra$actionWaitingThreadsSave();
                    this._GOTO_CMD_ID = MonitorsWindow.ra$WAITING_THREADS_GOTO_CMD_ID();
                    this._SETTINGS_CMD_ID = MonitorsWindow.ra$WAITING_THREADS_SETTINGS_CMD_ID();
                    this._SAVE_CMD_ID = MonitorsWindow.ra$WAITING_THREADS_SAVE_CMD_ID();
                    break;
                }
                case 3: {
                    this._actionGoTo = MonitorsWindow.ra$actionBlockedThreadsGoTo();
                    this._actionSettings = MonitorsWindow.ra$actionBlockedThreadsSettings();
                    this._actionSave = MonitorsWindow.ra$actionBlockedThreadsSave();
                    this._GOTO_CMD_ID = MonitorsWindow.ra$BLOCKED_THREADS_GOTO_CMD_ID();
                    this._SETTINGS_CMD_ID = MonitorsWindow.ra$BLOCKED_THREADS_SETTINGS_CMD_ID();
                    this._SAVE_CMD_ID = MonitorsWindow.ra$BLOCKED_THREADS_SAVE_CMD_ID();
                }
            }
        }

        protected void adjustGUI() {
            this.treeTable.getAccessibleContext().setAccessibleName(this.accessibleName);
            this.columnDefaultWidth[1] = this.columnDefaultWidth[1] * 2;
            this.column[1].setPreferredWidth(this.columnDefaultWidth[1]);
        }

        void setThreads(DebugThreadInfo[] debugThreadInfoArray) {
            this.threads = debugThreadInfoArray;
        }

        void setThread(DebugThreadInfo debugThreadInfo) {
            if (debugThreadInfo != null) {
                this.threads = new DebugThreadInfo[1];
                this.threads[0] = debugThreadInfo;
            } else {
                this.threads = null;
            }
        }

        void clearThreads() {
            this.threads = null;
            super.clearThreads();
        }

        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(this._actionSettings, context);
            if (this._actionSettings.isEnabled()) {
                if (this._menuitemSettings == null) {
                    this._menuitemSettings = contextMenu.createMenuItem((ToggleAction)this._actionSettings);
                }
                contextMenu.add((Component)this._menuitemSettings, JDeveloperMenuConstants.SECTION_TOOLS_CTXT_MENU);
            }
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == this._SETTINGS_CMD_ID) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(812), DbgArb.getString(813)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == this._SETTINGS_CMD_ID)) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == this._SETTINGS_CMD_ID) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        protected void addThreadItems() {
            if (this.threads != null) {
                List list = this.getRoot();
                Arrays.sort(this.threads, this);
                int n = 0;
                while (n < this.threads.length) {
                    list.add(new ThreadsPanel.ThreadItem(this, this.threads[n]));
                    ++n;
                }
            }
        }
    }
}

