/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.runner.debug.JDebugger;

final class ObjectPreferences {
    static final String FILENAME = "debuggerObjectPreferences.xml";
    static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-object-preferences");
    static final String ROOT_TAG = "debugger-object-preferences";
    static final String DATAFILTERS_FILENAME = "dataFilters.xml";
    static final String DATAFILTERS_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-data-filters");
    static final String DATAFILTERS_ROOT_TAG = "data-filters";
    static final String DATAVALUES_FILENAME = "dataValues.xml";
    static final String DATAVALUES_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-data-values");
    static final String DATAVALUES_ROOT_TAG = "data-values";
    private TreeMap _valueExpressions = new TreeMap();
    private TreeMap _valueExpressionSuggestions = new TreeMap();
    private TreeMap _hiddenFields = new TreeMap();
    private TreeSet _hideAllFields = new TreeSet();
    private TreeMap _expandExpressions = new TreeMap();
    private TreeMap _expandExpressionSuggestions = new TreeMap();
    private static String EXPAND_EXPRESSION_DELIMITERS = ",;";

    ObjectPreferences() {
    }

    boolean isValueExpressionsEmpty() {
        return this._valueExpressions.isEmpty();
    }

    TreeMap deepCloneValueExpressions() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String string : this._valueExpressions.keySet()) {
            String string2 = (String)this._valueExpressions.get(string);
            treeMap.put(string, string2);
        }
        return treeMap;
    }

    void setValueExpressions(TreeMap treeMap) {
        this._valueExpressions = treeMap;
    }

    String getValueExpression(String string) {
        return (String)this._valueExpressions.get(string);
    }

    String getValueExpression(DebugDataObjectInfo debugDataObjectInfo) {
        if (!this.isValueExpressionsEmpty()) {
            DebugClassInfo debugClassInfo = debugDataObjectInfo.getClassInfo();
            while (debugClassInfo != null) {
                String string = debugClassInfo.getName();
                String string2 = this.getValueExpression(string);
                if (string2 != null) {
                    return string2;
                }
                DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces();
                if (debugClassInfoArray != null) {
                    int n = debugClassInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string3 = debugClassInfoArray[n2].getName();
                        string2 = this.getValueExpression(string3);
                        if (string2 != null) {
                            return string2;
                        }
                        ++n2;
                    }
                }
                debugClassInfo = debugClassInfo.getSuperClass(1);
            }
        }
        return null;
    }

    void setValueExpression(String string, String string2) {
        if (!this._valueExpressions.containsKey(string)) {
            this._valueExpressions.put(string, string2);
        }
    }

    String[] getValueExpressionSuggestions(String string) {
        List list = (List)this._valueExpressionSuggestions.get(string);
        if (list != null) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    void addValueExpressionSuggestion(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this._valueExpressionSuggestions.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this._valueExpressionSuggestions.put(string, arrayList);
        }
        if (!arrayList.contains(string2)) {
            arrayList.add(string2);
        }
    }

    boolean isHiddenFieldsEmpty() {
        return this._hiddenFields.isEmpty();
    }

    TreeMap deepCloneHiddenFields() {
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        for (String string : this._hiddenFields.keySet()) {
            String[] stringArray = (String[])this._hiddenFields.get(string);
            int n = stringArray.length;
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            treeMap.put(string, stringArray2);
        }
        return treeMap;
    }

    void setHiddenFields(TreeMap treeMap) {
        this._hiddenFields = treeMap;
    }

    List getHiddenFields(String string) {
        String[] stringArray = (String[])this._hiddenFields.get(string);
        if (stringArray != null) {
            return Arrays.asList(stringArray);
        }
        return null;
    }

    boolean isHideAllFieldsEmpty() {
        return this._hideAllFields.isEmpty();
    }

    TreeSet deepCloneHideAllFields() {
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this._hideAllFields);
        return treeSet;
    }

    void setHideAllFields(TreeSet treeSet) {
        this._hideAllFields = treeSet;
    }

    void setHideAllFields(String string, boolean bl) {
        if (bl) {
            this._hideAllFields.add(string);
        }
    }

    boolean getHideAllFields(String string) {
        return this._hideAllFields.contains(string);
    }

    boolean getHideAllFields(DebugDataObjectInfo debugDataObjectInfo) {
        if (!this.isHideAllFieldsEmpty()) {
            DebugClassInfo debugClassInfo = debugDataObjectInfo.getClassInfo();
            while (debugClassInfo != null) {
                String string = debugClassInfo.getName();
                if (this.getHideAllFields(string)) {
                    return true;
                }
                DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces();
                if (debugClassInfoArray != null) {
                    int n = debugClassInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = debugClassInfoArray[n2].getName();
                        if (this.getHideAllFields(string2)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                debugClassInfo = debugClassInfo.getSuperClass(1);
            }
        }
        return false;
    }

    boolean isExpandExpressionsEmpty() {
        return this._expandExpressions.isEmpty();
    }

    TreeMap deepCloneExpandExpressions() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String string : this._expandExpressions.keySet()) {
            String string2 = (String)this._expandExpressions.get(string);
            treeMap.put(string, string2);
        }
        return treeMap;
    }

    void setExpandExpressions(TreeMap treeMap) {
        this._expandExpressions = treeMap;
    }

    String getExpandExpression(String string) {
        return (String)this._expandExpressions.get(string);
    }

    String getExpandExpression(DebugDataObjectInfo debugDataObjectInfo) {
        if (!this.isExpandExpressionsEmpty()) {
            DebugClassInfo debugClassInfo = debugDataObjectInfo.getClassInfo();
            while (debugClassInfo != null) {
                String string = debugClassInfo.getName();
                String string2 = this.getExpandExpression(string);
                if (string2 != null) {
                    return string2;
                }
                DebugClassInfo[] debugClassInfoArray = debugClassInfo.getInterfaces();
                if (debugClassInfoArray != null) {
                    int n = debugClassInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string3 = debugClassInfoArray[n2].getName();
                        string2 = this.getExpandExpression(string3);
                        if (string2 != null) {
                            return string2;
                        }
                        ++n2;
                    }
                }
                debugClassInfo = debugClassInfo.getSuperClass(1);
            }
        }
        return null;
    }

    void setExpandExpression(String string, String string2) {
        if (!this._expandExpressions.containsKey(string)) {
            this._expandExpressions.put(string, ObjectPreferences.fixExpandExpression(string2));
        }
    }

    String[] getExpandExpressionSuggestions(String string) {
        List list = (List)this._expandExpressionSuggestions.get(string);
        if (list != null) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    void addExpandExpressionSuggestion(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this._expandExpressionSuggestions.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this._expandExpressionSuggestions.put(string, arrayList);
        }
        if (!arrayList.contains(string2 = ObjectPreferences.fixExpandExpression(string2))) {
            arrayList.add(string2);
        }
    }

    static String[] tokenizeExpandExpression(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, EXPAND_EXPRESSION_DELIMITERS);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String fixExpandExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, EXPAND_EXPRESSION_DELIMITERS);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            stringBuffer.append(string2);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    void save() {
        try {
            URL uRL = ObjectPreferences.getXMLURL(FILENAME);
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(NAMESPACE_URI);
            Object[] objectArray = new Object[]{this._valueExpressions, this._valueExpressionSuggestions, this._hiddenFields, this._hideAllFields, this._expandExpressions, this._expandExpressionSuggestions};
            object2Dom.toDocument((Object)objectArray, ROOT_TAG, uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void load() {
        try {
            this._valueExpressions.clear();
            this._valueExpressionSuggestions.clear();
            this._hiddenFields.clear();
            this._expandExpressions.clear();
            this._expandExpressionSuggestions.clear();
            URL uRL = ObjectPreferences.getXMLURL(FILENAME);
            Object2Dom object2Dom = Object2Dom.newInstance();
            Object[] objectArray = (Object[])object2Dom.toObject(uRL);
            int n = objectArray.length;
            if (n > 0 && objectArray[0] instanceof TreeMap) {
                this._valueExpressions.putAll((TreeMap)objectArray[0]);
            }
            if (n > 1 && objectArray[1] instanceof TreeMap) {
                this._valueExpressionSuggestions.putAll((TreeMap)objectArray[1]);
            }
            if (n > 2 && objectArray[2] instanceof TreeMap) {
                this._hiddenFields.putAll((TreeMap)objectArray[2]);
            }
            if (n > 3 && objectArray[3] instanceof TreeSet) {
                this._hideAllFields.addAll((TreeSet)objectArray[3]);
            }
            if (n > 4 && objectArray[4] instanceof TreeMap) {
                this._expandExpressions.putAll((TreeMap)objectArray[4]);
            }
            if (n > 5 && objectArray[5] instanceof TreeMap) {
                this._expandExpressionSuggestions.putAll((TreeMap)objectArray[5]);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.loadDataFilters();
            this.loadDataValues();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._expandExpressionSuggestions.isEmpty()) {
            this.setValueExpression("java.util.Collection", "size + \" elements\"");
            this.setExpandExpression("java.util.ArrayList", "toArray()");
            this.setHideAllFields("java.util.ArrayList", true);
            this.setExpandExpression("java.util.EnumSet", "toArray()");
            this.setHideAllFields("java.util.EnumSet", true);
            this.setExpandExpression("java.util.HashSet", "toArray()");
            this.setHideAllFields("java.util.HashSet", true);
            this.setExpandExpression("java.util.LinkedHashSet", "toArray()");
            this.setHideAllFields("java.util.LinkedHashSet", true);
            this.setExpandExpression("java.util.LinkedList", "toArray()");
            this.setHideAllFields("java.util.LinkedList", true);
            this.setExpandExpression("java.util.PriorityQueue", "toArray()");
            this.setHideAllFields("java.util.PriorityQueue", true);
            this.setExpandExpression("java.util.Stack", "toArray()");
            this.setHideAllFields("java.util.Stack", true);
            this.setExpandExpression("java.util.TreeSet", "toArray()");
            this.setHideAllFields("java.util.TreeSet", true);
            this.setExpandExpression("java.util.Vector", "toArray()");
            this.setHideAllFields("java.util.Vector", true);
            this.setValueExpression("java.util.Map", "size + \" mappings\"");
            this.setValueExpression("java.util.Hashtable", "count + \" mappings\"");
            this.setExpandExpression("java.util.EnumMap", "entrySet().toArray()");
            this.setHideAllFields("java.util.EnumMap", true);
            this.setExpandExpression("java.util.HashMap", "entrySet().toArray()");
            this.setHideAllFields("java.util.HashMap", true);
            this.setExpandExpression("java.util.Hashtable", "entrySet().toArray()");
            this.setHideAllFields("java.util.Hashtable", true);
            this.setExpandExpression("java.util.IdentityHashMap", "entrySet().toArray()");
            this.setHideAllFields("java.util.IdentityHashMap", true);
            this.setExpandExpression("java.util.LinkedHashMap", "entrySet().toArray()");
            this.setHideAllFields("java.util.LinkedHashMap", true);
            this.setExpandExpression("java.util.Properties", "entrySet().toArray()");
            this.setHideAllFields("java.util.Properties", true);
            this.setExpandExpression("java.util.TreeMap", "entrySet().toArray()");
            this.setHideAllFields("java.util.TreeMap", true);
            this.setExpandExpression("java.util.WeakHashMap", "entrySet().toArray()");
            this.setHideAllFields("java.util.WeakHashMap", true);
            this.setValueExpression("java.util.Map$Entry", "key + \" -> \" + value");
            this.setExpandExpression("java.util.Map$Entry", "getKey(), getValue()");
            this.setHideAllFields("java.util.Map$Entry", true);
        }
        this.addValueExpressionSuggestion("java.awt.Button", "label");
        this.addValueExpressionSuggestion("java.awt.Checkbox", "label");
        this.addValueExpressionSuggestion("java.awt.Dimension", "width + \" * \" + height");
        this.addValueExpressionSuggestion("java.awt.Dimension", "width + \" X \" + height");
        this.addValueExpressionSuggestion("java.awt.Label", "text");
        this.addValueExpressionSuggestion("java.awt.MenuItem", "label");
        this.addValueExpressionSuggestion("java.awt.Point", "x + \", \" + y");
        this.addValueExpressionSuggestion("java.awt.Rectangle", "x + \", \" + y + \", \" + width + \", \" + height");
        this.addValueExpressionSuggestion("java.awt.TextComponent", "text");
        this.addValueExpressionSuggestion("java.awt.TextField", "text");
        this.addValueExpressionSuggestion("java.io.File", "path");
        this.addValueExpressionSuggestion("java.lang.Boolean", "value");
        this.addValueExpressionSuggestion("java.lang.Byte", "value");
        this.addValueExpressionSuggestion("java.lang.Character", "value");
        this.addValueExpressionSuggestion("java.lang.Double", "value");
        this.addValueExpressionSuggestion("java.lang.Float", "value");
        this.addValueExpressionSuggestion("java.lang.Integer", "value");
        this.addValueExpressionSuggestion("java.lang.Long", "value");
        this.addValueExpressionSuggestion("java.lang.ref.Reference", "referent");
        this.addValueExpressionSuggestion("java.lang.Short", "value");
        this.addValueExpressionSuggestion("java.lang.Thread", "name");
        this.addValueExpressionSuggestion("java.lang.ThreadGroup", "name");
        this.addValueExpressionSuggestion("java.lang.Throwable", "detailMessage");
        this.addValueExpressionSuggestion("java.util.Collection", "size() + \" elements\"");
        this.addValueExpressionSuggestion("java.util.Map", "size() + \" mappings\"");
        this.addValueExpressionSuggestion("java.util.Map$Entry", "key + \" -> \" + value");
        this.addValueExpressionSuggestion("java.util.Map$Entry", "getKey() + \" -> \" + getValue()");
        this.addValueExpressionSuggestion("java.util.Map$Entry", "key");
        this.addValueExpressionSuggestion("java.util.Map$Entry", "getKey()");
        this.addValueExpressionSuggestion("javax.swing.AbstractButton", "text");
        this.addValueExpressionSuggestion("javax.swing.JLabel", "text");
        this.addValueExpressionSuggestion("javax.swing.JTextField", "text");
        this.addValueExpressionSuggestion("javax.xml.namespace.QName", "(prefix != null && prefix.length() > 0) ? prefix + \":\" + localPart : localPart");
        this.addValueExpressionSuggestion("javax.xml.namespace.QName", "\"{\"+namespaceURI+\"}\"+localPart");
        this.addValueExpressionSuggestion("oracle.xml.parser.v2.XMLElement", "data[(int)nodeId + ELEM_QXNAME]");
        this.addExpandExpressionSuggestion("java.util.Collection", "toArray()");
        this.addExpandExpressionSuggestion("java.util.Map", "entrySet().toArray()");
        this.addExpandExpressionSuggestion("java.util.Map$Entry", "key, value");
        this.addExpandExpressionSuggestion("java.util.Map$Entry", "getKey(), getValue()");
    }

    void loadDataFilters() {
        try {
            URL uRL = ObjectPreferences.getXMLURL(DATAFILTERS_FILENAME);
            Object2Dom object2Dom = Object2Dom.newInstance();
            TreeMap treeMap = (TreeMap)object2Dom.toObject(uRL);
            this._hiddenFields.clear();
            this._hiddenFields.putAll(treeMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void loadDataValues() {
        try {
            URL uRL = ObjectPreferences.getXMLURL(DATAVALUES_FILENAME);
            Object2Dom object2Dom = Object2Dom.newInstance();
            TreeMap treeMap = (TreeMap)object2Dom.toObject(uRL);
            this._valueExpressions.clear();
            this._valueExpressions.putAll(treeMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static URL getXMLURL(String string) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(JDebugger.getExtensionID());
        return URLFactory.newURL((URL)uRL, (String)string);
    }
}

