/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.runner.debug.ClassesPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ObjectPreferences;

final class ObjectPreferencesPanel
extends ClassesPanel {
    private final ObjectPreferences objectPreferences;
    private final Map valueExpressions;
    private final List valueExpressionSuggestions;
    private final Map expandExpressions;
    private final List expandExpressionSuggestions;
    private final Set hideAllFields;
    private final Map hiddenFields;
    private final boolean sortFields;
    private final Map declaredFields;
    private final List hiddenFieldsList;
    private final JRadioButton radioValueToString;
    private final JRadioButton radioValueExpression;
    private final DefaultComboBoxModel valueExpressionModel;
    private final JComboBox valueExpressionComboBox;
    private final JTextField valueExpressionComboBoxEditor;
    private final JTextField valueExpressionTextField;
    private final JCheckBox checkExpandExpression;
    private final DefaultComboBoxModel expandExpressionModel;
    private final JComboBox expandExpressionComboBox;
    private final JTextField expandExpressionComboBoxEditor;
    private final JTextField expandExpressionTextField;
    private final JCheckBox checkExpandFields;
    private final JLabel fieldsLabel;
    private final Shuttle shuttle;
    private final JLabel fromLabel;
    private final DefaultListModel fromModel;
    private final JList fromList;
    private final JLabel fromFieldDescriptionLabel;
    private final JLabel toLabel;
    private final DefaultListModel toModel;
    private final JList toList;
    private final JLabel toFieldDescriptionLabel;
    private static final String toStringExpression = "toString()";
    private static final String fieldDescriptionLabelBlank = " ";

    static boolean showObjectPreferencesDialog(DebugClassInfo debugClassInfo, boolean bl) {
        JDebugger jDebugger = JDebugger.getInstance();
        ObjectPreferences objectPreferences = jDebugger.getObjectPreferences();
        TreeMap treeMap = objectPreferences.deepCloneValueExpressions();
        TreeMap treeMap2 = objectPreferences.deepCloneExpandExpressions();
        TreeSet treeSet = objectPreferences.deepCloneHideAllFields();
        TreeMap treeMap3 = objectPreferences.deepCloneHiddenFields();
        boolean bl2 = treeMap3.isEmpty() ^ true;
        ObjectPreferencesPanel objectPreferencesPanel = new ObjectPreferencesPanel(debugClassInfo, objectPreferences, treeMap, treeMap2, treeSet, treeMap3, bl);
        String string = DbgArb.getString(815);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)objectPreferencesPanel, (Component)objectPreferencesPanel.getInitialFocus(), (String)string);
        HelpSystem.getHelpSystem().registerTopic((JComponent)objectPreferencesPanel, "f1_deb_edit_filters_html");
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            DebugClassInfo debugClassInfo2 = objectPreferencesPanel.getCurrentClass();
            if (debugClassInfo2 != null) {
                objectPreferencesPanel.saveBody(debugClassInfo2);
            }
            objectPreferences.setValueExpressions(treeMap);
            objectPreferences.setExpandExpressions(treeMap2);
            objectPreferences.setHideAllFields(treeSet);
            objectPreferences.setHiddenFields(treeMap3);
            boolean bl3 = treeMap3.isEmpty() ^ true;
            if (bl2 != bl3) {
                jDebugger.setUseFilters(bl3);
            } else {
                jDebugger.updateDataWindows();
            }
            return true;
        }
        return false;
    }

    private ObjectPreferencesPanel(DebugClassInfo debugClassInfo, ObjectPreferences objectPreferences, Map map, Map map2, Set set, Map map3, boolean bl) {
        this.objectPreferences = objectPreferences;
        this.valueExpressions = map;
        this.valueExpressionSuggestions = new ArrayList();
        this.expandExpressions = map2;
        this.expandExpressionSuggestions = new ArrayList();
        this.hideAllFields = set;
        this.hiddenFields = map3;
        this.sortFields = bl;
        this.declaredFields = new HashMap();
        this.hiddenFieldsList = new ArrayList();
        this.radioValueToString = new JRadioButton();
        this.radioValueExpression = new JRadioButton();
        this.valueExpressionModel = new DefaultComboBoxModel();
        this.valueExpressionComboBox = new JComboBox(this.valueExpressionModel);
        this.valueExpressionComboBox.setEditable(true);
        this.valueExpressionComboBoxEditor = (JTextField)this.valueExpressionComboBox.getEditor().getEditorComponent();
        this.valueExpressionTextField = new JTextField();
        this.valueExpressionTextField.setVisible(false);
        this.checkExpandExpression = new JCheckBox();
        this.expandExpressionModel = new DefaultComboBoxModel();
        this.expandExpressionComboBox = new JComboBox(this.expandExpressionModel);
        this.expandExpressionComboBox.setEditable(true);
        this.expandExpressionComboBoxEditor = (JTextField)this.expandExpressionComboBox.getEditor().getEditorComponent();
        this.expandExpressionTextField = new JTextField();
        this.expandExpressionTextField.setVisible(false);
        this.checkExpandFields = new JCheckBox();
        this.fieldsLabel = new JLabel(DbgArb.getString(823));
        this.shuttle = new Shuttle();
        this.fromLabel = new JLabel();
        this.fromModel = new DefaultListModel();
        this.fromList = new JList();
        this.toLabel = new JLabel();
        this.toModel = new DefaultListModel();
        this.toList = new JList();
        this.fromFieldDescriptionLabel = new JLabel(fieldDescriptionLabelBlank);
        this.toFieldDescriptionLabel = new JLabel(fieldDescriptionLabelBlank);
        this.createPanel(debugClassInfo);
    }

    protected void setSelectedClass(ComboBoxModel comboBoxModel) {
        int n = comboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            ClassesPanel.ClassComboBoxItem classComboBoxItem = (ClassesPanel.ClassComboBoxItem)comboBoxModel.getElementAt(n2);
            if (classComboBoxItem.isSpecial()) {
                comboBoxModel.setSelectedItem(classComboBoxItem);
                return;
            }
            ++n2;
        }
        super.setSelectedClass(comboBoxModel);
    }

    protected ClassesPanel.ClassComboBoxItem createClassComboBoxItem(DebugClassInfo debugClassInfo, int n) {
        String string = debugClassInfo.getName();
        return new 8(this, this, debugClassInfo, n, string);
    }

    JPanel createBody() {
        JLabel jLabel = new JLabel(DbgArb.getString(816));
        JLabel jLabel2 = new JLabel(DbgArb.getString(817));
        ResourceUtils.resButton((AbstractButton)this.radioValueToString, (String)DbgArb.getString(818));
        ResourceUtils.resButton((AbstractButton)this.radioValueExpression, (String)DbgArb.getString(819));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioValueToString);
        buttonGroup.add(this.radioValueExpression);
        this.valueExpressionComboBoxEditor.getAccessibleContext().setAccessibleName(this.radioValueExpression.getText());
        this.valueExpressionTextField.getAccessibleContext().setAccessibleName(this.radioValueExpression.getText());
        JLabel jLabel3 = new JLabel(DbgArb.getString(820));
        ResourceUtils.resButton((AbstractButton)this.checkExpandExpression, (String)DbgArb.getString(821));
        this.expandExpressionComboBoxEditor.getAccessibleContext().setAccessibleName(this.checkExpandExpression.getText());
        this.expandExpressionTextField.getAccessibleContext().setAccessibleName(this.checkExpandExpression.getText());
        ResourceUtils.resButton((AbstractButton)this.checkExpandFields, (String)DbgArb.getString(822));
        ResourceUtils.resLabel((JLabel)this.fromLabel, (Component)this.fromList, (String)DbgArb.getString(824));
        this.shuttle.add((Component)this.fromLabel, (Object)"FromHeader");
        this.fromList.setModel(this.fromModel);
        ListPicker listPicker = new ListPicker(this.fromList);
        listPicker.setItemsSorted(this.sortFields);
        this.shuttle.setFromPicker((ItemPicker)listPicker);
        this.shuttle.add((Component)this.fromFieldDescriptionLabel, (Object)"FromFooter");
        ResourceUtils.resLabel((JLabel)this.toLabel, (Component)this.toList, (String)DbgArb.getString(825));
        this.shuttle.add((Component)this.toLabel, (Object)"ToHeader");
        this.toList.setModel(this.toModel);
        ListPicker listPicker2 = new ListPicker(this.toList);
        listPicker2.setItemsSorted(this.sortFields);
        this.shuttle.setToPicker((ItemPicker)listPicker2);
        this.shuttle.add((Component)this.toFieldDescriptionLabel, (Object)"ToFooter");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.radioValueToString, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.radioValueExpression, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.valueExpressionComboBox, new GridBagConstraints(1, n, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.valueExpressionTextField, new GridBagConstraints(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.checkExpandExpression, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.expandExpressionComboBox, new GridBagConstraints(1, n, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.expandExpressionTextField, new GridBagConstraints(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.checkExpandFields, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.fieldsLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 30, 0, 0), 0, 0));
        jPanel.add((Component)this.shuttle, new GridBagConstraints(0, n++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
        7 var9_9 = new 7();
        this.radioValueToString.addActionListener(var9_9);
        this.radioValueExpression.addActionListener(var9_9);
        this.valueExpressionComboBox.addActionListener(new 6());
        this.checkExpandExpression.addActionListener(new 5());
        this.expandExpressionComboBox.addActionListener(new 4());
        this.checkExpandFields.addActionListener(new 3());
        2 var10_10 = new 2();
        this.fromList.addFocusListener(var10_10);
        this.toList.addFocusListener(var10_10);
        1 var11_11 = new 1();
        this.fromList.addListSelectionListener(var11_11);
        this.toList.addListSelectionListener(var11_11);
        return jPanel;
    }

    Dimension getAppropriateSize() {
        return new Dimension(565, 400);
    }

    void saveBody(DebugClassInfo debugClassInfo) {
        String string = debugClassInfo.getName();
        if (this.radioValueToString.isSelected()) {
            this.valueExpressions.put(string, toStringExpression);
        } else {
            String string2 = this.valueExpressionTextField.getText();
            if (string2.length() > 0) {
                this.valueExpressions.put(string, string2);
                this.objectPreferences.addValueExpressionSuggestion(string, string2);
            } else {
                this.valueExpressions.remove(string);
            }
        }
        if (this.checkExpandExpression.isSelected()) {
            String string3 = this.expandExpressionTextField.getText();
            if ((string3 = ObjectPreferences.fixExpandExpression(string3)).length() > 0) {
                this.expandExpressions.put(string, string3);
                this.objectPreferences.addExpandExpressionSuggestion(string, string3);
            } else {
                this.expandExpressions.remove(string);
            }
        } else {
            this.expandExpressions.remove(string);
        }
        if (this.checkExpandFields.isSelected()) {
            this.hideAllFields.remove(string);
        } else {
            this.hideAllFields.add(string);
        }
        int n = this.toModel.size();
        if (n > 0) {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)this.toModel.elementAt(n2);
                ++n2;
            }
            this.hiddenFields.put(string, stringArray);
        } else {
            this.hiddenFields.remove(string);
        }
    }

    void clearBody() {
        this.radioValueExpression.setSelected(true);
        this.valueExpressionSuggestions.clear();
        this.valueExpressionSuggestions.add("");
        this.valueExpressionModel.removeAllElements();
        this.valueExpressionModel.addElement("");
        this.valueExpressionModel.setSelectedItem("");
        this.valueExpressionTextField.setText("");
        this.enableValueSection();
        this.checkExpandExpression.setSelected(false);
        this.expandExpressionSuggestions.clear();
        this.expandExpressionSuggestions.add("");
        this.expandExpressionModel.removeAllElements();
        this.expandExpressionModel.addElement("");
        this.expandExpressionModel.setSelectedItem("");
        this.expandExpressionTextField.setText("");
        this.enableExpandSection();
        this.checkExpandFields.setSelected(true);
        this.fromModel.clear();
        this.toModel.clear();
        this.declaredFields.clear();
        this.hiddenFieldsList.clear();
        this.fromFieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        this.toFieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        this.enableHiddenFieldsSection();
    }

    void loadBody(DebugClassInfo debugClassInfo) {
        String string;
        String string2;
        String string3 = debugClassInfo.getName();
        String[] stringArray = this.objectPreferences.getValueExpressionSuggestions(string3);
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.valueExpressionSuggestions.add(stringArray[n2]);
                this.valueExpressionModel.addElement(stringArray[n2]);
                ++n2;
            }
        }
        if ((string2 = (String)this.valueExpressions.get(string3)) != null) {
            if (string2.equals(toStringExpression)) {
                this.radioValueToString.setSelected(true);
            } else {
                if (!this.valueExpressionSuggestions.contains(string2)) {
                    this.valueExpressionSuggestions.add(string2);
                    this.valueExpressionModel.addElement(string2);
                }
                this.valueExpressionModel.setSelectedItem(string2);
            }
        }
        boolean bl = this.valueExpressionSuggestions.size() > 1;
        this.valueExpressionComboBox.setVisible(bl);
        this.valueExpressionTextField.setVisible(bl ^ true);
        this.enableValueSection();
        String[] stringArray2 = this.objectPreferences.getExpandExpressionSuggestions(string3);
        if (stringArray2 != null) {
            int n = stringArray2.length;
            int n3 = 0;
            while (n3 < n) {
                this.expandExpressionSuggestions.add(stringArray2[n3]);
                this.expandExpressionModel.addElement(stringArray2[n3]);
                ++n3;
            }
        }
        if ((string = (String)this.expandExpressions.get(string3)) != null && string.length() > 0) {
            this.checkExpandExpression.setSelected(true);
            if (!this.expandExpressionSuggestions.contains(string)) {
                this.expandExpressionSuggestions.add(string);
                this.expandExpressionModel.addElement(string);
            }
            this.expandExpressionModel.setSelectedItem(string);
        } else {
            this.checkExpandExpression.setSelected(false);
        }
        boolean bl2 = this.expandExpressionSuggestions.size() > 1;
        this.expandExpressionComboBox.setVisible(bl2);
        this.expandExpressionTextField.setVisible(bl2 ^ true);
        this.enableExpandSection();
        boolean bl3 = this.hideAllFields.contains(string3) ^ true;
        this.checkExpandFields.setSelected(bl3);
        String[] stringArray3 = (String[])this.hiddenFields.get(string3);
        if (stringArray3 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = stringArray3.length;
            int n4 = 0;
            while (n4 < n) {
                String string4 = stringArray3[n4];
                this.hiddenFieldsList.add(string4);
                arrayList.add(string4);
                ++n4;
            }
            if (this.sortFields) {
                Collections.sort(arrayList);
            }
            int n5 = arrayList.size();
            int n6 = 0;
            while (n6 < n5) {
                this.toModel.addElement((String)arrayList.get(n6));
                ++n6;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DebugFieldInfo[] debugFieldInfoArray = debugClassInfo.getFields(0, false, true);
        int n = debugFieldInfoArray.length;
        int n7 = 0;
        while (n7 < n) {
            DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n7];
            String string5 = debugFieldInfo.getName();
            this.declaredFields.put(string5, debugFieldInfo);
            if (!this.hiddenFieldsList.contains(string5)) {
                arrayList.add(string5);
            }
            ++n7;
        }
        if (this.sortFields) {
            Collections.sort(arrayList);
        }
        int n8 = arrayList.size();
        int n9 = 0;
        while (n9 < n8) {
            this.fromModel.addElement((String)arrayList.get(n9));
            ++n9;
        }
    }

    private void enableValueSection() {
        boolean bl = this.radioValueExpression.isSelected();
        this.valueExpressionComboBox.setEnabled(bl);
        this.valueExpressionTextField.setEnabled(bl);
    }

    private void enableExpandSection() {
        boolean bl = this.checkExpandExpression.isSelected();
        this.expandExpressionComboBox.setEnabled(bl);
        this.expandExpressionTextField.setEnabled(bl);
    }

    private void enableHiddenFieldsSection() {
        boolean bl = this.checkExpandFields.isSelected();
        this.fieldsLabel.setEnabled(bl);
        this.shuttle.setEnabled(bl);
        this.fromLabel.setEnabled(bl);
        this.fromList.setEnabled(bl);
        this.toLabel.setEnabled(bl);
        this.toList.setEnabled(bl);
        this.fromFieldDescriptionLabel.setEnabled(bl);
        this.toFieldDescriptionLabel.setEnabled(bl);
    }

    private void updateFieldDescriptionLabel(JList jList) {
        JLabel jLabel = jList == this.fromList ? this.fromFieldDescriptionLabel : this.toFieldDescriptionLabel;
        String string = (String)jList.getSelectedValue();
        DebugFieldInfo debugFieldInfo = (DebugFieldInfo)this.declaredFields.get(string);
        if (debugFieldInfo != null) {
            jLabel.setText(debugFieldInfo.getClassInfo().getName() + fieldDescriptionLabelBlank + string);
        } else {
            jLabel.setText(fieldDescriptionLabelBlank);
        }
    }

    static Map ra$valueExpressions(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.valueExpressions;
    }

    static Map ra$expandExpressions(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.expandExpressions;
    }

    static Set ra$hideAllFields(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.hideAllFields;
    }

    static Map ra$hiddenFields(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.hiddenFields;
    }

    static void mav$enableValueSection(ObjectPreferencesPanel objectPreferencesPanel) {
        objectPreferencesPanel.enableValueSection();
    }

    static JComboBox ra$valueExpressionComboBox(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.valueExpressionComboBox;
    }

    static JTextField ra$valueExpressionComboBoxEditor(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.valueExpressionComboBoxEditor;
    }

    static JTextField ra$valueExpressionTextField(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.valueExpressionTextField;
    }

    static void mav$enableExpandSection(ObjectPreferencesPanel objectPreferencesPanel) {
        objectPreferencesPanel.enableExpandSection();
    }

    static JComboBox ra$expandExpressionComboBox(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.expandExpressionComboBox;
    }

    static JTextField ra$expandExpressionComboBoxEditor(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.expandExpressionComboBoxEditor;
    }

    static JTextField ra$expandExpressionTextField(ObjectPreferencesPanel objectPreferencesPanel) {
        return objectPreferencesPanel.expandExpressionTextField;
    }

    static void mav$enableHiddenFieldsSection(ObjectPreferencesPanel objectPreferencesPanel) {
        objectPreferencesPanel.enableHiddenFieldsSection();
    }

    static void mav$updateFieldDescriptionLabel(ObjectPreferencesPanel objectPreferencesPanel, JList jList) {
        objectPreferencesPanel.updateFieldDescriptionLabel(jList);
    }

    final class 8
    extends ClassesPanel.ClassComboBoxItem {
        private final /* synthetic */ String v$className;
        final /* synthetic */ ObjectPreferencesPanel this$0;

        protected boolean isSpecial() {
            if (ObjectPreferencesPanel.ra$valueExpressions(this.this$0).containsKey(this.v$className)) {
                return true;
            }
            if (ObjectPreferencesPanel.ra$expandExpressions(this.this$0).containsKey(this.v$className)) {
                return true;
            }
            if (ObjectPreferencesPanel.ra$hideAllFields(this.this$0).contains(this.v$className)) {
                return true;
            }
            return ObjectPreferencesPanel.ra$hiddenFields(this.this$0).containsKey(this.v$className);
        }

        public 8(ObjectPreferencesPanel objectPreferencesPanel, ClassesPanel classesPanel, DebugClassInfo debugClassInfo, int n, String string) {
            this.v$className = string;
            this.this$0 = objectPreferencesPanel;
            super(debugClassInfo, n);
        }
    }

    final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectPreferencesPanel.mav$enableValueSection(ObjectPreferencesPanel.this);
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ObjectPreferencesPanel.ra$valueExpressionComboBox(ObjectPreferencesPanel.this).getSelectedItem();
            ObjectPreferencesPanel.ra$valueExpressionComboBoxEditor(ObjectPreferencesPanel.this).setText(string);
            ObjectPreferencesPanel.ra$valueExpressionTextField(ObjectPreferencesPanel.this).setText(string);
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectPreferencesPanel.mav$enableExpandSection(ObjectPreferencesPanel.this);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ObjectPreferencesPanel.ra$expandExpressionComboBox(ObjectPreferencesPanel.this).getSelectedItem();
            ObjectPreferencesPanel.ra$expandExpressionComboBoxEditor(ObjectPreferencesPanel.this).setText(string);
            ObjectPreferencesPanel.ra$expandExpressionTextField(ObjectPreferencesPanel.this).setText(string);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectPreferencesPanel.mav$enableHiddenFieldsSection(ObjectPreferencesPanel.this);
        }
    }

    final class 2
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            ObjectPreferencesPanel.mav$updateFieldDescriptionLabel(ObjectPreferencesPanel.this, (JList)focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ObjectPreferencesPanel.mav$updateFieldDescriptionLabel(ObjectPreferencesPanel.this, (JList)listSelectionEvent.getSource());
        }
    }
}

